import{s as ti,o as ni,n as K}from"../chunks/scheduler.18a86fab.js";import{S as oi,i as ri,g as l,s as r,r as g,m as v,H as x,A as ii,h as m,f as t,c as i,j as $,u,x as d,n as w,B as T,k as q,y as e,a as o,v as f,d as _,t as y,w as b}from"../chunks/index.98837b22.js";import{T as _a}from"../chunks/Tip.77304350.js";import{D as P}from"../chunks/Docstring.6758ea23.js";import{C as Js}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ze}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as F}from"../chunks/Heading.7e7e0c5b.js";import{E as li}from"../chunks/getInferenceSnippets.de10bc7d.js";function mi(R){let n,k="Examples:",p,h,M;return h=new Js({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlZm9ybWVyQ29uZmlnJTJDJTIwUmVmb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBSZWZvcm1lciUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwUmVmb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBSZWZvcm1lciUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReformerConfig, ReformerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Reformer configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ReformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Reformer model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=l("p"),n.textContent=k,p=r(),g(h.$$.fragment)},l(c){n=m(c,"P",{"data-svelte-h":!0}),d(n)!=="svelte-kvfsh7"&&(n.textContent=k),p=i(c),u(h.$$.fragment,c)},m(c,z){o(c,n,z),o(c,p,z),f(h,c,z),M=!0},p:K,i(c){M||(_(h.$$.fragment,c),M=!0)},o(c){y(h.$$.fragment,c),M=!1},d(c){c&&(t(n),t(p)),b(h,c)}}}function pi(R){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=k},l(p){n=m(p,"P",{"data-svelte-h":!0}),d(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,h){o(p,n,h)},p:K,d(p){p&&t(n)}}}function ci(R){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=k},l(p){n=m(p,"P",{"data-svelte-h":!0}),d(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,h){o(p,n,h)},p:K,d(p){p&&t(n)}}}function di(R){let n,k="Example:",p,h,M;return h=new Js({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyTW9kZWxXaXRoTE1IZWFkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVmb3JtZXItY3JpbWUtYW5kLXB1bmlzaG1lbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWZvcm1lck1vZGVsV2l0aExNSGVhZC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVmb3JtZXItY3JpbWUtYW5kLXB1bmlzaG1lbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerModelWithLMHead

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerModelWithLMHead.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=l("p"),n.textContent=k,p=r(),g(h.$$.fragment)},l(c){n=m(c,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=k),p=i(c),u(h.$$.fragment,c)},m(c,z){o(c,n,z),o(c,p,z),f(h,c,z),M=!0},p:K,i(c){M||(_(h.$$.fragment,c),M=!0)},o(c){y(h.$$.fragment,c),M=!1},d(c){c&&(t(n),t(p)),b(h,c)}}}function hi(R){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=k},l(p){n=m(p,"P",{"data-svelte-h":!0}),d(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,h){o(p,n,h)},p:K,d(p){p&&t(n)}}}function gi(R){let n,k="Example:",p,h,M;return h=new Js({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyRm9yTWFza2VkTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGdGlueS1yYW5kb20tcmVmb3JtZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWZvcm1lckZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGdGlueS1yYW5kb20tcmVmb3JtZXIlMjIpJTBBJTBBJTIzJTIwYWRkJTIwbWFza190b2tlbiUwQXRva2VuaXplci5hZGRfc3BlY2lhbF90b2tlbnMoJTdCJTIybWFza190b2tlbiUyMiUzQSUyMCUyMiU1Qk1BU0slNUQlMjIlN0QpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMHJlc2l6ZSUyMG1vZGVsJ3MlMjBlbWJlZGRpbmclMjBtYXRyaXglMEFtb2RlbC5yZXNpemVfdG9rZW5fZW1iZWRkaW5ncyhuZXdfbnVtX3Rva2VucyUzRG1vZGVsLmNvbmZpZy52b2NhYl9zaXplJTIwJTJCJTIwMSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMHJldHJpZXZlJTIwaW5kZXglMjBvZiUyMCU1Qk1BU0slNUQlMEFtYXNrX3Rva2VuX2luZGV4JTIwJTNEJTIwKGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCklNUIwJTVELm5vbnplcm8oYXNfdHVwbGUlM0RUcnVlKSU1QjAlNUQlMEElMEFwcmVkaWN0ZWRfdG9rZW5faWQlMjAlM0QlMjBsb2dpdHMlNUIwJTJDJTIwbWFza190b2tlbl9pbmRleCU1RC5hcmdtYXgoYXhpcyUzRC0xKSUwQXByZWRpY3RlZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUocHJlZGljdGVkX3Rva2VuX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-reformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForMaskedLM.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-reformer&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add mask_token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens({<span class="hljs-string">&quot;mask_token&quot;</span>: <span class="hljs-string">&quot;[MASK]&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># resize model&#x27;s embedding matrix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(new_num_tokens=model.config.vocab_size + <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token = tokenizer.decode(predicted_token_id)`,wrap:!1}}),{c(){n=l("p"),n.textContent=k,p=r(),g(h.$$.fragment)},l(c){n=m(c,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=k),p=i(c),u(h.$$.fragment,c)},m(c,z){o(c,n,z),o(c,p,z),f(h,c,z),M=!0},p:K,i(c){M||(_(h.$$.fragment,c),M=!0)},o(c){y(h.$$.fragment,c),M=!1},d(c){c&&(t(n),t(p)),b(h,c)}}}function ui(R){let n,k;return n=new Js({props:{code:"bGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjMlMjBtYXNrJTIwbGFiZWxzJTIwb2YlMjBub24tJTVCTUFTSyU1RCUyMHRva2VucyUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLndoZXJlKCUwQSUyMCUyMCUyMCUyMGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUyQyUyMGxhYmVscyU1QiUzQSUyQyUyMCUzQSUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1Qi0xJTVEJTVEJTJDJTIwLTEwMCUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMHJvdW5kKG91dHB1dHMubG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-[MASK] tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(
<span class="hljs-meta">... </span>    inputs.input_ids == tokenizer.mask_token_id, labels[:, : inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]], -<span class="hljs-number">100</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = <span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(p){u(n.$$.fragment,p)},m(p,h){f(n,p,h),k=!0},p:K,i(p){k||(_(n.$$.fragment,p),k=!0)},o(p){y(n.$$.fragment,p),k=!1},d(p){b(n,p)}}}function fi(R){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=k},l(p){n=m(p,"P",{"data-svelte-h":!0}),d(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,h){o(p,n,h)},p:K,d(p){p&&t(n)}}}function _i(R){let n,k="Example of single-label classification:",p,h,M;return h=new Js({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlZm9ybWVyRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlZm9ybWVyLWNyaW1lLWFuZC1wdW5pc2htZW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbGFiZWwlMjAlM0QlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>label = model.config.id2label[predicted_class_id]`,wrap:!1}}),{c(){n=l("p"),n.textContent=k,p=r(),g(h.$$.fragment)},l(c){n=m(c,"P",{"data-svelte-h":!0}),d(n)!=="svelte-ykxpe4"&&(n.textContent=k),p=i(c),u(h.$$.fragment,c)},m(c,z){o(c,n,z),o(c,p,z),f(h,c,z),M=!0},p:K,i(c){M||(_(h.$$.fragment,c),M=!0)},o(c){y(h.$$.fragment,c),M=!1},d(c){c&&(t(n),t(p)),b(h,c)}}}function yi(R){let n,k;return n=new Js({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwUmVmb3JtZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTBBKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigxKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>, num_labels=num_labels
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){g(n.$$.fragment)},l(p){u(n.$$.fragment,p)},m(p,h){f(n,p,h),k=!0},p:K,i(p){k||(_(n.$$.fragment,p),k=!0)},o(p){y(n.$$.fragment,p),k=!1},d(p){b(n,p)}}}function bi(R){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=l("p"),n.innerHTML=k},l(p){n=m(p,"P",{"data-svelte-h":!0}),d(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,h){o(p,n,h)},p:K,d(p){p&&t(n)}}}function vi(R){let n,k="Example:",p,h,M;return h=new Js({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBSZWZvcm1lckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWZvcm1lci1jcmltZS1hbmQtcHVuaXNobWVudCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlZm9ybWVyRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlZm9ybWVyLWNyaW1lLWFuZC1wdW5pc2htZW50JTIyKSUwQSUwQXF1ZXN0aW9uJTJDJTIwdGV4dCUyMCUzRCUyMCUyMldobyUyMHdhcyUyMEppbSUyMEhlbnNvbiUzRiUyMiUyQyUyMCUyMkppbSUyMEhlbnNvbiUyMHdhcyUyMGElMjBuaWNlJTIwcHVwcGV0JTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHF1ZXN0aW9uJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cy5hcmdtYXgoKSUwQWFuc3dlcl9lbmRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMuYXJnbWF4KCklMEElMEFwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBdG9rZW5pemVyLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMEElMjMlMjB0YXJnZXQlMjBpcyUyMCUyMm5pY2UlMjBwdXBwZXQlMjIlMEF0YXJnZXRfc3RhcnRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTQlNUQpJTBBdGFyZ2V0X2VuZF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNSU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBzdGFydF9wb3NpdGlvbnMlM0R0YXJnZXRfc3RhcnRfaW5kZXglMkMlMjBlbmRfcG9zaXRpb25zJTNEdGFyZ2V0X2VuZF9pbmRleCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ReformerForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ReformerForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/reformer-crime-and-punishment&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=l("p"),n.textContent=k,p=r(),g(h.$$.fragment)},l(c){n=m(c,"P",{"data-svelte-h":!0}),d(n)!=="svelte-11lpom8"&&(n.textContent=k),p=i(c),u(h.$$.fragment,c)},m(c,z){o(c,n,z),o(c,p,z),f(h,c,z),M=!0},p:K,i(c){M||(_(h.$$.fragment,c),M=!0)},o(c){y(h.$$.fragment,c),M=!1},d(c){c&&(t(n),t(p)),b(h,c)}}}function wi(R){let n,k,p,h,M,c,z,Co='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ya,qs,ba,Ws,jo='The Reformer model was proposed in the paper <a href="https://arxiv.org/abs/2001.04451.pdf" rel="nofollow">Reformer: The Efficient Transformer</a> by Nikita Kitaev, Łukasz Kaiser, Anselm Levskaya.',va,Us,Lo="The abstract from the paper is the following:",wa,Fs,Jo=`<em>Large Transformer models routinely achieve state-of-the-art results on a number of tasks but training these models can
be prohibitively costly, especially on long sequences. We introduce two techniques to improve the efficiency of
Transformers. For one, we replace dot-product attention by one that uses locality-sensitive hashing, changing its
complexity from O(L^2) to O(Llog(L)), where L is the length of the sequence. Furthermore, we use reversible residual
layers instead of the standard residuals, which allows storing activations only once in the training process instead of
N times, where N is the number of layers. The resulting model, the Reformer, performs on par with Transformer models
while being much more memory-efficient and much faster on long sequences.</em>`,ka,Hs,qo=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The Authors’ code can be
found <a href="https://github.com/google/trax/tree/master/trax/models/reformer" rel="nofollow">here</a>.`,Ma,Zs,xa,Ss,Wo='<li>Reformer does <strong>not</strong> work with <em>torch.nn.DataParallel</em> due to a bug in PyTorch, see <a href="https://github.com/pytorch/pytorch/issues/36035" rel="nofollow">issue #36035</a>.</li> <li>Use Axial position encoding (see below for more details). It’s a mechanism to avoid having a huge positional encoding matrix (when the sequence length is very big) by factorizing it into smaller matrices.</li> <li>Replace traditional attention by LSH (local-sensitive hashing) attention (see below for more details). It’s a technique to avoid computing the full product query-key in the attention layers.</li> <li>Avoid storing the intermediate results of each layer by using reversible transformer layers to obtain them during the backward pass (subtracting the residuals from the input of the next layer gives them back) or recomputing them for results inside a given layer (less efficient than storing them but saves memory).</li> <li>Compute the feedforward operations by chunks and not on the whole batch.</li>',Ta,Is,za,C,un,us,Uo="trax library",fn,$a,Rr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi></mrow><annotation encoding="application/x-tex">d</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span></span></span></span>',Ra,$e,Fo="config.hidden_size",_n,Ca,Cr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">i, \\ldots, n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',ja,La,jr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ja,Re,Ho="config.max_embedding_size",yn,qa,Lr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub><mo>=</mo><msup><mn>2</mn><mn>19</mn></msup><mo>≈</mo><mn>0.5</mn><mi>M</mi></mrow><annotation encoding="application/x-tex">n_s = 2^{19} \\approx 0.5M</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">19</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord">0.5</span><span class="mord mathnormal" style="margin-right:0.10903em;">M</span></span></span></span>',Wa,Ce,Zo="config.hidden_size",bn,Ua,Jr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi><mo>=</mo><msup><mn>2</mn><mn>10</mn></msup><mo>≈</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex">d = 2^{10} \\approx 1000</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">10</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Fa,Ha,qr='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>d</mi><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mi>s</mi></msub><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;">[</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">d</span><span class="mclose delimcenter" style="top:0em;">]</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;">[</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;">]</span></span></span></span></span></span>',Za,hs,vn,Sa,Wr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex">X_{i,j}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Ia,Na,Ur='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mn>1</mn></msubsup><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msup><mi>d</mi><mn>1</mn></msup><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X^{1}_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d^1\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s^1\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2472em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span></span></span></span></span>',Xa,Ns,wn,Va,Fr='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mn>2</mn></msubsup><mo separator="true">,</mo><mtext> with </mtext><mi>i</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo fence="true">]</mo></mrow><mtext> and </mtext><mi>j</mi><mo>∈</mo><mrow><mo fence="true">[</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo fence="true">]</mo></mrow></mrow><annotation encoding="application/x-tex">X^{2}_{i,j}, \\text{ with } i \\in \\left[1,\\ldots, d^2\\right] \\text{ and } j \\in \\left[1,\\ldots, n_s^2\\right]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2472em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">2</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2141em;vertical-align:-0.35em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size1">[</span></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size1">]</span></span></span></span></span></span></span>',Ea,Xs,kn,Pa,Hr='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>d</mi><mo>=</mo><msup><mi>d</mi><mn>1</mn></msup><mo>+</mo><msup><mi>d</mi><mn>2</mn></msup><mtext> and </mtext><msub><mi>n</mi><mi>s</mi></msub><mo>=</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo>×</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex">d = d^1 + d^2 \\text{ and } n_s = n_s^1 \\times n_s^2 .</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9474em;vertical-align:-0.0833em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0141em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> and </span></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1111em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1111em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',Qa,Vs,Mn,Aa,Zr=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow></msub><mo>=</mo><mrow><mo fence="true">{</mo><mtable rowspacing="0.36em" columnalign="left left" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo separator="true">,</mo><mi>k</mi></mrow><mn>1</mn></msubsup><mo separator="true">,</mo></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mtext>if  </mtext><mi>i</mi><mo>&lt;</mo><msup><mi>d</mi><mn>1</mn></msup><mtext> with </mtext><mi>k</mi><mo>=</mo><mi>j</mi><mspace></mspace><mspace width="0.6667em"/><mrow><mi mathvariant="normal">m</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">d</mi></mrow><mtext> </mtext><mtext> </mtext><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><msubsup><mi>X</mi><mrow><mi>i</mi><mo>−</mo><msup><mi>d</mi><mn>1</mn></msup><mo separator="true">,</mo><mi>l</mi></mrow><mn>2</mn></msubsup><mo separator="true">,</mo></mrow></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mtext>if </mtext><mi>i</mi><mo>≥</mo><msup><mi>d</mi><mn>1</mn></msup><mtext> with </mtext><mi>l</mi><mo>=</mo><mo stretchy="false">⌊</mo><mfrac><mi>j</mi><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup></mfrac><mo stretchy="false">⌋</mo></mrow></mstyle></mtd></mtr></mtable></mrow></mrow><annotation encoding="application/x-tex">X_{i,j} = \\begin{cases}
X^{1}_{i, k}, &amp; \\text{if }\\ i &lt; d^1 \\text{ with } k = j \\mod n_s^1 \\\\
X^{2}_{i - d^1, l}, &amp; \\text{if } i \\ge d^1 \\text{ with } l = \\lfloor\\frac{j}{n_s^1}\\rfloor
\\end{cases}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3em;vertical-align:-1.25em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mtable"><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7466em;"><span style="top:-3.7466em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span><span class="mpunct">,</span></span></span><span style="top:-2.3066em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.3806em;margin-left:-0.0785em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mtight"><span class="mord mathnormal mtight">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7463em;"><span style="top:-2.786em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">2</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4555em;"><span></span></span></span></span></span></span><span class="mpunct">,</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2466em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:1em;"></span><span class="col-align-l"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7466em;"><span style="top:-3.7466em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">if </span></span><span class="mspace"> </span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&lt;</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace allowbreak"></span><span class="mspace" style="margin-right:0.6667em;"></span><span class="mord"><span class="mord"><span class="mord mathrm">mod</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.3066em;"><span class="pstrut" style="height:3.008em;"></span><span class="mord"><span class="mord text"><span class="mord">if </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≥</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mopen">⌊</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9078em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight"><span class="mord mathnormal mtight">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7463em;"><span style="top:-2.214em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-2.786em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.286em;"><span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.5452em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mclose">⌋</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2466em;"><span></span></span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span></span>`,Ba,W,xn,Ga,Sr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>j</mi></msub><mo>∈</mo><msup><mi mathvariant="double-struck">R</mi><mi>d</mi></msup></mrow><annotation encoding="application/x-tex">x_j \\in \\mathbb{R}^{d}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord mathbb">R</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">d</span></span></span></span></span></span></span></span></span></span></span></span>',Oa,Da,Ir='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>x</mi><mrow><mi>k</mi><mo separator="true">,</mo><mi>l</mi></mrow><mn>1</mn></msubsup><mo>+</mo><msubsup><mi>x</mi><mrow><mi>l</mi><mo separator="true">,</mo><mi>k</mi></mrow><mn>2</mn></msubsup></mrow><annotation encoding="application/x-tex">x^1_{k, l} + x^2_{l, k}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2333em;vertical-align:-0.4192em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2333em;vertical-align:-0.4192em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4192em;"><span></span></span></span></span></span></span></span></span></span>',Ya,je,So="config.max_embedding_size",Tn,Ka,Nr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex">j</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',st,et,Xr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi><mtext> and </mtext><mi>l</mi></mrow><annotation encoding="application/x-tex">k \\text{ and } l</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mord text"><span class="mord"> and </span></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span></span></span></span>',at,tt,Vr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex">x_j</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7167em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',nt,ot,ns,zn,rt,Er='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>d</mi><mn>1</mn></msup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo>=</mo><msup><mn>2</mn><mn>9</mn></msup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo>=</mo><msup><mn>2</mn><mn>10</mn></msup></mrow><annotation encoding="application/x-tex">d^1 = 2^9, d^2 = 2^9, n_s^1 = 2^9, n_s^2 = 2^{10}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0085em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0611em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0611em;vertical-align:-0.247em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">9</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">10</span></span></span></span></span></span></span></span></span></span></span></span>',it,lt,Pr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mn>2</mn><mn>18</mn></msup><mo>+</mo><msup><mn>2</mn><mn>19</mn></msup><mo>≈</mo><mn>780000</mn></mrow><annotation encoding="application/x-tex">2^{18} + 2^{19} \\approx 780 000</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8974em;vertical-align:-0.0833em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">18</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord">2</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">19</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">780000</span></span></span></span>',mt,pt,L,$n,Le,Io="config.axial_pos_embds_dim",Rn,ct,Qr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msup><mi>d</mi><mn>1</mn></msup><mo separator="true">,</mo><msup><mi>d</mi><mn>2</mn></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(d^1, d^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0641em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',dt,Je,No="config.hidden_size",Cn,qe,Xo="config.axial_pos_shape",jn,ht,Ar='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msubsup><mi>n</mi><mi>s</mi><mn>1</mn></msubsup><mo separator="true">,</mo><msubsup><mi>n</mi><mi>s</mi><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(n_s^1, n_s^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0641em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',gt,We,Vo="config.max_embedding_size",Ln,Ue,Eo=`sequence
length`,Jn,Fe,Po="input_ids",qn,ut,Es,ft,Ps,Qo=`In Locality sensitive hashing (LSH) self attention the key and query projection weights are tied. Therefore, the key
query embedding vectors are also tied. LSH self attention uses the locality sensitive hashing mechanism proposed in
<a href="https://arxiv.org/abs/1509.02897" rel="nofollow">Practical and Optimal LSH for Angular Distance</a> to assign each of the tied key
query embedding vectors to one of <code>config.num_buckets</code> possible buckets. The premise is that the more “similar”
key query embedding vectors (in terms of <em>cosine similarity</em>) are to each other, the more likely they are assigned to
the same bucket.`,_t,Qs,Ao=`The accuracy of the LSH mechanism can be improved by increasing <code>config.num_hashes</code> or directly the argument
<code>num_hashes</code> of the forward function so that the output of the LSH self attention better approximates the output
of the “normal” full self attention. The buckets are then sorted and chunked into query key embedding vector chunks
each of length <code>config.lsh_chunk_length</code>. For each chunk, the query embedding vectors attend to its key vectors
(which are tied to themselves) and to the key embedding vectors of <code>config.lsh_num_chunks_before</code> previous
neighboring chunks and <code>config.lsh_num_chunks_after</code> following neighboring chunks.`,yt,As,Bo='For more information, see the <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">original Paper</a> or this great <a href="https://www.pragmatic.ml/reformer-deep-dive/" rel="nofollow">blog post</a>.',bt,X,Wn,He,Go="config.num_buckets",Un,vt,Br=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(n_{\\text{buckets}}^1,
n_{\\text{buckets}}^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,wt,kt,Gr=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>n</mi><mtext>buckets</mtext></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(1,\\ldots,
n_{\\text{buckets}})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,Mt,xt,Or=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo>−</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mn>1</mn><mo>−</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>1</mn></msubsup><mo>−</mo><msubsup><mi>n</mi><mtext>buckets</mtext><mn>2</mn></msubsup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">(1-1,\\ldots, n_{\\text{buckets}}^1-1, \\ldots,
1-n_{\\text{buckets}}^2, \\ldots, n_{\\text{buckets}}^1-n_{\\text{buckets}}^2)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0972em;vertical-align:-0.2831em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-2.4169em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">buckets</span></span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2831em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>`,Tt,zt,Bs,Oo=`When training a model from scratch, it is recommended to leave <code>config.num_buckets=None</code>, so that depending on the
sequence length a good value for <code>num_buckets</code> is calculated on the fly. This value will then automatically be
saved in the config and should be reused for inference.`,$t,G,Fn,Rt,Dr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times n_s)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Ct,jt,Yr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times \\log(n_s))</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">))</span></span></span></span>',Lt,Jt,Kr='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',qt,Wt,Gs,Ut,Os,Do=`Local self attention is essentially a “normal” self attention layer with key, query and value projections, but is
chunked so that in each chunk of length <code>config.local_chunk_length</code> the query embedding vectors only attends to
the key embedding vectors in its chunk and to the key embedding vectors of <code>config.local_num_chunks_before</code>
previous neighboring chunks and <code>config.local_num_chunks_after</code> following neighboring chunks.`,Ft,O,Hn,Ht,si='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times n_s)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Zt,St,ei='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="script">O</mi><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo>×</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>n</mi><mi>s</mi></msub><mo stretchy="false">)</mo><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathcal{O}(n_s \\times \\log(n_s))</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathcal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">))</span></span></span></span>',It,Nt,ai='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>n</mi><mi>s</mi></msub></mrow><annotation encoding="application/x-tex">n_s</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">n</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">s</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Xt,Vt,Ds,Et,Ys,Yo=`During training, we must ensure that the sequence length is set to a value that can be divided by the least common
multiple of <code>config.lsh_chunk_length</code> and <code>config.local_chunk_length</code> and that the parameters of the Axial
Positional Encodings are correctly set as described above. Reformer is very memory efficient so that the model can
easily be trained on sequences as long as 64000 tokens.`,Pt,Ks,Ko='For training, the <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> should be used as follows:',Qt,se,At,ee,Bt,ae,sr='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',Gt,te,Ot,Q,ne,Zn,Ze,er=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>. It is used to instantiate a
Reformer model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the ReFormer
<a href="https://huggingface.co/google/reformer-crime-and-punishment" rel="nofollow">google/reformer-crime-and-punishment</a> architecture.`,Sn,Se,ar=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,In,fs,Dt,oe,Yt,A,re,Nn,Ie,tr='Construct a Reformer tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> .',Xn,Ne,nr=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Vn,Xe,ie,Kt,le,sn,ss,me,En,Ve,or=`Construct a “fast” Reformer tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=unigram#models" rel="nofollow">Unigram</a>.`,Pn,Ee,rr=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,en,pe,an,H,ce,Qn,Pe,ir="The bare Reformer Model outputting raw hidden-states without any specific head on top.",An,Qe,lr=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bn,Ae,mr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gn,os,de,On,Be,pr='The <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> forward method, overrides the <code>__call__</code> special method.',Dn,_s,tn,he,nn,Z,ge,Yn,Ge,cr="Reformer Model with a <code>language modeling</code> head on top.",Kn,Oe,dr=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,De,hr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,eo,D,ue,ao,Ye,gr='The <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> forward method, overrides the <code>__call__</code> special method.',to,ys,no,bs,on,fe,rn,S,_e,oo,Ke,ur="The Reformer Model with a <code>language modeling</code> head on top.”",ro,sa,fr=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,io,ea,_r=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,lo,V,ye,mo,aa,yr='The <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',po,vs,co,ws,ho,ks,ln,be,mn,I,ve,go,ta,br=`Reformer Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,uo,na,vr=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fo,oa,wr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_o,E,we,yo,ra,kr='The <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',bo,Ms,vo,xs,wo,Ts,pn,ke,cn,N,Me,ko,ia,Mr=`The Reformer transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layer on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Mo,la,xr=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xo,ma,Tr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,To,Y,xe,zo,pa,zr='The <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',$o,zs,Ro,$s,dn,Te,hn,fa,gn;return M=new F({props:{title:"Reformer",local:"reformer",headingTag:"h1"}}),qs=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Zs=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Is=new F({props:{title:"Axial Positional Encodings",local:"axial-positional-encodings",headingTag:"h3"}}),Es=new F({props:{title:"LSH Self Attention",local:"lsh-self-attention",headingTag:"h3"}}),Gs=new F({props:{title:"Local Self Attention",local:"local-self-attention",headingTag:"h3"}}),Ds=new F({props:{title:"Training",local:"training",headingTag:"h3"}}),se=new Js({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZSglMjJUaGlzJTIwaXMlMjBhJTIwc2VudGVuY2UlMjBmcm9tJTIwdGhlJTIwdHJhaW5pbmclMjBkYXRhJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb3NzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEaW5wdXRfaWRzKSU1QjAlNUQ=",highlighted:`input_ids = tokenizer.encode(<span class="hljs-string">&quot;This is a sentence from the training data&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
loss = model(input_ids, labels=input_ids)[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),te=new F({props:{title:"ReformerConfig",local:"transformers.ReformerConfig",headingTag:"h2"}}),ne=new P({props:{name:"class transformers.ReformerConfig",anchor:"transformers.ReformerConfig",parameters:[{name:"attention_head_size",val:" = 64"},{name:"attn_layers",val:" = ['local', 'lsh', 'local', 'lsh', 'local', 'lsh']"},{name:"axial_norm_std",val:" = 1.0"},{name:"axial_pos_embds",val:" = True"},{name:"axial_pos_shape",val:" = [64, 64]"},{name:"axial_pos_embds_dim",val:" = [64, 192]"},{name:"chunk_size_lm_head",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"feed_forward_size",val:" = 512"},{name:"hash_seed",val:" = None"},{name:"hidden_act",val:" = 'relu'"},{name:"hidden_dropout_prob",val:" = 0.05"},{name:"hidden_size",val:" = 256"},{name:"initializer_range",val:" = 0.02"},{name:"is_decoder",val:" = False"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"local_num_chunks_before",val:" = 1"},{name:"local_num_chunks_after",val:" = 0"},{name:"local_attention_probs_dropout_prob",val:" = 0.05"},{name:"local_attn_chunk_length",val:" = 64"},{name:"lsh_attn_chunk_length",val:" = 64"},{name:"lsh_attention_probs_dropout_prob",val:" = 0.0"},{name:"lsh_num_chunks_before",val:" = 1"},{name:"lsh_num_chunks_after",val:" = 0"},{name:"max_position_embeddings",val:" = 4096"},{name:"num_attention_heads",val:" = 12"},{name:"num_buckets",val:" = None"},{name:"num_hashes",val:" = 1"},{name:"pad_token_id",val:" = 0"},{name:"vocab_size",val:" = 320"},{name:"tie_word_embeddings",val:" = False"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerConfig.attention_head_size",description:`<strong>attention_head_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality of the projected key, query and value vectors`,name:"attention_head_size"},{anchor:"transformers.ReformerConfig.attn_layers",description:`<strong>attn_layers</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&quot;local&quot;, &quot;lsh&quot;, &quot;local&quot;, &quot;lsh&quot;, &quot;local&quot;, &quot;lsh&quot;]</code>) &#x2014;
List of attention layer types in ascending order. It can be chosen between a LSHSelfAttention layer
(<code>&quot;lsh&quot;</code>) and a LocalSelfAttention layer (<code>&quot;local&quot;</code>).</p>
<p>For more information on LSHSelfAttention layer, see <a href="reformer#lsh-self-attention">LSH Self Attention</a>. For
more information on LocalSelfAttention layer, see <a href="reformer#local-self-attention">Local Self Attention</a>.`,name:"attn_layers"},{anchor:"transformers.ReformerConfig.axial_pos_embds",description:`<strong>axial_pos_embds</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use axial position embeddings. For more information on how axial position embeddings
work, see <a href="reformer#axial-positional-encodings">Axial Position Encodings</a>.`,name:"axial_pos_embds"},{anchor:"transformers.ReformerConfig.axial_norm_std",description:`<strong>axial_norm_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The standard deviation of the normal_initializer for initializing the weight matrices of the axial
positional encodings.`,name:"axial_norm_std"},{anchor:"transformers.ReformerConfig.axial_pos_shape",description:`<strong>axial_pos_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[64, 64]</code>) &#x2014;
The position dims of the axial position encodings. During training, the product of the position dims has to
be equal to the sequence length.</p>
<p>For more information on how axial position embeddings work, see <a href="reformer#axial-positional-encodings">Axial Position
Encodings</a>.`,name:"axial_pos_shape"},{anchor:"transformers.ReformerConfig.axial_pos_embds_dim",description:`<strong>axial_pos_embds_dim</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[64, 192]</code>) &#x2014;
The embedding dims of the axial position encodings. The sum of the embedding dims has to be equal to the
hidden size.</p>
<p>For more information on how axial position embeddings work, see <a href="reformer#axial-positional-encodings">Axial Position
Encodings</a>.`,name:"axial_pos_embds_dim"},{anchor:"transformers.ReformerConfig.chunk_size_lm_head",description:`<strong>chunk_size_lm_head</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The chunk size of the final language model feed forward head layer. A chunk size of 0 means that the feed
forward layer is not chunked. A chunk size of n means that the feed forward layer processes n &lt;
sequence_length embeddings at a time.</p>
<p>For more information on feed forward chunking, see <a href="../glossary#feed-forward-chunking">How does Feed Forward Chunking
work?</a>.`,name:"chunk_size_lm_head"},{anchor:"transformers.ReformerConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The token id for the end-of-sentence token.`,name:"eos_token_id"},{anchor:"transformers.ReformerConfig.feed_forward_size",description:`<strong>feed_forward_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the feed_forward layer in the residual attention block.`,name:"feed_forward_size"},{anchor:"transformers.ReformerConfig.hash_seed",description:`<strong>hash_seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed that can be used to make local sensitive hashing in <code>LSHSelfAttention</code> deterministic. This should only
be set for testing purposed. For evaluation and training purposes <code>hash_seed</code> should be left as <code>None</code> to
ensure fully random rotations in local sensitive hashing scheme.`,name:"hash_seed"},{anchor:"transformers.ReformerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the feed forward layer in the residual attention
block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.ReformerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.ReformerConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output hidden states of the residual attention blocks.`,name:"hidden_size"},{anchor:"transformers.ReformerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ReformerConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use a causal mask in addition to the <code>attention_mask</code> passed to <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>. When
using the Reformer for causal language modeling, this argument should be set to <code>True</code>.`,name:"is_decoder"},{anchor:"transformers.ReformerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ReformerConfig.local_chunk_length",description:`<strong>local_chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Length of chunk which attends to itself in <code>LocalSelfAttention</code>. Chunking reduces memory complexity from
sequence length x sequence length (self attention) to chunk length x chunk length x sequence length / chunk
length (chunked self attention).`,name:"local_chunk_length"},{anchor:"transformers.ReformerConfig.local_num_chunks_before",description:`<strong>local_num_chunks_before</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of previous neighbouring chunks to attend to in <code>LocalSelfAttention</code> layer to itself.`,name:"local_num_chunks_before"},{anchor:"transformers.ReformerConfig.local_num_chunks_after",description:`<strong>local_num_chunks_after</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of following neighbouring chunks to attend to in <code>LocalSelfAttention</code> layer in addition to itself.`,name:"local_num_chunks_after"},{anchor:"transformers.ReformerConfig.local_attention_probs_dropout_prob",description:`<strong>local_attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities in <code>LocalSelfAttention</code>.`,name:"local_attention_probs_dropout_prob"},{anchor:"transformers.ReformerConfig.lsh_attn_chunk_length",description:`<strong>lsh_attn_chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Length of chunk which attends to itself in <code>LSHSelfAttention</code>. Chunking reduces memory complexity from
sequence length x sequence length (self attention) to chunk length x chunk length x sequence length / chunk
length (chunked self attention).`,name:"lsh_attn_chunk_length"},{anchor:"transformers.ReformerConfig.lsh_num_chunks_before",description:`<strong>lsh_num_chunks_before</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of previous neighbouring chunks to attend to in <code>LSHSelfAttention</code> layer to itself.`,name:"lsh_num_chunks_before"},{anchor:"transformers.ReformerConfig.lsh_num_chunks_after",description:`<strong>lsh_num_chunks_after</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of following neighbouring chunks to attend to in <code>LSHSelfAttention</code> layer to itself.`,name:"lsh_num_chunks_after"},{anchor:"transformers.ReformerConfig.lsh_attention_probs_dropout_prob",description:`<strong>lsh_attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities in <code>LSHSelfAttention</code>.`,name:"lsh_attention_probs_dropout_prob"},{anchor:"transformers.ReformerConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.ReformerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ReformerConfig.num_buckets",description:`<strong>num_buckets</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
Number of buckets, the key query vectors can be &#x201C;hashed into&#x201D; using the locality sensitive hashing scheme.
Each query key vector is hashed into a hash in <code>1, ..., num_buckets</code>. The number of buckets can also be
factorized into a list for improved memory complexity. In this case, each query key vector is hashed into a
hash in <code>1-1, 1-2, ..., num_buckets[0]-1, ..., num_buckets[0]-num_buckets[1]</code> if <code>num_buckets</code> is
factorized into two factors. The number of buckets (or the product the factors) should approximately equal
sequence length / lsh_chunk_length. If <code>num_buckets</code> not set, a good value is calculated on the fly.`,name:"num_buckets"},{anchor:"transformers.ReformerConfig.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of hashing rounds (e.g., number of random rotations) in Local Sensitive Hashing scheme. The higher
<code>num_hashes</code>, the more accurate the <code>LSHSelfAttention</code> becomes, but also the more memory and time intensive
the hashing becomes.`,name:"num_hashes"},{anchor:"transformers.ReformerConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The token id for the padding token.`,name:"pad_token_id"},{anchor:"transformers.ReformerConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 320) &#x2014;\\
Vocabulary size of the Reformer model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>.`,name:"vocab_size"},{anchor:"transformers.ReformerConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie input and output embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.ReformerConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.ReformerConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/configuration_reformer.py#L25"}}),fs=new ze({props:{anchor:"transformers.ReformerConfig.example",$$slots:{default:[mi]},$$scope:{ctx:R}}}),oe=new F({props:{title:"ReformerTokenizer",local:"transformers.ReformerTokenizer",headingTag:"h2"}}),re=new P({props:{name:"class transformers.ReformerTokenizer",anchor:"transformers.ReformerTokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"additional_special_tokens",val:" = []"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.ReformerTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.ReformerTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.ReformerTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.ReformerTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/tokenization_reformer.py#L36"}}),ie=new P({props:{name:"save_vocabulary",anchor:"transformers.ReformerTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/tokenization_reformer.py#L158"}}),le=new F({props:{title:"ReformerTokenizerFast",local:"transformers.ReformerTokenizerFast",headingTag:"h2"}}),me=new P({props:{name:"class transformers.ReformerTokenizerFast",anchor:"transformers.ReformerTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"additional_special_tokens",val:" = []"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.ReformerTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.ReformerTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.ReformerTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.ReformerTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/tokenization_reformer_fast.py#L39"}}),pe=new F({props:{title:"ReformerModel",local:"transformers.ReformerModel",headingTag:"h2"}}),ce=new P({props:{name:"class transformers.ReformerModel",anchor:"transformers.ReformerModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L1884"}}),de=new P({props:{name:"forward",anchor:"transformers.ReformerModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_hashes",val:": typing.Optional[int] = None"},{name:"past_buckets_states",val:": typing.Optional[typing.List[typing.Tuple[torch.Tensor]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ReformerModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerModel.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerModel.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple[torch.Tensor]]</code>, torch.FloatTensor)]<code>, *optional*) -- List of </code>Tuple(torch.LongTensor, torch.FloatTensor<code>of length</code>config.n_layers<code>, with the first element being the previous *buckets* of shape </code>(batch_size, num_heads, num_hashes, sequence_length)<code>) and the second being the previous *hidden_states* of shape </code>(batch_size, sequence_length, hidden_size)\`).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L1913",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.reformer.modeling_reformer.ReformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_predict, hidden_size)</code>) — Sequence of hidden-states at the last layer of the model.</p>
<p><code>num_predict</code> corresponds to <code>target_mapping.shape[1]</code>. If <code>target_mapping</code> is <code>None</code>, then <code>num_predict</code>
corresponds to <code>sequence_length</code>.</p>
</li>
<li>
<p><strong>past_buckets_states</strong> (<code>List[Tuple(torch.LongTensor, torch.FloatTensor)]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>Tuple(torch.LongTensor, torch.FloatTensor</code> of length <code>config.n_layers</code>, with the first element
being the previous <em>buckets</em> of shape <code>(batch_size, num_heads, num_hashes, sequence_length)</code>) and the
second being the previous <em>hidden_states</em> of shape <code>(batch_size, sequence_length, hidden_size)</code>).</p>
<p>Contains precomputed buckets and hidden-states that can be used (see <code>past_buckets_states</code> input) to speed
up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings and one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.reformer.modeling_reformer.ReformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_s=new _a({props:{$$slots:{default:[pi]},$$scope:{ctx:R}}}),he=new F({props:{title:"ReformerModelWithLMHead",local:"transformers.ReformerModelWithLMHead",headingTag:"h2"}}),ge=new P({props:{name:"class transformers.ReformerModelWithLMHead",anchor:"transformers.ReformerModelWithLMHead",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerModelWithLMHead.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2114"}}),ue=new P({props:{name:"forward",anchor:"transformers.ReformerModelWithLMHead.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_hashes",val:": typing.Optional[int] = None"},{name:"past_buckets_states",val:": typing.Optional[typing.List[typing.Tuple[torch.Tensor]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ReformerModelWithLMHead.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerModelWithLMHead.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerModelWithLMHead.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerModelWithLMHead.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerModelWithLMHead.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerModelWithLMHead.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerModelWithLMHead.forward.past_buckets_states",description:`<strong>past_buckets_states</strong> (<code>List[Tuple[torch.Tensor]]</code>, torch.FloatTensor)]<code>, *optional*) -- List of </code>Tuple(torch.LongTensor, torch.FloatTensor<code>of length</code>config.n_layers<code>, with the first element being the previous *buckets* of shape </code>(batch_size, num_heads, num_hashes, sequence_length)<code>) and the second being the previous *hidden_states* of shape </code>(batch_size, sequence_length, hidden_size)\`).</p>
<p>Contains precomputed hidden-states and buckets (only relevant for LSH Self-Attention). Can be used to speed
up sequential decoding.`,name:"past_buckets_states"},{anchor:"transformers.ReformerModelWithLMHead.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ReformerModelWithLMHead.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerModelWithLMHead.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerModelWithLMHead.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ReformerModelWithLMHead.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ys=new _a({props:{$$slots:{default:[ci]},$$scope:{ctx:R}}}),bs=new ze({props:{anchor:"transformers.ReformerModelWithLMHead.forward.example",$$slots:{default:[di]},$$scope:{ctx:R}}}),fe=new F({props:{title:"ReformerForMaskedLM",local:"transformers.ReformerForMaskedLM",headingTag:"h2"}}),_e=new P({props:{name:"class transformers.ReformerForMaskedLM",anchor:"transformers.ReformerForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2264"}}),ye=new P({props:{name:"forward",anchor:"transformers.ReformerForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_hashes",val:": typing.Optional[int] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ReformerForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForMaskedLM.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This example uses a false checkpoint since we don&#x2019;t have any available pretrained model for the masked language
modeling task with the Reformer architecture.</p>

					</div>`,name:"labels"},{anchor:"transformers.ReformerForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),vs=new _a({props:{$$slots:{default:[hi]},$$scope:{ctx:R}}}),ws=new ze({props:{anchor:"transformers.ReformerForMaskedLM.forward.example",$$slots:{default:[gi]},$$scope:{ctx:R}}}),ks=new ze({props:{anchor:"transformers.ReformerForMaskedLM.forward.example-2",$$slots:{default:[ui]},$$scope:{ctx:R}}}),be=new F({props:{title:"ReformerForSequenceClassification",local:"transformers.ReformerForSequenceClassification",headingTag:"h2"}}),ve=new P({props:{name:"class transformers.ReformerForSequenceClassification",anchor:"transformers.ReformerForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2400"}}),we=new P({props:{name:"forward",anchor:"transformers.ReformerForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_hashes",val:": typing.Optional[int] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ReformerForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForSequenceClassification.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.ReformerForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2420",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ms=new _a({props:{$$slots:{default:[fi]},$$scope:{ctx:R}}}),xs=new ze({props:{anchor:"transformers.ReformerForSequenceClassification.forward.example",$$slots:{default:[_i]},$$scope:{ctx:R}}}),Ts=new ze({props:{anchor:"transformers.ReformerForSequenceClassification.forward.example-2",$$slots:{default:[yi]},$$scope:{ctx:R}}}),ke=new F({props:{title:"ReformerForQuestionAnswering",local:"transformers.ReformerForQuestionAnswering",headingTag:"h2"}}),Me=new P({props:{name:"class transformers.ReformerForQuestionAnswering",anchor:"transformers.ReformerForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ReformerForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2557"}}),xe=new P({props:{name:"forward",anchor:"transformers.ReformerForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"num_hashes",val:": typing.Optional[int] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ReformerForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. During training the input_ids sequence_length has to be
a multiple of the relevant model&#x2019;s chunk lengths (lsh&#x2019;s, local&#x2019;s or both). During evaluation, the indices
are automatically padded to be a multiple of the chunk length.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ReformerForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ReformerForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ReformerForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ReformerForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ReformerForQuestionAnswering.forward.num_hashes",description:`<strong>num_hashes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of hashing rounds that should be performed during bucketing. Setting this argument overwrites
the default defined in <code>config.num_hashes</code>.</p>
<p>For more information, see <code>num_hashes</code> in <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a>.`,name:"num_hashes"},{anchor:"transformers.ReformerForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ReformerForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.ReformerForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ReformerForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ReformerForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/reformer/modeling_reformer.py#L2570",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig"
>ReformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),zs=new _a({props:{$$slots:{default:[bi]},$$scope:{ctx:R}}}),$s=new ze({props:{anchor:"transformers.ReformerForQuestionAnswering.forward.example",$$slots:{default:[vi]},$$scope:{ctx:R}}}),Te=new li({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/reformer.md"}}),{c(){n=l("meta"),k=r(),p=l("p"),h=r(),g(M.$$.fragment),c=r(),z=l("div"),z.innerHTML=Co,ya=r(),g(qs.$$.fragment),ba=r(),Ws=l("p"),Ws.innerHTML=jo,va=r(),Us=l("p"),Us.textContent=Lo,wa=r(),Fs=l("p"),Fs.innerHTML=Jo,ka=r(),Hs=l("p"),Hs.innerHTML=qo,Ma=r(),g(Zs.$$.fragment),xa=r(),Ss=l("ul"),Ss.innerHTML=Wo,Ta=r(),g(Is.$$.fragment),za=r(),C=l("p"),un=v("Axial Positional Encodings were first implemented in Google’s "),us=l("a"),us.textContent=Uo,fn=v(`
and developed by the authors of this model’s paper. In models that are treating very long input sequences, the
conventional position id encodings store an embeddings vector of size`),$a=new x(!1),Ra=v(" being the "),$e=l("code"),$e.textContent=Fo,_n=v(` for
every position`),Ca=new x(!1),ja=v(", with"),La=new x(!1),Ja=v(" being "),Re=l("code"),Re.textContent=Ho,yn=v(`. This means that having
a sequence length of`),qa=new x(!1),Wa=v(" and a "),Ce=l("code"),Ce.textContent=Zo,bn=v(" of"),Ua=new x(!1),Fa=v(`
would result in a position encoding matrix:
`),Ha=new x(!1),Za=r(),hs=l("p"),vn=v("which alone has over 500M parameters to store. Axial positional encodings factorize"),Sa=new x(!1),Ia=v(` into two matrices:
`),Na=new x(!1),Xa=r(),Ns=l("p"),wn=v(`and
`),Va=new x(!1),Ea=r(),Xs=l("p"),kn=v(`with:
`),Pa=new x(!1),Qa=r(),Vs=l("p"),Mn=v(`Therefore the following holds:
`),Aa=new x(!1),Ba=r(),W=l("p"),xn=v("Intuitively, this means that a position embedding vector"),Ga=new x(!1),Oa=v(` is now the composition of two
factorized embedding vectors:`),Da=new x(!1),Ya=v(", where as the "),je=l("code"),je.textContent=So,Tn=v(" dimension"),Ka=new x(!1),st=v(" is factorized into"),et=new x(!1),at=v(". This design ensures that each position embedding vector"),tt=new x(!1),nt=v(" is unique."),ot=r(),ns=l("p"),zn=v("Using the above example again, axial position encoding with"),rt=new x(!1),it=v(`
can drastically reduced the number of parameters from 500 000 000 to`),lt=new x(!1),mt=v(" parameters, this means 85% less memory usage."),pt=r(),L=l("p"),$n=v("In practice, the parameter "),Le=l("code"),Le.textContent=Io,Rn=v(" is set to a tuple"),ct=new x(!1),dt=v(` which sum has to be
equal to `),Je=l("code"),Je.textContent=No,Cn=v(" and "),qe=l("code"),qe.textContent=Xo,jn=v(" is set to a tuple"),ht=new x(!1),gt=v(` which
product has to be equal to `),We=l("code"),We.textContent=Vo,Ln=v(", which during training has to be equal to the "),Ue=l("em"),Ue.textContent=Eo,Jn=v(" of the "),Fe=l("code"),Fe.textContent=Po,qn=v("."),ut=r(),g(Es.$$.fragment),ft=r(),Ps=l("p"),Ps.innerHTML=Qo,_t=r(),Qs=l("p"),Qs.innerHTML=Ao,yt=r(),As=l("p"),As.innerHTML=Bo,bt=r(),X=l("p"),Wn=v("Note that "),He=l("code"),He.textContent=Go,Un=v(" can also be factorized into a list"),vt=new x(!1),wt=v(". This way instead of assigning the query key embedding vectors to one of"),kt=new x(!1),Mt=v(" they are assigned to one of"),xt=new x(!1),Tt=v(`. This is crucial for very long sequences to
save memory.`),zt=r(),Bs=l("p"),Bs.innerHTML=Oo,$t=r(),G=l("p"),Fn=v("Using LSH self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Rt=new x(!1),Ct=v(" to"),jt=new x(!1),Lt=v(`, which usually represents the memory
and time bottleneck in a transformer model, with`),Jt=new x(!1),qt=v(" being the sequence length."),Wt=r(),g(Gs.$$.fragment),Ut=r(),Os=l("p"),Os.innerHTML=Do,Ft=r(),O=l("p"),Hn=v("Using Local self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Ht=new x(!1),Zt=v(" to"),St=new x(!1),It=v(`, which usually represents the memory
and time bottleneck in a transformer model, with`),Nt=new x(!1),Xt=v(" being the sequence length."),Vt=r(),g(Ds.$$.fragment),Et=r(),Ys=l("p"),Ys.innerHTML=Yo,Pt=r(),Ks=l("p"),Ks.innerHTML=Ko,Qt=r(),g(se.$$.fragment),At=r(),g(ee.$$.fragment),Bt=r(),ae=l("ul"),ae.innerHTML=sr,Gt=r(),g(te.$$.fragment),Ot=r(),Q=l("div"),g(ne.$$.fragment),Zn=r(),Ze=l("p"),Ze.innerHTML=er,Sn=r(),Se=l("p"),Se.innerHTML=ar,In=r(),g(fs.$$.fragment),Dt=r(),g(oe.$$.fragment),Yt=r(),A=l("div"),g(re.$$.fragment),Nn=r(),Ie=l("p"),Ie.innerHTML=tr,Xn=r(),Ne=l("p"),Ne.innerHTML=nr,Vn=r(),Xe=l("div"),g(ie.$$.fragment),Kt=r(),g(le.$$.fragment),sn=r(),ss=l("div"),g(me.$$.fragment),En=r(),Ve=l("p"),Ve.innerHTML=or,Pn=r(),Ee=l("p"),Ee.innerHTML=rr,en=r(),g(pe.$$.fragment),an=r(),H=l("div"),g(ce.$$.fragment),Qn=r(),Pe=l("p"),Pe.textContent=ir,An=r(),Qe=l("p"),Qe.innerHTML=lr,Bn=r(),Ae=l("p"),Ae.innerHTML=mr,Gn=r(),os=l("div"),g(de.$$.fragment),On=r(),Be=l("p"),Be.innerHTML=pr,Dn=r(),g(_s.$$.fragment),tn=r(),g(he.$$.fragment),nn=r(),Z=l("div"),g(ge.$$.fragment),Yn=r(),Ge=l("p"),Ge.innerHTML=cr,Kn=r(),Oe=l("p"),Oe.innerHTML=dr,so=r(),De=l("p"),De.innerHTML=hr,eo=r(),D=l("div"),g(ue.$$.fragment),ao=r(),Ye=l("p"),Ye.innerHTML=gr,to=r(),g(ys.$$.fragment),no=r(),g(bs.$$.fragment),on=r(),g(fe.$$.fragment),rn=r(),S=l("div"),g(_e.$$.fragment),oo=r(),Ke=l("p"),Ke.innerHTML=ur,ro=r(),sa=l("p"),sa.innerHTML=fr,io=r(),ea=l("p"),ea.innerHTML=_r,lo=r(),V=l("div"),g(ye.$$.fragment),mo=r(),aa=l("p"),aa.innerHTML=yr,po=r(),g(vs.$$.fragment),co=r(),g(ws.$$.fragment),ho=r(),g(ks.$$.fragment),ln=r(),g(be.$$.fragment),mn=r(),I=l("div"),g(ve.$$.fragment),go=r(),ta=l("p"),ta.textContent=br,uo=r(),na=l("p"),na.innerHTML=vr,fo=r(),oa=l("p"),oa.innerHTML=wr,_o=r(),E=l("div"),g(we.$$.fragment),yo=r(),ra=l("p"),ra.innerHTML=kr,bo=r(),g(Ms.$$.fragment),vo=r(),g(xs.$$.fragment),wo=r(),g(Ts.$$.fragment),pn=r(),g(ke.$$.fragment),cn=r(),N=l("div"),g(Me.$$.fragment),ko=r(),ia=l("p"),ia.innerHTML=Mr,Mo=r(),la=l("p"),la.innerHTML=xr,xo=r(),ma=l("p"),ma.innerHTML=Tr,To=r(),Y=l("div"),g(xe.$$.fragment),zo=r(),pa=l("p"),pa.innerHTML=zr,$o=r(),g(zs.$$.fragment),Ro=r(),g($s.$$.fragment),dn=r(),g(Te.$$.fragment),hn=r(),fa=l("p"),this.h()},l(s){const a=ii("svelte-u9bgzb",document.head);n=m(a,"META",{name:!0,content:!0}),a.forEach(t),k=i(s),p=m(s,"P",{}),$(p).forEach(t),h=i(s),u(M.$$.fragment,s),c=i(s),z=m(s,"DIV",{class:!0,"data-svelte-h":!0}),d(z)!=="svelte-13t8s2t"&&(z.innerHTML=Co),ya=i(s),u(qs.$$.fragment,s),ba=i(s),Ws=m(s,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-j0navk"&&(Ws.innerHTML=jo),va=i(s),Us=m(s,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-vfdo9a"&&(Us.textContent=Lo),wa=i(s),Fs=m(s,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1o1aozf"&&(Fs.innerHTML=Jo),ka=i(s),Hs=m(s,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-1vxy8gz"&&(Hs.innerHTML=qo),Ma=i(s),u(Zs.$$.fragment,s),xa=i(s),Ss=m(s,"UL",{"data-svelte-h":!0}),d(Ss)!=="svelte-ri2u9g"&&(Ss.innerHTML=Wo),Ta=i(s),u(Is.$$.fragment,s),za=i(s),C=m(s,"P",{});var j=$(C);un=w(j,"Axial Positional Encodings were first implemented in Google’s "),us=m(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),d(us)!=="svelte-djxu9"&&(us.textContent=Uo),fn=w(j,`
and developed by the authors of this model’s paper. In models that are treating very long input sequences, the
conventional position id encodings store an embeddings vector of size`),$a=T(j,!1),Ra=w(j," being the "),$e=m(j,"CODE",{"data-svelte-h":!0}),d($e)!=="svelte-6l7gp8"&&($e.textContent=Fo),_n=w(j,` for
every position`),Ca=T(j,!1),ja=w(j,", with"),La=T(j,!1),Ja=w(j," being "),Re=m(j,"CODE",{"data-svelte-h":!0}),d(Re)!=="svelte-1vzjei2"&&(Re.textContent=Ho),yn=w(j,`. This means that having
a sequence length of`),qa=T(j,!1),Wa=w(j," and a "),Ce=m(j,"CODE",{"data-svelte-h":!0}),d(Ce)!=="svelte-6l7gp8"&&(Ce.textContent=Zo),bn=w(j," of"),Ua=T(j,!1),Fa=w(j,`
would result in a position encoding matrix:
`),Ha=T(j,!1),j.forEach(t),Za=i(s),hs=m(s,"P",{});var Rs=$(hs);vn=w(Rs,"which alone has over 500M parameters to store. Axial positional encodings factorize"),Sa=T(Rs,!1),Ia=w(Rs,` into two matrices:
`),Na=T(Rs,!1),Rs.forEach(t),Xa=i(s),Ns=m(s,"P",{});var ca=$(Ns);wn=w(ca,`and
`),Va=T(ca,!1),ca.forEach(t),Ea=i(s),Xs=m(s,"P",{});var da=$(Xs);kn=w(da,`with:
`),Pa=T(da,!1),da.forEach(t),Qa=i(s),Vs=m(s,"P",{});var ha=$(Vs);Mn=w(ha,`Therefore the following holds:
`),Aa=T(ha,!1),ha.forEach(t),Ba=i(s),W=m(s,"P",{});var U=$(W);xn=w(U,"Intuitively, this means that a position embedding vector"),Ga=T(U,!1),Oa=w(U,` is now the composition of two
factorized embedding vectors:`),Da=T(U,!1),Ya=w(U,", where as the "),je=m(U,"CODE",{"data-svelte-h":!0}),d(je)!=="svelte-1vzjei2"&&(je.textContent=So),Tn=w(U," dimension"),Ka=T(U,!1),st=w(U," is factorized into"),et=T(U,!1),at=w(U,". This design ensures that each position embedding vector"),tt=T(U,!1),nt=w(U," is unique."),U.forEach(t),ot=i(s),ns=m(s,"P",{});var gs=$(ns);zn=w(gs,"Using the above example again, axial position encoding with"),rt=T(gs,!1),it=w(gs,`
can drastically reduced the number of parameters from 500 000 000 to`),lt=T(gs,!1),mt=w(gs," parameters, this means 85% less memory usage."),gs.forEach(t),pt=i(s),L=m(s,"P",{});var J=$(L);$n=w(J,"In practice, the parameter "),Le=m(J,"CODE",{"data-svelte-h":!0}),d(Le)!=="svelte-bgblb7"&&(Le.textContent=Io),Rn=w(J," is set to a tuple"),ct=T(J,!1),dt=w(J,` which sum has to be
equal to `),Je=m(J,"CODE",{"data-svelte-h":!0}),d(Je)!=="svelte-6l7gp8"&&(Je.textContent=No),Cn=w(J," and "),qe=m(J,"CODE",{"data-svelte-h":!0}),d(qe)!=="svelte-1k6g78u"&&(qe.textContent=Xo),jn=w(J," is set to a tuple"),ht=T(J,!1),gt=w(J,` which
product has to be equal to `),We=m(J,"CODE",{"data-svelte-h":!0}),d(We)!=="svelte-1vzjei2"&&(We.textContent=Vo),Ln=w(J,", which during training has to be equal to the "),Ue=m(J,"EM",{"data-svelte-h":!0}),d(Ue)!=="svelte-16lxu1p"&&(Ue.textContent=Eo),Jn=w(J," of the "),Fe=m(J,"CODE",{"data-svelte-h":!0}),d(Fe)!=="svelte-4gs31l"&&(Fe.textContent=Po),qn=w(J,"."),J.forEach(t),ut=i(s),u(Es.$$.fragment,s),ft=i(s),Ps=m(s,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-xd6oue"&&(Ps.innerHTML=Qo),_t=i(s),Qs=m(s,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-aoz16s"&&(Qs.innerHTML=Ao),yt=i(s),As=m(s,"P",{"data-svelte-h":!0}),d(As)!=="svelte-uzsb76"&&(As.innerHTML=Bo),bt=i(s),X=m(s,"P",{});var B=$(X);Wn=w(B,"Note that "),He=m(B,"CODE",{"data-svelte-h":!0}),d(He)!=="svelte-l93flo"&&(He.textContent=Go),Un=w(B," can also be factorized into a list"),vt=T(B,!1),wt=w(B,". This way instead of assigning the query key embedding vectors to one of"),kt=T(B,!1),Mt=w(B," they are assigned to one of"),xt=T(B,!1),Tt=w(B,`. This is crucial for very long sequences to
save memory.`),B.forEach(t),zt=i(s),Bs=m(s,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-1bjm2ay"&&(Bs.innerHTML=Oo),$t=i(s),G=m(s,"P",{});var es=$(G);Fn=w(es,"Using LSH self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Rt=T(es,!1),Ct=w(es," to"),jt=T(es,!1),Lt=w(es,`, which usually represents the memory
and time bottleneck in a transformer model, with`),Jt=T(es,!1),qt=w(es," being the sequence length."),es.forEach(t),Wt=i(s),u(Gs.$$.fragment,s),Ut=i(s),Os=m(s,"P",{"data-svelte-h":!0}),d(Os)!=="svelte-1nbjwv1"&&(Os.innerHTML=Do),Ft=i(s),O=m(s,"P",{});var as=$(O);Hn=w(as,"Using Local self attention, the memory and time complexity of the query-key matmul operation can be reduced from"),Ht=T(as,!1),Zt=w(as," to"),St=T(as,!1),It=w(as,`, which usually represents the memory
and time bottleneck in a transformer model, with`),Nt=T(as,!1),Xt=w(as," being the sequence length."),as.forEach(t),Vt=i(s),u(Ds.$$.fragment,s),Et=i(s),Ys=m(s,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1p0w2ej"&&(Ys.innerHTML=Yo),Pt=i(s),Ks=m(s,"P",{"data-svelte-h":!0}),d(Ks)!=="svelte-tjoyem"&&(Ks.innerHTML=Ko),Qt=i(s),u(se.$$.fragment,s),At=i(s),u(ee.$$.fragment,s),Bt=i(s),ae=m(s,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-1vlk5zq"&&(ae.innerHTML=sr),Gt=i(s),u(te.$$.fragment,s),Ot=i(s),Q=m(s,"DIV",{class:!0});var ts=$(Q);u(ne.$$.fragment,ts),Zn=i(ts),Ze=m(ts,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-s82gpp"&&(Ze.innerHTML=er),Sn=i(ts),Se=m(ts,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-o55m63"&&(Se.innerHTML=ar),In=i(ts),u(fs.$$.fragment,ts),ts.forEach(t),Dt=i(s),u(oe.$$.fragment,s),Yt=i(s),A=m(s,"DIV",{class:!0});var Cs=$(A);u(re.$$.fragment,Cs),Nn=i(Cs),Ie=m(Cs,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jlmve2"&&(Ie.innerHTML=tr),Xn=i(Cs),Ne=m(Cs,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1c3t5ty"&&(Ne.innerHTML=nr),Vn=i(Cs),Xe=m(Cs,"DIV",{class:!0});var $r=$(Xe);u(ie.$$.fragment,$r),$r.forEach(t),Cs.forEach(t),Kt=i(s),u(le.$$.fragment,s),sn=i(s),ss=m(s,"DIV",{class:!0});var ga=$(ss);u(me.$$.fragment,ga),En=i(ga),Ve=m(ga,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-qjebx3"&&(Ve.innerHTML=or),Pn=i(ga),Ee=m(ga,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-fh0aq"&&(Ee.innerHTML=rr),ga.forEach(t),en=i(s),u(pe.$$.fragment,s),an=i(s),H=m(s,"DIV",{class:!0});var rs=$(H);u(ce.$$.fragment,rs),Qn=i(rs),Pe=m(rs,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1ndz2hc"&&(Pe.textContent=ir),An=i(rs),Qe=m(rs,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=lr),Bn=i(rs),Ae=m(rs,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=mr),Gn=i(rs),os=m(rs,"DIV",{class:!0});var ua=$(os);u(de.$$.fragment,ua),On=i(ua),Be=m(ua,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-8bg4gr"&&(Be.innerHTML=pr),Dn=i(ua),u(_s.$$.fragment,ua),ua.forEach(t),rs.forEach(t),tn=i(s),u(he.$$.fragment,s),nn=i(s),Z=m(s,"DIV",{class:!0});var is=$(Z);u(ge.$$.fragment,is),Yn=i(is),Ge=m(is,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-jukcqm"&&(Ge.innerHTML=cr),Kn=i(is),Oe=m(is,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-6pahdo"&&(Oe.innerHTML=dr),so=i(is),De=m(is,"P",{"data-svelte-h":!0}),d(De)!=="svelte-hswkmf"&&(De.innerHTML=hr),eo=i(is),D=m(is,"DIV",{class:!0});var js=$(D);u(ue.$$.fragment,js),ao=i(js),Ye=m(js,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-141l0x3"&&(Ye.innerHTML=gr),to=i(js),u(ys.$$.fragment,js),no=i(js),u(bs.$$.fragment,js),js.forEach(t),is.forEach(t),on=i(s),u(fe.$$.fragment,s),rn=i(s),S=m(s,"DIV",{class:!0});var ls=$(S);u(_e.$$.fragment,ls),oo=i(ls),Ke=m(ls,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1bhhpq0"&&(Ke.innerHTML=ur),ro=i(ls),sa=m(ls,"P",{"data-svelte-h":!0}),d(sa)!=="svelte-6pahdo"&&(sa.innerHTML=fr),io=i(ls),ea=m(ls,"P",{"data-svelte-h":!0}),d(ea)!=="svelte-hswkmf"&&(ea.innerHTML=_r),lo=i(ls),V=m(ls,"DIV",{class:!0});var ms=$(V);u(ye.$$.fragment,ms),mo=i(ms),aa=m(ms,"P",{"data-svelte-h":!0}),d(aa)!=="svelte-bspvkf"&&(aa.innerHTML=yr),po=i(ms),u(vs.$$.fragment,ms),co=i(ms),u(ws.$$.fragment,ms),ho=i(ms),u(ks.$$.fragment,ms),ms.forEach(t),ls.forEach(t),ln=i(s),u(be.$$.fragment,s),mn=i(s),I=m(s,"DIV",{class:!0});var ps=$(I);u(ve.$$.fragment,ps),go=i(ps),ta=m(ps,"P",{"data-svelte-h":!0}),d(ta)!=="svelte-tck2ey"&&(ta.textContent=br),uo=i(ps),na=m(ps,"P",{"data-svelte-h":!0}),d(na)!=="svelte-6pahdo"&&(na.innerHTML=vr),fo=i(ps),oa=m(ps,"P",{"data-svelte-h":!0}),d(oa)!=="svelte-hswkmf"&&(oa.innerHTML=wr),_o=i(ps),E=m(ps,"DIV",{class:!0});var cs=$(E);u(we.$$.fragment,cs),yo=i(cs),ra=m(cs,"P",{"data-svelte-h":!0}),d(ra)!=="svelte-9yvwij"&&(ra.innerHTML=kr),bo=i(cs),u(Ms.$$.fragment,cs),vo=i(cs),u(xs.$$.fragment,cs),wo=i(cs),u(Ts.$$.fragment,cs),cs.forEach(t),ps.forEach(t),pn=i(s),u(ke.$$.fragment,s),cn=i(s),N=m(s,"DIV",{class:!0});var ds=$(N);u(Me.$$.fragment,ds),ko=i(ds),ia=m(ds,"P",{"data-svelte-h":!0}),d(ia)!=="svelte-5xzdgh"&&(ia.innerHTML=Mr),Mo=i(ds),la=m(ds,"P",{"data-svelte-h":!0}),d(la)!=="svelte-6pahdo"&&(la.innerHTML=xr),xo=i(ds),ma=m(ds,"P",{"data-svelte-h":!0}),d(ma)!=="svelte-hswkmf"&&(ma.innerHTML=Tr),To=i(ds),Y=m(ds,"DIV",{class:!0});var Ls=$(Y);u(xe.$$.fragment,Ls),zo=i(Ls),pa=m(Ls,"P",{"data-svelte-h":!0}),d(pa)!=="svelte-vyu31t"&&(pa.innerHTML=zr),$o=i(Ls),u(zs.$$.fragment,Ls),Ro=i(Ls),u($s.$$.fragment,Ls),Ls.forEach(t),ds.forEach(t),dn=i(s),u(Te.$$.fragment,s),hn=i(s),fa=m(s,"P",{}),$(fa).forEach(t),this.h()},h(){q(n,"name","hf:doc:metadata"),q(n,"content",ki),q(z,"class","flex flex-wrap space-x-1"),q(us,"href","https://github.com/google/trax/blob/4d99ad4965bab1deba227539758d59f0df0fef48/trax/layers/research/position_encodings.py#L29"),q(us,"rel","nofollow"),$a.a=Ra,Ca.a=ja,La.a=Ja,qa.a=Wa,Ua.a=Fa,Ha.a=null,Sa.a=Ia,Na.a=null,Va.a=null,Pa.a=null,Aa.a=null,Ga.a=Oa,Da.a=Ya,Ka.a=st,et.a=at,tt.a=nt,rt.a=it,lt.a=mt,ct.a=dt,ht.a=gt,vt.a=wt,kt.a=Mt,xt.a=Tt,Rt.a=Ct,jt.a=Lt,Jt.a=qt,Ht.a=Zt,St.a=It,Nt.a=Xt,q(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,a){e(document.head,n),o(s,k,a),o(s,p,a),o(s,h,a),f(M,s,a),o(s,c,a),o(s,z,a),o(s,ya,a),f(qs,s,a),o(s,ba,a),o(s,Ws,a),o(s,va,a),o(s,Us,a),o(s,wa,a),o(s,Fs,a),o(s,ka,a),o(s,Hs,a),o(s,Ma,a),f(Zs,s,a),o(s,xa,a),o(s,Ss,a),o(s,Ta,a),f(Is,s,a),o(s,za,a),o(s,C,a),e(C,un),e(C,us),e(C,fn),$a.m(Rr,C),e(C,Ra),e(C,$e),e(C,_n),Ca.m(Cr,C),e(C,ja),La.m(jr,C),e(C,Ja),e(C,Re),e(C,yn),qa.m(Lr,C),e(C,Wa),e(C,Ce),e(C,bn),Ua.m(Jr,C),e(C,Fa),Ha.m(qr,C),o(s,Za,a),o(s,hs,a),e(hs,vn),Sa.m(Wr,hs),e(hs,Ia),Na.m(Ur,hs),o(s,Xa,a),o(s,Ns,a),e(Ns,wn),Va.m(Fr,Ns),o(s,Ea,a),o(s,Xs,a),e(Xs,kn),Pa.m(Hr,Xs),o(s,Qa,a),o(s,Vs,a),e(Vs,Mn),Aa.m(Zr,Vs),o(s,Ba,a),o(s,W,a),e(W,xn),Ga.m(Sr,W),e(W,Oa),Da.m(Ir,W),e(W,Ya),e(W,je),e(W,Tn),Ka.m(Nr,W),e(W,st),et.m(Xr,W),e(W,at),tt.m(Vr,W),e(W,nt),o(s,ot,a),o(s,ns,a),e(ns,zn),rt.m(Er,ns),e(ns,it),lt.m(Pr,ns),e(ns,mt),o(s,pt,a),o(s,L,a),e(L,$n),e(L,Le),e(L,Rn),ct.m(Qr,L),e(L,dt),e(L,Je),e(L,Cn),e(L,qe),e(L,jn),ht.m(Ar,L),e(L,gt),e(L,We),e(L,Ln),e(L,Ue),e(L,Jn),e(L,Fe),e(L,qn),o(s,ut,a),f(Es,s,a),o(s,ft,a),o(s,Ps,a),o(s,_t,a),o(s,Qs,a),o(s,yt,a),o(s,As,a),o(s,bt,a),o(s,X,a),e(X,Wn),e(X,He),e(X,Un),vt.m(Br,X),e(X,wt),kt.m(Gr,X),e(X,Mt),xt.m(Or,X),e(X,Tt),o(s,zt,a),o(s,Bs,a),o(s,$t,a),o(s,G,a),e(G,Fn),Rt.m(Dr,G),e(G,Ct),jt.m(Yr,G),e(G,Lt),Jt.m(Kr,G),e(G,qt),o(s,Wt,a),f(Gs,s,a),o(s,Ut,a),o(s,Os,a),o(s,Ft,a),o(s,O,a),e(O,Hn),Ht.m(si,O),e(O,Zt),St.m(ei,O),e(O,It),Nt.m(ai,O),e(O,Xt),o(s,Vt,a),f(Ds,s,a),o(s,Et,a),o(s,Ys,a),o(s,Pt,a),o(s,Ks,a),o(s,Qt,a),f(se,s,a),o(s,At,a),f(ee,s,a),o(s,Bt,a),o(s,ae,a),o(s,Gt,a),f(te,s,a),o(s,Ot,a),o(s,Q,a),f(ne,Q,null),e(Q,Zn),e(Q,Ze),e(Q,Sn),e(Q,Se),e(Q,In),f(fs,Q,null),o(s,Dt,a),f(oe,s,a),o(s,Yt,a),o(s,A,a),f(re,A,null),e(A,Nn),e(A,Ie),e(A,Xn),e(A,Ne),e(A,Vn),e(A,Xe),f(ie,Xe,null),o(s,Kt,a),f(le,s,a),o(s,sn,a),o(s,ss,a),f(me,ss,null),e(ss,En),e(ss,Ve),e(ss,Pn),e(ss,Ee),o(s,en,a),f(pe,s,a),o(s,an,a),o(s,H,a),f(ce,H,null),e(H,Qn),e(H,Pe),e(H,An),e(H,Qe),e(H,Bn),e(H,Ae),e(H,Gn),e(H,os),f(de,os,null),e(os,On),e(os,Be),e(os,Dn),f(_s,os,null),o(s,tn,a),f(he,s,a),o(s,nn,a),o(s,Z,a),f(ge,Z,null),e(Z,Yn),e(Z,Ge),e(Z,Kn),e(Z,Oe),e(Z,so),e(Z,De),e(Z,eo),e(Z,D),f(ue,D,null),e(D,ao),e(D,Ye),e(D,to),f(ys,D,null),e(D,no),f(bs,D,null),o(s,on,a),f(fe,s,a),o(s,rn,a),o(s,S,a),f(_e,S,null),e(S,oo),e(S,Ke),e(S,ro),e(S,sa),e(S,io),e(S,ea),e(S,lo),e(S,V),f(ye,V,null),e(V,mo),e(V,aa),e(V,po),f(vs,V,null),e(V,co),f(ws,V,null),e(V,ho),f(ks,V,null),o(s,ln,a),f(be,s,a),o(s,mn,a),o(s,I,a),f(ve,I,null),e(I,go),e(I,ta),e(I,uo),e(I,na),e(I,fo),e(I,oa),e(I,_o),e(I,E),f(we,E,null),e(E,yo),e(E,ra),e(E,bo),f(Ms,E,null),e(E,vo),f(xs,E,null),e(E,wo),f(Ts,E,null),o(s,pn,a),f(ke,s,a),o(s,cn,a),o(s,N,a),f(Me,N,null),e(N,ko),e(N,ia),e(N,Mo),e(N,la),e(N,xo),e(N,ma),e(N,To),e(N,Y),f(xe,Y,null),e(Y,zo),e(Y,pa),e(Y,$o),f(zs,Y,null),e(Y,Ro),f($s,Y,null),o(s,dn,a),f(Te,s,a),o(s,hn,a),o(s,fa,a),gn=!0},p(s,[a]){const j={};a&2&&(j.$$scope={dirty:a,ctx:s}),fs.$set(j);const Rs={};a&2&&(Rs.$$scope={dirty:a,ctx:s}),_s.$set(Rs);const ca={};a&2&&(ca.$$scope={dirty:a,ctx:s}),ys.$set(ca);const da={};a&2&&(da.$$scope={dirty:a,ctx:s}),bs.$set(da);const ha={};a&2&&(ha.$$scope={dirty:a,ctx:s}),vs.$set(ha);const U={};a&2&&(U.$$scope={dirty:a,ctx:s}),ws.$set(U);const gs={};a&2&&(gs.$$scope={dirty:a,ctx:s}),ks.$set(gs);const J={};a&2&&(J.$$scope={dirty:a,ctx:s}),Ms.$set(J);const B={};a&2&&(B.$$scope={dirty:a,ctx:s}),xs.$set(B);const es={};a&2&&(es.$$scope={dirty:a,ctx:s}),Ts.$set(es);const as={};a&2&&(as.$$scope={dirty:a,ctx:s}),zs.$set(as);const ts={};a&2&&(ts.$$scope={dirty:a,ctx:s}),$s.$set(ts)},i(s){gn||(_(M.$$.fragment,s),_(qs.$$.fragment,s),_(Zs.$$.fragment,s),_(Is.$$.fragment,s),_(Es.$$.fragment,s),_(Gs.$$.fragment,s),_(Ds.$$.fragment,s),_(se.$$.fragment,s),_(ee.$$.fragment,s),_(te.$$.fragment,s),_(ne.$$.fragment,s),_(fs.$$.fragment,s),_(oe.$$.fragment,s),_(re.$$.fragment,s),_(ie.$$.fragment,s),_(le.$$.fragment,s),_(me.$$.fragment,s),_(pe.$$.fragment,s),_(ce.$$.fragment,s),_(de.$$.fragment,s),_(_s.$$.fragment,s),_(he.$$.fragment,s),_(ge.$$.fragment,s),_(ue.$$.fragment,s),_(ys.$$.fragment,s),_(bs.$$.fragment,s),_(fe.$$.fragment,s),_(_e.$$.fragment,s),_(ye.$$.fragment,s),_(vs.$$.fragment,s),_(ws.$$.fragment,s),_(ks.$$.fragment,s),_(be.$$.fragment,s),_(ve.$$.fragment,s),_(we.$$.fragment,s),_(Ms.$$.fragment,s),_(xs.$$.fragment,s),_(Ts.$$.fragment,s),_(ke.$$.fragment,s),_(Me.$$.fragment,s),_(xe.$$.fragment,s),_(zs.$$.fragment,s),_($s.$$.fragment,s),_(Te.$$.fragment,s),gn=!0)},o(s){y(M.$$.fragment,s),y(qs.$$.fragment,s),y(Zs.$$.fragment,s),y(Is.$$.fragment,s),y(Es.$$.fragment,s),y(Gs.$$.fragment,s),y(Ds.$$.fragment,s),y(se.$$.fragment,s),y(ee.$$.fragment,s),y(te.$$.fragment,s),y(ne.$$.fragment,s),y(fs.$$.fragment,s),y(oe.$$.fragment,s),y(re.$$.fragment,s),y(ie.$$.fragment,s),y(le.$$.fragment,s),y(me.$$.fragment,s),y(pe.$$.fragment,s),y(ce.$$.fragment,s),y(de.$$.fragment,s),y(_s.$$.fragment,s),y(he.$$.fragment,s),y(ge.$$.fragment,s),y(ue.$$.fragment,s),y(ys.$$.fragment,s),y(bs.$$.fragment,s),y(fe.$$.fragment,s),y(_e.$$.fragment,s),y(ye.$$.fragment,s),y(vs.$$.fragment,s),y(ws.$$.fragment,s),y(ks.$$.fragment,s),y(be.$$.fragment,s),y(ve.$$.fragment,s),y(we.$$.fragment,s),y(Ms.$$.fragment,s),y(xs.$$.fragment,s),y(Ts.$$.fragment,s),y(ke.$$.fragment,s),y(Me.$$.fragment,s),y(xe.$$.fragment,s),y(zs.$$.fragment,s),y($s.$$.fragment,s),y(Te.$$.fragment,s),gn=!1},d(s){s&&(t(k),t(p),t(h),t(c),t(z),t(ya),t(ba),t(Ws),t(va),t(Us),t(wa),t(Fs),t(ka),t(Hs),t(Ma),t(xa),t(Ss),t(Ta),t(za),t(C),t(Za),t(hs),t(Xa),t(Ns),t(Ea),t(Xs),t(Qa),t(Vs),t(Ba),t(W),t(ot),t(ns),t(pt),t(L),t(ut),t(ft),t(Ps),t(_t),t(Qs),t(yt),t(As),t(bt),t(X),t(zt),t(Bs),t($t),t(G),t(Wt),t(Ut),t(Os),t(Ft),t(O),t(Vt),t(Et),t(Ys),t(Pt),t(Ks),t(Qt),t(At),t(Bt),t(ae),t(Gt),t(Ot),t(Q),t(Dt),t(Yt),t(A),t(Kt),t(sn),t(ss),t(en),t(an),t(H),t(tn),t(nn),t(Z),t(on),t(rn),t(S),t(ln),t(mn),t(I),t(pn),t(cn),t(N),t(dn),t(hn),t(fa)),t(n),b(M,s),b(qs,s),b(Zs,s),b(Is,s),b(Es,s),b(Gs,s),b(Ds,s),b(se,s),b(ee,s),b(te,s),b(ne),b(fs),b(oe,s),b(re),b(ie),b(le,s),b(me),b(pe,s),b(ce),b(de),b(_s),b(he,s),b(ge),b(ue),b(ys),b(bs),b(fe,s),b(_e),b(ye),b(vs),b(ws),b(ks),b(be,s),b(ve),b(we),b(Ms),b(xs),b(Ts),b(ke,s),b(Me),b(xe),b(zs),b($s),b(Te,s)}}}const ki='{"title":"Reformer","local":"reformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Axial Positional Encodings","local":"axial-positional-encodings","sections":[],"depth":3},{"title":"LSH Self Attention","local":"lsh-self-attention","sections":[],"depth":3},{"title":"Local Self Attention","local":"local-self-attention","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ReformerConfig","local":"transformers.ReformerConfig","sections":[],"depth":2},{"title":"ReformerTokenizer","local":"transformers.ReformerTokenizer","sections":[],"depth":2},{"title":"ReformerTokenizerFast","local":"transformers.ReformerTokenizerFast","sections":[],"depth":2},{"title":"ReformerModel","local":"transformers.ReformerModel","sections":[],"depth":2},{"title":"ReformerModelWithLMHead","local":"transformers.ReformerModelWithLMHead","sections":[],"depth":2},{"title":"ReformerForMaskedLM","local":"transformers.ReformerForMaskedLM","sections":[],"depth":2},{"title":"ReformerForSequenceClassification","local":"transformers.ReformerForSequenceClassification","sections":[],"depth":2},{"title":"ReformerForQuestionAnswering","local":"transformers.ReformerForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function Mi(R){return ni(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ji extends oi{constructor(n){super(),ri(this,n,Mi,wi,ti,{})}}export{Ji as component};
