import{s as As,z as Xs,o as Gs,n as uo}from"../chunks/scheduler.18a86fab.js";import{S as Ys,i as Qs,g as i,s as n,r as p,A as Os,h as m,f as t,c as s,j as w,u as h,x as d,k as T,y as a,a as r,v as g,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as Ot}from"../chunks/Tip.77304350.js";import{D as $}from"../chunks/Docstring.6758ea23.js";import{C as Ko}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Yn}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as j}from"../chunks/Heading.7e7e0c5b.js";import{E as Ks}from"../chunks/getInferenceSnippets.de10bc7d.js";function ea(z){let l,M="Example:",b,y,S;return y=new Ko({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTYW1WaXNpb25Db25maWclMkMlMEElMjAlMjAlMjAlMjBTYW1Qcm9tcHRFbmNvZGVyQ29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwU2FtTWFza0RlY29kZXJDb25maWclMkMlMEElMjAlMjAlMjAlMjBTYW1Nb2RlbCUyQyUwQSklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2FtQ29uZmlnJTIwd2l0aCUyMCU2MCUyMmZhY2Vib29rJTJGc2FtLXZpdC1odWdlJTIyJTYwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNhbUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNhbU1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjAlNjAlMjJmYWNlYm9vayUyRnNhbS12aXQtaHVnZSUyMiU2MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU2FtTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBhbHNvJTIwaW5pdGlhbGl6ZSUyMGElMjBTYW1Db25maWclMjBmcm9tJTIwYSUyMFNhbVZpc2lvbkNvbmZpZyUyQyUyMFNhbVByb21wdEVuY29kZXJDb25maWclMkMlMjBhbmQlMjBTYW1NYXNrRGVjb2RlckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMFNBTSUyMHZpc2lvbiUyQyUyMFNBTSUyMFEtRm9ybWVyJTIwYW5kJTIwbGFuZ3VhZ2UlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb25zJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMFNhbVZpc2lvbkNvbmZpZygpJTBBcHJvbXB0X2VuY29kZXJfY29uZmlnJTIwJTNEJTIwU2FtUHJvbXB0RW5jb2RlckNvbmZpZygpJTBBbWFza19kZWNvZGVyX2NvbmZpZyUyMCUzRCUyMFNhbU1hc2tEZWNvZGVyQ29uZmlnKCklMEElMEFjb25maWclMjAlM0QlMjBTYW1Db25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHByb21wdF9lbmNvZGVyX2NvbmZpZyUyQyUyMG1hc2tfZGVjb2Rlcl9jb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SamVisionConfig,
<span class="hljs-meta">... </span>    SamPromptEncoderConfig,
<span class="hljs-meta">... </span>    SamMaskDecoderConfig,
<span class="hljs-meta">... </span>    SamModel,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamConfig with \`&quot;facebook/sam-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SamConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamModel (with random weights) from the \`&quot;facebook/sam-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SamModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a SamConfig from a SamVisionConfig, SamPromptEncoderConfig, and SamMaskDecoderConfig</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing SAM vision, SAM Q-Former and language model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = SamVisionConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_encoder_config = SamPromptEncoderConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_decoder_config = SamMaskDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = SamConfig(vision_config, prompt_encoder_config, mask_decoder_config)`,wrap:!1}}),{c(){l=i("p"),l.textContent=M,b=n(),p(y.$$.fragment)},l(c){l=m(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),b=s(c),h(y.$$.fragment,c)},m(c,k){r(c,l,k),r(c,b,k),g(y,c,k),S=!0},p:uo,i(c){S||(f(y.$$.fragment,c),S=!0)},o(c){u(y.$$.fragment,c),S=!1},d(c){c&&(t(l),t(b)),_(y,c)}}}function oa(z){let l,M="Example:",b,y,S;return y=new Ko({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTYW1WaXNpb25Db25maWclMkMlMEElMjAlMjAlMjAlMjBTYW1WaXNpb25Nb2RlbCUyQyUwQSklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2FtVmlzaW9uQ29uZmlnJTIwd2l0aCUyMCU2MCUyMmZhY2Vib29rJTJGc2FtLXZpdC1odWdlJTIyJTYwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNhbVZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNhbVZpc2lvbk1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjAlNjAlMjJmYWNlYm9vayUyRnNhbS12aXQtaHVnZSUyMiU2MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU2FtVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SamVisionConfig,
<span class="hljs-meta">... </span>    SamVisionModel,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamVisionConfig with \`&quot;facebook/sam-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SamVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamVisionModel (with random weights) from the \`&quot;facebook/sam-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SamVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=i("p"),l.textContent=M,b=n(),p(y.$$.fragment)},l(c){l=m(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),b=s(c),h(y.$$.fragment,c)},m(c,k){r(c,l,k),r(c,b,k),g(y,c,k),S=!0},p:uo,i(c){S||(f(y.$$.fragment,c),S=!0)},o(c){u(y.$$.fragment,c),S=!1},d(c){c&&(t(l),t(b)),_(y,c)}}}function ta(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=M},l(b){l=m(b,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){r(b,l,y)},p:uo,d(b){b&&t(l)}}}function na(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=M},l(b){l=m(b,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){r(b,l,y)},p:uo,d(b){b&&t(l)}}}function sa(z){let l,M="Example:",b,y,S;return y=new Ko({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxfZG9jJTJGc2FtLWNhci5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWdfdXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbnB1dF9wb2ludHMlMjAlM0QlMjAlNUIlNUIlNUI0MDAlMkMlMjA2NTAlNUQlNUQlNUQlMjAlMjAlMjMlMjAyRCUyMGxvY2F0aW9uJTIwb2YlMjBhJTIwd2luZG93JTIwb24lMjB0aGUlMjBjYXIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEcmF3X2ltYWdlJTJDJTIwaW5wdXRfcG9pbnRzJTNEaW5wdXRfcG9pbnRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZXQlMjBzZWdtZW50YXRpb24lMjBtYXNrJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMFBvc3Rwcm9jZXNzJTIwbWFza3MlMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfbWFza3MoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cy5wcmVkX21hc2tzJTJDJTIwaW5wdXRzJTVCJTIyb3JpZ2luYWxfc2l6ZXMlMjIlNUQlMkMlMjBpbnB1dHMlNUIlMjJyZXNoYXBlZF9pbnB1dF9zaXplcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/sam-car.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_points = [[[<span class="hljs-number">400</span>, <span class="hljs-number">650</span>]]]  <span class="hljs-comment"># 2D location of a window on the car</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=raw_image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get segmentation mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Postprocess masks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>masks = processor.post_process_masks(
<span class="hljs-meta">... </span>    outputs.pred_masks, inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>], inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=M,b=n(),p(y.$$.fragment)},l(c){l=m(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),b=s(c),h(y.$$.fragment,c)},m(c,k){r(c,l,k),r(c,b,k),g(y,c,k),S=!0},p:uo,i(c){S||(f(y.$$.fragment,c),S=!0)},o(c){u(y.$$.fragment,c),S=!1},d(c){c&&(t(l),t(b)),_(y,c)}}}function aa(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=M},l(b){l=m(b,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){r(b,l,y)},p:uo,d(b){b&&t(l)}}}function ra(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=M},l(b){l=m(b,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){r(b,l,y)},p:uo,d(b){b&&t(l)}}}function ia(z){let l,M,b,y,S,c,k,Qn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/>',et,ge,ot,fe,On='SAM (Segment Anything Model) was proposed in <a href="https://arxiv.org/pdf/2304.02643v1.pdf" rel="nofollow">Segment Anything</a> by Alexander Kirillov, Eric Mintun, Nikhila Ravi, Hanzi Mao, Chloe Rolland, Laura Gustafson, Tete Xiao, Spencer Whitehead, Alex Berg, Wan-Yen Lo, Piotr Dollar, Ross Girshick.',tt,ue,Kn="The model can be used to predict segmentation masks of any object of interest given an input image.",nt,_e,es='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/sam-output.png" alt="example image"/>',st,be,os="The abstract from the paper is the following:",at,ye,ts='<em>We introduce the Segment Anything (SA) project: a new task, model, and dataset for image segmentation. Using our efficient model in a data collection loop, we built the largest segmentation dataset to date (by far), with over 1 billion masks on 11M licensed and privacy respecting images. The model is designed and trained to be promptable, so it can transfer zero-shot to new image distributions and tasks. We evaluate its capabilities on numerous tasks and find that its zero-shot performance is impressive — often competitive with or even superior to prior fully supervised results. We are releasing the Segment Anything Model (SAM) and corresponding dataset (SA-1B) of 1B masks and 11M images at <a href="https://segment-anything.com" rel="nofollow">https://segment-anything.com</a> to foster research into foundation models for computer vision.</em>',rt,Te,ns="Tips:",it,Me,ss='<li>The model predicts binary masks that states the presence or not of the object of interest given an image.</li> <li>The model predicts much better results if input 2D points and/or input bounding boxes are provided</li> <li>You can prompt multiple points for the same image, and predict a single mask.</li> <li>Fine-tuning the model is not supported yet</li> <li>According to the paper, textual input should be also supported. However, at this time of writing this seems not to be supported according to <a href="https://github.com/facebookresearch/segment-anything/issues/4#issuecomment-1497626844" rel="nofollow">the official repository</a>.</li>',mt,ve,as=`This model was contributed by <a href="https://huggingface.co/ybelkada" rel="nofollow">ybelkada</a> and <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a>.
The original code can be found <a href="https://github.com/facebookresearch/segment-anything" rel="nofollow">here</a>.`,lt,we,rs="Below is an example on how to run mask generation given an image and a 2D point:",dt,Se,ct,xe,is="You can also process your own masks alongside the input images in the processor to be passed to the model.",pt,$e,ht,ke,gt,ze,ms="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SAM.",ft,Ie,ls='<li><a href="https://github.com/huggingface/notebooks/blob/main/examples/segment_anything.ipynb" rel="nofollow">Demo notebook</a> for using the model.</li> <li><a href="https://github.com/huggingface/notebooks/blob/main/examples/automatic_mask_generation.ipynb" rel="nofollow">Demo notebook</a> for using the automatic mask generation pipeline.</li> <li><a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SAM/Run_inference_with_MedSAM_using_HuggingFace_Transformers.ipynb" rel="nofollow">Demo notebook</a> for inference with MedSAM, a fine-tuned version of SAM on the medical domain. 🌎</li> <li><a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SAM/Fine_tune_SAM_(segment_anything)_on_a_custom_dataset.ipynb" rel="nofollow">Demo notebook</a> for fine-tuning the model on custom data. 🌎</li>',ut,Ce,_t,je,ds='SlimSAM, a pruned version of SAM, was proposed in <a href="https://arxiv.org/abs/2312.05284" rel="nofollow">0.1% Data Makes Segment Anything Slim</a> by Zigeng Chen et al. SlimSAM reduces the size of the SAM models considerably while maintaining the same performance.',bt,Je,cs='Checkpoints can be found on the <a href="https://huggingface.co/models?other=slimsam" rel="nofollow">hub</a>, and they can be used as a drop-in replacement of SAM.',yt,Ne,Tt,Ue,ps='One can combine <a href="grounding-dino">Grounding DINO</a> with SAM for text-based mask generation as introduced in <a href="https://arxiv.org/abs/2401.14159" rel="nofollow">Grounded SAM: Assembling Open-World Models for Diverse Visual Tasks</a>. You can refer to this <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Grounding%20DINO/GroundingDINO_with_Segment_Anything.ipynb" rel="nofollow">demo notebook</a> 🌍 for details.',Mt,Y,hs,vt,Pe,gs='Grounded SAM overview. Taken from the <a href="https://github.com/IDEA-Research/Grounded-Segment-Anything">original repository</a>.',wt,We,St,J,Fe,Kt,_o,fs=`<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a> is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamModel">SamModel</a>. It is used to instantiate a
SAM model according to the specified arguments, defining the vision model, prompt-encoder model and mask decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the
SAM-ViT-H <a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,en,bo,us=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,on,Q,xt,Ze,$t,N,Ve,tn,yo,_s=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamVisionModel">SamVisionModel</a>. It is used to instantiate a SAM
vision encoder according to the specified arguments, defining the model architecture. Instantiating a configuration
defaults will yield a similar configuration to that of the SAM ViT-h
<a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,nn,To,bs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,sn,O,kt,Le,zt,F,Be,an,Mo,ys=`This is the configuration class to store the configuration of a <code>SamMaskDecoder</code>. It is used to instantiate a SAM
mask decoder to the specified arguments, defining the model architecture. Instantiating a configuration defaults
will yield a similar configuration to that of the SAM-vit-h
<a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,rn,vo,Ts=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,It,Ee,Ct,Z,Re,mn,wo,Ms=`This is the configuration class to store the configuration of a <code>SamPromptEncoder</code>. The <code>SamPromptEncoder</code>
module is used to encode the input 2D points and bounding boxes. Instantiating a configuration defaults will yield
a similar configuration to that of the SAM-vit-h
<a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,ln,So,vs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jt,De,Jt,V,qe,dn,xo,ws=`Constructs a SAM processor which wraps a SAM image processor and an 2D points & Bounding boxes processor into a
single processor.`,cn,$o,Ss=`<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a>. See the docstring of
<a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__"><strong>call</strong>()</a> for more information.`,Nt,He,Ut,v,Ae,pn,ko,xs="Constructs a SAM image processor.",hn,K,Xe,gn,zo,$s=`Filters the predicted masks by selecting only the ones that meets several criteria. The first criterion being
that the iou scores needs to be greater than <code>pred_iou_thresh</code>. The second criterion is that the stability
score needs to be greater than <code>stability_score_thresh</code>. The method also converts the predicted masks to
bounding boxes and pad the predicted masks if necessary.`,fn,ee,Ge,un,Io,ks="Generates a list of crop boxes of different sizes. Each layer has (2<strong>i)</strong>2 boxes for the ith layer.",_n,oe,Ye,bn,Co,zs="Pad an image to <code>(pad_size[&quot;height&quot;], pad_size[&quot;width&quot;])</code> with zeros to the right and bottom.",yn,te,Qe,Tn,jo,Is="Post processes mask that are generated by calling the Non Maximum Suppression algorithm on the predicted masks.",Mn,ne,Oe,vn,Jo,Cs="Remove padding and upscale masks to the original image size.",wn,se,Ke,Sn,No,js="Preprocess an image or batch of images.",xn,ae,eo,$n,Uo,Js="Resize an image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>.",Pt,oo,Wt,I,to,kn,Po,Ns="The vision model from Sam without any head or projection on top.",zn,Wo,Us=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,In,Fo,Ps=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Cn,E,no,jn,Zo,Ws='The <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamVisionModel">SamVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Jn,re,Ft,so,Zt,C,ao,Nn,Vo,Fs="Segment Anything Model (SAM) for generating segmentation masks, given an input image and",Un,Lo,Zs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pn,Bo,Vs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wn,W,ro,Fn,Eo,Ls='The <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamModel">SamModel</a> forward method, overrides the <code>__call__</code> special method.',Zn,ie,Vn,me,Vt,io,Lt,U,mo,Ln,Ro,Bs=`The vision model from Sam without any head or projection on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bn,Do,Es=`This model is also a TensorFlow <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a>
subclass. Use it as a regular TensorFlow Model and refer to the TensorFlow documentation for all matter related to
general usage and behavior.`,En,R,lo,Rn,qo,Rs='The <a href="/docs/transformers/main/en/model_doc/sam#transformers.TFSamVisionModel">TFSamVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Dn,le,Bt,co,Et,P,po,qn,Ho,Ds=`Segment Anything Model (SAM) for generating segmentation masks, given an input image and  optional 2D location and bounding boxes.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Hn,Ao,qs=`This model is also a TensorFlow <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a>
subclass. Use it as a regular TensorFlow Model and refer to the TensorFlow documentation for all matter related to
general usage and behavior.`,An,D,ho,Xn,Xo,Hs='The <a href="/docs/transformers/main/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> forward method, overrides the <code>__call__</code> special method.',Gn,de,Rt,go,Dt,Oo,qt;return S=new j({props:{title:"SAM",local:"sam",headingTag:"h1"}}),ge=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Se=new Ko({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTYW1Nb2RlbCUyQyUyMFNhbVByb2Nlc3NvciUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBTYW1Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWh1Z2UlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBTYW1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1odWdlJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGeWJlbGthZGElMkZzZWdtZW50LWFueXRoaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZhc3NldHMlMkZjYXIucG5nJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCNDUwJTJDJTIwNjAwJTVEJTVEJTVEJTIwJTIwJTIzJTIwMkQlMjBsb2NhdGlvbiUyMG9mJTIwYSUyMHdpbmRvdyUyMGluJTIwdGhlJTIwaW1hZ2UlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocmF3X2ltYWdlJTJDJTIwaW5wdXRfcG9pbnRzJTNEaW5wdXRfcG9pbnRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza3MlMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19tYXNrcyglMEElMjAlMjAlMjAlMjBvdXRwdXRzLnByZWRfbWFza3MuY3B1KCklMkMlMjBpbnB1dHMlNUIlMjJvcmlnaW5hbF9zaXplcyUyMiU1RC5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTVELmNwdSgpJTBBKSUwQXNjb3JlcyUyMCUzRCUyMG91dHB1dHMuaW91X3Njb3Jlcw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-huge&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-huge&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
input_points = [[[<span class="hljs-number">450</span>, <span class="hljs-number">600</span>]]]  <span class="hljs-comment"># 2D location of a window in the image</span>

inputs = processor(raw_image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

masks = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)
scores = outputs.iou_scores`,wrap:!1}}),$e=new Ko({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTYW1Nb2RlbCUyQyUyMFNhbVByb2Nlc3NvciUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBTYW1Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWh1Z2UlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBTYW1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1odWdlJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGeWJlbGthZGElMkZzZWdtZW50LWFueXRoaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZhc3NldHMlMkZjYXIucG5nJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGeWJlbGthZGElMkZzZWdtZW50LWFueXRoaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZhc3NldHMlMkZjYXIucG5nJTIyJTBBc2VnbWVudGF0aW9uX21hcCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KG1hc2tfdXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMjElMjIpJTBBaW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCNDUwJTJDJTIwNjAwJTVEJTVEJTVEJTIwJTIwJTIzJTIwMkQlMjBsb2NhdGlvbiUyMG9mJTIwYSUyMHdpbmRvdyUyMGluJTIwdGhlJTIwaW1hZ2UlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocmF3X2ltYWdlJTJDJTIwaW5wdXRfcG9pbnRzJTNEaW5wdXRfcG9pbnRzJTJDJTIwc2VnbWVudGF0aW9uX21hcHMlM0RzZWdtZW50YXRpb25fbWFwJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza3MlMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19tYXNrcyglMEElMjAlMjAlMjAlMjBvdXRwdXRzLnByZWRfbWFza3MuY3B1KCklMkMlMjBpbnB1dHMlNUIlMjJvcmlnaW5hbF9zaXplcyUyMiU1RC5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTVELmNwdSgpJTBBKSUwQXNjb3JlcyUyMCUzRCUyMG91dHB1dHMuaW91X3Njb3Jlcw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-huge&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-huge&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
segmentation_map = Image.<span class="hljs-built_in">open</span>(requests.get(mask_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;1&quot;</span>)
input_points = [[[<span class="hljs-number">450</span>, <span class="hljs-number">600</span>]]]  <span class="hljs-comment"># 2D location of a window in the image</span>

inputs = processor(raw_image, input_points=input_points, segmentation_maps=segmentation_map, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

masks = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)
scores = outputs.iou_scores`,wrap:!1}}),ke=new j({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ce=new j({props:{title:"SlimSAM",local:"slimsam",headingTag:"h2"}}),Ne=new j({props:{title:"Grounded SAM",local:"grounded-sam",headingTag:"h2"}}),We=new j({props:{title:"SamConfig",local:"transformers.SamConfig",headingTag:"h2"}}),Fe=new $({props:{name:"class transformers.SamConfig",anchor:"transformers.SamConfig",parameters:[{name:"vision_config",val:" = None"},{name:"prompt_encoder_config",val:" = None"},{name:"mask_decoder_config",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamConfig.vision_config",description:`<strong>vision_config</strong> (Union[<code>dict</code>, <code>SamVisionConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamVisionConfig">SamVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.SamConfig.prompt_encoder_config",description:`<strong>prompt_encoder_config</strong> (Union[<code>dict</code>, <code>SamPromptEncoderConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamPromptEncoderConfig">SamPromptEncoderConfig</a>.`,name:"prompt_encoder_config"},{anchor:"transformers.SamConfig.mask_decoder_config",description:`<strong>mask_decoder_config</strong> (Union[<code>dict</code>, <code>SamMaskDecoderConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamMaskDecoderConfig">SamMaskDecoderConfig</a>.`,name:"mask_decoder_config"},{anchor:"transformers.SamConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/configuration_sam.py#L254"}}),Q=new Yn({props:{anchor:"transformers.SamConfig.example",$$slots:{default:[ea]},$$scope:{ctx:z}}}),Ze=new j({props:{title:"SamVisionConfig",local:"transformers.SamVisionConfig",headingTag:"h2"}}),Ve=new $({props:{name:"class transformers.SamVisionConfig",anchor:"transformers.SamVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"output_channels",val:" = 256"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 1e-10"},{name:"qkv_bias",val:" = True"},{name:"mlp_ratio",val:" = 4.0"},{name:"use_abs_pos",val:" = True"},{name:"use_rel_pos",val:" = True"},{name:"window_size",val:" = 14"},{name:"global_attn_indexes",val:" = [2, 5, 8, 11]"},{name:"num_pos_feats",val:" = 128"},{name:"mlp_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SamVisionConfig.output_channels",description:`<strong>output_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output channels in the Patch Encoder.`,name:"output_channels"},{anchor:"transformers.SamVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SamVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SamVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.SamVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Expected resolution. Target size of the resized input image.`,name:"image_size"},{anchor:"transformers.SamVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Size of the patches to be extracted from the input image.`,name:"patch_size"},{anchor:"transformers.SamVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string)`,name:"hidden_act"},{anchor:"transformers.SamVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SamVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.SamVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-10) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SamVisionConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to query, key, value projections.`,name:"qkv_bias"},{anchor:"transformers.SamVisionConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of mlp hidden dim to embedding dim.`,name:"mlp_ratio"},{anchor:"transformers.SamVisionConfig.use_abs_pos",description:`<strong>use_abs_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use absolute position embedding.`,name:"use_abs_pos"},{anchor:"transformers.SamVisionConfig.use_rel_pos",description:`<strong>use_rel_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use relative position embedding.`,name:"use_rel_pos"},{anchor:"transformers.SamVisionConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Window size for relative position.`,name:"window_size"},{anchor:"transformers.SamVisionConfig.global_attn_indexes",description:`<strong>global_attn_indexes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
The indexes of the global attention layers.`,name:"global_attn_indexes"},{anchor:"transformers.SamVisionConfig.num_pos_feats",description:`<strong>num_pos_feats</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The dimensionality of the position embedding.`,name:"num_pos_feats"},{anchor:"transformers.SamVisionConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The dimensionality of the MLP layer in the Transformer encoder. If <code>None</code>, defaults to <code>mlp_ratio * hidden_size</code>.`,name:"mlp_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/configuration_sam.py#L136"}}),O=new Yn({props:{anchor:"transformers.SamVisionConfig.example",$$slots:{default:[oa]},$$scope:{ctx:z}}}),Le=new j({props:{title:"SamMaskDecoderConfig",local:"transformers.SamMaskDecoderConfig",headingTag:"h2"}}),Be=new $({props:{name:"class transformers.SamMaskDecoderConfig",anchor:"transformers.SamMaskDecoderConfig",parameters:[{name:"hidden_size",val:" = 256"},{name:"hidden_act",val:" = 'relu'"},{name:"mlp_dim",val:" = 2048"},{name:"num_hidden_layers",val:" = 2"},{name:"num_attention_heads",val:" = 8"},{name:"attention_downsample_rate",val:" = 2"},{name:"num_multimask_outputs",val:" = 3"},{name:"iou_head_depth",val:" = 3"},{name:"iou_head_hidden_dim",val:" = 256"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamMaskDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the hidden states.`,name:"hidden_size"},{anchor:"transformers.SamMaskDecoderConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function used inside the <code>SamMaskDecoder</code> module.`,name:"hidden_act"},{anchor:"transformers.SamMaskDecoderConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"mlp_dim"},{anchor:"transformers.SamMaskDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SamMaskDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SamMaskDecoderConfig.attention_downsample_rate",description:`<strong>attention_downsample_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The downsampling rate of the attention layer.`,name:"attention_downsample_rate"},{anchor:"transformers.SamMaskDecoderConfig.num_multimask_outputs",description:`<strong>num_multimask_outputs</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of outputs from the <code>SamMaskDecoder</code> module. In the Segment Anything paper, this is set to 3.`,name:"num_multimask_outputs"},{anchor:"transformers.SamMaskDecoderConfig.iou_head_depth",description:`<strong>iou_head_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of layers in the IoU head module.`,name:"iou_head_depth"},{anchor:"transformers.SamMaskDecoderConfig.iou_head_hidden_dim",description:`<strong>iou_head_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The dimensionality of the hidden states in the IoU head module.`,name:"iou_head_hidden_dim"},{anchor:"transformers.SamMaskDecoderConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/configuration_sam.py#L73"}}),Ee=new j({props:{title:"SamPromptEncoderConfig",local:"transformers.SamPromptEncoderConfig",headingTag:"h2"}}),Re=new $({props:{name:"class transformers.SamPromptEncoderConfig",anchor:"transformers.SamPromptEncoderConfig",parameters:[{name:"hidden_size",val:" = 256"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"mask_input_channels",val:" = 16"},{name:"num_point_embeddings",val:" = 4"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamPromptEncoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the hidden states.`,name:"hidden_size"},{anchor:"transformers.SamPromptEncoderConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The expected output resolution of the image.`,name:"image_size"},{anchor:"transformers.SamPromptEncoderConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SamPromptEncoderConfig.mask_input_channels",description:`<strong>mask_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of channels to be fed to the <code>MaskDecoder</code> module.`,name:"mask_input_channels"},{anchor:"transformers.SamPromptEncoderConfig.num_point_embeddings",description:`<strong>num_point_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of point embeddings to be used.`,name:"num_point_embeddings"},{anchor:"transformers.SamPromptEncoderConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function in the encoder and pooler.`,name:"hidden_act"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/configuration_sam.py#L24"}}),De=new j({props:{title:"SamProcessor",local:"transformers.SamProcessor",headingTag:"h2"}}),qe=new $({props:{name:"class transformers.SamProcessor",anchor:"transformers.SamProcessor",parameters:[{name:"image_processor",val:""}],parametersDescription:[{anchor:"transformers.SamProcessor.image_processor",description:`<strong>image_processor</strong> (<code>SamImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a>. The image processor is a required input.`,name:"image_processor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/processing_sam.py#L55"}}),He=new j({props:{title:"SamImageProcessor",local:"transformers.SamImageProcessor",headingTag:"h2"}}),Ae=new $({props:{name:"class transformers.SamImageProcessor",anchor:"transformers.SamImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"mask_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": typing.Optional[int] = None"},{name:"mask_pad_size",val:": typing.Optional[int] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SamImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;longest_edge&quot; -- 1024}</code>):
Size of the output image after resizing. Resizes the longest edge of the image to match
<code>size[&quot;longest_edge&quot;]</code> while maintaining the aspect ratio. Can be overridden by the <code>size</code> parameter in the
<code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SamImageProcessor.mask_size",description:`<strong>mask_size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;longest_edge&quot; -- 256}</code>):
Size of the output segmentation map after resizing. Resizes the longest edge of the image to match
<code>size[&quot;longest_edge&quot;]</code> while maintaining the aspect ratio. Can be overridden by the <code>mask_size</code> parameter
in the <code>preprocess</code> method.`,name:"mask_size"},{anchor:"transformers.SamImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.SamImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Wwhether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SamImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.SamImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.SamImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.SamImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.SamImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to the specified <code>pad_size</code>. Can be overridden by the <code>do_pad</code> parameter in the
<code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.SamImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1024, &quot;width&quot;: 1024}</code>):
Size of the output image after padding. Can be overridden by the <code>pad_size</code> parameter in the <code>preprocess</code>
method.`,name:"pad_size"},{anchor:"transformers.SamImageProcessor.mask_pad_size",description:`<strong>mask_pad_size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the output segmentation map after padding. Can be overridden by the <code>mask_pad_size</code> parameter in
the <code>preprocess</code> method.`,name:"mask_pad_size"},{anchor:"transformers.SamImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L67"}}),Xe=new $({props:{name:"filter_masks",anchor:"transformers.SamImageProcessor.filter_masks",parameters:[{name:"masks",val:""},{name:"iou_scores",val:""},{name:"original_size",val:""},{name:"cropped_box_image",val:""},{name:"pred_iou_thresh",val:" = 0.88"},{name:"stability_score_thresh",val:" = 0.95"},{name:"mask_threshold",val:" = 0"},{name:"stability_score_offset",val:" = 1"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.SamImageProcessor.filter_masks.masks",description:`<strong>masks</strong> (<code>Union[torch.Tensor, tf.Tensor]</code>) &#x2014;
Input masks.`,name:"masks"},{anchor:"transformers.SamImageProcessor.filter_masks.iou_scores",description:`<strong>iou_scores</strong> (<code>Union[torch.Tensor, tf.Tensor]</code>) &#x2014;
List of IoU scores.`,name:"iou_scores"},{anchor:"transformers.SamImageProcessor.filter_masks.original_size",description:`<strong>original_size</strong> (<code>Tuple[int,int]</code>) &#x2014;
Size of the original image.`,name:"original_size"},{anchor:"transformers.SamImageProcessor.filter_masks.cropped_box_image",description:`<strong>cropped_box_image</strong> (<code>np.array</code>) &#x2014;
The cropped image.`,name:"cropped_box_image"},{anchor:"transformers.SamImageProcessor.filter_masks.pred_iou_thresh",description:`<strong>pred_iou_thresh</strong> (<code>float</code>, <em>optional</em>, defaults to 0.88) &#x2014;
The threshold for the iou scores.`,name:"pred_iou_thresh"},{anchor:"transformers.SamImageProcessor.filter_masks.stability_score_thresh",description:`<strong>stability_score_thresh</strong> (<code>float</code>, <em>optional</em>, defaults to 0.95) &#x2014;
The threshold for the stability score.`,name:"stability_score_thresh"},{anchor:"transformers.SamImageProcessor.filter_masks.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The threshold for the predicted masks.`,name:"mask_threshold"},{anchor:"transformers.SamImageProcessor.filter_masks.stability_score_offset",description:`<strong>stability_score_offset</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The offset for the stability score used in the <code>_compute_stability_score</code> method.`,name:"stability_score_offset"},{anchor:"transformers.SamImageProcessor.filter_masks.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>pt</code>) &#x2014;
If <code>pt</code>, returns <code>torch.Tensor</code>. If <code>tf</code>, returns <code>tf.Tensor</code>.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L806"}}),Ge=new $({props:{name:"generate_crop_boxes",anchor:"transformers.SamImageProcessor.generate_crop_boxes",parameters:[{name:"image",val:""},{name:"target_size",val:""},{name:"crop_n_layers",val:": int = 0"},{name:"overlap_ratio",val:": float = 0.3413333333333333"},{name:"points_per_crop",val:": typing.Optional[int] = 32"},{name:"crop_n_points_downscale_factor",val:": typing.Optional[typing.List[int]] = 1"},{name:"device",val:": typing.Optional[ForwardRef('torch.device')] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"return_tensors",val:": str = 'pt'"}],parametersDescription:[{anchor:"transformers.SamImageProcessor.generate_crop_boxes.image",description:`<strong>image</strong> (<code>np.array</code>) &#x2014;
Input original image`,name:"image"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.target_size",description:`<strong>target_size</strong> (<code>int</code>) &#x2014;
Target size of the resized image`,name:"target_size"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.crop_n_layers",description:`<strong>crop_n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt;0, mask prediction will be run again on crops of the image. Sets the number of layers to run, where
each layer has 2**i_layer number of image crops.`,name:"crop_n_layers"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.overlap_ratio",description:`<strong>overlap_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 512/1500) &#x2014;
Sets the degree to which crops overlap. In the first crop layer, crops will overlap by this fraction of
the image length. Later layers with more crops scale down this overlap.`,name:"overlap_ratio"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.points_per_crop",description:`<strong>points_per_crop</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of points to sample from each crop.`,name:"points_per_crop"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.crop_n_points_downscale_factor",description:`<strong>crop_n_points_downscale_factor</strong> (<code>List[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of points-per-side sampled in layer n is scaled down by crop_n_points_downscale_factor**n.`,name:"crop_n_points_downscale_factor"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to None) &#x2014;
Device to use for the computation. If None, cpu will be used.`,name:"device"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.SamImageProcessor.generate_crop_boxes.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>pt</code>) &#x2014;
If <code>pt</code>, returns <code>torch.Tensor</code>. If <code>tf</code>, returns <code>tf.Tensor</code>.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L741"}}),Ye=new $({props:{name:"pad_image",anchor:"transformers.SamImageProcessor.pad_image",parameters:[{name:"image",val:": ndarray"},{name:"pad_size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamImageProcessor.pad_image.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.SamImageProcessor.pad_image.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image after padding.`,name:"pad_size"},{anchor:"transformers.SamImageProcessor.pad_image.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The data format of the image. Can be either &#x201C;channels_first&#x201D; or &#x201C;channels_last&#x201D;. If <code>None</code>, the
<code>data_format</code> of the <code>image</code> will be used.`,name:"data_format"},{anchor:"transformers.SamImageProcessor.pad_image.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L166"}}),Qe=new $({props:{name:"post_process_for_mask_generation",anchor:"transformers.SamImageProcessor.post_process_for_mask_generation",parameters:[{name:"all_masks",val:""},{name:"all_scores",val:""},{name:"all_boxes",val:""},{name:"crops_nms_thresh",val:""},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.SamImageProcessor.post_process_for_mask_generation.all_masks",description:`<strong>all_masks</strong> (<code>Union[List[torch.Tensor], List[tf.Tensor]]</code>) &#x2014;
List of all predicted segmentation masks`,name:"all_masks"},{anchor:"transformers.SamImageProcessor.post_process_for_mask_generation.all_scores",description:`<strong>all_scores</strong> (<code>Union[List[torch.Tensor], List[tf.Tensor]]</code>) &#x2014;
List of all predicted iou scores`,name:"all_scores"},{anchor:"transformers.SamImageProcessor.post_process_for_mask_generation.all_boxes",description:`<strong>all_boxes</strong> (<code>Union[List[torch.Tensor], List[tf.Tensor]]</code>) &#x2014;
List of all bounding boxes of the predicted masks`,name:"all_boxes"},{anchor:"transformers.SamImageProcessor.post_process_for_mask_generation.crops_nms_thresh",description:`<strong>crops_nms_thresh</strong> (<code>float</code>) &#x2014;
Threshold for NMS (Non Maximum Suppression) algorithm.`,name:"crops_nms_thresh"},{anchor:"transformers.SamImageProcessor.post_process_for_mask_generation.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>pt</code>) &#x2014;
If <code>pt</code>, returns <code>torch.Tensor</code>. If <code>tf</code>, returns <code>tf.Tensor</code>.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L718"}}),Oe=new $({props:{name:"post_process_masks",anchor:"transformers.SamImageProcessor.post_process_masks",parameters:[{name:"masks",val:""},{name:"original_sizes",val:""},{name:"reshaped_input_sizes",val:""},{name:"mask_threshold",val:" = 0.0"},{name:"binarize",val:" = True"},{name:"pad_size",val:" = None"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.SamImageProcessor.post_process_masks.masks",description:`<strong>masks</strong> (<code>Union[List[torch.Tensor], List[np.ndarray], List[tf.Tensor]]</code>) &#x2014;
Batched masks from the mask_decoder in (batch_size, num_channels, height, width) format.`,name:"masks"},{anchor:"transformers.SamImageProcessor.post_process_masks.original_sizes",description:`<strong>original_sizes</strong> (<code>Union[torch.Tensor, tf.Tensor, List[Tuple[int,int]]]</code>) &#x2014;
The original sizes of each image before it was resized to the model&#x2019;s expected input shape, in (height,
width) format.`,name:"original_sizes"},{anchor:"transformers.SamImageProcessor.post_process_masks.reshaped_input_sizes",description:`<strong>reshaped_input_sizes</strong> (<code>Union[torch.Tensor, tf.Tensor, List[Tuple[int,int]]]</code>) &#x2014;
The size of each image as it is fed to the model, in (height, width) format. Used to remove padding.`,name:"reshaped_input_sizes"},{anchor:"transformers.SamImageProcessor.post_process_masks.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The threshold to use for binarizing the masks.`,name:"mask_threshold"},{anchor:"transformers.SamImageProcessor.post_process_masks.binarize",description:`<strong>binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to binarize the masks.`,name:"binarize"},{anchor:"transformers.SamImageProcessor.post_process_masks.pad_size",description:`<strong>pad_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.pad_size</code>) &#x2014;
The target size the images were padded to before being passed to the model. If None, the target size is
assumed to be the processor&#x2019;s <code>pad_size</code>.`,name:"pad_size"},{anchor:"transformers.SamImageProcessor.post_process_masks.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
If <code>&quot;pt&quot;</code>, return PyTorch tensors. If <code>&quot;tf&quot;</code>, return TensorFlow tensors.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Batched masks in batch_size, num_channels, height, width) format, where
(height, width) is given by original_size.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>Union[torch.Tensor, tf.Tensor]</code>)</p>
`}}),Ke=new $({props:{name:"preprocess",anchor:"transformers.SamImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"mask_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[ForwardRef('PILImageResampling')] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"mask_pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.SamImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SamImageProcessor.preprocess.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
Segmentation map to preprocess.`,name:"segmentation_maps"},{anchor:"transformers.SamImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SamImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Controls the size of the image after <code>resize</code>. The longest edge of the image is resized to
<code>size[&quot;longest_edge&quot;]</code> whilst preserving the aspect ratio.`,name:"size"},{anchor:"transformers.SamImageProcessor.preprocess.mask_size",description:`<strong>mask_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.mask_size</code>) &#x2014;
Controls the size of the segmentation map after <code>resize</code>. The longest edge of the image is resized to
<code>size[&quot;longest_edge&quot;]</code> whilst preserving the aspect ratio.`,name:"mask_size"},{anchor:"transformers.SamImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BILINEAR</code>.`,name:"resample"},{anchor:"transformers.SamImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image pixel values by rescaling factor.`,name:"do_rescale"},{anchor:"transformers.SamImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to apply to the image pixel values.`,name:"rescale_factor"},{anchor:"transformers.SamImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.SamImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.SamImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.SamImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.SamImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.pad_size</code>) &#x2014;
Controls the size of the padding applied to the image. The image is padded to <code>pad_size[&quot;height&quot;]</code> and
<code>pad_size[&quot;width&quot;]</code> if <code>do_pad</code> is set to <code>True</code>.`,name:"pad_size"},{anchor:"transformers.SamImageProcessor.preprocess.mask_pad_size",description:`<strong>mask_pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.mask_pad_size</code>) &#x2014;
Controls the size of the padding applied to the segmentation map. The image is padded to
<code>mask_pad_size[&quot;height&quot;]</code> and <code>mask_pad_size[&quot;width&quot;]</code> if <code>do_pad</code> is set to <code>True</code>.`,name:"mask_pad_size"},{anchor:"transformers.SamImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.SamImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SamImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SamImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L390"}}),eo=new $({props:{name:"resize",anchor:"transformers.SamImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SamImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary in the format <code>{&quot;longest_edge&quot;: int}</code> specifying the size of the output image. The longest
edge of the image will be resized to the specified size, while the other edge will be resized to
maintain the aspect ratio.`,name:"size"},{anchor:"transformers.SamImageProcessor.resize.resample",description:`<strong>resample</strong> &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BILINEAR</code>.`,name:"resample"},{anchor:"transformers.SamImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. If unset, the channel dimension format of the input
image is used. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SamImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/image_processing_sam.py#L214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),oo=new j({props:{title:"SamVisionModel",local:"transformers.SamVisionModel",headingTag:"h2"}}),to=new $({props:{name:"class transformers.SamVisionModel",anchor:"transformers.SamVisionModel",parameters:[{name:"config",val:": SamVisionConfig"}],parametersDescription:[{anchor:"transformers.SamVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamVisionConfig">SamVisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_sam.py#L1201"}}),no=new $({props:{name:"forward",anchor:"transformers.SamVisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SamVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SamVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SamVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SamVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_sam.py#L1220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.sam.modeling_sam.SamVisionEncoderOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig"
>SamConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim)</code> <em>optional</em> returned when model is initialized with <code>with_projection=True</code>) — The image embeddings obtained by applying the projection layer to the pooler_output.</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.sam.modeling_sam.SamVisionEncoderOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Ot({props:{$$slots:{default:[ta]},$$scope:{ctx:z}}}),so=new j({props:{title:"SamModel",local:"transformers.SamModel",headingTag:"h2"}}),ao=new $({props:{name:"class transformers.SamModel",anchor:"transformers.SamModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SamModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamModel">SamModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_sam.py#L1236"}}),ro=new $({props:{name:"forward",anchor:"transformers.SamModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_points",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"input_boxes",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_masks",val:": typing.Optional[torch.LongTensor] = None"},{name:"image_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"multimask_output",val:": bool = True"},{name:"attention_similarity",val:": typing.Optional[torch.FloatTensor] = None"},{name:"target_embedding",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SamModel.forward.input_points",description:`<strong>input_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_points, 2)</code>) &#x2014;
Input 2D spatial points, this is used by the prompt encoder to encode the prompt. Generally yields to much
better results. The points can be obtained by passing a list of list of list to the processor that will
create corresponding <code>torch</code> tensors of dimension 4. The first dimension is the image batch size, the
second dimension is the point batch size (i.e. how many segmentation masks do we want the model to predict
per input point), the third dimension is the number of points per segmentation mask (it is possible to pass
multiple points for a single mask), and the last dimension is the x (vertical) and y (horizontal)
coordinates of the point. If a different number of points is passed either for each image, or for each
mask, the processor will create &#x201C;PAD&#x201D; points that will correspond to the (0, 0) coordinate, and the
computation of the embedding will be skipped for these points using the labels.`,name:"input_points"},{anchor:"transformers.SamModel.forward.input_labels",description:`<strong>input_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, point_batch_size, num_points)</code>) &#x2014;
Input labels for the points, this is used by the prompt encoder to encode the prompt. According to the
official implementation, there are 3 types of labels</p>
<ul>
<li><code>1</code>: the point is a point that contains the object of interest</li>
<li><code>0</code>: the point is a point that does not contain the object of interest</li>
<li><code>-1</code>: the point corresponds to the background</li>
</ul>
<p>We added the label:</p>
<ul>
<li><code>-10</code>: the point is a padding point, thus should be ignored by the prompt encoder</li>
</ul>
<p>The padding labels should be automatically done by the processor.`,name:"input_labels"},{anchor:"transformers.SamModel.forward.input_boxes",description:`<strong>input_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_boxes, 4)</code>) &#x2014;
Input boxes for the points, this is used by the prompt encoder to encode the prompt. Generally yields to
much better generated masks. The boxes can be obtained by passing a list of list of list to the processor,
that will generate a <code>torch</code> tensor, with each dimension corresponding respectively to the image batch
size, the number of boxes per image and the coordinates of the top left and bottom right point of the box.
In the order (<code>x1</code>, <code>y1</code>, <code>x2</code>, <code>y2</code>):</p>
<ul>
<li><code>x1</code>: the x coordinate of the top left point of the input box</li>
<li><code>y1</code>: the y coordinate of the top left point of the input box</li>
<li><code>x2</code>: the x coordinate of the bottom right point of the input box</li>
<li><code>y2</code>: the y coordinate of the bottom right point of the input box</li>
</ul>`,name:"input_boxes"},{anchor:"transformers.SamModel.forward.input_masks",description:`<strong>input_masks</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, image_size, image_size)</code>) &#x2014;
SAM model also accepts segmentation masks as input. The mask will be embedded by the prompt encoder to
generate a corresponding embedding, that will be fed later on to the mask decoder. These masks needs to be
manually fed by the user, and they need to be of shape (<code>batch_size</code>, <code>image_size</code>, <code>image_size</code>).`,name:"input_masks"},{anchor:"transformers.SamModel.forward.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_channels, window_size, window_size)</code>) &#x2014;
Image embeddings, this is used by the mask decder to generate masks and iou scores. For more memory
efficient computation, users can first retrieve the image embeddings using the <code>get_image_embeddings</code>
method, and then feed them to the <code>forward</code> method instead of feeding the <code>pixel_values</code>.`,name:"image_embeddings"},{anchor:"transformers.SamModel.forward.multimask_output",description:`<strong>multimask_output</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
In the original implementation and paper, the model always outputs 3 masks per image (or per point / per
bounding box if relevant). However, it is possible to just output a single mask, that corresponds to the
&#x201C;best&#x201D; mask, by specifying <code>multimask_output=False</code>.`,name:"multimask_output"},{anchor:"transformers.SamModel.forward.attention_similarity",description:`<strong>attention_similarity</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Attention similarity tensor, to be provided to the mask decoder for target-guided attention in case the
model is used for personalization as introduced in <a href="https://arxiv.org/abs/2305.03048" rel="nofollow">PerSAM</a>.`,name:"attention_similarity"},{anchor:"transformers.SamModel.forward.target_embedding",description:`<strong>target_embedding</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Embedding of the target concept, to be provided to the mask decoder for target-semantic prompting in case
the model is used for personalization as introduced in <a href="https://arxiv.org/abs/2305.03048" rel="nofollow">PerSAM</a>.`,name:"target_embedding"},{anchor:"transformers.SamModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SamModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_sam.py#L1336",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.sam.modeling_sam.SamImageSegmentationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig"
>SamConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>iou_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_masks)</code>) — The iou scores of the predicted masks.</p>
</li>
<li>
<p><strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_masks, height, width)</code>) — The predicted low resolutions masks. Needs to be post-processed by the processor</p>
</li>
<li>
<p><strong>vision_hidden_states</strong>  (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the vision model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>vision_attentions</strong>  (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>mask_decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.sam.modeling_sam.SamImageSegmentationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Ot({props:{$$slots:{default:[na]},$$scope:{ctx:z}}}),me=new Yn({props:{anchor:"transformers.SamModel.forward.example",$$slots:{default:[sa]},$$scope:{ctx:z}}}),io=new j({props:{title:"TFSamVisionModel",local:"transformers.TFSamVisionModel",headingTag:"h2"}}),mo=new $({props:{name:"class transformers.TFSamVisionModel",anchor:"transformers.TFSamVisionModel",parameters:[{name:"config",val:": SamVisionConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSamVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_tf_sam.py#L1425"}}),lo=new $({props:{name:"call",anchor:"transformers.TFSamVisionModel.call",parameters:[{name:"pixel_values",val:": TFModelInputType | None = None"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"training",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSamVisionModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a>. See <code>SamProcessor.__call__()</code> for
details.`,name:"pixel_values"},{anchor:"transformers.TFSamVisionModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSamVisionModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSamVisionModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_tf_sam.py#L1448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.sam.modeling_tf_sam.TFSamVisionEncoderOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<code>&lt;class 'transformers.models.sam.configuration_sam.SamVisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>image_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, output_dim)</code> <em>optional</em> returned when model is initialized with <code>with_projection=True</code>) — The image embeddings obtained by applying the projection layer to the pooler_output.</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.sam.modeling_tf_sam.TFSamVisionEncoderOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),le=new Ot({props:{$$slots:{default:[aa]},$$scope:{ctx:z}}}),co=new j({props:{title:"TFSamModel",local:"transformers.TFSamModel",headingTag:"h2"}}),po=new $({props:{name:"class transformers.TFSamModel",anchor:"transformers.TFSamModel",parameters:[{name:"config",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSamModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_tf_sam.py#L1473"}}),ho=new $({props:{name:"call",anchor:"transformers.TFSamModel.call",parameters:[{name:"pixel_values",val:": TFModelInputType | None = None"},{name:"input_points",val:": tf.Tensor | None = None"},{name:"input_labels",val:": tf.Tensor | None = None"},{name:"input_boxes",val:": tf.Tensor | None = None"},{name:"input_masks",val:": tf.Tensor | None = None"},{name:"image_embeddings",val:": tf.Tensor | None = None"},{name:"multimask_output",val:": bool = True"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"training",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSamModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a>. See <code>SamProcessor.__call__()</code> for
details.`,name:"pixel_values"},{anchor:"transformers.TFSamModel.call.input_points",description:`<strong>input_points</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_points, 2)</code>) &#x2014;
Input 2D spatial points, this is used by the prompt encoder to encode the prompt. Generally yields to much
better results. The points can be obtained by passing a list of list of list to the processor that will
create corresponding <code>tf</code> tensors of dimension 4. The first dimension is the image batch size, the second
dimension is the point batch size (i.e. how many segmentation masks do we want the model to predict per
input point), the third dimension is the number of points per segmentation mask (it is possible to pass
multiple points for a single mask), and the last dimension is the x (vertical) and y (horizontal)
coordinates of the point. If a different number of points is passed either for each image, or for each
mask, the processor will create &#x201C;PAD&#x201D; points that will correspond to the (0, 0) coordinate, and the
computation of the embedding will be skipped for these points using the labels.`,name:"input_points"},{anchor:"transformers.TFSamModel.call.input_labels",description:`<strong>input_labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, point_batch_size, num_points)</code>) &#x2014;
Input labels for the points, this is used by the prompt encoder to encode the prompt. According to the
official implementation, there are 3 types of labels</p>
<ul>
<li><code>1</code>: the point is a point that contains the object of interest</li>
<li><code>0</code>: the point is a point that does not contain the object of interest</li>
<li><code>-1</code>: the point corresponds to the background</li>
</ul>
<p>We added the label:</p>
<ul>
<li><code>-10</code>: the point is a padding point, thus should be ignored by the prompt encoder</li>
</ul>
<p>The padding labels should be automatically done by the processor.`,name:"input_labels"},{anchor:"transformers.TFSamModel.call.input_boxes",description:`<strong>input_boxes</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_boxes, 4)</code>) &#x2014;
Input boxes for the points, this is used by the prompt encoder to encode the prompt. Generally yields to
much better generated masks. The boxes can be obtained by passing a list of list of list to the processor,
that will generate a <code>tf</code> tensor, with each dimension corresponding respectively to the image batch size,
the number of boxes per image and the coordinates of the top left and bottom right point of the box. In the
order (<code>x1</code>, <code>y1</code>, <code>x2</code>, <code>y2</code>):</p>
<ul>
<li><code>x1</code>: the x coordinate of the top left point of the input box</li>
<li><code>y1</code>: the y coordinate of the top left point of the input box</li>
<li><code>x2</code>: the x coordinate of the bottom right point of the input box</li>
<li><code>y2</code>: the y coordinate of the bottom right point of the input box</li>
</ul>`,name:"input_boxes"},{anchor:"transformers.TFSamModel.call.input_masks",description:`<strong>input_masks</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, image_size, image_size)</code>) &#x2014;
SAM model also accepts segmentation masks as input. The mask will be embedded by the prompt encoder to
generate a corresponding embedding, that will be fed later on to the mask decoder. These masks needs to be
manually fed by the user, and they need to be of shape (<code>batch_size</code>, <code>image_size</code>, <code>image_size</code>).`,name:"input_masks"},{anchor:"transformers.TFSamModel.call.image_embeddings",description:`<strong>image_embeddings</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, output_channels, window_size, window_size)</code>) &#x2014;
Image embeddings, this is used by the mask decder to generate masks and iou scores. For more memory
efficient computation, users can first retrieve the image embeddings using the <code>get_image_embeddings</code>
method, and then feed them to the <code>call</code> method instead of feeding the <code>pixel_values</code>.`,name:"image_embeddings"},{anchor:"transformers.TFSamModel.call.multimask_output",description:`<strong>multimask_output</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
In the original implementation and paper, the model always outputs 3 masks per image (or per point / per
bounding box if relevant). However, it is possible to just output a single mask, that corresponds to the
&#x201C;best&#x201D; mask, by specifying <code>multimask_output=False</code>.`,name:"multimask_output"},{anchor:"transformers.TFSamModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSamModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSamModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam/modeling_tf_sam.py#L1568"}}),de=new Ot({props:{$$slots:{default:[ra]},$$scope:{ctx:z}}}),go=new Ks({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/sam.md"}}),{c(){l=i("meta"),M=n(),b=i("p"),y=n(),p(S.$$.fragment),c=n(),k=i("div"),k.innerHTML=Qn,et=n(),p(ge.$$.fragment),ot=n(),fe=i("p"),fe.innerHTML=On,tt=n(),ue=i("p"),ue.textContent=Kn,nt=n(),_e=i("p"),_e.innerHTML=es,st=n(),be=i("p"),be.textContent=os,at=n(),ye=i("p"),ye.innerHTML=ts,rt=n(),Te=i("p"),Te.textContent=ns,it=n(),Me=i("ul"),Me.innerHTML=ss,mt=n(),ve=i("p"),ve.innerHTML=as,lt=n(),we=i("p"),we.textContent=rs,dt=n(),p(Se.$$.fragment),ct=n(),xe=i("p"),xe.textContent=is,pt=n(),p($e.$$.fragment),ht=n(),p(ke.$$.fragment),gt=n(),ze=i("p"),ze.textContent=ms,ft=n(),Ie=i("ul"),Ie.innerHTML=ls,ut=n(),p(Ce.$$.fragment),_t=n(),je=i("p"),je.innerHTML=ds,bt=n(),Je=i("p"),Je.innerHTML=cs,yt=n(),p(Ne.$$.fragment),Tt=n(),Ue=i("p"),Ue.innerHTML=ps,Mt=n(),Y=i("img"),vt=n(),Pe=i("small"),Pe.innerHTML=gs,wt=n(),p(We.$$.fragment),St=n(),J=i("div"),p(Fe.$$.fragment),Kt=n(),_o=i("p"),_o.innerHTML=fs,en=n(),bo=i("p"),bo.innerHTML=us,on=n(),p(Q.$$.fragment),xt=n(),p(Ze.$$.fragment),$t=n(),N=i("div"),p(Ve.$$.fragment),tn=n(),yo=i("p"),yo.innerHTML=_s,nn=n(),To=i("p"),To.innerHTML=bs,sn=n(),p(O.$$.fragment),kt=n(),p(Le.$$.fragment),zt=n(),F=i("div"),p(Be.$$.fragment),an=n(),Mo=i("p"),Mo.innerHTML=ys,rn=n(),vo=i("p"),vo.innerHTML=Ts,It=n(),p(Ee.$$.fragment),Ct=n(),Z=i("div"),p(Re.$$.fragment),mn=n(),wo=i("p"),wo.innerHTML=Ms,ln=n(),So=i("p"),So.innerHTML=vs,jt=n(),p(De.$$.fragment),Jt=n(),V=i("div"),p(qe.$$.fragment),dn=n(),xo=i("p"),xo.textContent=ws,cn=n(),$o=i("p"),$o.innerHTML=Ss,Nt=n(),p(He.$$.fragment),Ut=n(),v=i("div"),p(Ae.$$.fragment),pn=n(),ko=i("p"),ko.textContent=xs,hn=n(),K=i("div"),p(Xe.$$.fragment),gn=n(),zo=i("p"),zo.innerHTML=$s,fn=n(),ee=i("div"),p(Ge.$$.fragment),un=n(),Io=i("p"),Io.innerHTML=ks,_n=n(),oe=i("div"),p(Ye.$$.fragment),bn=n(),Co=i("p"),Co.innerHTML=zs,yn=n(),te=i("div"),p(Qe.$$.fragment),Tn=n(),jo=i("p"),jo.textContent=Is,Mn=n(),ne=i("div"),p(Oe.$$.fragment),vn=n(),Jo=i("p"),Jo.textContent=Cs,wn=n(),se=i("div"),p(Ke.$$.fragment),Sn=n(),No=i("p"),No.textContent=js,xn=n(),ae=i("div"),p(eo.$$.fragment),$n=n(),Uo=i("p"),Uo.innerHTML=Js,Pt=n(),p(oo.$$.fragment),Wt=n(),I=i("div"),p(to.$$.fragment),kn=n(),Po=i("p"),Po.textContent=Ns,zn=n(),Wo=i("p"),Wo.innerHTML=Us,In=n(),Fo=i("p"),Fo.innerHTML=Ps,Cn=n(),E=i("div"),p(no.$$.fragment),jn=n(),Zo=i("p"),Zo.innerHTML=Ws,Jn=n(),p(re.$$.fragment),Ft=n(),p(so.$$.fragment),Zt=n(),C=i("div"),p(ao.$$.fragment),Nn=n(),Vo=i("p"),Vo.textContent=Fs,Un=n(),Lo=i("p"),Lo.innerHTML=Zs,Pn=n(),Bo=i("p"),Bo.innerHTML=Vs,Wn=n(),W=i("div"),p(ro.$$.fragment),Fn=n(),Eo=i("p"),Eo.innerHTML=Ls,Zn=n(),p(ie.$$.fragment),Vn=n(),p(me.$$.fragment),Vt=n(),p(io.$$.fragment),Lt=n(),U=i("div"),p(mo.$$.fragment),Ln=n(),Ro=i("p"),Ro.innerHTML=Bs,Bn=n(),Do=i("p"),Do.innerHTML=Es,En=n(),R=i("div"),p(lo.$$.fragment),Rn=n(),qo=i("p"),qo.innerHTML=Rs,Dn=n(),p(le.$$.fragment),Bt=n(),p(co.$$.fragment),Et=n(),P=i("div"),p(po.$$.fragment),qn=n(),Ho=i("p"),Ho.innerHTML=Ds,Hn=n(),Ao=i("p"),Ao.innerHTML=qs,An=n(),D=i("div"),p(ho.$$.fragment),Xn=n(),Xo=i("p"),Xo.innerHTML=Hs,Gn=n(),p(de.$$.fragment),Rt=n(),p(go.$$.fragment),Dt=n(),Oo=i("p"),this.h()},l(e){const o=Os("svelte-u9bgzb",document.head);l=m(o,"META",{name:!0,content:!0}),o.forEach(t),M=s(e),b=m(e,"P",{}),w(b).forEach(t),y=s(e),h(S.$$.fragment,e),c=s(e),k=m(e,"DIV",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-ltwe0m"&&(k.innerHTML=Qn),et=s(e),h(ge.$$.fragment,e),ot=s(e),fe=m(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-gruntp"&&(fe.innerHTML=On),tt=s(e),ue=m(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-lkoryj"&&(ue.textContent=Kn),nt=s(e),_e=m(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-8e5g7x"&&(_e.innerHTML=es),st=s(e),be=m(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-vfdo9a"&&(be.textContent=os),at=s(e),ye=m(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1o5y69o"&&(ye.innerHTML=ts),rt=s(e),Te=m(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-axv494"&&(Te.textContent=ns),it=s(e),Me=m(e,"UL",{"data-svelte-h":!0}),d(Me)!=="svelte-wpfy5a"&&(Me.innerHTML=ss),mt=s(e),ve=m(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-3s0ihy"&&(ve.innerHTML=as),lt=s(e),we=m(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-j41zpc"&&(we.textContent=rs),dt=s(e),h(Se.$$.fragment,e),ct=s(e),xe=m(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-eylhz1"&&(xe.textContent=is),pt=s(e),h($e.$$.fragment,e),ht=s(e),h(ke.$$.fragment,e),gt=s(e),ze=m(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-r7mpci"&&(ze.textContent=ms),ft=s(e),Ie=m(e,"UL",{"data-svelte-h":!0}),d(Ie)!=="svelte-su2mt3"&&(Ie.innerHTML=ls),ut=s(e),h(Ce.$$.fragment,e),_t=s(e),je=m(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-a4zcm8"&&(je.innerHTML=ds),bt=s(e),Je=m(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1kuacy9"&&(Je.innerHTML=cs),yt=s(e),h(Ne.$$.fragment,e),Tt=s(e),Ue=m(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-iwaemq"&&(Ue.innerHTML=ps),Mt=s(e),Y=m(e,"IMG",{src:!0,alt:!0,width:!0}),vt=s(e),Pe=m(e,"SMALL",{"data-svelte-h":!0}),d(Pe)!=="svelte-16zie7b"&&(Pe.innerHTML=gs),wt=s(e),h(We.$$.fragment,e),St=s(e),J=m(e,"DIV",{class:!0});var L=w(J);h(Fe.$$.fragment,L),Kt=s(L),_o=m(L,"P",{"data-svelte-h":!0}),d(_o)!=="svelte-1biooea"&&(_o.innerHTML=fs),en=s(L),bo=m(L,"P",{"data-svelte-h":!0}),d(bo)!=="svelte-o55m63"&&(bo.innerHTML=us),on=s(L),h(Q.$$.fragment,L),L.forEach(t),xt=s(e),h(Ze.$$.fragment,e),$t=s(e),N=m(e,"DIV",{class:!0});var B=w(N);h(Ve.$$.fragment,B),tn=s(B),yo=m(B,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-jsjbhk"&&(yo.innerHTML=_s),nn=s(B),To=m(B,"P",{"data-svelte-h":!0}),d(To)!=="svelte-o55m63"&&(To.innerHTML=bs),sn=s(B),h(O.$$.fragment,B),B.forEach(t),kt=s(e),h(Le.$$.fragment,e),zt=s(e),F=m(e,"DIV",{class:!0});var A=w(F);h(Be.$$.fragment,A),an=s(A),Mo=m(A,"P",{"data-svelte-h":!0}),d(Mo)!=="svelte-c8g7g5"&&(Mo.innerHTML=ys),rn=s(A),vo=m(A,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-o55m63"&&(vo.innerHTML=Ts),A.forEach(t),It=s(e),h(Ee.$$.fragment,e),Ct=s(e),Z=m(e,"DIV",{class:!0});var X=w(Z);h(Re.$$.fragment,X),mn=s(X),wo=m(X,"P",{"data-svelte-h":!0}),d(wo)!=="svelte-y6v7jy"&&(wo.innerHTML=Ms),ln=s(X),So=m(X,"P",{"data-svelte-h":!0}),d(So)!=="svelte-o55m63"&&(So.innerHTML=vs),X.forEach(t),jt=s(e),h(De.$$.fragment,e),Jt=s(e),V=m(e,"DIV",{class:!0});var G=w(V);h(qe.$$.fragment,G),dn=s(G),xo=m(G,"P",{"data-svelte-h":!0}),d(xo)!=="svelte-i07qcs"&&(xo.textContent=ws),cn=s(G),$o=m(G,"P",{"data-svelte-h":!0}),d($o)!=="svelte-jhq6r0"&&($o.innerHTML=Ss),G.forEach(t),Nt=s(e),h(He.$$.fragment,e),Ut=s(e),v=m(e,"DIV",{class:!0});var x=w(v);h(Ae.$$.fragment,x),pn=s(x),ko=m(x,"P",{"data-svelte-h":!0}),d(ko)!=="svelte-iyanpn"&&(ko.textContent=xs),hn=s(x),K=m(x,"DIV",{class:!0});var fo=w(K);h(Xe.$$.fragment,fo),gn=s(fo),zo=m(fo,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-jpa0fq"&&(zo.innerHTML=$s),fo.forEach(t),fn=s(x),ee=m(x,"DIV",{class:!0});var Ht=w(ee);h(Ge.$$.fragment,Ht),un=s(Ht),Io=m(Ht,"P",{"data-svelte-h":!0}),d(Io)!=="svelte-1j7xts3"&&(Io.innerHTML=ks),Ht.forEach(t),_n=s(x),oe=m(x,"DIV",{class:!0});var At=w(oe);h(Ye.$$.fragment,At),bn=s(At),Co=m(At,"P",{"data-svelte-h":!0}),d(Co)!=="svelte-1g2f7kg"&&(Co.innerHTML=zs),At.forEach(t),yn=s(x),te=m(x,"DIV",{class:!0});var Xt=w(te);h(Qe.$$.fragment,Xt),Tn=s(Xt),jo=m(Xt,"P",{"data-svelte-h":!0}),d(jo)!=="svelte-wwrho9"&&(jo.textContent=Is),Xt.forEach(t),Mn=s(x),ne=m(x,"DIV",{class:!0});var Gt=w(ne);h(Oe.$$.fragment,Gt),vn=s(Gt),Jo=m(Gt,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-juomob"&&(Jo.textContent=Cs),Gt.forEach(t),wn=s(x),se=m(x,"DIV",{class:!0});var Yt=w(se);h(Ke.$$.fragment,Yt),Sn=s(Yt),No=m(Yt,"P",{"data-svelte-h":!0}),d(No)!=="svelte-1x3yxsa"&&(No.textContent=js),Yt.forEach(t),xn=s(x),ae=m(x,"DIV",{class:!0});var Qt=w(ae);h(eo.$$.fragment,Qt),$n=s(Qt),Uo=m(Qt,"P",{"data-svelte-h":!0}),d(Uo)!=="svelte-1oee9wu"&&(Uo.innerHTML=Js),Qt.forEach(t),x.forEach(t),Pt=s(e),h(oo.$$.fragment,e),Wt=s(e),I=m(e,"DIV",{class:!0});var q=w(I);h(to.$$.fragment,q),kn=s(q),Po=m(q,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-1g2jbi1"&&(Po.textContent=Ns),zn=s(q),Wo=m(q,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-6pahdo"&&(Wo.innerHTML=Us),In=s(q),Fo=m(q,"P",{"data-svelte-h":!0}),d(Fo)!=="svelte-hswkmf"&&(Fo.innerHTML=Ps),Cn=s(q),E=m(q,"DIV",{class:!0});var Go=w(E);h(no.$$.fragment,Go),jn=s(Go),Zo=m(Go,"P",{"data-svelte-h":!0}),d(Zo)!=="svelte-17vcxu4"&&(Zo.innerHTML=Ws),Jn=s(Go),h(re.$$.fragment,Go),Go.forEach(t),q.forEach(t),Ft=s(e),h(so.$$.fragment,e),Zt=s(e),C=m(e,"DIV",{class:!0});var H=w(C);h(ao.$$.fragment,H),Nn=s(H),Vo=m(H,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-1acc5l6"&&(Vo.textContent=Fs),Un=s(H),Lo=m(H,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-6pahdo"&&(Lo.innerHTML=Zs),Pn=s(H),Bo=m(H,"P",{"data-svelte-h":!0}),d(Bo)!=="svelte-hswkmf"&&(Bo.innerHTML=Vs),Wn=s(H),W=m(H,"DIV",{class:!0});var ce=w(W);h(ro.$$.fragment,ce),Fn=s(ce),Eo=m(ce,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-1wwqxlg"&&(Eo.innerHTML=Ls),Zn=s(ce),h(ie.$$.fragment,ce),Vn=s(ce),h(me.$$.fragment,ce),ce.forEach(t),H.forEach(t),Vt=s(e),h(io.$$.fragment,e),Lt=s(e),U=m(e,"DIV",{class:!0});var pe=w(U);h(mo.$$.fragment,pe),Ln=s(pe),Ro=m(pe,"P",{"data-svelte-h":!0}),d(Ro)!=="svelte-wehnf7"&&(Ro.innerHTML=Bs),Bn=s(pe),Do=m(pe,"P",{"data-svelte-h":!0}),d(Do)!=="svelte-224cht"&&(Do.innerHTML=Es),En=s(pe),R=m(pe,"DIV",{class:!0});var Yo=w(R);h(lo.$$.fragment,Yo),Rn=s(Yo),qo=m(Yo,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1swrwf8"&&(qo.innerHTML=Rs),Dn=s(Yo),h(le.$$.fragment,Yo),Yo.forEach(t),pe.forEach(t),Bt=s(e),h(co.$$.fragment,e),Et=s(e),P=m(e,"DIV",{class:!0});var he=w(P);h(po.$$.fragment,he),qn=s(he),Ho=m(he,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-1qudda3"&&(Ho.innerHTML=Ds),Hn=s(he),Ao=m(he,"P",{"data-svelte-h":!0}),d(Ao)!=="svelte-224cht"&&(Ao.innerHTML=qs),An=s(he),D=m(he,"DIV",{class:!0});var Qo=w(D);h(ho.$$.fragment,Qo),Xn=s(Qo),Xo=m(Qo,"P",{"data-svelte-h":!0}),d(Xo)!=="svelte-1dnqt04"&&(Xo.innerHTML=Hs),Gn=s(Qo),h(de.$$.fragment,Qo),Qo.forEach(t),he.forEach(t),Rt=s(e),h(go.$$.fragment,e),Dt=s(e),Oo=m(e,"P",{}),w(Oo).forEach(t),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",ma),T(k,"class","flex flex-wrap space-x-1"),Xs(Y.src,hs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grounded_sam.png")||T(Y,"src",hs),T(Y,"alt","drawing"),T(Y,"width","900"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,l),r(e,M,o),r(e,b,o),r(e,y,o),g(S,e,o),r(e,c,o),r(e,k,o),r(e,et,o),g(ge,e,o),r(e,ot,o),r(e,fe,o),r(e,tt,o),r(e,ue,o),r(e,nt,o),r(e,_e,o),r(e,st,o),r(e,be,o),r(e,at,o),r(e,ye,o),r(e,rt,o),r(e,Te,o),r(e,it,o),r(e,Me,o),r(e,mt,o),r(e,ve,o),r(e,lt,o),r(e,we,o),r(e,dt,o),g(Se,e,o),r(e,ct,o),r(e,xe,o),r(e,pt,o),g($e,e,o),r(e,ht,o),g(ke,e,o),r(e,gt,o),r(e,ze,o),r(e,ft,o),r(e,Ie,o),r(e,ut,o),g(Ce,e,o),r(e,_t,o),r(e,je,o),r(e,bt,o),r(e,Je,o),r(e,yt,o),g(Ne,e,o),r(e,Tt,o),r(e,Ue,o),r(e,Mt,o),r(e,Y,o),r(e,vt,o),r(e,Pe,o),r(e,wt,o),g(We,e,o),r(e,St,o),r(e,J,o),g(Fe,J,null),a(J,Kt),a(J,_o),a(J,en),a(J,bo),a(J,on),g(Q,J,null),r(e,xt,o),g(Ze,e,o),r(e,$t,o),r(e,N,o),g(Ve,N,null),a(N,tn),a(N,yo),a(N,nn),a(N,To),a(N,sn),g(O,N,null),r(e,kt,o),g(Le,e,o),r(e,zt,o),r(e,F,o),g(Be,F,null),a(F,an),a(F,Mo),a(F,rn),a(F,vo),r(e,It,o),g(Ee,e,o),r(e,Ct,o),r(e,Z,o),g(Re,Z,null),a(Z,mn),a(Z,wo),a(Z,ln),a(Z,So),r(e,jt,o),g(De,e,o),r(e,Jt,o),r(e,V,o),g(qe,V,null),a(V,dn),a(V,xo),a(V,cn),a(V,$o),r(e,Nt,o),g(He,e,o),r(e,Ut,o),r(e,v,o),g(Ae,v,null),a(v,pn),a(v,ko),a(v,hn),a(v,K),g(Xe,K,null),a(K,gn),a(K,zo),a(v,fn),a(v,ee),g(Ge,ee,null),a(ee,un),a(ee,Io),a(v,_n),a(v,oe),g(Ye,oe,null),a(oe,bn),a(oe,Co),a(v,yn),a(v,te),g(Qe,te,null),a(te,Tn),a(te,jo),a(v,Mn),a(v,ne),g(Oe,ne,null),a(ne,vn),a(ne,Jo),a(v,wn),a(v,se),g(Ke,se,null),a(se,Sn),a(se,No),a(v,xn),a(v,ae),g(eo,ae,null),a(ae,$n),a(ae,Uo),r(e,Pt,o),g(oo,e,o),r(e,Wt,o),r(e,I,o),g(to,I,null),a(I,kn),a(I,Po),a(I,zn),a(I,Wo),a(I,In),a(I,Fo),a(I,Cn),a(I,E),g(no,E,null),a(E,jn),a(E,Zo),a(E,Jn),g(re,E,null),r(e,Ft,o),g(so,e,o),r(e,Zt,o),r(e,C,o),g(ao,C,null),a(C,Nn),a(C,Vo),a(C,Un),a(C,Lo),a(C,Pn),a(C,Bo),a(C,Wn),a(C,W),g(ro,W,null),a(W,Fn),a(W,Eo),a(W,Zn),g(ie,W,null),a(W,Vn),g(me,W,null),r(e,Vt,o),g(io,e,o),r(e,Lt,o),r(e,U,o),g(mo,U,null),a(U,Ln),a(U,Ro),a(U,Bn),a(U,Do),a(U,En),a(U,R),g(lo,R,null),a(R,Rn),a(R,qo),a(R,Dn),g(le,R,null),r(e,Bt,o),g(co,e,o),r(e,Et,o),r(e,P,o),g(po,P,null),a(P,qn),a(P,Ho),a(P,Hn),a(P,Ao),a(P,An),a(P,D),g(ho,D,null),a(D,Xn),a(D,Xo),a(D,Gn),g(de,D,null),r(e,Rt,o),g(go,e,o),r(e,Dt,o),r(e,Oo,o),qt=!0},p(e,[o]){const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),Q.$set(L);const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),O.$set(B);const A={};o&2&&(A.$$scope={dirty:o,ctx:e}),re.$set(A);const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),ie.$set(X);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),me.$set(G);const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),le.$set(x);const fo={};o&2&&(fo.$$scope={dirty:o,ctx:e}),de.$set(fo)},i(e){qt||(f(S.$$.fragment,e),f(ge.$$.fragment,e),f(Se.$$.fragment,e),f($e.$$.fragment,e),f(ke.$$.fragment,e),f(Ce.$$.fragment,e),f(Ne.$$.fragment,e),f(We.$$.fragment,e),f(Fe.$$.fragment,e),f(Q.$$.fragment,e),f(Ze.$$.fragment,e),f(Ve.$$.fragment,e),f(O.$$.fragment,e),f(Le.$$.fragment,e),f(Be.$$.fragment,e),f(Ee.$$.fragment,e),f(Re.$$.fragment,e),f(De.$$.fragment,e),f(qe.$$.fragment,e),f(He.$$.fragment,e),f(Ae.$$.fragment,e),f(Xe.$$.fragment,e),f(Ge.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(eo.$$.fragment,e),f(oo.$$.fragment,e),f(to.$$.fragment,e),f(no.$$.fragment,e),f(re.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(ro.$$.fragment,e),f(ie.$$.fragment,e),f(me.$$.fragment,e),f(io.$$.fragment,e),f(mo.$$.fragment,e),f(lo.$$.fragment,e),f(le.$$.fragment,e),f(co.$$.fragment,e),f(po.$$.fragment,e),f(ho.$$.fragment,e),f(de.$$.fragment,e),f(go.$$.fragment,e),qt=!0)},o(e){u(S.$$.fragment,e),u(ge.$$.fragment,e),u(Se.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(Ne.$$.fragment,e),u(We.$$.fragment,e),u(Fe.$$.fragment,e),u(Q.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(O.$$.fragment,e),u(Le.$$.fragment,e),u(Be.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(De.$$.fragment,e),u(qe.$$.fragment,e),u(He.$$.fragment,e),u(Ae.$$.fragment,e),u(Xe.$$.fragment,e),u(Ge.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(eo.$$.fragment,e),u(oo.$$.fragment,e),u(to.$$.fragment,e),u(no.$$.fragment,e),u(re.$$.fragment,e),u(so.$$.fragment,e),u(ao.$$.fragment,e),u(ro.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(io.$$.fragment,e),u(mo.$$.fragment,e),u(lo.$$.fragment,e),u(le.$$.fragment,e),u(co.$$.fragment,e),u(po.$$.fragment,e),u(ho.$$.fragment,e),u(de.$$.fragment,e),u(go.$$.fragment,e),qt=!1},d(e){e&&(t(M),t(b),t(y),t(c),t(k),t(et),t(ot),t(fe),t(tt),t(ue),t(nt),t(_e),t(st),t(be),t(at),t(ye),t(rt),t(Te),t(it),t(Me),t(mt),t(ve),t(lt),t(we),t(dt),t(ct),t(xe),t(pt),t(ht),t(gt),t(ze),t(ft),t(Ie),t(ut),t(_t),t(je),t(bt),t(Je),t(yt),t(Tt),t(Ue),t(Mt),t(Y),t(vt),t(Pe),t(wt),t(St),t(J),t(xt),t($t),t(N),t(kt),t(zt),t(F),t(It),t(Ct),t(Z),t(jt),t(Jt),t(V),t(Nt),t(Ut),t(v),t(Pt),t(Wt),t(I),t(Ft),t(Zt),t(C),t(Vt),t(Lt),t(U),t(Bt),t(Et),t(P),t(Rt),t(Dt),t(Oo)),t(l),_(S,e),_(ge,e),_(Se,e),_($e,e),_(ke,e),_(Ce,e),_(Ne,e),_(We,e),_(Fe),_(Q),_(Ze,e),_(Ve),_(O),_(Le,e),_(Be),_(Ee,e),_(Re),_(De,e),_(qe),_(He,e),_(Ae),_(Xe),_(Ge),_(Ye),_(Qe),_(Oe),_(Ke),_(eo),_(oo,e),_(to),_(no),_(re),_(so,e),_(ao),_(ro),_(ie),_(me),_(io,e),_(mo),_(lo),_(le),_(co,e),_(po),_(ho),_(de),_(go,e)}}}const ma='{"title":"SAM","local":"sam","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SlimSAM","local":"slimsam","sections":[],"depth":2},{"title":"Grounded SAM","local":"grounded-sam","sections":[],"depth":2},{"title":"SamConfig","local":"transformers.SamConfig","sections":[],"depth":2},{"title":"SamVisionConfig","local":"transformers.SamVisionConfig","sections":[],"depth":2},{"title":"SamMaskDecoderConfig","local":"transformers.SamMaskDecoderConfig","sections":[],"depth":2},{"title":"SamPromptEncoderConfig","local":"transformers.SamPromptEncoderConfig","sections":[],"depth":2},{"title":"SamProcessor","local":"transformers.SamProcessor","sections":[],"depth":2},{"title":"SamImageProcessor","local":"transformers.SamImageProcessor","sections":[],"depth":2},{"title":"SamVisionModel","local":"transformers.SamVisionModel","sections":[],"depth":2},{"title":"SamModel","local":"transformers.SamModel","sections":[],"depth":2},{"title":"TFSamVisionModel","local":"transformers.TFSamVisionModel","sections":[],"depth":2},{"title":"TFSamModel","local":"transformers.TFSamModel","sections":[],"depth":2}],"depth":1}';function la(z){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends Ys{constructor(l){super(),Qs(this,l,la,ia,As,{})}}export{ba as component};
