import{s as Wn,o as Zn,n as kt}from"../chunks/scheduler.18a86fab.js";import{S as Vn,i as qn,g as r,s,r as p,A as Fn,h as i,f as n,c as a,j as x,u as h,x as d,k as j,y as l,a as o,v as f,d as u,t as g,w as _}from"../chunks/index.98837b22.js";import{T as zn}from"../chunks/Tip.77304350.js";import{D as R}from"../chunks/Docstring.6758ea23.js";import{C as $t}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as In}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as V}from"../chunks/Heading.7e7e0c5b.js";import{E as Xn}from"../chunks/getInferenceSnippets.de10bc7d.js";function Rn(z){let m,w="Example:",b,y,M;return y=new $t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTYW1IUVZpc2lvbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFNhbUhRVmlzaW9uTW9kZWwlMkMlMEEpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNhbUhRVmlzaW9uQ29uZmlnJTIwd2l0aCUyMCU2MCUyMmZhY2Vib29rJTJGc2FtX2hxLXZpdC1odWdlJTIyJTYwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNhbUhRVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2FtSFFWaXNpb25Nb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwJTYwJTIyZmFjZWJvb2slMkZzYW1faHEtdml0LWh1Z2UlMjIlNjAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFNhbUhRVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SamHQVisionConfig,
<span class="hljs-meta">... </span>    SamHQVisionModel,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamHQVisionConfig with \`&quot;facebook/sam_hq-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SamHQVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SamHQVisionModel (with random weights) from the \`&quot;facebook/sam_hq-vit-huge&quot;\` style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SamHQVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m=r("p"),m.textContent=w,b=s(),p(y.$$.fragment)},l(c){m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-11lpom8"&&(m.textContent=w),b=a(c),h(y.$$.fragment,c)},m(c,T){o(c,m,T),o(c,b,T),f(y,c,T),M=!0},p:kt,i(c){M||(u(y.$$.fragment,c),M=!0)},o(c){g(y.$$.fragment,c),M=!1},d(c){c&&(n(m),n(b)),_(y,c)}}}function Bn(z){let m,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=r("p"),m.innerHTML=w},l(b){m=i(b,"P",{"data-svelte-h":!0}),d(m)!=="svelte-fincs2"&&(m.innerHTML=w)},m(b,y){o(b,m,y)},p:kt,d(b){b&&n(m)}}}function Nn(z){let m,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=r("p"),m.innerHTML=w},l(b){m=i(b,"P",{"data-svelte-h":!0}),d(m)!=="svelte-fincs2"&&(m.innerHTML=w)},m(b,y){o(b,m,y)},p:kt,d(b){b&&n(m)}}}function En(z){let m,w="Example:",b,y,M;return y=new $t({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdXNobWFudGglMkZzYW1faHFfdml0X2IlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzaG1hbnRoJTJGc2FtX2hxX3ZpdF9iJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbF9kb2MlMkZzYW0tY2FyLnBuZyUyMiUwQXJhd19pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWlucHV0X3BvaW50cyUyMCUzRCUyMCU1QiU1QiU1QjQwMCUyQyUyMDY1MCU1RCU1RCU1RCUyMCUyMCUyMyUyMDJEJTIwbG9jYXRpb24lMjBvZiUyMGElMjB3aW5kb3clMjBvbiUyMHRoZSUyMGNhciUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RyYXdfaW1hZ2UlMkMlMjBpbnB1dF9wb2ludHMlM0RpbnB1dF9wb2ludHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdldCUyMGhpZ2gtcXVhbGl0eSUyMHNlZ21lbnRhdGlvbiUyMG1hc2slMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwRm9yJTIwaGlnaC1xdWFsaXR5JTIwbWFzayUyMG9ubHklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBocV90b2tlbl9vbmx5JTNEVHJ1ZSklMEElMEElMjMlMjBQb3N0cHJvY2VzcyUyMG1hc2tzJTBBbWFza3MlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMucHJlZF9tYXNrcyUyQyUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVEJTJDJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;sushmanth/sam_hq_vit_b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;sushmanth/sam_hq_vit_b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/sam-car.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_points = [[[<span class="hljs-number">400</span>, <span class="hljs-number">650</span>]]]  <span class="hljs-comment"># 2D location of a window on the car</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=raw_image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get high-quality segmentation mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For high-quality mask only</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, hq_token_only=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Postprocess masks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>masks = processor.post_process_masks(
<span class="hljs-meta">... </span>    outputs.pred_masks, inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>], inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){m=r("p"),m.textContent=w,b=s(),p(y.$$.fragment)},l(c){m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-11lpom8"&&(m.textContent=w),b=a(c),h(y.$$.fragment,c)},m(c,T){o(c,m,T),o(c,b,T),f(y,c,T),M=!0},p:kt,i(c){M||(u(y.$$.fragment,c),M=!0)},o(c){g(y.$$.fragment,c),M=!1},d(c){c&&(n(m),n(b)),_(y,c)}}}function Pn(z){let m,w,b,y,M,c,T,Ge,L,tn='SAM-HQ (High-Quality Segment Anything Model) was proposed in <a href="https://arxiv.org/pdf/2306.01567.pdf" rel="nofollow">Segment Anything in High Quality</a> by Lei Ke, Mingqiao Ye, Martin Danelljan, Yifan Liu, Yu-Wing Tai, Chi-Keung Tang, Fisher Yu.',Ae,G,nn="The model is an enhancement to the original SAM model that produces significantly higher quality segmentation masks while maintaining SAM’s original promptable design, efficiency, and zero-shot generalizability.",De,A,on='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/sam-output.png" alt="example image"/>',Ke,D,sn="SAM-HQ introduces several key improvements over the original SAM model:",Oe,K,an="<li>High-Quality Output Token: A learnable token injected into SAM’s mask decoder for higher quality mask prediction</li> <li>Global-local Feature Fusion: Combines features from different stages of the model for improved mask details</li> <li>Training Data: Uses a carefully curated dataset of 44K high-quality masks instead of SA-1B</li> <li>Efficiency: Adds only 0.5% additional parameters while significantly improving mask quality</li> <li>Zero-shot Capability: Maintains SAM’s strong zero-shot performance while improving accuracy</li>",et,O,rn="The abstract from the paper is the following:",tt,ee,ln="<em>The recent Segment Anything Model (SAM) represents a big leap in scaling up segmentation models, allowing for powerful zero-shot capabilities and flexible prompting. Despite being trained with 1.1 billion masks, SAM’s mask prediction quality falls short in many cases, particularly when dealing with objects that have intricate structures. We propose HQ-SAM, equipping SAM with the ability to accurately segment any object, while maintaining SAM’s original promptable design, efficiency, and zero-shot generalizability. Our careful design reuses and preserves the pre-trained model weights of SAM, while only introducing minimal additional parameters and computation. We design a learnable High-Quality Output Token, which is injected into SAM’s mask decoder and is responsible for predicting the high-quality mask. Instead of only applying it on mask-decoder features, we first fuse them with early and final ViT features for improved mask details. To train our introduced learnable parameters, we compose a dataset of 44K fine-grained masks from several sources. HQ-SAM is only trained on the introduced dataset of 44k masks, which takes only 4 hours on 8 GPUs.</em>",nt,te,mn="Tips:",ot,ne,dn="<li>SAM-HQ produces higher quality masks than the original SAM model, particularly for objects with intricate structures and fine details</li> <li>The model predicts binary masks with more accurate boundaries and better handling of thin structures</li> <li>Like SAM, the model performs better with input 2D points and/or input bounding boxes</li> <li>You can prompt multiple points for the same image and predict a single high-quality mask</li> <li>The model maintains SAM’s zero-shot generalization capabilities</li> <li>SAM-HQ only adds ~0.5% additional parameters compared to SAM</li> <li>Fine-tuning the model is not supported yet</li>",st,oe,cn=`This model was contributed by <a href="https://huggingface.co/sushmanth" rel="nofollow">sushmanth</a>.
The original code can be found <a href="https://github.com/SysCV/SAM-HQ" rel="nofollow">here</a>.`,at,se,pn="Below is an example on how to run mask generation given an image and a 2D point:",rt,ae,it,re,hn="You can also process your own masks alongside the input images in the processor to be passed to the model:",lt,ie,mt,le,dt,me,fn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SAM-HQ:",ct,de,un='<li>Demo notebook for using the model (coming soon)</li> <li>Paper implementation and code: <a href="https://github.com/SysCV/SAM-HQ" rel="nofollow">SAM-HQ GitHub Repository</a></li>',pt,ce,ht,Q,pe,Ut,Je,gn=`<a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQConfig">SamHQConfig</a> is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQModel">SamHQModel</a>. It is used to instantiate a
SAM-HQ model according to the specified arguments, defining the vision model, prompt-encoder model and mask decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the
SAM-HQ-ViT-H <a href="https://huggingface.co/sushmanth/sam_hq_vit_h" rel="nofollow">sushmanth/sam_hq_vit_h</a> architecture.`,xt,$e,_n=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ft,he,ut,S,fe,jt,ke,bn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQVisionModel">SamHQVisionModel</a>. It is used to instantiate a SAM_HQ
vision encoder according to the specified arguments, defining the model architecture. Instantiating a configuration
defaults will yield a similar configuration to that of the SAM_HQ ViT-h
<a href="https://huggingface.co/facebook/sam_hq-vit-huge" rel="nofollow">facebook/sam_hq-vit-huge</a> architecture.`,zt,Ue,yn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,It,B,gt,ue,_t,J,ge,Wt,xe,Mn=`This is the configuration class to store the configuration of a <code>SamHQMaskDecoder</code>. It is used to instantiate a SAM_HQ
mask decoder to the specified arguments, defining the model architecture. Instantiating a configuration defaults
will yield a similar configuration to that of the SAM_HQ-vit-h
<a href="https://huggingface.co/facebook/sam_hq-vit-huge" rel="nofollow">facebook/sam_hq-vit-huge</a> architecture.`,Zt,je,wn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,bt,_e,yt,$,be,Vt,ze,Tn=`This is the configuration class to store the configuration of a <code>SamHQPromptEncoderModel</code>.The <code>SamHQPromptEncoderModel</code>
module is used to encode the input 2D points and bounding boxes. Instantiating a configuration defaults will yield a
similar configuration to that of the SAM_HQ model. The configuration is used to store the configuration of the model.
<a href="https://huggingface.co/Uminosachi/sam-hq" rel="nofollow">Uminosachi/sam-hq</a> architecture.`,qt,Ie,vn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model’s output.Read the documentation from
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mt,ye,wt,k,Me,Ft,We,Hn=`Constructs a SAM HQ processor which wraps a SAM  image processor and an 2D points & Bounding boxes processor into a
single processor.`,Xt,Ze,Sn=`<a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQProcessor">SamHQProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a>. See the docstring of
<a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__"><strong>call</strong>()</a> for more information.`,Tt,we,vt,v,Te,Rt,Ve,Cn="The vision model from SamHQ without any head or projection on top.",Bt,qe,Qn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Nt,Fe,Jn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,I,ve,Pt,Xe,$n='The <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQVisionModel">SamHQVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Yt,N,Ht,He,St,H,Se,Lt,Re,kn="Segment Anything Model HQ (SAM-HQ) for generating masks, given an input image and optional 2D location and bounding boxes.",Gt,Be,Un=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,At,Ne,xn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Dt,C,Ce,Kt,Ee,jn='The <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQModel">SamHQModel</a> forward method, overrides the <code>__call__</code> special method.',Ot,E,en,P,Ct,Qe,Qt,Le,Jt;return M=new V({props:{title:"SAM-HQ",local:"sam-hq",headingTag:"h1"}}),T=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new $t({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTYW1IUU1vZGVsJTJDJTIwU2FtSFFQcm9jZXNzb3IlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwU2FtSFFNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3lzY3YtY29tbXVuaXR5JTJGc2FtLWhxLXZpdC1iYXNlJTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU2FtSFFQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN5c2N2LWNvbW11bml0eSUyRnNhbS1ocS12aXQtYmFzZSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnliZWxrYWRhJTJGc2VnbWVudC1hbnl0aGluZyUyRnJlc29sdmUlMkZtYWluJTJGYXNzZXRzJTJGY2FyLnBuZyUyMiUwQXJhd19pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWlucHV0X3BvaW50cyUyMCUzRCUyMCU1QiU1QiU1QjQ1MCUyQyUyMDYwMCU1RCU1RCU1RCUyMCUyMCUyMyUyMDJEJTIwbG9jYXRpb24lMjBvZiUyMGElMjB3aW5kb3clMjBpbiUyMHRoZSUyMGltYWdlJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHJhd19pbWFnZSUyQyUyMGlucHV0X3BvaW50cyUzRGlucHV0X3BvaW50cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW1hc2tzJTIwJTNEJTIwcHJvY2Vzc29yLmltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfbWFza3MoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cy5wcmVkX21hc2tzLmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIyb3JpZ2luYWxfc2l6ZXMlMjIlNUQuY3B1KCklMkMlMjBpbnB1dHMlNUIlMjJyZXNoYXBlZF9pbnB1dF9zaXplcyUyMiU1RC5jcHUoKSUwQSklMEFzY29yZXMlMjAlM0QlMjBvdXRwdXRzLmlvdV9zY29yZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamHQModel, SamHQProcessor

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
model = SamHQModel.from_pretrained(<span class="hljs-string">&quot;syscv-community/sam-hq-vit-base&quot;</span>).to(device)
processor = SamHQProcessor.from_pretrained(<span class="hljs-string">&quot;syscv-community/sam-hq-vit-base&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
input_points = [[[<span class="hljs-number">450</span>, <span class="hljs-number">600</span>]]]  <span class="hljs-comment"># 2D location of a window in the image</span>

inputs = processor(raw_image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

masks = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)
scores = outputs.iou_scores`,wrap:!1}}),ie=new $t({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTYW1IUU1vZGVsJTJDJTIwU2FtSFFQcm9jZXNzb3IlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwU2FtSFFNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3lzY3YtY29tbXVuaXR5JTJGc2FtLWhxLXZpdC1iYXNlJTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU2FtSFFQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN5c2N2LWNvbW11bml0eSUyRnNhbS1ocS12aXQtYmFzZSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnliZWxrYWRhJTJGc2VnbWVudC1hbnl0aGluZyUyRnJlc29sdmUlMkZtYWluJTJGYXNzZXRzJTJGY2FyLnBuZyUyMiUwQXJhd19pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnliZWxrYWRhJTJGc2VnbWVudC1hbnl0aGluZyUyRnJlc29sdmUlMkZtYWluJTJGYXNzZXRzJTJGY2FyLnBuZyUyMiUwQXNlZ21lbnRhdGlvbl9tYXAlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChtYXNrX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjIxJTIyKSUwQWlucHV0X3BvaW50cyUyMCUzRCUyMCU1QiU1QiU1QjQ1MCUyQyUyMDYwMCU1RCU1RCU1RCUyMCUyMCUyMyUyMDJEJTIwbG9jYXRpb24lMjBvZiUyMGElMjB3aW5kb3clMjBpbiUyMHRoZSUyMGltYWdlJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHJhd19pbWFnZSUyQyUyMGlucHV0X3BvaW50cyUzRGlucHV0X3BvaW50cyUyQyUyMHNlZ21lbnRhdGlvbl9tYXBzJTNEc2VnbWVudGF0aW9uX21hcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW1hc2tzJTIwJTNEJTIwcHJvY2Vzc29yLmltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfbWFza3MoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cy5wcmVkX21hc2tzLmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIyb3JpZ2luYWxfc2l6ZXMlMjIlNUQuY3B1KCklMkMlMjBpbnB1dHMlNUIlMjJyZXNoYXBlZF9pbnB1dF9zaXplcyUyMiU1RC5jcHUoKSUwQSklMEFzY29yZXMlMjAlM0QlMjBvdXRwdXRzLmlvdV9zY29yZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamHQModel, SamHQProcessor

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
model = SamHQModel.from_pretrained(<span class="hljs-string">&quot;syscv-community/sam-hq-vit-base&quot;</span>).to(device)
processor = SamHQProcessor.from_pretrained(<span class="hljs-string">&quot;syscv-community/sam-hq-vit-base&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_url = <span class="hljs-string">&quot;https://huggingface.co/ybelkada/segment-anything/resolve/main/assets/car.png&quot;</span>
segmentation_map = Image.<span class="hljs-built_in">open</span>(requests.get(mask_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;1&quot;</span>)
input_points = [[[<span class="hljs-number">450</span>, <span class="hljs-number">600</span>]]]  <span class="hljs-comment"># 2D location of a window in the image</span>

inputs = processor(raw_image, input_points=input_points, segmentation_maps=segmentation_map, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

masks = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)
scores = outputs.iou_scores`,wrap:!1}}),le=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ce=new V({props:{title:"SamHQConfig",local:"transformers.SamHQConfig",headingTag:"h2"}}),pe=new R({props:{name:"class transformers.SamHQConfig",anchor:"transformers.SamHQConfig",parameters:[{name:"vision_config",val:" = None"},{name:"prompt_encoder_config",val:" = None"},{name:"mask_decoder_config",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamHQConfig.vision_config",description:`<strong>vision_config</strong> (Union[<code>dict</code>, <code>SamHQVisionConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQVisionConfig">SamHQVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.SamHQConfig.prompt_encoder_config",description:`<strong>prompt_encoder_config</strong> (Union[<code>dict</code>, <code>SamHQPromptEncoderConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQPromptEncoderConfig">SamHQPromptEncoderConfig</a>.`,name:"prompt_encoder_config"},{anchor:"transformers.SamHQConfig.mask_decoder_config",description:`<strong>mask_decoder_config</strong> (Union[<code>dict</code>, <code>SamHQMaskDecoderConfig</code>], <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQMaskDecoderConfig">SamHQMaskDecoderConfig</a>.`,name:"mask_decoder_config"},{anchor:"transformers.SamHQConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/configuration_sam_hq.py#L261"}}),he=new V({props:{title:"SamHQVisionConfig",local:"transformers.SamHQVisionConfig",headingTag:"h2"}}),fe=new R({props:{name:"class transformers.SamHQVisionConfig",anchor:"transformers.SamHQVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"output_channels",val:" = 256"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 1e-10"},{name:"qkv_bias",val:" = True"},{name:"mlp_ratio",val:" = 4.0"},{name:"use_abs_pos",val:" = True"},{name:"use_rel_pos",val:" = True"},{name:"window_size",val:" = 14"},{name:"global_attn_indexes",val:" = [2, 5, 8, 11]"},{name:"num_pos_feats",val:" = 128"},{name:"mlp_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamHQVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SamHQVisionConfig.output_channels",description:`<strong>output_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output channels in the Patch Encoder.`,name:"output_channels"},{anchor:"transformers.SamHQVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SamHQVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SamHQVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.SamHQVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Expected resolution. Target size of the resized input image.`,name:"image_size"},{anchor:"transformers.SamHQVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Size of the patches to be extracted from the input image.`,name:"patch_size"},{anchor:"transformers.SamHQVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string)`,name:"hidden_act"},{anchor:"transformers.SamHQVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SamHQVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.SamHQVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-10) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SamHQVisionConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to query, key, value projections.`,name:"qkv_bias"},{anchor:"transformers.SamHQVisionConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of mlp hidden dim to embedding dim.`,name:"mlp_ratio"},{anchor:"transformers.SamHQVisionConfig.use_abs_pos",description:`<strong>use_abs_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use absolute position embedding.`,name:"use_abs_pos"},{anchor:"transformers.SamHQVisionConfig.use_rel_pos",description:`<strong>use_rel_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use relative position embedding.`,name:"use_rel_pos"},{anchor:"transformers.SamHQVisionConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Window size for relative position.`,name:"window_size"},{anchor:"transformers.SamHQVisionConfig.global_attn_indexes",description:`<strong>global_attn_indexes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
The indexes of the global attention layers.`,name:"global_attn_indexes"},{anchor:"transformers.SamHQVisionConfig.num_pos_feats",description:`<strong>num_pos_feats</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The dimensionality of the position embedding.`,name:"num_pos_feats"},{anchor:"transformers.SamHQVisionConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The dimensionality of the MLP layer in the Transformer encoder. If <code>None</code>, defaults to <code>mlp_ratio * hidden_size</code>.`,name:"mlp_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/configuration_sam_hq.py#L75"}}),B=new In({props:{anchor:"transformers.SamHQVisionConfig.example",$$slots:{default:[Rn]},$$scope:{ctx:z}}}),ue=new V({props:{title:"SamHQMaskDecoderConfig",local:"transformers.SamHQMaskDecoderConfig",headingTag:"h2"}}),ge=new R({props:{name:"class transformers.SamHQMaskDecoderConfig",anchor:"transformers.SamHQMaskDecoderConfig",parameters:[{name:"hidden_size",val:" = 256"},{name:"hidden_act",val:" = 'relu'"},{name:"mlp_dim",val:" = 2048"},{name:"num_hidden_layers",val:" = 2"},{name:"num_attention_heads",val:" = 8"},{name:"attention_downsample_rate",val:" = 2"},{name:"num_multimask_outputs",val:" = 3"},{name:"iou_head_depth",val:" = 3"},{name:"iou_head_hidden_dim",val:" = 256"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"vit_dim",val:" = 768"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamHQMaskDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the hidden states.`,name:"hidden_size"},{anchor:"transformers.SamHQMaskDecoderConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function used inside the <code>SamHQMaskDecoder</code> module.`,name:"hidden_act"},{anchor:"transformers.SamHQMaskDecoderConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"mlp_dim"},{anchor:"transformers.SamHQMaskDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SamHQMaskDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SamHQMaskDecoderConfig.attention_downsample_rate",description:`<strong>attention_downsample_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The downsampling rate of the attention layer.`,name:"attention_downsample_rate"},{anchor:"transformers.SamHQMaskDecoderConfig.num_multimask_outputs",description:`<strong>num_multimask_outputs</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of outputs from the <code>SamHQMaskDecoder</code> module. In the Segment Anything paper, this is set to 3.`,name:"num_multimask_outputs"},{anchor:"transformers.SamHQMaskDecoderConfig.iou_head_depth",description:`<strong>iou_head_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of layers in the IoU head module.`,name:"iou_head_depth"},{anchor:"transformers.SamHQMaskDecoderConfig.iou_head_hidden_dim",description:`<strong>iou_head_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The dimensionality of the hidden states in the IoU head module.`,name:"iou_head_hidden_dim"},{anchor:"transformers.SamHQMaskDecoderConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/configuration_sam_hq.py#L193"}}),_e=new V({props:{title:"SamHQPromptEncoderConfig",local:"transformers.SamHQPromptEncoderConfig",headingTag:"h2"}}),be=new R({props:{name:"class transformers.SamHQPromptEncoderConfig",anchor:"transformers.SamHQPromptEncoderConfig",parameters:[{name:"hidden_size",val:" = 256"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"mask_input_channels",val:" = 16"},{name:"num_point_embeddings",val:" = 4"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamHQPromptEncoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the hidden states.`,name:"hidden_size"},{anchor:"transformers.SamHQPromptEncoderConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The expected output resolution of the image.`,name:"image_size"},{anchor:"transformers.SamHQPromptEncoderConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SamHQPromptEncoderConfig.mask_input_channels",description:`<strong>mask_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of channels to be fed to the <code>MaskDecoder</code> module.`,name:"mask_input_channels"},{anchor:"transformers.SamHQPromptEncoderConfig.num_point_embeddings",description:`<strong>num_point_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of point embeddings to be used.`,name:"num_point_embeddings"},{anchor:"transformers.SamHQPromptEncoderConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function in the encoder and pooler.`,name:"hidden_act"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/configuration_sam_hq.py#L26"}}),ye=new V({props:{title:"SamHQProcessor",local:"transformers.SamHQProcessor",headingTag:"h2"}}),Me=new R({props:{name:"class transformers.SamHQProcessor",anchor:"transformers.SamHQProcessor",parameters:[{name:"image_processor",val:""}],parametersDescription:[{anchor:"transformers.SamHQProcessor.image_processor",description:`<strong>image_processor</strong> (<code>SamImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a>. The image processor is a required input.`,name:"image_processor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/processing_samhq.py#L52"}}),we=new V({props:{title:"SamHQVisionModel",local:"transformers.SamHQVisionModel",headingTag:"h2"}}),Te=new R({props:{name:"class transformers.SamHQVisionModel",anchor:"transformers.SamHQVisionModel",parameters:[{name:"config",val:": SamHQVisionConfig"}],parametersDescription:[{anchor:"transformers.SamHQVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQVisionConfig">SamHQVisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/modeling_sam_hq.py#L1148"}}),ve=new R({props:{name:"forward",anchor:"transformers.SamHQVisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SamHQVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SamHQVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SamHQVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SamHQVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/modeling_sam_hq.py#L1167",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.sam_hq.modeling_sam_hq.SamHQVisionEncoderOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQConfig"
>SamHQConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim)</code> <em>optional</em> returned when model is initialized with <code>with_projection=True</code>) — The image embeddings obtained by applying the projection layer to the pooler_output.</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>intermediate_embeddings</strong> (<code>list(torch.FloatTensor)</code>, <em>optional</em>) — A list of intermediate embeddings collected from certain blocks within the model, typically those without
windowed attention. Each element in the list is of shape <code>(batch_size, sequence_length, hidden_size)</code>.
This is specific to SAM-HQ and not present in base SAM.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.sam_hq.modeling_sam_hq.SamHQVisionEncoderOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new zn({props:{$$slots:{default:[Bn]},$$scope:{ctx:z}}}),He=new V({props:{title:"SamHQModel",local:"transformers.SamHQModel",headingTag:"h2"}}),Se=new R({props:{name:"class transformers.SamHQModel",anchor:"transformers.SamHQModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SamHQModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sam_hq#transformers.SamHQModel">SamHQModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/modeling_sam_hq.py#L1346"}}),Ce=new R({props:{name:"forward",anchor:"transformers.SamHQModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_points",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"input_boxes",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_masks",val:": typing.Optional[torch.LongTensor] = None"},{name:"image_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"multimask_output",val:": bool = True"},{name:"hq_token_only",val:": bool = False"},{name:"attention_similarity",val:": typing.Optional[torch.FloatTensor] = None"},{name:"target_embedding",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"intermediate_embeddings",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SamHQModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SamHQModel.forward.input_points",description:`<strong>input_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_points, 2)</code>) &#x2014;
Input 2D spatial points, this is used by the prompt encoder to encode the prompt. Generally yields to much
better results. The points can be obtained by passing a list of list of list to the processor that will
create corresponding <code>torch</code> tensors of dimension 4. The first dimension is the image batch size, the
second dimension is the point batch size (i.e. how many segmentation masks do we want the model to predict
per input point), the third dimension is the number of points per segmentation mask (it is possible to pass
multiple points for a single mask), and the last dimension is the x (vertical) and y (horizontal)
coordinates of the point. If a different number of points is passed either for each image, or for each
mask, the processor will create &#x201C;PAD&#x201D; points that will correspond to the (0, 0) coordinate, and the
computation of the embedding will be skipped for these points using the labels.`,name:"input_points"},{anchor:"transformers.SamHQModel.forward.input_labels",description:`<strong>input_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, point_batch_size, num_points)</code>) &#x2014;
Input labels for the points, this is used by the prompt encoder to encode the prompt. According to the
official implementation, there are 3 types of labels</p>
<ul>
<li><code>1</code>: the point is a point that contains the object of interest</li>
<li><code>0</code>: the point is a point that does not contain the object of interest</li>
<li><code>-1</code>: the point corresponds to the background</li>
</ul>
<p>We added the label:</p>
<ul>
<li><code>-10</code>: the point is a padding point, thus should be ignored by the prompt encoder</li>
</ul>
<p>The padding labels should be automatically done by the processor.`,name:"input_labels"},{anchor:"transformers.SamHQModel.forward.input_boxes",description:`<strong>input_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_boxes, 4)</code>) &#x2014;
Input boxes for the points, this is used by the prompt encoder to encode the prompt. Generally yields to
much better generated masks. The boxes can be obtained by passing a list of list of list to the processor,
that will generate a <code>torch</code> tensor, with each dimension corresponding respectively to the image batch
size, the number of boxes per image and the coordinates of the top left and bottom right point of the box.
In the order (<code>x1</code>, <code>y1</code>, <code>x2</code>, <code>y2</code>):</p>
<ul>
<li><code>x1</code>: the x coordinate of the top left point of the input box</li>
<li><code>y1</code>: the y coordinate of the top left point of the input box</li>
<li><code>x2</code>: the x coordinate of the bottom right point of the input box</li>
<li><code>y2</code>: the y coordinate of the bottom right point of the input box</li>
</ul>`,name:"input_boxes"},{anchor:"transformers.SamHQModel.forward.input_masks",description:`<strong>input_masks</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, image_size, image_size)</code>) &#x2014;
SAM_HQ model also accepts segmentation masks as input. The mask will be embedded by the prompt encoder to
generate a corresponding embedding, that will be fed later on to the mask decoder. These masks needs to be
manually fed by the user, and they need to be of shape (<code>batch_size</code>, <code>image_size</code>, <code>image_size</code>).`,name:"input_masks"},{anchor:"transformers.SamHQModel.forward.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_channels, window_size, window_size)</code>) &#x2014;
Image embeddings, this is used by the mask decder to generate masks and iou scores. For more memory
efficient computation, users can first retrieve the image embeddings using the <code>get_image_embeddings</code>
method, and then feed them to the <code>forward</code> method instead of feeding the <code>pixel_values</code>.`,name:"image_embeddings"},{anchor:"transformers.SamHQModel.forward.multimask_output",description:`<strong>multimask_output</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
In the original implementation and paper, the model always outputs 3 masks per image (or per point / per
bounding box if relevant). However, it is possible to just output a single mask, that corresponds to the
&#x201C;best&#x201D; mask, by specifying <code>multimask_output=False</code>.`,name:"multimask_output"},{anchor:"transformers.SamHQModel.forward.hq_token_only",description:`<strong>hq_token_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use only the HQ token path for mask generation. When False, combines both standard and HQ paths.
This is specific to SAM-HQ&#x2019;s architecture.`,name:"hq_token_only"},{anchor:"transformers.SamHQModel.forward.attention_similarity",description:`<strong>attention_similarity</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Attention similarity tensor, to be provided to the mask decoder for target-guided attention in case the
model is used for personalization as introduced in <a href="https://arxiv.org/abs/2305.03048" rel="nofollow">PerSAM</a>.`,name:"attention_similarity"},{anchor:"transformers.SamHQModel.forward.target_embedding",description:`<strong>target_embedding</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Embedding of the target concept, to be provided to the mask decoder for target-semantic prompting in case
the model is used for personalization as introduced in <a href="https://arxiv.org/abs/2305.03048" rel="nofollow">PerSAM</a>.`,name:"target_embedding"},{anchor:"transformers.SamHQModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SamHQModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SamHQModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SamHQModel.forward.intermediate_embeddings",description:`<strong>intermediate_embeddings</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Intermediate embeddings from vision encoder&#x2019;s non-windowed blocks, used by SAM-HQ for enhanced mask quality.
Required when providing pre-computed image_embeddings instead of pixel_values.`,name:"intermediate_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sam_hq/modeling_sam_hq.py#L1453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, torch.Tensor]]</code></p>
`}}),E=new zn({props:{$$slots:{default:[Nn]},$$scope:{ctx:z}}}),P=new In({props:{anchor:"transformers.SamHQModel.forward.example",$$slots:{default:[En]},$$scope:{ctx:z}}}),Qe=new Xn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/sam_hq.md"}}),{c(){m=r("meta"),w=s(),b=r("p"),y=s(),p(M.$$.fragment),c=s(),p(T.$$.fragment),Ge=s(),L=r("p"),L.innerHTML=tn,Ae=s(),G=r("p"),G.textContent=nn,De=s(),A=r("p"),A.innerHTML=on,Ke=s(),D=r("p"),D.textContent=sn,Oe=s(),K=r("ol"),K.innerHTML=an,et=s(),O=r("p"),O.textContent=rn,tt=s(),ee=r("p"),ee.innerHTML=ln,nt=s(),te=r("p"),te.textContent=mn,ot=s(),ne=r("ul"),ne.innerHTML=dn,st=s(),oe=r("p"),oe.innerHTML=cn,at=s(),se=r("p"),se.textContent=pn,rt=s(),p(ae.$$.fragment),it=s(),re=r("p"),re.textContent=hn,lt=s(),p(ie.$$.fragment),mt=s(),p(le.$$.fragment),dt=s(),me=r("p"),me.textContent=fn,ct=s(),de=r("ul"),de.innerHTML=un,pt=s(),p(ce.$$.fragment),ht=s(),Q=r("div"),p(pe.$$.fragment),Ut=s(),Je=r("p"),Je.innerHTML=gn,xt=s(),$e=r("p"),$e.innerHTML=_n,ft=s(),p(he.$$.fragment),ut=s(),S=r("div"),p(fe.$$.fragment),jt=s(),ke=r("p"),ke.innerHTML=bn,zt=s(),Ue=r("p"),Ue.innerHTML=yn,It=s(),p(B.$$.fragment),gt=s(),p(ue.$$.fragment),_t=s(),J=r("div"),p(ge.$$.fragment),Wt=s(),xe=r("p"),xe.innerHTML=Mn,Zt=s(),je=r("p"),je.innerHTML=wn,bt=s(),p(_e.$$.fragment),yt=s(),$=r("div"),p(be.$$.fragment),Vt=s(),ze=r("p"),ze.innerHTML=Tn,qt=s(),Ie=r("p"),Ie.innerHTML=vn,Mt=s(),p(ye.$$.fragment),wt=s(),k=r("div"),p(Me.$$.fragment),Ft=s(),We=r("p"),We.textContent=Hn,Xt=s(),Ze=r("p"),Ze.innerHTML=Sn,Tt=s(),p(we.$$.fragment),vt=s(),v=r("div"),p(Te.$$.fragment),Rt=s(),Ve=r("p"),Ve.textContent=Cn,Bt=s(),qe=r("p"),qe.innerHTML=Qn,Nt=s(),Fe=r("p"),Fe.innerHTML=Jn,Et=s(),I=r("div"),p(ve.$$.fragment),Pt=s(),Xe=r("p"),Xe.innerHTML=$n,Yt=s(),p(N.$$.fragment),Ht=s(),p(He.$$.fragment),St=s(),H=r("div"),p(Se.$$.fragment),Lt=s(),Re=r("p"),Re.textContent=kn,Gt=s(),Be=r("p"),Be.innerHTML=Un,At=s(),Ne=r("p"),Ne.innerHTML=xn,Dt=s(),C=r("div"),p(Ce.$$.fragment),Kt=s(),Ee=r("p"),Ee.innerHTML=jn,Ot=s(),p(E.$$.fragment),en=s(),p(P.$$.fragment),Ct=s(),p(Qe.$$.fragment),Qt=s(),Le=r("p"),this.h()},l(e){const t=Fn("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(n),w=a(e),b=i(e,"P",{}),x(b).forEach(n),y=a(e),h(M.$$.fragment,e),c=a(e),h(T.$$.fragment,e),Ge=a(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-116y6ic"&&(L.innerHTML=tn),Ae=a(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-ltzfnj"&&(G.textContent=nn),De=a(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-8e5g7x"&&(A.innerHTML=on),Ke=a(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1yz8bw9"&&(D.textContent=sn),Oe=a(e),K=i(e,"OL",{"data-svelte-h":!0}),d(K)!=="svelte-1i02sxi"&&(K.innerHTML=an),et=a(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-vfdo9a"&&(O.textContent=rn),tt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-s1ez2n"&&(ee.innerHTML=ln),nt=a(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-axv494"&&(te.textContent=mn),ot=a(e),ne=i(e,"UL",{"data-svelte-h":!0}),d(ne)!=="svelte-4ihf1u"&&(ne.innerHTML=dn),st=a(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1190due"&&(oe.innerHTML=cn),at=a(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-j41zpc"&&(se.textContent=pn),rt=a(e),h(ae.$$.fragment,e),it=a(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-9n292x"&&(re.textContent=hn),lt=a(e),h(ie.$$.fragment,e),mt=a(e),h(le.$$.fragment,e),dt=a(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1xvpfwq"&&(me.textContent=fn),ct=a(e),de=i(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-s9rgjd"&&(de.innerHTML=un),pt=a(e),h(ce.$$.fragment,e),ht=a(e),Q=i(e,"DIV",{class:!0});var q=x(Q);h(pe.$$.fragment,q),Ut=a(q),Je=i(q,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-avsvms"&&(Je.innerHTML=gn),xt=a(q),$e=i(q,"P",{"data-svelte-h":!0}),d($e)!=="svelte-o55m63"&&($e.innerHTML=_n),q.forEach(n),ft=a(e),h(he.$$.fragment,e),ut=a(e),S=i(e,"DIV",{class:!0});var U=x(S);h(fe.$$.fragment,U),jt=a(U),ke=i(U,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-15kv9ns"&&(ke.innerHTML=bn),zt=a(U),Ue=i(U,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-o55m63"&&(Ue.innerHTML=yn),It=a(U),h(B.$$.fragment,U),U.forEach(n),gt=a(e),h(ue.$$.fragment,e),_t=a(e),J=i(e,"DIV",{class:!0});var F=x(J);h(ge.$$.fragment,F),Wt=a(F),xe=i(F,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-ebwaj0"&&(xe.innerHTML=Mn),Zt=a(F),je=i(F,"P",{"data-svelte-h":!0}),d(je)!=="svelte-o55m63"&&(je.innerHTML=wn),F.forEach(n),bt=a(e),h(_e.$$.fragment,e),yt=a(e),$=i(e,"DIV",{class:!0});var X=x($);h(be.$$.fragment,X),Vt=a(X),ze=i(X,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-abevwi"&&(ze.innerHTML=Tn),qt=a(X),Ie=i(X,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1fwzrcu"&&(Ie.innerHTML=vn),X.forEach(n),Mt=a(e),h(ye.$$.fragment,e),wt=a(e),k=i(e,"DIV",{class:!0});var Pe=x(k);h(Me.$$.fragment,Pe),Ft=a(Pe),We=i(Pe,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1frihgb"&&(We.textContent=Hn),Xt=a(Pe),Ze=i(Pe,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-if58ta"&&(Ze.innerHTML=Sn),Pe.forEach(n),Tt=a(e),h(we.$$.fragment,e),vt=a(e),v=i(e,"DIV",{class:!0});var W=x(v);h(Te.$$.fragment,W),Rt=a(W),Ve=i(W,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-15n6fiu"&&(Ve.textContent=Cn),Bt=a(W),qe=i(W,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-6pahdo"&&(qe.innerHTML=Qn),Nt=a(W),Fe=i(W,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=Jn),Et=a(W),I=i(W,"DIV",{class:!0});var Ye=x(I);h(ve.$$.fragment,Ye),Pt=a(Ye),Xe=i(Ye,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-19utr9k"&&(Xe.innerHTML=$n),Yt=a(Ye),h(N.$$.fragment,Ye),Ye.forEach(n),W.forEach(n),Ht=a(e),h(He.$$.fragment,e),St=a(e),H=i(e,"DIV",{class:!0});var Z=x(H);h(Se.$$.fragment,Z),Lt=a(Z),Re=i(Z,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-7h36yk"&&(Re.textContent=kn),Gt=a(Z),Be=i(Z,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-6pahdo"&&(Be.innerHTML=Un),At=a(Z),Ne=i(Z,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-hswkmf"&&(Ne.innerHTML=xn),Dt=a(Z),C=i(Z,"DIV",{class:!0});var Y=x(C);h(Ce.$$.fragment,Y),Kt=a(Y),Ee=i(Y,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1abptl8"&&(Ee.innerHTML=jn),Ot=a(Y),h(E.$$.fragment,Y),en=a(Y),h(P.$$.fragment,Y),Y.forEach(n),Z.forEach(n),Ct=a(e),h(Qe.$$.fragment,e),Qt=a(e),Le=i(e,"P",{}),x(Le).forEach(n),this.h()},h(){j(m,"name","hf:doc:metadata"),j(m,"content",Yn),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,m),o(e,w,t),o(e,b,t),o(e,y,t),f(M,e,t),o(e,c,t),f(T,e,t),o(e,Ge,t),o(e,L,t),o(e,Ae,t),o(e,G,t),o(e,De,t),o(e,A,t),o(e,Ke,t),o(e,D,t),o(e,Oe,t),o(e,K,t),o(e,et,t),o(e,O,t),o(e,tt,t),o(e,ee,t),o(e,nt,t),o(e,te,t),o(e,ot,t),o(e,ne,t),o(e,st,t),o(e,oe,t),o(e,at,t),o(e,se,t),o(e,rt,t),f(ae,e,t),o(e,it,t),o(e,re,t),o(e,lt,t),f(ie,e,t),o(e,mt,t),f(le,e,t),o(e,dt,t),o(e,me,t),o(e,ct,t),o(e,de,t),o(e,pt,t),f(ce,e,t),o(e,ht,t),o(e,Q,t),f(pe,Q,null),l(Q,Ut),l(Q,Je),l(Q,xt),l(Q,$e),o(e,ft,t),f(he,e,t),o(e,ut,t),o(e,S,t),f(fe,S,null),l(S,jt),l(S,ke),l(S,zt),l(S,Ue),l(S,It),f(B,S,null),o(e,gt,t),f(ue,e,t),o(e,_t,t),o(e,J,t),f(ge,J,null),l(J,Wt),l(J,xe),l(J,Zt),l(J,je),o(e,bt,t),f(_e,e,t),o(e,yt,t),o(e,$,t),f(be,$,null),l($,Vt),l($,ze),l($,qt),l($,Ie),o(e,Mt,t),f(ye,e,t),o(e,wt,t),o(e,k,t),f(Me,k,null),l(k,Ft),l(k,We),l(k,Xt),l(k,Ze),o(e,Tt,t),f(we,e,t),o(e,vt,t),o(e,v,t),f(Te,v,null),l(v,Rt),l(v,Ve),l(v,Bt),l(v,qe),l(v,Nt),l(v,Fe),l(v,Et),l(v,I),f(ve,I,null),l(I,Pt),l(I,Xe),l(I,Yt),f(N,I,null),o(e,Ht,t),f(He,e,t),o(e,St,t),o(e,H,t),f(Se,H,null),l(H,Lt),l(H,Re),l(H,Gt),l(H,Be),l(H,At),l(H,Ne),l(H,Dt),l(H,C),f(Ce,C,null),l(C,Kt),l(C,Ee),l(C,Ot),f(E,C,null),l(C,en),f(P,C,null),o(e,Ct,t),f(Qe,e,t),o(e,Qt,t),o(e,Le,t),Jt=!0},p(e,[t]){const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),B.$set(q);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),N.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),E.$set(F);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),P.$set(X)},i(e){Jt||(u(M.$$.fragment,e),u(T.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(B.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(N.$$.fragment,e),u(He.$$.fragment,e),u(Se.$$.fragment,e),u(Ce.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(Qe.$$.fragment,e),Jt=!0)},o(e){g(M.$$.fragment,e),g(T.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(B.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(N.$$.fragment,e),g(He.$$.fragment,e),g(Se.$$.fragment,e),g(Ce.$$.fragment,e),g(E.$$.fragment,e),g(P.$$.fragment,e),g(Qe.$$.fragment,e),Jt=!1},d(e){e&&(n(w),n(b),n(y),n(c),n(Ge),n(L),n(Ae),n(G),n(De),n(A),n(Ke),n(D),n(Oe),n(K),n(et),n(O),n(tt),n(ee),n(nt),n(te),n(ot),n(ne),n(st),n(oe),n(at),n(se),n(rt),n(it),n(re),n(lt),n(mt),n(dt),n(me),n(ct),n(de),n(pt),n(ht),n(Q),n(ft),n(ut),n(S),n(gt),n(_t),n(J),n(bt),n(yt),n($),n(Mt),n(wt),n(k),n(Tt),n(vt),n(v),n(Ht),n(St),n(H),n(Ct),n(Qt),n(Le)),n(m),_(M,e),_(T,e),_(ae,e),_(ie,e),_(le,e),_(ce,e),_(pe),_(he,e),_(fe),_(B),_(ue,e),_(ge),_(_e,e),_(be),_(ye,e),_(Me),_(we,e),_(Te),_(ve),_(N),_(He,e),_(Se),_(Ce),_(E),_(P),_(Qe,e)}}}const Yn='{"title":"SAM-HQ","local":"sam-hq","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SamHQConfig","local":"transformers.SamHQConfig","sections":[],"depth":2},{"title":"SamHQVisionConfig","local":"transformers.SamHQVisionConfig","sections":[],"depth":2},{"title":"SamHQMaskDecoderConfig","local":"transformers.SamHQMaskDecoderConfig","sections":[],"depth":2},{"title":"SamHQPromptEncoderConfig","local":"transformers.SamHQPromptEncoderConfig","sections":[],"depth":2},{"title":"SamHQProcessor","local":"transformers.SamHQProcessor","sections":[],"depth":2},{"title":"SamHQVisionModel","local":"transformers.SamHQVisionModel","sections":[],"depth":2},{"title":"SamHQModel","local":"transformers.SamHQModel","sections":[],"depth":2}],"depth":1}';function Ln(z){return Zn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oo extends Vn{constructor(m){super(),qn(this,m,Ln,Pn,Wn,{})}}export{oo as component};
