import{s as wo,o as Zo,n as je}from"../chunks/scheduler.18a86fab.js";import{S as jo,i as Jo,g as i,s,r as f,A as ko,h as p,f as a,c as r,j as F,u,x as h,k as $,y as d,a as c,v as g,d as _,t as y,w as b}from"../chunks/index.98837b22.js";import{T as vo}from"../chunks/Tip.77304350.js";import{D as L}from"../chunks/Docstring.6758ea23.js";import{C as R}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as qe}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as A}from"../chunks/Heading.7e7e0c5b.js";import{E as Wo}from"../chunks/getInferenceSnippets.de10bc7d.js";function Uo(J){let n,v="Examples:",m,l,M;return l=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBXYXYyVmVjMkNvbmZpZyUyQyUyMFNwZWVjaEVuY29kZXJEZWNvZGVyQ29uZmlnJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBXYXYyVmVjMiUyMCUyNiUyMEJFUlQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWdfZW5jb2RlciUyMCUzRCUyMFdhdjJWZWMyQ29uZmlnKCklMEFjb25maWdfZGVjb2RlciUyMCUzRCUyMEJlcnRDb25maWcoKSUwQSUwQWNvbmZpZyUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyQ29uZmlnLmZyb21fZW5jb2Rlcl9kZWNvZGVyX2NvbmZpZ3MoY29uZmlnX2VuY29kZXIlMkMlMjBjb25maWdfZGVjb2RlciklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwV2F2MlZlYzJCZXJ0JTIwbW9kZWwlMjBmcm9tJTIwYSUyMFdhdjJWZWMyJTIwJTI2JTIwZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbnMlMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwoY29uZmlnJTNEY29uZmlnKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ19lbmNvZGVyJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVuY29kZXIlMEFjb25maWdfZGVjb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy5kZWNvZGVyJTBBJTIzJTIwc2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMHRvJTIwY2F1c2FsJTIwbG0lMEFjb25maWdfZGVjb2Rlci5pc19kZWNvZGVyJTIwJTNEJTIwVHJ1ZSUwQWNvbmZpZ19kZWNvZGVyLmFkZF9jcm9zc19hdHRlbnRpb24lMjAlM0QlMjBUcnVlJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LW1vZGVsJTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBZW5jb2Rlcl9kZWNvZGVyX2NvbmZpZyUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJteS1tb2RlbCUyMiklMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm15LW1vZGVsJTIyJTJDJTIwY29uZmlnJTNEZW5jb2Rlcl9kZWNvZGVyX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, Wav2Vec2Config, SpeechEncoderDecoderConfig, SpeechEncoderDecoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Wav2Vec2 &amp; BERT style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_encoder = Wav2Vec2Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = BertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = SpeechEncoderDecoderConfig.from_encoder_decoder_configs(config_encoder, config_decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Wav2Vec2Bert model from a Wav2Vec2 &amp; google-bert/bert-base-uncased style configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_encoder = model.config.encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set decoder config to causal lm</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder.is_decoder = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder.add_cross_attention = <span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_decoder_config = SpeechEncoderDecoderConfig.from_pretrained(<span class="hljs-string">&quot;my-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;my-model&quot;</span>, config=encoder_decoder_config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=v,m=s(),f(l.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(t),u(l.$$.fragment,t)},m(t,T){c(t,n,T),c(t,m,T),g(l,t,T),M=!0},p:je,i(t){M||(_(l.$$.fragment,t),M=!0)},o(t){y(l.$$.fragment,t),M=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function xo(J){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=i("p"),n.innerHTML=v},l(m){n=p(m,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){c(m,n,l)},p:je,d(m){m&&a(n)}}}function Eo(J){let n,v="Examples:",m,l,M;return l=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwlMkMlMjBBdXRvUHJvY2Vzc29yJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLXhscy1yLTMwMG0tZW4tdG8tMTUlMjIpJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLXhscy1yLTMwMG0tZW4tdG8tMTUlMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMHByb2Nlc3NvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfdmFsdWVzJTBBJTIzJTIwSW5mZXJlbmNlJTNBJTIwVHJhbnNsYXRlJTIwRW5nbGlzaCUyMHNwZWVjaCUyMHRvJTIwR2VybWFuJTBBZ2VuZXJhdGVkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfdmFsdWVzKSUwQWRlY29kZWQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEFkZWNvZGVkJTBBJTBBJTIzJTIwVHJhaW5pbmclM0ElMjBUcmFpbiUyMG1vZGVsJTIwb24lMjBFbmdsaXNoJTIwdHJhbnNjcmlwdGlvbiUwQWxhYmVscyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEZHMlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQWxvc3MlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechEncoderDecoderModel, AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-xls-r-300m-en-to-15&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-xls-r-300m-en-to-15&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inference: Translate English speech to German</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated = model.generate(input_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoded = processor.batch_decode(generated, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>decoded
<span class="hljs-string">&#x27;Mr. Quilter ist der Apostel der Mittelschicht und wir freuen uns, sein Evangelium willkommen heißen zu können.&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Training: Train model on English transcription</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor(text=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_values, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){n=i("p"),n.textContent=v,m=s(),f(l.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(t),u(l.$$.fragment,t)},m(t,T){c(t,n,T),c(t,m,T),g(l,t,T),M=!0},p:je,i(t){M||(_(l.$$.fragment,t),M=!0)},o(t){y(l.$$.fragment,t),M=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Vo(J){let n,v="Example:",m,l,M;return l=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwlMEElMEElMjMlMjBpbml0aWFsaXplJTIwYSUyMHdhdjJ2ZWMyYmVydCUyMGZyb20lMjBhJTIwcHJldHJhaW5lZCUyMFdhdjJWZWMyJTIwYW5kJTIwYSUyMHByZXRyYWluZWQlMjBCRVJUJTIwbW9kZWwuJTIwTm90ZSUyMHRoYXQlMjB0aGUlMjBjcm9zcy1hdHRlbnRpb24lMjBsYXllcnMlMjB3aWxsJTIwYmUlMjByYW5kb21seSUyMGluaXRpYWxpemVkJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fZW5jb2Rlcl9kZWNvZGVyX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIlMkMlMjAlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBKSUwQSUyMyUyMHNhdmluZyUyMG1vZGVsJTIwYWZ0ZXIlMjBmaW5lLXR1bmluZyUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGd2F2MnZlYzJiZXJ0JTIyKSUwQSUyMyUyMGxvYWQlMjBmaW5lLXR1bmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ3YXYydmVjMmJlcnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechEncoderDecoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize a wav2vec2bert from a pretrained Wav2Vec2 and a pretrained BERT model. Note that the cross-attention layers will be randomly initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_encoder_decoder_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># saving model after fine-tuning</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;./wav2vec2bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load fine-tuned model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;./wav2vec2bert&quot;</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=v,m=s(),f(l.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),u(l.$$.fragment,t)},m(t,T){c(t,n,T),c(t,m,T),g(l,t,T),M=!0},p:je,i(t){M||(_(l.$$.fragment,t),M=!0)},o(t){y(l.$$.fragment,t),M=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Co(J){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=i("p"),n.innerHTML=v},l(m){n=p(m,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){c(m,n,l)},p:je,d(m){m&&a(n)}}}function So(J){let n,v="Examples:",m,l,M;return l=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMGxvYWQlMjBhJTIwZmluZS10dW5lZCUyMHdhdjJ2ZWMyLTItYmFydCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBGbGF4U3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycGF0cmlja3ZvbnBsYXRlbiUyRndhdjJ2ZWMyLTItYmFydC1sYXJnZSUyMiklMEElMjMlMjBsb2FkJTIwb3V0cHV0JTIwdG9rZW5pemVyJTBBdG9rZW5pemVyX291dHB1dCUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGYmFydC1sYXJnZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBqbnAub25lcygoMiUyQyUyMDUwMDApJTJDJTIwZHR5cGUlM0RqbnAuZmxvYXQzMiklMEElMEElMjMlMjB1c2UlMjBiYXJ0J3MlMjBzcGVjaWFsJTIwYm9zJTJDJTIwcGFkJTIwYW5kJTIwZW9zJTIwdG9rZW5zJTBBbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5kZWNvZGVyLmNvbmZpZy5ib3NfdG9rZW5faWQlMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZGVjb2Rlci5jb25maWcucGFkX3Rva2VuX2lkJTBBbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUyMCUzRCUyMG1vZGVsLmRlY29kZXIuY29uZmlnLmVvc190b2tlbl9pZCUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxSpeechEncoderDecoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load a fine-tuned wav2vec2-2-bart model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxSpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-2-bart-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load output tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/bart-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = jnp.ones((<span class="hljs-number">2</span>, <span class="hljs-number">5000</span>), dtype=jnp.float32)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use bart&#x27;s special bos, pad and eos tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = model.decoder.config.bos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.decoder.config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.eos_token_id = model.decoder.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(inputs)
<span class="hljs-comment"># Assert something? More interesting input? dtype correct?</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=v,m=s(),f(l.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=r(t),u(l.$$.fragment,t)},m(t,T){c(t,n,T),c(t,m,T),g(l,t,T),M=!0},p:je,i(t){M||(_(l.$$.fragment,t),M=!0)},o(t){y(l.$$.fragment,t),M=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Go(J){let n,v="Example:",m,l,M;return l=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMGElMjB3YXYydmVjMi0yLWJhcnQlMjBmcm9tJTIwcHJldHJhaW5lZCUyMHdhdjJ2ZWMyJTIwYW5kJTIwYmFydCUyMG1vZGVscy4lMjBOb3RlJTIwdGhhdCUyMHRoZSUyMGNyb3NzLWF0dGVudGlvbiUyMGxheWVycyUyMHdpbGwlMjBiZSUyMHJhbmRvbWx5JTIwaW5pdGlhbGl6ZWQlMEFtb2RlbCUyMCUzRCUyMEZsYXhTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fZW5jb2Rlcl9kZWNvZGVyX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS1sdjYwJTIyJTJDJTIwJTIyZmFjZWJvb2slMkZiYXJ0LWxhcmdlJTIyJTBBKSUwQSUyMyUyMHNhdmluZyUyMG1vZGVsJTIwYWZ0ZXIlMjBmaW5lLXR1bmluZyUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGd2F2MnZlYzItMi1iYXJ0LWxhcmdlJTIyKSUwQSUyMyUyMGxvYWQlMjBmaW5lLXR1bmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEZsYXhTcGVlY2hFbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjIuJTJGd2F2MnZlYzItMi1iYXJ0LWxhcmdlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxSpeechEncoderDecoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize a wav2vec2-2-bart from pretrained wav2vec2 and bart models. Note that the cross-attention layers will be randomly initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>, <span class="hljs-string">&quot;facebook/bart-large&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># saving model after fine-tuning</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;./wav2vec2-2-bart-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load fine-tuned model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxSpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;./wav2vec2-2-bart-large&quot;</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=v,m=s(),f(l.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),u(l.$$.fragment,t)},m(t,T){c(t,n,T),c(t,m,T),g(l,t,T),M=!0},p:je,i(t){M||(_(l.$$.fragment,t),M=!0)},o(t){y(l.$$.fragment,t),M=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function $o(J){let n,v,m,l,M,t,T,Lt=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>`,He,Q,At=`The <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> can be used to initialize a speech-to-text model
with any pretrained speech autoencoding model as the encoder (<em>e.g.</em> <a href="wav2vec2">Wav2Vec2</a>, <a href="hubert">Hubert</a>) and any pretrained autoregressive model as the decoder.`,Le,P,Qt=`The effectiveness of initializing speech-sequence-to-text-sequence models with pretrained checkpoints for speech
recognition and speech translation has <em>e.g.</em> been shown in <a href="https://arxiv.org/abs/2104.06678" rel="nofollow">Large-Scale Self- and Semi-Supervised Learning for Speech
Translation</a> by Changhan Wang, Anne Wu, Juan Pino, Alexei Baevski, Michael Auli,
Alexis Conneau.`,Ae,O,Pt='An example of how to use a <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> for inference can be seen in <a href="speech_to_text_2">Speech2Text2</a>.',Qe,K,Pe,ee,Ot=`<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> can be randomly initialized from an encoder and a decoder config. In the following example, we show how to do this using the default <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> configuration for the encoder
and the default <code>BertForCausalLM</code> configuration for the decoder.`,Oe,te,Ke,oe,et,ne,Kt=`<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> can be initialized from a pretrained encoder checkpoint and a pretrained decoder checkpoint. Note that any pretrained Transformer-based speech model, <em>e.g.</em> <a href="wav2vec2">Wav2Vec2</a>, <a href="hubert">Hubert</a> can serve as the encoder and both pretrained auto-encoding models, <em>e.g.</em> BERT, pretrained causal language models, <em>e.g.</em> GPT2, as well as the pretrained decoder part of sequence-to-sequence models, <em>e.g.</em> decoder of BART, can be used as the decoder.
Depending on which architecture you choose as the decoder, the cross-attention layers might be randomly initialized.
Initializing <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> from a pretrained encoder and decoder checkpoint requires the model to be fine-tuned on a downstream task, as has been shown in <a href="https://huggingface.co/blog/warm-starting-encoder-decoder" rel="nofollow">the <em>Warm-starting-encoder-decoder blog post</em></a>.
To do so, the <code>SpeechEncoderDecoderModel</code> class provides a <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained">SpeechEncoderDecoderModel.from_encoder_decoder_pretrained()</a> method.`,tt,ae,ot,se,nt,re,eo='To load fine-tuned checkpoints of the <code>SpeechEncoderDecoderModel</code> class, <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> provides the <code>from_pretrained(...)</code> method just like any other model architecture in Transformers.',at,de,to="To perform inference, one uses the <code>generate</code> method, which allows to autoregressively generate text. This method supports various forms of decoding, such as greedy, beam search and multinomial sampling.",st,ce,rt,le,dt,ie,oo=`Once the model is created, it can be fine-tuned similar to BART, T5 or any other encoder-decoder model on a dataset of (speech, text) pairs.
As you can see, only 2 inputs are required for the model in order to compute a loss: <code>input_values</code> (which are the
speech inputs) and <code>labels</code> (which are the <code>input_ids</code> of the encoded target sequence).`,ct,pe,lt,me,it,k,he,yt,Je,no=`<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a> is the configuration class to store the configuration of a
<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a>. It is used to instantiate an Encoder Decoder model according to the specified
arguments, defining the encoder and decoder configs.`,bt,ke,ao=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mt,N,Tt,z,fe,vt,We,so=`Instantiate a <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a> (or a derived class) from a pre-trained encoder model
configuration and decoder model configuration.`,pt,ue,mt,j,ge,wt,Ue,ro="The bare Speech Encoder Decoder Model outputting raw hidden-states without any specific head on top.",Zt,xe,co=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jt,Ee,lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jt,x,_e,kt,Ve,io='The <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> forward method, overrides the <code>__call__</code> special method.',Wt,Y,Ut,X,xt,E,ye,Et,Ce,po=`Instantiate an encoder and a decoder from one or two base classes of the library from pretrained model
checkpoints.`,Vt,Se,mo=`The model is set in evaluation mode by default using <code>model.eval()</code> (Dropout modules are deactivated). To train
the model, you need to first set it back in training mode with <code>model.train()</code>.`,Ct,B,ht,be,ft,w,Me,St,Ge,ho=`This class can be used to initialize a speech-sequence-to-text-sequence model with any pretrained speech
autoencoding model as the encoder and any pretrained text autoregressive model as the decoder. The encoder is
loaded via <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> function and the decoder is loaded via
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> function. Cross-attention layers are automatically added to the decoder
and should be fine-tuned on a downstream generative task, like summarization.`,Gt,$e,fo=`The effectiveness of initializing sequence-to-sequence models with pretrained checkpoints for sequence generation
tasks was shown in <a href="https://arxiv.org/abs/1907.12461" rel="nofollow">Leveraging Pre-trained Checkpoints for Sequence Generation
Tasks</a> by Sascha Rothe, Shashi Narayan, Aliaksei Severyn. Michael Matena, Yanqi
Zhou, Wei Li, Peter J. Liu.`,$t,Ie,uo=`Additionally, in <a href="https://arxiv.org/abs/2104.06678" rel="nofollow">Large-Scale Self- and Semi-Supervised Learning for Speech
Translation</a> it is shown how leveraging large pretrained speech models for speech
translation yields a significant performance improvement.`,It,Fe,go=`After such an Speech-Encoder Decoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,Ft,Re,_o=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rt,Ne,yo=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,Nt,ze,bo=`<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.FlaxSpeechEncoderDecoderModel">FlaxSpeechEncoderDecoderModel</a> is a generic model class that will be instantiated as a transformer architecture
with the module (flax.nn.Module) of one of the base model classes of the library as encoder module and another one
as decoder module when created with the :meth<em>~transformers.FlaxAutoModel.from_pretrained</em> class method for the
encoder and :meth<em>~transformers.FlaxAutoModelForCausalLM.from_pretrained</em> class method for the decoder.`,zt,V,Te,Yt,Ye,Mo='The <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.FlaxSpeechEncoderDecoderModel">FlaxSpeechEncoderDecoderModel</a> forward method, overrides the <code>__call__</code> special method.',Xt,D,Bt,q,Dt,I,ve,qt,Xe,To=`Instantiate an encoder and a decoder from one or two base classes of the library from pretrained model
checkpoints.`,Ht,H,ut,we,gt,De,_t;return M=new A({props:{title:"Speech Encoder Decoder Models",local:"speech-encoder-decoder-models",headingTag:"h1"}}),K=new A({props:{title:"Randomly initializing SpeechEncoderDecoderModel from model configurations.",local:"randomly-initializing-speechencoderdecodermodel-from-model-configurations",headingTag:"h2"}}),te=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBXYXYyVmVjMkNvbmZpZyUyQyUyMFNwZWVjaEVuY29kZXJEZWNvZGVyQ29uZmlnJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQSUwQWNvbmZpZ19lbmNvZGVyJTIwJTNEJTIwV2F2MlZlYzJDb25maWcoKSUwQWNvbmZpZ19kZWNvZGVyJTIwJTNEJTIwQmVydENvbmZpZygpJTBBJTBBY29uZmlnJTIwJTNEJTIwU3BlZWNoRW5jb2RlckRlY29kZXJDb25maWcuZnJvbV9lbmNvZGVyX2RlY29kZXJfY29uZmlncyhjb25maWdfZW5jb2RlciUyQyUyMGNvbmZpZ19kZWNvZGVyKSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbChjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, Wav2Vec2Config, SpeechEncoderDecoderConfig, SpeechEncoderDecoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>config_encoder = Wav2Vec2Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = BertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = SpeechEncoderDecoderConfig.from_encoder_decoder_configs(config_encoder, config_decoder)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel(config=config)`,wrap:!1}}),oe=new A({props:{title:"Initialising SpeechEncoderDecoderModel from a pretrained encoder and a pretrained decoder.",local:"initialising-speechencoderdecodermodel-from-a-pretrained-encoder-and-a-pretrained-decoder",headingTag:"h2"}}),ae=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9lbmNvZGVyX2RlY29kZXJfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRmh1YmVydC1sYXJnZS1sbDYwayUyMiUyQyUyMCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechEncoderDecoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_encoder_decoder_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/hubert-large-ll60k&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),se=new A({props:{title:"Loading an existing SpeechEncoderDecoderModel checkpoint and perform inference.",local:"loading-an-existing-speechencoderdecodermodel-checkpoint-and-perform-inference",headingTag:"h2"}}),ce=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyUHJvY2Vzc29yJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMGElMjBmaW5lLXR1bmVkJTIwc3BlZWNoJTIwdHJhbnNsYXRpb24lMjBtb2RlbCUyMGFuZCUyMGNvcnJlc3BvbmRpbmclMjBwcm9jZXNzb3IlMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzIteGxzLXItMzAwbS1lbi10by0xNSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBXYXYyVmVjMlByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi14bHMtci0zMDBtLWVuLXRvLTE1JTIyKSUwQSUwQSUyMyUyMGxldCdzJTIwcGVyZm9ybSUyMGluZmVyZW5jZSUyMG9uJTIwYSUyMHBpZWNlJTIwb2YlMjBFbmdsaXNoJTIwc3BlZWNoJTIwKHdoaWNoJTIwd2UnbGwlMjB0cmFuc2xhdGUlMjB0byUyMEdlcm1hbiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF92YWx1ZXMlMEElMEElMjMlMjBhdXRvcmVncmVzc2l2ZWx5JTIwZ2VuZXJhdGUlMjB0cmFuc2NyaXB0aW9uJTIwKHVzZXMlMjBncmVlZHklMjBkZWNvZGluZyUyMGJ5JTIwZGVmYXVsdCklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfdmFsdWVzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2Processor, SpeechEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load a fine-tuned speech translation model and corresponding processor</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-xls-r-300m-en-to-15&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Wav2Vec2Processor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-xls-r-300m-en-to-15&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s perform inference on a piece of English speech (which we&#x27;ll translate to German)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># autoregressively generate transcription (uses greedy decoding by default)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
Mr. Quilter ist der Apostel der Mittelschicht und wir freuen uns, sein Evangelium willkommen heißen zu können.`,wrap:!1}}),le=new A({props:{title:"Training",local:"training",headingTag:"h2"}}),pe=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoFeatureExtractor, SpeechEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_id = <span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>  <span class="hljs-comment"># acoustic model encoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_id = <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>  <span class="hljs-comment"># text decoder</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(encoder_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(decoder_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Combine pre-trained encoder and pre-trained decoder to form a Seq2Seq model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_encoder_decoder_pretrained(encoder_id, decoder_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = tokenizer.cls_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = tokenizer.pad_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load an audio input and pre-process (normalise mean/std to 0/1)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load its corresponding transcription and tokenize to generate labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the forward function automatically creates the correct decoder_input_ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_values=input_values, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),me=new A({props:{title:"SpeechEncoderDecoderConfig",local:"transformers.SpeechEncoderDecoderConfig",headingTag:"h2"}}),he=new L({props:{name:"class transformers.SpeechEncoderDecoderConfig",anchor:"transformers.SpeechEncoderDecoderConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SpeechEncoderDecoderConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/configuration_speech_encoder_decoder.py#L26"}}),N=new qe({props:{anchor:"transformers.SpeechEncoderDecoderConfig.example",$$slots:{default:[Uo]},$$scope:{ctx:J}}}),fe=new L({props:{name:"from_encoder_decoder_configs",anchor:"transformers.SpeechEncoderDecoderConfig.from_encoder_decoder_configs",parameters:[{name:"encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/configuration_speech_encoder_decoder.py#L94",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig"
>SpeechEncoderDecoderConfig</a></p>
`}}),ue=new A({props:{title:"SpeechEncoderDecoderModel",local:"transformers.SpeechEncoderDecoderModel",headingTag:"h2"}}),ge=new L({props:{name:"class transformers.SpeechEncoderDecoderModel",anchor:"transformers.SpeechEncoderDecoderModel",parameters:[{name:"config",val:": typing.Optional[transformers.configuration_utils.PretrainedConfig] = None"},{name:"encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"transformers.SpeechEncoderDecoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.SpeechEncoderDecoderModel.encoder",description:`<strong>encoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The encoder model to use.`,name:"encoder"},{anchor:"transformers.SpeechEncoderDecoderModel.decoder",description:`<strong>decoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The decoder model to use.`,name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_speech_encoder_decoder.py#L55"}}),_e=new L({props:{name:"forward",anchor:"transformers.SpeechEncoderDecoderModel.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SpeechEncoderDecoderModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code> or <code>(batch_size, sequence_length, feature_dim)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform or speech features. Values can be obtained by loading a <code>.flac</code>
or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile
library (<code>pip install soundfile</code>). To prepare the array into <code>inputs</code>, either the <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> or
<a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextProcessor">Speech2TextProcessor</a> should be used for padding and conversion into a tensor of type
<code>torch.FloatTensor</code>.`,name:"inputs"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>For training, <code>decoder_input_ids</code> are automatically created by the model by shifting the <code>labels</code> to the
right, replacing -100 by the <code>pad_token_id</code> and prepending them with the <code>decoder_start_token_id</code>.`,name:"decoder_input_ids"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. This is useful if you want more control over how to convert <code>decoder_input_ids</code> indices
into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss for the decoder. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <em>.flac</em> or <em>.wav</em> audio file
into an array of type <em>List[float]</em> or a <em>numpy.ndarray</em>, <em>e.g.</em> via the soundfile library (<em>pip install
soundfile</em>). To prepare the array into <em>input_values</em>, the <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> should be used for padding
and conversion into a tensor of type <em>torch.FloatTensor</em>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, feature_size)</code>, <em>optional</em>) &#x2014;
Float values of fbank features extracted from the raw speech waveform. Raw speech waveform can be obtained
by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em>
via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_features</code>, the
<a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextFeatureExtractor">Speech2TextFeatureExtractor</a> should be used for extracting the fbank features, padding and conversion
into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextFeatureExtractor.__call__"><strong>call</strong>()</a>`,name:"input_features"},{anchor:"transformers.SpeechEncoderDecoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_speech_encoder_decoder.py#L320",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig"
>SpeechEncoderDecoderConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new vo({props:{$$slots:{default:[xo]},$$scope:{ctx:J}}}),X=new qe({props:{anchor:"transformers.SpeechEncoderDecoderModel.forward.example",$$slots:{default:[Eo]},$$scope:{ctx:J}}}),ye=new L({props:{name:"from_encoder_decoder_pretrained",anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained",parameters:[{name:"encoder_pretrained_model_name_or_path",val:": typing.Optional[str] = None"},{name:"decoder_pretrained_model_name_or_path",val:": typing.Optional[str] = None"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained.encoder_pretrained_model_name_or_path",description:`<strong>encoder_pretrained_model_name_or_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Information necessary to initiate the encoder. Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"encoder_pretrained_model_name_or_path"},{anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained.decoder_pretrained_model_name_or_path",description:`<strong>decoder_pretrained_model_name_or_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Information necessary to initiate the decoder. Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"decoder_pretrained_model_name_or_path"},{anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained.model_args",description:`<strong>model_args</strong> (remaining positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments will be passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>).</p>
<ul>
<li>To update the encoder configuration, use the prefix <em>encoder_</em> for each configuration parameter.</li>
<li>To update the decoder configuration, use the prefix <em>decoder_</em> for each configuration parameter.</li>
<li>To update the parent model configuration, do not use a prefix for each configuration parameter.</li>
</ul>
<p>Behaves differently depending on whether a <code>config</code> is provided or automatically loaded.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_speech_encoder_decoder.py#L169"}}),B=new qe({props:{anchor:"transformers.SpeechEncoderDecoderModel.from_encoder_decoder_pretrained.example",$$slots:{default:[Vo]},$$scope:{ctx:J}}}),be=new A({props:{title:"FlaxSpeechEncoderDecoderModel",local:"transformers.FlaxSpeechEncoderDecoderModel",headingTag:"h2"}}),Me=new L({props:{name:"class transformers.FlaxSpeechEncoderDecoderModel",anchor:"transformers.FlaxSpeechEncoderDecoderModel",parameters:[{name:"config",val:": SpeechEncoderDecoderConfig"},{name:"input_shape",val:": typing.Optional[typing.Tuple] = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxSpeechEncoderDecoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_flax_speech_encoder_decoder.py#L328"}}),Te=new L({props:{name:"__call__",anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__",parameters:[{name:"inputs",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_input_ids",val:": typing.Optional[jax.Array] = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_position_ids",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"params",val:": typing.Optional[dict] = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f540c285510> = None"}],parametersDescription:[{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.inputs",description:`<strong>inputs</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code> or <code>(batch_size, sequence_length, feature_dim)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform or speech features. Values can be obtained by loading a <code>.flac</code>
or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile
library (<code>pip install soundfile</code>). To prepare the array into <code>inputs</code>, either the <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> or
<a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextProcessor">Speech2TextProcessor</a> should be used for padding and conversion into a tensor of type
<code>torch.FloatTensor</code>.`,name:"inputs"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>For sequence to sequence training, <code>decoder_input_ids</code> should be provided. <code>decoder_input_ids</code> should be
created outside of the model by shifting the <code>labels</code> to the right, replacing -100 by the <code>pad_token_id</code>
and prepending them with the <code>decoder_start_token_id</code>.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each decoder input sequence tokens in the position embeddings. Selected in the
range <code>[0, config.decoder.max_position_embeddings - 1]</code>.`,name:"decoder_position_ids"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <code>~utils.FlaxSeq2SeqLMOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_flax_speech_encoder_decoder.py#L660",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig"
>SpeechEncoderDecoderConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new vo({props:{$$slots:{default:[Co]},$$scope:{ctx:J}}}),q=new qe({props:{anchor:"transformers.FlaxSpeechEncoderDecoderModel.__call__.example",$$slots:{default:[So]},$$scope:{ctx:J}}}),ve=new L({props:{name:"from_encoder_decoder_pretrained",anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained",parameters:[{name:"encoder_pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"decoder_pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained.encoder_pretrained_model_name_or_path",description:`<strong>encoder_pretrained_model_name_or_path</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Information necessary to initiate the encoder. Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"encoder_pretrained_model_name_or_path"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained.decoder_pretrained_model_name_or_path",description:`<strong>decoder_pretrained_model_name_or_path</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Information necessary to initiate the decoder. Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"decoder_pretrained_model_name_or_path"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained.model_args",description:`<strong>model_args</strong> (remaining positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments will be passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>).</p>
<ul>
<li>To update the encoder configuration, use the prefix <em>encoder_</em> for each configuration parameter.</li>
<li>To update the decoder configuration, use the prefix <em>decoder_</em> for each configuration parameter.</li>
<li>To update the parent model configuration, do not use a prefix for each configuration parameter.</li>
</ul>
<p>Behaves differently depending on whether a <code>config</code> is provided or automatically loaded.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_encoder_decoder/modeling_flax_speech_encoder_decoder.py#L782"}}),H=new qe({props:{anchor:"transformers.FlaxSpeechEncoderDecoderModel.from_encoder_decoder_pretrained.example",$$slots:{default:[Go]},$$scope:{ctx:J}}}),we=new Wo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/speech-encoder-decoder.md"}}),{c(){n=i("meta"),v=s(),m=i("p"),l=s(),f(M.$$.fragment),t=s(),T=i("div"),T.innerHTML=Lt,He=s(),Q=i("p"),Q.innerHTML=At,Le=s(),P=i("p"),P.innerHTML=Qt,Ae=s(),O=i("p"),O.innerHTML=Pt,Qe=s(),f(K.$$.fragment),Pe=s(),ee=i("p"),ee.innerHTML=Ot,Oe=s(),f(te.$$.fragment),Ke=s(),f(oe.$$.fragment),et=s(),ne=i("p"),ne.innerHTML=Kt,tt=s(),f(ae.$$.fragment),ot=s(),f(se.$$.fragment),nt=s(),re=i("p"),re.innerHTML=eo,at=s(),de=i("p"),de.innerHTML=to,st=s(),f(ce.$$.fragment),rt=s(),f(le.$$.fragment),dt=s(),ie=i("p"),ie.innerHTML=oo,ct=s(),f(pe.$$.fragment),lt=s(),f(me.$$.fragment),it=s(),k=i("div"),f(he.$$.fragment),yt=s(),Je=i("p"),Je.innerHTML=no,bt=s(),ke=i("p"),ke.innerHTML=ao,Mt=s(),f(N.$$.fragment),Tt=s(),z=i("div"),f(fe.$$.fragment),vt=s(),We=i("p"),We.innerHTML=so,pt=s(),f(ue.$$.fragment),mt=s(),j=i("div"),f(ge.$$.fragment),wt=s(),Ue=i("p"),Ue.textContent=ro,Zt=s(),xe=i("p"),xe.innerHTML=co,jt=s(),Ee=i("p"),Ee.innerHTML=lo,Jt=s(),x=i("div"),f(_e.$$.fragment),kt=s(),Ve=i("p"),Ve.innerHTML=io,Wt=s(),f(Y.$$.fragment),Ut=s(),f(X.$$.fragment),xt=s(),E=i("div"),f(ye.$$.fragment),Et=s(),Ce=i("p"),Ce.textContent=po,Vt=s(),Se=i("p"),Se.innerHTML=mo,Ct=s(),f(B.$$.fragment),ht=s(),f(be.$$.fragment),ft=s(),w=i("div"),f(Me.$$.fragment),St=s(),Ge=i("p"),Ge.innerHTML=ho,Gt=s(),$e=i("p"),$e.innerHTML=fo,$t=s(),Ie=i("p"),Ie.innerHTML=uo,It=s(),Fe=i("p"),Fe.textContent=go,Ft=s(),Re=i("p"),Re.innerHTML=_o,Rt=s(),Ne=i("p"),Ne.innerHTML=yo,Nt=s(),ze=i("p"),ze.innerHTML=bo,zt=s(),V=i("div"),f(Te.$$.fragment),Yt=s(),Ye=i("p"),Ye.innerHTML=Mo,Xt=s(),f(D.$$.fragment),Bt=s(),f(q.$$.fragment),Dt=s(),I=i("div"),f(ve.$$.fragment),qt=s(),Xe=i("p"),Xe.textContent=To,Ht=s(),f(H.$$.fragment),ut=s(),f(we.$$.fragment),gt=s(),De=i("p"),this.h()},l(e){const o=ko("svelte-u9bgzb",document.head);n=p(o,"META",{name:!0,content:!0}),o.forEach(a),v=r(e),m=p(e,"P",{}),F(m).forEach(a),l=r(e),u(M.$$.fragment,e),t=r(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),h(T)!=="svelte-hmx6yz"&&(T.innerHTML=Lt),He=r(e),Q=p(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1scow92"&&(Q.innerHTML=At),Le=r(e),P=p(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1jxsacc"&&(P.innerHTML=Qt),Ae=r(e),O=p(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-ajdviw"&&(O.innerHTML=Pt),Qe=r(e),u(K.$$.fragment,e),Pe=r(e),ee=p(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-zmztt0"&&(ee.innerHTML=Ot),Oe=r(e),u(te.$$.fragment,e),Ke=r(e),u(oe.$$.fragment,e),et=r(e),ne=p(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-gb0umw"&&(ne.innerHTML=Kt),tt=r(e),u(ae.$$.fragment,e),ot=r(e),u(se.$$.fragment,e),nt=r(e),re=p(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1deypkt"&&(re.innerHTML=eo),at=r(e),de=p(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-otiwkm"&&(de.innerHTML=to),st=r(e),u(ce.$$.fragment,e),rt=r(e),u(le.$$.fragment,e),dt=r(e),ie=p(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1mtzhr7"&&(ie.innerHTML=oo),ct=r(e),u(pe.$$.fragment,e),lt=r(e),u(me.$$.fragment,e),it=r(e),k=p(e,"DIV",{class:!0});var U=F(k);u(he.$$.fragment,U),yt=r(U),Je=p(U,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-19pavco"&&(Je.innerHTML=no),bt=r(U),ke=p(U,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-o55m63"&&(ke.innerHTML=ao),Mt=r(U),u(N.$$.fragment,U),Tt=r(U),z=p(U,"DIV",{class:!0});var Ze=F(z);u(fe.$$.fragment,Ze),vt=r(Ze),We=p(Ze,"P",{"data-svelte-h":!0}),h(We)!=="svelte-18e8szt"&&(We.innerHTML=so),Ze.forEach(a),U.forEach(a),pt=r(e),u(ue.$$.fragment,e),mt=r(e),j=p(e,"DIV",{class:!0});var W=F(j);u(ge.$$.fragment,W),wt=r(W),Ue=p(W,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1fcfhqe"&&(Ue.textContent=ro),Zt=r(W),xe=p(W,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-6pahdo"&&(xe.innerHTML=co),jt=r(W),Ee=p(W,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-hswkmf"&&(Ee.innerHTML=lo),Jt=r(W),x=p(W,"DIV",{class:!0});var C=F(x);u(_e.$$.fragment,C),kt=r(C),Ve=p(C,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-c8pc75"&&(Ve.innerHTML=io),Wt=r(C),u(Y.$$.fragment,C),Ut=r(C),u(X.$$.fragment,C),C.forEach(a),xt=r(W),E=p(W,"DIV",{class:!0});var S=F(E);u(ye.$$.fragment,S),Et=r(S),Ce=p(S,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-n4p3zm"&&(Ce.textContent=po),Vt=r(S),Se=p(S,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-ce5sus"&&(Se.innerHTML=mo),Ct=r(S),u(B.$$.fragment,S),S.forEach(a),W.forEach(a),ht=r(e),u(be.$$.fragment,e),ft=r(e),w=p(e,"DIV",{class:!0});var Z=F(w);u(Me.$$.fragment,Z),St=r(Z),Ge=p(Z,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-qrv7xx"&&(Ge.innerHTML=ho),Gt=r(Z),$e=p(Z,"P",{"data-svelte-h":!0}),h($e)!=="svelte-1faerbf"&&($e.innerHTML=fo),$t=r(Z),Ie=p(Z,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-xu4z0z"&&(Ie.innerHTML=uo),It=r(Z),Fe=p(Z,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-1dsbzbd"&&(Fe.textContent=go),Ft=r(Z),Re=p(Z,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-18ki9f4"&&(Re.innerHTML=_o),Rt=r(Z),Ne=p(Z,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-idybz1"&&(Ne.innerHTML=yo),Nt=r(Z),ze=p(Z,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-b07hd7"&&(ze.innerHTML=bo),zt=r(Z),V=p(Z,"DIV",{class:!0});var G=F(V);u(Te.$$.fragment,G),Yt=r(G),Ye=p(G,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-2ydbot"&&(Ye.innerHTML=Mo),Xt=r(G),u(D.$$.fragment,G),Bt=r(G),u(q.$$.fragment,G),G.forEach(a),Dt=r(Z),I=p(Z,"DIV",{class:!0});var Be=F(I);u(ve.$$.fragment,Be),qt=r(Be),Xe=p(Be,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-n4p3zm"&&(Xe.textContent=To),Ht=r(Be),u(H.$$.fragment,Be),Be.forEach(a),Z.forEach(a),ut=r(e),u(we.$$.fragment,e),gt=r(e),De=p(e,"P",{}),F(De).forEach(a),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",Io),$(T,"class","flex flex-wrap space-x-1"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){d(document.head,n),c(e,v,o),c(e,m,o),c(e,l,o),g(M,e,o),c(e,t,o),c(e,T,o),c(e,He,o),c(e,Q,o),c(e,Le,o),c(e,P,o),c(e,Ae,o),c(e,O,o),c(e,Qe,o),g(K,e,o),c(e,Pe,o),c(e,ee,o),c(e,Oe,o),g(te,e,o),c(e,Ke,o),g(oe,e,o),c(e,et,o),c(e,ne,o),c(e,tt,o),g(ae,e,o),c(e,ot,o),g(se,e,o),c(e,nt,o),c(e,re,o),c(e,at,o),c(e,de,o),c(e,st,o),g(ce,e,o),c(e,rt,o),g(le,e,o),c(e,dt,o),c(e,ie,o),c(e,ct,o),g(pe,e,o),c(e,lt,o),g(me,e,o),c(e,it,o),c(e,k,o),g(he,k,null),d(k,yt),d(k,Je),d(k,bt),d(k,ke),d(k,Mt),g(N,k,null),d(k,Tt),d(k,z),g(fe,z,null),d(z,vt),d(z,We),c(e,pt,o),g(ue,e,o),c(e,mt,o),c(e,j,o),g(ge,j,null),d(j,wt),d(j,Ue),d(j,Zt),d(j,xe),d(j,jt),d(j,Ee),d(j,Jt),d(j,x),g(_e,x,null),d(x,kt),d(x,Ve),d(x,Wt),g(Y,x,null),d(x,Ut),g(X,x,null),d(j,xt),d(j,E),g(ye,E,null),d(E,Et),d(E,Ce),d(E,Vt),d(E,Se),d(E,Ct),g(B,E,null),c(e,ht,o),g(be,e,o),c(e,ft,o),c(e,w,o),g(Me,w,null),d(w,St),d(w,Ge),d(w,Gt),d(w,$e),d(w,$t),d(w,Ie),d(w,It),d(w,Fe),d(w,Ft),d(w,Re),d(w,Rt),d(w,Ne),d(w,Nt),d(w,ze),d(w,zt),d(w,V),g(Te,V,null),d(V,Yt),d(V,Ye),d(V,Xt),g(D,V,null),d(V,Bt),g(q,V,null),d(w,Dt),d(w,I),g(ve,I,null),d(I,qt),d(I,Xe),d(I,Ht),g(H,I,null),c(e,ut,o),g(we,e,o),c(e,gt,o),c(e,De,o),_t=!0},p(e,[o]){const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),N.$set(U);const Ze={};o&2&&(Ze.$$scope={dirty:o,ctx:e}),Y.$set(Ze);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),X.$set(W);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),B.$set(C);const S={};o&2&&(S.$$scope={dirty:o,ctx:e}),D.$set(S);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),q.$set(Z);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),H.$set(G)},i(e){_t||(_(M.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(ce.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(N.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Y.$$.fragment,e),_(X.$$.fragment,e),_(ye.$$.fragment,e),_(B.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(D.$$.fragment,e),_(q.$$.fragment,e),_(ve.$$.fragment,e),_(H.$$.fragment,e),_(we.$$.fragment,e),_t=!0)},o(e){y(M.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(ce.$$.fragment,e),y(le.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(he.$$.fragment,e),y(N.$$.fragment,e),y(fe.$$.fragment,e),y(ue.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y(Y.$$.fragment,e),y(X.$$.fragment,e),y(ye.$$.fragment,e),y(B.$$.fragment,e),y(be.$$.fragment,e),y(Me.$$.fragment,e),y(Te.$$.fragment,e),y(D.$$.fragment,e),y(q.$$.fragment,e),y(ve.$$.fragment,e),y(H.$$.fragment,e),y(we.$$.fragment,e),_t=!1},d(e){e&&(a(v),a(m),a(l),a(t),a(T),a(He),a(Q),a(Le),a(P),a(Ae),a(O),a(Qe),a(Pe),a(ee),a(Oe),a(Ke),a(et),a(ne),a(tt),a(ot),a(nt),a(re),a(at),a(de),a(st),a(rt),a(dt),a(ie),a(ct),a(lt),a(it),a(k),a(pt),a(mt),a(j),a(ht),a(ft),a(w),a(ut),a(gt),a(De)),a(n),b(M,e),b(K,e),b(te,e),b(oe,e),b(ae,e),b(se,e),b(ce,e),b(le,e),b(pe,e),b(me,e),b(he),b(N),b(fe),b(ue,e),b(ge),b(_e),b(Y),b(X),b(ye),b(B),b(be,e),b(Me),b(Te),b(D),b(q),b(ve),b(H),b(we,e)}}}const Io='{"title":"Speech Encoder Decoder Models","local":"speech-encoder-decoder-models","sections":[{"title":"Randomly initializing SpeechEncoderDecoderModel from model configurations.","local":"randomly-initializing-speechencoderdecodermodel-from-model-configurations","sections":[],"depth":2},{"title":"Initialising SpeechEncoderDecoderModel from a pretrained encoder and a pretrained decoder.","local":"initialising-speechencoderdecodermodel-from-a-pretrained-encoder-and-a-pretrained-decoder","sections":[],"depth":2},{"title":"Loading an existing SpeechEncoderDecoderModel checkpoint and perform inference.","local":"loading-an-existing-speechencoderdecodermodel-checkpoint-and-perform-inference","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"SpeechEncoderDecoderConfig","local":"transformers.SpeechEncoderDecoderConfig","sections":[],"depth":2},{"title":"SpeechEncoderDecoderModel","local":"transformers.SpeechEncoderDecoderModel","sections":[],"depth":2},{"title":"FlaxSpeechEncoderDecoderModel","local":"transformers.FlaxSpeechEncoderDecoderModel","sections":[],"depth":2}],"depth":1}';function Fo(J){return Zo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends jo{constructor(n){super(),Jo(this,n,Fo,$o,wo,{})}}export{Ho as component};
