import{s as Lt,o as Et,n as U}from"../chunks/scheduler.18a86fab.js";import{S as qt,i as Pt,g as h,s as i,r as u,A as At,h as f,f as r,c as l,j as R,x as y,u as g,k as X,l as Dt,y as p,a as m,v as _,d as w,t as b,w as v}from"../chunks/index.98837b22.js";import{T as Fe}from"../chunks/Tip.77304350.js";import{D as ue}from"../chunks/Docstring.6758ea23.js";import{C as We}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as De}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Ze}from"../chunks/Heading.7e7e0c5b.js";import{H as Ot,a as Qt}from"../chunks/HfOption.6641485e.js";import{E as Kt}from"../chunks/getInferenceSnippets.de10bc7d.js";function eo(M){let t,d="Click on the Swin Transformer V2 models in the right sidebar for more examples of how to apply Swin Transformer V2 to vision tasks.";return{c(){t=h("p"),t.textContent=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-jkaekw"&&(t.textContent=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function to(M){let t,d;return t=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWljcm9zb2Z0JTJGc3dpbnYyLXRpbnktcGF0Y2g0LXdpbmRvdzgtMjU2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNEMCUwQSklMEFwaXBlbGluZShpbWFnZXMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(
    task=<span class="hljs-string">&quot;image-classification&quot;</span>,
    model=<span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>,
    torch_dtype=torch.float16,
    device=<span class="hljs-number">0</span>
)
pipeline(images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>)`,wrap:!1}}),{c(){u(t.$$.fragment)},l(o){g(t.$$.fragment,o)},m(o,a){_(t,o,a),d=!0},p:U,i(o){d||(w(t.$$.fragment,o),d=!0)},o(o){b(t.$$.fragment,o),d=!1},d(o){v(t,o)}}}function oo(M){let t,d;return t=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTJDJTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZzd2ludjItdGlueS1wYXRjaDQtd2luZG93OC0yNTYlMjIlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZzd2ludjItdGlueS1wYXRjaDQtd2luZG93OC0yNTYlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUwQSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoZGltJTNELTEpLml0ZW0oKSUwQXByZWRpY3RlZF9jbGFzc19sYWJlbCUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQXByaW50KGYlMjJUaGUlMjBwcmVkaWN0ZWQlMjBjbGFzcyUyMGxhYmVsJTIwaXMlM0ElMjAlN0JwcmVkaWN0ZWRfY2xhc3NfbGFiZWwlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>,
)
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-keyword">with</span> torch.no_grad():
  logits = model(**inputs).logits

predicted_class_id = logits.argmax(dim=-<span class="hljs-number">1</span>).item()
predicted_class_label = model.config.id2label[predicted_class_id]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The predicted class label is: <span class="hljs-subst">{predicted_class_label}</span>&quot;</span>)`,wrap:!1}}),{c(){u(t.$$.fragment)},l(o){g(t.$$.fragment,o)},m(o,a){_(t,o,a),d=!0},p:U,i(o){d||(w(t.$$.fragment,o),d=!0)},o(o){b(t.$$.fragment,o),d=!1},d(o){v(t,o)}}}function no(M){let t,d,o,a;return t=new Qt({props:{id:"usage",option:"Pipeline",$$slots:{default:[to]},$$scope:{ctx:M}}}),o=new Qt({props:{id:"usage",option:"AutoModel",$$slots:{default:[oo]},$$scope:{ctx:M}}}),{c(){u(t.$$.fragment),d=i(),u(o.$$.fragment)},l(c){g(t.$$.fragment,c),d=l(c),g(o.$$.fragment,c)},m(c,n){_(t,c,n),m(c,d,n),_(o,c,n),a=!0},p(c,n){const $={};n&2&&($.$$scope={dirty:n,ctx:c}),t.$set($);const B={};n&2&&(B.$$scope={dirty:n,ctx:c}),o.$set(B)},i(c){a||(w(t.$$.fragment,c),w(o.$$.fragment,c),a=!0)},o(c){b(t.$$.fragment,c),b(o.$$.fragment,c),a=!1},d(c){c&&r(d),v(t,c),v(o,c)}}}function so(M){let t,d="Example:",o,a,c;return a=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW52MkNvbmZpZyUyQyUyMFN3aW52Mk1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFN3aW52MiUyMG1pY3Jvc29mdCUyRnN3aW52Mi10aW55LXBhdGNoNC13aW5kb3c4LTI1NiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTd2ludjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwbWljcm9zb2Z0JTJGc3dpbnYyLXRpbnktcGF0Y2g0LXdpbmRvdzgtMjU2JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2ludjJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swinv2Config, Swinv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swinv2 microsoft/swinv2-tiny-patch4-window8-256 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Swinv2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the microsoft/swinv2-tiny-patch4-window8-256 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swinv2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=h("p"),t.textContent=d,o=i(),u(a.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=d),o=l(n),g(a.$$.fragment,n)},m(n,$){m(n,t,$),m(n,o,$),_(a,n,$),c=!0},p:U,i(n){c||(w(a.$$.fragment,n),c=!0)},o(n){b(a.$$.fragment,n),c=!1},d(n){n&&(r(t),r(o)),v(a,n)}}}function ao(M){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function ro(M){let t,d="Example:",o,a,c;return a=new We({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=h("p"),t.textContent=d,o=i(),u(a.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=d),o=l(n),g(a.$$.fragment,n)},m(n,$){m(n,t,$),m(n,o,$),_(a,n,$),c=!0},p:U,i(n){c||(w(a.$$.fragment,n),c=!0)},o(n){b(a.$$.fragment,n),c=!1},d(n){n&&(r(t),r(o)),v(a,n)}}}function io(M){let t,d=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){t=h("p"),t.innerHTML=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-7i3y9o"&&(t.innerHTML=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function lo(M){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function co(M){let t,d="Examples:",o,a,c;return a=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW52MkZvck1hc2tlZEltYWdlTW9kZWxpbmclMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbnYyLXRpbnktcGF0Y2g0LXdpbmRvdzgtMjU2JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbnYyRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbnYyLXRpbnktcGF0Y2g0LXdpbmRvdzgtMjU2JTIyKSUwQSUwQW51bV9wYXRjaGVzJTIwJTNEJTIwKG1vZGVsLmNvbmZpZy5pbWFnZV9zaXplJTIwJTJGJTJGJTIwbW9kZWwuY29uZmlnLnBhdGNoX3NpemUpJTIwKiolMjAyJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBJTIzJTIwY3JlYXRlJTIwcmFuZG9tJTIwYm9vbGVhbiUyMG1hc2slMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcGF0Y2hlcyklMEFib29sX21hc2tlZF9wb3MlMjAlM0QlMjB0b3JjaC5yYW5kaW50KGxvdyUzRDAlMkMlMjBoaWdoJTNEMiUyQyUyMHNpemUlM0QoMSUyQyUyMG51bV9wYXRjaGVzKSkuYm9vbCgpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyUyQyUyMGJvb2xfbWFza2VkX3BvcyUzRGJvb2xfbWFza2VkX3BvcyklMEFsb3NzJTJDJTIwcmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uJTBBbGlzdChyZWNvbnN0cnVjdGVkX3BpeGVsX3ZhbHVlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swinv2ForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swinv2ForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){t=h("p"),t.textContent=d,o=i(),u(a.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=d),o=l(n),g(a.$$.fragment,n)},m(n,$){m(n,t,$),m(n,o,$),_(a,n,$),c=!0},p:U,i(n){c||(w(a.$$.fragment,n),c=!0)},o(n){b(a.$$.fragment,n),c=!1},d(n){n&&(r(t),r(o)),v(a,n)}}}function po(M){let t,d=`Note that it’s possible to fine-tune SwinV2 on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){t=h("p"),t.innerHTML=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1dn4x3r"&&(t.innerHTML=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function mo(M){let t,d=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=d},l(o){t=f(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=d)},m(o,a){m(o,t,a)},p:U,d(o){o&&r(t)}}}function ho(M){let t,d="Example:",o,a,c;return a=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW52MkZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW52Mi10aW55LXBhdGNoNC13aW5kb3c4LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFN3aW52MkZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW52Mi10aW55LXBhdGNoNC13aW5kb3c4LTI1NiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swinv2ForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swinv2ForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swinv2-tiny-patch4-window8-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
...`,wrap:!1}}),{c(){t=h("p"),t.textContent=d,o=i(),u(a.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=d),o=l(n),g(a.$$.fragment,n)},m(n,$){m(n,t,$),m(n,o,$),_(a,n,$),c=!0},p:U,i(n){c||(w(a.$$.fragment,n),c=!0)},o(n){b(a.$$.fragment,n),c=!1},d(n){n&&(r(t),r(o)),v(a,n)}}}function fo(M){let t,d,o,a,c,n='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/></div>',$,B,Ue,K,Tt='<a href="https://huggingface.co/papers/2111.09883" rel="nofollow">Swin Transformer V2</a> is a 3B parameter model that focuses on how to scale a vision model to billions of parameters. It introduces techniques like residual-post-norm combined with cosine attention for improved training stability, log-spaced continuous position bias to better handle varying image resolutions between pre-training and fine-tuning, and a new pre-training method (SimMIM) to reduce the need for large amounts of labeled data. These improvements enable efficiently training very large models (up to 3 billion parameters) capable of processing high-resolution images.',xe,ee,jt='You can find official Swin Transformer V2 checkpoints under the <a href="https://huggingface.co/microsoft?search_models=swinv2" rel="nofollow">Microsoft</a> organization.',ze,Y,Ne,V,Ge,te,Be,oe,Jt='<li>Swin Transformer V2 can pad the inputs for any input height and width divisible by <code>32</code>.</li> <li>Swin Transformer V2 can be used as a <a href="../backbones">backbone</a>. When <code>output_hidden_states = True</code>, it outputs both <code>hidden_states</code> and <code>reshaped_hidden_states</code>. The <code>reshaped_hidden_states</code> have a shape of <code>(batch, num_channels, height, width)</code> rather than <code>(batch_size, sequence_length, num_channels)</code>.</li>',Re,ne,Xe,C,se,Oe,ge,kt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a>. It is used to instantiate a Swin
Transformer v2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Swin Transformer v2
<a href="https://huggingface.co/microsoft/swinv2-tiny-patch4-window8-256" rel="nofollow">microsoft/swinv2-tiny-patch4-window8-256</a>
architecture.`,Ke,_e,St=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,et,H,Ye,ae,Ve,J,re,tt,we,Ct="The bare Swinv2 Model outputting raw hidden-states without any specific head on top.",ot,be,Ft=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,nt,ve,Zt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,st,Z,ie,at,Me,Wt='The <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> forward method, overrides the <code>__call__</code> special method.',rt,Q,it,L,He,le,Qe,T,de,lt,ye,It=`Swinv2 Model with a decoder on top for masked image modeling, as proposed in
<a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.`,dt,E,ct,$e,Ut=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,pt,Te,xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mt,W,ce,ht,je,zt='The <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForMaskedImageModeling">Swinv2ForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',ft,q,ut,P,Le,pe,Ee,j,me,gt,Je,Nt=`Swinv2 Model transformer with an image classification head on top (a linear layer on top of the final hidden state
of the [CLS] token) e.g. for ImageNet.`,_t,A,wt,ke,Gt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bt,Se,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vt,I,he,Mt,Ce,Rt='The <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForImageClassification">Swinv2ForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',yt,D,$t,O,qe,fe,Pe,Ie,Ae;return B=new Ze({props:{title:"Swin Transformer V2",local:"swin-transformer-v2",headingTag:"h1"}}),Y=new Fe({props:{warning:!1,$$slots:{default:[eo]},$$scope:{ctx:M}}}),V=new Ot({props:{id:"usage",options:["Pipeline","AutoModel"],$$slots:{default:[no]},$$scope:{ctx:M}}}),te=new Ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),ne=new Ze({props:{title:"Swinv2Config",local:"transformers.Swinv2Config",headingTag:"h2"}}),se=new ue({props:{name:"class transformers.Swinv2Config",anchor:"transformers.Swinv2Config",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 4"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 96"},{name:"depths",val:" = [2, 2, 6, 2]"},{name:"num_heads",val:" = [3, 6, 12, 24]"},{name:"window_size",val:" = 7"},{name:"pretrained_window_sizes",val:" = [0, 0, 0, 0]"},{name:"mlp_ratio",val:" = 4.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"encoder_stride",val:" = 32"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swinv2Config.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Swinv2Config.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Swinv2Config.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.Swinv2Config.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.Swinv2Config.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 2, 6, 2]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.Swinv2Config.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[3, 6, 12, 24]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Swinv2Config.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.Swinv2Config.pretrained_window_sizes",description:`<strong>pretrained_window_sizes</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[0, 0, 0, 0]</code>) &#x2014;
Size of windows during pretraining.`,name:"pretrained_window_sizes"},{anchor:"transformers.Swinv2Config.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.Swinv2Config.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.Swinv2Config.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.Swinv2Config.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.Swinv2Config.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.Swinv2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Swinv2Config.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.Swinv2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Swinv2Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Swinv2Config.encoder_stride",description:`<strong>encoder_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Factor to increase the spatial resolution by in the decoder head for masked image modeling.`,name:"encoder_stride"},{anchor:"transformers.Swinv2Config.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage.`,name:"out_features"},{anchor:"transformers.Swinv2Config.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/configuration_swinv2.py#L25"}}),H=new De({props:{anchor:"transformers.Swinv2Config.example",$$slots:{default:[so]},$$scope:{ctx:M}}}),ae=new Ze({props:{title:"Swinv2Model",local:"transformers.Swinv2Model",headingTag:"h2"}}),re=new ue({props:{name:"class transformers.Swinv2Model",anchor:"transformers.Swinv2Model",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"},{name:"use_mask_token",val:" = False"}],parametersDescription:[{anchor:"transformers.Swinv2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.Swinv2Model.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply pooling layer.`,name:"add_pooling_layer"},{anchor:"transformers.Swinv2Model.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create and apply mask tokens in the embedding layer.`,name:"use_mask_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L987"}}),ie=new ue({props:{name:"forward",anchor:"transformers.Swinv2Model.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swinv2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Swinv2Model.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.Swinv2Model.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swinv2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swinv2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swinv2Model.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Swinv2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L1022",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swinv2.modeling_swinv2.Swinv2ModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Config"
>Swinv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swinv2.modeling_swinv2.Swinv2ModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Fe({props:{$$slots:{default:[ao]},$$scope:{ctx:M}}}),L=new De({props:{anchor:"transformers.Swinv2Model.forward.example",$$slots:{default:[ro]},$$scope:{ctx:M}}}),le=new Ze({props:{title:"Swinv2ForMaskedImageModeling",local:"transformers.Swinv2ForMaskedImageModeling",headingTag:"h2"}}),de=new ue({props:{name:"class transformers.Swinv2ForMaskedImageModeling",anchor:"transformers.Swinv2ForMaskedImageModeling",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swinv2ForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForMaskedImageModeling">Swinv2ForMaskedImageModeling</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L1088"}}),E=new Fe({props:{$$slots:{default:[io]},$$scope:{ctx:M}}}),ce=new ue({props:{name:"forward",anchor:"transformers.Swinv2ForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swinv2.modeling_swinv2.Swinv2MaskedImageModelingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Config"
>Swinv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swinv2.modeling_swinv2.Swinv2MaskedImageModelingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new Fe({props:{$$slots:{default:[lo]},$$scope:{ctx:M}}}),P=new De({props:{anchor:"transformers.Swinv2ForMaskedImageModeling.forward.example",$$slots:{default:[co]},$$scope:{ctx:M}}}),pe=new Ze({props:{title:"Swinv2ForImageClassification",local:"transformers.Swinv2ForImageClassification",headingTag:"h2"}}),me=new ue({props:{name:"class transformers.Swinv2ForImageClassification",anchor:"transformers.Swinv2ForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swinv2ForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForImageClassification">Swinv2ForImageClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L1205"}}),A=new Fe({props:{$$slots:{default:[po]},$$scope:{ctx:M}}}),he=new ue({props:{name:"forward",anchor:"transformers.Swinv2ForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swinv2ForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Swinv2ForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swinv2ForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.Swinv2ForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swinv2ForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swinv2ForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Swinv2ForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swinv2/modeling_swinv2.py#L1235",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swinv2.modeling_swinv2.Swinv2ImageClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Config"
>Swinv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swinv2.modeling_swinv2.Swinv2ImageClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Fe({props:{$$slots:{default:[mo]},$$scope:{ctx:M}}}),O=new De({props:{anchor:"transformers.Swinv2ForImageClassification.forward.example",$$slots:{default:[ho]},$$scope:{ctx:M}}}),fe=new Kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/swinv2.md"}}),{c(){t=h("meta"),d=i(),o=h("p"),a=i(),c=h("div"),c.innerHTML=n,$=i(),u(B.$$.fragment),Ue=i(),K=h("p"),K.innerHTML=Tt,xe=i(),ee=h("p"),ee.innerHTML=jt,ze=i(),u(Y.$$.fragment),Ne=i(),u(V.$$.fragment),Ge=i(),u(te.$$.fragment),Be=i(),oe=h("ul"),oe.innerHTML=Jt,Re=i(),u(ne.$$.fragment),Xe=i(),C=h("div"),u(se.$$.fragment),Oe=i(),ge=h("p"),ge.innerHTML=kt,Ke=i(),_e=h("p"),_e.innerHTML=St,et=i(),u(H.$$.fragment),Ye=i(),u(ae.$$.fragment),Ve=i(),J=h("div"),u(re.$$.fragment),tt=i(),we=h("p"),we.textContent=Ct,ot=i(),be=h("p"),be.innerHTML=Ft,nt=i(),ve=h("p"),ve.innerHTML=Zt,st=i(),Z=h("div"),u(ie.$$.fragment),at=i(),Me=h("p"),Me.innerHTML=Wt,rt=i(),u(Q.$$.fragment),it=i(),u(L.$$.fragment),He=i(),u(le.$$.fragment),Qe=i(),T=h("div"),u(de.$$.fragment),lt=i(),ye=h("p"),ye.innerHTML=It,dt=i(),u(E.$$.fragment),ct=i(),$e=h("p"),$e.innerHTML=Ut,pt=i(),Te=h("p"),Te.innerHTML=xt,mt=i(),W=h("div"),u(ce.$$.fragment),ht=i(),je=h("p"),je.innerHTML=zt,ft=i(),u(q.$$.fragment),ut=i(),u(P.$$.fragment),Le=i(),u(pe.$$.fragment),Ee=i(),j=h("div"),u(me.$$.fragment),gt=i(),Je=h("p"),Je.textContent=Nt,_t=i(),u(A.$$.fragment),wt=i(),ke=h("p"),ke.innerHTML=Gt,bt=i(),Se=h("p"),Se.innerHTML=Bt,vt=i(),I=h("div"),u(he.$$.fragment),Mt=i(),Ce=h("p"),Ce.innerHTML=Rt,yt=i(),u(D.$$.fragment),$t=i(),u(O.$$.fragment),qe=i(),u(fe.$$.fragment),Pe=i(),Ie=h("p"),this.h()},l(e){const s=At("svelte-u9bgzb",document.head);t=f(s,"META",{name:!0,content:!0}),s.forEach(r),d=l(e),o=f(e,"P",{}),R(o).forEach(r),a=l(e),c=f(e,"DIV",{style:!0,"data-svelte-h":!0}),y(c)!=="svelte-wa5t4p"&&(c.innerHTML=n),$=l(e),g(B.$$.fragment,e),Ue=l(e),K=f(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1k5jmqs"&&(K.innerHTML=Tt),xe=l(e),ee=f(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1b5t8xh"&&(ee.innerHTML=jt),ze=l(e),g(Y.$$.fragment,e),Ne=l(e),g(V.$$.fragment,e),Ge=l(e),g(te.$$.fragment,e),Be=l(e),oe=f(e,"UL",{"data-svelte-h":!0}),y(oe)!=="svelte-133le3i"&&(oe.innerHTML=Jt),Re=l(e),g(ne.$$.fragment,e),Xe=l(e),C=f(e,"DIV",{class:!0});var x=R(C);g(se.$$.fragment,x),Oe=l(x),ge=f(x,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-hnd3qk"&&(ge.innerHTML=kt),Ke=l(x),_e=f(x,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-o55m63"&&(_e.innerHTML=St),et=l(x),g(H.$$.fragment,x),x.forEach(r),Ye=l(e),g(ae.$$.fragment,e),Ve=l(e),J=f(e,"DIV",{class:!0});var F=R(J);g(re.$$.fragment,F),tt=l(F),we=f(F,"P",{"data-svelte-h":!0}),y(we)!=="svelte-pfx5dl"&&(we.textContent=Ct),ot=l(F),be=f(F,"P",{"data-svelte-h":!0}),y(be)!=="svelte-6pahdo"&&(be.innerHTML=Ft),nt=l(F),ve=f(F,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-hswkmf"&&(ve.innerHTML=Zt),st=l(F),Z=f(F,"DIV",{class:!0});var z=R(Z);g(ie.$$.fragment,z),at=l(z),Me=f(z,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-png4t4"&&(Me.innerHTML=Wt),rt=l(z),g(Q.$$.fragment,z),it=l(z),g(L.$$.fragment,z),z.forEach(r),F.forEach(r),He=l(e),g(le.$$.fragment,e),Qe=l(e),T=f(e,"DIV",{class:!0});var k=R(T);g(de.$$.fragment,k),lt=l(k),ye=f(k,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-npirve"&&(ye.innerHTML=It),dt=l(k),g(E.$$.fragment,k),ct=l(k),$e=f(k,"P",{"data-svelte-h":!0}),y($e)!=="svelte-6pahdo"&&($e.innerHTML=Ut),pt=l(k),Te=f(k,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-hswkmf"&&(Te.innerHTML=xt),mt=l(k),W=f(k,"DIV",{class:!0});var N=R(W);g(ce.$$.fragment,N),ht=l(N),je=f(N,"P",{"data-svelte-h":!0}),y(je)!=="svelte-1uczwda"&&(je.innerHTML=zt),ft=l(N),g(q.$$.fragment,N),ut=l(N),g(P.$$.fragment,N),N.forEach(r),k.forEach(r),Le=l(e),g(pe.$$.fragment,e),Ee=l(e),j=f(e,"DIV",{class:!0});var S=R(j);g(me.$$.fragment,S),gt=l(S),Je=f(S,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-13r27gg"&&(Je.textContent=Nt),_t=l(S),g(A.$$.fragment,S),wt=l(S),ke=f(S,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-6pahdo"&&(ke.innerHTML=Gt),bt=l(S),Se=f(S,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-hswkmf"&&(Se.innerHTML=Bt),vt=l(S),I=f(S,"DIV",{class:!0});var G=R(I);g(he.$$.fragment,G),Mt=l(G),Ce=f(G,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-e8d70y"&&(Ce.innerHTML=Rt),yt=l(G),g(D.$$.fragment,G),$t=l(G),g(O.$$.fragment,G),G.forEach(r),S.forEach(r),qe=l(e),g(fe.$$.fragment,e),Pe=l(e),Ie=f(e,"P",{}),R(Ie).forEach(r),this.h()},h(){X(t,"name","hf:doc:metadata"),X(t,"content",uo),Dt(c,"float","right"),X(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){p(document.head,t),m(e,d,s),m(e,o,s),m(e,a,s),m(e,c,s),m(e,$,s),_(B,e,s),m(e,Ue,s),m(e,K,s),m(e,xe,s),m(e,ee,s),m(e,ze,s),_(Y,e,s),m(e,Ne,s),_(V,e,s),m(e,Ge,s),_(te,e,s),m(e,Be,s),m(e,oe,s),m(e,Re,s),_(ne,e,s),m(e,Xe,s),m(e,C,s),_(se,C,null),p(C,Oe),p(C,ge),p(C,Ke),p(C,_e),p(C,et),_(H,C,null),m(e,Ye,s),_(ae,e,s),m(e,Ve,s),m(e,J,s),_(re,J,null),p(J,tt),p(J,we),p(J,ot),p(J,be),p(J,nt),p(J,ve),p(J,st),p(J,Z),_(ie,Z,null),p(Z,at),p(Z,Me),p(Z,rt),_(Q,Z,null),p(Z,it),_(L,Z,null),m(e,He,s),_(le,e,s),m(e,Qe,s),m(e,T,s),_(de,T,null),p(T,lt),p(T,ye),p(T,dt),_(E,T,null),p(T,ct),p(T,$e),p(T,pt),p(T,Te),p(T,mt),p(T,W),_(ce,W,null),p(W,ht),p(W,je),p(W,ft),_(q,W,null),p(W,ut),_(P,W,null),m(e,Le,s),_(pe,e,s),m(e,Ee,s),m(e,j,s),_(me,j,null),p(j,gt),p(j,Je),p(j,_t),_(A,j,null),p(j,wt),p(j,ke),p(j,bt),p(j,Se),p(j,vt),p(j,I),_(he,I,null),p(I,Mt),p(I,Ce),p(I,yt),_(D,I,null),p(I,$t),_(O,I,null),m(e,qe,s),_(fe,e,s),m(e,Pe,s),m(e,Ie,s),Ae=!0},p(e,[s]){const x={};s&2&&(x.$$scope={dirty:s,ctx:e}),Y.$set(x);const F={};s&2&&(F.$$scope={dirty:s,ctx:e}),V.$set(F);const z={};s&2&&(z.$$scope={dirty:s,ctx:e}),H.$set(z);const k={};s&2&&(k.$$scope={dirty:s,ctx:e}),Q.$set(k);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),L.$set(N);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),E.$set(S);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),q.$set(G);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:e}),P.$set(Xt);const Yt={};s&2&&(Yt.$$scope={dirty:s,ctx:e}),A.$set(Yt);const Vt={};s&2&&(Vt.$$scope={dirty:s,ctx:e}),D.$set(Vt);const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),O.$set(Ht)},i(e){Ae||(w(B.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(se.$$.fragment,e),w(H.$$.fragment,e),w(ae.$$.fragment,e),w(re.$$.fragment,e),w(ie.$$.fragment,e),w(Q.$$.fragment,e),w(L.$$.fragment,e),w(le.$$.fragment,e),w(de.$$.fragment,e),w(E.$$.fragment,e),w(ce.$$.fragment,e),w(q.$$.fragment,e),w(P.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(A.$$.fragment,e),w(he.$$.fragment,e),w(D.$$.fragment,e),w(O.$$.fragment,e),w(fe.$$.fragment,e),Ae=!0)},o(e){b(B.$$.fragment,e),b(Y.$$.fragment,e),b(V.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(H.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(Q.$$.fragment,e),b(L.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(E.$$.fragment,e),b(ce.$$.fragment,e),b(q.$$.fragment,e),b(P.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(A.$$.fragment,e),b(he.$$.fragment,e),b(D.$$.fragment,e),b(O.$$.fragment,e),b(fe.$$.fragment,e),Ae=!1},d(e){e&&(r(d),r(o),r(a),r(c),r($),r(Ue),r(K),r(xe),r(ee),r(ze),r(Ne),r(Ge),r(Be),r(oe),r(Re),r(Xe),r(C),r(Ye),r(Ve),r(J),r(He),r(Qe),r(T),r(Le),r(Ee),r(j),r(qe),r(Pe),r(Ie)),r(t),v(B,e),v(Y,e),v(V,e),v(te,e),v(ne,e),v(se),v(H),v(ae,e),v(re),v(ie),v(Q),v(L),v(le,e),v(de),v(E),v(ce),v(q),v(P),v(pe,e),v(me),v(A),v(he),v(D),v(O),v(fe,e)}}}const uo='{"title":"Swin Transformer V2","local":"swin-transformer-v2","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"Swinv2Config","local":"transformers.Swinv2Config","sections":[],"depth":2},{"title":"Swinv2Model","local":"transformers.Swinv2Model","sections":[],"depth":2},{"title":"Swinv2ForMaskedImageModeling","local":"transformers.Swinv2ForMaskedImageModeling","sections":[],"depth":2},{"title":"Swinv2ForImageClassification","local":"transformers.Swinv2ForImageClassification","sections":[],"depth":2}],"depth":1}';function go(M){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends qt{constructor(t){super(),Pt(this,t,go,fo,Lt,{})}}export{Jo as component};
