import{s as st,o as at,n as We}from"../chunks/scheduler.18a86fab.js";import{S as rt,i as it,g as i,s as a,r as h,A as lt,h as l,f as n,c as r,j as O,u,x as p,k,y as m,a as s,v as g,d as T,t as _,w as M}from"../chunks/index.98837b22.js";import{T as nt}from"../chunks/Tip.77304350.js";import{D as de}from"../chunks/Docstring.6758ea23.js";import{C as ot}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as mt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ce}from"../chunks/Heading.7e7e0c5b.js";import{E as dt}from"../chunks/getInferenceSnippets.de10bc7d.js";function ct(I){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=i("p"),o.innerHTML=w},l(d){o=l(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(d,f){s(d,o,f)},p:We,d(d){d&&n(o)}}}function pt(I){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=i("p"),o.innerHTML=w},l(d){o=l(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(d,f){s(d,o,f)},p:We,d(d){d&&n(o)}}}function ft(I){let o,w="Example:",d,f,v;return f=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRpbWVzRm1Nb2RlbEZvclByZWRpY3Rpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRpbWVzRm1Nb2RlbEZvclByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRpbWVzZm0tMi4wLTUwMG0tcHl0b3JjaCUyMiklMEElMEFmb3JlY2FzdF9pbnB1dCUyMCUzRCUyMCU1QnRvcmNoLmxpbnNwYWNlKDAlMkMlMjAyMCUyQyUyMDEwMCkuc2luKCklMkMlMjB0b3JjaC5saW5zcGFjZSgwJTJDJTIwMjAlMkMlMjAyMDApLnNpbigpJTJDJTIwdG9yY2gubGluc3BhY2UoMCUyQyUyMDIwJTJDJTIwNDAwKS5zaW4oKSU1RCUwQWZyZXF1ZW5jeV9pbnB1dCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMjBkdHlwZSUzRHRvcmNoLmxvbmcpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEZm9yZWNhc3RfaW5wdXQlMkMlMjBmcmVxJTNEZnJlcXVlbmN5X2lucHV0JTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHBvaW50X2ZvcmVjYXN0X2NvbnYlMjAlM0QlMjBvdXRwdXRzLm1lYW5fcHJlZGljdGlvbnMlMEElMjAlMjAlMjAlMjBxdWFudGlsZV9mb3JlY2FzdF9jb252JTIwJTNEJTIwb3V0cHV0cy5mdWxsX3ByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimesFmModelForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesFmModelForPrediction.from_pretrained(<span class="hljs-string">&quot;google/timesfm-2.0-500m-pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>forecast_input = [torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">100</span>).sin(), torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">200</span>).sin(), torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">400</span>).sin()]
<span class="hljs-meta">&gt;&gt;&gt; </span>frequency_input = torch.tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>], dtype=torch.long)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">&gt;&gt;&gt; </span>    outputs = model(past_values=forecast_input, freq=frequency_input, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>    point_forecast_conv = outputs.mean_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>    quantile_forecast_conv = outputs.full_predictions`,wrap:!1}}),{c(){o=i("p"),o.textContent=w,d=a(),h(f.$$.fragment)},l(c){o=l(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-11lpom8"&&(o.textContent=w),d=r(c),u(f.$$.fragment,c)},m(c,F){s(c,o,F),s(c,d,F),g(f,c,F),v=!0},p:We,i(c){v||(T(f.$$.fragment,c),v=!0)},o(c){_(f.$$.fragment,c),v=!1},d(c){c&&(n(o),n(d)),M(f,c)}}}function ht(I){let o,w,d,f,v,c,F,qe='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',pe,E,fe,G,Pe='TimesFM (Time Series Foundation Model) is a pretrained time-series foundation model proposed in <a href="https://huggingface.co/papers/2310.10688" rel="nofollow">A decoder-only foundation model for time-series forecasting</a> by Abhimanyu Das, Weihao Kong, Rajat Sen, and  Yichen Zhou. It is a decoder only model that uses non-overlapping patches of time-series data as input and outputs some output patch length prediction in an autoregressive fashion.',he,R,He="The abstract from the paper is the following:",ue,V,Le="<em>Motivated by recent advances in large language models for Natural Language Processing (NLP), we design a time-series foundation model for forecasting whose out-of-the-box zero-shot performance on a variety of public datasets comes close to the accuracy of state-of-the-art supervised forecasting models for each individual dataset. Our model is based on pretraining a patched-decoder style attention model on a large time-series corpus, and can work well across different forecasting history lengths, prediction lengths and temporal granularities.</em>",ge,W,Xe=`This model was contributed by <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>.
The original code can be found <a href="https://github.com/google-research/timesfm" rel="nofollow">here</a>.`,Te,q,Ye="To use the model:",_e,P,Me,H,be,$,L,xe,ee,Ae=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmModelForPrediction">TimesFmModelForPrediction</a> or a <code>TFTimesFmModel</code>. It is used to
instantiate a TimesFM model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the TimesFM
<a href="https://huggingface.co/google/timesfm-2.0-500m-pytorch" rel="nofollow">google/timesfm-2.0-500m-pytorch</a> architecture.`,Ce,te,Se=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,we,X,ye,b,Y,Ue,ne,De="The bare Timesfm Model outputting raw hidden-states without any specific head on top.",Ie,oe,Qe=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ze,se,Ke=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ze,x,A,Be,ae,Oe='The <a href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmModel">TimesFmModel</a> forward method, overrides the <code>__call__</code> special method.',Ne,z,ve,S,Fe,j,D,ke,re,et="TimesFM model for quantile and mean prediction.",Ee,J,Q,Ge,ie,tt='The <a href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmModelForPrediction">TimesFmModelForPrediction</a> forward method, overrides the <code>__call__</code> special method.',Re,Z,Ve,B,Je,K,$e,me,je;return v=new ce({props:{title:"TimesFM",local:"timesfm",headingTag:"h1"}}),E=new ce({props:{title:"Overview",local:"overview",headingTag:"h2"}}),P=new ot({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimesFmModelForPrediction


model = TimesFmModelForPrediction.from_pretrained(
    <span class="hljs-string">&quot;google/timesfm-2.0-500m-pytorch&quot;</span>,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
)


 <span class="hljs-comment"># Create dummy inputs</span>
forecast_input = [
    np.sin(np.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">100</span>)),
    np.sin(np.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">200</span>)),
    np.sin(np.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">20</span>, <span class="hljs-number">400</span>)),
]
frequency_input = [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-comment"># Convert inputs to sequence of tensors</span>
forecast_input_tensor = [
    torch.tensor(ts, dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
    <span class="hljs-keyword">for</span> ts <span class="hljs-keyword">in</span> forecast_input
]
frequency_input_tensor = torch.tensor(frequency_input, dtype=torch.long).to(
    <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)

<span class="hljs-comment"># Get predictions from the pre-trained model</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(past_values=forecast_input_tensor, freq=frequency_input_tensor, return_dict=<span class="hljs-literal">True</span>)
    point_forecast_conv = outputs.mean_predictions.<span class="hljs-built_in">float</span>().cpu().numpy()
    quantile_forecast_conv = outputs.full_predictions.<span class="hljs-built_in">float</span>().cpu().numpy()`,wrap:!1}}),H=new ce({props:{title:"TimesFmConfig",local:"transformers.TimesFmConfig",headingTag:"h2"}}),L=new de({props:{name:"class transformers.TimesFmConfig",anchor:"transformers.TimesFmConfig",parameters:[{name:"patch_length",val:": int = 32"},{name:"context_length",val:": int = 512"},{name:"horizon_length",val:": int = 128"},{name:"freq_size",val:": int = 3"},{name:"num_hidden_layers",val:": int = 50"},{name:"hidden_size",val:": int = 1280"},{name:"intermediate_size",val:": int = 1280"},{name:"head_dim",val:": int = 80"},{name:"num_attention_heads",val:": int = 16"},{name:"tolerance",val:": float = 1e-06"},{name:"rms_norm_eps",val:": float = 1e-06"},{name:"quantiles",val:": typing.List[float] = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]"},{name:"pad_val",val:": float = 1123581321.0"},{name:"attention_dropout",val:": float = 0.0"},{name:"use_positional_embedding",val:": bool = False"},{name:"initializer_range",val:": float = 0.02"},{name:"min_timescale",val:": int = 1"},{name:"max_timescale",val:": int = 10000"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TimesFmConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The length of one patch in the input sequence.`,name:"patch_length"},{anchor:"transformers.TimesFmConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The length of the input context.`,name:"context_length"},{anchor:"transformers.TimesFmConfig.horizon_length",description:`<strong>horizon_length</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The length of the prediction horizon.`,name:"horizon_length"},{anchor:"transformers.TimesFmConfig.freq_size",description:`<strong>freq_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of frequency embeddings.`,name:"freq_size"},{anchor:"transformers.TimesFmConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
Number of Transformer layers.`,name:"num_hidden_layers"},{anchor:"transformers.TimesFmConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Size of the hidden layers in the feed-forward networks.`,name:"hidden_size"},{anchor:"transformers.TimesFmConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.TimesFmConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
Size of the key, query, value projections per attention head. The <code>inner_dim</code> of the projection layer will
be defined as <code>num_attention_heads * head_dim</code>.`,name:"head_dim"},{anchor:"transformers.TimesFmConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TimesFmConfig.tolerance",description:`<strong>tolerance</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The tolerance for the quantile loss.`,name:"tolerance"},{anchor:"transformers.TimesFmConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the RMS normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.TimesFmConfig.quantiles",description:`<strong>quantiles</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]</code>) &#x2014;
The quantiles to predict.`,name:"quantiles"},{anchor:"transformers.TimesFmConfig.pad_val",description:`<strong>pad_val</strong> (<code>float</code>, <em>optional</em>, defaults to 1123581321.0) &#x2014;
The value used to pad the predictions.`,name:"pad_val"},{anchor:"transformers.TimesFmConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention scores.`,name:"attention_dropout"},{anchor:"transformers.TimesFmConfig.use_positional_embedding",description:`<strong>use_positional_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add positional embeddings.`,name:"use_positional_embedding"},{anchor:"transformers.TimesFmConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TimesFmConfig.min_timescale",description:`<strong>min_timescale</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The start of the geometric positional index. Determines the periodicity of
the added signal.`,name:"min_timescale"},{anchor:"transformers.TimesFmConfig.max_timescale",description:`<strong>max_timescale</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014;
The end of the geometric positional index. Determines the frequency of the
added signal.`,name:"max_timescale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesfm/configuration_timesfm.py#L26"}}),X=new ce({props:{title:"TimesFmModel",local:"transformers.TimesFmModel",headingTag:"h2"}}),Y=new de({props:{name:"class transformers.TimesFmModel",anchor:"transformers.TimesFmModel",parameters:[{name:"config",val:": TimesFmConfig"}],parametersDescription:[{anchor:"transformers.TimesFmModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmConfig">TimesFmConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesfm/modeling_timesfm.py#L329"}}),A=new de({props:{name:"forward",anchor:"transformers.TimesFmModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_values_padding",val:": LongTensor"},{name:"freq",val:": Tensor"},{name:"output_attentions",val:": bool = False"},{name:"output_hidden_states",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TimesFmModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Past values of the time series that serves as input to the model.`,name:"past_values"},{anchor:"transformers.TimesFmModel.forward.past_values_padding",description:`<strong>past_values_padding</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The padding indicator of the time series.`,name:"past_values_padding"},{anchor:"transformers.TimesFmModel.forward.freq",description:`<strong>freq</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>) &#x2014;
Frequency indices for the time series data.`,name:"freq"},{anchor:"transformers.TimesFmModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TimesFmModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesfm/modeling_timesfm.py#L370",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.timesfm.modeling_timesfm.TimesFmOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmConfig"
>TimesFmConfig</a>) and inputs.</p>
<ul>
<li><strong>loc</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, )</code>) — The mean of the time series inputs.</li>
<li><strong>scale</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>) — The scale of the time series inputs.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.timesfm.modeling_timesfm.TimesFmOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),z=new nt({props:{$$slots:{default:[ct]},$$scope:{ctx:I}}}),S=new ce({props:{title:"TimesFmModelForPrediction",local:"transformers.TimesFmModelForPrediction",headingTag:"h2"}}),D=new de({props:{name:"class transformers.TimesFmModelForPrediction",anchor:"transformers.TimesFmModelForPrediction",parameters:[{name:"config",val:": TimesFmConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesfm/modeling_timesfm.py#L593"}}),Q=new de({props:{name:"forward",anchor:"transformers.TimesFmModelForPrediction.forward",parameters:[{name:"past_values",val:": Sequence"},{name:"freq",val:": typing.Optional[collections.abc.Sequence[typing.Union[torch.Tensor, int]]] = None"},{name:"window_size",val:": typing.Optional[int] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"forecast_context_len",val:": typing.Optional[int] = None"},{name:"return_forecast_on_context",val:": bool = False"},{name:"truncate_negative",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TimesFmModelForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>collections.abc.Sequence</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Past values of the time series that serves as input to the model.`,name:"past_values"},{anchor:"transformers.TimesFmModelForPrediction.forward.freq",description:`<strong>freq</strong> (<code>collections.abc.Sequence[Union[torch.Tensor, int]]</code> of shape <code>(batch_size,)</code>) &#x2014;
Frequency indices for the time series data.`,name:"freq"},{anchor:"transformers.TimesFmModelForPrediction.forward.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Window size of trend + residual decomposition. If None then we do not do decomposition.`,name:"window_size"},{anchor:"transformers.TimesFmModelForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Optional future time series values to be used for loss computation.`,name:"future_values"},{anchor:"transformers.TimesFmModelForPrediction.forward.forecast_context_len",description:`<strong>forecast_context_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Optional max context length.`,name:"forecast_context_len"},{anchor:"transformers.TimesFmModelForPrediction.forward.return_forecast_on_context",description:`<strong>return_forecast_on_context</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
True to return the forecast on the context when available, i.e. after the first input patch.`,name:"return_forecast_on_context"},{anchor:"transformers.TimesFmModelForPrediction.forward.truncate_negative",description:`<strong>truncate_negative</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Truncate to only non-negative values if any of the contexts have non-negative values,
otherwise do nothing.`,name:"truncate_negative"},{anchor:"transformers.TimesFmModelForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to output the attentions.`,name:"output_attentions"},{anchor:"transformers.TimesFmModelForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to output the hidden states.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesfm/modeling_timesfm.py#L681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.timesfm.modeling_timesfm.TimesFmOutputForPrediction</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/timesfm#transformers.TimesFmConfig"
>TimesFmConfig</a>) and inputs.</p>
<ul>
<li><strong>mean_predictions</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — The mean predictions of the time series.</li>
<li><strong>full_predictions</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — The full predictions of the time series including the mean and the quantiles.</li>
<li><strong>loss</strong> (<code>torch.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>future_values</code> is provided) — The loss of the TimesFM model.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.timesfm.modeling_timesfm.TimesFmOutputForPrediction</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new nt({props:{$$slots:{default:[pt]},$$scope:{ctx:I}}}),B=new mt({props:{anchor:"transformers.TimesFmModelForPrediction.forward.example",$$slots:{default:[ft]},$$scope:{ctx:I}}}),K=new dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/timesfm.md"}}),{c(){o=i("meta"),w=a(),d=i("p"),f=a(),h(v.$$.fragment),c=a(),F=i("div"),F.innerHTML=qe,pe=a(),h(E.$$.fragment),fe=a(),G=i("p"),G.innerHTML=Pe,he=a(),R=i("p"),R.textContent=He,ue=a(),V=i("p"),V.innerHTML=Le,ge=a(),W=i("p"),W.innerHTML=Xe,Te=a(),q=i("p"),q.textContent=Ye,_e=a(),h(P.$$.fragment),Me=a(),h(H.$$.fragment),be=a(),$=i("div"),h(L.$$.fragment),xe=a(),ee=i("p"),ee.innerHTML=Ae,Ce=a(),te=i("p"),te.innerHTML=Se,we=a(),h(X.$$.fragment),ye=a(),b=i("div"),h(Y.$$.fragment),Ue=a(),ne=i("p"),ne.textContent=De,Ie=a(),oe=i("p"),oe.innerHTML=Qe,ze=a(),se=i("p"),se.innerHTML=Ke,Ze=a(),x=i("div"),h(A.$$.fragment),Be=a(),ae=i("p"),ae.innerHTML=Oe,Ne=a(),h(z.$$.fragment),ve=a(),h(S.$$.fragment),Fe=a(),j=i("div"),h(D.$$.fragment),ke=a(),re=i("p"),re.textContent=et,Ee=a(),J=i("div"),h(Q.$$.fragment),Ge=a(),ie=i("p"),ie.innerHTML=tt,Re=a(),h(Z.$$.fragment),Ve=a(),h(B.$$.fragment),Je=a(),h(K.$$.fragment),$e=a(),me=i("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);o=l(t,"META",{name:!0,content:!0}),t.forEach(n),w=r(e),d=l(e,"P",{}),O(d).forEach(n),f=r(e),u(v.$$.fragment,e),c=r(e),F=l(e,"DIV",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-13t8s2t"&&(F.innerHTML=qe),pe=r(e),u(E.$$.fragment,e),fe=r(e),G=l(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1i46uh2"&&(G.innerHTML=Pe),he=r(e),R=l(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-vfdo9a"&&(R.textContent=He),ue=r(e),V=l(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-g2ilxp"&&(V.innerHTML=Le),ge=r(e),W=l(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1wn4265"&&(W.innerHTML=Xe),Te=r(e),q=l(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-q2qfla"&&(q.textContent=Ye),_e=r(e),u(P.$$.fragment,e),Me=r(e),u(H.$$.fragment,e),be=r(e),$=l(e,"DIV",{class:!0});var C=O($);u(L.$$.fragment,C),xe=r(C),ee=l(C,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1be20ft"&&(ee.innerHTML=Ae),Ce=r(C),te=l(C,"P",{"data-svelte-h":!0}),p(te)!=="svelte-o55m63"&&(te.innerHTML=Se),C.forEach(n),we=r(e),u(X.$$.fragment,e),ye=r(e),b=l(e,"DIV",{class:!0});var y=O(b);u(Y.$$.fragment,y),Ue=r(y),ne=l(y,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1cqmr5n"&&(ne.textContent=De),Ie=r(y),oe=l(y,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-6pahdo"&&(oe.innerHTML=Qe),ze=r(y),se=l(y,"P",{"data-svelte-h":!0}),p(se)!=="svelte-hswkmf"&&(se.innerHTML=Ke),Ze=r(y),x=l(y,"DIV",{class:!0});var U=O(x);u(A.$$.fragment,U),Be=r(U),ae=l(U,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1iitkas"&&(ae.innerHTML=Oe),Ne=r(U),u(z.$$.fragment,U),U.forEach(n),y.forEach(n),ve=r(e),u(S.$$.fragment,e),Fe=r(e),j=l(e,"DIV",{class:!0});var le=O(j);u(D.$$.fragment,le),ke=r(le),re=l(le,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1ux4bpd"&&(re.textContent=et),Ee=r(le),J=l(le,"DIV",{class:!0});var N=O(J);u(Q.$$.fragment,N),Ge=r(N),ie=l(N,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1iigufw"&&(ie.innerHTML=tt),Re=r(N),u(Z.$$.fragment,N),Ve=r(N),u(B.$$.fragment,N),N.forEach(n),le.forEach(n),Je=r(e),u(K.$$.fragment,e),$e=r(e),me=l(e,"P",{}),O(me).forEach(n),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",ut),k(F,"class","flex flex-wrap space-x-1"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,o),s(e,w,t),s(e,d,t),s(e,f,t),g(v,e,t),s(e,c,t),s(e,F,t),s(e,pe,t),g(E,e,t),s(e,fe,t),s(e,G,t),s(e,he,t),s(e,R,t),s(e,ue,t),s(e,V,t),s(e,ge,t),s(e,W,t),s(e,Te,t),s(e,q,t),s(e,_e,t),g(P,e,t),s(e,Me,t),g(H,e,t),s(e,be,t),s(e,$,t),g(L,$,null),m($,xe),m($,ee),m($,Ce),m($,te),s(e,we,t),g(X,e,t),s(e,ye,t),s(e,b,t),g(Y,b,null),m(b,Ue),m(b,ne),m(b,Ie),m(b,oe),m(b,ze),m(b,se),m(b,Ze),m(b,x),g(A,x,null),m(x,Be),m(x,ae),m(x,Ne),g(z,x,null),s(e,ve,t),g(S,e,t),s(e,Fe,t),s(e,j,t),g(D,j,null),m(j,ke),m(j,re),m(j,Ee),m(j,J),g(Q,J,null),m(J,Ge),m(J,ie),m(J,Re),g(Z,J,null),m(J,Ve),g(B,J,null),s(e,Je,t),g(K,e,t),s(e,$e,t),s(e,me,t),je=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),z.$set(C);const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),Z.$set(y);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),B.$set(U)},i(e){je||(T(v.$$.fragment,e),T(E.$$.fragment,e),T(P.$$.fragment,e),T(H.$$.fragment,e),T(L.$$.fragment,e),T(X.$$.fragment,e),T(Y.$$.fragment,e),T(A.$$.fragment,e),T(z.$$.fragment,e),T(S.$$.fragment,e),T(D.$$.fragment,e),T(Q.$$.fragment,e),T(Z.$$.fragment,e),T(B.$$.fragment,e),T(K.$$.fragment,e),je=!0)},o(e){_(v.$$.fragment,e),_(E.$$.fragment,e),_(P.$$.fragment,e),_(H.$$.fragment,e),_(L.$$.fragment,e),_(X.$$.fragment,e),_(Y.$$.fragment,e),_(A.$$.fragment,e),_(z.$$.fragment,e),_(S.$$.fragment,e),_(D.$$.fragment,e),_(Q.$$.fragment,e),_(Z.$$.fragment,e),_(B.$$.fragment,e),_(K.$$.fragment,e),je=!1},d(e){e&&(n(w),n(d),n(f),n(c),n(F),n(pe),n(fe),n(G),n(he),n(R),n(ue),n(V),n(ge),n(W),n(Te),n(q),n(_e),n(Me),n(be),n($),n(we),n(ye),n(b),n(ve),n(Fe),n(j),n(Je),n($e),n(me)),n(o),M(v,e),M(E,e),M(P,e),M(H,e),M(L),M(X,e),M(Y),M(A),M(z),M(S,e),M(D),M(Q),M(Z),M(B),M(K,e)}}}const ut='{"title":"TimesFM","local":"timesfm","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"TimesFmConfig","local":"transformers.TimesFmConfig","sections":[],"depth":2},{"title":"TimesFmModel","local":"transformers.TimesFmModel","sections":[],"depth":2},{"title":"TimesFmModelForPrediction","local":"transformers.TimesFmModelForPrediction","sections":[],"depth":2}],"depth":1}';function gt(I){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends rt{constructor(o){super(),it(this,o,gt,ht,st,{})}}export{Jt as component};
