import{s as Rt,z as At,o as Xt,n as xo}from"../chunks/scheduler.18a86fab.js";import{S as Nt,i as Pt,g as i,s as n,r as f,A as Ft,h as l,f as t,c as s,j as x,u as h,x as c,k as b,y as r,a,v as g,d as u,t as M,w as T}from"../chunks/index.98837b22.js";import{T as $t}from"../chunks/Tip.77304350.js";import{D as G}from"../chunks/Docstring.6758ea23.js";import{C as nt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Wt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as D}from"../chunks/Heading.7e7e0c5b.js";import{E as Ht}from"../chunks/getInferenceSnippets.de10bc7d.js";function Et(z){let d,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=v},l(p){d=l(p,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=v)},m(p,y){a(p,d,y)},p:xo,d(p){p&&t(d)}}}function Qt(z){let d,v="Examples:",p,y,_;return y=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUdnBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwVHZwTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkppcWluZyUyRnRpbnktcmFuZG9tLXR2cCUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJKaXFpbmclMkZ0aW55LXJhbmRvbS10dnAlMjIpJTBBJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMSUyQyUyMDMlMkMlMjA0NDglMkMlMjA0NDgpJTBBdGV4dF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTIwaW5wdXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKHRleHRfaW5wdXRzLmlucHV0X2lkcyUyQyUyMHBpeGVsX3ZhbHVlcyUyQyUyMHRleHRfaW5wdXRzLmF0dGVudGlvbl9tYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoTokenizer, TvpModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvpModel.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">448</span>, <span class="hljs-number">448</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_inputs = tokenizer(<span class="hljs-string">&quot;This is an example input&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(text_inputs.input_ids, pixel_values, text_inputs.attention_mask)`,wrap:!1}}),{c(){d=i("p"),d.textContent=v,p=n(),f(y.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=v),p=s(m),h(y.$$.fragment,m)},m(m,w){a(m,d,w),a(m,p,w),g(y,m,w),_=!0},p:xo,i(m){_||(u(y.$$.fragment,m),_=!0)},o(m){M(y.$$.fragment,m),_=!1},d(m){m&&(t(d),t(p)),T(y,m)}}}function St(z){let d,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=v},l(p){d=l(p,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=v)},m(p,y){a(p,d,y)},p:xo,d(p){p&&t(d)}}}function Lt(z){let d,v="Examples:",p,y,_;return y=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUdnBGb3JWaWRlb0dyb3VuZGluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVHZwRm9yVmlkZW9Hcm91bmRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMkppcWluZyUyRnRpbnktcmFuZG9tLXR2cCUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJKaXFpbmclMkZ0aW55LXJhbmRvbS10dnAlMjIpJTBBJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMSUyQyUyMDMlMkMlMjA0NDglMkMlMjA0NDgpJTBBdGV4dF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTIwaW5wdXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKHRleHRfaW5wdXRzLmlucHV0X2lkcyUyQyUyMHBpeGVsX3ZhbHVlcyUyQyUyMHRleHRfaW5wdXRzLmF0dGVudGlvbl9tYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoTokenizer, TvpForVideoGrounding

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvpForVideoGrounding.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">448</span>, <span class="hljs-number">448</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_inputs = tokenizer(<span class="hljs-string">&quot;This is an example input&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(text_inputs.input_ids, pixel_values, text_inputs.attention_mask)`,wrap:!1}}),{c(){d=i("p"),d.textContent=v,p=n(),f(y.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=v),p=s(m),h(y.$$.fragment,m)},m(m,w){a(m,d,w),a(m,p,w),g(y,m,w),_=!0},p:xo,i(m){_||(u(y.$$.fragment,m),_=!0)},o(m){M(y.$$.fragment,m),_=!1},d(m){m&&(t(d),t(p)),T(y,m)}}}function Yt(z){let d,v,p,y,_,m,w,st='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',De,q,qe,K,at='The text-visual prompting (TVP) framework was proposed in the paper <a href="https://arxiv.org/abs/2303.04995" rel="nofollow">Text-Visual Prompting for Efficient 2D Temporal Video Grounding</a> by Yimeng Zhang, Xin Chen, Jinghan Jia, Sijia Liu, Ke Ding.',Ke,O,rt="The abstract from the paper is the following:",Oe,ee,it="<em>In this paper, we study the problem of temporal video grounding (TVG), which aims to predict the starting/ending time points of moments described by a text sentence within a long untrimmed video. Benefiting from fine-grained 3D visual features, the TVG techniques have achieved remarkable progress in recent years. However, the high complexity of 3D convolutional neural networks (CNNs) makes extracting dense 3D visual features time-consuming, which calls for intensive memory and computing resources. Towards efficient TVG, we propose a novel text-visual prompting (TVP) framework, which incorporates optimized perturbation patterns (that we call ‘prompts’) into both visual inputs and textual features of a TVG model. In sharp contrast to 3D CNNs, we show that TVP allows us to effectively co-train vision encoder and language encoder in a 2D TVG model and improves the performance of cross-modal feature fusion using only low-complexity sparse 2D visual features. Further, we propose a Temporal-Distance IoU (TDIoU) loss for efficient learning of TVG. Experiments on two benchmark datasets, Charades-STA and ActivityNet Captions datasets, empirically show that the proposed TVP significantly boosts the performance of 2D TVG (e.g., 9.79% improvement on Charades-STA and 30.77% improvement on ActivityNet Captions) and achieves 5× inference acceleration over TVG using 3D visual features.</em>",eo,oe,lt="This research addresses temporal video grounding (TVG), which is the process of pinpointing the start and end times of specific events in a long video, as described by a text sentence. Text-visual prompting (TVP), is proposed to enhance TVG. TVP involves integrating specially designed patterns, known as ‘prompts’, into both the visual (image-based) and textual (word-based) input components of a TVG model. These prompts provide additional spatial-temporal context, improving the model’s ability to accurately determine event timings in the video. The approach employs 2D visual inputs in place of 3D ones. Although 3D inputs offer more spatial-temporal detail, they are also more time-consuming to process. The use of 2D inputs with the prompting method aims to provide similar levels of context and accuracy more efficiently.",oo,R,dt,to,te,ct='TVP architecture. Taken from the <a href="https://arxiv.org/abs/2303.04995">original paper.</a>',no,ne,mt='This model was contributed by <a href="https://huggingface.co/Jiqing" rel="nofollow">Jiqing Feng</a>. The original code can be found <a href="https://github.com/intel/TVP" rel="nofollow">here</a>.',so,se,ao,ae,pt="Prompts are optimized perturbation patterns, which would be added to input video frames or text features. Universal set refers to using the same exact set of prompts for any input, this means that these prompts are added consistently to all video frames and text features, regardless of the input’s content.",ro,re,ft="TVP consists of a visual encoder and cross-modal encoder. A universal set of visual prompts and text prompts to be integrated into sampled video frames and textual features, respectively. Specially, a set of different visual prompts are applied to uniformly-sampled frames of one untrimmed video in order.",io,ie,ht=`The goal of this model is to incorporate trainable prompts into both visual inputs and textual features to temporal video grounding(TVG) problems.
In principle, one can apply any visual, cross-modal encoder in the proposed architecture.`,lo,le,gt=`The <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> wraps <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> and <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> into a single instance to both
encode the text and prepare the images respectively.`,co,de,ut='The following example shows how to run temporal video grounding using <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> and <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpForVideoGrounding">TvpForVideoGrounding</a>.',mo,ce,po,me,Mt="Tips:",fo,pe,Tt='<li>This implementation of TVP uses <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> to generate text embeddings and Resnet-50 model to compute visual embeddings.</li> <li>Checkpoints for pre-trained <a href="https://huggingface.co/Intel/tvp-base" rel="nofollow">tvp-base</a> is released.</li> <li>Please refer to <a href="https://arxiv.org/pdf/2303.04995.pdf" rel="nofollow">Table 2</a> for TVP’s performance on Temporal Video Grounding task.</li>',ho,fe,go,J,he,ko,Ze,yt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a>. It is used to instantiate an Tvp
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Tvp
<a href="https://huggingface.co/Intel/tvp-base" rel="nofollow">Intel/tvp-base</a> architecture.`,Bo,Ge,_t=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zo,A,ge,Go,ze,bt='Instantiate a <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> (or a derived class) from a pre-trained backbone model configuration.',zo,X,ue,Vo,Ve,vt='Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>.',uo,Me,Mo,Z,Te,$o,$e,wt="Constructs a Tvp image processor.",Wo,N,ye,Ro,We,Jt="Preprocess an image or batch of images.",To,_e,yo,j,be,Ao,Re,It="Constructs an TVP processor which wraps a TVP image processor and a Bert tokenizer into a single processor.",Xo,Ae,Ut=`<a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,No,P,ve,Po,Xe,jt=`Main method to prepare for the model one or several sequences(s) and image(s). This method forwards the <code>text</code>
and <code>kwargs</code> arguments to BertTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to encode
the text. To prepare the image(s), this method forwards the <code>videos</code> and <code>kwargs</code> arguments to
TvpImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>videos</code> is not <code>None</code>. Please refer to the docstring of
the above two methods for more information.`,_o,we,bo,I,Je,Fo,Ne,Ct="The bare Tvp Model transformer outputting BaseModelOutputWithPooling object without any specific head on top.",Ho,Pe,xt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Eo,Fe,kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qo,k,Ie,So,He,Bt='The <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> forward method, overrides the <code>__call__</code> special method.',Lo,F,Yo,H,vo,Ue,wo,U,je,Do,Ee,Zt="Tvp Model with a video grounding head on top computing IoU, distance, and duration loss.",qo,Qe,Gt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ko,Se,zt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oo,B,Ce,et,Le,Vt='The <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpForVideoGrounding">TvpForVideoGrounding</a> forward method, overrides the <code>__call__</code> special method.',ot,E,tt,Q,Jo,xe,Io,Ye,Uo;return _=new D({props:{title:"TVP",local:"tvp",headingTag:"h1"}}),q=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new D({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),ce=new nt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TvpForVideoGrounding


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pyav_decode</span>(<span class="hljs-params">container, sampling_rate, num_frames, clip_idx, num_clips, target_fps</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Convert the video from its original fps to the target_fps and decode the video with PyAV decoder.
    Args:
        container (container): pyav container.
        sampling_rate (int): frame sampling rate (interval between two sampled frames).
        num_frames (int): number of frames to sample.
        clip_idx (int): if clip_idx is -1, perform random temporal sampling.
            If clip_idx is larger than -1, uniformly split the video to num_clips
            clips, and select the clip_idx-th video clip.
        num_clips (int): overall number of clips to uniformly sample from the given video.
        target_fps (int): the input video may have different fps, convert it to
            the target video fps before frame sampling.
    Returns:
        frames (tensor): decoded frames from the video. Return None if the no
            video stream was found.
        fps (float): the number of frames per second of the video.
    &#x27;&#x27;&#x27;</span>
    video = container.streams.video[<span class="hljs-number">0</span>]
    fps = <span class="hljs-built_in">float</span>(video.average_rate)
    clip_size = sampling_rate * num_frames / target_fps * fps
    delta = <span class="hljs-built_in">max</span>(num_frames - clip_size, <span class="hljs-number">0</span>)
    start_idx = delta * clip_idx / num_clips
    end_idx = start_idx + clip_size - <span class="hljs-number">1</span>
    timebase = video.duration / num_frames
    video_start_pts = <span class="hljs-built_in">int</span>(start_idx * timebase)
    video_end_pts = <span class="hljs-built_in">int</span>(end_idx * timebase)
    seek_offset = <span class="hljs-built_in">max</span>(video_start_pts - <span class="hljs-number">1024</span>, <span class="hljs-number">0</span>)
    container.seek(seek_offset, any_frame=<span class="hljs-literal">False</span>, backward=<span class="hljs-literal">True</span>, stream=video)
    frames = {}
    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> container.decode(video=<span class="hljs-number">0</span>):
        <span class="hljs-keyword">if</span> frame.pts &lt; video_start_pts:
            <span class="hljs-keyword">continue</span>
        frames[frame.pts] = frame
        <span class="hljs-keyword">if</span> frame.pts &gt; video_end_pts:
            <span class="hljs-keyword">break</span>
    frames = [frames[pts] <span class="hljs-keyword">for</span> pts <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(frames)]
    <span class="hljs-keyword">return</span> frames, fps


<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode</span>(<span class="hljs-params">container, sampling_rate, num_frames, clip_idx, num_clips, target_fps</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video and perform temporal sampling.
    Args:
        container (container): pyav container.
        sampling_rate (int): frame sampling rate (interval between two sampled frames).
        num_frames (int): number of frames to sample.
        clip_idx (int): if clip_idx is -1, perform random temporal sampling.
            If clip_idx is larger than -1, uniformly split the video to num_clips
            clips, and select the clip_idx-th video clip.
        num_clips (int): overall number of clips to uniformly sample from the given video.
        target_fps (int): the input video may have different fps, convert it to
            the target video fps before frame sampling.
    Returns:
        frames (tensor): decoded frames from the video.
    &#x27;&#x27;&#x27;</span>
    <span class="hljs-keyword">assert</span> clip_idx &gt;= -<span class="hljs-number">2</span>, <span class="hljs-string">&quot;Not a valid clip_idx {}&quot;</span>.<span class="hljs-built_in">format</span>(clip_idx)
    frames, fps = pyav_decode(container, sampling_rate, num_frames, clip_idx, num_clips, target_fps)
    clip_size = sampling_rate * num_frames / target_fps * fps
    index = np.linspace(<span class="hljs-number">0</span>, clip_size - <span class="hljs-number">1</span>, num_frames)
    index = np.clip(index, <span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(frames) - <span class="hljs-number">1</span>).astype(np.int64)
    frames = np.array([frames[idx].to_rgb().to_ndarray() <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> index])
    frames = frames.transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    <span class="hljs-keyword">return</span> frames


file = hf_hub_download(repo_id=<span class="hljs-string">&quot;Intel/tvp_demo&quot;</span>, filename=<span class="hljs-string">&quot;AK2KG.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
model = TvpForVideoGrounding.from_pretrained(<span class="hljs-string">&quot;Intel/tvp-base&quot;</span>)

decoder_kwargs = <span class="hljs-built_in">dict</span>(
    container=av.<span class="hljs-built_in">open</span>(file, metadata_errors=<span class="hljs-string">&quot;ignore&quot;</span>),
    sampling_rate=<span class="hljs-number">1</span>,
    num_frames=model.config.num_frames,
    clip_idx=<span class="hljs-number">0</span>,
    num_clips=<span class="hljs-number">1</span>,
    target_fps=<span class="hljs-number">3</span>,
)
raw_sampled_frms = decode(**decoder_kwargs)

text = <span class="hljs-string">&quot;a person is sitting on a bed.&quot;</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/tvp-base&quot;</span>)
model_inputs = processor(
    text=[text], videos=<span class="hljs-built_in">list</span>(raw_sampled_frms), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, max_text_length=<span class="hljs-number">100</span><span class="hljs-comment">#, size=size</span>
)

model_inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>] = model_inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>].to(model.dtype)
output = model(**model_inputs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_video_duration</span>(<span class="hljs-params">filename</span>):
    cap = cv2.VideoCapture(filename)
    <span class="hljs-keyword">if</span> cap.isOpened():
        rate = cap.get(<span class="hljs-number">5</span>)
        frame_num = cap.get(<span class="hljs-number">7</span>)
        duration = frame_num/rate
        <span class="hljs-keyword">return</span> duration
    <span class="hljs-keyword">return</span> -<span class="hljs-number">1</span>

duration = get_video_duration(file)
start, end = processor.post_process_video_grounding(output.logits, duration)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The time slot of the video corresponding to the text \\&quot;<span class="hljs-subst">{text}</span>\\&quot; is from <span class="hljs-subst">{start}</span>s to <span class="hljs-subst">{end}</span>s&quot;</span>)`,wrap:!1}}),fe=new D({props:{title:"TvpConfig",local:"transformers.TvpConfig",headingTag:"h2"}}),he=new G({props:{name:"class transformers.TvpConfig",anchor:"transformers.TvpConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"distance_loss_weight",val:" = 1.0"},{name:"duration_loss_weight",val:" = 0.1"},{name:"visual_prompter_type",val:" = 'framepad'"},{name:"visual_prompter_apply",val:" = 'replace'"},{name:"visual_prompt_size",val:" = 96"},{name:"max_img_size",val:" = 448"},{name:"num_frames",val:" = 48"},{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"max_position_embeddings",val:" = 512"},{name:"max_grid_col_position_embeddings",val:" = 100"},{name:"max_grid_row_position_embeddings",val:" = 100"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"initializer_range",val:" = 0.02"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.TvpConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.TvpConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.TvpConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.TvpConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.TvpConfig.distance_loss_weight",description:`<strong>distance_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight of distance loss.`,name:"distance_loss_weight"},{anchor:"transformers.TvpConfig.duration_loss_weight",description:`<strong>duration_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of duration loss.`,name:"duration_loss_weight"},{anchor:"transformers.TvpConfig.visual_prompter_type",description:`<strong>visual_prompter_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;framepad&quot;</code>) &#x2014;
Visual prompt type. The type of padding. Framepad means padding on each frame. Should be one of &#x201C;framepad&#x201D;
or &#x201C;framedownpad&#x201D;`,name:"visual_prompter_type"},{anchor:"transformers.TvpConfig.visual_prompter_apply",description:`<strong>visual_prompter_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
The way of applying visual prompt. Replace means use the value of prompt to change the original value in
visual inputs. Should be one of &#x201C;replace&#x201D;, or &#x201C;add&#x201D;, or &#x201C;remove&#x201D;.`,name:"visual_prompter_apply"},{anchor:"transformers.TvpConfig.visual_prompt_size",description:`<strong>visual_prompt_size</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
The size of visual prompt.`,name:"visual_prompt_size"},{anchor:"transformers.TvpConfig.max_img_size",description:`<strong>max_img_size</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
The maximum size of frame.`,name:"max_img_size"},{anchor:"transformers.TvpConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
The number of frames extracted from a video.`,name:"num_frames"},{anchor:"transformers.TvpConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Tvp text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a>.`,name:"vocab_size"},{anchor:"transformers.TvpConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_size"},{anchor:"transformers.TvpConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TvpConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TvpConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TvpConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TvpConfig.max_grid_col_position_embeddings",description:`<strong>max_grid_col_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The largest number of horizontal patches from a video frame.`,name:"max_grid_col_position_embeddings"},{anchor:"transformers.TvpConfig.max_grid_row_position_embeddings",description:`<strong>max_grid_row_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The largest number of vertical patches from a video frame.`,name:"max_grid_row_position_embeddings"},{anchor:"transformers.TvpConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability of hidden layers.`,name:"hidden_dropout_prob"},{anchor:"transformers.TvpConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TvpConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TvpConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TvpConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability of attention layers.`,name:"attention_probs_dropout_prob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/configuration_tvp.py#L28"}}),ge=new G({props:{name:"from_backbone_config",anchor:"transformers.TvpConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/configuration_tvp.py#L175",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpConfig"
>TvpConfig</a></p>
`}}),ue=new G({props:{name:"to_dict",anchor:"transformers.TvpConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/configuration_tvp.py#L187",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, any]</code></p>
`}}),Me=new D({props:{title:"TvpImageProcessor",local:"transformers.TvpImageProcessor",headingTag:"h2"}}),Te=new G({props:{name:"class transformers.TvpImageProcessor",anchor:"transformers.TvpImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"constant_values",val:": typing.Union[float, collections.abc.Iterable[float]] = 0"},{name:"pad_mode",val:": PaddingMode = <PaddingMode.CONSTANT: 'constant'>"},{name:"do_normalize",val:": bool = True"},{name:"do_flip_channel_order",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.TvpImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;longest_edge&quot; -- 448}</code>):
Size of the output image after resizing. The longest edge of the image will be resized to
<code>size[&quot;longest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overridden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.TvpImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.TvpImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.TvpImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.TvpImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.TvpImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.TvpImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.TvpImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the padding. Can be overridden by the <code>pad_size</code> parameter in the
<code>preprocess</code> method.`,name:"pad_size"},{anchor:"transformers.TvpImageProcessor.constant_values",description:`<strong>constant_values</strong> (<code>Union[float, Iterable[float]]</code>, <em>optional</em>, defaults to 0) &#x2014;
The fill value to use when padding the image.`,name:"constant_values"},{anchor:"transformers.TvpImageProcessor.pad_mode",description:`<strong>pad_mode</strong> (<code>PaddingMode</code>, <em>optional</em>, defaults to <code>PaddingMode.CONSTANT</code>) &#x2014;
Use what kind of mode in padding.`,name:"pad_mode"},{anchor:"transformers.TvpImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.TvpImageProcessor.do_flip_channel_order",description:`<strong>do_flip_channel_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to flip the color channels from RGB to BGR. Can be overridden by the <code>do_flip_channel_order</code>
parameter in the <code>preprocess</code> method.`,name:"do_flip_channel_order"},{anchor:"transformers.TvpImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.TvpImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/image_processing_tvp.py#L85"}}),ye=new G({props:{name:"preprocess",anchor:"transformers.TvpImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]], typing.List[typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"constant_values",val:": typing.Union[float, collections.abc.Iterable[float], NoneType] = None"},{name:"pad_mode",val:": PaddingMode = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"do_flip_channel_order",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.TvpImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code> or <code>List[ImageInput]</code> or <code>List[List[ImageInput]]</code>) &#x2014;
Frames to preprocess.`,name:"videos"},{anchor:"transformers.TvpImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.TvpImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.TvpImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.TvpImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.TvpImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.TvpImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.TvpImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.TvpImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.TvpImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the padding. Can be overridden by the <code>pad_size</code> parameter in the
<code>preprocess</code> method.`,name:"pad_size"},{anchor:"transformers.TvpImageProcessor.preprocess.constant_values",description:`<strong>constant_values</strong> (<code>Union[float, Iterable[float]]</code>, <em>optional</em>, defaults to 0) &#x2014;
The fill value to use when padding the image.`,name:"constant_values"},{anchor:"transformers.TvpImageProcessor.preprocess.pad_mode",description:`<strong>pad_mode</strong> (<code>PaddingMode</code>, <em>optional</em>, defaults to &#x201C;PaddingMode.CONSTANT&#x201D;) &#x2014;
Use what kind of mode in padding.`,name:"pad_mode"},{anchor:"transformers.TvpImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.TvpImageProcessor.preprocess.do_flip_channel_order",description:`<strong>do_flip_channel_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_flip_channel_order</code>) &#x2014;
Whether to flip the channel order of the image.`,name:"do_flip_channel_order"},{anchor:"transformers.TvpImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.TvpImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.TvpImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.TvpImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.TvpImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/image_processing_tvp.py#L340"}}),_e=new D({props:{title:"TvpProcessor",local:"transformers.TvpProcessor",headingTag:"h2"}}),be=new G({props:{name:"class transformers.TvpProcessor",anchor:"transformers.TvpProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.TvpProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/processing_tvp.py#L23"}}),ve=new G({props:{name:"__call__",anchor:"transformers.TvpProcessor.__call__",parameters:[{name:"text",val:" = None"},{name:"videos",val:" = None"},{name:"return_tensors",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpProcessor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.TvpProcessor.__call__.videos",description:`<strong>videos</strong> (<code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>, <code>List[List[PIL.Image.Image]]</code>, <code>List[List[np.ndarray]]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>): The video or batch of videos to be prepared. Each video should be a list
of frames, which can be either PIL images or NumPy arrays. In case of NumPy arrays/PyTorch tensors,
each frame should be of shape (H, W, C), where H and W are frame height and width, and C is a number of
channels.`,name:"videos"},{anchor:"transformers.TvpProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/processing_tvp.py#L49",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>videos</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),we=new D({props:{title:"TvpModel",local:"transformers.TvpModel",headingTag:"h2"}}),Je=new G({props:{name:"class transformers.TvpModel",anchor:"transformers.TvpModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvpModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/modeling_tvp.py#L722"}}),Ie=new G({props:{name:"forward",anchor:"transformers.TvpModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TvpModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TvpModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.TvpModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TvpModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TvpModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvpModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvpModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvpModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/modeling_tvp.py#L757"}}),F=new $t({props:{$$slots:{default:[Et]},$$scope:{ctx:z}}}),H=new Wt({props:{anchor:"transformers.TvpModel.forward.example",$$slots:{default:[Qt]},$$scope:{ctx:z}}}),Ue=new D({props:{title:"TvpForVideoGrounding",local:"transformers.TvpForVideoGrounding",headingTag:"h2"}}),je=new G({props:{name:"class transformers.TvpForVideoGrounding",anchor:"transformers.TvpForVideoGrounding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvpForVideoGrounding.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpForVideoGrounding">TvpForVideoGrounding</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/modeling_tvp.py#L845"}}),Ce=new G({props:{name:"forward",anchor:"transformers.TvpForVideoGrounding.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[typing.Tuple[torch.Tensor]] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TvpForVideoGrounding.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TvpForVideoGrounding.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.TvpForVideoGrounding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TvpForVideoGrounding.forward.labels",description:`<strong>labels</strong> (<code>Tuple[torch.Tensor]</code> of shape <code>(batch_size, 3)</code>, <em>optional</em>) &#x2014;
The labels contains duration, start time, and end time of the video corresponding to the text.`,name:"labels"},{anchor:"transformers.TvpForVideoGrounding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TvpForVideoGrounding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvpForVideoGrounding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvpForVideoGrounding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvpForVideoGrounding.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tvp/modeling_tvp.py#L859"}}),E=new $t({props:{$$slots:{default:[St]},$$scope:{ctx:z}}}),Q=new Wt({props:{anchor:"transformers.TvpForVideoGrounding.forward.example",$$slots:{default:[Lt]},$$scope:{ctx:z}}}),xe=new Ht({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/tvp.md"}}),{c(){d=i("meta"),v=n(),p=i("p"),y=n(),f(_.$$.fragment),m=n(),w=i("div"),w.innerHTML=st,De=n(),f(q.$$.fragment),qe=n(),K=i("p"),K.innerHTML=at,Ke=n(),O=i("p"),O.textContent=rt,Oe=n(),ee=i("p"),ee.innerHTML=it,eo=n(),oe=i("p"),oe.textContent=lt,oo=n(),R=i("img"),to=n(),te=i("small"),te.innerHTML=ct,no=n(),ne=i("p"),ne.innerHTML=mt,so=n(),f(se.$$.fragment),ao=n(),ae=i("p"),ae.textContent=pt,ro=n(),re=i("p"),re.textContent=ft,io=n(),ie=i("p"),ie.textContent=ht,lo=n(),le=i("p"),le.innerHTML=gt,co=n(),de=i("p"),de.innerHTML=ut,mo=n(),f(ce.$$.fragment),po=n(),me=i("p"),me.textContent=Mt,fo=n(),pe=i("ul"),pe.innerHTML=Tt,ho=n(),f(fe.$$.fragment),go=n(),J=i("div"),f(he.$$.fragment),ko=n(),Ze=i("p"),Ze.innerHTML=yt,Bo=n(),Ge=i("p"),Ge.innerHTML=_t,Zo=n(),A=i("div"),f(ge.$$.fragment),Go=n(),ze=i("p"),ze.innerHTML=bt,zo=n(),X=i("div"),f(ue.$$.fragment),Vo=n(),Ve=i("p"),Ve.innerHTML=vt,uo=n(),f(Me.$$.fragment),Mo=n(),Z=i("div"),f(Te.$$.fragment),$o=n(),$e=i("p"),$e.textContent=wt,Wo=n(),N=i("div"),f(ye.$$.fragment),Ro=n(),We=i("p"),We.textContent=Jt,To=n(),f(_e.$$.fragment),yo=n(),j=i("div"),f(be.$$.fragment),Ao=n(),Re=i("p"),Re.textContent=It,Xo=n(),Ae=i("p"),Ae.innerHTML=Ut,No=n(),P=i("div"),f(ve.$$.fragment),Po=n(),Xe=i("p"),Xe.innerHTML=jt,_o=n(),f(we.$$.fragment),bo=n(),I=i("div"),f(Je.$$.fragment),Fo=n(),Ne=i("p"),Ne.textContent=Ct,Ho=n(),Pe=i("p"),Pe.innerHTML=xt,Eo=n(),Fe=i("p"),Fe.innerHTML=kt,Qo=n(),k=i("div"),f(Ie.$$.fragment),So=n(),He=i("p"),He.innerHTML=Bt,Lo=n(),f(F.$$.fragment),Yo=n(),f(H.$$.fragment),vo=n(),f(Ue.$$.fragment),wo=n(),U=i("div"),f(je.$$.fragment),Do=n(),Ee=i("p"),Ee.textContent=Zt,qo=n(),Qe=i("p"),Qe.innerHTML=Gt,Ko=n(),Se=i("p"),Se.innerHTML=zt,Oo=n(),B=i("div"),f(Ce.$$.fragment),et=n(),Le=i("p"),Le.innerHTML=Vt,ot=n(),f(E.$$.fragment),tt=n(),f(Q.$$.fragment),Jo=n(),f(xe.$$.fragment),Io=n(),Ye=i("p"),this.h()},l(e){const o=Ft("svelte-u9bgzb",document.head);d=l(o,"META",{name:!0,content:!0}),o.forEach(t),v=s(e),p=l(e,"P",{}),x(p).forEach(t),y=s(e),h(_.$$.fragment,e),m=s(e),w=l(e,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-13t8s2t"&&(w.innerHTML=st),De=s(e),h(q.$$.fragment,e),qe=s(e),K=l(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-ru7f7y"&&(K.innerHTML=at),Ke=s(e),O=l(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-vfdo9a"&&(O.textContent=rt),Oe=s(e),ee=l(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-ez3ksy"&&(ee.innerHTML=it),eo=s(e),oe=l(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-e6jl89"&&(oe.textContent=lt),oo=s(e),R=l(e,"IMG",{src:!0,alt:!0,width:!0}),to=s(e),te=l(e,"SMALL",{"data-svelte-h":!0}),c(te)!=="svelte-5ezgfp"&&(te.innerHTML=ct),no=s(e),ne=l(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-3zatzf"&&(ne.innerHTML=mt),so=s(e),h(se.$$.fragment,e),ao=s(e),ae=l(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1cyrqov"&&(ae.textContent=pt),ro=s(e),re=l(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1bgttui"&&(re.textContent=ft),io=s(e),ie=l(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1w5jusu"&&(ie.textContent=ht),lo=s(e),le=l(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1o30d19"&&(le.innerHTML=gt),co=s(e),de=l(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-wnh6z7"&&(de.innerHTML=ut),mo=s(e),h(ce.$$.fragment,e),po=s(e),me=l(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-axv494"&&(me.textContent=Mt),fo=s(e),pe=l(e,"UL",{"data-svelte-h":!0}),c(pe)!=="svelte-vh5qk9"&&(pe.innerHTML=Tt),ho=s(e),h(fe.$$.fragment,e),go=s(e),J=l(e,"DIV",{class:!0});var C=x(J);h(he.$$.fragment,C),ko=s(C),Ze=l(C,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1vsbyuh"&&(Ze.innerHTML=yt),Bo=s(C),Ge=l(C,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-o55m63"&&(Ge.innerHTML=_t),Zo=s(C),A=l(C,"DIV",{class:!0});var ke=x(A);h(ge.$$.fragment,ke),Go=s(ke),ze=l(ke,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1pi4u0y"&&(ze.innerHTML=bt),ke.forEach(t),zo=s(C),X=l(C,"DIV",{class:!0});var Be=x(X);h(ue.$$.fragment,Be),Vo=s(Be),Ve=l(Be,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-1amdb4q"&&(Ve.innerHTML=vt),Be.forEach(t),C.forEach(t),uo=s(e),h(Me.$$.fragment,e),Mo=s(e),Z=l(e,"DIV",{class:!0});var W=x(Z);h(Te.$$.fragment,W),$o=s(W),$e=l(W,"P",{"data-svelte-h":!0}),c($e)!=="svelte-18mjwp8"&&($e.textContent=wt),Wo=s(W),N=l(W,"DIV",{class:!0});var jo=x(N);h(ye.$$.fragment,jo),Ro=s(jo),We=l(jo,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1x3yxsa"&&(We.textContent=Jt),jo.forEach(t),W.forEach(t),To=s(e),h(_e.$$.fragment,e),yo=s(e),j=l(e,"DIV",{class:!0});var S=x(j);h(be.$$.fragment,S),Ao=s(S),Re=l(S,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-zs1zlw"&&(Re.textContent=It),Xo=s(S),Ae=l(S,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-a73fly"&&(Ae.innerHTML=Ut),No=s(S),P=l(S,"DIV",{class:!0});var Co=x(P);h(ve.$$.fragment,Co),Po=s(Co),Xe=l(Co,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-13t0ows"&&(Xe.innerHTML=jt),Co.forEach(t),S.forEach(t),_o=s(e),h(we.$$.fragment,e),bo=s(e),I=l(e,"DIV",{class:!0});var V=x(I);h(Je.$$.fragment,V),Fo=s(V),Ne=l(V,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1q1y37s"&&(Ne.textContent=Ct),Ho=s(V),Pe=l(V,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=xt),Eo=s(V),Fe=l(V,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=kt),Qo=s(V),k=l(V,"DIV",{class:!0});var L=x(k);h(Ie.$$.fragment,L),So=s(L),He=l(L,"P",{"data-svelte-h":!0}),c(He)!=="svelte-qa69mf"&&(He.innerHTML=Bt),Lo=s(L),h(F.$$.fragment,L),Yo=s(L),h(H.$$.fragment,L),L.forEach(t),V.forEach(t),vo=s(e),h(Ue.$$.fragment,e),wo=s(e),U=l(e,"DIV",{class:!0});var $=x(U);h(je.$$.fragment,$),Do=s($),Ee=l($,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-sl1gwa"&&(Ee.textContent=Zt),qo=s($),Qe=l($,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=Gt),Ko=s($),Se=l($,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-hswkmf"&&(Se.innerHTML=zt),Oo=s($),B=l($,"DIV",{class:!0});var Y=x(B);h(Ce.$$.fragment,Y),et=s(Y),Le=l(Y,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-110fgkf"&&(Le.innerHTML=Vt),ot=s(Y),h(E.$$.fragment,Y),tt=s(Y),h(Q.$$.fragment,Y),Y.forEach(t),$.forEach(t),Jo=s(e),h(xe.$$.fragment,e),Io=s(e),Ye=l(e,"P",{}),x(Ye).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",Dt),b(w,"class","flex flex-wrap space-x-1"),At(R.src,dt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/tvp_architecture.png")||b(R,"src",dt),b(R,"alt","drawing"),b(R,"width","600"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,d),a(e,v,o),a(e,p,o),a(e,y,o),g(_,e,o),a(e,m,o),a(e,w,o),a(e,De,o),g(q,e,o),a(e,qe,o),a(e,K,o),a(e,Ke,o),a(e,O,o),a(e,Oe,o),a(e,ee,o),a(e,eo,o),a(e,oe,o),a(e,oo,o),a(e,R,o),a(e,to,o),a(e,te,o),a(e,no,o),a(e,ne,o),a(e,so,o),g(se,e,o),a(e,ao,o),a(e,ae,o),a(e,ro,o),a(e,re,o),a(e,io,o),a(e,ie,o),a(e,lo,o),a(e,le,o),a(e,co,o),a(e,de,o),a(e,mo,o),g(ce,e,o),a(e,po,o),a(e,me,o),a(e,fo,o),a(e,pe,o),a(e,ho,o),g(fe,e,o),a(e,go,o),a(e,J,o),g(he,J,null),r(J,ko),r(J,Ze),r(J,Bo),r(J,Ge),r(J,Zo),r(J,A),g(ge,A,null),r(A,Go),r(A,ze),r(J,zo),r(J,X),g(ue,X,null),r(X,Vo),r(X,Ve),a(e,uo,o),g(Me,e,o),a(e,Mo,o),a(e,Z,o),g(Te,Z,null),r(Z,$o),r(Z,$e),r(Z,Wo),r(Z,N),g(ye,N,null),r(N,Ro),r(N,We),a(e,To,o),g(_e,e,o),a(e,yo,o),a(e,j,o),g(be,j,null),r(j,Ao),r(j,Re),r(j,Xo),r(j,Ae),r(j,No),r(j,P),g(ve,P,null),r(P,Po),r(P,Xe),a(e,_o,o),g(we,e,o),a(e,bo,o),a(e,I,o),g(Je,I,null),r(I,Fo),r(I,Ne),r(I,Ho),r(I,Pe),r(I,Eo),r(I,Fe),r(I,Qo),r(I,k),g(Ie,k,null),r(k,So),r(k,He),r(k,Lo),g(F,k,null),r(k,Yo),g(H,k,null),a(e,vo,o),g(Ue,e,o),a(e,wo,o),a(e,U,o),g(je,U,null),r(U,Do),r(U,Ee),r(U,qo),r(U,Qe),r(U,Ko),r(U,Se),r(U,Oo),r(U,B),g(Ce,B,null),r(B,et),r(B,Le),r(B,ot),g(E,B,null),r(B,tt),g(Q,B,null),a(e,Jo,o),g(xe,e,o),a(e,Io,o),a(e,Ye,o),Uo=!0},p(e,[o]){const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),F.$set(C);const ke={};o&2&&(ke.$$scope={dirty:o,ctx:e}),H.$set(ke);const Be={};o&2&&(Be.$$scope={dirty:o,ctx:e}),E.$set(Be);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),Q.$set(W)},i(e){Uo||(u(_.$$.fragment,e),u(q.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Ie.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(xe.$$.fragment,e),Uo=!0)},o(e){M(_.$$.fragment,e),M(q.$$.fragment,e),M(se.$$.fragment,e),M(ce.$$.fragment,e),M(fe.$$.fragment,e),M(he.$$.fragment,e),M(ge.$$.fragment,e),M(ue.$$.fragment,e),M(Me.$$.fragment,e),M(Te.$$.fragment,e),M(ye.$$.fragment,e),M(_e.$$.fragment,e),M(be.$$.fragment,e),M(ve.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(Ie.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(Ue.$$.fragment,e),M(je.$$.fragment,e),M(Ce.$$.fragment,e),M(E.$$.fragment,e),M(Q.$$.fragment,e),M(xe.$$.fragment,e),Uo=!1},d(e){e&&(t(v),t(p),t(y),t(m),t(w),t(De),t(qe),t(K),t(Ke),t(O),t(Oe),t(ee),t(eo),t(oe),t(oo),t(R),t(to),t(te),t(no),t(ne),t(so),t(ao),t(ae),t(ro),t(re),t(io),t(ie),t(lo),t(le),t(co),t(de),t(mo),t(po),t(me),t(fo),t(pe),t(ho),t(go),t(J),t(uo),t(Mo),t(Z),t(To),t(yo),t(j),t(_o),t(bo),t(I),t(vo),t(wo),t(U),t(Jo),t(Io),t(Ye)),t(d),T(_,e),T(q,e),T(se,e),T(ce,e),T(fe,e),T(he),T(ge),T(ue),T(Me,e),T(Te),T(ye),T(_e,e),T(be),T(ve),T(we,e),T(Je),T(Ie),T(F),T(H),T(Ue,e),T(je),T(Ce),T(E),T(Q),T(xe,e)}}}const Dt='{"title":"TVP","local":"tvp","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"TvpConfig","local":"transformers.TvpConfig","sections":[],"depth":2},{"title":"TvpImageProcessor","local":"transformers.TvpImageProcessor","sections":[],"depth":2},{"title":"TvpProcessor","local":"transformers.TvpProcessor","sections":[],"depth":2},{"title":"TvpModel","local":"transformers.TvpModel","sections":[],"depth":2},{"title":"TvpForVideoGrounding","local":"transformers.TvpForVideoGrounding","sections":[],"depth":2}],"depth":1}';function qt(z){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rn extends Nt{constructor(d){super(),Pt(this,d,qt,Yt,Rt,{})}}export{rn as component};
