import{s as Qt,o as Yt,n as zt}from"../chunks/scheduler.18a86fab.js";import{S as St,i as xt,g as n,s as t,r as o,A as Ht,h as y,f as s,c as a,j as Vt,u as U,x as i,k as $t,y as Lt,a as M,v as p,d as w,t as T,w as d}from"../chunks/index.98837b22.js";import{T as Ft}from"../chunks/Tip.77304350.js";import{C as j}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as J}from"../chunks/Heading.7e7e0c5b.js";import{E as Ot}from"../chunks/getInferenceSnippets.de10bc7d.js";function Dt(fe){let c,m="Modular Transformers isn’t meant to replace the modeling code, and if your model isn’t based on an existing model, you’ll need to add a <code>modeling.py</code> file manually. Likewise, if a configuration, tokenization or processing file can’t easily inherit from a similar file, you can add that file directly.";return{c(){c=n("p"),c.innerHTML=m},l(C){c=y(C,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1wc3n5d"&&(c.innerHTML=m)},m(C,Ie){M(C,c,Ie)},p:zt,d(C){C&&s(c)}}}function Pt(fe){let c,m,C,Ie,h,Ae,I,ZM="Modular Transformers lowers the bar for contributing models and significantly reduces the code required to add a model by allowing imports and inheritance.",be,u,GM='One of Transformers’ core design feature is the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a> policy. Model components - such as attention layers - are repeated across many files and any independent implementations tend to diverge as fixes and changes are applied to specific parts of the code.',_e,f,BM='The <a href="./pr_checks#check-copies"><code># Copied from</code></a> statements prevents the code from diverging, and it is enforced by our continuous integration tests and local commands. The downside is that this approach is tedious and adds significantly more lines of code, most of which is boilerplate.',Ze,A,Ge,b,kM="Modular Transformers addresses these issues by adding a <em>modular</em> file to a model folder. The modular file can import code from other models and inherit code from other classes unlike traditional modeling and processing files.",Be,r,ke,_,RM="A modular file contains model, processor, and configuration class code that would otherwise be in separate files under the single model, single file policy.",Re,Z,vM="Model users still import and use the single-file interface they’ve grown familiar with. In doing so, we hope to enable simpler contributions while sticking to our philosophy.",ve,G,We,B,WM="A linter “unravels” the modular file into a <code>modeling.py</code> file to preserve the single model, single file directory structure (modeling, processor, etc.). Inheritance is flattened to only a <strong>single</strong> level.",ge,k,gM="Run the command below to automatically generate a <code>modeling.py</code> file from a modular file.",Ne,R,Ee,v,NM="For example:",Xe,W,EM="<li>If a configuration class inherits from another class, but adds and deletes an argument, the generated file directly references it if an argument is added or completely removes it if an argument is deleted.</li> <li>If a class inherits from another, like <code>GemmaModel(LlamaModel)</code>, the dependencies are automatically inferred. All submodules are also automatically inferred from the superclass.</li> <li>If a new function is defined in the modular file and used inside classes, the linter automatically infers these as well.</li>",Ve,g,XM="You should be able to write everything (tokenizer, image processor, model, config, etc.) in a modular and their corresponding single-files are generated.",$e,N,VM="Run the command below to ensure the generated content matches <code>modular_&lt;your_model&gt;.py</code>.",Qe,E,Ye,X,$M="The example below demonstrates how a model can be added with significantly fewer lines of code with Modular Transformers.",ze,V,Se,$,QM="BERT and RoBERTa, two very similar models, differ solely in how the embedding layer is implemented.",xe,Q,YM="Instead of redefining the model entirely, consider the <code>modular_roberta.py</code> file shown below for the modeling and configuration classes (the tokenizer isn’t shown in this example).",He,Y,Le,z,zM="If you don’t use the defined dependency, you’ll receive the following error.",Fe,S,Oe,x,De,H,SM='The easiest way to start is by browsing Transformers for a model similar to yours in order to inherit from it. Some good starting points are <a href="./model_doc/mistral">Mistral</a>, <a href="./model_doc/qwen2">Qwen2</a>, <a href="./model_doc/cohere">Cohere</a> and <a href="./model_doc/cohere2">Cohere</a>, and <a href="./model_doc/llama">Llama</a>. Refer to the table below for components your model might be using and where you can inherit from.',Pe,L,xM="<thead><tr><th>Component</th> <th>Model</th></tr></thead> <tbody><tr><td>Mixture of expert</td> <td>SwitchTransformers or Mixtral</td></tr> <tr><td>Interleaved (and/or partial) rotary embedding</td> <td>GLM, Phi</td></tr> <tr><td>State space models</td> <td>Jamba, Bamba, Zamba, Mamba2</td></tr> <tr><td>Recurrent hidden states</td> <td>Gemma2</td></tr> <tr><td>Sliding window attention/full attention patterns per layer</td> <td>Gemma2, Cohere2</td></tr> <tr><td>QKV clipping</td> <td>Olmo</td></tr> <tr><td>QK normalization</td> <td>Olmo2, Cohere</td></tr> <tr><td>Fused QKV (not recommended)</td> <td>Phi3</td></tr></tbody>",Ke,F,HM='This section will walk you through how to implement <a href="./model_doc/olmo2">Olmo2</a> from <a href="./model_doc/olmo">Olmo</a> with modular Transformers (you can refer to the original <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modular_olmo2.py" rel="nofollow">modeling.py</a> file).',qe,O,ls,D,LM="The modular <code>Olmo2Config</code> is shown below.",es,P,ss,K,FM="There are three points where the <code>Olmo2Config</code> is different from the original <code>OlmoConfig</code>.",Ms,q,OM="<li>The default value of most arguments have changed.</li> <li>There is a new argument, <code>rms_norm_eps</code>.</li> <li>The <code>clip_qkv</code> argument isn’t used anymore.</li>",ts,ll,DM="For the new default values and argument, overwrite the <code>__init__</code> function with the new default values and add <code>rms_norm_eps</code>. Assign <code>rms_norm_eps</code> to <code>self</code> in the body of <code>__init__</code>. For the <code>clip_qkv</code> argument, use <code>del self.clip_qkv</code> to remove the assignment of this attribute in the unraveled code (post-linter conversion).",as,el,PM="Notice how the <code>super().__init__(...)</code> is used. Typically, it calls the parent <code>__init__</code>.",ns,sl,KM="But in modular Transformers, if there is a call like <code>super().my_function(...)</code>, the linter takes the body of <code>my_function</code> in the parent and unravels it where the call to <code>super().my_function(...)</code> occurred. The <code>del self.clip_qkv</code> statement removes the reference to <code>self.clip_qkv</code> in the unraveled body.",ys,Ml,qM="<code>del self.</code> and <code>super().my_function(..)</code> work together, and it should always be placed after <code>super().my_function(...)</code>. You can add whatever you want <em>before</em> calling <code>super()</code>, and it is placed before the parents body.",is,tl,os,al,Us,nl,lt="Nothing needs to be modified in <code>LlamaRMSNorm</code>. The linter unravels the exact content of <code>LlamaRMSNorm</code> into <code>Olmo2RMSNorm</code>. References to Llama in the docstrings, type hints, and comments are also changed to Olmo2.",ps,yl,ws,il,et="The modular <code>Olmo2Attention</code> is shown below.",Ts,ol,ds,Ul,st="The <code>super().__init__(...)</code> copies the parent definition and adds 2 new layers from <code>Olmo2RMSNorm</code>. The forward pass needs to be overwritten to use these 2 new layers. A pass with the norm layers is added before projecting with <code>q_proj</code> and <code>k_proj</code>. To make it easier, the <code>eager_attention_forward</code> function is directly imported from Llama and the <code>apply_rotary_pos_emb</code> is imported from Olmo.",js,pl,Mt="The linter automatically adds these imported functions in the final <code>modeling_olmo2.py</code> file by copying their definitions from the source files. The <code>rotate_half</code> and <code>repeat_kv</code> functions are also added because they are used inside <code>apply_rotary_pos_emb</code> and <code>eager_attention_forward</code>.",Js,wl,tt="The <code>Attention</code> class had to be redefined because there weren’t any existing models with an <code>Attention</code> layer that included a <code>RMSNorm</code> layer.",cs,Tl,Cs,dl,at="The modular <code>DecoderLayer</code> is shown below.",rs,jl,ms,Jl,nt="The norm type is switched in <code>__init__</code> by overwriting <code>self.post_attention_layernorm</code> after the call to <code>super().__init__(...)</code>. Delete the <code>self.input_layernorm</code> attributed and replace it with <code>self.post_feedforward_layernorm</code> because it is applied after in Olmo2. The forward method is overwritten to reflect this change.",hs,cl,yt="If you only switched <code>self.post_feedforward_layernorm</code> and <code>self.input_layernorm</code> from <code>LayerNorm</code> to <code>RMSNorm</code> without also changing the name and logic of <code>self.input_layernorm</code>, then you wouldn’t have to rewrite the forward method.",Is,Cl,us,rl,it="The modular <code>Olmo2Model</code> class is shown below.",fs,ml,As,hl,ot="You only need to change the <em>type</em> of the <code>self.norm</code> attribute to use <code>RMSNorm</code> instead of <code>LayerNorm</code>. This change doesn’t affect the logic in the forward method (layer name and usage is identical to the parent class), so you don’t need to overwrite it. The linter automatically unravels it.",bs,Il,_s,ul,Ut="The modular causal modeling head is shown below.",Zs,fl,Gs,Al,pt="The logic is identical to <code>OlmoForCausalLM</code> which means you don’t need to make any changes here.",Bs,bl,ks,_l,wt='The <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">modeling_olmo2.py</a> generated by the linter also contains some classes (<code>Olmo2MLP</code>, <code>Olmo2RotaryEmbedding</code>, <code>Olmo2PreTrainedModel</code>) that weren’t explicitly defined in <code>modular_olmo2.py</code>.',Rs,Zl,Tt="Classes that are a dependency of an inherited class but aren’t explicitly defined are automatically added as a part of dependency tracing. This is similar to how some functions were added to the <code>Attention</code> class without directly importing them.",vs,Gl,dt="For example, <code>OlmoDecoderLayer</code> has an attribute defined as <code>self.mlp = OlmoMLP(config)</code>. This class was never explicitly redefined in <code>Olmo2MLP</code>, so the linter automatically created a <code>Olmo2MLP</code> class similar to <code>OlmoMLP</code>. It is identical to the code below if it was explicitly written in <code>modular_olmo2.py</code>.",Ws,Bl,gs,kl,jt="However, it was necessary to rewrite <code>Olmo2RMSNorm</code> because the layer norm needed to be redefined in the <code>Attention</code> and <code>DecoderLayer</code> classes. Similarly, this is why you didn’t need to create the <code>Olmo2PreTrainedModel</code> and <code>Olmo2RotaryEmbedding</code> classes.",Ns,Rl,Jt="Classes that aren’t rewritten are copied from the file where the inherited module first uses them. This means if you wanted <code>Olmo2MLP</code> to inherit from <code>MistralMLP</code> instead, you would need to be more explicit as shown below.",Es,vl,Xs,Wl,Vs,gl,ct="You can <code>del</code> to remove attributes defined in the parent after using <code>super().__init__()</code>. However, this doesn’t work if the attribute is also used somewhere else as shown below. It only suppresses the assignment. The <code>self.attribute = config.attribute</code> line is removed, but the <code>if</code> statement remains and references the attribute.",$s,Nl,Qs,El,Ys,Xl,Ct="If you still want to inherit from <code>DummyModel</code> but don’t want to remove the <code>self.attribute</code>, be explicit about which class’ <code>super()</code> you’re calling. The example below shows how to call the <code>super()</code> of <code>nn.Module</code> (unraveled code shown on the right)",zs,Vl,Ss,$l,xs,Ql,rt="Remove an attribute by overwriting it with a <code>raise AttributeError(&quot;&quot;)</code> statement to mimic the behavior you want when you remove a parent function in Python. The example below removes the methods in the unraveled code.",Hs,Yl,Ls,zl,Fs,Sl,mt="By default, if you inherit from a class and override a method with one or more decorators in the parent method, the decorators are also added to the unraveled code <em>only if you don’t add any yourself</em>. Otherwise, the redefined decorator is used.",Os,xl,ht="For example, if you had a parent class shown below and you overwrite it, the parent decorator is kept.",Ds,Hl,Ps,Ll,It="Modular code is shown on the left, and the unraveled code is shown on the right.",Ks,Fl,qs,Ol,ut="But if you add a new decorator, your new decorator is used instead.",lM,Dl,eM,Pl,sM,Kl,ft="In scenarios where a forward method is really long and you want to switch decorators, you don’t need to redefine everything and copy/paste the function. You can use <code>super().forward(...)</code> to unravel the parent body. When there are a lot of arguments in the function signature, use the special <code>**super_kwargs</code> syntax in the overwritten signature.",MM,ql,At='This syntax indicates to the linter to unravel all the parent signature arguments here. An example signature in a <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> model is shown below, with lots of arguments.',tM,le,aM,ee,bt="Instead of rewriting and copying/pasting all of those arguments, use the <code>super().forward(**super_kwargs)</code> statement (modular code shown on the left, unraveled code on the right).",nM,se,yM,Me,_t="This makes it very easy to switch decorators and makes it explicit that the only change you want to apply is the decorator.",iM,te,Zt="<code>**super_kwargs</code> should not be used to avoid being explicit when redefining methods though. If you overwrite a method, you should explicitly write the signature as you normally would. The <code>**super_kwargs</code> syntax is a shortcut for switching decorators and a few other niche cases.",oM,ae,UM,ne,Gt="If an object defined in both the modular and modeling file from which it inherits, the modular definition has precedence unless for assignments containing the pattern <code>DOCSTRING</code>. These variables are typically used in <code>MODEL_START_DOCSTRING</code> and <code>MODEL_INPUT_DOCSTRING</code> in the modeling files. They are big blocks of docstrings and the linter rewrites the names everywhere. For this reason, assignments containing the <code>DOCSTRING</code> variable can use the definition found in the source file without copying the whole docstring, by simply setting the variable to <code>None</code> in the modular file.",pM,ye,Bt='This is very useful if you need the variable reference somewhere but you don’t want to clutter the modular file with docstrings which are always the same. The example code below allows you to automatically use the same docstrings from <a href="./model_doc/mistral">Mistral</a> in <a href="./model_doc/starcoder2">Starcoder2</a>.',wM,ie,TM,oe,kt="Setting the variable to anything other than <code>None</code> will override the docstring, so that you can customize the docstrings if needed.",dM,Ue,jM,pe,Rt="The linter automatically renames everything when inheriting from a class. For consistency, you should always use the same class name prefix when inheriting from different classes from the same file.",JM,we,vt="The example below is not recommended. It breaks standards in the library, <code>MyModelIncredibleMLP</code> instead of <code>LlamaMLP</code>, and because the linter doesn’t know how to rename potential higher-order dependencies (<code>MyModelIncredible</code> or just <code>MyModel</code>).",cM,Te,CM,de,Wt='However, if there aren’t any <a href="#other-classes">implicit dependencies</a>, then you can locally rename a single class. Make sure you still explicitly redefine every other mention of the class with the new name pattern though. For example, all mentions of <code>LlamaMLP</code> should be renamed to <code>MyModelIncredibleMLP</code> otherwise the linter may add a new and unwanted <code>MyModelMLP</code> class.',rM,je,gt="The linter raises a warning if an ambiguous case is detected. It explains what is happening and which prefix is used by default for getting the dependencies. These warning and renaming pattern complications usually only come up when defining multimodal models. For example, adding <code>Text</code> to class names in a multimodal model to make it clear which modality it refers to.",mM,Je,hM,ce,Nt="If there are automatic dependencies with a prefix, but you want another one, explicitly rename the classes locally with a <code>pass</code> class as shown in the following.",IM,Ce,uM,re,fM,me,Et="When inheriting a <code>Config</code> class or adding and deleting attributes, you may want to only redefine the new attributes in the docstring. However, the linter doesn’t support this yet. You need to directly add the while docstring directly in the modular file under the class definition.",AM,he,bM,ue,_M;return h=new J({props:{title:"Modular Transformers",local:"modular-transformers",headingTag:"h1"}}),A=new J({props:{title:"Motivation",local:"motivation",headingTag:"h2"}}),r=new Ft({props:{warning:!1,$$slots:{default:[Dt]},$$scope:{ctx:fe}}}),G=new J({props:{title:"Create a modeling.py file",local:"create-a-modelingpy-file",headingTag:"h2"}}),R=new j({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZtb2R1bGFyX21vZGVsX2NvbnZlcnRlci5weSUyMC0tZmlsZXNfdG9fcGFyc2UlMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkYlM0N5b3VyX21vZGVsJTNFJTJGbW9kdWxhcl8lM0N5b3VyX21vZGVsJTNFLnB5",highlighted:"python utils/modular_model_converter.py --files_to_parse src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),E=new j({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19tb2R1bGFyX2NvbnZlcnNpb24ucHklMjAtLWZpbGVzJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGJTNDeW91cl9tb2RlbCUzRSUyRm1vZHVsYXJfJTNDeW91cl9tb2RlbCUzRS5weQ==",highlighted:"python utils/check_modular_conversion.py --files src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),V=new J({props:{title:"BERT and RoBERTa",local:"bert-and-roberta",headingTag:"h3"}}),Y=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># RoBERTa and BERT config is identical</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># Redefine the embeddings to highlight the padding id difference, and redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># RoBERTa and BERT model is identical except for the embedding layer, which is defined above, so no need for additional changes here</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)


<span class="hljs-comment"># The model heads now only need to redefine the model inside to \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),S=new j({props:{code:"VmFsdWVFcnJvciUzQSUyMFlvdSUyMGRlZmluZWQlMjAlNjBSb2JlcnRhRW1iZWRkaW5ncyU2MCUyMGluJTIwdGhlJTIwbW9kdWxhcl9yb2JlcnRhLnB5JTJDJTIwaXQlMjBzaG91bGQlMjBiZSUyMHVzZWQlMjB3aGVuJTIweW91JTIwZGVmaW5lJTIwJTYwQmVydE1vZGVsJTYwJTJDJTIwYXMlMjBpdCUyMGlzJTIwb25lJTIwb2YlMjBpdCdzJTIwZGlyZWN0JTIwZGVwZW5kZW5jaWVzLiUyME1ha2UlMjBzdXJlJTIweW91JTIwdXNlJTIwaXQlMjBpbiUyMHRoZSUyMCU2MF9faW5pdF9fJTYwJTIwZnVuY3Rpb24u",highlighted:'<span class="hljs-symbol">ValueError:</span> You defined `RobertaEmbeddings` <span class="hljs-keyword">in</span> the modular_roberta.py, it should be used <span class="hljs-keyword">when</span> you define `BertModel`, <span class="hljs-keyword">as</span> it <span class="hljs-built_in">is</span> one <span class="hljs-keyword">of</span> it<span class="hljs-comment">&#x27;s direct dependencies. Make sure you use it in the `__init__` function.</span>',wrap:!1}}),x=new J({props:{title:"Implementing a modular file",local:"implementing-a-modular-file",headingTag:"h2"}}),O=new J({props:{title:"Config",local:"config",headingTag:"h3"}}),P=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.configuration_olmo <span class="hljs-keyword">import</span> OlmoConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Config</span>(<span class="hljs-title class_ inherited__">OlmoConfig</span>):
    <span class="hljs-string">r&quot;&quot;&quot;
    This is the configuration class to store the configuration of a [Olmo2Model](/docs/transformers/main/en/model_doc/olmo2#transformers.Olmo2Model).
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        vocab_size=<span class="hljs-number">50304</span>,
        hidden_size=<span class="hljs-number">4096</span>,
        intermediate_size=<span class="hljs-number">11008</span>,
        num_hidden_layers=<span class="hljs-number">32</span>,
        num_attention_heads=<span class="hljs-number">32</span>,
        num_key_value_heads=<span class="hljs-literal">None</span>,
        hidden_act=<span class="hljs-string">&quot;silu&quot;</span>,
        max_position_embeddings=<span class="hljs-number">2048</span>,
        initializer_range=<span class="hljs-number">0.02</span>,
        use_cache=<span class="hljs-literal">True</span>,
        pad_token_id=<span class="hljs-number">1</span>,
        bos_token_id=<span class="hljs-literal">None</span>,
        eos_token_id=<span class="hljs-number">50279</span>,
        tie_word_embeddings=<span class="hljs-literal">False</span>,
        rope_theta=<span class="hljs-number">10000.0</span>,
        rope_scaling=<span class="hljs-literal">None</span>,
        attention_bias=<span class="hljs-literal">False</span>,
        attention_dropout=<span class="hljs-number">0.0</span>,
        rms_norm_eps=<span class="hljs-number">1e-5</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__(
            vocab_size=vocab_size,
            hidden_size=hidden_size,
            intermediate_size=intermediate_size,
            num_hidden_layers=num_hidden_layers,
            num_attention_heads=num_attention_heads,
            num_key_value_heads=num_key_value_heads,
            hidden_act=hidden_act,
            max_position_embeddings=max_position_embeddings,
            initializer_range=initializer_range,
            use_cache=use_cache,
            pad_token_id=pad_token_id,
            bos_token_id=bos_token_id,
            eos_token_id=eos_token_id,
            tie_word_embeddings=tie_word_embeddings,
            rope_theta=rope_theta,
            rope_scaling=rope_scaling,
            attention_bias=attention_bias,
            attention_dropout=attention_dropout,
            **kwargs,
        )

        self.rms_norm_eps = rms_norm_eps
        <span class="hljs-keyword">del</span> self.clip_qkv`,wrap:!1}}),tl=new J({props:{title:"Norm",local:"norm",headingTag:"h3"}}),al=new j({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBMbGFtYVJNU05vcm0lMEElMEFjbGFzcyUyME9sbW8yUk1TTm9ybShMbGFtYVJNU05vcm0pJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> LlamaRMSNorm

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2RMSNorm</span>(<span class="hljs-title class_ inherited__">LlamaRMSNorm</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),yl=new J({props:{title:"Attention",local:"attention",headingTag:"h3"}}),ol=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> eager_attention_forward
<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoAttention, apply_rotary_pos_emb


<span class="hljs-comment"># Olmo2 attention is identical to OLMo attention except:</span>
<span class="hljs-comment"># - Norm is applied to attention queries and keys.</span>
<span class="hljs-comment"># - No qkv clipping.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Attention</span>(<span class="hljs-title class_ inherited__">OlmoAttention</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.q_norm = Olmo2RMSNorm(config.num_attention_heads * self.head_dim, config.rms_norm_eps)
        self.k_norm = Olmo2RMSNorm(config.num_key_value_heads * self.head_dim, config.rms_norm_eps)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        position_embeddings: <span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor],
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor], <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor]]]:
        input_shape = hidden_states.shape[:-<span class="hljs-number">1</span>]
        hidden_shape = (*input_shape, -<span class="hljs-number">1</span>, self.head_dim)

        query_states = self.q_norm(self.q_proj(hidden_states))
        key_states = self.k_norm(self.k_proj(hidden_states))
        value_states = self.v_proj(hidden_states)

        query_states = query_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        key_states = key_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        value_states = value_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)

        cos, sin = position_embeddings
        query_states, key_states = apply_rotary_pos_emb(query_states, key_states, cos, sin)

        <span class="hljs-keyword">if</span> past_key_value <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># sin and cos are specific to RoPE models; cache_position needed for the static cache</span>
            cache_kwargs = {<span class="hljs-string">&quot;sin&quot;</span>: sin, <span class="hljs-string">&quot;cos&quot;</span>: cos, <span class="hljs-string">&quot;cache_position&quot;</span>: cache_position}
            key_states, value_states = past_key_value.update(key_states, value_states, self.layer_idx, cache_kwargs)

        attention_interface: <span class="hljs-type">Callable</span> = eager_attention_forward
        <span class="hljs-keyword">if</span> self.config._attn_implementation != <span class="hljs-string">&quot;eager&quot;</span>:
            attention_interface = ALL_ATTENTION_FUNCTIONS[self.config._attn_implementation]

        attn_output, attn_weights = attention_interface(
            self,
            query_states,
            key_states,
            value_states,
            attention_mask,
            dropout=<span class="hljs-number">0.0</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.training <span class="hljs-keyword">else</span> self.attention_dropout,
            scaling=self.scaling,
            **kwargs,
        )

        attn_output = attn_output.reshape(*input_shape, -<span class="hljs-number">1</span>).contiguous()
        attn_output = self.o_proj(attn_output)
        <span class="hljs-keyword">return</span> attn_output, attn_weights`,wrap:!1}}),Tl=new J({props:{title:"DecoderLayer",local:"decoderlayer",headingTag:"h3"}}),jl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoDecoderLayer

<span class="hljs-comment"># The OLMo2 layers are identical to those of the OLMo model except:</span>
<span class="hljs-comment"># - RMSNorm is used instead of standard layer norm.</span>
<span class="hljs-comment"># - Norm is applied after attention/feedforward rather than before.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2DecoderLayer</span>(<span class="hljs-title class_ inherited__">OlmoDecoderLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.post_attention_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.post_feedforward_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.self_attn = Olmo2Attention(config=config, layer_idx=layer_idx)
        <span class="hljs-keyword">del</span> self.input_layernorm

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        position_embeddings: <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor]] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># necessary, but kept here for BC</span>
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.FloatTensor, <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.FloatTensor, torch.FloatTensor]]]:
        residual = hidden_states

        <span class="hljs-comment"># Self Attention</span>
        hidden_states, self_attn_weights = self.self_attn(
            hidden_states=hidden_states,
            attention_mask=attention_mask,
            position_ids=position_ids,
            past_key_value=past_key_value,
            output_attentions=output_attentions,
            use_cache=use_cache,
            cache_position=cache_position,
            position_embeddings=position_embeddings,
            **kwargs,
        )
        hidden_states = self.post_attention_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        <span class="hljs-comment"># Fully Connected</span>
        residual = hidden_states
        hidden_states = self.mlp(hidden_states)
        hidden_states = self.post_feedforward_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        outputs = (hidden_states,)
        <span class="hljs-keyword">if</span> output_attentions:
            outputs += (self_attn_weights,)

        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),Cl=new J({props:{title:"Model",local:"model",headingTag:"h3"}}),ml=new j({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01vZGVsJTBBJTBBJTIzJTIwVGhlJTIwT0xNbzIlMjBtb2RlbCUyMGlzJTIwaWRlbnRpY2FsJTIwdG8lMjB0aGUlMjBPTE1vJTIwbW9kZWwlMkMlMjBleGNlcHQlMjBSTVNOb3JtJTIwaXMlMjB1c2VkJTIwaW5zdGVhZCUyMG9mJTBBJTIzJTIwc3RhbmRhcmQlMjBsYXllciUyMG5vcm0lMjBmb3IlMjB0aGUlMjBvdXRwdXQlMjBub3JtLiUwQWNsYXNzJTIwT2xtbzJNb2RlbChPbG1vTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME9sbW8yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcuaGlkZGVuX3NpemUlMkMlMjBlcHMlM0Rjb25maWcucm1zX25vcm1fZXBzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJzJTIwJTNEJTIwbm4uTW9kdWxlTGlzdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJPbG1vMkRlY29kZXJMYXllcihjb25maWclMkMlMjBsYXllcl9pZHgpJTIwZm9yJTIwbGF5ZXJfaWR4JTIwaW4lMjByYW5nZShjb25maWcubnVtX2hpZGRlbl9sYXllcnMpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoModel

<span class="hljs-comment"># The OLMo2 model is identical to the OLMo model, except RMSNorm is used instead of</span>
<span class="hljs-comment"># standard layer norm for the output norm.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Model</span>(<span class="hljs-title class_ inherited__">OlmoModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.norm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.layers = nn.ModuleList(
            [Olmo2DecoderLayer(config, layer_idx) <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)]
        )`,wrap:!1}}),Il=new J({props:{title:"Model head",local:"model-head",headingTag:"h3"}}),fl=new j({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb0ZvckNhdXNhbExNJTBBJTBBY2xhc3MlMjBPbG1vMkZvckNhdXNhbExNKE9sbW9Gb3JDYXVzYWxMTSklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoForCausalLM

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2ForCausalLM</span>(<span class="hljs-title class_ inherited__">OlmoForCausalLM</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),bl=new J({props:{title:"Other classes",local:"other-classes",headingTag:"h3"}}),Bl=new j({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01MUCUwQSUwQWNsYXNzJTIwT2xtbzJNTFAoT2xtb01MUCklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">OlmoMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),vl=new j({props:{code:"JTIzJTIwc3dpdGNoJTIwdG8lMjBtaXN0cmFsJTIwZGVmaW5pdGlvbiUwQWZyb20lMjAuLm1pc3RyYWwubW9kZWxpbmdfbWlzdHJhbCUyMGltcG9ydCUyME1pc3RyYWxNTFAlMEElMEFjbGFzcyUyME9sbW8yTUxQKE1pc3RyYWxNTFApJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-comment"># switch to mistral definition</span>
<span class="hljs-keyword">from</span> ..mistral.modeling_mistral <span class="hljs-keyword">import</span> MistralMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">MistralMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Wl=new J({props:{title:"Removing attributes",local:"removing-attributes",headingTag:"h2"}}),Nl=new j({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwRHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwc2VsZi5hdHRyaWJ1dGUlMjAlM0QlMjBjb25maWcuYXR0cmlidXRlJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmF0dHJpYnV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwbW9yZSUyMHN0dWZmJTIwd2l0aCUyMCU2MHNlbGYuYXR0cmlidXRlJTYwJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUwQWNsYXNzJTIwTXlOZXdEdW1teU1vZGVsKER1bW15TW9kZWwpJTNBJTBBJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhjb25maWcpJTBBJTIwJTIwJTIwJTIwZGVsJTIwc2VsZi5hdHRyaWJ1dGU=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: DummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__()
    self.attribute = config.attribute
    <span class="hljs-keyword">if</span> self.attribute:
      <span class="hljs-comment"># do more stuff with \`self.attribute\` here</span>
      ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-keyword">del</span> self.attribute`,wrap:!1}}),El=new J({props:{title:"Explicit super() calls",local:"explicit-super-calls",headingTag:"h2"}}),Vl=new j({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCUyQyUyMG5uLk1vZHVsZSklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjBjbGFzcyUyME15TmV3RHVtbXlNb2RlbChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlLl9faW5pdF9fKGNvbmZpZyklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(DummyModel, nn.Module):        |     <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(nn.Module):
                                                     |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):      |       <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    nn.Module.__init__(config)                       |         <span class="hljs-built_in">super</span>().__init__()
    self.foo = config.foo                            |         self.foo = config.foo
    ...                                              |         ...`,wrap:!1}}),$l=new J({props:{title:"Deleting unused methods",local:"deleting-unused-methods",headingTag:"h2"}}),Yl=new j({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfc3BtX3Byb2Nlc3NvcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdW5rX3Rva2VuX2xlbmd0aChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(<span class="hljs-title class_ inherited__">LlamaTokenizer</span>):
    ...

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_spm_processor</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">unk_token_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)`,wrap:!1}}),zl=new J({props:{title:"Defining new functions",local:"defining-new-functions",headingTag:"h2"}}),Hl=new j({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBkZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc3R1ZmYlMjBoZXJl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):
  ...

<span class="hljs-meta">  @decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
    <span class="hljs-comment"># do stuff here</span>`,wrap:!1}}),Fl=new j({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MGRlY29yYXRvciguLi4pJTBBJTIwJTIwJTIwJTIwLi4uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     @decorator(...)
    ...                           |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
                                  |       ...`,wrap:!1}}),Dl=new j({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
<span class="hljs-meta">  @my_new_decorator(<span class="hljs-params">...</span>)          |     @my_new_decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
    ...                           |       ...`,wrap:!1}}),Pl=new J({props:{title:"super_kwargs",local:"superkwargs",headingTag:"h2"}}),le=new j({props:{code:"Y2xhc3MlMjBMbGFtYUZvckNhdXNhbExNKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBhZGRfc3RhcnRfZG9jc3RyaW5nc190b19tb2RlbF9mb3J3YXJkKExMQU1BX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTQwcmVwbGFjZV9yZXR1cm5fZG9jc3RyaW5ncyhvdXRwdXRfdHlwZSUzRENhdXNhbExNT3V0cHV0V2l0aFBhc3QlMkMlMjBjb25maWdfY2xhc3MlM0RfQ09ORklHX0ZPUl9ET0MpJTBBJTIwJTIwZGVmJTIwZm9yd2FyZCglMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNBJTIwdG9yY2guTG9uZ1RlbnNvciUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHBvc2l0aW9uX2lkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwYXN0X2tleV92YWx1ZXMlM0ElMjBPcHRpb25hbCU1QlVuaW9uJTVCQ2FjaGUlMkMlMjBMaXN0JTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlNUQlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzX2VtYmVkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5Mb25nVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfYXR0ZW50aW9ucyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfaGlkZGVuX3N0YXRlcyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBudW1fbG9naXRzX3RvX2tlZXAlM0ElMjBpbnQlMjAlM0QlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlM0ElMjBVbnBhY2slNUJLd2FyZ3NGb3JDYXVzYWxMTSU1RCUyQyUwQSUyMCUyMCklMjAtJTNFJTIwVW5pb24lNUJUdXBsZSUyQyUyMENhdXNhbExNT3V0cHV0V2l0aFBhc3QlNUQlM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...

<span class="hljs-meta">  @add_start_docstrings_to_model_forward(<span class="hljs-params">LLAMA_INPUTS_DOCSTRING</span>)</span>
<span class="hljs-meta">  @replace_return_docstrings(<span class="hljs-params">output_type=CausalLMOutputWithPast, config_class=_CONFIG_FOR_DOC</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
      self,
      input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
      attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
      position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = <span class="hljs-literal">None</span>,
      inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
      labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
      **kwargs: Unpack[KwargsForCausalLM],
  </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
    ...`,wrap:!1}}),se=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModelForCausalLM</span>(<span class="hljs-title class_ inherited__">LlamaForCausalLM</span>):    |    <span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...                                           |      ...
                                                |
<span class="hljs-meta">  @my_new_decorator                             |     @my_new_decorator</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, **super_kwargs</span>):            |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
    <span class="hljs-built_in">super</span>(<span class="hljs-params"></span>).forward(<span class="hljs-params">**super_kwargs</span>)             |         self,
                                                |         input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
                                                |         attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
                                                |         position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = |<span class="hljs-literal">None</span>,
                                                |         inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
                                                |         labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
                                                |         **kwargs: Unpack[KwargsForCausalLM],
                                                |     </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
                                                |       ...`,wrap:!1}}),ae=new J({props:{title:"Docstring variables",local:"docstring-variables",headingTag:"h2"}}),ie=new j({props:{code:"U1RBUkNPREVSMl9JTlBVVFNfRE9DU1RSSU5HJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMGF1dG9tYXRpY2FsbHklMjByZWRlZmluZWQlMEElMEFjbGFzcyUyMFN0YXJjb2RlcjJNb2RlbChNaXN0cmFsTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTQwYWRkX3N0YXJ0X2RvY3N0cmluZ3NfdG9fbW9kZWxfZm9yd2FyZChTVEFSQ09ERVIyX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`STARCODER2_INPUTS_DOCSTRING = <span class="hljs-literal">None</span>  <span class="hljs-comment"># will be automatically redefined</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Starcoder2Model</span>(<span class="hljs-title class_ inherited__">MistralModel</span>):
    ...

<span class="hljs-meta">    @add_start_docstrings_to_model_forward(<span class="hljs-params">STARCODER2_INPUTS_DOCSTRING</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
        ...`,wrap:!1}}),Ue=new J({props:{title:"Special naming",local:"special-naming",headingTag:"h2"}}),Te=new j({props:{code:"Y2xhc3MlMjBNeU1vZGVsSW5jcmVkaWJsZU1MUChMbGFtYU1MUCklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFjbGFzcyUyME15TW9kZWxEZWNvZGVyTGF5ZXIoTGxhbWFEZWNvZGVyTGF5ZXIpJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelIncredibleMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):
    ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelDecoderLayer</span>(<span class="hljs-title class_ inherited__">LlamaDecoderLayer</span>):
    ...`,wrap:!1}}),Je=new j({props:{code:"V2UlMjBkZXRlY3RlZCUyMG11bHRpcGxlJTIwcHJlZml4JTIwbmFtZXMlMjB3aGVuJTIwaW5oZXJpdGluZyUyMGZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLmxsYW1hLm1vZGVsaW5nX2xsYW1hJTNBJTIwKCdFbXUzVGV4dCclMkMlMjAnRW11MycpLiUyMFdlJTIwd2lsbCUyMG9ubHklMjB1c2UlMjB0aGUlMjBtb3N0JTIwdXNlZCUyMCdFbXUzJyUyMHByZWZpeCUyMHdoZW4lMjBncmFiYmluZyUyMGFyZ3MlMjBhbmQlMjBkZXBlbmRlbmNpZXMuJTIwTWFrZSUyMHN1cmUlMjB0byUyMHN1YmNsYXNzJTIwdGhlJTIwaW50ZXJtZWRpYXRlJTIwY2xhc3NlcyUyMHdpdGglMjB0aGUlMjBwcmVmaXglMjB5b3UlMjB3YW50JTIwKGlmJTIwZGlmZmVyZW50JTIwZnJvbSUyMCdFbXUzJyklMjBvciUyMHVzZSUyMGElMjBzaW5nbGUlMjBwcmVmaXglMjBpbiUyMGFsbCUyMHRoZSUyMG1vZHVsYXIlMjAoYmVzdCku",highlighted:'We detected multiple prefix names when inheriting <span class="hljs-keyword">from</span> transformers.models.llama.modeling_llama: (<span class="hljs-string">&#x27;Emu3Text&#x27;</span>, <span class="hljs-string">&#x27;Emu3&#x27;</span>). We will only use the most used <span class="hljs-string">&#x27;Emu3&#x27;</span> prefix when grabbing args <span class="hljs-keyword">and</span> dependencies. Make sure to subclass the intermediate classes <span class="hljs-keyword">with</span> the prefix you want (<span class="hljs-keyword">if</span> different <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;Emu3&#x27;</span>) <span class="hljs-keyword">or</span> use a single prefix <span class="hljs-keyword">in</span> <span class="hljs-built_in">all</span> the modular (best).',wrap:!1}}),Ce=new j({props:{code:"Y2xhc3MlMjBFbXUzVGV4dE1MUChMbGFtYU1MUCklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Emu3TextMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),re=new J({props:{title:"Config docstrings",local:"config-docstrings",headingTag:"h2"}}),he=new Ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){c=n("meta"),m=t(),C=n("p"),Ie=t(),o(h.$$.fragment),Ae=t(),I=n("p"),I.textContent=ZM,be=t(),u=n("p"),u.innerHTML=GM,_e=t(),f=n("p"),f.innerHTML=BM,Ze=t(),o(A.$$.fragment),Ge=t(),b=n("p"),b.innerHTML=kM,Be=t(),o(r.$$.fragment),ke=t(),_=n("p"),_.textContent=RM,Re=t(),Z=n("p"),Z.textContent=vM,ve=t(),o(G.$$.fragment),We=t(),B=n("p"),B.innerHTML=WM,ge=t(),k=n("p"),k.innerHTML=gM,Ne=t(),o(R.$$.fragment),Ee=t(),v=n("p"),v.textContent=NM,Xe=t(),W=n("ul"),W.innerHTML=EM,Ve=t(),g=n("p"),g.textContent=XM,$e=t(),N=n("p"),N.innerHTML=VM,Qe=t(),o(E.$$.fragment),Ye=t(),X=n("p"),X.textContent=$M,ze=t(),o(V.$$.fragment),Se=t(),$=n("p"),$.textContent=QM,xe=t(),Q=n("p"),Q.innerHTML=YM,He=t(),o(Y.$$.fragment),Le=t(),z=n("p"),z.textContent=zM,Fe=t(),o(S.$$.fragment),Oe=t(),o(x.$$.fragment),De=t(),H=n("p"),H.innerHTML=SM,Pe=t(),L=n("table"),L.innerHTML=xM,Ke=t(),F=n("p"),F.innerHTML=HM,qe=t(),o(O.$$.fragment),ls=t(),D=n("p"),D.innerHTML=LM,es=t(),o(P.$$.fragment),ss=t(),K=n("p"),K.innerHTML=FM,Ms=t(),q=n("ol"),q.innerHTML=OM,ts=t(),ll=n("p"),ll.innerHTML=DM,as=t(),el=n("p"),el.innerHTML=PM,ns=t(),sl=n("p"),sl.innerHTML=KM,ys=t(),Ml=n("p"),Ml.innerHTML=qM,is=t(),o(tl.$$.fragment),os=t(),o(al.$$.fragment),Us=t(),nl=n("p"),nl.innerHTML=lt,ps=t(),o(yl.$$.fragment),ws=t(),il=n("p"),il.innerHTML=et,Ts=t(),o(ol.$$.fragment),ds=t(),Ul=n("p"),Ul.innerHTML=st,js=t(),pl=n("p"),pl.innerHTML=Mt,Js=t(),wl=n("p"),wl.innerHTML=tt,cs=t(),o(Tl.$$.fragment),Cs=t(),dl=n("p"),dl.innerHTML=at,rs=t(),o(jl.$$.fragment),ms=t(),Jl=n("p"),Jl.innerHTML=nt,hs=t(),cl=n("p"),cl.innerHTML=yt,Is=t(),o(Cl.$$.fragment),us=t(),rl=n("p"),rl.innerHTML=it,fs=t(),o(ml.$$.fragment),As=t(),hl=n("p"),hl.innerHTML=ot,bs=t(),o(Il.$$.fragment),_s=t(),ul=n("p"),ul.textContent=Ut,Zs=t(),o(fl.$$.fragment),Gs=t(),Al=n("p"),Al.innerHTML=pt,Bs=t(),o(bl.$$.fragment),ks=t(),_l=n("p"),_l.innerHTML=wt,Rs=t(),Zl=n("p"),Zl.innerHTML=Tt,vs=t(),Gl=n("p"),Gl.innerHTML=dt,Ws=t(),o(Bl.$$.fragment),gs=t(),kl=n("p"),kl.innerHTML=jt,Ns=t(),Rl=n("p"),Rl.innerHTML=Jt,Es=t(),o(vl.$$.fragment),Xs=t(),o(Wl.$$.fragment),Vs=t(),gl=n("p"),gl.innerHTML=ct,$s=t(),o(Nl.$$.fragment),Qs=t(),o(El.$$.fragment),Ys=t(),Xl=n("p"),Xl.innerHTML=Ct,zs=t(),o(Vl.$$.fragment),Ss=t(),o($l.$$.fragment),xs=t(),Ql=n("p"),Ql.innerHTML=rt,Hs=t(),o(Yl.$$.fragment),Ls=t(),o(zl.$$.fragment),Fs=t(),Sl=n("p"),Sl.innerHTML=mt,Os=t(),xl=n("p"),xl.textContent=ht,Ds=t(),o(Hl.$$.fragment),Ps=t(),Ll=n("p"),Ll.textContent=It,Ks=t(),o(Fl.$$.fragment),qs=t(),Ol=n("p"),Ol.textContent=ut,lM=t(),o(Dl.$$.fragment),eM=t(),o(Pl.$$.fragment),sM=t(),Kl=n("p"),Kl.innerHTML=ft,MM=t(),ql=n("p"),ql.innerHTML=At,tM=t(),o(le.$$.fragment),aM=t(),ee=n("p"),ee.innerHTML=bt,nM=t(),o(se.$$.fragment),yM=t(),Me=n("p"),Me.textContent=_t,iM=t(),te=n("p"),te.innerHTML=Zt,oM=t(),o(ae.$$.fragment),UM=t(),ne=n("p"),ne.innerHTML=Gt,pM=t(),ye=n("p"),ye.innerHTML=Bt,wM=t(),o(ie.$$.fragment),TM=t(),oe=n("p"),oe.innerHTML=kt,dM=t(),o(Ue.$$.fragment),jM=t(),pe=n("p"),pe.textContent=Rt,JM=t(),we=n("p"),we.innerHTML=vt,cM=t(),o(Te.$$.fragment),CM=t(),de=n("p"),de.innerHTML=Wt,rM=t(),je=n("p"),je.innerHTML=gt,mM=t(),o(Je.$$.fragment),hM=t(),ce=n("p"),ce.innerHTML=Nt,IM=t(),o(Ce.$$.fragment),uM=t(),o(re.$$.fragment),fM=t(),me=n("p"),me.innerHTML=Et,AM=t(),o(he.$$.fragment),bM=t(),ue=n("p"),this.h()},l(l){const e=Ht("svelte-u9bgzb",document.head);c=y(e,"META",{name:!0,content:!0}),e.forEach(s),m=a(l),C=y(l,"P",{}),Vt(C).forEach(s),Ie=a(l),U(h.$$.fragment,l),Ae=a(l),I=y(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-lj81hr"&&(I.textContent=ZM),be=a(l),u=y(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-1fibcpl"&&(u.innerHTML=GM),_e=a(l),f=y(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-12jtllm"&&(f.innerHTML=BM),Ze=a(l),U(A.$$.fragment,l),Ge=a(l),b=y(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-wcqh4p"&&(b.innerHTML=kM),Be=a(l),U(r.$$.fragment,l),ke=a(l),_=y(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-sz29kf"&&(_.textContent=RM),Re=a(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1n4f4or"&&(Z.textContent=vM),ve=a(l),U(G.$$.fragment,l),We=a(l),B=y(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-12wgxa8"&&(B.innerHTML=WM),ge=a(l),k=y(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1vs9m3e"&&(k.innerHTML=gM),Ne=a(l),U(R.$$.fragment,l),Ee=a(l),v=y(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1gkqha7"&&(v.textContent=NM),Xe=a(l),W=y(l,"UL",{"data-svelte-h":!0}),i(W)!=="svelte-2znzcv"&&(W.innerHTML=EM),Ve=a(l),g=y(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1q8tpr3"&&(g.textContent=XM),$e=a(l),N=y(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1nmms0q"&&(N.innerHTML=VM),Qe=a(l),U(E.$$.fragment,l),Ye=a(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-fj797c"&&(X.textContent=$M),ze=a(l),U(V.$$.fragment,l),Se=a(l),$=y(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1tajku"&&($.textContent=QM),xe=a(l),Q=y(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1izmokq"&&(Q.innerHTML=YM),He=a(l),U(Y.$$.fragment,l),Le=a(l),z=y(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1hj80v9"&&(z.textContent=zM),Fe=a(l),U(S.$$.fragment,l),Oe=a(l),U(x.$$.fragment,l),De=a(l),H=y(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-36nwfz"&&(H.innerHTML=SM),Pe=a(l),L=y(l,"TABLE",{"data-svelte-h":!0}),i(L)!=="svelte-smzi7r"&&(L.innerHTML=xM),Ke=a(l),F=y(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-vpi0ku"&&(F.innerHTML=HM),qe=a(l),U(O.$$.fragment,l),ls=a(l),D=y(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1yjd5s7"&&(D.innerHTML=LM),es=a(l),U(P.$$.fragment,l),ss=a(l),K=y(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-q0b1mo"&&(K.innerHTML=FM),Ms=a(l),q=y(l,"OL",{"data-svelte-h":!0}),i(q)!=="svelte-139or2s"&&(q.innerHTML=OM),ts=a(l),ll=y(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-3ks7rn"&&(ll.innerHTML=DM),as=a(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-11wms29"&&(el.innerHTML=PM),ns=a(l),sl=y(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-yznf21"&&(sl.innerHTML=KM),ys=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1i7o0i6"&&(Ml.innerHTML=qM),is=a(l),U(tl.$$.fragment,l),os=a(l),U(al.$$.fragment,l),Us=a(l),nl=y(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-12zqvql"&&(nl.innerHTML=lt),ps=a(l),U(yl.$$.fragment,l),ws=a(l),il=y(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-suxygn"&&(il.innerHTML=et),Ts=a(l),U(ol.$$.fragment,l),ds=a(l),Ul=y(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1k0gkac"&&(Ul.innerHTML=st),js=a(l),pl=y(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-10o1ggb"&&(pl.innerHTML=Mt),Js=a(l),wl=y(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1y0dfl"&&(wl.innerHTML=tt),cs=a(l),U(Tl.$$.fragment,l),Cs=a(l),dl=y(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-jueczp"&&(dl.innerHTML=at),rs=a(l),U(jl.$$.fragment,l),ms=a(l),Jl=y(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1grcsyb"&&(Jl.innerHTML=nt),hs=a(l),cl=y(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-krborp"&&(cl.innerHTML=yt),Is=a(l),U(Cl.$$.fragment,l),us=a(l),rl=y(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-12qws02"&&(rl.innerHTML=it),fs=a(l),U(ml.$$.fragment,l),As=a(l),hl=y(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-2efkpk"&&(hl.innerHTML=ot),bs=a(l),U(Il.$$.fragment,l),_s=a(l),ul=y(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-111k955"&&(ul.textContent=Ut),Zs=a(l),U(fl.$$.fragment,l),Gs=a(l),Al=y(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-ue8kve"&&(Al.innerHTML=pt),Bs=a(l),U(bl.$$.fragment,l),ks=a(l),_l=y(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-j99j4d"&&(_l.innerHTML=wt),Rs=a(l),Zl=y(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1mv6aiq"&&(Zl.innerHTML=Tt),vs=a(l),Gl=y(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-li8sd3"&&(Gl.innerHTML=dt),Ws=a(l),U(Bl.$$.fragment,l),gs=a(l),kl=y(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-1qoxxsw"&&(kl.innerHTML=jt),Ns=a(l),Rl=y(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-16zifu2"&&(Rl.innerHTML=Jt),Es=a(l),U(vl.$$.fragment,l),Xs=a(l),U(Wl.$$.fragment,l),Vs=a(l),gl=y(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1reud8e"&&(gl.innerHTML=ct),$s=a(l),U(Nl.$$.fragment,l),Qs=a(l),U(El.$$.fragment,l),Ys=a(l),Xl=y(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-21xdqm"&&(Xl.innerHTML=Ct),zs=a(l),U(Vl.$$.fragment,l),Ss=a(l),U($l.$$.fragment,l),xs=a(l),Ql=y(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-ho137b"&&(Ql.innerHTML=rt),Hs=a(l),U(Yl.$$.fragment,l),Ls=a(l),U(zl.$$.fragment,l),Fs=a(l),Sl=y(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-mwxhil"&&(Sl.innerHTML=mt),Os=a(l),xl=y(l,"P",{"data-svelte-h":!0}),i(xl)!=="svelte-8g3zpp"&&(xl.textContent=ht),Ds=a(l),U(Hl.$$.fragment,l),Ps=a(l),Ll=y(l,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-hkv2ct"&&(Ll.textContent=It),Ks=a(l),U(Fl.$$.fragment,l),qs=a(l),Ol=y(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-1b9k8jx"&&(Ol.textContent=ut),lM=a(l),U(Dl.$$.fragment,l),eM=a(l),U(Pl.$$.fragment,l),sM=a(l),Kl=y(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-ce3ins"&&(Kl.innerHTML=ft),MM=a(l),ql=y(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-142mre4"&&(ql.innerHTML=At),tM=a(l),U(le.$$.fragment,l),aM=a(l),ee=y(l,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-161qf9e"&&(ee.innerHTML=bt),nM=a(l),U(se.$$.fragment,l),yM=a(l),Me=y(l,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1w35umg"&&(Me.textContent=_t),iM=a(l),te=y(l,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1x7kbin"&&(te.innerHTML=Zt),oM=a(l),U(ae.$$.fragment,l),UM=a(l),ne=y(l,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-dnuz94"&&(ne.innerHTML=Gt),pM=a(l),ye=y(l,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1a2wp3o"&&(ye.innerHTML=Bt),wM=a(l),U(ie.$$.fragment,l),TM=a(l),oe=y(l,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-zwpgdq"&&(oe.innerHTML=kt),dM=a(l),U(Ue.$$.fragment,l),jM=a(l),pe=y(l,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1r96udu"&&(pe.textContent=Rt),JM=a(l),we=y(l,"P",{"data-svelte-h":!0}),i(we)!=="svelte-1w8gdvq"&&(we.innerHTML=vt),cM=a(l),U(Te.$$.fragment,l),CM=a(l),de=y(l,"P",{"data-svelte-h":!0}),i(de)!=="svelte-ce2erv"&&(de.innerHTML=Wt),rM=a(l),je=y(l,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1n8wdp0"&&(je.innerHTML=gt),mM=a(l),U(Je.$$.fragment,l),hM=a(l),ce=y(l,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-3dj83y"&&(ce.innerHTML=Nt),IM=a(l),U(Ce.$$.fragment,l),uM=a(l),U(re.$$.fragment,l),fM=a(l),me=y(l,"P",{"data-svelte-h":!0}),i(me)!=="svelte-msrgaf"&&(me.innerHTML=Et),AM=a(l),U(he.$$.fragment,l),bM=a(l),ue=y(l,"P",{}),Vt(ue).forEach(s),this.h()},h(){$t(c,"name","hf:doc:metadata"),$t(c,"content",Kt)},m(l,e){Lt(document.head,c),M(l,m,e),M(l,C,e),M(l,Ie,e),p(h,l,e),M(l,Ae,e),M(l,I,e),M(l,be,e),M(l,u,e),M(l,_e,e),M(l,f,e),M(l,Ze,e),p(A,l,e),M(l,Ge,e),M(l,b,e),M(l,Be,e),p(r,l,e),M(l,ke,e),M(l,_,e),M(l,Re,e),M(l,Z,e),M(l,ve,e),p(G,l,e),M(l,We,e),M(l,B,e),M(l,ge,e),M(l,k,e),M(l,Ne,e),p(R,l,e),M(l,Ee,e),M(l,v,e),M(l,Xe,e),M(l,W,e),M(l,Ve,e),M(l,g,e),M(l,$e,e),M(l,N,e),M(l,Qe,e),p(E,l,e),M(l,Ye,e),M(l,X,e),M(l,ze,e),p(V,l,e),M(l,Se,e),M(l,$,e),M(l,xe,e),M(l,Q,e),M(l,He,e),p(Y,l,e),M(l,Le,e),M(l,z,e),M(l,Fe,e),p(S,l,e),M(l,Oe,e),p(x,l,e),M(l,De,e),M(l,H,e),M(l,Pe,e),M(l,L,e),M(l,Ke,e),M(l,F,e),M(l,qe,e),p(O,l,e),M(l,ls,e),M(l,D,e),M(l,es,e),p(P,l,e),M(l,ss,e),M(l,K,e),M(l,Ms,e),M(l,q,e),M(l,ts,e),M(l,ll,e),M(l,as,e),M(l,el,e),M(l,ns,e),M(l,sl,e),M(l,ys,e),M(l,Ml,e),M(l,is,e),p(tl,l,e),M(l,os,e),p(al,l,e),M(l,Us,e),M(l,nl,e),M(l,ps,e),p(yl,l,e),M(l,ws,e),M(l,il,e),M(l,Ts,e),p(ol,l,e),M(l,ds,e),M(l,Ul,e),M(l,js,e),M(l,pl,e),M(l,Js,e),M(l,wl,e),M(l,cs,e),p(Tl,l,e),M(l,Cs,e),M(l,dl,e),M(l,rs,e),p(jl,l,e),M(l,ms,e),M(l,Jl,e),M(l,hs,e),M(l,cl,e),M(l,Is,e),p(Cl,l,e),M(l,us,e),M(l,rl,e),M(l,fs,e),p(ml,l,e),M(l,As,e),M(l,hl,e),M(l,bs,e),p(Il,l,e),M(l,_s,e),M(l,ul,e),M(l,Zs,e),p(fl,l,e),M(l,Gs,e),M(l,Al,e),M(l,Bs,e),p(bl,l,e),M(l,ks,e),M(l,_l,e),M(l,Rs,e),M(l,Zl,e),M(l,vs,e),M(l,Gl,e),M(l,Ws,e),p(Bl,l,e),M(l,gs,e),M(l,kl,e),M(l,Ns,e),M(l,Rl,e),M(l,Es,e),p(vl,l,e),M(l,Xs,e),p(Wl,l,e),M(l,Vs,e),M(l,gl,e),M(l,$s,e),p(Nl,l,e),M(l,Qs,e),p(El,l,e),M(l,Ys,e),M(l,Xl,e),M(l,zs,e),p(Vl,l,e),M(l,Ss,e),p($l,l,e),M(l,xs,e),M(l,Ql,e),M(l,Hs,e),p(Yl,l,e),M(l,Ls,e),p(zl,l,e),M(l,Fs,e),M(l,Sl,e),M(l,Os,e),M(l,xl,e),M(l,Ds,e),p(Hl,l,e),M(l,Ps,e),M(l,Ll,e),M(l,Ks,e),p(Fl,l,e),M(l,qs,e),M(l,Ol,e),M(l,lM,e),p(Dl,l,e),M(l,eM,e),p(Pl,l,e),M(l,sM,e),M(l,Kl,e),M(l,MM,e),M(l,ql,e),M(l,tM,e),p(le,l,e),M(l,aM,e),M(l,ee,e),M(l,nM,e),p(se,l,e),M(l,yM,e),M(l,Me,e),M(l,iM,e),M(l,te,e),M(l,oM,e),p(ae,l,e),M(l,UM,e),M(l,ne,e),M(l,pM,e),M(l,ye,e),M(l,wM,e),p(ie,l,e),M(l,TM,e),M(l,oe,e),M(l,dM,e),p(Ue,l,e),M(l,jM,e),M(l,pe,e),M(l,JM,e),M(l,we,e),M(l,cM,e),p(Te,l,e),M(l,CM,e),M(l,de,e),M(l,rM,e),M(l,je,e),M(l,mM,e),p(Je,l,e),M(l,hM,e),M(l,ce,e),M(l,IM,e),p(Ce,l,e),M(l,uM,e),p(re,l,e),M(l,fM,e),M(l,me,e),M(l,AM,e),p(he,l,e),M(l,bM,e),M(l,ue,e),_M=!0},p(l,[e]){const Xt={};e&2&&(Xt.$$scope={dirty:e,ctx:l}),r.$set(Xt)},i(l){_M||(w(h.$$.fragment,l),w(A.$$.fragment,l),w(r.$$.fragment,l),w(G.$$.fragment,l),w(R.$$.fragment,l),w(E.$$.fragment,l),w(V.$$.fragment,l),w(Y.$$.fragment,l),w(S.$$.fragment,l),w(x.$$.fragment,l),w(O.$$.fragment,l),w(P.$$.fragment,l),w(tl.$$.fragment,l),w(al.$$.fragment,l),w(yl.$$.fragment,l),w(ol.$$.fragment,l),w(Tl.$$.fragment,l),w(jl.$$.fragment,l),w(Cl.$$.fragment,l),w(ml.$$.fragment,l),w(Il.$$.fragment,l),w(fl.$$.fragment,l),w(bl.$$.fragment,l),w(Bl.$$.fragment,l),w(vl.$$.fragment,l),w(Wl.$$.fragment,l),w(Nl.$$.fragment,l),w(El.$$.fragment,l),w(Vl.$$.fragment,l),w($l.$$.fragment,l),w(Yl.$$.fragment,l),w(zl.$$.fragment,l),w(Hl.$$.fragment,l),w(Fl.$$.fragment,l),w(Dl.$$.fragment,l),w(Pl.$$.fragment,l),w(le.$$.fragment,l),w(se.$$.fragment,l),w(ae.$$.fragment,l),w(ie.$$.fragment,l),w(Ue.$$.fragment,l),w(Te.$$.fragment,l),w(Je.$$.fragment,l),w(Ce.$$.fragment,l),w(re.$$.fragment,l),w(he.$$.fragment,l),_M=!0)},o(l){T(h.$$.fragment,l),T(A.$$.fragment,l),T(r.$$.fragment,l),T(G.$$.fragment,l),T(R.$$.fragment,l),T(E.$$.fragment,l),T(V.$$.fragment,l),T(Y.$$.fragment,l),T(S.$$.fragment,l),T(x.$$.fragment,l),T(O.$$.fragment,l),T(P.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(yl.$$.fragment,l),T(ol.$$.fragment,l),T(Tl.$$.fragment,l),T(jl.$$.fragment,l),T(Cl.$$.fragment,l),T(ml.$$.fragment,l),T(Il.$$.fragment,l),T(fl.$$.fragment,l),T(bl.$$.fragment,l),T(Bl.$$.fragment,l),T(vl.$$.fragment,l),T(Wl.$$.fragment,l),T(Nl.$$.fragment,l),T(El.$$.fragment,l),T(Vl.$$.fragment,l),T($l.$$.fragment,l),T(Yl.$$.fragment,l),T(zl.$$.fragment,l),T(Hl.$$.fragment,l),T(Fl.$$.fragment,l),T(Dl.$$.fragment,l),T(Pl.$$.fragment,l),T(le.$$.fragment,l),T(se.$$.fragment,l),T(ae.$$.fragment,l),T(ie.$$.fragment,l),T(Ue.$$.fragment,l),T(Te.$$.fragment,l),T(Je.$$.fragment,l),T(Ce.$$.fragment,l),T(re.$$.fragment,l),T(he.$$.fragment,l),_M=!1},d(l){l&&(s(m),s(C),s(Ie),s(Ae),s(I),s(be),s(u),s(_e),s(f),s(Ze),s(Ge),s(b),s(Be),s(ke),s(_),s(Re),s(Z),s(ve),s(We),s(B),s(ge),s(k),s(Ne),s(Ee),s(v),s(Xe),s(W),s(Ve),s(g),s($e),s(N),s(Qe),s(Ye),s(X),s(ze),s(Se),s($),s(xe),s(Q),s(He),s(Le),s(z),s(Fe),s(Oe),s(De),s(H),s(Pe),s(L),s(Ke),s(F),s(qe),s(ls),s(D),s(es),s(ss),s(K),s(Ms),s(q),s(ts),s(ll),s(as),s(el),s(ns),s(sl),s(ys),s(Ml),s(is),s(os),s(Us),s(nl),s(ps),s(ws),s(il),s(Ts),s(ds),s(Ul),s(js),s(pl),s(Js),s(wl),s(cs),s(Cs),s(dl),s(rs),s(ms),s(Jl),s(hs),s(cl),s(Is),s(us),s(rl),s(fs),s(As),s(hl),s(bs),s(_s),s(ul),s(Zs),s(Gs),s(Al),s(Bs),s(ks),s(_l),s(Rs),s(Zl),s(vs),s(Gl),s(Ws),s(gs),s(kl),s(Ns),s(Rl),s(Es),s(Xs),s(Vs),s(gl),s($s),s(Qs),s(Ys),s(Xl),s(zs),s(Ss),s(xs),s(Ql),s(Hs),s(Ls),s(Fs),s(Sl),s(Os),s(xl),s(Ds),s(Ps),s(Ll),s(Ks),s(qs),s(Ol),s(lM),s(eM),s(sM),s(Kl),s(MM),s(ql),s(tM),s(aM),s(ee),s(nM),s(yM),s(Me),s(iM),s(te),s(oM),s(UM),s(ne),s(pM),s(ye),s(wM),s(TM),s(oe),s(dM),s(jM),s(pe),s(JM),s(we),s(cM),s(CM),s(de),s(rM),s(je),s(mM),s(hM),s(ce),s(IM),s(uM),s(fM),s(me),s(AM),s(bM),s(ue)),s(c),d(h,l),d(A,l),d(r,l),d(G,l),d(R,l),d(E,l),d(V,l),d(Y,l),d(S,l),d(x,l),d(O,l),d(P,l),d(tl,l),d(al,l),d(yl,l),d(ol,l),d(Tl,l),d(jl,l),d(Cl,l),d(ml,l),d(Il,l),d(fl,l),d(bl,l),d(Bl,l),d(vl,l),d(Wl,l),d(Nl,l),d(El,l),d(Vl,l),d($l,l),d(Yl,l),d(zl,l),d(Hl,l),d(Fl,l),d(Dl,l),d(Pl,l),d(le,l),d(se,l),d(ae,l),d(ie,l),d(Ue,l),d(Te,l),d(Je,l),d(Ce,l),d(re,l),d(he,l)}}}const Kt='{"title":"Modular Transformers","local":"modular-transformers","sections":[{"title":"Motivation","local":"motivation","sections":[],"depth":2},{"title":"Create a modeling.py file","local":"create-a-modelingpy-file","sections":[{"title":"BERT and RoBERTa","local":"bert-and-roberta","sections":[],"depth":3}],"depth":2},{"title":"Implementing a modular file","local":"implementing-a-modular-file","sections":[{"title":"Config","local":"config","sections":[],"depth":3},{"title":"Norm","local":"norm","sections":[],"depth":3},{"title":"Attention","local":"attention","sections":[],"depth":3},{"title":"DecoderLayer","local":"decoderlayer","sections":[],"depth":3},{"title":"Model","local":"model","sections":[],"depth":3},{"title":"Model head","local":"model-head","sections":[],"depth":3},{"title":"Other classes","local":"other-classes","sections":[],"depth":3}],"depth":2},{"title":"Removing attributes","local":"removing-attributes","sections":[],"depth":2},{"title":"Explicit super() calls","local":"explicit-super-calls","sections":[],"depth":2},{"title":"Deleting unused methods","local":"deleting-unused-methods","sections":[],"depth":2},{"title":"Defining new functions","local":"defining-new-functions","sections":[],"depth":2},{"title":"super_kwargs","local":"superkwargs","sections":[],"depth":2},{"title":"Docstring variables","local":"docstring-variables","sections":[],"depth":2},{"title":"Special naming","local":"special-naming","sections":[],"depth":2},{"title":"Config docstrings","local":"config-docstrings","sections":[],"depth":2}],"depth":1}';function qt(fe){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class na extends St{constructor(c){super(),xt(this,c,qt,Pt,Qt,{})}}export{na as component};
