import{s as qt,o as Pt,n as Ae}from"../chunks/scheduler.18a86fab.js";import{S as Dt,i as Kt,g as i,s as a,r as d,A as Ot,h as r,f as t,c as n,j as St,u as M,x as p,k as at,l as es,y as ls,a as s,v as m,d as u,t as h,w}from"../chunks/index.98837b22.js";import{T as He}from"../chunks/Tip.77304350.js";import{C as T}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as J}from"../chunks/Heading.7e7e0c5b.js";import{E as ts}from"../chunks/getInferenceSnippets.de10bc7d.js";function ss(j){let o,y="Tensor parallelism is very communication intensive, therefore it is reccomended to use it on a single machine with multiple GPUs, utilizing fast intra-node communication. For multi-node training, methods as pipeline or data parallelism are more efficient (depending on your use case).";return{c(){o=i("p"),o.textContent=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1oi9wpr"&&(o.textContent=y)},m(c,f){s(c,o,f)},p:Ae,d(c){c&&t(o)}}}function as(j){let o,y="Expand the list below to see which models support tensor parallelism. Open a GitHub issue or pull request to add support for a model not currently below.";return{c(){o=i("p"),o.textContent=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1awp5l7"&&(o.textContent=y)},m(c,f){s(c,o,f)},p:Ae,d(c){c&&t(o)}}}function ns(j){let o,y='For a list of models that support tensor parallelism, see the <a href="#supported-models">Supported models</a> section above.';return{c(){o=i("p"),o.innerHTML=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1ljoabn"&&(o.innerHTML=y)},m(c,f){s(c,o,f)},p:Ae,d(c){c&&t(o)}}}function os(j){let o,y='If this is a bit difficult to wrap your head around, check out <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/tensor_parallel.py#L79-#L108" rel="nofollow">this comment</a> for an amazing visual representation of why <code>Packed*</code> needs to be used.';return{c(){o=i("p"),o.innerHTML=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-14227uc"&&(o.innerHTML=y)},m(c,f){s(c,o,f)},p:Ae,d(c){c&&t(o)}}}function is(j){let o,y='Manually specifying your own partitiong plan requires a good understanding of the model architecture and how the partitioning strategies interact together. If you are not sure about this, the resulting model can be very slow, even failing or incorrect. Again, refer to the <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=tensor_parallelism" rel="nofollow">Ultra-Scale Playbook</a> which can teach you everything required.';return{c(){o=i("p"),o.innerHTML=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1wsomyv"&&(o.innerHTML=y)},m(c,f){s(c,o,f)},p:Ae,d(c){c&&t(o)}}}function rs(j){let o,y,c,f,C,Ye,G,nt=`<a href="./perf_train_gpu_many#tensor-parallelism">Tensor parallelism</a> shards a model onto multiple GPUs and parallelizes computations such as matrix multiplication. It enables fitting larger model sizes into memory and is faster because each GPU can process a tensor slice.
This document assumes that you are already familiar with the basics of tensor parallelism. If you are not, please refer to the <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=tensor_parallelism" rel="nofollow">Ultra-Scale Playbook</a> section on tensor parallelism.`,Ne,b,Le,v,ot="Tensor parallelism requires slight changes to the model parameters, therefore in transformers, we support some of the popular models out of the box.",Ee,U,Qe,Z,it='<summary>Supported models</summary> <ul><li><a href="./model_doc/cohere">Cohere</a> and <a href="./model_doc/cohere2">Cohere 2</a></li> <li><a href="./model_doc/gemma">Gemma</a> and <a href="./model_doc/gemma2">Gemma 2</a></li> <li><a href="./model_doc/glm">GLM</a></li> <li><a href="./model_doc/granite">Granite</a></li> <li><a href="./model_doc/llama">Llama</a></li> <li><a href="./model_doc/mistral">Mistral</a></li> <li><a href="./model_doc/mixtral">Mixtral</a></li> <li><a href="./model_doc/olmo">OLMo</a> and <a href="./model_doc/olmo2">OLMo2</a></li> <li><a href="./model_doc/phi">Phi</a> and <a href="./model_doc/phi3">Phi-3</a></li> <li><a href="./model_doc/qwen2">Qwen2</a>, <a href="./model_doc/qwen2_moe">Qwen2Moe</a>, and <a href="./model_doc/qwen2_5_vl">Qwen2-VL</a></li> <li><a href="./model_doc/starcoder2">Starcoder2</a></li></ul>',Fe,X,ze,W,rt=`Transformers provides a simple interface to use for tensor parallelism. We provide multiple classes implementing different partitioning
strategies and a simple entrypoint to parallelize <code>nn.Module</code> instance. You won’t have to interact with this interface directly, everything is done in <code>PretrainedModel.from_pretrained</code> method for you. This section will first talk about the partitioning strategies
we support, then the user interface you will be interacting with, and finally it will teach you how to extend it with your own partitioning
strategies.`,Se,V,qe,k,pt="In transformers, partitioning strategies reside in a class <code>ParallelInterface</code> which works like a mapping from string to the strategy implementation.",Pe,R,De,x,ct="We support the following strategies:",Ke,H,dt='<li><code>ColwiseParallel</code> - A simple column-wise partitioning, being able to handle both weights and biases, does exactly what we’ve discussed before.</li> <li><code>RowwiseParallel</code> - Again, row-wise partitioning as dicussed before, supports weights and biases, on top of that it also supports <code>nn.Embedding</code> modules.</li> <li><code>SequenceParallel</code> - Sequence parallel implementation, for support of <code>LayerNorm</code> and <code>Dropout</code> layers. Also supports Python implementation of <code>RMSNorm</code> (see <a href="https://github.com/facebookresearch/llama/blob/main/llama/model.py#L34" rel="nofollow">this</a>)</li> <li><code>PackedColwiseParallel</code> - A variant of column-wise partitioning, however it works on packed weights (i.e. <code>up_proj</code> and <code>gate_proj</code> being packed together). For more details, see <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/tensor_parallel.py#L79-#L108" rel="nofollow">this comment</a></li> <li><code>PackedRowwiseParallel</code> - A variant of row-wise partitioning, works on packed weights, for more details check the comment linked above.</li> <li><code>GatherParallel</code> - A very simple class, that only makes the outputs of the module to be gathered across devices.</li> <li><code>IsolatedParallel</code> - This is a special case, where we want to <em>isolate</em> the module from the rest of the devices (world). This is used for Experts in MoE layers, basically creating Expert parallelism of sorts.</li> <li><code>ReplicateParallel</code> - Many <code>torch.distributed</code> APIs break if model is partially sharded, so this class is used to replicate the module across all devices.</li>',Oe,A,el,Y,Mt="We provide two ways to shard a model, first one is to use <code>auto</code> tensor parallelism plan, which will automatically shard the model based on our predefined configuration. This requires the model to have predefined tensor parallel plan in transformers.",ll,N,tl,I,sl,L,mt="The second way is to manually specify your own partitioning plan.",al,E,nl,Q,ut="You might have noticed that there are some special cases in the <code>ParallelInterface</code> mapping, let’s now talk about them. This will help you understand their purpose and help with extending to other strategies.",ol,F,il,z,ht="This class is a special case of <code>RowwiseParallel</code>, it’s used to shard packed weights. Weight packing is a common technique used in models. It’s a technique where we pack multiple linear layers into a single, bigger one.",rl,S,wt="For example in <code>Llama4</code> model, we pack <code>up_proj</code> and <code>gate_proj</code> into a single <code>gate_up_proj</code> module.",pl,q,cl,P,yt="Then in forward, we can use batch matrix multiplication to compute the output of the <code>gate_up_proj</code> module.",dl,D,Ml,K,Tt="In this case, we need to use the <code>PackedRowwiseParallel</code> strategy to shard the <code>gate_up_proj</code> module, as using a simple <code>RowwiseParallel</code> will shard the layers wrongly.",ml,g,ul,O,hl,ee,ft=`You could have noticed that there are <code>local*</code> strategies, which use the same layers as <code>*</code> strategy, but don’t use <code>DTensor</code> at all.
This is because <code>DTensor</code> is not supported for some of the operations: such as <code>torch.chunk</code>. Therefore, sometimes we need to use the <code>local*</code> strategies, which use vanilla <code>torch.Tensor</code> and do some of the distributed logic manually.`,wl,_,yl,le,Tl,te,jt=`This is a very advanced topic, which requires a good understanding of distributed collectives and the model architecture.
Your custom partitioning strategy should inherit from <code>TensorParallelLayer</code> defined in <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/tensor_parallel.py" rel="nofollow">integrations/tensor_parallel.py</a> and implement: <code>partition_tensor</code>, <code>_prepare_input_fn</code> and <code>_prepare_output_fn</code>. Then it should be registered in the <code>ParallelInterface</code> mapping, so our dispatching logic can find it when specified in the <code>tp_plan</code>.`,fl,se,Jt="Let’s go through this workflow step by step, on an already existing example: <code>ColwiseParallel</code>.",jl,ae,bt="<li>Inherit from <code>TensorParallelLayer</code> and initialization</li>",Jl,ne,bl,oe,Ut="In the <code>__init__</code> method, we define these attributes, where <code>input_layouts</code> and <code>output_layouts</code> describing, how the input and output tensors should be placed on the devices. <code>desired_input_layouts</code> is used to specify, how the input <em>SHOULD</em> be placed on the devices.",Ul,ie,It="2a. Implement <code>partition_tensor</code> method",Il,re,gl,pe,gt=`This method is used to partition the tensor, and fill the <code>empty_param</code> with the partitioned tensor.
We provide some utility functions to help you with this, such as <code>get_tensor_shard</code> which will get you the correct shard of the original parameter for this rank or <code>get_packed_weights</code> to help with packed weights.`,_l,ce,_t="2b. Implement <code>_prepare_input_fn</code> and <code>_prepare_output_fn</code> methods",Bl,de,Bt='These methods are used as <a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.modules.module.register_module_forward_pre_hook.html" rel="nofollow"><code>pre-forward</code></a> and <a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.modules.module.register_module_forward_hook.html" rel="nofollow"><code>forward</code></a> hooks respectively. Their purpose is to re-distribute the inputs and outputs to the desired layout, passed in the <code>__init__</code> method.',$l,Me,Cl,B,$t=`<li>Register the strategy
Congratulations! You’ve implemented your own partitioning strategy. Now, to use it with your own <code>tp_plan</code>, you need to register it in the <code>ParallelInterface</code> mapping.</li>`,Gl,me,vl,ue,Ct="And now you can use it in your <code>tp_plan</code> as such:",Zl,he,Xl,we,Wl,ye,Gt="Let’s go through a full example of inference with tensor parallelism.",Vl,Te,kl,fe,vt='Launch the inference script above on <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a> with 4 processes per GPU.',Rl,je,xl,Je,Zt="You can benefit from considerable speed ups for inference, especially for inputs with large batch size or long sequences.",Hl,be,Xt='For a single forward pass on <a href="./model_doc/llama">Llama</a> with a sequence length of 512 and various batch sizes, you can expect the following speed ups.',Al,$,Wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Meta-Llama-3-8B-Instruct%2C%20seqlen%20%3D%20512%2C%20python%2C%20w_%20compile.png"/>',Yl,Ue,Nl,Ie,Vt="Our implementation of tensor parallelism is framework-agnostic in design, but the specific implementations we’ve developed rely on the torch.distributed package. We heavily utilize abstractions such as <code>DeviceMesh</code> or <code>DTensor</code> to provide a simple and extensible interface to the user.",Ll,ge,El,_e,kt="Imagine <code>DeviceMesh</code> as a multi-dimensional grid of devices that communicate together. Different parallelization strategies require different types of communication patterns, therefore we can create a <code>DeviceMesh</code> with multiple submeshes:",Ql,Be,Fl,$e,Rt="Then, most of the <code>torch.distributed</code> defined parallelization strategies can be applied to a mesh itself, or its submesh, automatically handling the communication patterns.",zl,Ce,Sl,Ge,xt=`Abbreviation for Distributed Tensor, <code>DTensor</code> is a tensor subclass that handles the distributed logic on-top of the usual tensor operations. Most of the model weights in case of tensor parallelism are stored as <code>DTensor</code>s (with some exceptions, more on that later).
The most important part of DTensor, that is crucial to understand, is the <code>placement</code> attribute. It’s an attribute that tells PyTorch how is the tensor placed on the devices of the <code>DeviceMesh</code>.`,ql,ve,Ht="It can have the following values:",Pl,Ze,At="<li><code>Shard(dimension)</code> - Annotates that this <code>DTensor</code> is sharded across a given dimension, over the <code>DeviceMesh</code> it was constructed under. For example, if we would like to shard weights for column-wise partitioning, we would do:</li>",Dl,Xe,Kl,We,Yt="To give another example, for row-wise partitioning, we would do:",Ol,Ve,et,ke,Nt="<li><code>Replicate()</code> - Annotates that this <code>DTensor</code> is replicated across the <code>DeviceMesh</code>. Very straight-forward, only creates a full copy of the tensor on each device.</li> <li><code>Partial()</code> - This placement is mostly of no interest to us, it’s used to annotate that this tensor is pending a reduction operation.</li>",lt,Re,tt,xe,st;return C=new J({props:{title:"Tensor parallelism in transformers",local:"tensor-parallelism-in-transformers",headingTag:"h1"}}),b=new He({props:{warning:!1,$$slots:{default:[ss]},$$scope:{ctx:j}}}),U=new He({props:{warning:!1,$$slots:{default:[as]},$$scope:{ctx:j}}}),X=new J({props:{title:"Using 🤗 transformers",local:"using--transformers",headingTag:"h2"}}),V=new J({props:{title:"Partitioning strategies",local:"partitioning-strategies",headingTag:"h3"}}),R=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ParallelInterface</span>(<span class="hljs-title class_ inherited__">MutableMapping</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Dict-like object keeping track of allowed attention functions. You can easily add a new attention function
    with a call to \`register()\`. If a model needs to locally overwrite an existing attention function, say \`sdpa\`,
    it needs to declare a new instance of this class inside the \`modeling_&lt;model&gt;.py\`, and declare it on that instance.
    &quot;&quot;&quot;</span>
    _global_mapping = {
        <span class="hljs-string">&quot;colwise&quot;</span>: ColwiseParallel(),
        <span class="hljs-string">&quot;rowwise&quot;</span>: RowwiseParallel(),
        <span class="hljs-string">&quot;colwise_rep&quot;</span>: ColwiseParallel(output_layouts=Replicate()),
        <span class="hljs-string">&quot;rowwise_rep&quot;</span>: RowwiseParallel(input_layouts=Replicate()),
        <span class="hljs-string">&quot;local_colwise&quot;</span>: ColwiseParallel(use_dtensor=<span class="hljs-literal">False</span>),
        <span class="hljs-string">&quot;local_rowwise&quot;</span>: RowwiseParallel(use_dtensor=<span class="hljs-literal">False</span>),
        <span class="hljs-string">&quot;local&quot;</span>: IsolatedParallel(),
        <span class="hljs-string">&quot;gather&quot;</span>: GatherParallel(),
        <span class="hljs-string">&quot;local_packed_rowwise&quot;</span>: PackedRowwiseParallel(use_dtensor=<span class="hljs-literal">False</span>),
        <span class="hljs-string">&quot;sequence_parallel&quot;</span>: SequenceParallel(),
        <span class="hljs-string">&quot;replicate&quot;</span>: ReplicateParallel(),
    }`,wrap:!1}}),A=new J({props:{title:"Sharding a model",local:"sharding-a-model",headingTag:"h3"}}),N=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyJTIwJTIzJTIwYmV0dGVyJTIwZm9yJTIwc21hbGxlciUyMG51bWJlciUyMG9mJTIwR1BVcyUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtU2NvdXQtMTdCLTE2RS1JbnN0cnVjdCUyMiUyMCUyMyUyMGJldHRlciUyMHRvJTIwdmlzdWFsaXplJTIwYWxsJTIwdGhlJTIwcG9zc2libGUlMjBzdHJhdGVnaWVzJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwdHBfcGxhbiUzRCUyMmF1dG8lMjIpJTBBJTBBcHJpbnQobW9kZWwuX3RwX3BsYW4p",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># model_id = &quot;meta-llama/Meta-Llama-3-8B-Instruct&quot; # better for smaller number of GPUs</span>
model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span> <span class="hljs-comment"># better to visualize all the possible strategies</span>

model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, tp_plan=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-built_in">print</span>(model._tp_plan)`,wrap:!1}}),I=new He({props:{warning:!1,$$slots:{default:[ns]},$$scope:{ctx:j}}}),E=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdHBfcGxhbiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsLmxheWVycy4qLnNlbGZfYXR0bi5xX3Byb2olMjIlM0ElMjAlMjJjb2x3aXNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWwubGF5ZXJzLiouc2VsZl9hdHRuLmtfcHJvaiUyMiUzQSUyMCUyMmNvbHdpc2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbC5sYXllcnMuKi5zZWxmX2F0dG4udl9wcm9qJTIyJTNBJTIwJTIyY29sd2lzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsLmxheWVycy4qLnNlbGZfYXR0bi5vX3Byb2olMjIlM0ElMjAlMjJyb3d3aXNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTdEJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwdHBfcGxhbiUzRHRwX3BsYW4pJTBBJTBBcHJpbnQobW9kZWwuX3RwX3BsYW4p",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

tp_plan = {
    <span class="hljs-string">&quot;model.layers.*.self_attn.q_proj&quot;</span>: <span class="hljs-string">&quot;colwise&quot;</span>,
    <span class="hljs-string">&quot;model.layers.*.self_attn.k_proj&quot;</span>: <span class="hljs-string">&quot;colwise&quot;</span>,
    <span class="hljs-string">&quot;model.layers.*.self_attn.v_proj&quot;</span>: <span class="hljs-string">&quot;colwise&quot;</span>,
    <span class="hljs-string">&quot;model.layers.*.self_attn.o_proj&quot;</span>: <span class="hljs-string">&quot;rowwise&quot;</span>,
    ...
}

model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, tp_plan=tp_plan)

<span class="hljs-built_in">print</span>(model._tp_plan)`,wrap:!1}}),F=new J({props:{title:"PackedRowwiseParallel",local:"packedrowwiseparallel",headingTag:"h3"}}),q=new T({props:{code:"Y2xhc3MlMjBMbGFtYTRUZXh0RXhwZXJ0cyhubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwc2VsZi5nYXRlX3VwX3Byb2olMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2guZW1wdHkoc2VsZi5udW1fZXhwZXJ0cyUyQyUyMHNlbGYuaGlkZGVuX3NpemUlMkMlMjAyJTIwKiUyMHNlbGYuZXhwZXJ0X2RpbSkp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Llama4TextExperts</span>(nn.Module):
    ...
    self.gate_up_proj = nn.Parameter(torch.empty(self.num_experts, self.hidden_size, <span class="hljs-number">2</span> * self.expert_dim))`,wrap:!1}}),D=new T({props:{code:"ZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaGlkZGVuX3N0YXRlcyklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBnYXRlX3VwJTIwJTNEJTIwdG9yY2guYm1tKGhpZGRlbl9zdGF0ZXMlMkMlMjBzZWxmLmdhdGVfdXBfcHJvaiklMjAlMjMlMjBDb21wdXRlJTIwdGhlJTIwb3V0cHV0JTIwb2YlMjB0aGUlMjBnYXRlX3VwX3Byb2olMjBtb2R1bGUlMEElMjAlMjAlMjAlMjBnYXRlJTJDJTIwdXAlMjAlM0QlMjBnYXRlX3VwLmNodW5rKDIlMkMlMjBkaW0lM0QtMSklMjAlMjMlMjBTcGxpdCUyMHRoZSUyMG91dHB1dCUyMGludG8lMjBnYXRlJTIwYW5kJTIwdXA=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
    ...
    gate_up = torch.bmm(hidden_states, self.gate_up_proj) <span class="hljs-comment"># Compute the output of the gate_up_proj module</span>
    gate, up = gate_up.chunk(<span class="hljs-number">2</span>, dim=-<span class="hljs-number">1</span>) <span class="hljs-comment"># Split the output into gate and up</span>`,wrap:!1}}),g=new He({props:{warning:!1,$$slots:{default:[os]},$$scope:{ctx:j}}}),O=new J({props:{title:"local* strategies",local:"local-strategies",headingTag:"h3"}}),_=new He({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:j}}}),le=new J({props:{title:"Extending the interface with your own partitioning strategies",local:"extending-the-interface-with-your-own-partitioning-strategies",headingTag:"h3"}}),ne=new T({props:{code:"Y2xhc3MlMjBDb2x3aXNlUGFyYWxsZWwoVGVuc29yUGFyYWxsZWxMYXllciklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2xheW91dHMlM0ElMjBPcHRpb25hbCU1QlBsYWNlbWVudCU1RCUyMCUzRCUyME5vbmUlMkMlMjAlMjMlMjBUaGUlMjBpbnB1dCUyMGxheW91dCUyMGNvbWluZyUyMGZyb20lMjB0aGUlMjBwcmV2aW91cyUyMGxheWVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2xheW91dHMlM0ElMjBPcHRpb25hbCU1QlBsYWNlbWVudCU1RCUyMCUzRCUyME5vbmUlMkMlMjAlMjMlMjBUaGUlMjBvdXRwdXQlMjBsYXlvdXQlMjB3ZSUyMHdhbnQlMjB0byUyMGFjaGlldmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfbG9jYWxfb3V0cHV0JTNBJTIwYm9vbCUyMCUzRCUyMFRydWUlMkMlMjAlMjMlMjBXaGV0aGVyJTIwdG8lMjB1c2UlMjBsb2NhbCUyMG91dHB1dCUyMG9yJTIwbm90JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX2R0ZW5zb3IlM0RUcnVlJTJDJTIwJTIzJTIwV2hldGhlciUyMHRvJTIwdXNlJTIwRFRlbnNvciUyMG9yJTIwbm90JTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5wdXRfbGF5b3V0cyUyMCUzRCUyMChpbnB1dF9sYXlvdXRzJTIwb3IlMjBSZXBsaWNhdGUoKSUyQyklMjAlMjMlMjBUaGUlMjBpbnB1dCUyMHNoYXJkaW5nJTIwY29taW5nJTIwZnJvbSUyMHRoZSUyMHByZXZpb3VzJTIwbGF5ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm91dHB1dF9sYXlvdXRzJTIwJTNEJTIwKG91dHB1dF9sYXlvdXRzJTIwb3IlMjBTaGFyZCgtMSklMkMpJTIwJTIzJTIwRGVzaXJlZCUyMG91dHB1dCUyMHNoYXJkaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXNpcmVkX2lucHV0X2xheW91dHMlMjAlM0QlMjAoUmVwbGljYXRlKCklMkMpJTIwJTIzJTIwRGVzaXJlZCUyMGlucHV0JTIwc2hhcmRpbmclMkMlMjBpbnB1dHMlMjBzaG91bGQlMjBiZSUyMHJlcGxpY2F0ZWQlMjBhY3Jvc3MlMjBHUFVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi51c2VfbG9jYWxfb3V0cHV0JTIwJTNEJTIwdXNlX2xvY2FsX291dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudXNlX2R0ZW5zb3IlMjAlM0QlMjB1c2VfZHRlbnNvcg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ColwiseParallel</span>(<span class="hljs-title class_ inherited__">TensorParallelLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        *,
        input_layouts: <span class="hljs-type">Optional</span>[Placement] = <span class="hljs-literal">None</span>, <span class="hljs-comment"># The input layout coming from the previous layer</span>
        output_layouts: <span class="hljs-type">Optional</span>[Placement] = <span class="hljs-literal">None</span>, <span class="hljs-comment"># The output layout we want to achieve</span>
        use_local_output: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Whether to use local output or not</span>
        use_dtensor=<span class="hljs-literal">True</span>, <span class="hljs-comment"># Whether to use DTensor or not</span>
    </span>):
        self.input_layouts = (input_layouts <span class="hljs-keyword">or</span> Replicate(),) <span class="hljs-comment"># The input sharding coming from the previous layer</span>
        self.output_layouts = (output_layouts <span class="hljs-keyword">or</span> Shard(-<span class="hljs-number">1</span>),) <span class="hljs-comment"># Desired output sharding</span>
        self.desired_input_layouts = (Replicate(),) <span class="hljs-comment"># Desired input sharding, inputs should be replicated across GPUs</span>
        self.use_local_output = use_local_output
        self.use_dtensor = use_dtensor`,wrap:!1}}),re=new T({props:{code:"ZGVmJTIwcGFydGl0aW9uX3RlbnNvciglMEElMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwcGFyYW0lMkMlMjAlMjMlMjBGdWxsJTIwdGVuc29yJTIwb2YlMjB0aGUlMjBwYXJhbWV0ZXIlMEElMjAlMjAlMjAlMjBlbXB0eV9wYXJhbSUyQyUyMCUyMyUyMEVtcHR5JTIwdGVuc29yJTIwb2YlMjB0aGUlMjBwYXJhbWV0ZXIlMkMlMjB3aWxsJTIwYmUlMjBmaWxsZWQlMjB3aXRoJTIwdGhlJTIwcGFydGl0aW9uZWQlMjB0ZW5zb3IlMEElMjAlMjAlMjAlMjBwYXJhbV90eXBlJTJDJTIwJTIzJTIwVHlwZSUyMG9mJTIwdGhlJTIwcGFyYW1ldGVyJTJDJTIwJTYwYmlhcyU2MCUyMG9yJTIwJTYwd2VpZ2h0JTYwJTBBJTIwJTIwJTIwJTIwcGFyYW1fY2FzdGluZ19kdHlwZSUyQyUyMCUyMyUyMFRoZSUyMHR5cGUlMjB0byUyMGNhc3QlMjB0aGUlMjBwYXJhbWV0ZXIlMjB0byUwQSUyMCUyMCUyMCUyMHRvX2NvbnRpZ3VvdXMlMkMlMjAlMjMlMjBXaGV0aGVyJTIwdG8lMjBjb252ZXJ0JTIwdGhlJTIwdGVuc29yJTIwdG8lMjBhJTIwY29udGlndW91cyUyMG1lbW9yeSUyMGxheW91dCUwQSUyMCUyMCUyMCUyMHJhbmslMkMlMjAlMjMlMjBUaGUlMjByYW5rJTIwb2YlMjB0aGUlMjBjdXJyZW50JTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21lc2glMkMlMjAlMjMlMjBUaGUlMjBkZXZpY2UlMjBtZXNoJTBBKSUyMC0lM0UlMjBubi5QYXJhbWV0ZXIlM0ElMjAlMjMlMjBSZXR1cm4lMjB0aGUlMjBwYXJ0aXRpb25lZCUyMHBhcmFtZXRlciUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">partition_tensor</span>(<span class="hljs-params">
    self,
    param, <span class="hljs-comment"># Full tensor of the parameter</span>
    empty_param, <span class="hljs-comment"># Empty tensor of the parameter, will be filled with the partitioned tensor</span>
    param_type, <span class="hljs-comment"># Type of the parameter, \`bias\` or \`weight\`</span>
    param_casting_dtype, <span class="hljs-comment"># The type to cast the parameter to</span>
    to_contiguous, <span class="hljs-comment"># Whether to convert the tensor to a contiguous memory layout</span>
    rank, <span class="hljs-comment"># The rank of the current device</span>
    device_mesh, <span class="hljs-comment"># The device mesh</span>
</span>) -&gt; nn.Parameter: <span class="hljs-comment"># Return the partitioned parameter</span>
    ...`,wrap:!1}}),Me=new T({props:{code:"ZGVmJTIwX3ByZXBhcmVfaW5wdXRfZm4oaW5wdXRfbGF5b3V0cyUyQyUyMGRlc2lyZWRfaW5wdXRfbGF5b3V0cyUyQyUyMG1vZCUyQyUyMGlucHV0cyUyQyUyMGRldmljZV9tZXNoKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMyUyMERvJTIwc29tZSUyMGN1c3RvbSUyMGxvZ2ljJTJDJTIwY2FzdCUyMHRvJTIwRFRlbnNvciUyMGV0Yy4lMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMucmVkaXN0cmlidXRlKHBsYWNlbWVudHMlM0RkZXNpcmVkX2lucHV0X2xheW91dHMlMkMlMjBkZXZpY2VfbWVzaCUzRGRldmljZV9tZXNoKSUwQSUwQWRlZiUyMF9wcmVwYXJlX291dHB1dF9mbihvdXRwdXRfbGF5b3V0cyUyQyUyMHVzZV9sb2NhbF9vdXRwdXQlMkMlMjBtb2QlMkMlMjBvdXRwdXRzJTJDJTIwZGV2aWNlX21lc2gpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIzJTIwRG8lMjBzb21lJTIwY3VzdG9tJTIwbG9naWMlMkMlMjBjYXN0JTIwdG8lMjBEVGVuc29yJTIwZXRjLiUwQSUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMucmVkaXN0cmlidXRlKHBsYWNlbWVudHMlM0RvdXRwdXRfbGF5b3V0cyUyQyUyMGRldmljZV9tZXNoJTNEZGV2aWNlX21lc2gp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_input_fn</span>(<span class="hljs-params">input_layouts, desired_input_layouts, mod, inputs, device_mesh</span>):
    ...
    <span class="hljs-comment"># Do some custom logic, cast to DTensor etc.</span>
    ...
    <span class="hljs-keyword">return</span> inputs.redistribute(placements=desired_input_layouts, device_mesh=device_mesh)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_output_fn</span>(<span class="hljs-params">output_layouts, use_local_output, mod, outputs, device_mesh</span>):
    ...
    <span class="hljs-comment"># Do some custom logic, cast to DTensor etc.</span>
    ...
    <span class="hljs-keyword">return</span> outputs.redistribute(placements=output_layouts, device_mesh=device_mesh)`,wrap:!1}}),me=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMudGVuc29yX3BhcmFsbGVsJTIwaW1wb3J0JTIwUGFyYWxsZWxJbnRlcmZhY2UlMEElMEFQYXJhbGxlbEludGVyZmFjZS5yZWdpc3Rlcl9zdHJhdGVneSglMjJjb2x3aXNlX2N1c3RvbSUyMiUyQyUyMENvbHdpc2VQYXJhbGxlbCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations.tensor_parallel <span class="hljs-keyword">import</span> ParallelInterface

ParallelInterface.register_strategy(<span class="hljs-string">&quot;colwise_custom&quot;</span>, ColwiseParallel)`,wrap:!1}}),he=new T({props:{code:"dHBfcGxhbiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsLmxheWVycy4qLnNlbGZfYXR0bi5xX3Byb2olMjIlM0ElMjAlMjJjb2x3aXNlX2N1c3RvbSUyMiUyQyUwQSUyMCUyMCUyMCUyMC4uLiUwQSU3RCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMHRwX3BsYW4lM0R0cF9wbGFuKQ==",highlighted:`tp_plan = {
    <span class="hljs-string">&quot;model.layers.*.self_attn.q_proj&quot;</span>: <span class="hljs-string">&quot;colwise_custom&quot;</span>,
    ...
}

model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, tp_plan=tp_plan)`,wrap:!1}}),we=new J({props:{title:"Full example",local:"full-example",headingTag:"h2"}}),Te=new T({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMEElMjMlMjBlbmFibGUlMjB0ZW5zb3IlMjBwYXJhbGxlbGlzbSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjB0cF9wbGFuJTNEJTIyYXV0byUyMiUyQyUwQSklMEElMEElMjMlMjBwcmVwYXJlJTIwaW5wdXQlMjB0b2tlbnMlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkNhbiUyMEklMjBoZWxwJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcy50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwZGlzdHJpYnV0ZWQlMjBydW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer


<span class="hljs-comment"># enable tensor parallelism</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    tp_plan=<span class="hljs-string">&quot;auto&quot;</span>,
)

<span class="hljs-comment"># prepare input tokens</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
prompt = <span class="hljs-string">&quot;Can I help&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(model.device)

<span class="hljs-comment"># distributed run</span>
outputs = model(inputs)`,wrap:!1}}),je=new T({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jLXBlci1ub2RlJTIwNCUyMGRlbW8ucHk=",highlighted:"torchrun --nproc-per-node 4 demo.py",wrap:!1}}),Ue=new J({props:{title:"Tensor parallelism in-depth",local:"tensor-parallelism-in-depth",headingTag:"h2"}}),ge=new J({props:{title:"DeviceMesh",local:"devicemesh",headingTag:"h3"}}),Be=new T({props:{code:"ZnJvbSUyMHRvcmNoLmRpc3RyaWJ1dGVkLmRldmljZV9tZXNoJTIwaW1wb3J0JTIwaW5pdF9kZXZpY2VfbWVzaCUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjAxRCUyMG1lc2glMjBvZiUyMDQlMjBHUFVzJTBBZGV2aWNlX21lc2glMjAlM0QlMjBpbml0X2RldmljZV9tZXNoKCUyMmN1ZGElMjIlMkMlMjAoNCUyQyklMkMlMjBtZXNoX2RpbV9uYW1lcyUzRCU1QiUyMnRwJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.distributed.device_mesh <span class="hljs-keyword">import</span> init_device_mesh

<span class="hljs-comment"># Create a 1D mesh of 4 GPUs</span>
device_mesh = init_device_mesh(<span class="hljs-string">&quot;cuda&quot;</span>, (<span class="hljs-number">4</span>,), mesh_dim_names=[<span class="hljs-string">&quot;tp&quot;</span>])`,wrap:!1}}),Ce=new J({props:{title:"DTensor",local:"dtensor",headingTag:"h3"}}),Xe=new T({props:{code:"d2VpZ2h0JTIwJTNEJTIwLi4uJTBBd2VpZ2h0JTIwJTNEJTIwRFRlbnNvci5mcm9tX2xvY2FsKHdlaWdodCUyQyUyMGRldmljZV9tZXNoJTVCJTIydHAlMjIlNUQlMkMlMjBwbGFjZW1lbnRzJTNEJTVCU2hhcmQoMCklNUQpJTIwJTIzJTIwU2hhcmQlMjBhY3Jvc3MlMjB0aGUlMjAxc3QlMjAoY29sdW1uLXdpc2UpJTIwZGltZW5zaW9uJTBBYmlhcyUyMCUzRCUyMC4uLiUwQWJpYXMlMjAlM0QlMjBEVGVuc29yLmZyb21fbG9jYWwoYmlhcyUyQyUyMGRldmljZV9tZXNoJTVCJTIydHAlMjIlNUQlMkMlMjBwbGFjZW1lbnRzJTNEJTVCU2hhcmQoLTEpJTVEKSUyMCUyMyUyMFNoYXJkJTIwYWNyb3NzJTIwdGhlJTIwT05MWSUyMGRpbWVuc2lvbg==",highlighted:`weight = ...
weight = DTensor.from_local(weight, device_mesh[<span class="hljs-string">&quot;tp&quot;</span>], placements=[Shard(<span class="hljs-number">0</span>)]) <span class="hljs-comment"># Shard across the 1st (column-wise) dimension</span>
bias = ...
bias = DTensor.from_local(bias, device_mesh[<span class="hljs-string">&quot;tp&quot;</span>], placements=[Shard(-<span class="hljs-number">1</span>)]) <span class="hljs-comment"># Shard across the ONLY dimension</span>`,wrap:!1}}),Ve=new T({props:{code:"d2VpZ2h0JTIwJTNEJTIwLi4uJTBBd2VpZ2h0JTIwJTNEJTIwRFRlbnNvci5mcm9tX2xvY2FsKHdlaWdodCUyQyUyMGRldmljZV9tZXNoJTVCJTIydHAlMjIlNUQlMkMlMjBwbGFjZW1lbnRzJTNEJTVCU2hhcmQoMSklNUQpJTIwJTIzJTIwU2hhcmQlMjBhY3Jvc3MlMjB0aGUlMjAybmQlMjAocm93LXdpc2UpJTIwZGltZW5zaW9uJTBBYmlhcyUyMCUzRCUyMC4uLiUwQWJpYXMlMjAlM0QlMjBEVGVuc29yLmZyb21fbG9jYWwoYmlhcyUyQyUyMGRldmljZV9tZXNoJTVCJTIydHAlMjIlNUQlMkMlMjBwbGFjZW1lbnRzJTNEJTVCUmVwbGljYXRlKCklNUQpJTIwJTIzJTIwUmVwbGljYXRlJTIwYmlhcyUyMGFjcm9zcyUyMGFsbCUyMEdQVXM=",highlighted:`weight = ...
weight = DTensor.from_local(weight, device_mesh[<span class="hljs-string">&quot;tp&quot;</span>], placements=[Shard(<span class="hljs-number">1</span>)]) <span class="hljs-comment"># Shard across the 2nd (row-wise) dimension</span>
bias = ...
bias = DTensor.from_local(bias, device_mesh[<span class="hljs-string">&quot;tp&quot;</span>], placements=[Replicate()]) <span class="hljs-comment"># Replicate bias across all GPUs</span>`,wrap:!1}}),Re=new ts({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_infer_gpu_multi.md"}}),{c(){o=i("meta"),y=a(),c=i("p"),f=a(),d(C.$$.fragment),Ye=a(),G=i("p"),G.innerHTML=nt,Ne=a(),d(b.$$.fragment),Le=a(),v=i("p"),v.textContent=ot,Ee=a(),d(U.$$.fragment),Qe=a(),Z=i("details"),Z.innerHTML=it,Fe=a(),d(X.$$.fragment),ze=a(),W=i("p"),W.innerHTML=rt,Se=a(),d(V.$$.fragment),qe=a(),k=i("p"),k.innerHTML=pt,Pe=a(),d(R.$$.fragment),De=a(),x=i("p"),x.textContent=ct,Ke=a(),H=i("ul"),H.innerHTML=dt,Oe=a(),d(A.$$.fragment),el=a(),Y=i("p"),Y.innerHTML=Mt,ll=a(),d(N.$$.fragment),tl=a(),d(I.$$.fragment),sl=a(),L=i("p"),L.textContent=mt,al=a(),d(E.$$.fragment),nl=a(),Q=i("p"),Q.innerHTML=ut,ol=a(),d(F.$$.fragment),il=a(),z=i("p"),z.innerHTML=ht,rl=a(),S=i("p"),S.innerHTML=wt,pl=a(),d(q.$$.fragment),cl=a(),P=i("p"),P.innerHTML=yt,dl=a(),d(D.$$.fragment),Ml=a(),K=i("p"),K.innerHTML=Tt,ml=a(),d(g.$$.fragment),ul=a(),d(O.$$.fragment),hl=a(),ee=i("p"),ee.innerHTML=ft,wl=a(),d(_.$$.fragment),yl=a(),d(le.$$.fragment),Tl=a(),te=i("p"),te.innerHTML=jt,fl=a(),se=i("p"),se.innerHTML=Jt,jl=a(),ae=i("ol"),ae.innerHTML=bt,Jl=a(),d(ne.$$.fragment),bl=a(),oe=i("p"),oe.innerHTML=Ut,Ul=a(),ie=i("p"),ie.innerHTML=It,Il=a(),d(re.$$.fragment),gl=a(),pe=i("p"),pe.innerHTML=gt,_l=a(),ce=i("p"),ce.innerHTML=_t,Bl=a(),de=i("p"),de.innerHTML=Bt,$l=a(),d(Me.$$.fragment),Cl=a(),B=i("ol"),B.innerHTML=$t,Gl=a(),d(me.$$.fragment),vl=a(),ue=i("p"),ue.innerHTML=Ct,Zl=a(),d(he.$$.fragment),Xl=a(),d(we.$$.fragment),Wl=a(),ye=i("p"),ye.textContent=Gt,Vl=a(),d(Te.$$.fragment),kl=a(),fe=i("p"),fe.innerHTML=vt,Rl=a(),d(je.$$.fragment),xl=a(),Je=i("p"),Je.textContent=Zt,Hl=a(),be=i("p"),be.innerHTML=Xt,Al=a(),$=i("div"),$.innerHTML=Wt,Yl=a(),d(Ue.$$.fragment),Nl=a(),Ie=i("p"),Ie.innerHTML=Vt,Ll=a(),d(ge.$$.fragment),El=a(),_e=i("p"),_e.innerHTML=kt,Ql=a(),d(Be.$$.fragment),Fl=a(),$e=i("p"),$e.innerHTML=Rt,zl=a(),d(Ce.$$.fragment),Sl=a(),Ge=i("p"),Ge.innerHTML=xt,ql=a(),ve=i("p"),ve.textContent=Ht,Pl=a(),Ze=i("ul"),Ze.innerHTML=At,Dl=a(),d(Xe.$$.fragment),Kl=a(),We=i("p"),We.textContent=Yt,Ol=a(),d(Ve.$$.fragment),et=a(),ke=i("ul"),ke.innerHTML=Nt,lt=a(),d(Re.$$.fragment),tt=a(),xe=i("p"),this.h()},l(e){const l=Ot("svelte-u9bgzb",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(t),y=n(e),c=r(e,"P",{}),St(c).forEach(t),f=n(e),M(C.$$.fragment,e),Ye=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-yy76hy"&&(G.innerHTML=nt),Ne=n(e),M(b.$$.fragment,e),Le=n(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1j3zdyi"&&(v.textContent=ot),Ee=n(e),M(U.$$.fragment,e),Qe=n(e),Z=r(e,"DETAILS",{"data-svelte-h":!0}),p(Z)!=="svelte-svh7x"&&(Z.innerHTML=it),Fe=n(e),M(X.$$.fragment,e),ze=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-zbjxcw"&&(W.innerHTML=rt),Se=n(e),M(V.$$.fragment,e),qe=n(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-ulgkhk"&&(k.innerHTML=pt),Pe=n(e),M(R.$$.fragment,e),De=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-wr2bdq"&&(x.textContent=ct),Ke=n(e),H=r(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1eihssd"&&(H.innerHTML=dt),Oe=n(e),M(A.$$.fragment,e),el=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1fj1l6x"&&(Y.innerHTML=Mt),ll=n(e),M(N.$$.fragment,e),tl=n(e),M(I.$$.fragment,e),sl=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-19ygb3r"&&(L.textContent=mt),al=n(e),M(E.$$.fragment,e),nl=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-nw82xq"&&(Q.innerHTML=ut),ol=n(e),M(F.$$.fragment,e),il=n(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1cgy0u2"&&(z.innerHTML=ht),rl=n(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-akd5lc"&&(S.innerHTML=wt),pl=n(e),M(q.$$.fragment,e),cl=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-17cpnad"&&(P.innerHTML=yt),dl=n(e),M(D.$$.fragment,e),Ml=n(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-11b8acn"&&(K.innerHTML=Tt),ml=n(e),M(g.$$.fragment,e),ul=n(e),M(O.$$.fragment,e),hl=n(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-tjtroj"&&(ee.innerHTML=ft),wl=n(e),M(_.$$.fragment,e),yl=n(e),M(le.$$.fragment,e),Tl=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-14oayqb"&&(te.innerHTML=jt),fl=n(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-a3qvmr"&&(se.innerHTML=Jt),jl=n(e),ae=r(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-c6x59z"&&(ae.innerHTML=bt),Jl=n(e),M(ne.$$.fragment,e),bl=n(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-imxlcm"&&(oe.innerHTML=Ut),Ul=n(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-porjao"&&(ie.innerHTML=It),Il=n(e),M(re.$$.fragment,e),gl=n(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1js0maj"&&(pe.innerHTML=gt),_l=n(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1gs7kk5"&&(ce.innerHTML=_t),Bl=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-m9biz1"&&(de.innerHTML=Bt),$l=n(e),M(Me.$$.fragment,e),Cl=n(e),B=r(e,"OL",{start:!0,"data-svelte-h":!0}),p(B)!=="svelte-199ereb"&&(B.innerHTML=$t),Gl=n(e),M(me.$$.fragment,e),vl=n(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-15wm6uy"&&(ue.innerHTML=Ct),Zl=n(e),M(he.$$.fragment,e),Xl=n(e),M(we.$$.fragment,e),Wl=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-tf0qg7"&&(ye.textContent=Gt),Vl=n(e),M(Te.$$.fragment,e),kl=n(e),fe=r(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-968uev"&&(fe.innerHTML=vt),Rl=n(e),M(je.$$.fragment,e),xl=n(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-8zwnyi"&&(Je.textContent=Zt),Hl=n(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-bszveo"&&(be.innerHTML=Xt),Al=n(e),$=r(e,"DIV",{style:!0,"data-svelte-h":!0}),p($)!=="svelte-1tp7cj2"&&($.innerHTML=Wt),Yl=n(e),M(Ue.$$.fragment,e),Nl=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-toiq3e"&&(Ie.innerHTML=Vt),Ll=n(e),M(ge.$$.fragment,e),El=n(e),_e=r(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-txx5xu"&&(_e.innerHTML=kt),Ql=n(e),M(Be.$$.fragment,e),Fl=n(e),$e=r(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1mfcxex"&&($e.innerHTML=Rt),zl=n(e),M(Ce.$$.fragment,e),Sl=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1mjlmjm"&&(Ge.innerHTML=xt),ql=n(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-y8yerj"&&(ve.textContent=Ht),Pl=n(e),Ze=r(e,"UL",{"data-svelte-h":!0}),p(Ze)!=="svelte-1j554u3"&&(Ze.innerHTML=At),Dl=n(e),M(Xe.$$.fragment,e),Kl=n(e),We=r(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-q6nvnb"&&(We.textContent=Yt),Ol=n(e),M(Ve.$$.fragment,e),et=n(e),ke=r(e,"UL",{"data-svelte-h":!0}),p(ke)!=="svelte-1ssd1d"&&(ke.innerHTML=Nt),lt=n(e),M(Re.$$.fragment,e),tt=n(e),xe=r(e,"P",{}),St(xe).forEach(t),this.h()},h(){at(o,"name","hf:doc:metadata"),at(o,"content",ps),at(B,"start","3"),es($,"text-align","center")},m(e,l){ls(document.head,o),s(e,y,l),s(e,c,l),s(e,f,l),m(C,e,l),s(e,Ye,l),s(e,G,l),s(e,Ne,l),m(b,e,l),s(e,Le,l),s(e,v,l),s(e,Ee,l),m(U,e,l),s(e,Qe,l),s(e,Z,l),s(e,Fe,l),m(X,e,l),s(e,ze,l),s(e,W,l),s(e,Se,l),m(V,e,l),s(e,qe,l),s(e,k,l),s(e,Pe,l),m(R,e,l),s(e,De,l),s(e,x,l),s(e,Ke,l),s(e,H,l),s(e,Oe,l),m(A,e,l),s(e,el,l),s(e,Y,l),s(e,ll,l),m(N,e,l),s(e,tl,l),m(I,e,l),s(e,sl,l),s(e,L,l),s(e,al,l),m(E,e,l),s(e,nl,l),s(e,Q,l),s(e,ol,l),m(F,e,l),s(e,il,l),s(e,z,l),s(e,rl,l),s(e,S,l),s(e,pl,l),m(q,e,l),s(e,cl,l),s(e,P,l),s(e,dl,l),m(D,e,l),s(e,Ml,l),s(e,K,l),s(e,ml,l),m(g,e,l),s(e,ul,l),m(O,e,l),s(e,hl,l),s(e,ee,l),s(e,wl,l),m(_,e,l),s(e,yl,l),m(le,e,l),s(e,Tl,l),s(e,te,l),s(e,fl,l),s(e,se,l),s(e,jl,l),s(e,ae,l),s(e,Jl,l),m(ne,e,l),s(e,bl,l),s(e,oe,l),s(e,Ul,l),s(e,ie,l),s(e,Il,l),m(re,e,l),s(e,gl,l),s(e,pe,l),s(e,_l,l),s(e,ce,l),s(e,Bl,l),s(e,de,l),s(e,$l,l),m(Me,e,l),s(e,Cl,l),s(e,B,l),s(e,Gl,l),m(me,e,l),s(e,vl,l),s(e,ue,l),s(e,Zl,l),m(he,e,l),s(e,Xl,l),m(we,e,l),s(e,Wl,l),s(e,ye,l),s(e,Vl,l),m(Te,e,l),s(e,kl,l),s(e,fe,l),s(e,Rl,l),m(je,e,l),s(e,xl,l),s(e,Je,l),s(e,Hl,l),s(e,be,l),s(e,Al,l),s(e,$,l),s(e,Yl,l),m(Ue,e,l),s(e,Nl,l),s(e,Ie,l),s(e,Ll,l),m(ge,e,l),s(e,El,l),s(e,_e,l),s(e,Ql,l),m(Be,e,l),s(e,Fl,l),s(e,$e,l),s(e,zl,l),m(Ce,e,l),s(e,Sl,l),s(e,Ge,l),s(e,ql,l),s(e,ve,l),s(e,Pl,l),s(e,Ze,l),s(e,Dl,l),m(Xe,e,l),s(e,Kl,l),s(e,We,l),s(e,Ol,l),m(Ve,e,l),s(e,et,l),s(e,ke,l),s(e,lt,l),m(Re,e,l),s(e,tt,l),s(e,xe,l),st=!0},p(e,[l]){const Lt={};l&2&&(Lt.$$scope={dirty:l,ctx:e}),b.$set(Lt);const Et={};l&2&&(Et.$$scope={dirty:l,ctx:e}),U.$set(Et);const Qt={};l&2&&(Qt.$$scope={dirty:l,ctx:e}),I.$set(Qt);const Ft={};l&2&&(Ft.$$scope={dirty:l,ctx:e}),g.$set(Ft);const zt={};l&2&&(zt.$$scope={dirty:l,ctx:e}),_.$set(zt)},i(e){st||(u(C.$$.fragment,e),u(b.$$.fragment,e),u(U.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(I.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(g.$$.fragment,e),u(O.$$.fragment,e),u(_.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(ge.$$.fragment,e),u(Be.$$.fragment,e),u(Ce.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Re.$$.fragment,e),st=!0)},o(e){h(C.$$.fragment,e),h(b.$$.fragment,e),h(U.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(A.$$.fragment,e),h(N.$$.fragment,e),h(I.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(g.$$.fragment,e),h(O.$$.fragment,e),h(_.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(Me.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(ge.$$.fragment,e),h(Be.$$.fragment,e),h(Ce.$$.fragment,e),h(Xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Re.$$.fragment,e),st=!1},d(e){e&&(t(y),t(c),t(f),t(Ye),t(G),t(Ne),t(Le),t(v),t(Ee),t(Qe),t(Z),t(Fe),t(ze),t(W),t(Se),t(qe),t(k),t(Pe),t(De),t(x),t(Ke),t(H),t(Oe),t(el),t(Y),t(ll),t(tl),t(sl),t(L),t(al),t(nl),t(Q),t(ol),t(il),t(z),t(rl),t(S),t(pl),t(cl),t(P),t(dl),t(Ml),t(K),t(ml),t(ul),t(hl),t(ee),t(wl),t(yl),t(Tl),t(te),t(fl),t(se),t(jl),t(ae),t(Jl),t(bl),t(oe),t(Ul),t(ie),t(Il),t(gl),t(pe),t(_l),t(ce),t(Bl),t(de),t($l),t(Cl),t(B),t(Gl),t(vl),t(ue),t(Zl),t(Xl),t(Wl),t(ye),t(Vl),t(kl),t(fe),t(Rl),t(xl),t(Je),t(Hl),t(be),t(Al),t($),t(Yl),t(Nl),t(Ie),t(Ll),t(El),t(_e),t(Ql),t(Fl),t($e),t(zl),t(Sl),t(Ge),t(ql),t(ve),t(Pl),t(Ze),t(Dl),t(Kl),t(We),t(Ol),t(et),t(ke),t(lt),t(tt),t(xe)),t(o),w(C,e),w(b,e),w(U,e),w(X,e),w(V,e),w(R,e),w(A,e),w(N,e),w(I,e),w(E,e),w(F,e),w(q,e),w(D,e),w(g,e),w(O,e),w(_,e),w(le,e),w(ne,e),w(re,e),w(Me,e),w(me,e),w(he,e),w(we,e),w(Te,e),w(je,e),w(Ue,e),w(ge,e),w(Be,e),w(Ce,e),w(Xe,e),w(Ve,e),w(Re,e)}}}const ps='{"title":"Tensor parallelism in transformers","local":"tensor-parallelism-in-transformers","sections":[{"title":"Using 🤗 transformers","local":"using--transformers","sections":[{"title":"Partitioning strategies","local":"partitioning-strategies","sections":[],"depth":3},{"title":"Sharding a model","local":"sharding-a-model","sections":[],"depth":3},{"title":"PackedRowwiseParallel","local":"packedrowwiseparallel","sections":[],"depth":3},{"title":"local* strategies","local":"local-strategies","sections":[],"depth":3},{"title":"Extending the interface with your own partitioning strategies","local":"extending-the-interface-with-your-own-partitioning-strategies","sections":[],"depth":3}],"depth":2},{"title":"Full example","local":"full-example","sections":[],"depth":2},{"title":"Tensor parallelism in-depth","local":"tensor-parallelism-in-depth","sections":[{"title":"DeviceMesh","local":"devicemesh","sections":[],"depth":3},{"title":"DTensor","local":"dtensor","sections":[],"depth":3}],"depth":2}],"depth":1}';function cs(j){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends Dt{constructor(o){super(),Kt(this,o,cs,rs,qt,{})}}export{ys as component};
