import{s as we,n as _e,o as qe}from"../chunks/scheduler.18a86fab.js";import{S as ze,i as Te,g as r,s as i,r as P,A as Me,h as s,f as a,c as o,j as K,u as I,x as d,k as ye,y as h,a as n,v as Q,d as j,t as J,w as A}from"../chunks/index.98837b22.js";import{C as ve}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as oe}from"../chunks/Heading.7e7e0c5b.js";import{E as Le}from"../chunks/getInferenceSnippets.de10bc7d.js";function $e(re){let c,E,k,W,f,Z,p,se='Transformers supports many quantization methods such as QLoRA, GPTQ, LLM.int8, and AWQ. However, there are still many more quantization approaches that haven’t been integrated yet. To make adding and using these quantization methods with Transformers easier, use the <a href="/docs/transformers/main/en/main_classes/quantization#transformers.quantizers.HfQuantizer">HfQuantizer</a> class.  <a href="/docs/transformers/main/en/main_classes/quantization#transformers.quantizers.HfQuantizer">HfQuantizer</a> is designed to be an internal helper class for adding a quantization method instead of something applied to every PyTorch module.',S,g,le='This guide will show you how to integrate a new quantization method with <a href="/docs/transformers/main/en/main_classes/quantization#transformers.quantizers.HfQuantizer">HfQuantizer</a>.',Y,b,B,y,he="Before integrating a new quantization method into Transformers, ensure the method meets the following requirements. Only quantization methods that can be run with PyTorch modules are supported.",F,l,M,de="<p>The quantization method is available through a Python package that is pip-installable (it is also fine if you can only install the package from source). Ideally, pre-compiled kernels are included in the pip package.</p>",N,v,ue="<p>The method can run on commonly-used hardware (CPU, GPU, etc.).</p>",ee,m,L,ce='The method is wrapped in a <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">nn.Module</a> (<code>~bitsandbytes.nn.Linear8bitLt</code>, <code>~bitsandbytes.nn.Linear4bit</code>), and the quantized linear layer should have the following definition.',te,w,ae,$,me='This way, Transformers models are easily quantized by replacing instances of <a href="https://pytorch.org/docs/stable/generated/torch.nn.Linear.html" rel="nofollow">nn.Linear</a> with a target class.',ne,C,fe="<p>The quantization method should be serializable. You can save the quantized weights locally or push them to the Hub.</p>",ie,x,pe="<p>Make sure the package containing the quantization kernels/primitive is stable (no frequent breaking changes).</p>",G,_,ge="Some quantization methods may require “pre-quantizing” the model through data calibration (AWQ). In this case, we prefer to only support inference in Transformers and let the third-party library maintained by the ML community deal handle the model quantization itself.",R,q,X,z,be='<li><p>Create a new quantization config class inside <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/quantization_config.py" rel="nofollow">src/transformers/utils/quantization_config.py</a>. Add the new quantization config to the <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py#L1088" rel="nofollow">_import_structure</a> inside Transformers’ <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py" rel="nofollow">src/transformers/<strong>init</strong>.py</a> file.</p></li> <li><p>Create a new file inside <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers" rel="nofollow">src/transformers/quantizers/</a> named <code>quantizer_your_method.py</code>, and make it inherit from [`~quantizers.HfQuantizer]. Make sure to add the new quantizer and quantization config in the quantization auto-mapping in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/auto.py" rel="nofollow">src/transformers/quantizers/auto.py</a>.</p></li> <li><p>Define the following class attributes and property methods for your quantization method.</p> <ul><li><code>requires_calibration</code>: Whether the quantization method requires a data calibration process. If set to <code>True</code>, you can only support inference (with quantized weights) and not inference and quantization.</li> <li><code>required_packages</code>: A list of strings of the required packages to use the quantized weights. You might need to define some new utility methods such as <code>is_auto_awq_available</code> in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/import_utils.py" rel="nofollow">transformers/src/utils/import_utils.py</a>.</li> <li><code>requires_parameters_quantization</code>: Only required if your quantization method requires extra attention to the underlying <a href="https://pytorch.org/docs/stable/generated/torch.nn.parameter.Parameter.html" rel="nofollow">nn.Parameter</a> object. For example, bitsandbytes uses <code>~bitsandbytes.nn.Params4bit</code> and <code>~bitsandbytes.nn.Int8Params</code>, which requires some extra attention when quantizing the model. Most of the recent quantization method packs int2 and int4 weights inside <a href="https://pytorch.org/docs/stable/tensors.html" rel="nofollow">torch.uint8</a> weights, so this flag should not be really required (set to <code>False</code> by default).</li> <li><code>is_serializable</code>: A property method to determine whether the method is serializable or not.</li> <li><code>is_trainable</code>:  A property method to determine whether you can fine-tune models on top of the quantization method (with or without PEFT approaches).</li></ul></li> <li><p>Write the <code>validate_environment</code> and <code>update_torch_dtype</code> methods. These methods are called before creating the quantized model to ensure users use the right configuration. Refer to other quantizers for an example of it is implemented.</p></li> <li><p>Write the <code>_process_model_before_weight_loading</code> method. In Transformers, the quantized models are initialized first on the <code>&quot;meta&quot;</code> device before loading the weights. This means the <code>_process_model_before_weight_loading</code> method takes care of manipulating the model skeleton to replace some modules (<a href="https://pytorch.org/docs/stable/generated/torch.nn.Linear.html" rel="nofollow">nn.Linear</a>) with the target modules (quantization modules).</p> <p>You can define module replacement logic or any other utility method by creating a new file in <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/integrations" rel="nofollow">transformers/src/integrations/</a> and exposing the relevant methods in that folder’s <code>__init__.py</code> file. The best starting point would be to have a look at another quantization method such as <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/quantizer_awq.py" rel="nofollow">quantizer_awq.py</a>.</p></li> <li><p>Write the <code>_process_model_after_weight_loading</code> method. This method enables implementing additional features that require manipulating the model after loading the weights.</p></li> <li><p>Document everything! Make sure your quantization method is documented by adding a new file under <code>docs/source/en/quantization</code>.</p></li> <li><p>You should add tests by adding the package in our nightly Dockerfile inside <code>docker/transformers-quantization-latest-gpu</code> and then adding a new test file in <code>tests/quantization/xxx</code>. Feel free to check out existing quantization methods to see how it is implemented.</p></li>',D,T,V,U,O;return f=new oe({props:{title:"Contribute",local:"contribute",headingTag:"h1"}}),b=new oe({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),w=new ve({props:{code:"Y2xhc3MlMjBMaW5lYXI0Yml0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbXlfNGJpdF9rZXJuZWwoeCUyQyUyMHNlbGYud2VpZ2h0JTJDJTIwc2VsZi5iaWFzKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Linear4bit</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ...</span>):
        ...
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> my_4bit_kernel(x, self.weight, self.bias)`,wrap:!1}}),q=new oe({props:{title:"Create new HFQuantizer class",local:"create-new-hfquantizer-class",headingTag:"h2"}}),T=new Le({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/contribute.md"}}),{c(){c=r("meta"),E=i(),k=r("p"),W=i(),P(f.$$.fragment),Z=i(),p=r("p"),p.innerHTML=se,S=i(),g=r("p"),g.innerHTML=le,Y=i(),P(b.$$.fragment),B=i(),y=r("p"),y.textContent=he,F=i(),l=r("ul"),M=r("li"),M.innerHTML=de,N=i(),v=r("li"),v.innerHTML=ue,ee=i(),m=r("li"),L=r("p"),L.innerHTML=ce,te=i(),P(w.$$.fragment),ae=i(),$=r("p"),$.innerHTML=me,ne=i(),C=r("li"),C.innerHTML=fe,ie=i(),x=r("li"),x.innerHTML=pe,G=i(),_=r("p"),_.textContent=ge,R=i(),P(q.$$.fragment),X=i(),z=r("ol"),z.innerHTML=be,D=i(),P(T.$$.fragment),V=i(),U=r("p"),this.h()},l(e){const t=Me("svelte-u9bgzb",document.head);c=s(t,"META",{name:!0,content:!0}),t.forEach(a),E=o(e),k=s(e,"P",{}),K(k).forEach(a),W=o(e),I(f.$$.fragment,e),Z=o(e),p=s(e,"P",{"data-svelte-h":!0}),d(p)!=="svelte-yj2ewj"&&(p.innerHTML=se),S=o(e),g=s(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-14tob6x"&&(g.innerHTML=le),Y=o(e),I(b.$$.fragment,e),B=o(e),y=s(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1xzixq6"&&(y.textContent=he),F=o(e),l=s(e,"UL",{});var u=K(l);M=s(u,"LI",{"data-svelte-h":!0}),d(M)!=="svelte-sv9ywh"&&(M.innerHTML=de),N=o(u),v=s(u,"LI",{"data-svelte-h":!0}),d(v)!=="svelte-9za9zo"&&(v.innerHTML=ue),ee=o(u),m=s(u,"LI",{});var H=K(m);L=s(H,"P",{"data-svelte-h":!0}),d(L)!=="svelte-jibffa"&&(L.innerHTML=ce),te=o(H),I(w.$$.fragment,H),ae=o(H),$=s(H,"P",{"data-svelte-h":!0}),d($)!=="svelte-8aozwx"&&($.innerHTML=me),H.forEach(a),ne=o(u),C=s(u,"LI",{"data-svelte-h":!0}),d(C)!=="svelte-z7e46y"&&(C.innerHTML=fe),ie=o(u),x=s(u,"LI",{"data-svelte-h":!0}),d(x)!=="svelte-1fr6u90"&&(x.innerHTML=pe),u.forEach(a),G=o(e),_=s(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-70g41u"&&(_.textContent=ge),R=o(e),I(q.$$.fragment,e),X=o(e),z=s(e,"OL",{"data-svelte-h":!0}),d(z)!=="svelte-z7zmfd"&&(z.innerHTML=be),D=o(e),I(T.$$.fragment,e),V=o(e),U=s(e,"P",{}),K(U).forEach(a),this.h()},h(){ye(c,"name","hf:doc:metadata"),ye(c,"content",Ce)},m(e,t){h(document.head,c),n(e,E,t),n(e,k,t),n(e,W,t),Q(f,e,t),n(e,Z,t),n(e,p,t),n(e,S,t),n(e,g,t),n(e,Y,t),Q(b,e,t),n(e,B,t),n(e,y,t),n(e,F,t),n(e,l,t),h(l,M),h(l,N),h(l,v),h(l,ee),h(l,m),h(m,L),h(m,te),Q(w,m,null),h(m,ae),h(m,$),h(l,ne),h(l,C),h(l,ie),h(l,x),n(e,G,t),n(e,_,t),n(e,R,t),Q(q,e,t),n(e,X,t),n(e,z,t),n(e,D,t),Q(T,e,t),n(e,V,t),n(e,U,t),O=!0},p:_e,i(e){O||(j(f.$$.fragment,e),j(b.$$.fragment,e),j(w.$$.fragment,e),j(q.$$.fragment,e),j(T.$$.fragment,e),O=!0)},o(e){J(f.$$.fragment,e),J(b.$$.fragment,e),J(w.$$.fragment,e),J(q.$$.fragment,e),J(T.$$.fragment,e),O=!1},d(e){e&&(a(E),a(k),a(W),a(Z),a(p),a(S),a(g),a(Y),a(B),a(y),a(F),a(l),a(G),a(_),a(R),a(X),a(z),a(D),a(V),a(U)),a(c),A(f,e),A(b,e),A(w),A(q,e),A(T,e)}}}const Ce='{"title":"Contribute","local":"contribute","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Create new HFQuantizer class","local":"create-new-hfquantizer-class","sections":[],"depth":2}],"depth":1}';function xe(re){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qe extends ze{constructor(c){super(),Te(this,c,xe,$e,we,{})}}export{Qe as component};
