import{s as Ae,n as ze,o as He}from"../chunks/scheduler.18a86fab.js";import{S as Ee,i as Fe,g as o,s as a,r as M,A as Qe,h as i,f as t,c as n,j as Ne,u as c,x as r,k as Be,y as $e,a as s,v as p,d,t as y,w as m}from"../chunks/index.98837b22.js";import{C as h}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as xe}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as Se}from"../chunks/Heading.7e7e0c5b.js";import{E as qe}from"../chunks/getInferenceSnippets.de10bc7d.js";function Le(fe){let u,x,Q,S,U,q,w,L,b,Te='Knowledge distillation is a technique used to transfer knowledge from a larger, more complex model (teacher) to a smaller, simpler model (student). To distill knowledge from one model to another, we take a pre-trained teacher model trained on a certain task (image classification for this case) and randomly initialize a student model to be trained on image classification. Next, we train the student model to minimize the difference between its outputs and the teacher’s outputs, thus making it mimic the behavior. It was first introduced in <a href="https://arxiv.org/abs/1503.02531" rel="nofollow">Distilling the Knowledge in a Neural Network by Hinton et al</a>. In this guide, we will do task-specific knowledge distillation. We will use the <a href="https://huggingface.co/datasets/beans" rel="nofollow">beans dataset</a> for this.',D,J,ge='This guide demonstrates how you can distill a <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">fine-tuned ViT model</a> (teacher model) to a <a href="https://huggingface.co/google/mobilenet_v2_1.4_224" rel="nofollow">MobileNet</a> (student model) using the <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#trainer" rel="nofollow">Trainer API</a> of 🤗 Transformers.',K,j,Ce="Let’s install the libraries needed for distillation and evaluating the process.",P,f,O,T,Ze="In this example, we are using the <code>merve/beans-vit-224</code> model as teacher model. It’s an image classification model, based on <code>google/vit-base-patch16-224-in21k</code> fine-tuned on beans dataset. We will distill this model to a randomly initialized MobileNetV2.",ee,g,_e="We will now load the dataset.",le,C,te,Z,We="We can use an image processor from either of the models, as in this case they return the same output with same resolution. We will use the <code>map()</code> method of <code>dataset</code> to apply the preprocessing to every split of the dataset.",se,_,ae,W,Ge="Essentially, we want the student model (a randomly initialized MobileNet) to mimic the teacher model (fine-tuned vision transformer). To achieve this, we first get the logits output from the teacher and the student. Then, we divide each of them by the parameter <code>temperature</code> which controls the importance of each soft target. A parameter called <code>lambda</code> weighs the importance of the distillation loss. In this example, we will use <code>temperature=5</code> and <code>lambda=0.5</code>. We will use the Kullback-Leibler Divergence loss to compute the divergence between the student and teacher. Given two data P and Q, KL Divergence explains how much extra information we need to represent P using Q. If two are identical, their KL divergence is zero, as there’s no other information needed to explain P from Q. Thus, in the context of knowledge distillation, KL divergence is useful.",ne,G,oe,R,Re="We will now login to Hugging Face Hub so we can push our model to the Hugging Face Hub through the <code>Trainer</code>.",ie,I,re,V,Ie="Let’s set the <code>TrainingArguments</code>, the teacher model and the student model.",Me,v,ce,X,Ve="We can use <code>compute_metrics</code> function to evaluate our model on the test set. This function will be used during the training process to compute the <code>accuracy</code> &amp; <code>f1</code> of our model.",pe,k,de,Y,ve="Let’s initialize the <code>Trainer</code> with the training arguments we defined. We will also initialize our data collator.",ye,N,me,B,Xe="We can now train our model.",he,A,ue,z,ke="We can evaluate the model on the test set.",Ue,H,we,E,Ye='On test set, our model reaches 72 percent accuracy. To have a sanity check over efficiency of distillation, we also trained MobileNet on the beans dataset from scratch with the same hyperparameters and observed 63 percent accuracy on the test set. We invite the readers to try different pre-trained teacher models, student architectures, distillation parameters and report their findings. The training logs and checkpoints for distilled model can be found in <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">this repository</a>, and MobileNetV2 trained from scratch can be found in this <a href="https://huggingface.co/merve/resnet-mobilenet-beans-5" rel="nofollow">repository</a>.',be,F,Je,$,je;return U=new Se({props:{title:"Knowledge Distillation for Computer Vision",local:"knowledge-distillation-for-computer-vision",headingTag:"h1"}}),w=new xe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/knowledge_distillation_for_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/knowledge_distillation_for_image_classification.ipynb"}]}}),f=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMHRlbnNvcmJvYXJkJTIwZXZhbHVhdGUlMjAtLXVwZ3JhZGU=",highlighted:"pip install transformers datasets accelerate tensorboard evaluate --upgrade",wrap:!1}}),C=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiZWFucyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>)`,wrap:!1}}),_=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQXRlYWNoZXJfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtZXJ2ZSUyRmJlYW5zLXZpdC0yMjQlMjIpJTBBJTBBZGVmJTIwcHJvY2VzcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfaW5wdXRzJTIwJTNEJTIwdGVhY2hlcl9wcm9jZXNzb3IoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwcm9jZXNzZWRfaW5wdXRzJTBBJTBBcHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2VzcyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
teacher_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">examples</span>):
    processed_inputs = teacher_processor(examples[<span class="hljs-string">&quot;image&quot;</span>])
    <span class="hljs-keyword">return</span> processed_inputs

processed_datasets = dataset.<span class="hljs-built_in">map</span>(process, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageDistilTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, teacher_model=<span class="hljs-literal">None</span>, student_model=<span class="hljs-literal">None</span>, temperature=<span class="hljs-literal">None</span>, lambda_param=<span class="hljs-literal">None</span>,  *args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(model=student_model, *args, **kwargs)
        self.teacher = teacher_model
        self.student = student_model
        self.loss_function = nn.KLDivLoss(reduction=<span class="hljs-string">&quot;batchmean&quot;</span>)
        device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
        self.teacher.to(device)
        self.teacher.<span class="hljs-built_in">eval</span>()
        self.temperature = temperature
        self.lambda_param = lambda_param

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, student, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        student_output = self.student(**inputs)

        <span class="hljs-keyword">with</span> torch.no_grad():
          teacher_output = self.teacher(**inputs)

        <span class="hljs-comment"># Compute soft targets for teacher and student</span>
        soft_teacher = F.softmax(teacher_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)
        soft_student = F.log_softmax(student_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Compute the loss</span>
        distillation_loss = self.loss_function(soft_student, soft_teacher) * (self.temperature ** <span class="hljs-number">2</span>)

        <span class="hljs-comment"># Compute the true label loss</span>
        student_target_loss = student_output.loss

        <span class="hljs-comment"># Calculate final loss</span>
        loss = (<span class="hljs-number">1.</span> - self.lambda_param) * student_target_loss + self.lambda_param * distillation_loss
        <span class="hljs-keyword">return</span> (loss, student_output) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),I=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBNb2JpbGVOZXRWMkNvbmZpZyUyQyUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIybXktYXdlc29tZS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0RmJTIyJTdCcmVwb19uYW1lJTdEJTJGbG9ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyYWNjdXJhY3klMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0ZW5zb3Jib2FyZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGh1Yl9zdHJhdGVneSUzRCUyMmV2ZXJ5X3NhdmUlMjIlMkMlMEElMjAlMjAlMjAlMjBodWJfbW9kZWxfaWQlM0RyZXBvX25hbWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVscyUyMiU1RC5uYW1lcyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwbW9kZWxzJTBBdGVhY2hlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1lcnZlJTJGYmVhbnMtdml0LTIyNCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMHRyYWluaW5nJTIwTW9iaWxlTmV0VjIlMjBmcm9tJTIwc2NyYXRjaCUwQXN0dWRlbnRfY29uZmlnJTIwJTNEJTIwTW9iaWxlTmV0VjJDb25maWcoKSUwQXN0dWRlbnRfY29uZmlnLm51bV9sYWJlbHMlMjAlM0QlMjBudW1fbGFiZWxzJTBBc3R1ZGVudF9tb2RlbCUyMCUzRCUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihzdHVkZW50X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, MobileNetV2Config, MobileNetV2ForImageClassification

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;my-awesome-model&quot;</span>,
    num_train_epochs=<span class="hljs-number">30</span>,
    fp16=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{repo_name}</span>/logs&quot;</span>,
    logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    report_to=<span class="hljs-string">&quot;tensorboard&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_strategy=<span class="hljs-string">&quot;every_save&quot;</span>,
    hub_model_id=repo_name,
    )

num_labels = <span class="hljs-built_in">len</span>(processed_datasets[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;labels&quot;</span>].names)

<span class="hljs-comment"># initialize models</span>
teacher_model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>,
    num_labels=num_labels,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># training MobileNetV2 from scratch</span>
student_config = MobileNetV2Config()
student_config.num_labels = num_labels
student_model = MobileNetV2ForImageClassification(student_config)`,wrap:!1}}),k=new h({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMGFjYyUyMCUzRCUyMGFjY3VyYWN5LmNvbXB1dGUocmVmZXJlbmNlcyUzRGxhYmVscyUyQyUyMHByZWRpY3Rpb25zJTNEbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFjY3VyYWN5JTIyJTNBJTIwYWNjJTVCJTIyYWNjdXJhY3klMjIlNUQlN0Q=",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    acc = accuracy.compute(references=labels, predictions=np.argmax(predictions, axis=<span class="hljs-number">1</span>))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: acc[<span class="hljs-string">&quot;accuracy&quot;</span>]}`,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigpJTBBdHJhaW5lciUyMCUzRCUyMEltYWdlRGlzdGlsVHJhaW5lciglMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEc3R1ZGVudF9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRlYWNoZXJfbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdGVhY2hlcl9wcm9jZXNzb3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDUlMkMlMEElMjAlMjAlMjAlMjBsYW1iZGFfcGFyYW0lM0QwLjUlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

data_collator = DefaultDataCollator()
trainer = ImageDistilTrainer(
    student_model=student_model,
    teacher_model=teacher_model,
    training_args=training_args,
    train_dataset=processed_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=teacher_processor,
    compute_metrics=compute_metrics,
    temperature=<span class="hljs-number">5</span>,
    lambda_param=<span class="hljs-number">0.5</span>
)`,wrap:!1}}),A=new h({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),H=new h({props:{code:"dHJhaW5lci5ldmFsdWF0ZShwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0ZXN0JTIyJTVEKQ==",highlighted:'trainer.evaluate(processed_datasets[<span class="hljs-string">&quot;test&quot;</span>])',wrap:!1}}),F=new qe({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/knowledge_distillation_for_image_classification.md"}}),{c(){u=o("meta"),x=a(),Q=o("p"),S=a(),M(U.$$.fragment),q=a(),M(w.$$.fragment),L=a(),b=o("p"),b.innerHTML=Te,D=a(),J=o("p"),J.innerHTML=ge,K=a(),j=o("p"),j.textContent=Ce,P=a(),M(f.$$.fragment),O=a(),T=o("p"),T.innerHTML=Ze,ee=a(),g=o("p"),g.textContent=_e,le=a(),M(C.$$.fragment),te=a(),Z=o("p"),Z.innerHTML=We,se=a(),M(_.$$.fragment),ae=a(),W=o("p"),W.innerHTML=Ge,ne=a(),M(G.$$.fragment),oe=a(),R=o("p"),R.innerHTML=Re,ie=a(),M(I.$$.fragment),re=a(),V=o("p"),V.innerHTML=Ie,Me=a(),M(v.$$.fragment),ce=a(),X=o("p"),X.innerHTML=Ve,pe=a(),M(k.$$.fragment),de=a(),Y=o("p"),Y.innerHTML=ve,ye=a(),M(N.$$.fragment),me=a(),B=o("p"),B.textContent=Xe,he=a(),M(A.$$.fragment),ue=a(),z=o("p"),z.textContent=ke,Ue=a(),M(H.$$.fragment),we=a(),E=o("p"),E.innerHTML=Ye,be=a(),M(F.$$.fragment),Je=a(),$=o("p"),this.h()},l(e){const l=Qe("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),x=n(e),Q=i(e,"P",{}),Ne(Q).forEach(t),S=n(e),c(U.$$.fragment,e),q=n(e),c(w.$$.fragment,e),L=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-hls4jk"&&(b.innerHTML=Te),D=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1jgqwsa"&&(J.innerHTML=ge),K=n(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-eb5dox"&&(j.textContent=Ce),P=n(e),c(f.$$.fragment,e),O=n(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1mtygw2"&&(T.innerHTML=Ze),ee=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ti28ib"&&(g.textContent=_e),le=n(e),c(C.$$.fragment,e),te=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vnqg06"&&(Z.innerHTML=We),se=n(e),c(_.$$.fragment,e),ae=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1s0q0ij"&&(W.innerHTML=Ge),ne=n(e),c(G.$$.fragment,e),oe=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-18dqoen"&&(R.innerHTML=Re),ie=n(e),c(I.$$.fragment,e),re=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-169di0f"&&(V.innerHTML=Ie),Me=n(e),c(v.$$.fragment,e),ce=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lauups"&&(X.innerHTML=Ve),pe=n(e),c(k.$$.fragment,e),de=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-v7k90h"&&(Y.innerHTML=ve),ye=n(e),c(N.$$.fragment,e),me=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1914o93"&&(B.textContent=Xe),he=n(e),c(A.$$.fragment,e),ue=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ra6erz"&&(z.textContent=ke),Ue=n(e),c(H.$$.fragment,e),we=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-t8ooy5"&&(E.innerHTML=Ye),be=n(e),c(F.$$.fragment,e),Je=n(e),$=i(e,"P",{}),Ne($).forEach(t),this.h()},h(){Be(u,"name","hf:doc:metadata"),Be(u,"content",De)},m(e,l){$e(document.head,u),s(e,x,l),s(e,Q,l),s(e,S,l),p(U,e,l),s(e,q,l),p(w,e,l),s(e,L,l),s(e,b,l),s(e,D,l),s(e,J,l),s(e,K,l),s(e,j,l),s(e,P,l),p(f,e,l),s(e,O,l),s(e,T,l),s(e,ee,l),s(e,g,l),s(e,le,l),p(C,e,l),s(e,te,l),s(e,Z,l),s(e,se,l),p(_,e,l),s(e,ae,l),s(e,W,l),s(e,ne,l),p(G,e,l),s(e,oe,l),s(e,R,l),s(e,ie,l),p(I,e,l),s(e,re,l),s(e,V,l),s(e,Me,l),p(v,e,l),s(e,ce,l),s(e,X,l),s(e,pe,l),p(k,e,l),s(e,de,l),s(e,Y,l),s(e,ye,l),p(N,e,l),s(e,me,l),s(e,B,l),s(e,he,l),p(A,e,l),s(e,ue,l),s(e,z,l),s(e,Ue,l),p(H,e,l),s(e,we,l),s(e,E,l),s(e,be,l),p(F,e,l),s(e,Je,l),s(e,$,l),je=!0},p:ze,i(e){je||(d(U.$$.fragment,e),d(w.$$.fragment,e),d(f.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(G.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(F.$$.fragment,e),je=!0)},o(e){y(U.$$.fragment,e),y(w.$$.fragment,e),y(f.$$.fragment,e),y(C.$$.fragment,e),y(_.$$.fragment,e),y(G.$$.fragment,e),y(I.$$.fragment,e),y(v.$$.fragment,e),y(k.$$.fragment,e),y(N.$$.fragment,e),y(A.$$.fragment,e),y(H.$$.fragment,e),y(F.$$.fragment,e),je=!1},d(e){e&&(t(x),t(Q),t(S),t(q),t(L),t(b),t(D),t(J),t(K),t(j),t(P),t(O),t(T),t(ee),t(g),t(le),t(te),t(Z),t(se),t(ae),t(W),t(ne),t(oe),t(R),t(ie),t(re),t(V),t(Me),t(ce),t(X),t(pe),t(de),t(Y),t(ye),t(me),t(B),t(he),t(ue),t(z),t(Ue),t(we),t(E),t(be),t(Je),t($)),t(u),m(U,e),m(w,e),m(f,e),m(C,e),m(_,e),m(G,e),m(I,e),m(v,e),m(k,e),m(N,e),m(A,e),m(H,e),m(F,e)}}}const De='{"title":"Knowledge Distillation for Computer Vision","local":"knowledge-distillation-for-computer-vision","sections":[],"depth":1}';function Ke(fe){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Ee{constructor(u){super(),Fe(this,u,Ke,Le,Ae,{})}}export{al as component};
