import{s as vs,n as Fs,o as $s}from"../chunks/scheduler.18a86fab.js";import{S as Ws,i as Ns,g as i,s as a,r as m,A as zs,h as p,f as l,c as n,j as Zs,u as o,x as M,k as b,y as Xs,a as t,v as r,d as y,t as c,w as U}from"../chunks/index.98837b22.js";import{C as u}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as oe}from"../chunks/Heading.7e7e0c5b.js";import{E as Gs}from"../chunks/getInferenceSnippets.de10bc7d.js";function Ss(as){let h,re,Me,ye,f,ce,C,ns=`Mask generation is the task of generating semantically meaningful masks for an image.
This task is very similar to <a href="semantic_segmentation">image segmentation</a>, but many differences exist. Image segmentation models are trained on labeled datasets and are limited to the classes they have seen during training; they return a set of masks and corresponding classes, given an image.`,Ue,k,is="Mask generation models are trained on large amounts of data and operate in two modes.",ue,Q,ps=`<li>Prompting mode: In this mode, the model takes in an image and a prompt, where a prompt can be a 2D point location (XY coordinates) in the image within an object or a bounding box surrounding an object. In prompting mode, the model only returns the mask over the object
that the prompt is pointing out.</li> <li>Segment Everything mode: In segment everything, given an image, the model generates every mask in the image. To do so, a grid of points is generated and overlaid on the image for inference.</li>`,he,I,Ms='Mask generation task is supported by <a href="model_doc/sam">Segment Anything Model (SAM)</a>. It’s a powerful model that consists of a Vision Transformer-based image encoder, a prompt encoder, and a two-way transformer mask decoder. Images and prompts are encoded, and the decoder takes these embeddings and generates valid masks.',de,d,ms='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sam.png" alt="SAM Architecture"/>',Je,x,os=`SAM serves as a powerful foundation model for segmentation as it has large data coverage. It is trained on
<a href="https://ai.meta.com/datasets/segment-anything/" rel="nofollow">SA-1B</a>, a dataset with 1 million images and 1.1 billion masks.`,je,B,rs="In this guide, you will learn how to:",we,Z,ys="<li>Infer in segment everything mode with batching,</li> <li>Infer in point prompting mode,</li> <li>Infer in box prompting mode.</li>",Te,v,cs="First, let’s install <code>transformers</code>:",ge,F,be,$,fe,W,Us="The easiest way to infer mask generation models is to use the <code>mask-generation</code> pipeline.",Ce,N,ke,z,us="Let’s see the image.",Qe,X,Ie,J,hs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Example Image"/>',xe,G,ds="Let’s segment everything. <code>points-per-batch</code> enables parallel inference of points in segment everything mode. This enables faster inference, but consumes more memory. Moreover, SAM only enables batching over points and not the images. <code>pred_iou_thresh</code> is the IoU confidence threshold where only the masks above that certain threshold are returned.",Be,S,Ze,Y,Js="The <code>masks</code> looks like the following:",ve,_,Fe,A,js="We can visualize them like this:",$e,H,We,R,ws="Below is the original image in grayscale with colorful maps overlaid. Very impressive.",Ne,j,Ts='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee_segmented.png" alt="Visualized"/>',ze,E,Xe,V,Ge,L,gs=`You can also use the model without the pipeline. To do so, initialize the model and
the processor.`,Se,D,Ye,K,bs=`To do point prompting, pass the input point to the processor, then take the processor output
and pass it to the model for inference. To post-process the model output, pass the outputs and
<code>original_sizes</code> and <code>reshaped_input_sizes</code> we take from the processor’s initial output. We need to pass these
since the processor resizes the image, and the output needs to be extrapolated.`,_e,q,Ae,P,fs="We can visualize the three masks in the <code>masks</code> output.",He,O,Re,w,Cs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/masks.png" alt="Visualized"/>',Ee,ee,Ve,se,ks=`You can also do box prompting in a similar fashion to point prompting. You can simply pass the input box in the format of a list
<code>[x_min, y_min, x_max, y_max]</code> format along with the image to the <code>processor</code>. Take the processor output and directly pass it
to the model, then post-process the output again.`,Le,le,De,te,Qs="You can visualize the bounding box around the bee as shown below.",Ke,ae,qe,T,Is='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/bbox.png" alt="Visualized Bbox"/>',Pe,ne,xs="You can see the inference output below.",Oe,ie,es,g,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/box_inference.png" alt="Visualized Inference"/>',ss,pe,ls,me,ts;return f=new oe({props:{title:"Mask Generation",local:"mask-generation",headingTag:"h1"}}),F=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),$=new oe({props:{title:"Mask Generation Pipeline",local:"mask-generation-pipeline",headingTag:"h2"}}),N=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyJTBBbWFza19nZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRGNoZWNrcG9pbnQlMkMlMjB0YXNrJTNEJTIybWFzay1nZW5lcmF0aW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_generator = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;mask-generation&quot;</span>)`,wrap:!1}}),X=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),S=new u({props:{code:"bWFza3MlMjAlM0QlMjBtYXNrX2dlbmVyYXRvcihpbWFnZSUyQyUyMHBvaW50c19wZXJfYmF0Y2glM0QxMjglMkMlMjBwcmVkX2lvdV90aHJlc2glM0QwLjg4KQ==",highlighted:'masks = mask_generator(image, points_per_batch=<span class="hljs-number">128</span>, pred_iou_thresh=<span class="hljs-number">0.88</span>)',wrap:!1}}),_=new u({props:{code:"JTdCJ21hc2tzJyUzQSUyMCU1QmFycmF5KCU1QiU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCU1RCklMkMlMEElMjAlMjBhcnJheSglNUIlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEEnc2NvcmVzJyUzQSUyMHRlbnNvciglNUIwLjk5NzIlMkMlMjAwLjk5MTclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;masks&#x27;</span>: [array([[False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         ...,
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False]]),
  array([[False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         ...,
<span class="hljs-string">&#x27;scores&#x27;</span>: tensor([0.9972, 0.9917,
        ...,
}`,wrap:!1}}),H=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5pbXNob3coaW1hZ2UlMkMlMjBjbWFwJTNEJ2dyYXknKSUwQSUwQWZvciUyMGklMkMlMjBtYXNrJTIwaW4lMjBlbnVtZXJhdGUobWFza3MlNUIlMjJtYXNrcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBwbHQuaW1zaG93KG1hc2slMkMlMjBjbWFwJTNEJ3ZpcmlkaXMnJTJDJTIwYWxwaGElM0QwLjElMkMlMjB2bWluJTNEMCUyQyUyMHZtYXglM0QxKSUwQSUwQXBsdC5heGlzKCdvZmYnKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.imshow(image, cmap=<span class="hljs-string">&#x27;gray&#x27;</span>)

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(masks[<span class="hljs-string">&quot;masks&quot;</span>]):
    plt.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.1</span>, vmin=<span class="hljs-number">0</span>, vmax=<span class="hljs-number">1</span>)

plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
plt.show()`,wrap:!1}}),E=new oe({props:{title:"Model Inference",local:"model-inference",headingTag:"h2"}}),V=new oe({props:{title:"Point Prompting",local:"point-prompting",headingTag:"h3"}}),D=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTJDJTIwU2FtUHJvY2Vzc29yJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZS50ZXN0X3V0aWxzLnRlc3RpbmclMjBpbXBvcnQlMjBnZXRfYmFja2VuZCUwQSUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBZGV2aWNlJTJDJTIwXyUyQyUyMF8lMjAlM0QlMjBnZXRfYmFja2VuZCgpJTBBbW9kZWwlMjAlM0QlMjBTYW1Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWJhc2UlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBTYW1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend
<span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
device, _, _ = get_backend()
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),q=new u({props:{code:"aW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCMjU5MiUyQyUyMDE3MjglNUQlNUQlNUQlMjAlMjMlMjBwb2ludCUyMGxvY2F0aW9uJTIwb2YlMjB0aGUlMjBiZWUlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjBpbnB1dF9wb2ludHMlM0RpbnB1dF9wb2ludHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCkp",highlighted:`input_points = [[[<span class="hljs-number">2592</span>, <span class="hljs-number">1728</span>]]] <span class="hljs-comment"># point location of the bee</span>

inputs = processor(image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)
masks = processor.image_processor.post_process_masks(outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu())`,wrap:!1}}),O=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWZpZyUyQyUyMGF4ZXMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMSUyQyUyMDQlMkMlMjBmaWdzaXplJTNEKDE1JTJDJTIwNSkpJTBBJTBBYXhlcyU1QjAlNUQuaW1zaG93KGltYWdlKSUwQWF4ZXMlNUIwJTVELnNldF90aXRsZSgnT3JpZ2luYWwlMjBJbWFnZScpJTBBbWFza19saXN0JTIwJTNEJTIwJTVCbWFza3MlNUIwJTVEJTVCMCU1RCU1QjAlNUQubnVtcHkoKSUyQyUyMG1hc2tzJTVCMCU1RCU1QjAlNUQlNUIxJTVELm51bXB5KCklMkMlMjBtYXNrcyU1QjAlNUQlNUIwJTVEJTVCMiU1RC5udW1weSgpJTVEJTBBJTBBZm9yJTIwaSUyQyUyMG1hc2slMjBpbiUyMGVudW1lcmF0ZShtYXNrX2xpc3QlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpLmNvcHkoKSUwQSUwQSUyMCUyMCUyMCUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzAlNUQlMjAlM0QlMjBucC53aGVyZShtYXNrJTIwJTNEJTNEJTIwMSUyQyUyMDI1NSUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzAlNUQpJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMSU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMCUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzElNUQpJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMiU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMCUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzIlNUQpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwYXhlcyU1QmklNUQuaW1zaG93KG92ZXJsYXllZF9pbWFnZSklMEElMjAlMjAlMjAlMjBheGVzJTVCaSU1RC5zZXRfdGl0bGUoZidNYXNrJTIwJTdCaSU3RCcpJTBBZm9yJTIwYXglMjBpbiUyMGF4ZXMlM0ElMEElMjAlMjAlMjAlMjBheC5heGlzKCdvZmYnKSUwQSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

fig, axes = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">5</span>))

axes[<span class="hljs-number">0</span>].imshow(image)
axes[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&#x27;Original Image&#x27;</span>)
mask_list = [masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">1</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">2</span>].numpy()]

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(mask_list, start=<span class="hljs-number">1</span>):
    overlayed_image = np.array(image).copy()

    overlayed_image[:,:,<span class="hljs-number">0</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">255</span>, overlayed_image[:,:,<span class="hljs-number">0</span>])
    overlayed_image[:,:,<span class="hljs-number">1</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">1</span>])
    overlayed_image[:,:,<span class="hljs-number">2</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">2</span>])
    
    axes[i].imshow(overlayed_image)
    axes[i].set_title(<span class="hljs-string">f&#x27;Mask <span class="hljs-subst">{i}</span>&#x27;</span>)
<span class="hljs-keyword">for</span> ax <span class="hljs-keyword">in</span> axes:
    ax.axis(<span class="hljs-string">&#x27;off&#x27;</span>)

plt.show()`,wrap:!1}}),ee=new oe({props:{title:"Box Prompting",local:"box-prompting",headingTag:"h3"}}),le=new u({props:{code:"JTIzJTIwYm91bmRpbmclMjBib3glMjBhcm91bmQlMjB0aGUlMjBiZWUlMEFib3glMjAlM0QlMjAlNUIyMzUwJTJDJTIwMTYwMCUyQyUyMDI4NTAlMkMlMjAyMTAwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfYm94ZXMlM0QlNUIlNUIlNUJib3glNUQlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBJTIwJTIwJTIwJTIwKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFzayUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCklMEEpJTVCMCU1RCU1QjAlNUQlNUIwJTVELm51bXB5KCk=",highlighted:`<span class="hljs-comment"># bounding box around the bee</span>
box = [<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">2850</span>, <span class="hljs-number">2100</span>]

inputs = processor(
        image,
        input_boxes=[[[box]]],
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
    ).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

mask = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(),
    inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(),
    inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy()`,wrap:!1}}),ae=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5wYXRjaGVzJTIwYXMlMjBwYXRjaGVzJTBBJTBBZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEElMEFyZWN0YW5nbGUlMjAlM0QlMjBwYXRjaGVzLlJlY3RhbmdsZSgoMjM1MCUyQyUyMDE2MDApJTJDJTIwNTAwJTJDJTIwNTAwJTJDJTIwbGluZXdpZHRoJTNEMiUyQyUyMGVkZ2Vjb2xvciUzRCdyJyUyQyUyMGZhY2Vjb2xvciUzRCdub25lJyklMEFheC5hZGRfcGF0Y2gocmVjdGFuZ2xlKSUwQWF4LmF4aXMoJTIyb2ZmJTIyKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.patches <span class="hljs-keyword">as</span> patches

fig, ax = plt.subplots()
ax.imshow(image)

rectangle = patches.Rectangle((<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>), <span class="hljs-number">500</span>, <span class="hljs-number">500</span>, linewidth=<span class="hljs-number">2</span>, edgecolor=<span class="hljs-string">&#x27;r&#x27;</span>, facecolor=<span class="hljs-string">&#x27;none&#x27;</span>)
ax.add_patch(rectangle)
ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),ie=new u({props:{code:"ZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEFheC5pbXNob3cobWFzayUyQyUyMGNtYXAlM0QndmlyaWRpcyclMkMlMjBhbHBoYSUzRDAuNCklMEElMEFheC5heGlzKCUyMm9mZiUyMiklMEFwbHQuc2hvdygp",highlighted:`fig, ax = plt.subplots()
ax.imshow(image)
ax.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.4</span>)

ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),pe=new Gs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/mask_generation.md"}}),{c(){h=i("meta"),re=a(),Me=i("p"),ye=a(),m(f.$$.fragment),ce=a(),C=i("p"),C.innerHTML=ns,Ue=a(),k=i("p"),k.textContent=is,ue=a(),Q=i("ul"),Q.innerHTML=ps,he=a(),I=i("p"),I.innerHTML=Ms,de=a(),d=i("div"),d.innerHTML=ms,Je=a(),x=i("p"),x.innerHTML=os,je=a(),B=i("p"),B.textContent=rs,we=a(),Z=i("ul"),Z.innerHTML=ys,Te=a(),v=i("p"),v.innerHTML=cs,ge=a(),m(F.$$.fragment),be=a(),m($.$$.fragment),fe=a(),W=i("p"),W.innerHTML=Us,Ce=a(),m(N.$$.fragment),ke=a(),z=i("p"),z.textContent=us,Qe=a(),m(X.$$.fragment),Ie=a(),J=i("div"),J.innerHTML=hs,xe=a(),G=i("p"),G.innerHTML=ds,Be=a(),m(S.$$.fragment),Ze=a(),Y=i("p"),Y.innerHTML=Js,ve=a(),m(_.$$.fragment),Fe=a(),A=i("p"),A.textContent=js,$e=a(),m(H.$$.fragment),We=a(),R=i("p"),R.textContent=ws,Ne=a(),j=i("div"),j.innerHTML=Ts,ze=a(),m(E.$$.fragment),Xe=a(),m(V.$$.fragment),Ge=a(),L=i("p"),L.textContent=gs,Se=a(),m(D.$$.fragment),Ye=a(),K=i("p"),K.innerHTML=bs,_e=a(),m(q.$$.fragment),Ae=a(),P=i("p"),P.innerHTML=fs,He=a(),m(O.$$.fragment),Re=a(),w=i("div"),w.innerHTML=Cs,Ee=a(),m(ee.$$.fragment),Ve=a(),se=i("p"),se.innerHTML=ks,Le=a(),m(le.$$.fragment),De=a(),te=i("p"),te.textContent=Qs,Ke=a(),m(ae.$$.fragment),qe=a(),T=i("div"),T.innerHTML=Is,Pe=a(),ne=i("p"),ne.textContent=xs,Oe=a(),m(ie.$$.fragment),es=a(),g=i("div"),g.innerHTML=Bs,ss=a(),m(pe.$$.fragment),ls=a(),me=i("p"),this.h()},l(e){const s=zs("svelte-u9bgzb",document.head);h=p(s,"META",{name:!0,content:!0}),s.forEach(l),re=n(e),Me=p(e,"P",{}),Zs(Me).forEach(l),ye=n(e),o(f.$$.fragment,e),ce=n(e),C=p(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-11gpkf1"&&(C.innerHTML=ns),Ue=n(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1efgayb"&&(k.textContent=is),ue=n(e),Q=p(e,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-110gnfy"&&(Q.innerHTML=ps),he=n(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-grokwa"&&(I.innerHTML=Ms),de=n(e),d=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-18bgtyc"&&(d.innerHTML=ms),Je=n(e),x=p(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-siwu7f"&&(x.innerHTML=os),je=n(e),B=p(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1xy9go1"&&(B.textContent=rs),we=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),M(Z)!=="svelte-1xdcdcm"&&(Z.innerHTML=ys),Te=n(e),v=p(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1qvzz2d"&&(v.innerHTML=cs),ge=n(e),o(F.$$.fragment,e),be=n(e),o($.$$.fragment,e),fe=n(e),W=p(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-hy99c4"&&(W.innerHTML=Us),Ce=n(e),o(N.$$.fragment,e),ke=n(e),z=p(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-13rxk6q"&&(z.textContent=us),Qe=n(e),o(X.$$.fragment,e),Ie=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-5ac7qo"&&(J.innerHTML=hs),xe=n(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-xsc4t1"&&(G.innerHTML=ds),Be=n(e),o(S.$$.fragment,e),Ze=n(e),Y=p(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-rg5py"&&(Y.innerHTML=Js),ve=n(e),o(_.$$.fragment,e),Fe=n(e),A=p(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1kbs52p"&&(A.textContent=js),$e=n(e),o(H.$$.fragment,e),We=n(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-b8wd3m"&&(R.textContent=ws),Ne=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-1xv3qg"&&(j.innerHTML=Ts),ze=n(e),o(E.$$.fragment,e),Xe=n(e),o(V.$$.fragment,e),Ge=n(e),L=p(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-kmstl8"&&(L.textContent=gs),Se=n(e),o(D.$$.fragment,e),Ye=n(e),K=p(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-kaodbx"&&(K.innerHTML=bs),_e=n(e),o(q.$$.fragment,e),Ae=n(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-zoqnl5"&&(P.innerHTML=fs),He=n(e),o(O.$$.fragment,e),Re=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-od5m1y"&&(w.innerHTML=Cs),Ee=n(e),o(ee.$$.fragment,e),Ve=n(e),se=p(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1hby767"&&(se.innerHTML=ks),Le=n(e),o(le.$$.fragment,e),De=n(e),te=p(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-n8en77"&&(te.textContent=Qs),Ke=n(e),o(ae.$$.fragment,e),qe=n(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-12t8f97"&&(T.innerHTML=Is),Pe=n(e),ne=p(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-mexiag"&&(ne.textContent=xs),Oe=n(e),o(ie.$$.fragment,e),es=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-1inger9"&&(g.innerHTML=Bs),ss=n(e),o(pe.$$.fragment,e),ls=n(e),me=p(e,"P",{}),Zs(me).forEach(l),this.h()},h(){b(h,"name","hf:doc:metadata"),b(h,"content",Ys),b(d,"class","flex justify-center"),b(J,"class","flex justify-center"),b(j,"class","flex justify-center"),b(w,"class","flex justify-center"),b(T,"class","flex justify-center"),b(g,"class","flex justify-center")},m(e,s){Xs(document.head,h),t(e,re,s),t(e,Me,s),t(e,ye,s),r(f,e,s),t(e,ce,s),t(e,C,s),t(e,Ue,s),t(e,k,s),t(e,ue,s),t(e,Q,s),t(e,he,s),t(e,I,s),t(e,de,s),t(e,d,s),t(e,Je,s),t(e,x,s),t(e,je,s),t(e,B,s),t(e,we,s),t(e,Z,s),t(e,Te,s),t(e,v,s),t(e,ge,s),r(F,e,s),t(e,be,s),r($,e,s),t(e,fe,s),t(e,W,s),t(e,Ce,s),r(N,e,s),t(e,ke,s),t(e,z,s),t(e,Qe,s),r(X,e,s),t(e,Ie,s),t(e,J,s),t(e,xe,s),t(e,G,s),t(e,Be,s),r(S,e,s),t(e,Ze,s),t(e,Y,s),t(e,ve,s),r(_,e,s),t(e,Fe,s),t(e,A,s),t(e,$e,s),r(H,e,s),t(e,We,s),t(e,R,s),t(e,Ne,s),t(e,j,s),t(e,ze,s),r(E,e,s),t(e,Xe,s),r(V,e,s),t(e,Ge,s),t(e,L,s),t(e,Se,s),r(D,e,s),t(e,Ye,s),t(e,K,s),t(e,_e,s),r(q,e,s),t(e,Ae,s),t(e,P,s),t(e,He,s),r(O,e,s),t(e,Re,s),t(e,w,s),t(e,Ee,s),r(ee,e,s),t(e,Ve,s),t(e,se,s),t(e,Le,s),r(le,e,s),t(e,De,s),t(e,te,s),t(e,Ke,s),r(ae,e,s),t(e,qe,s),t(e,T,s),t(e,Pe,s),t(e,ne,s),t(e,Oe,s),r(ie,e,s),t(e,es,s),t(e,g,s),t(e,ss,s),r(pe,e,s),t(e,ls,s),t(e,me,s),ts=!0},p:Fs,i(e){ts||(y(f.$$.fragment,e),y(F.$$.fragment,e),y($.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y(S.$$.fragment,e),y(_.$$.fragment,e),y(H.$$.fragment,e),y(E.$$.fragment,e),y(V.$$.fragment,e),y(D.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),ts=!0)},o(e){c(f.$$.fragment,e),c(F.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(X.$$.fragment,e),c(S.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(V.$$.fragment,e),c(D.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),ts=!1},d(e){e&&(l(re),l(Me),l(ye),l(ce),l(C),l(Ue),l(k),l(ue),l(Q),l(he),l(I),l(de),l(d),l(Je),l(x),l(je),l(B),l(we),l(Z),l(Te),l(v),l(ge),l(be),l(fe),l(W),l(Ce),l(ke),l(z),l(Qe),l(Ie),l(J),l(xe),l(G),l(Be),l(Ze),l(Y),l(ve),l(Fe),l(A),l($e),l(We),l(R),l(Ne),l(j),l(ze),l(Xe),l(Ge),l(L),l(Se),l(Ye),l(K),l(_e),l(Ae),l(P),l(He),l(Re),l(w),l(Ee),l(Ve),l(se),l(Le),l(De),l(te),l(Ke),l(qe),l(T),l(Pe),l(ne),l(Oe),l(es),l(g),l(ss),l(ls),l(me)),l(h),U(f,e),U(F,e),U($,e),U(N,e),U(X,e),U(S,e),U(_,e),U(H,e),U(E,e),U(V,e),U(D,e),U(q,e),U(O,e),U(ee,e),U(le,e),U(ae,e),U(ie,e),U(pe,e)}}}const Ys='{"title":"Mask Generation","local":"mask-generation","sections":[{"title":"Mask Generation Pipeline","local":"mask-generation-pipeline","sections":[],"depth":2},{"title":"Model Inference","local":"model-inference","sections":[{"title":"Point Prompting","local":"point-prompting","sections":[],"depth":3},{"title":"Box Prompting","local":"box-prompting","sections":[],"depth":3}],"depth":2}],"depth":1}';function _s(as){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends Ws{constructor(h){super(),Ns(this,h,_s,Ss,vs,{})}}export{Ls as component};
