import{s as Ys,n as Fs,o as Ss}from"../chunks/scheduler.18a86fab.js";import{S as qs,i as Ps,g as i,s as a,r,A as Ls,h as p,f as l,c as n,j as Qs,u as c,x as o,k as fe,y as Ds,a as t,v as m,d,t as M,w as u}from"../chunks/index.98837b22.js";import{C as f}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as de}from"../chunks/Heading.7e7e0c5b.js";import{E as Ks}from"../chunks/getInferenceSnippets.de10bc7d.js";function Os(us){let y,ye,Me,he,J,we,j,fs='Make <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> your own by subclassing it and implementing a few methods. Share the code with the community on the <a href="https://hf.co" rel="nofollow">Hub</a> and register the pipeline with Transformers so that everyone can quickly and easily use it.',Te,b,ys="This guide will walk you through the process of adding a new pipeline to Transformers.",Je,U,je,I,hs='At a minimum, you only need to provide <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> with an appropriate input for a task. This is also where you should begin when designing your pipeline.',be,_,ws='Decide what input types <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> can accept. It can be strings, raw bytes, dictionaries, and so on. Try to keep the inputs in pure Python where possible because it’s more compatible. Next, decide on the output <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> should return. Again, keeping the output in Python is the simplest and best option because it’s easier to work with.',Ue,B,Ts='Keeping the inputs and outputs simple, and ideally JSON-serializable, makes it easier for users to run your <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> without needing to learn new object types. It’s also common to support many different input types for even greater ease of use. For example, making an audio file acceptable from a filename, URL, or raw bytes gives the user more flexibility in how they provide the audio data.',Ie,g,_e,k,Js='With an input and output decided, you can start implementing <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>. Your pipeline should inherit from the base <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> class and include 4 methods.',Be,C,ge,Z,js="<li><code>preprocess</code> takes the inputs and transforms them into the appropriate input format for the model.</li>",ke,G,Ce,h,bs="<li><code>_forward</code> shouldn’t be called directly. <code>forward</code> is the preferred method because it includes safeguards to make sure everything works correctly on the expected device. Anything linked to the model belongs in <code>_forward</code> and everything else belongs in either <code>preprocess</code> or <code>postprocess</code>.</li>",Ze,$,Ge,w,Us="<li><code>postprocess</code> generates the final output from the models output in <code>_forward</code>.</li>",$e,V,Ve,T,Is='<li><code>_sanitize_parameters</code> lets users pass additional parameters to <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>. This could be during initialization or when <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> is called. <code>_sanitize_parameters</code> returns 3 dicts of additional keyword arguments that are passed directly to <code>preprocess</code>, <code>_forward</code>, and <code>postprocess</code>. Don’t add anything if a user didn’t call the pipeline with extra parameters. This keeps the default arguments in the function definition which is always more natural.</li>',We,W,_s="For example, add a <code>top_k</code> parameter in <code>postprocess</code> to return the top 5 most likely classes. Then in <code>_sanitize_parameters</code>, check if the user passed in <code>top_k</code> and add it to <code>postprocess_kwargs</code>.",ve,v,xe,x,Bs="Now the pipeline can return the top most likely labels if a user chooses to.",Ae,A,Xe,X,He,H,gs="Register the new task your pipeline supports in the <code>PIPELINE_REGISTRY</code>. The registry defines:",Ne,N,ks="<li>the machine learning framework the pipeline supports with either <code>pt_model</code> or <code>tf_model</code> (add both to ensure it works with either frameworks)</li> <li>a default model which should come from a specific revision (branch, or commit hash) where the model works as expected with <code>default</code></li> <li>the expected input with <code>type</code></li>",ze,z,Re,R,Ee,E,Cs='Share your pipeline with the community on the <a href="https://hf.co" rel="nofollow">Hub</a> or you can add it directly to Transformers.',Qe,Q,Zs='It’s faster to upload your pipeline code to the Hub because it doesn’t require a review from the Transformers team. Adding the pipeline to Transformers may be slower because it requires a review and you need to add tests to ensure your <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> works.',Ye,Y,Fe,F,Gs="Add your pipeline code to the Hub in a Python file.",Se,S,$s="For example, a custom pipeline for sentence pair classification might look like the following code below. The implementation works for PyTorch and TensorFlow models.",qe,q,Pe,P,Vs="Save the code in a file named <code>pair_classification.py</code>, and import and register it as shown below.",Le,L,De,D,Ws='The <a href="https://github.com/huggingface/transformers/blob/9feae5fb0164e89d4998e5776897c16f7330d3df/src/transformers/pipelines/base.py#L1387" rel="nofollow">register_pipeline</a> function registers the pipeline details (task type, pipeline class, supported backends) to a models <code>config.json</code> file.',Ke,K,Oe,O,vs='Call <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub. The Python file containing the code is copied to the Hub, and the pipelines model and tokenizer are also saved and pushed to the Hub. Your pipeline should now be available on the Hub under your namespace.',es,ee,ss,se,xs="To use the pipeline, add <code>trust_remote_code=True</code> when loading the pipeline.",ls,le,ts,te,as,ae,As="Adding a custom pipeline to Transformers requires adding tests to make sure everything works as expected, and requesting a review from the Transformers team.",ns,ne,Xs='Add your pipeline code as a new module to the <a href="https://github.com/huggingface/transformers/tree/main/src/transformers/pipelines" rel="nofollow">pipelines</a> submodule, and add it to the list of tasks defined in <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/__init__.py" rel="nofollow">pipelines/<strong>init</strong>.py</a>.',is,ie,Hs='Next, add a new test for the pipeline in <a href="https://github.com/huggingface/transformers/tree/main/tests/pipelines" rel="nofollow">transformers/tests/pipelines</a>. You can look at the other tests for examples of how to test your pipeline.',ps,pe,Ns='The <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L186" rel="nofollow">run_pipeline_test</a> function should be very generic and run on the models defined in <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L48" rel="nofollow">model_mapping</a> and <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L49" rel="nofollow">tf_model_mapping</a>. This is important for testing future compatibility with new models.',os,oe,zs='You’ll also notice <code>ANY</code> is used throughout the <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L186" rel="nofollow">run_pipeline_test</a> function. The models are random, so you can’t check the actual values. Using <code>ANY</code> allows the test to match the output of the pipeline type instead.',rs,re,Rs="Finally, you should also implement the following 4 tests.",cs,ce,Es='<li><a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L59" rel="nofollow">test_small_model_pt</a> and <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_text_classification.py#L150" rel="nofollow">test_small_model_tf</a>, use a small model for these pipelines to make sure they return the correct outputs. The results don’t have to make sense. Each pipeline should return the same result.</li> <li><a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_zero_shot_image_classification.py#L187" rel="nofollow">test_large_model_pt</a> nad <a href="https://github.com/huggingface/transformers/blob/db70426854fe7850f2c5834d633aff637f14772e/tests/pipelines/test_pipelines_zero_shot_image_classification.py#L220" rel="nofollow">test_large_model_tf</a>, use a realistic model for these pipelines to make sure they return meaningful results. These tests are slow and should be marked as slow.</li>',ms,me,ds,ue,Ms;return J=new de({props:{title:"Adding a new pipeline",local:"adding-a-new-pipeline",headingTag:"h1"}}),U=new de({props:{title:"Design choices",local:"design-choices",headingTag:"h2"}}),g=new de({props:{title:"Create a pipeline",local:"create-a-pipeline",headingTag:"h2"}}),C=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMEElMjAlMjAlMjAlMjBkZWYlMjBwcmVwcm9jZXNzKHNlbGYlMkMlMjBpbnB1dHMlMkMlMjBhcmdzJTNEMiklM0ElMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfZm9yd2FyZChzZWxmJTJDJTIwbW9kZWxfaW5wdXRzKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHBvc3Rwcm9jZXNzKHNlbGYlMkMlMjBtb2RlbF9vdXRwdXRzKSUzQQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, args=<span class="hljs-number">2</span></span>):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):`,wrap:!1}}),G=new f({props:{code:"ZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
    model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}`,wrap:!1}}),$=new f({props:{code:"ZGVmJTIwX2ZvcndhcmQoc2VsZiUyQyUyMG1vZGVsX2lucHV0cyklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwc2VsZi5tb2RlbCgqKm1vZGVsX2lucHV0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
    outputs = self.model(**model_inputs)
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),V=new f({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),v=new f({props:{code:"ZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),A=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSglMjJteS10YXNrJTIyKSUwQSUyMyUyMHJldHVybnMlMjAzJTIwbW9zdCUyMGxpa2VseSUyMGxhYmVscyUwQXBpcGVsaW5lKCUyMlRoaXMlMjBpcyUyMHRoZSUyMGJlc3QlMjBtZWFsJTIwSSd2ZSUyMGV2ZXIlMjBoYWQlMjIlMkMlMjB0b3BfayUzRDMpJTBBJTIzJTIwcmV0dXJucyUyMDUlMjBtb3N0JTIwbGlrZWx5JTIwbGFiZWxzJTIwYnklMjBkZWZhdWx0JTBBcGlwZWxpbmUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVzdCUyMG1lYWwlMjBJJ3ZlJTIwZXZlciUyMGhhZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(<span class="hljs-string">&quot;my-task&quot;</span>)
<span class="hljs-comment"># returns 3 most likely labels</span>
pipeline(<span class="hljs-string">&quot;This is the best meal I&#x27;ve ever had&quot;</span>, top_k=<span class="hljs-number">3</span>)
<span class="hljs-comment"># returns 5 most likely labels by default</span>
pipeline(<span class="hljs-string">&quot;This is the best meal I&#x27;ve ever had&quot;</span>)`,wrap:!1}}),X=new de({props:{title:"Register a pipeline",local:"register-a-pipeline",headingTag:"h2"}}),z=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBUElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjB0Zl9tb2RlbCUzRFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHQlM0QlN0IlMjJwdCUyMiUzQSUyMCglMjJ1c2VyJTJGYXdlc29tZS1tb2RlbCUyMiUyQyUyMCUyMmJyYW5jaC1uYW1lJTIyKSU3RCUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJ0ZXh0JTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome-model&quot;</span>, <span class="hljs-string">&quot;branch-name&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,
)`,wrap:!1}}),R=new de({props:{title:"Share your pipeline",local:"share-your-pipeline",headingTag:"h2"}}),Y=new de({props:{title:"Upload to the Hub",local:"upload-to-the-hub",headingTag:"h3"}}),q=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),L=new f({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),K=new f({props:{code:"JTIwJTIwJTIyY3VzdG9tX3BpcGVsaW5lcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJpbXBsJTIyJTNBJTIwJTIycGFpcl9jbGFzc2lmaWNhdGlvbi5QYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnB0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnRmJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJD",highlighted:`  <span class="hljs-attr">&quot;custom_pipelines&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;pair-classification&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;impl&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pair_classification.PairClassificationPipeline&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;pt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;AutoModelForSequenceClassification&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;tf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;TFAutoModelForSequenceClassification&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),ee=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycGFpci1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc2d1Z2dlciUyRmZpbmV0dW5lZC1iZXJ0LW1ycGMlMjIpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIycGFpci1jbGFzc2lmaWNhdGlvbi1waXBlbGluZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(task=<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)
pipeline.push_to_hub(<span class="hljs-string">&quot;pair-classification-pipeline&quot;</span>)`,wrap:!1}}),le=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycGFpci1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(task=<span class="hljs-string">&quot;pair-classification&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),te=new de({props:{title:"Add to Transformers",local:"add-to-transformers",headingTag:"h3"}}),me=new Ks({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/add_new_pipeline.md"}}),{c(){y=i("meta"),ye=a(),Me=i("p"),he=a(),r(J.$$.fragment),we=a(),j=i("p"),j.innerHTML=fs,Te=a(),b=i("p"),b.textContent=ys,Je=a(),r(U.$$.fragment),je=a(),I=i("p"),I.innerHTML=hs,be=a(),_=i("p"),_.innerHTML=ws,Ue=a(),B=i("p"),B.innerHTML=Ts,Ie=a(),r(g.$$.fragment),_e=a(),k=i("p"),k.innerHTML=Js,Be=a(),r(C.$$.fragment),ge=a(),Z=i("ol"),Z.innerHTML=js,ke=a(),r(G.$$.fragment),Ce=a(),h=i("ol"),h.innerHTML=bs,Ze=a(),r($.$$.fragment),Ge=a(),w=i("ol"),w.innerHTML=Us,$e=a(),r(V.$$.fragment),Ve=a(),T=i("ol"),T.innerHTML=Is,We=a(),W=i("p"),W.innerHTML=_s,ve=a(),r(v.$$.fragment),xe=a(),x=i("p"),x.textContent=Bs,Ae=a(),r(A.$$.fragment),Xe=a(),r(X.$$.fragment),He=a(),H=i("p"),H.innerHTML=gs,Ne=a(),N=i("ul"),N.innerHTML=ks,ze=a(),r(z.$$.fragment),Re=a(),r(R.$$.fragment),Ee=a(),E=i("p"),E.innerHTML=Cs,Qe=a(),Q=i("p"),Q.innerHTML=Zs,Ye=a(),r(Y.$$.fragment),Fe=a(),F=i("p"),F.textContent=Gs,Se=a(),S=i("p"),S.textContent=$s,qe=a(),r(q.$$.fragment),Pe=a(),P=i("p"),P.innerHTML=Vs,Le=a(),r(L.$$.fragment),De=a(),D=i("p"),D.innerHTML=Ws,Ke=a(),r(K.$$.fragment),Oe=a(),O=i("p"),O.innerHTML=vs,es=a(),r(ee.$$.fragment),ss=a(),se=i("p"),se.innerHTML=xs,ls=a(),r(le.$$.fragment),ts=a(),r(te.$$.fragment),as=a(),ae=i("p"),ae.textContent=As,ns=a(),ne=i("p"),ne.innerHTML=Xs,is=a(),ie=i("p"),ie.innerHTML=Hs,ps=a(),pe=i("p"),pe.innerHTML=Ns,os=a(),oe=i("p"),oe.innerHTML=zs,rs=a(),re=i("p"),re.textContent=Rs,cs=a(),ce=i("ol"),ce.innerHTML=Es,ms=a(),r(me.$$.fragment),ds=a(),ue=i("p"),this.h()},l(e){const s=Ls("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(l),ye=n(e),Me=p(e,"P",{}),Qs(Me).forEach(l),he=n(e),c(J.$$.fragment,e),we=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-zh8dzx"&&(j.innerHTML=fs),Te=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1qih3n5"&&(b.textContent=ys),Je=n(e),c(U.$$.fragment,e),je=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-82znr8"&&(I.innerHTML=hs),be=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1uu89pl"&&(_.innerHTML=ws),Ue=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-bu86g9"&&(B.innerHTML=Ts),Ie=n(e),c(g.$$.fragment,e),_e=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1347odr"&&(k.innerHTML=Js),Be=n(e),c(C.$$.fragment,e),ge=n(e),Z=p(e,"OL",{"data-svelte-h":!0}),o(Z)!=="svelte-ls3j8c"&&(Z.innerHTML=js),ke=n(e),c(G.$$.fragment,e),Ce=n(e),h=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(h)!=="svelte-13h6esa"&&(h.innerHTML=bs),Ze=n(e),c($.$$.fragment,e),Ge=n(e),w=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(w)!=="svelte-mkxo99"&&(w.innerHTML=Us),$e=n(e),c(V.$$.fragment,e),Ve=n(e),T=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(T)!=="svelte-83wwtd"&&(T.innerHTML=Is),We=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-v5ycok"&&(W.innerHTML=_s),ve=n(e),c(v.$$.fragment,e),xe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-14yp2qx"&&(x.textContent=Bs),Ae=n(e),c(A.$$.fragment,e),Xe=n(e),c(X.$$.fragment,e),He=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-r2irul"&&(H.innerHTML=gs),Ne=n(e),N=p(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-153a938"&&(N.innerHTML=ks),ze=n(e),c(z.$$.fragment,e),Re=n(e),c(R.$$.fragment,e),Ee=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-dw693k"&&(E.innerHTML=Cs),Qe=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-rw26s4"&&(Q.innerHTML=Zs),Ye=n(e),c(Y.$$.fragment,e),Fe=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-18lz264"&&(F.textContent=Gs),Se=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1h8b4z3"&&(S.textContent=$s),qe=n(e),c(q.$$.fragment,e),Pe=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-95yu2g"&&(P.innerHTML=Vs),Le=n(e),c(L.$$.fragment,e),De=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-14qyyu6"&&(D.innerHTML=Ws),Ke=n(e),c(K.$$.fragment,e),Oe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-f45kde"&&(O.innerHTML=vs),es=n(e),c(ee.$$.fragment,e),ss=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-18tixm2"&&(se.innerHTML=xs),ls=n(e),c(le.$$.fragment,e),ts=n(e),c(te.$$.fragment,e),as=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-z2ovgw"&&(ae.textContent=As),ns=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-101anii"&&(ne.innerHTML=Xs),is=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1lm54uv"&&(ie.innerHTML=Hs),ps=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-9nbw2n"&&(pe.innerHTML=Ns),os=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1cmkq36"&&(oe.innerHTML=zs),rs=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-93pg6i"&&(re.textContent=Rs),cs=n(e),ce=p(e,"OL",{"data-svelte-h":!0}),o(ce)!=="svelte-1o915mr"&&(ce.innerHTML=Es),ms=n(e),c(me.$$.fragment,e),ds=n(e),ue=p(e,"P",{}),Qs(ue).forEach(l),this.h()},h(){fe(y,"name","hf:doc:metadata"),fe(y,"content",el),fe(h,"start","2"),fe(w,"start","3"),fe(T,"start","4")},m(e,s){Ds(document.head,y),t(e,ye,s),t(e,Me,s),t(e,he,s),m(J,e,s),t(e,we,s),t(e,j,s),t(e,Te,s),t(e,b,s),t(e,Je,s),m(U,e,s),t(e,je,s),t(e,I,s),t(e,be,s),t(e,_,s),t(e,Ue,s),t(e,B,s),t(e,Ie,s),m(g,e,s),t(e,_e,s),t(e,k,s),t(e,Be,s),m(C,e,s),t(e,ge,s),t(e,Z,s),t(e,ke,s),m(G,e,s),t(e,Ce,s),t(e,h,s),t(e,Ze,s),m($,e,s),t(e,Ge,s),t(e,w,s),t(e,$e,s),m(V,e,s),t(e,Ve,s),t(e,T,s),t(e,We,s),t(e,W,s),t(e,ve,s),m(v,e,s),t(e,xe,s),t(e,x,s),t(e,Ae,s),m(A,e,s),t(e,Xe,s),m(X,e,s),t(e,He,s),t(e,H,s),t(e,Ne,s),t(e,N,s),t(e,ze,s),m(z,e,s),t(e,Re,s),m(R,e,s),t(e,Ee,s),t(e,E,s),t(e,Qe,s),t(e,Q,s),t(e,Ye,s),m(Y,e,s),t(e,Fe,s),t(e,F,s),t(e,Se,s),t(e,S,s),t(e,qe,s),m(q,e,s),t(e,Pe,s),t(e,P,s),t(e,Le,s),m(L,e,s),t(e,De,s),t(e,D,s),t(e,Ke,s),m(K,e,s),t(e,Oe,s),t(e,O,s),t(e,es,s),m(ee,e,s),t(e,ss,s),t(e,se,s),t(e,ls,s),m(le,e,s),t(e,ts,s),m(te,e,s),t(e,as,s),t(e,ae,s),t(e,ns,s),t(e,ne,s),t(e,is,s),t(e,ie,s),t(e,ps,s),t(e,pe,s),t(e,os,s),t(e,oe,s),t(e,rs,s),t(e,re,s),t(e,cs,s),t(e,ce,s),t(e,ms,s),m(me,e,s),t(e,ds,s),t(e,ue,s),Ms=!0},p:Fs,i(e){Ms||(d(J.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(V.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(me.$$.fragment,e),Ms=!0)},o(e){M(J.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(C.$$.fragment,e),M(G.$$.fragment,e),M($.$$.fragment,e),M(V.$$.fragment,e),M(v.$$.fragment,e),M(A.$$.fragment,e),M(X.$$.fragment,e),M(z.$$.fragment,e),M(R.$$.fragment,e),M(Y.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(te.$$.fragment,e),M(me.$$.fragment,e),Ms=!1},d(e){e&&(l(ye),l(Me),l(he),l(we),l(j),l(Te),l(b),l(Je),l(je),l(I),l(be),l(_),l(Ue),l(B),l(Ie),l(_e),l(k),l(Be),l(ge),l(Z),l(ke),l(Ce),l(h),l(Ze),l(Ge),l(w),l($e),l(Ve),l(T),l(We),l(W),l(ve),l(xe),l(x),l(Ae),l(Xe),l(He),l(H),l(Ne),l(N),l(ze),l(Re),l(Ee),l(E),l(Qe),l(Q),l(Ye),l(Fe),l(F),l(Se),l(S),l(qe),l(Pe),l(P),l(Le),l(De),l(D),l(Ke),l(Oe),l(O),l(es),l(ss),l(se),l(ls),l(ts),l(as),l(ae),l(ns),l(ne),l(is),l(ie),l(ps),l(pe),l(os),l(oe),l(rs),l(re),l(cs),l(ce),l(ms),l(ds),l(ue)),l(y),u(J,e),u(U,e),u(g,e),u(C,e),u(G,e),u($,e),u(V,e),u(v,e),u(A,e),u(X,e),u(z,e),u(R,e),u(Y,e),u(q,e),u(L,e),u(K,e),u(ee,e),u(le,e),u(te,e),u(me,e)}}}const el='{"title":"Adding a new pipeline","local":"adding-a-new-pipeline","sections":[{"title":"Design choices","local":"design-choices","sections":[],"depth":2},{"title":"Create a pipeline","local":"create-a-pipeline","sections":[],"depth":2},{"title":"Register a pipeline","local":"register-a-pipeline","sections":[],"depth":2},{"title":"Share your pipeline","local":"share-your-pipeline","sections":[{"title":"Upload to the Hub","local":"upload-to-the-hub","sections":[],"depth":3},{"title":"Add to Transformers","local":"add-to-transformers","sections":[],"depth":3}],"depth":2}],"depth":1}';function sl(us){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends qs{constructor(y){super(),Ps(this,y,sl,Os,Ys,{})}}export{pl as component};
