import{s as In,o as xn,n as Zn}from"../chunks/scheduler.18a86fab.js";import{S as vn,i as Vn,g as p,s as l,r,A as _n,h as i,f as s,c as n,j as kn,u as c,x as o,k as At,y as Gn,a,v as h,d as m,t as M,w as d}from"../chunks/index.98837b22.js";import{T as Bn}from"../chunks/Tip.77304350.js";import{C as y}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as Wn}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as b}from"../chunks/Heading.7e7e0c5b.js";import{E as Rn}from"../chunks/getInferenceSnippets.de10bc7d.js";function Xn(St){let j,v="To follow this guide you will need a GPU. If you’re working in a notebook, run the following line to check if a GPU is available:",U,w,J,T,C="or alternatively for AMD GPUs:",$,g,V;return w=new y({props:{code:"IW52aWRpYS1zbWk=",highlighted:"!nvidia-smi",wrap:!1}}),g=new y({props:{code:"IXJvY20tc21p",highlighted:"!rocm-smi",wrap:!1}}),{c(){j=p("p"),j.textContent=v,U=l(),r(w.$$.fragment),J=l(),T=p("p"),T.textContent=C,$=l(),r(g.$$.fragment)},l(u){j=i(u,"P",{"data-svelte-h":!0}),o(j)!=="svelte-gf6llt"&&(j.textContent=v),U=n(u),c(w.$$.fragment,u),J=n(u),T=i(u,"P",{"data-svelte-h":!0}),o(T)!=="svelte-p2429"&&(T.textContent=C),$=n(u),c(g.$$.fragment,u)},m(u,f){a(u,j,f),a(u,U,f),h(w,u,f),a(u,J,f),a(u,T,f),a(u,$,f),h(g,u,f),V=!0},p:Zn,i(u){V||(m(w.$$.fragment,u),m(g.$$.fragment,u),V=!0)},o(u){M(w.$$.fragment,u),M(g.$$.fragment,u),V=!1},d(u){u&&(s(j),s(U),s(J),s(T),s($)),d(w,u),d(g,u)}}}function Yn(St){let j,v,U,w,J,T,C,$,g,V=`Text-to-speech (TTS) is the task of creating natural-sounding speech from text, where the speech can be generated in multiple
languages and for multiple speakers. Several text-to-speech models are currently available in 🤗 Transformers, such as
<a href="../model_doc/bark">Bark</a>, <a href="../model_doc/mms">MMS</a>, <a href="../model_doc/vits">VITS</a> and <a href="../model_doc/speecht5">SpeechT5</a>.`,u,f,ml=`You can easily generate audio using the <code>&quot;text-to-audio&quot;</code> pipeline (or its alias - <code>&quot;text-to-speech&quot;</code>). Some models, like Bark,
can also be conditioned to generate non-verbal communications such as laughing, sighing and crying, or even add music.
Here’s an example of how you would use the <code>&quot;text-to-speech&quot;</code> pipeline with Bark:`,Et,_,Pt,G,Ml="Here’s a code snippet you can use to listen to the resulting audio in a notebook:",Lt,B,Dt,W,dl=`For more examples on what Bark and other pretrained TTS models can do, refer to our
<a href="https://huggingface.co/learn/audio-course/chapter6/pre-trained_models" rel="nofollow">Audio course</a>.`,Kt,R,yl=`If you are looking to fine-tune a TTS model, the only text-to-speech models currently available in 🤗 Transformers
are <a href="model_doc/speecht5">SpeechT5</a> and <a href="model_doc/fastspeech2_conformer">FastSpeech2Conformer</a>, though more will be added in the future. SpeechT5 is pre-trained on a combination of speech-to-text and text-to-speech data, allowing it to learn a unified space of hidden representations shared by both text and speech. This means that the same pre-trained model can be fine-tuned for different tasks. Furthermore, SpeechT5 supports multiple speakers through x-vector speaker embeddings.`,Ot,X,ul="The remainder of this guide illustrates how to:",es,Y,jl='<li>Fine-tune <a href="../model_doc/speecht5">SpeechT5</a> that was originally trained on English speech on the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.</li> <li>Use your refined model for inference in one of two ways: using a pipeline or directly.</li>',ts,z,gl="Before you begin, make sure you have all the necessary libraries installed:",ss,Q,as,N,fl="Install 🤗Transformers from source as not all the SpeechT5 features have been merged into an official release yet:",ls,F,ns,k,ps,H,wl="We encourage you to log in to your Hugging Face account to upload and share your model with the community. When prompted, enter your token to log in:",is,q,os,A,rs,S,Jl=`<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. In this guide, we are using the Dutch language subset, feel free to pick another subset.`,cs,E,Tl=`Note that VoxPopuli or any other automated speech recognition (ASR) dataset may not be the most suitable
option for training TTS models. The features that make it beneficial for ASR, such as excessive background noise, are
typically undesirable in TTS. However, finding top-quality, multilingual, and multi-speaker TTS datasets can be quite
challenging.`,hs,P,bl="Let’s load the data:",ms,L,Ms,D,Ul=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,ds,K,ys,O,us,ee,Cl="Let’s begin by defining the model checkpoint to use and loading the appropriate processor:",js,te,gs,se,fs,ae,$l="Start by cleaning up the text data. You’ll need the tokenizer part of the processor to process the text:",ws,le,Js,ne,kl=`The dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which feature to use as the text input,
consider that the SpeechT5 tokenizer doesn’t have any tokens for numbers. In <code>normalized_text</code> the numbers are written
out as text. Thus, it is a better fit, and we recommend using    <code>normalized_text</code> as input text.`,Ts,pe,Il=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,bs,ie,xl=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,Us,oe,Cs,re,Zl=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,$s,ce,ks,he,vl=`To handle the unsupported characters identified in the previous step, define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,Is,me,xs,Me,Vl="Now that you have dealt with special characters in the text, it’s time to shift focus to the audio data.",Zs,de,vs,ye,_l=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,Vs,ue,_s,je,Gl="By plotting a histogram you can get a sense of how much data there is for each speaker.",Gs,ge,Bs,I,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Ws,fe,Wl=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,Rs,we,Xs,Je,Rl="Let’s check how many speakers remain:",Ys,Te,zs,be,Xl="Let’s see how many examples are left:",Qs,Ue,Ns,Ce,Yl="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Fs,$e,zl=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Hs,ke,qs,Ie,Ql=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,As,xe,Nl=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,Ss,Ze,Es,ve,Fl=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Ps,Ve,Hl=`For optimal results, we recommend training an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language.`,Ls,_e,Ds,Ge,ql=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,Ks,Be,Os,We,Al="Verify the processing is correct by looking at a single example:",ea,Re,ta,Xe,Sl="Speaker embeddings should be a 512-element vector:",sa,Ye,aa,ze,El="The labels should be a log-mel spectrogram with 80 mel bins.",la,Qe,na,x,Pl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',pa,Ne,Ll=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,ia,Fe,Dl="Now apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",oa,He,ra,qe,Kl=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,ca,Ae,ha,Se,Ol="Next, create a basic train/test split:",ma,Ee,Ma,Pe,da,Le,en=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with the special value <code>-100</code>. This special value
instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,ya,De,ua,Ke,tn=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,ja,Oe,ga,et,fa,tt,sn="Load the pre-trained model from the same checkpoint as you used for loading the processor:",wa,st,Ja,at,an="The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training.",Ta,lt,ba,nt,ln=`Define the training arguments. Here we are not computing any evaluation metrics during the training process. Instead, we’ll
only look at the loss:`,Ua,pt,Ca,it,nn="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",$a,ot,ka,rt,pn=`And with that, you’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Ia,ct,xa,ht,on="To be able to use your checkpoint with a pipeline, make sure to save the processor with the checkpoint:",Za,mt,va,Mt,rn="Push the final model to the 🤗 Hub:",Va,dt,_a,yt,Ga,ut,Ba,jt,cn=`Great, now that you’ve fine-tuned a model, you can use it for inference!
First, let’s see how you can use it with a corresponding pipeline. Let’s create a <code>&quot;text-to-speech&quot;</code> pipeline with your
checkpoint:`,Wa,gt,Ra,ft,hn="Pick a piece of text in Dutch you’d like narrated, e.g.:",Xa,wt,Ya,Jt,mn="To use SpeechT5 with the pipeline, you’ll need a speaker embedding. Let’s get it from an example in the test dataset:",za,Tt,Qa,bt,Mn="Now you can pass the text and speaker embeddings to the pipeline, and it will take care of the rest:",Na,Ut,Fa,Ct,dn="You can then listen to the result:",Ha,$t,qa,kt,Aa,It,yn="You can achieve the same inference results without using the pipeline, however, more steps will be required.",Sa,xt,un="Load the model from the 🤗 Hub:",Ea,Zt,Pa,vt,jn="Pick an example from the test dataset obtain a speaker embedding.",La,Vt,Da,_t,gn="Define the input text and tokenize it.",Ka,Gt,Oa,Bt,fn="Create a spectrogram with your model:",el,Wt,tl,Rt,wn="Visualize the spectrogram, if you’d like to:",sl,Xt,al,Z,Jn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_2.png" alt="Generated log-mel spectrogram"/>',ll,Yt,Tn="Finally, use the vocoder to turn the spectrogram into sound.",nl,zt,pl,Qt,bn=`In our experience, obtaining satisfactory results from this model can be challenging. The quality of the speaker
embeddings appears to be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,il,Nt,Un=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,ol,Ft,Cn=`Finally, it is essential to consider ethical considerations. Although TTS technology has numerous useful applications, it
may also be used for malicious purposes, such as impersonating someone’s voice without their knowledge or consent. Please
use TTS judiciously and responsibly.`,rl,Ht,cl,qt,hl;return J=new b({props:{title:"Text to speech",local:"text-to-speech",headingTag:"h1"}}),C=new Wn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"}]}}),_=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMiklMEF0ZXh0JTIwJTNEJTIwJTIyJTVCY2xlYXJzJTIwdGhyb2F0JTVEJTIwVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjAuLi4lMjBhbmQlMjBJJTIwanVzdCUyMHRvb2slMjBhJTIwbG9uZyUyMHBhdXNlLiUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;[clears throat] This is a test ... and I just took a long pause.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text)`,wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Q=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install datasets soundfile speechbrain accelerate",wrap:!1}}),F=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdA==",highlighted:"pip install git+https://github.com/huggingface/transformers.git",wrap:!1}}),k=new Bn({props:{$$slots:{default:[Xn]},$$scope:{ctx:St}}}),q=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),A=new b({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">20968</span>`,wrap:!1}}),K=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),O=new b({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),te=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),se=new b({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),le=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),oe=new y({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
<span class="hljs-meta">... </span>    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


<span class="hljs-meta">&gt;&gt;&gt; </span>vocabs = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    extract_all_chars,
<span class="hljs-meta">... </span>    batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    keep_in_memory=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    remove_columns=dataset.column_names,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),ce=new y({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab - tokenizer_vocab
{<span class="hljs-string">&#x27; &#x27;</span>, <span class="hljs-string">&#x27;à&#x27;</span>, <span class="hljs-string">&#x27;ç&#x27;</span>, <span class="hljs-string">&#x27;è&#x27;</span>, <span class="hljs-string">&#x27;ë&#x27;</span>, <span class="hljs-string">&#x27;í&#x27;</span>, <span class="hljs-string">&#x27;ï&#x27;</span>, <span class="hljs-string">&#x27;ö&#x27;</span>, <span class="hljs-string">&#x27;ü&#x27;</span>}`,wrap:!1}}),me=new y({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>replacements = [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
<span class="hljs-meta">... </span>        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),de=new b({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),ue=new y({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
<span class="hljs-meta">... </span>    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),ge=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),we=new y({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),Te=new y({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))
<span class="hljs-number">42</span>`,wrap:!1}}),Ue=new y({props:{code:"bGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">9973</span>`,wrap:!1}}),ke=new b({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),Ze=new y({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5pbmZlcmVuY2UuY2xhc3NpZmllcnMlMjBpbXBvcnQlMjBFbmNvZGVyQ2xhc3NpZmllciUwQWZyb20lMjBhY2NlbGVyYXRlLnRlc3RfdXRpbHMudGVzdGluZyUyMGltcG9ydCUyMGdldF9iYWNrZW5kJTBBJTBBc3BrX21vZGVsX25hbWUlMjAlM0QlMjAlMjJzcGVlY2hicmFpbiUyRnNwa3JlYy14dmVjdC12b3hjZWxlYiUyMiUwQWRldmljZSUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwZ2V0X2JhY2tlbmQoKSUyMCUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBc3BlYWtlcl9tb2RlbCUyMCUzRCUyMEVuY29kZXJDbGFzc2lmaWVyLmZyb21faHBhcmFtcyglMEElMjAlMjAlMjAlMjBzb3VyY2UlM0RzcGtfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHJ1bl9vcHRzJTNEJTdCJTIyZGV2aWNlJTIyJTNBJTIwZGV2aWNlJTdEJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZWRpciUzRG9zLnBhdGguam9pbiglMjIlMkZ0bXAlMjIlMkMlMjBzcGtfbW9kZWxfbmFtZSklMkMlMEEpJTBBJTBBJTBBZGVmJTIwY3JlYXRlX3NwZWFrZXJfZW1iZWRkaW5nKHdhdmVmb3JtKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX21vZGVsLmVuY29kZV9iYXRjaCh0b3JjaC50ZW5zb3Iod2F2ZWZvcm0pKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwubm9ybWFsaXplKHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMGRpbSUzRDIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnNxdWVlemUoKS5jcHUoKS5udW1weSgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BlYWtlcl9lbWJlZGRpbmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> speechbrain.inference.classifiers <span class="hljs-keyword">import</span> EncoderClassifier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

<span class="hljs-meta">&gt;&gt;&gt; </span>spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_model = EncoderClassifier.from_hparams(
<span class="hljs-meta">... </span>    source=spk_model_name,
<span class="hljs-meta">... </span>    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
<span class="hljs-meta">... </span>    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
<span class="hljs-meta">... </span>        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),_e=new b({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Be=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">... </span>    example = processor(
<span class="hljs-meta">... </span>        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
<span class="hljs-meta">... </span>        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>        return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-comment"># strip off the batch dimension</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Re=new y({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(processed_example.keys())
[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;stop_labels&#x27;</span>, <span class="hljs-string">&#x27;speaker_embeddings&#x27;</span>]`,wrap:!1}}),Ye=new y({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape
(<span class="hljs-number">512</span>,)`,wrap:!1}}),Qe=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),He=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Ae=new y({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
<span class="hljs-meta">... </span>    input_length = <span class="hljs-built_in">len</span>(input_ids)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">8259</span>`,wrap:!1}}),Ee=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Pe=new b({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),De=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
<span class="hljs-meta">... </span>    processor: <span class="hljs-type">Any</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
<span class="hljs-meta">... </span>        batch = processor.pad(input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># not used during fine-tuning</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>            target_lengths = torch.tensor([<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features])
<span class="hljs-meta">... </span>            target_lengths = target_lengths.new(
<span class="hljs-meta">... </span>                [length - length % model.config.reduction_factor <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths]
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            max_length = <span class="hljs-built_in">max</span>(target_lengths)
<span class="hljs-meta">... </span>            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># also add in the speaker embeddings</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Oe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = TTSDataCollatorWithPadding(processor=processor)',wrap:!1}}),et=new b({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),st=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),lt=new y({props:{code:"bW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNl",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.use_cache = <span class="hljs-literal">False</span>',wrap:!1}}),pt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = Seq2SeqTrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">4000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ot=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Seq2SeqTrainer(
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    processing_class=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ct=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),mt=new y({props:{code:"cHJvY2Vzc29yLnNhdmVfcHJldHJhaW5lZCglMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>processor.save_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),dt=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),yt=new b({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ut=new b({props:{title:"Inference with a pipeline",local:"inference-with-a-pipeline",headingTag:"h3"}}),gt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)`,wrap:!1}}),wt=new y({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Tt=new y({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ut=new y({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlM0ElMjBzcGVha2VyX2VtYmVkZGluZ3MlN0QlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQlMkMlMjBmb3J3YXJkX3BhcmFtcyUzRGZvcndhcmRfcGFyYW1zKSUwQW91dHB1dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>forward_params = {<span class="hljs-string">&quot;speaker_embeddings&quot;</span>: speaker_embeddings}
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text, forward_params=forward_params)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;audio&#x27;</span>: array([-<span class="hljs-number">6.82714235e-05</span>, -<span class="hljs-number">4.26525949e-04</span>,  <span class="hljs-number">1.06134125e-04</span>, ...,
        -<span class="hljs-number">1.22392643e-03</span>, -<span class="hljs-number">7.76011671e-04</span>,  <span class="hljs-number">3.29112721e-04</span>], dtype=float32),
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),$t=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJ2F1ZGlvJyU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUInc2FtcGxpbmdfcmF0ZSclNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&#x27;audio&#x27;</span>], rate=output[<span class="hljs-string">&#x27;sampling_rate&#x27;</span>])`,wrap:!1}}),kt=new b({props:{title:"Run inference manually",local:"run-inference-manually",headingTag:"h3"}}),Zt=new y({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),Vt=new y({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Gt=new y({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Wt=new y({props:{code:"c3BlY3Ryb2dyYW0lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZV9zcGVlY2goaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings)',wrap:!1}}),Xt=new y({props:{code:"cGx0LmZpZ3VyZSgpJTBBcGx0Lmltc2hvdyhzcGVjdHJvZ3JhbS5UKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(spectrogram.T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),zt=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyMCUzRCUyMHZvY29kZXIoc3BlY3Ryb2dyYW0pJTBBJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    speech = vocoder(spectrogram)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ht=new Rn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/text-to-speech.md"}}),{c(){j=p("meta"),v=l(),U=p("p"),w=l(),r(J.$$.fragment),T=l(),r(C.$$.fragment),$=l(),g=p("p"),g.innerHTML=V,u=l(),f=p("p"),f.innerHTML=ml,Et=l(),r(_.$$.fragment),Pt=l(),G=p("p"),G.textContent=Ml,Lt=l(),r(B.$$.fragment),Dt=l(),W=p("p"),W.innerHTML=dl,Kt=l(),R=p("p"),R.innerHTML=yl,Ot=l(),X=p("p"),X.textContent=ul,es=l(),Y=p("ol"),Y.innerHTML=jl,ts=l(),z=p("p"),z.textContent=gl,ss=l(),r(Q.$$.fragment),as=l(),N=p("p"),N.textContent=fl,ls=l(),r(F.$$.fragment),ns=l(),r(k.$$.fragment),ps=l(),H=p("p"),H.textContent=wl,is=l(),r(q.$$.fragment),os=l(),r(A.$$.fragment),rs=l(),S=p("p"),S.innerHTML=Jl,cs=l(),E=p("p"),E.textContent=Tl,hs=l(),P=p("p"),P.textContent=bl,ms=l(),r(L.$$.fragment),Ms=l(),D=p("p"),D.textContent=Ul,ds=l(),r(K.$$.fragment),ys=l(),r(O.$$.fragment),us=l(),ee=p("p"),ee.textContent=Cl,js=l(),r(te.$$.fragment),gs=l(),r(se.$$.fragment),fs=l(),ae=p("p"),ae.textContent=$l,ws=l(),r(le.$$.fragment),Js=l(),ne=p("p"),ne.innerHTML=kl,Ts=l(),pe=p("p"),pe.innerHTML=Il,bs=l(),ie=p("p"),ie.innerHTML=xl,Us=l(),r(oe.$$.fragment),Cs=l(),re=p("p"),re.textContent=Zl,$s=l(),r(ce.$$.fragment),ks=l(),he=p("p"),he.innerHTML=vl,Is=l(),r(me.$$.fragment),xs=l(),Me=p("p"),Me.textContent=Vl,Zs=l(),r(de.$$.fragment),vs=l(),ye=p("p"),ye.textContent=_l,Vs=l(),r(ue.$$.fragment),_s=l(),je=p("p"),je.textContent=Gl,Gs=l(),r(ge.$$.fragment),Bs=l(),I=p("div"),I.innerHTML=Bl,Ws=l(),fe=p("p"),fe.textContent=Wl,Rs=l(),r(we.$$.fragment),Xs=l(),Je=p("p"),Je.textContent=Rl,Ys=l(),r(Te.$$.fragment),zs=l(),be=p("p"),be.textContent=Xl,Qs=l(),r(Ue.$$.fragment),Ns=l(),Ce=p("p"),Ce.textContent=Yl,Fs=l(),$e=p("p"),$e.textContent=zl,Hs=l(),r(ke.$$.fragment),qs=l(),Ie=p("p"),Ie.innerHTML=Ql,As=l(),xe=p("p"),xe.innerHTML=Nl,Ss=l(),r(Ze.$$.fragment),Es=l(),ve=p("p"),ve.innerHTML=Fl,Ps=l(),Ve=p("p"),Ve.textContent=Hl,Ls=l(),r(_e.$$.fragment),Ds=l(),Ge=p("p"),Ge.innerHTML=ql,Ks=l(),r(Be.$$.fragment),Os=l(),We=p("p"),We.textContent=Al,ea=l(),r(Re.$$.fragment),ta=l(),Xe=p("p"),Xe.textContent=Sl,sa=l(),r(Ye.$$.fragment),aa=l(),ze=p("p"),ze.textContent=El,la=l(),r(Qe.$$.fragment),na=l(),x=p("div"),x.innerHTML=Pl,pa=l(),Ne=p("p"),Ne.textContent=Ll,ia=l(),Fe=p("p"),Fe.textContent=Dl,oa=l(),r(He.$$.fragment),ra=l(),qe=p("p"),qe.textContent=Kl,ca=l(),r(Ae.$$.fragment),ha=l(),Se=p("p"),Se.textContent=Ol,ma=l(),r(Ee.$$.fragment),Ma=l(),r(Pe.$$.fragment),da=l(),Le=p("p"),Le.innerHTML=en,ya=l(),r(De.$$.fragment),ua=l(),Ke=p("p"),Ke.textContent=tn,ja=l(),r(Oe.$$.fragment),ga=l(),r(et.$$.fragment),fa=l(),tt=p("p"),tt.textContent=sn,wa=l(),r(st.$$.fragment),Ja=l(),at=p("p"),at.innerHTML=an,Ta=l(),r(lt.$$.fragment),ba=l(),nt=p("p"),nt.textContent=ln,Ua=l(),r(pt.$$.fragment),Ca=l(),it=p("p"),it.innerHTML=nn,$a=l(),r(ot.$$.fragment),ka=l(),rt=p("p"),rt.innerHTML=pn,Ia=l(),r(ct.$$.fragment),xa=l(),ht=p("p"),ht.textContent=on,Za=l(),r(mt.$$.fragment),va=l(),Mt=p("p"),Mt.textContent=rn,Va=l(),r(dt.$$.fragment),_a=l(),r(yt.$$.fragment),Ga=l(),r(ut.$$.fragment),Ba=l(),jt=p("p"),jt.innerHTML=cn,Wa=l(),r(gt.$$.fragment),Ra=l(),ft=p("p"),ft.textContent=hn,Xa=l(),r(wt.$$.fragment),Ya=l(),Jt=p("p"),Jt.textContent=mn,za=l(),r(Tt.$$.fragment),Qa=l(),bt=p("p"),bt.textContent=Mn,Na=l(),r(Ut.$$.fragment),Fa=l(),Ct=p("p"),Ct.textContent=dn,Ha=l(),r($t.$$.fragment),qa=l(),r(kt.$$.fragment),Aa=l(),It=p("p"),It.textContent=yn,Sa=l(),xt=p("p"),xt.textContent=un,Ea=l(),r(Zt.$$.fragment),Pa=l(),vt=p("p"),vt.textContent=jn,La=l(),r(Vt.$$.fragment),Da=l(),_t=p("p"),_t.textContent=gn,Ka=l(),r(Gt.$$.fragment),Oa=l(),Bt=p("p"),Bt.textContent=fn,el=l(),r(Wt.$$.fragment),tl=l(),Rt=p("p"),Rt.textContent=wn,sl=l(),r(Xt.$$.fragment),al=l(),Z=p("div"),Z.innerHTML=Jn,ll=l(),Yt=p("p"),Yt.textContent=Tn,nl=l(),r(zt.$$.fragment),pl=l(),Qt=p("p"),Qt.textContent=bn,il=l(),Nt=p("p"),Nt.innerHTML=Un,ol=l(),Ft=p("p"),Ft.textContent=Cn,rl=l(),r(Ht.$$.fragment),cl=l(),qt=p("p"),this.h()},l(e){const t=_n("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(s),v=n(e),U=i(e,"P",{}),kn(U).forEach(s),w=n(e),c(J.$$.fragment,e),T=n(e),c(C.$$.fragment,e),$=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-df7jf3"&&(g.innerHTML=V),u=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1qjfjz9"&&(f.innerHTML=ml),Et=n(e),c(_.$$.fragment,e),Pt=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-q175ip"&&(G.textContent=Ml),Lt=n(e),c(B.$$.fragment,e),Dt=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1wr79tk"&&(W.innerHTML=dl),Kt=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1w1eza9"&&(R.innerHTML=yl),Ot=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-13pgbx8"&&(X.textContent=ul),es=n(e),Y=i(e,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-16nfhgc"&&(Y.innerHTML=jl),ts=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1c9nexd"&&(z.textContent=gl),ss=n(e),c(Q.$$.fragment,e),as=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1pk9b4n"&&(N.textContent=fl),ls=n(e),c(F.$$.fragment,e),ns=n(e),c(k.$$.fragment,e),ps=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-yib87s"&&(H.textContent=wl),is=n(e),c(q.$$.fragment,e),os=n(e),c(A.$$.fragment,e),rs=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-i51j1v"&&(S.innerHTML=Jl),cs=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1smm6mj"&&(E.textContent=Tl),hs=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1soaqfm"&&(P.textContent=bl),ms=n(e),c(L.$$.fragment,e),Ms=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1xdebij"&&(D.textContent=Ul),ds=n(e),c(K.$$.fragment,e),ys=n(e),c(O.$$.fragment,e),us=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1y5a32a"&&(ee.textContent=Cl),js=n(e),c(te.$$.fragment,e),gs=n(e),c(se.$$.fragment,e),fs=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1bseo5y"&&(ae.textContent=$l),ws=n(e),c(le.$$.fragment,e),Js=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-alux34"&&(ne.innerHTML=kl),Ts=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1qiuc1m"&&(pe.innerHTML=Il),bs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-l4aof2"&&(ie.innerHTML=xl),Us=n(e),c(oe.$$.fragment,e),Cs=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-fefaym"&&(re.textContent=Zl),$s=n(e),c(ce.$$.fragment,e),ks=n(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1m7sgt2"&&(he.innerHTML=vl),Is=n(e),c(me.$$.fragment,e),xs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-k1jzc5"&&(Me.textContent=Vl),Zs=n(e),c(de.$$.fragment,e),vs=n(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1edo483"&&(ye.textContent=_l),Vs=n(e),c(ue.$$.fragment,e),_s=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1hah56a"&&(je.textContent=Gl),Gs=n(e),c(ge.$$.fragment,e),Bs=n(e),I=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-1uufiik"&&(I.innerHTML=Bl),Ws=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-k2ylek"&&(fe.textContent=Wl),Rs=n(e),c(we.$$.fragment,e),Xs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1twjone"&&(Je.textContent=Rl),Ys=n(e),c(Te.$$.fragment,e),zs=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-58xrnp"&&(be.textContent=Xl),Qs=n(e),c(Ue.$$.fragment,e),Ns=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-oizlk1"&&(Ce.textContent=Yl),Fs=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1n0u7fp"&&($e.textContent=zl),Hs=n(e),c(ke.$$.fragment,e),qs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-fggtda"&&(Ie.innerHTML=Ql),As=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-7nncma"&&(xe.innerHTML=Nl),Ss=n(e),c(Ze.$$.fragment,e),Es=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1mtxkxr"&&(ve.innerHTML=Fl),Ps=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1az2ed"&&(Ve.textContent=Hl),Ls=n(e),c(_e.$$.fragment,e),Ds=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1tlidee"&&(Ge.innerHTML=ql),Ks=n(e),c(Be.$$.fragment,e),Os=n(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-17mzfft"&&(We.textContent=Al),ea=n(e),c(Re.$$.fragment,e),ta=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1mqg4ck"&&(Xe.textContent=Sl),sa=n(e),c(Ye.$$.fragment,e),aa=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-f7g58h"&&(ze.textContent=El),la=n(e),c(Qe.$$.fragment,e),na=n(e),x=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-j4o1b8"&&(x.innerHTML=Pl),pa=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1t9vz0y"&&(Ne.textContent=Ll),ia=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1r5jy40"&&(Fe.textContent=Dl),oa=n(e),c(He.$$.fragment,e),ra=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-wvyh3r"&&(qe.textContent=Kl),ca=n(e),c(Ae.$$.fragment,e),ha=n(e),Se=i(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-bxk629"&&(Se.textContent=Ol),ma=n(e),c(Ee.$$.fragment,e),Ma=n(e),c(Pe.$$.fragment,e),da=n(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1qadcxm"&&(Le.innerHTML=en),ya=n(e),c(De.$$.fragment,e),ua=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-u623yc"&&(Ke.textContent=tn),ja=n(e),c(Oe.$$.fragment,e),ga=n(e),c(et.$$.fragment,e),fa=n(e),tt=i(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1cncndu"&&(tt.textContent=sn),wa=n(e),c(st.$$.fragment,e),Ja=n(e),at=i(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-15xsopr"&&(at.innerHTML=an),Ta=n(e),c(lt.$$.fragment,e),ba=n(e),nt=i(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-11l73nm"&&(nt.textContent=ln),Ua=n(e),c(pt.$$.fragment,e),Ca=n(e),it=i(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1yq1u47"&&(it.innerHTML=nn),$a=n(e),c(ot.$$.fragment,e),ka=n(e),rt=i(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1qh8b8v"&&(rt.innerHTML=pn),Ia=n(e),c(ct.$$.fragment,e),xa=n(e),ht=i(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-y4s9dx"&&(ht.textContent=on),Za=n(e),c(mt.$$.fragment,e),va=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-hefgo2"&&(Mt.textContent=rn),Va=n(e),c(dt.$$.fragment,e),_a=n(e),c(yt.$$.fragment,e),Ga=n(e),c(ut.$$.fragment,e),Ba=n(e),jt=i(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-v48okf"&&(jt.innerHTML=cn),Wa=n(e),c(gt.$$.fragment,e),Ra=n(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1jnrzsv"&&(ft.textContent=hn),Xa=n(e),c(wt.$$.fragment,e),Ya=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1q3bhpe"&&(Jt.textContent=mn),za=n(e),c(Tt.$$.fragment,e),Qa=n(e),bt=i(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-j6jhy"&&(bt.textContent=Mn),Na=n(e),c(Ut.$$.fragment,e),Fa=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1rln9cy"&&(Ct.textContent=dn),Ha=n(e),c($t.$$.fragment,e),qa=n(e),c(kt.$$.fragment,e),Aa=n(e),It=i(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-ioj6pb"&&(It.textContent=yn),Sa=n(e),xt=i(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-qr2au3"&&(xt.textContent=un),Ea=n(e),c(Zt.$$.fragment,e),Pa=n(e),vt=i(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-kbl5lr"&&(vt.textContent=jn),La=n(e),c(Vt.$$.fragment,e),Da=n(e),_t=i(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1611eam"&&(_t.textContent=gn),Ka=n(e),c(Gt.$$.fragment,e),Oa=n(e),Bt=i(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1rnfl72"&&(Bt.textContent=fn),el=n(e),c(Wt.$$.fragment,e),tl=n(e),Rt=i(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1xw0ohr"&&(Rt.textContent=wn),sl=n(e),c(Xt.$$.fragment,e),al=n(e),Z=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-16b2dt6"&&(Z.innerHTML=Jn),ll=n(e),Yt=i(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-chmo02"&&(Yt.textContent=Tn),nl=n(e),c(zt.$$.fragment,e),pl=n(e),Qt=i(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1fdujzv"&&(Qt.textContent=bn),il=n(e),Nt=i(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-6lmfh0"&&(Nt.innerHTML=Un),ol=n(e),Ft=i(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1mo0fd"&&(Ft.textContent=Cn),rl=n(e),c(Ht.$$.fragment,e),cl=n(e),qt=i(e,"P",{}),kn(qt).forEach(s),this.h()},h(){At(j,"name","hf:doc:metadata"),At(j,"content",zn),At(I,"class","flex justify-center"),At(x,"class","flex justify-center"),At(Z,"class","flex justify-center")},m(e,t){Gn(document.head,j),a(e,v,t),a(e,U,t),a(e,w,t),h(J,e,t),a(e,T,t),h(C,e,t),a(e,$,t),a(e,g,t),a(e,u,t),a(e,f,t),a(e,Et,t),h(_,e,t),a(e,Pt,t),a(e,G,t),a(e,Lt,t),h(B,e,t),a(e,Dt,t),a(e,W,t),a(e,Kt,t),a(e,R,t),a(e,Ot,t),a(e,X,t),a(e,es,t),a(e,Y,t),a(e,ts,t),a(e,z,t),a(e,ss,t),h(Q,e,t),a(e,as,t),a(e,N,t),a(e,ls,t),h(F,e,t),a(e,ns,t),h(k,e,t),a(e,ps,t),a(e,H,t),a(e,is,t),h(q,e,t),a(e,os,t),h(A,e,t),a(e,rs,t),a(e,S,t),a(e,cs,t),a(e,E,t),a(e,hs,t),a(e,P,t),a(e,ms,t),h(L,e,t),a(e,Ms,t),a(e,D,t),a(e,ds,t),h(K,e,t),a(e,ys,t),h(O,e,t),a(e,us,t),a(e,ee,t),a(e,js,t),h(te,e,t),a(e,gs,t),h(se,e,t),a(e,fs,t),a(e,ae,t),a(e,ws,t),h(le,e,t),a(e,Js,t),a(e,ne,t),a(e,Ts,t),a(e,pe,t),a(e,bs,t),a(e,ie,t),a(e,Us,t),h(oe,e,t),a(e,Cs,t),a(e,re,t),a(e,$s,t),h(ce,e,t),a(e,ks,t),a(e,he,t),a(e,Is,t),h(me,e,t),a(e,xs,t),a(e,Me,t),a(e,Zs,t),h(de,e,t),a(e,vs,t),a(e,ye,t),a(e,Vs,t),h(ue,e,t),a(e,_s,t),a(e,je,t),a(e,Gs,t),h(ge,e,t),a(e,Bs,t),a(e,I,t),a(e,Ws,t),a(e,fe,t),a(e,Rs,t),h(we,e,t),a(e,Xs,t),a(e,Je,t),a(e,Ys,t),h(Te,e,t),a(e,zs,t),a(e,be,t),a(e,Qs,t),h(Ue,e,t),a(e,Ns,t),a(e,Ce,t),a(e,Fs,t),a(e,$e,t),a(e,Hs,t),h(ke,e,t),a(e,qs,t),a(e,Ie,t),a(e,As,t),a(e,xe,t),a(e,Ss,t),h(Ze,e,t),a(e,Es,t),a(e,ve,t),a(e,Ps,t),a(e,Ve,t),a(e,Ls,t),h(_e,e,t),a(e,Ds,t),a(e,Ge,t),a(e,Ks,t),h(Be,e,t),a(e,Os,t),a(e,We,t),a(e,ea,t),h(Re,e,t),a(e,ta,t),a(e,Xe,t),a(e,sa,t),h(Ye,e,t),a(e,aa,t),a(e,ze,t),a(e,la,t),h(Qe,e,t),a(e,na,t),a(e,x,t),a(e,pa,t),a(e,Ne,t),a(e,ia,t),a(e,Fe,t),a(e,oa,t),h(He,e,t),a(e,ra,t),a(e,qe,t),a(e,ca,t),h(Ae,e,t),a(e,ha,t),a(e,Se,t),a(e,ma,t),h(Ee,e,t),a(e,Ma,t),h(Pe,e,t),a(e,da,t),a(e,Le,t),a(e,ya,t),h(De,e,t),a(e,ua,t),a(e,Ke,t),a(e,ja,t),h(Oe,e,t),a(e,ga,t),h(et,e,t),a(e,fa,t),a(e,tt,t),a(e,wa,t),h(st,e,t),a(e,Ja,t),a(e,at,t),a(e,Ta,t),h(lt,e,t),a(e,ba,t),a(e,nt,t),a(e,Ua,t),h(pt,e,t),a(e,Ca,t),a(e,it,t),a(e,$a,t),h(ot,e,t),a(e,ka,t),a(e,rt,t),a(e,Ia,t),h(ct,e,t),a(e,xa,t),a(e,ht,t),a(e,Za,t),h(mt,e,t),a(e,va,t),a(e,Mt,t),a(e,Va,t),h(dt,e,t),a(e,_a,t),h(yt,e,t),a(e,Ga,t),h(ut,e,t),a(e,Ba,t),a(e,jt,t),a(e,Wa,t),h(gt,e,t),a(e,Ra,t),a(e,ft,t),a(e,Xa,t),h(wt,e,t),a(e,Ya,t),a(e,Jt,t),a(e,za,t),h(Tt,e,t),a(e,Qa,t),a(e,bt,t),a(e,Na,t),h(Ut,e,t),a(e,Fa,t),a(e,Ct,t),a(e,Ha,t),h($t,e,t),a(e,qa,t),h(kt,e,t),a(e,Aa,t),a(e,It,t),a(e,Sa,t),a(e,xt,t),a(e,Ea,t),h(Zt,e,t),a(e,Pa,t),a(e,vt,t),a(e,La,t),h(Vt,e,t),a(e,Da,t),a(e,_t,t),a(e,Ka,t),h(Gt,e,t),a(e,Oa,t),a(e,Bt,t),a(e,el,t),h(Wt,e,t),a(e,tl,t),a(e,Rt,t),a(e,sl,t),h(Xt,e,t),a(e,al,t),a(e,Z,t),a(e,ll,t),a(e,Yt,t),a(e,nl,t),h(zt,e,t),a(e,pl,t),a(e,Qt,t),a(e,il,t),a(e,Nt,t),a(e,ol,t),a(e,Ft,t),a(e,rl,t),h(Ht,e,t),a(e,cl,t),a(e,qt,t),hl=!0},p(e,[t]){const $n={};t&2&&($n.$$scope={dirty:t,ctx:e}),k.$set($n)},i(e){hl||(m(J.$$.fragment,e),m(C.$$.fragment,e),m(_.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(k.$$.fragment,e),m(q.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(ke.$$.fragment,e),m(Ze.$$.fragment,e),m(_e.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(Ye.$$.fragment,e),m(Qe.$$.fragment,e),m(He.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Pe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(pt.$$.fragment,e),m(ot.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(dt.$$.fragment,e),m(yt.$$.fragment,e),m(ut.$$.fragment,e),m(gt.$$.fragment,e),m(wt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ut.$$.fragment,e),m($t.$$.fragment,e),m(kt.$$.fragment,e),m(Zt.$$.fragment,e),m(Vt.$$.fragment,e),m(Gt.$$.fragment,e),m(Wt.$$.fragment,e),m(Xt.$$.fragment,e),m(zt.$$.fragment,e),m(Ht.$$.fragment,e),hl=!0)},o(e){M(J.$$.fragment,e),M(C.$$.fragment,e),M(_.$$.fragment,e),M(B.$$.fragment,e),M(Q.$$.fragment,e),M(F.$$.fragment,e),M(k.$$.fragment,e),M(q.$$.fragment,e),M(A.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(ge.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),M(Ue.$$.fragment,e),M(ke.$$.fragment,e),M(Ze.$$.fragment,e),M(_e.$$.fragment,e),M(Be.$$.fragment,e),M(Re.$$.fragment,e),M(Ye.$$.fragment,e),M(Qe.$$.fragment,e),M(He.$$.fragment,e),M(Ae.$$.fragment,e),M(Ee.$$.fragment,e),M(Pe.$$.fragment,e),M(De.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),M(st.$$.fragment,e),M(lt.$$.fragment,e),M(pt.$$.fragment,e),M(ot.$$.fragment,e),M(ct.$$.fragment,e),M(mt.$$.fragment,e),M(dt.$$.fragment,e),M(yt.$$.fragment,e),M(ut.$$.fragment,e),M(gt.$$.fragment,e),M(wt.$$.fragment,e),M(Tt.$$.fragment,e),M(Ut.$$.fragment,e),M($t.$$.fragment,e),M(kt.$$.fragment,e),M(Zt.$$.fragment,e),M(Vt.$$.fragment,e),M(Gt.$$.fragment,e),M(Wt.$$.fragment,e),M(Xt.$$.fragment,e),M(zt.$$.fragment,e),M(Ht.$$.fragment,e),hl=!1},d(e){e&&(s(v),s(U),s(w),s(T),s($),s(g),s(u),s(f),s(Et),s(Pt),s(G),s(Lt),s(Dt),s(W),s(Kt),s(R),s(Ot),s(X),s(es),s(Y),s(ts),s(z),s(ss),s(as),s(N),s(ls),s(ns),s(ps),s(H),s(is),s(os),s(rs),s(S),s(cs),s(E),s(hs),s(P),s(ms),s(Ms),s(D),s(ds),s(ys),s(us),s(ee),s(js),s(gs),s(fs),s(ae),s(ws),s(Js),s(ne),s(Ts),s(pe),s(bs),s(ie),s(Us),s(Cs),s(re),s($s),s(ks),s(he),s(Is),s(xs),s(Me),s(Zs),s(vs),s(ye),s(Vs),s(_s),s(je),s(Gs),s(Bs),s(I),s(Ws),s(fe),s(Rs),s(Xs),s(Je),s(Ys),s(zs),s(be),s(Qs),s(Ns),s(Ce),s(Fs),s($e),s(Hs),s(qs),s(Ie),s(As),s(xe),s(Ss),s(Es),s(ve),s(Ps),s(Ve),s(Ls),s(Ds),s(Ge),s(Ks),s(Os),s(We),s(ea),s(ta),s(Xe),s(sa),s(aa),s(ze),s(la),s(na),s(x),s(pa),s(Ne),s(ia),s(Fe),s(oa),s(ra),s(qe),s(ca),s(ha),s(Se),s(ma),s(Ma),s(da),s(Le),s(ya),s(ua),s(Ke),s(ja),s(ga),s(fa),s(tt),s(wa),s(Ja),s(at),s(Ta),s(ba),s(nt),s(Ua),s(Ca),s(it),s($a),s(ka),s(rt),s(Ia),s(xa),s(ht),s(Za),s(va),s(Mt),s(Va),s(_a),s(Ga),s(Ba),s(jt),s(Wa),s(Ra),s(ft),s(Xa),s(Ya),s(Jt),s(za),s(Qa),s(bt),s(Na),s(Fa),s(Ct),s(Ha),s(qa),s(Aa),s(It),s(Sa),s(xt),s(Ea),s(Pa),s(vt),s(La),s(Da),s(_t),s(Ka),s(Oa),s(Bt),s(el),s(tl),s(Rt),s(sl),s(al),s(Z),s(ll),s(Yt),s(nl),s(pl),s(Qt),s(il),s(Nt),s(ol),s(Ft),s(rl),s(cl),s(qt)),s(j),d(J,e),d(C,e),d(_,e),d(B,e),d(Q,e),d(F,e),d(k,e),d(q,e),d(A,e),d(L,e),d(K,e),d(O,e),d(te,e),d(se,e),d(le,e),d(oe,e),d(ce,e),d(me,e),d(de,e),d(ue,e),d(ge,e),d(we,e),d(Te,e),d(Ue,e),d(ke,e),d(Ze,e),d(_e,e),d(Be,e),d(Re,e),d(Ye,e),d(Qe,e),d(He,e),d(Ae,e),d(Ee,e),d(Pe,e),d(De,e),d(Oe,e),d(et,e),d(st,e),d(lt,e),d(pt,e),d(ot,e),d(ct,e),d(mt,e),d(dt,e),d(yt,e),d(ut,e),d(gt,e),d(wt,e),d(Tt,e),d(Ut,e),d($t,e),d(kt,e),d(Zt,e),d(Vt,e),d(Gt,e),d(Wt,e),d(Xt,e),d(zt,e),d(Ht,e)}}}const zn='{"title":"Text to speech","local":"text-to-speech","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Inference with a pipeline","local":"inference-with-a-pipeline","sections":[],"depth":3},{"title":"Run inference manually","local":"run-inference-manually","sections":[],"depth":3}],"depth":2}],"depth":1}';function Qn(St){return xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends vn{constructor(j){super(),Vn(this,j,Qn,Yn,In,{})}}export{Pn as component};
