import{s as Be,o as Qe,n as Ve}from"../chunks/scheduler.18a86fab.js";import{S as Ye,i as ze,g as p,s as a,r,A as Fe,h as o,f as t,c as n,j as We,u as d,x as c,k as Xe,l as Ne,y as Ee,a as l,v as m,d as M,t as y,w as J}from"../chunks/index.98837b22.js";import{T as qe}from"../chunks/Tip.77304350.js";import{C as u}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as Se}from"../chunks/Heading.7e7e0c5b.js";import{E as Ae}from"../chunks/getInferenceSnippets.de10bc7d.js";function He(A){let i,j="For large scale use cases, you may want to index and retrieve documents with a vector database.";return{c(){i=p("p"),i.textContent=j},l(h){i=o(h,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1ty4hkx"&&(i.textContent=j)},m(h,q){l(h,i,q)},p:Ve,d(h){h&&t(i)}}}function De(A){let i,j,h,q,U,H,T,Ue="Documents can contain multimodal data if they include charts, tables, and visuals in addition to text. Retrieving information from these documents is challenging because text retrieval models alone can’t handle visual data and image retrieval models lack the granularity and document processing capabilities.",D,f,Te="Visual document retrieval can help retrieve information from all types of documents, including multimodal retrieval augmented generation (RAG). These models accept documents (as images) and texts and calculates the similarity scores between them.",P,C,fe='This guide demonstrates how to index and retrieve documents with <a href="../model_doc/colpali">ColPali</a>.',K,b,L,g,Ce="Make sure Transformers and Datasets is installed.",O,I,ee,_,ge="We will index a dataset of documents related to UFO sightings. We filter the examples where our column of interest is missing. It contains several columns, we are interested in the column <code>specific_detail_query</code> where it contains short summary of the document, and <code>image</code> column that contains our documents.",se,k,te,x,le,Z,Ie="Let’s load the model and the tokenizer.",ae,v,ne,$,_e='Pass the text query to the processor and return the indexed text embeddings from the model. For image-to-text search, replace the <code>text</code> parameter in <a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliProcessor">ColPaliProcessor</a> with the <code>images</code> parameter to pass images.',ie,G,pe,R,ke="Index the images offline, and during inference, return the query text embeddings to get its closest image embeddings.",oe,W,xe='Store the image and image embeddings by writing them to the dataset with <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> as shown below. Add an <code>embeddings</code> column that contains the indexed embeddings. ColPali embeddings take up a lot of storage, so remove them from the GPU and store them in the CPU as NumPy vectors.',ce,X,re,N,Ze="For online inference, create a function to search the image embeddings in batches and retrieve the k-most relevant images. The function below returns the indices in the dataset and their scores for a given indexed dataset, text embeddings, number of top results, and the batch size.",de,B,me,Q,ve="Generate the text embeddings and pass them to the function above to return the dataset indices and scores.",Me,V,ye,Y,Je,z,$e="Display the images to view the Mars related documents.",he,F,ue,w,Ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/doc_1.png" alt="Document 1" style="height: 200px; object-fit: contain; margin-right: 10px;"/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/doc_2.png" alt="Document 2" style="height: 200px; object-fit: contain;"/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/doc_3.png" alt="Document 3" style="height: 200px; object-fit: contain;"/>',we,E,be,S,je;return U=new Se({props:{title:"Visual document retrieval",local:"visual-document-retrieval",headingTag:"h1"}}),b=new qe({props:{warning:!1,$$slots:{default:[He]},$$scope:{ctx:A}}}),I=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q datasets transformers",wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkYXZhbnN0cmllbiUyRnVmby1Db2xQYWxpJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUzQSUyMGV4YW1wbGUlNUIlMjJzcGVjaWZpY19kZXRhaWxfcXVlcnklMjIlNUQlMjBpcyUyMG5vdCUyME5vbmUpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;davanstrien/ufo-ColPali&quot;</span>)
dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&quot;specific_detail_query&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>)
dataset`,wrap:!1}}),x=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbWFnZSclMkMlMjAncmF3X3F1ZXJpZXMnJTJDJTIwJ2Jyb2FkX3RvcGljYWxfcXVlcnknJTJDJTIwJ2Jyb2FkX3RvcGljYWxfZXhwbGFuYXRpb24nJTJDJTIwJ3NwZWNpZmljX2RldGFpbF9xdWVyeSclMkMlMjAnc3BlY2lmaWNfZGV0YWlsX2V4cGxhbmF0aW9uJyUyQyUyMCd2aXN1YWxfZWxlbWVudF9xdWVyeSclMkMlMjAndmlzdWFsX2VsZW1lbnRfZXhwbGFuYXRpb24nJTJDJTIwJ3BhcnNlZF9pbnRvX2pzb24nJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAyMTcyJTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;raw_queries&#x27;</span>, <span class="hljs-string">&#x27;broad_topical_query&#x27;</span>, <span class="hljs-string">&#x27;broad_topical_explanation&#x27;</span>, <span class="hljs-string">&#x27;specific_detail_query&#x27;</span>, <span class="hljs-string">&#x27;specific_detail_explanation&#x27;</span>, <span class="hljs-string">&#x27;visual_element_query&#x27;</span>, <span class="hljs-string">&#x27;visual_element_explanation&#x27;</span>, <span class="hljs-string">&#x27;parsed_into_json&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">2172</span>
})`,wrap:!1}}),v=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ29sUGFsaUZvclJldHJpZXZhbCUyQyUyMENvbFBhbGlQcm9jZXNzb3IlMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydmlkb3JlJTJGY29scGFsaS12MS4yLWhmJTIyJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ29sUGFsaVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEFtb2RlbCUyMCUzRCUyMENvbFBhbGlGb3JSZXRyaWV2YWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMkMlMEEpLmV2YWwoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColPaliForRetrieval, ColPaliProcessor

model_name = <span class="hljs-string">&quot;vidore/colpali-v1.2-hf&quot;</span>

processor = ColPaliProcessor.from_pretrained(model_name)

model = ColPaliForRetrieval.from_pretrained(
    model_name,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
).<span class="hljs-built_in">eval</span>()`,wrap:!1}}),G=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlMjJhJTIwZG9jdW1lbnQlMjBhYm91dCUyME1hcnMlMjBleHBlZGl0aW9uJTIyKS50byglMjJjdWRhJTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjB0ZXh0X2VtYmVkcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuZW1iZWRkaW5ncw==",highlighted:`inputs = processor(text=<span class="hljs-string">&quot;a document about Mars expedition&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
  text_embeds = model(**inputs, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).embeddings`,wrap:!1}}),X=new u({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzJTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QidlbWJlZGRpbmdzJyUzQSUyMG1vZGVsKCoqcHJvY2Vzc29yKGltYWdlcyUzRGV4YW1wbGUlNUIlMjJpbWFnZSUyMiU1RCkudG8oJTIyY3VkYSUyMiklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5lbWJlZGRpbmdzLnRvKHRvcmNoLmZsb2F0MzIpLmRldGFjaCgpLmNwdSgpLm51bXB5KCklN0Qp",highlighted:'ds_with_embeddings = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&#x27;embeddings&#x27;</span>: model(**processor(images=example[<span class="hljs-string">&quot;image&quot;</span>]).to(<span class="hljs-string">&quot;cuda&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).embeddings.to(torch.float32).detach().cpu().numpy()})',wrap:!1}}),B=new u({props:{code:"ZGVmJTIwZmluZF90b3Bfa19pbmRpY2VzX2JhdGNoZWQoZGF0YXNldCUyQyUyMHRleHRfZW1iZWRkaW5nJTJDJTIwcHJvY2Vzc29yJTJDJTIwayUzRDEwJTJDJTIwYmF0Y2hfc2l6ZSUzRDQpJTNBJTBBJTIwJTIwJTIwJTIwc2NvcmVzX2FuZF9pbmRpY2VzJTIwJTNEJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmRfaWR4JTIwJTNEJTIwbWluKHN0YXJ0X2lkeCUyMCUyQiUyMGJhdGNoX3NpemUlMkMlMjBsZW4oZGF0YXNldCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBkYXRhc2V0JTVCc3RhcnRfaWR4JTNBZW5kX2lkeCU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoX2VtYmVkZGluZ3MlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3IoZW1iJTVCMCU1RCUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQzMiklMjBmb3IlMjBlbWIlMjBpbiUyMGJhdGNoJTVCJTIyZW1iZWRkaW5ncyUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMHByb2Nlc3Nvci5zY29yZV9yZXRyaWV2YWwodGV4dF9lbWJlZGRpbmcudG8oJTIyY3B1JTIyKS50byh0b3JjaC5mbG9hdDMyKSUyQyUyMGJhdGNoX2VtYmVkZGluZ3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBoYXNhdHRyKHNjb3JlcyUyQyUyMCUyMnRvbGlzdCUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjBzY29yZXMudG9saXN0KCklNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHNjb3JlJTIwaW4lMjBlbnVtZXJhdGUoc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3Jlc19hbmRfaW5kaWNlcy5hcHBlbmQoKHNjb3JlJTJDJTIwc3RhcnRfaWR4JTIwJTJCJTIwaSkpJTBBJTBBJTIwJTIwJTIwJTIwc29ydGVkX3Jlc3VsdHMlMjAlM0QlMjBzb3J0ZWQoc2NvcmVzX2FuZF9pbmRpY2VzJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElMEElMjAlMjAlMjAlMjB0b3BrJTIwJTNEJTIwc29ydGVkX3Jlc3VsdHMlNUIlM0FrJTVEJTBBJTIwJTIwJTIwJTIwaW5kaWNlcyUyMCUzRCUyMCU1QmlkeCUyMGZvciUyMF8lMkMlMjBpZHglMjBpbiUyMHRvcGslNUQlMEElMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjAlNUJzY29yZSUyMGZvciUyMHNjb3JlJTJDJTIwXyUyMGluJTIwdG9wayU1RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGluZGljZXMlMkMlMjBzY29yZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">find_top_k_indices_batched</span>(<span class="hljs-params">dataset, text_embedding, processor, k=<span class="hljs-number">10</span>, batch_size=<span class="hljs-number">4</span></span>):
    scores_and_indices = []

    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), batch_size):

        end_idx = <span class="hljs-built_in">min</span>(start_idx + batch_size, <span class="hljs-built_in">len</span>(dataset))
        batch = dataset[start_idx:end_idx]        
        batch_embeddings = [torch.tensor(emb[<span class="hljs-number">0</span>], dtype=torch.float32) <span class="hljs-keyword">for</span> emb <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;embeddings&quot;</span>]]
        scores = processor.score_retrieval(text_embedding.to(<span class="hljs-string">&quot;cpu&quot;</span>).to(torch.float32), batch_embeddings)

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(scores, <span class="hljs-string">&quot;tolist&quot;</span>):
            scores = scores.tolist()[<span class="hljs-number">0</span>]

        <span class="hljs-keyword">for</span> i, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(scores):
            scores_and_indices.append((score, start_idx + i))

    sorted_results = <span class="hljs-built_in">sorted</span>(scores_and_indices, key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])

    topk = sorted_results[:k]
    indices = [idx <span class="hljs-keyword">for</span> _, idx <span class="hljs-keyword">in</span> topk]
    scores = [score <span class="hljs-keyword">for</span> score, _ <span class="hljs-keyword">in</span> topk]

    <span class="hljs-keyword">return</span> indices, scores`,wrap:!1}}),V=new u({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMHRleHRfZW1iZWRzJTIwJTNEJTIwbW9kZWwoKipwcm9jZXNzb3IodGV4dCUzRCUyMmElMjBkb2N1bWVudCUyMGFib3V0JTIwTWFycyUyMGV4cGVkaXRpb24lMjIpLnRvKCUyMmN1ZGElMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuZW1iZWRkaW5ncyUwQWluZGljZXMlMkMlMjBzY29yZXMlMjAlM0QlMjBmaW5kX3RvcF9rX2luZGljZXNfYmF0Y2hlZChkc193aXRoX2VtYmVkZGluZ3MlMkMlMjB0ZXh0X2VtYmVkcyUyQyUyMHByb2Nlc3NvciUyQyUyMGslM0QzJTJDJTIwYmF0Y2hfc2l6ZSUzRDQpJTBBcHJpbnQoaW5kaWNlcyUyQyUyMHNjb3Jlcyk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
  text_embeds = model(**processor(text=<span class="hljs-string">&quot;a document about Mars expedition&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).embeddings
indices, scores = find_top_k_indices_batched(ds_with_embeddings, text_embeds, processor, k=<span class="hljs-number">3</span>, batch_size=<span class="hljs-number">4</span>)
<span class="hljs-built_in">print</span>(indices, scores)`,wrap:!1}}),Y=new u({props:{code:"KCU1QjQ0MCUyQyUyMDQ0MiUyQyUyMDQ0MyU1RCUyQyUwQSUyMCU1QjE0LjM3MDc4NjY2Njg3MDExNyUyQyUwQSUyMCUyMDEzLjY3NTQ4NzUxODMxMDU0NyUyQyUwQSUyMCUyMDEyLjk4OTkzMjA2MDI0MTclNUQp",highlighted:`([<span class="hljs-name">440</span>, <span class="hljs-number">442</span>, <span class="hljs-number">443</span>],
 [<span class="hljs-name">14.370786666870117</span>,
  <span class="hljs-number">13.675487518310547</span>,
  <span class="hljs-number">12.9899320602417</span>])`,wrap:!1}}),F=new u({props:{code:"Zm9yJTIwaSUyMGluJTIwaW5kaWNlcyUzQSUwQSUyMCUyMGRpc3BsYXkoZGF0YXNldCU1QmklNUQlNUIlMjJpbWFnZSUyMiU1RCk=",highlighted:`<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> indices:
  display(dataset[i][<span class="hljs-string">&quot;image&quot;</span>])`,wrap:!1}}),E=new Ae({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/visual_document_retrieval.md"}}),{c(){i=p("meta"),j=a(),h=p("p"),q=a(),r(U.$$.fragment),H=a(),T=p("p"),T.textContent=Ue,D=a(),f=p("p"),f.textContent=Te,P=a(),C=p("p"),C.innerHTML=fe,K=a(),r(b.$$.fragment),L=a(),g=p("p"),g.textContent=Ce,O=a(),r(I.$$.fragment),ee=a(),_=p("p"),_.innerHTML=ge,se=a(),r(k.$$.fragment),te=a(),r(x.$$.fragment),le=a(),Z=p("p"),Z.textContent=Ie,ae=a(),r(v.$$.fragment),ne=a(),$=p("p"),$.innerHTML=_e,ie=a(),r(G.$$.fragment),pe=a(),R=p("p"),R.textContent=ke,oe=a(),W=p("p"),W.innerHTML=xe,ce=a(),r(X.$$.fragment),re=a(),N=p("p"),N.textContent=Ze,de=a(),r(B.$$.fragment),me=a(),Q=p("p"),Q.textContent=ve,Me=a(),r(V.$$.fragment),ye=a(),r(Y.$$.fragment),Je=a(),z=p("p"),z.textContent=$e,he=a(),r(F.$$.fragment),ue=a(),w=p("div"),w.innerHTML=Ge,we=a(),r(E.$$.fragment),be=a(),S=p("p"),this.h()},l(e){const s=Fe("svelte-u9bgzb",document.head);i=o(s,"META",{name:!0,content:!0}),s.forEach(t),j=n(e),h=o(e,"P",{}),We(h).forEach(t),q=n(e),d(U.$$.fragment,e),H=n(e),T=o(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-10qzjz4"&&(T.textContent=Ue),D=n(e),f=o(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1t9gk3d"&&(f.textContent=Te),P=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-xgcmqq"&&(C.innerHTML=fe),K=n(e),d(b.$$.fragment,e),L=n(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-fb0qzh"&&(g.textContent=Ce),O=n(e),d(I.$$.fragment,e),ee=n(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1vp4ogz"&&(_.innerHTML=ge),se=n(e),d(k.$$.fragment,e),te=n(e),d(x.$$.fragment,e),le=n(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1sbq1d0"&&(Z.textContent=Ie),ae=n(e),d(v.$$.fragment,e),ne=n(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1htxcec"&&($.innerHTML=_e),ie=n(e),d(G.$$.fragment,e),pe=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-r0q688"&&(R.textContent=ke),oe=n(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-anvmq7"&&(W.innerHTML=xe),ce=n(e),d(X.$$.fragment,e),re=n(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-s8v7ww"&&(N.textContent=Ze),de=n(e),d(B.$$.fragment,e),me=n(e),Q=o(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-dr294z"&&(Q.textContent=ve),Me=n(e),d(V.$$.fragment,e),ye=n(e),d(Y.$$.fragment,e),Je=n(e),z=o(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-sfwoi"&&(z.textContent=$e),he=n(e),d(F.$$.fragment,e),ue=n(e),w=o(e,"DIV",{style:!0,"data-svelte-h":!0}),c(w)!=="svelte-11pj4z2"&&(w.innerHTML=Ge),we=n(e),d(E.$$.fragment,e),be=n(e),S=o(e,"P",{}),We(S).forEach(t),this.h()},h(){Xe(i,"name","hf:doc:metadata"),Xe(i,"content",Pe),Ne(w,"display","flex"),Ne(w,"align-items","center")},m(e,s){Ee(document.head,i),l(e,j,s),l(e,h,s),l(e,q,s),m(U,e,s),l(e,H,s),l(e,T,s),l(e,D,s),l(e,f,s),l(e,P,s),l(e,C,s),l(e,K,s),m(b,e,s),l(e,L,s),l(e,g,s),l(e,O,s),m(I,e,s),l(e,ee,s),l(e,_,s),l(e,se,s),m(k,e,s),l(e,te,s),m(x,e,s),l(e,le,s),l(e,Z,s),l(e,ae,s),m(v,e,s),l(e,ne,s),l(e,$,s),l(e,ie,s),m(G,e,s),l(e,pe,s),l(e,R,s),l(e,oe,s),l(e,W,s),l(e,ce,s),m(X,e,s),l(e,re,s),l(e,N,s),l(e,de,s),m(B,e,s),l(e,me,s),l(e,Q,s),l(e,Me,s),m(V,e,s),l(e,ye,s),m(Y,e,s),l(e,Je,s),l(e,z,s),l(e,he,s),m(F,e,s),l(e,ue,s),l(e,w,s),l(e,we,s),m(E,e,s),l(e,be,s),l(e,S,s),je=!0},p(e,[s]){const Re={};s&2&&(Re.$$scope={dirty:s,ctx:e}),b.$set(Re)},i(e){je||(M(U.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(k.$$.fragment,e),M(x.$$.fragment,e),M(v.$$.fragment,e),M(G.$$.fragment,e),M(X.$$.fragment,e),M(B.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(E.$$.fragment,e),je=!0)},o(e){y(U.$$.fragment,e),y(b.$$.fragment,e),y(I.$$.fragment,e),y(k.$$.fragment,e),y(x.$$.fragment,e),y(v.$$.fragment,e),y(G.$$.fragment,e),y(X.$$.fragment,e),y(B.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(E.$$.fragment,e),je=!1},d(e){e&&(t(j),t(h),t(q),t(H),t(T),t(D),t(f),t(P),t(C),t(K),t(L),t(g),t(O),t(ee),t(_),t(se),t(te),t(le),t(Z),t(ae),t(ne),t($),t(ie),t(pe),t(R),t(oe),t(W),t(ce),t(re),t(N),t(de),t(me),t(Q),t(Me),t(ye),t(Je),t(z),t(he),t(ue),t(w),t(we),t(be),t(S)),t(i),J(U,e),J(b,e),J(I,e),J(k,e),J(x,e),J(v,e),J(G,e),J(X,e),J(B,e),J(V,e),J(Y,e),J(F,e),J(E,e)}}}const Pe='{"title":"Visual document retrieval","local":"visual-document-retrieval","sections":[],"depth":1}';function Ke(A){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends Ye{constructor(i){super(),ze(this,i,Ke,De,Be,{})}}export{as as component};
