import{s as At,n as Ht,o as Qt}from"../chunks/scheduler.18a86fab.js";import{S as St,i as zt,g as o,s as a,r as p,A as xt,h as i,f as e,c as l,j as Et,u as r,x as c,k as Yt,y as Lt,a as s,v as m,d as M,t as y,w as d}from"../chunks/index.98837b22.js";import{C as Q}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as S}from"../chunks/Heading.7e7e0c5b.js";import{E as qt}from"../chunks/getInferenceSnippets.de10bc7d.js";function Ot(Zt){let h,L,z,q,u,O,w,kt=`This page describes how to use the <code>AttentionInterface</code> in order to register custom attention functions to use with
supported models.`,D,f,K,j,It=`Most recent models can now switch from one attention function used in the Attention layer to the other, thanks to a simple mapping.
By default, we provide the implementation for <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>sdpa</code></a>,
<a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow"><code>flash_attention_2</code></a> and <a href="https://pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow"><code>flex_attention</code></a>
as well as <code>eager</code>, which is a simple matrix multiplication without any optimization on top.<br/>
This is the setting you can usually choose when instantiating a model:`,P,b,tt,T,Bt=`But what if you wanted to create your own attention function? Or simply play around with existing ones, adding
a few statements here and there? You can now do so with the <code>AttentionInterface</code>! Here is an example:`,nt,J,et,U,_t="You will see it prints “I just entered the attention computation” as many times as there are layers in the model (with this example, 16 times).",st,g,at,Z,Gt="You could dynamically change the model’s attention function as well, by overriding the <code>config._attn_implementation</code> field:",lt,k,ot,I,Ct=`and it will stop printing the statements, as it now uses the <code>sdpa</code> attention.<br/>
This allows to quickly change an attention function, without needing to reload the model!`,it,B,pt,_,Rt=`But indeed, what if the new function requires a new arg to be properly used? It’s no issue! Models supporting the
<code>AttentionInterface</code> propagate kwargs all the way to the Attention layers, and to the used attention function. That way,
you can simply pass the arg (as a kwargs, i.e. you need to qualify the name of the arg) in the model’s forward, and it will be correctly used in the attention. However, custom attention functions have some limitations. In particular, it must follow the signature and return format of other attention functions, i.e.`,rt,G,ct,C,Xt='If in doubt about what args/kwargs a given model sends to the attention function, simply check that model’s modeling code on <a href="https://github.com/huggingface/transformers/tree/main/src/transformers/models" rel="nofollow">GitHub</a>!',mt,R,Mt,X,Wt=`Most of the time, you will simply need to <code>register</code> a new function. If, however, you need to access an existing one,
and/or perform a few checks, the preferred way is to use the global <code>ALL_ATTENTION_FUNCTIONS</code>. It behaves the same way you
would expect from a usual Python dictionary:`,yt,W,dt,v,ht,$,vt=`Having a new attention function may mean that you need a new format of attention mask to decide what key and value tokens
the query tokens should attend to. This is now possible with the <code>AttentionMaskInterface</code>! It works in the same way as
the <code>AttentionInterface</code>:`,ut,F,wt,V,$t=`The reason you have to register it is because we need to automatically correct your mask format based on the attention implementation (for example, flex attention uses a BlockMask format, while sdpa uses a 4D tensor).
By default, if you do not register an attention mask function along with your attention function, mask creation will be skipped
and <code>attention_mask=None</code> will be passed along to the Attention layers.`,ft,N,Ft="The default signature of the attention mask functions is the following:",jt,E,bt,Y,Vt='It mostly works thanks to the <code>mask_function</code>, which is a <code>Callable</code> in the form of <a href="https://pytorch.org/blog/flexattention/" rel="nofollow">torch’s mask_mod functions</a>, taking 4 indices as input and returning a boolean to indicate if this position should take part in the attention computation.',Tt,A,Nt='If you cannot use the <code>mask_function</code> to create your mask for some reason, you can try to work around it by doing something similar to our <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/executorch.py" rel="nofollow">torch export workaround</a>.',Jt,H,Ut,x,gt;return u=new S({props:{title:"Attention Interface",local:"attention-interface",headingTag:"h1"}}),f=new S({props:{title:"Customizing attention function",local:"customizing-attention-function",headingTag:"h2"}}),b=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTFCJTIyJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHVzaW5nJTIwZmxhc2glMjBhdHRlbnRpb24lMjBhcyUyMGFuJTIwZXhhbXBsZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>

<span class="hljs-comment"># Here, using flash attention as an example</span>
model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)`,wrap:!1}}),J=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXR0ZW50aW9uSW50ZXJmYWNlJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24lMjBpbXBvcnQlMjBzZHBhX2F0dGVudGlvbl9mb3J3YXJkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItMUIlMjIlMEElMEFkZWYlMjBteV9uZXdfc2RwYSgqYXJncyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkklMjBqdXN0JTIwZW50ZXJlZCUyMHRoZSUyMGF0dGVudGlvbiUyMGNvbXB1dGF0aW9uJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNkcGFfYXR0ZW50aW9uX2ZvcndhcmQoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMEFBdHRlbnRpb25JbnRlcmZhY2UucmVnaXN0ZXIoJTIybXlfbmV3X3NkcGElMjIlMkMlMjBteV9uZXdfc2RwYSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJteV9uZXdfc2RwYSUyMiklMEElMjMlMjBUcnklMjBydW5uaW5nJTIwdGhlJTIwZm9yd2FyZCUyMHdpdGglMjB0aGUlMjBuZXclMjBhdHRlbnRpb24lMjBmdW5jdGlvbiUwQW1vZGVsKHRvcmNoLm9uZXMoMSUyQyUyMDUlMkMlMjBkdHlwZSUzRGludCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AttentionInterface
<span class="hljs-keyword">from</span> transformers.integrations.sdpa_attention <span class="hljs-keyword">import</span> sdpa_attention_forward
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_sdpa</span>(<span class="hljs-params">*args, **kwargs</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I just entered the attention computation&quot;</span>)
    <span class="hljs-keyword">return</span> sdpa_attention_forward(*args, **kwargs)

AttentionInterface.register(<span class="hljs-string">&quot;my_new_sdpa&quot;</span>, my_new_sdpa)

model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;my_new_sdpa&quot;</span>)
<span class="hljs-comment"># Try running the forward with the new attention function</span>
model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>))`,wrap:!1}}),g=new S({props:{title:"Dynamically switching attention function",local:"dynamically-switching-attention-function",headingTag:"h2"}}),k=new Q({props:{code:"JTIzJTIwQmFjayUyMHRvJTIwdXNlJTIwb3JpZ2luYWwlMjBzZHBhJTIwaW1wbGVtZW50YXRpb24lMEFtb2RlbC5jb25maWcuX2F0dG5faW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzZHBhJTIyJTBBJTBBbW9kZWwodG9yY2gub25lcygxJTJDJTIwNSUyQyUyMGR0eXBlJTNEaW50KSk=",highlighted:`<span class="hljs-comment"># Back to use original sdpa implementation</span>
model.config._attn_implementation = <span class="hljs-string">&quot;sdpa&quot;</span>

model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>))`,wrap:!1}}),B=new S({props:{title:"What about new args needed in my custom attention function?",local:"what-about-new-args-needed-in-my-custom-attention-function",headingTag:"h2"}}),G=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXR0ZW50aW9uSW50ZXJmYWNlJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24lMjBpbXBvcnQlMjBzZHBhX2F0dGVudGlvbl9mb3J3YXJkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjdXN0b21fYXR0ZW50aW9uKCUwQSUyMCUyMCUyMCUyMG1vZHVsZSUzQSUyMHRvcmNoLm5uLk1vZHVsZSUyQyUyMCUyMCUyMyUyMHJlcXVpcmVkJTIwYXJnJTBBJTIwJTIwJTIwJTIwcXVlcnklM0ElMjB0b3JjaC5UZW5zb3IlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGtleSUzQSUyMHRvcmNoLlRlbnNvciUyQyUyMCUyMCUyMyUyMHJlcXVpcmVkJTIwYXJnJTBBJTIwJTIwJTIwJTIwdmFsdWUlM0ElMjB0b3JjaC5UZW5zb3IlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5UZW5zb3IlNUQlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGFfbmV3X2t3YXJncyUyMCUzRCUyME5vbmUlMkMlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBub3clMjBhZGQlMjBhcyUyMG1hbnklMjBrd2FyZ3MlMjBhcyUyMHlvdSUyMG5lZWQlMEElMjAlMjAlMjAlMjBhbm90aGVyX25ld19rd2FyZ3MlMjAlM0QlMjBOb25lJTJDJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwbm93JTIwYWRkJTIwYXMlMjBtYW55JTIwa3dhcmdzJTIwYXMlMjB5b3UlMjBuZWVkJTBBJTIwJTIwJTIwJTIwKiprd2FyZ3MlMkMlMjAlMjAlMjMlMjBZb3UlMjBuZWVkJTIwdG8lMjBhY2NlcHQlMjAqKmt3YXJncyUyMGFzJTIwbW9kZWxzJTIwd2lsbCUyMHBhc3MlMjBvdGhlciUyMGFyZ3MlMEEpJTIwLSUzRSUyMFR1cGxlJTVCdG9yY2guVGVuc29yJTJDJTIwT3B0aW9uYWwlNUJ0b3JjaC5UZW5zb3IlNUQlNUQlMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjMlMjBkbyUyMHlvdXIlMjBtYWdpYyElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhdHRuX291dHB1dCUyQyUyMGF0dG5fd2VpZ2h0cyUyMCUyMCUyMyUyMGF0dG5fd2VpZ2h0cyUyMGFyZSUyMG9wdGlvbmFsJTIwaGVyZSUwQSUwQUF0dGVudGlvbkludGVyZmFjZS5yZWdpc3RlciglMjJjdXN0b20lMjIlMkMlMjBjdXN0b21fYXR0ZW50aW9uKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmN1c3RvbSUyMiklMEElMjMlMjBGb3J3YXJkJTIwcGFzcyUyMHdpdGglMjB0aGUlMjBuZXclMjBrd2FyZ3MlMEFtb2RlbCh0b3JjaC5vbmVzKDElMkMlMjA1JTJDJTIwZHR5cGUlM0RpbnQpJTJDJTIwYV9uZXdfa3dhcmdzJTNELi4uJTJDJTIwYW5vdGhlcl9uZXdfa3dhcmdzJTNELi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AttentionInterface
<span class="hljs-keyword">from</span> transformers.integrations.sdpa_attention <span class="hljs-keyword">import</span> sdpa_attention_forward
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_attention</span>(<span class="hljs-params">
    module: torch.nn.Module,  <span class="hljs-comment"># required arg</span>
    query: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    key: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    value: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],  <span class="hljs-comment"># required arg</span>
    a_new_kwargs = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># You can now add as many kwargs as you need</span>
    another_new_kwargs = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># You can now add as many kwargs as you need</span>
    **kwargs,  <span class="hljs-comment"># You need to accept **kwargs as models will pass other args</span>
</span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor]]
    ...  <span class="hljs-comment"># do your magic!</span>
    <span class="hljs-keyword">return</span> attn_output, attn_weights  <span class="hljs-comment"># attn_weights are optional here</span>

AttentionInterface.register(<span class="hljs-string">&quot;custom&quot;</span>, custom_attention)

model = AutoModelForCausalLM.from_pretrained(model_id, attn_implementation=<span class="hljs-string">&quot;custom&quot;</span>)
<span class="hljs-comment"># Forward pass with the new kwargs</span>
model(torch.ones(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, dtype=<span class="hljs-built_in">int</span>), a_new_kwargs=..., another_new_kwargs=...)`,wrap:!1}}),R=new S({props:{title:"Accessing current available implementations",local:"accessing-current-available-implementations",headingTag:"h2"}}),W=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ191dGlscyUyMGltcG9ydCUyMEFMTF9BVFRFTlRJT05fRlVOQ1RJT05TJTBBJTBBbGlzdChBTExfQVRURU5USU9OX0ZVTkNUSU9OUy5rZXlzKCkpJTBBJTVCJ2ZsYXNoX2F0dGVudGlvbl8yJyUyQyUyMCdmbGV4X2F0dGVudGlvbiclMkMlMjAnc2RwYSclNUQlMEElMEFBTExfQVRURU5USU9OX0ZVTkNUSU9OUyU1QiUyMnNkcGElMjIlNUQlMEElM0NmdW5jdGlvbiUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24uc2RwYV9hdHRlbnRpb25fZm9yd2FyZCUzRSUwQSUwQUFMTF9BVFRFTlRJT05fRlVOQ1RJT05TLmdldCglMjJzZHBhJTIyJTJDJTIwTm9uZSklMEElM0NmdW5jdGlvbiUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMuc2RwYV9hdHRlbnRpb24uc2RwYV9hdHRlbnRpb25fZm9yd2FyZCUzRSUwQSUwQUFMTF9BVFRFTlRJT05fRlVOQ1RJT05TLnJlZ2lzdGVyKCUyMm5ld19mdW5jJTIyJTJDJTIwbmV3X2Z1bmMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.modeling_utils <span class="hljs-keyword">import</span> ALL_ATTENTION_FUNCTIONS

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(ALL_ATTENTION_FUNCTIONS.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span>[<span class="hljs-string">&#x27;flash_attention_2&#x27;</span>, <span class="hljs-string">&#x27;flex_attention&#x27;</span>, <span class="hljs-string">&#x27;sdpa&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS[<span class="hljs-string">&quot;sdpa&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>&lt;function transformers.integrations.sdpa_attention.sdpa_attention_forward&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS.get(<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>&lt;function transformers.integrations.sdpa_attention.sdpa_attention_forward&gt;

<span class="hljs-comment"># You can also globally \`register\` a new function directly on it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_ATTENTION_FUNCTIONS.register(<span class="hljs-string">&quot;new_func&quot;</span>, new_func)`,wrap:!1}}),v=new S({props:{title:"Attention Mask Interface",local:"attention-mask-interface",headingTag:"h2"}}),F=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF0dGVudGlvbk1hc2tJbnRlcmZhY2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1hc2tpbmdfdXRpbHMlMjBpbXBvcnQlMjBzZHBhX21hc2slMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMG15X25ld19zZHBhX21hc2soKmFyZ3MlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJJJTIwanVzdCUyMGVudGVyZWQlMjB0aGUlMjBhdHRlbnRpb24lMjBtYXNrJTIwY29tcHV0YXRpb24lMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2RwYV9tYXNrKCphcmdzJTJDJTIwKiprd2FyZ3MpJTBBJTBBQXR0ZW50aW9uTWFza0ludGVyZmFjZS5yZWdpc3RlciglMjJteV9uZXdfc2RwYV9tYXNrJTIyJTJDJTIwbXlfbmV3X3NkcGFfbWFzayk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AttentionMaskInterface
<span class="hljs-keyword">from</span> transformers.masking_utils <span class="hljs-keyword">import</span> sdpa_mask
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_sdpa_mask</span>(<span class="hljs-params">*args, **kwargs</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I just entered the attention mask computation&quot;</span>)
    <span class="hljs-keyword">return</span> sdpa_mask(*args, **kwargs)

AttentionMaskInterface.register(<span class="hljs-string">&quot;my_new_sdpa_mask&quot;</span>, my_new_sdpa_mask)`,wrap:!1}}),E=new Q({props:{code:"ZGVmJTIwY3VzdG9tX2F0dGVudGlvbl9tYXNrKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0ElMjBpbnQlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGNhY2hlX3Bvc2l0aW9uJTNBJTIwdG9yY2guVGVuc29yJTJDJTIwJTIwJTIzJTIwcmVxdWlyZWQlMjBhcmclMEElMjAlMjAlMjAlMjBrdl9sZW5ndGglM0ElMjBpbnQlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMGt2X29mZnNldCUzQSUyMGludCUyMCUzRCUyMDAlMkMlMjAlMjAlMjMlMjByZXF1aXJlZCUyMGFyZyUwQSUyMCUyMCUyMCUyMG1hc2tfZnVuY3Rpb24lM0ElMjBDYWxsYWJsZSUyMCUzRCUyMGNhdXNhbF9tYXNrX2Z1bmN0aW9uJTJDJTIwJTIwJTIzJTIwcmVxdWlyZWQlMjBhcmclMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUyMCUyMCUyMyUyMHJlcXVpcmVkJTIwYXJnJTBBJTIwJTIwJTIwJTIwKiprd2FyZ3MlMkMlMjAlMjAlMjMlMjBhJTIwZmV3JTIwYWRkaXRpb25hbCUyMGFyZ3MlMjBtYXklMjBiZSUyMHBhc3NlZCUyMGFzJTIwa3dhcmdzJTJDJTIwZXNwZWNpYWxseSUyMHRoZSUyMG1vZGVsJ3MlMjBjb25maWclMjBpcyUyMGFsd2F5cyUyMHBhc3NlZCUwQSklMjAtJTNFJTIwT3B0aW9uYWwlNUJ0b3JjaC5UZW5zb3IlNUQlM0E=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_attention_mask</span>(<span class="hljs-params">
    batch_size: <span class="hljs-built_in">int</span>,  <span class="hljs-comment"># required arg</span>
    cache_position: torch.Tensor,  <span class="hljs-comment"># required arg</span>
    kv_length: <span class="hljs-built_in">int</span>,  <span class="hljs-comment"># required arg</span>
    kv_offset: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,  <span class="hljs-comment"># required arg</span>
    mask_function: <span class="hljs-type">Callable</span> = causal_mask_function,  <span class="hljs-comment"># required arg</span>
    attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># required arg</span>
    **kwargs,  <span class="hljs-comment"># a few additional args may be passed as kwargs, especially the model&#x27;s config is always passed</span>
</span>) -&gt; <span class="hljs-type">Optional</span>[torch.Tensor]:`,wrap:!1}}),H=new qt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/attention_interface.md"}}),{c(){h=o("meta"),L=a(),z=o("p"),q=a(),p(u.$$.fragment),O=a(),w=o("p"),w.innerHTML=kt,D=a(),p(f.$$.fragment),K=a(),j=o("p"),j.innerHTML=It,P=a(),p(b.$$.fragment),tt=a(),T=o("p"),T.innerHTML=Bt,nt=a(),p(J.$$.fragment),et=a(),U=o("p"),U.textContent=_t,st=a(),p(g.$$.fragment),at=a(),Z=o("p"),Z.innerHTML=Gt,lt=a(),p(k.$$.fragment),ot=a(),I=o("p"),I.innerHTML=Ct,it=a(),p(B.$$.fragment),pt=a(),_=o("p"),_.innerHTML=Rt,rt=a(),p(G.$$.fragment),ct=a(),C=o("p"),C.innerHTML=Xt,mt=a(),p(R.$$.fragment),Mt=a(),X=o("p"),X.innerHTML=Wt,yt=a(),p(W.$$.fragment),dt=a(),p(v.$$.fragment),ht=a(),$=o("p"),$.innerHTML=vt,ut=a(),p(F.$$.fragment),wt=a(),V=o("p"),V.innerHTML=$t,ft=a(),N=o("p"),N.textContent=Ft,jt=a(),p(E.$$.fragment),bt=a(),Y=o("p"),Y.innerHTML=Vt,Tt=a(),A=o("p"),A.innerHTML=Nt,Jt=a(),p(H.$$.fragment),Ut=a(),x=o("p"),this.h()},l(t){const n=xt("svelte-u9bgzb",document.head);h=i(n,"META",{name:!0,content:!0}),n.forEach(e),L=l(t),z=i(t,"P",{}),Et(z).forEach(e),q=l(t),r(u.$$.fragment,t),O=l(t),w=i(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-q2swd"&&(w.innerHTML=kt),D=l(t),r(f.$$.fragment,t),K=l(t),j=i(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-tb8yar"&&(j.innerHTML=It),P=l(t),r(b.$$.fragment,t),tt=l(t),T=i(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-6n784k"&&(T.innerHTML=Bt),nt=l(t),r(J.$$.fragment,t),et=l(t),U=i(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-seluzu"&&(U.textContent=_t),st=l(t),r(g.$$.fragment,t),at=l(t),Z=i(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-avcttm"&&(Z.innerHTML=Gt),lt=l(t),r(k.$$.fragment,t),ot=l(t),I=i(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1fjssz0"&&(I.innerHTML=Ct),it=l(t),r(B.$$.fragment,t),pt=l(t),_=i(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1mzkqc4"&&(_.innerHTML=Rt),rt=l(t),r(G.$$.fragment,t),ct=l(t),C=i(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-upb3ef"&&(C.innerHTML=Xt),mt=l(t),r(R.$$.fragment,t),Mt=l(t),X=i(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-7h0zcj"&&(X.innerHTML=Wt),yt=l(t),r(W.$$.fragment,t),dt=l(t),r(v.$$.fragment,t),ht=l(t),$=i(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-15uniki"&&($.innerHTML=vt),ut=l(t),r(F.$$.fragment,t),wt=l(t),V=i(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-7vvru9"&&(V.innerHTML=$t),ft=l(t),N=i(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-10po5zn"&&(N.textContent=Ft),jt=l(t),r(E.$$.fragment,t),bt=l(t),Y=i(t,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1gqwmwq"&&(Y.innerHTML=Vt),Tt=l(t),A=i(t,"P",{"data-svelte-h":!0}),c(A)!=="svelte-ks3jto"&&(A.innerHTML=Nt),Jt=l(t),r(H.$$.fragment,t),Ut=l(t),x=i(t,"P",{}),Et(x).forEach(e),this.h()},h(){Yt(h,"name","hf:doc:metadata"),Yt(h,"content",Dt)},m(t,n){Lt(document.head,h),s(t,L,n),s(t,z,n),s(t,q,n),m(u,t,n),s(t,O,n),s(t,w,n),s(t,D,n),m(f,t,n),s(t,K,n),s(t,j,n),s(t,P,n),m(b,t,n),s(t,tt,n),s(t,T,n),s(t,nt,n),m(J,t,n),s(t,et,n),s(t,U,n),s(t,st,n),m(g,t,n),s(t,at,n),s(t,Z,n),s(t,lt,n),m(k,t,n),s(t,ot,n),s(t,I,n),s(t,it,n),m(B,t,n),s(t,pt,n),s(t,_,n),s(t,rt,n),m(G,t,n),s(t,ct,n),s(t,C,n),s(t,mt,n),m(R,t,n),s(t,Mt,n),s(t,X,n),s(t,yt,n),m(W,t,n),s(t,dt,n),m(v,t,n),s(t,ht,n),s(t,$,n),s(t,ut,n),m(F,t,n),s(t,wt,n),s(t,V,n),s(t,ft,n),s(t,N,n),s(t,jt,n),m(E,t,n),s(t,bt,n),s(t,Y,n),s(t,Tt,n),s(t,A,n),s(t,Jt,n),m(H,t,n),s(t,Ut,n),s(t,x,n),gt=!0},p:Ht,i(t){gt||(M(u.$$.fragment,t),M(f.$$.fragment,t),M(b.$$.fragment,t),M(J.$$.fragment,t),M(g.$$.fragment,t),M(k.$$.fragment,t),M(B.$$.fragment,t),M(G.$$.fragment,t),M(R.$$.fragment,t),M(W.$$.fragment,t),M(v.$$.fragment,t),M(F.$$.fragment,t),M(E.$$.fragment,t),M(H.$$.fragment,t),gt=!0)},o(t){y(u.$$.fragment,t),y(f.$$.fragment,t),y(b.$$.fragment,t),y(J.$$.fragment,t),y(g.$$.fragment,t),y(k.$$.fragment,t),y(B.$$.fragment,t),y(G.$$.fragment,t),y(R.$$.fragment,t),y(W.$$.fragment,t),y(v.$$.fragment,t),y(F.$$.fragment,t),y(E.$$.fragment,t),y(H.$$.fragment,t),gt=!1},d(t){t&&(e(L),e(z),e(q),e(O),e(w),e(D),e(K),e(j),e(P),e(tt),e(T),e(nt),e(et),e(U),e(st),e(at),e(Z),e(lt),e(ot),e(I),e(it),e(pt),e(_),e(rt),e(ct),e(C),e(mt),e(Mt),e(X),e(yt),e(dt),e(ht),e($),e(ut),e(wt),e(V),e(ft),e(N),e(jt),e(bt),e(Y),e(Tt),e(A),e(Jt),e(Ut),e(x)),e(h),d(u,t),d(f,t),d(b,t),d(J,t),d(g,t),d(k,t),d(B,t),d(G,t),d(R,t),d(W,t),d(v,t),d(F,t),d(E,t),d(H,t)}}}const Dt='{"title":"Attention Interface","local":"attention-interface","sections":[{"title":"Customizing attention function","local":"customizing-attention-function","sections":[],"depth":2},{"title":"Dynamically switching attention function","local":"dynamically-switching-attention-function","sections":[],"depth":2},{"title":"What about new args needed in my custom attention function?","local":"what-about-new-args-needed-in-my-custom-attention-function","sections":[],"depth":2},{"title":"Accessing current available implementations","local":"accessing-current-available-implementations","sections":[],"depth":2},{"title":"Attention Mask Interface","local":"attention-mask-interface","sections":[],"depth":2}],"depth":1}';function Kt(Zt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class an extends St{constructor(h){super(),zt(this,h,Kt,Ot,At,{})}}export{an as component};
