import{s as xt,o as jt,n as Se}from"../chunks/scheduler.18a86fab.js";import{S as Ft,i as Jt,g as d,s as o,r as m,A as It,h as c,f as n,c as s,j as de,u as p,x as _,k as ce,y as l,a,v as h,d as u,t as f,w as g}from"../chunks/index.98837b22.js";import{T as zt}from"../chunks/Tip.77304350.js";import{D as we}from"../chunks/Docstring.6758ea23.js";import{C as Qe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Ut}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as j}from"../chunks/Heading.7e7e0c5b.js";import{E as Lt}from"../chunks/getInferenceSnippets.de10bc7d.js";function Zt(U){let i,y;return i=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdE5ldE1vZGVsJTJDJTIwQml0TmV0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJpdE5ldCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCaXROZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBCaXROZXQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEJpdE5ldE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitNetModel, BitNetConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BitNet style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BitNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the BitNet style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(i.$$.fragment)},l(r){p(i.$$.fragment,r)},m(r,M){h(i,r,M),y=!0},p:Se,i(r){y||(u(i.$$.fragment,r),y=!0)},o(r){f(i.$$.fragment,r),y=!1},d(r){g(i,r)}}}function qt(U){let i,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=d("p"),i.innerHTML=y},l(r){i=c(r,"P",{"data-svelte-h":!0}),_(i)!=="svelte-fincs2"&&(i.innerHTML=y)},m(r,M){a(r,i,M)},p:Se,d(r){r&&n(i)}}}function Wt(U){let i,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=d("p"),i.innerHTML=y},l(r){i=c(r,"P",{"data-svelte-h":!0}),_(i)!=="svelte-fincs2"&&(i.innerHTML=y)},m(r,M){a(r,i,M)},p:Se,d(r){r&&n(i)}}}function Gt(U){let i,y="Example:",r,M,N;return M=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaXROZXRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQml0TmV0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpdG5ldC1iMS41OC0yQi00VCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaXRuZXQtYjEuNTgtMkItNFQlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwZiclM0MlN0NiZWdpbl9vZl90ZXh0JTdDJTNFVXNlciUzQSUyMEhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTNDJTdDZW90X2lkJTdDJTNFQXNzaXN0YW50JTNBJTIwJyUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QxMDApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BitNetForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitNetForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&#x27;&lt;|begin_of_text|&gt;User: Hey, are you conscious? Can you talk to me?&lt;|eot_id|&gt;Assistant: &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;User: Hey, are you conscious? Can you talk to me?Assistant: No, I&#x27;m not conscious. I&#x27;m an artificial intelligence designed to assist with information and tasks. How can I help you today?&quot;</span>`,wrap:!1}}),{c(){i=d("p"),i.textContent=y,r=o(),m(M.$$.fragment)},l(b){i=c(b,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=y),r=s(b),p(M.$$.fragment,b)},m(b,C){a(b,i,C),a(b,r,C),h(M,b,C),N=!0},p:Se,i(b){N||(u(M.$$.fragment,b),N=!0)},o(b){f(M.$$.fragment,b),N=!1},d(b){b&&(n(i),n(r)),g(M,b)}}}function Et(U){let i,y,r,M,N,b,C,ve,W,mt="Trained on a corpus of 4 trillion tokens, this model demonstrates that native 1-bit LLMs can achieve performance comparable to leading open-weight, full-precision models of similar size, while offering substantial advantages in computational efficiency (memory, energy, latency).",ke,G,pt='➡️ <strong>Technical Report:</strong> <a href="https://arxiv.org/abs/2504.12285" rel="nofollow">BitNet b1.58 2B4T Technical Report</a>',$e,E,ht='➡️ <strong>Official Inference Code:</strong> <a href="https://github.com/microsoft/BitNet" rel="nofollow">microsoft/BitNet (bitnet.cpp)</a>',Ne,R,Be,H,ut="Several versions of the model weights are available on Hugging Face:",Ce,P,ft='<li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T</code></strong></a>: Contains the packed 1.58-bit weights optimized for efficient inference. <strong>Use this for deployment.</strong></p></li> <li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T-bf16" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T-bf16</code></strong></a>: Contains the master weights in BF16 format. <strong>Use this only for training or fine-tuning purposes.</strong></p></li> <li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T-gguf" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T-gguf</code></strong></a>: Contains the model weights in GGUF format, compatible with the <code>bitnet.cpp</code> library for CPU inference.</p></li>',ze,X,Ue,V,gt='<li><strong>Architecture:</strong> Transformer-based, modified with <code>BitLinear</code> layers (BitNet framework).<ul><li>Uses Rotary Position Embeddings (RoPE).</li> <li>Uses squared ReLU (ReLU²) activation in FFN layers.</li> <li>Employs <a href="https://proceedings.mlr.press/v202/wang23u.html" rel="nofollow"><code>subln</code></a> normalization.</li> <li>No bias terms in linear or normalization layers.</li></ul></li> <li><strong>Quantization:</strong> Native 1.58-bit weights and 8-bit activations (W1.58A8).<ul><li>Weights are quantized to ternary values {-1, 0, +1} using absmean quantization during the forward pass.</li> <li>Activations are quantized to 8-bit integers using absmax quantization (per-token).</li> <li><strong>Crucially, the model was <em>trained from scratch</em> with this quantization scheme, not post-training quantized.</strong></li></ul></li> <li><strong>Parameters:</strong> ~2 Billion</li> <li><strong>Training Tokens:</strong> 4 Trillion</li> <li><strong>Context Length:</strong> Maximum sequence length of <strong>4096 tokens</strong>.<ul><li><em>Recommendation:</em> For optimal performance on tasks requiring very long contexts (beyond the pre-training length or for specialized long-reasoning tasks), we recommend performing intermediate long-sequence adaptation/training before the final fine-tuning stage.</li></ul></li> <li><strong>Training Stages:</strong><ol><li><strong>Pre-training:</strong> Large-scale training on public text/code and synthetic math data using a two-stage learning rate and weight decay schedule.</li> <li><strong>Supervised Fine-tuning (SFT):</strong> Fine-tuned on instruction-following and conversational datasets using sum loss aggregation and specific hyperparameter tuning.</li> <li><strong>Direct Preference Optimization (DPO):</strong> Aligned with human preferences using preference pairs.</li></ol></li> <li><strong>Tokenizer:</strong> LLaMA 3 Tokenizer (vocab size: 128,256).</li>',xe,Q,je,S,_t="<strong>VERY IMPORTANT NOTE ON EFFICIENCY</strong>",Fe,A,bt='<p>Please do NOT expect performance efficiency gains (in terms of speed, latency, or energy consumption) when using this model with the standard transformers library.</p> <p>The current execution paths within transformers do not contain the specialized, highly optimized computational kernels required to leverage the advantages of the BitNet architecture. Running the model via transformers will likely result in inference speeds and energy usage comparable to, or potentially worse than, standard full-precision models within this framework on both CPU and GPU.</p> <p>While you might observe reduced memory usage due to the quantized weights, the primary computational efficiency benefits are not accessible through this standard transformers usage path.</p> <p>For achieving the efficiency benefits demonstrated in the technical paper, you MUST use the dedicated C++ implementation: <a href="https://github.com/microsoft/BitNet" rel="nofollow">bitnet.cpp</a>.</p>',Je,O,Ie,Y,Le,D,Ze,K,qe,ee,We,v,te,Ae,me,yt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a>. It is used to instantiate an BitNet
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of
BitNet b1.58 2B4T <a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T" rel="nofollow">microsoft/bitnet-b1.58-2B-4T</a>.`,Oe,pe,Mt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ye,J,Ge,ne,Ee,T,oe,De,he,Tt="The bare Bitnet Model outputting raw hidden-states without any specific head on top.",Ke,ue,wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,et,fe,vt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tt,x,se,nt,ge,kt='The <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a> forward method, overrides the <code>__call__</code> special method.',ot,I,Re,ae,He,w,ie,st,_e,$t="The Bitnet Model for causal language modeling.",at,be,Nt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,it,ye,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rt,B,re,lt,Me,Ct='The <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetForCausalLM">BitNetForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',dt,L,ct,Z,Pe,le,Xe,Te,Ve;return N=new j({props:{title:"BitNet",local:"bitnet",headingTag:"h1"}}),C=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),R=new j({props:{title:"Model Variants",local:"model-variants",headingTag:"h2"}}),X=new j({props:{title:"Model Details",local:"model-details",headingTag:"h3"}}),Q=new j({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),O=new j({props:{title:"Requirements",local:"requirements",headingTag:"h3"}}),Y=new Qe({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),D=new j({props:{title:"Example",local:"example",headingTag:"h3"}}),K=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtaWNyb3NvZnQlMkZiaXRuZXQtYjEuNTgtMkItNFQlMjIlMEElMEElMjMlMjBMb2FkJTIwdG9rZW5pemVyJTIwYW5kJTIwbW9kZWwlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjB0aGUlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElNUQlMEFjaGF0X2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwcmVzcG9uc2UlMEFjaGF0X291dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShjaGF0X2lucHV0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFyZXNwb25zZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoY2hhdF9vdXRwdXRzJTVCMCU1RCU1QmNoYXRfaW5wdXQuc2hhcGUlNUItMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMCUyMyUyMERlY29kZSUyMG9ubHklMjB0aGUlMjByZXNwb25zZSUyMHBhcnQlMEFwcmludCglMjIlNUNuQXNzaXN0YW50JTIwUmVzcG9uc2UlM0ElMjIlMkMlMjByZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>

<span class="hljs-comment"># Load tokenizer and model</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># Apply the chat template</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful AI assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How are you?&quot;</span>},
]
chat_input = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate response</span>
chat_outputs = model.generate(chat_input, max_new_tokens=<span class="hljs-number">50</span>)
response = tokenizer.decode(chat_outputs[<span class="hljs-number">0</span>][chat_input.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-comment"># Decode only the response part</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nAssistant Response:&quot;</span>, response)`,wrap:!1}}),ee=new j({props:{title:"BitNetConfig",local:"transformers.BitNetConfig",headingTag:"h2"}}),te=new we({props:{name:"class transformers.BitNetConfig",anchor:"transformers.BitNetConfig",parameters:[{name:"vocab_size",val:" = 128256"},{name:"hidden_size",val:" = 2560"},{name:"intermediate_size",val:" = 6912"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 20"},{name:"num_key_value_heads",val:" = 5"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 128000"},{name:"eos_token_id",val:" = 128001"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 500000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitNetConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128256) &#x2014;
Vocabulary size of the BitNet model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a>`,name:"vocab_size"},{anchor:"transformers.BitNetConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2560) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.BitNetConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6912) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.BitNetConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.BitNetConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.BitNetConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details, check out [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.BitNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.BitNetConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.BitNetConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BitNetConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.BitNetConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.BitNetConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.BitNetConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128000) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.BitNetConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.BitNetConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.BitNetConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 500000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.BitNetConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.BitNetConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/configuration_bitnet.py#L23"}}),J=new Ut({props:{anchor:"transformers.BitNetConfig.example",$$slots:{default:[Zt]},$$scope:{ctx:U}}}),ne=new j({props:{title:"BitNetModel",local:"transformers.BitNetModel",headingTag:"h2"}}),oe=new we({props:{name:"class transformers.BitNetModel",anchor:"transformers.BitNetModel",parameters:[{name:"config",val:": BitNetConfig"}],parametersDescription:[{anchor:"transformers.BitNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetConfig">BitNetConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L343"}}),se=new we({props:{name:"forward",anchor:"transformers.BitNetModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.BitNetModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BitNetModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BitNetModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BitNetModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BitNetModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BitNetModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BitNetModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BitNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitNetModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetConfig"
>BitNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new zt({props:{$$slots:{default:[qt]},$$scope:{ctx:U}}}),ae=new j({props:{title:"BitNetForCausalLM",local:"transformers.BitNetForCausalLM",headingTag:"h2"}}),ie=new we({props:{name:"class transformers.BitNetForCausalLM",anchor:"transformers.BitNetForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BitNetForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetForCausalLM">BitNetForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L471"}}),re=new we({props:{name:"forward",anchor:"transformers.BitNetForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.bitnet.modeling_bitnet.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.BitNetForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BitNetForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BitNetForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BitNetForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BitNetForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BitNetForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, transformers., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, transformers., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.BitNetForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BitNetForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BitNetForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitNetForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.BitNetForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L504",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetConfig"
>BitNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new zt({props:{$$slots:{default:[Wt]},$$scope:{ctx:U}}}),Z=new Ut({props:{anchor:"transformers.BitNetForCausalLM.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:U}}}),le=new Lt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/bitnet.md"}}),{c(){i=d("meta"),y=o(),r=d("p"),M=o(),m(N.$$.fragment),b=o(),m(C.$$.fragment),ve=o(),W=d("p"),W.textContent=mt,ke=o(),G=d("p"),G.innerHTML=pt,$e=o(),E=d("p"),E.innerHTML=ht,Ne=o(),m(R.$$.fragment),Be=o(),H=d("p"),H.textContent=ut,Ce=o(),P=d("ul"),P.innerHTML=ft,ze=o(),m(X.$$.fragment),Ue=o(),V=d("ul"),V.innerHTML=gt,xe=o(),m(Q.$$.fragment),je=o(),S=d("p"),S.innerHTML=_t,Fe=o(),A=d("blockquote"),A.innerHTML=bt,Je=o(),m(O.$$.fragment),Ie=o(),m(Y.$$.fragment),Le=o(),m(D.$$.fragment),Ze=o(),m(K.$$.fragment),qe=o(),m(ee.$$.fragment),We=o(),v=d("div"),m(te.$$.fragment),Ae=o(),me=d("p"),me.innerHTML=yt,Oe=o(),pe=d("p"),pe.innerHTML=Mt,Ye=o(),m(J.$$.fragment),Ge=o(),m(ne.$$.fragment),Ee=o(),T=d("div"),m(oe.$$.fragment),De=o(),he=d("p"),he.textContent=Tt,Ke=o(),ue=d("p"),ue.innerHTML=wt,et=o(),fe=d("p"),fe.innerHTML=vt,tt=o(),x=d("div"),m(se.$$.fragment),nt=o(),ge=d("p"),ge.innerHTML=kt,ot=o(),m(I.$$.fragment),Re=o(),m(ae.$$.fragment),He=o(),w=d("div"),m(ie.$$.fragment),st=o(),_e=d("p"),_e.textContent=$t,at=o(),be=d("p"),be.innerHTML=Nt,it=o(),ye=d("p"),ye.innerHTML=Bt,rt=o(),B=d("div"),m(re.$$.fragment),lt=o(),Me=d("p"),Me.innerHTML=Ct,dt=o(),m(L.$$.fragment),ct=o(),m(Z.$$.fragment),Pe=o(),m(le.$$.fragment),Xe=o(),Te=d("p"),this.h()},l(e){const t=It("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(n),y=s(e),r=c(e,"P",{}),de(r).forEach(n),M=s(e),p(N.$$.fragment,e),b=s(e),p(C.$$.fragment,e),ve=s(e),W=c(e,"P",{"data-svelte-h":!0}),_(W)!=="svelte-1pmndzz"&&(W.textContent=mt),ke=s(e),G=c(e,"P",{"data-svelte-h":!0}),_(G)!=="svelte-15tk2ma"&&(G.innerHTML=pt),$e=s(e),E=c(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-vdffu1"&&(E.innerHTML=ht),Ne=s(e),p(R.$$.fragment,e),Be=s(e),H=c(e,"P",{"data-svelte-h":!0}),_(H)!=="svelte-qnf1r5"&&(H.textContent=ut),Ce=s(e),P=c(e,"UL",{"data-svelte-h":!0}),_(P)!=="svelte-1nmw3am"&&(P.innerHTML=ft),ze=s(e),p(X.$$.fragment,e),Ue=s(e),V=c(e,"UL",{"data-svelte-h":!0}),_(V)!=="svelte-1lu6ouj"&&(V.innerHTML=gt),xe=s(e),p(Q.$$.fragment,e),je=s(e),S=c(e,"P",{"data-svelte-h":!0}),_(S)!=="svelte-17x01k1"&&(S.innerHTML=_t),Fe=s(e),A=c(e,"BLOCKQUOTE",{"data-svelte-h":!0}),_(A)!=="svelte-1xhi4or"&&(A.innerHTML=bt),Je=s(e),p(O.$$.fragment,e),Ie=s(e),p(Y.$$.fragment,e),Le=s(e),p(D.$$.fragment,e),Ze=s(e),p(K.$$.fragment,e),qe=s(e),p(ee.$$.fragment,e),We=s(e),v=c(e,"DIV",{class:!0});var z=de(v);p(te.$$.fragment,z),Ae=s(z),me=c(z,"P",{"data-svelte-h":!0}),_(me)!=="svelte-162cit"&&(me.innerHTML=yt),Oe=s(z),pe=c(z,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-o55m63"&&(pe.innerHTML=Mt),Ye=s(z),p(J.$$.fragment,z),z.forEach(n),Ge=s(e),p(ne.$$.fragment,e),Ee=s(e),T=c(e,"DIV",{class:!0});var k=de(T);p(oe.$$.fragment,k),De=s(k),he=c(k,"P",{"data-svelte-h":!0}),_(he)!=="svelte-1r6bsx6"&&(he.textContent=Tt),Ke=s(k),ue=c(k,"P",{"data-svelte-h":!0}),_(ue)!=="svelte-6pahdo"&&(ue.innerHTML=wt),et=s(k),fe=c(k,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-hswkmf"&&(fe.innerHTML=vt),tt=s(k),x=c(k,"DIV",{class:!0});var F=de(x);p(se.$$.fragment,F),nt=s(F),ge=c(F,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-lq298d"&&(ge.innerHTML=kt),ot=s(F),p(I.$$.fragment,F),F.forEach(n),k.forEach(n),Re=s(e),p(ae.$$.fragment,e),He=s(e),w=c(e,"DIV",{class:!0});var $=de(w);p(ie.$$.fragment,$),st=s($),_e=c($,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-4h0355"&&(_e.textContent=$t),at=s($),be=c($,"P",{"data-svelte-h":!0}),_(be)!=="svelte-6pahdo"&&(be.innerHTML=Nt),it=s($),ye=c($,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-hswkmf"&&(ye.innerHTML=Bt),rt=s($),B=c($,"DIV",{class:!0});var q=de(B);p(re.$$.fragment,q),lt=s(q),Me=c(q,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-g8wwbd"&&(Me.innerHTML=Ct),dt=s(q),p(L.$$.fragment,q),ct=s(q),p(Z.$$.fragment,q),q.forEach(n),$.forEach(n),Pe=s(e),p(le.$$.fragment,e),Xe=s(e),Te=c(e,"P",{}),de(Te).forEach(n),this.h()},h(){ce(i,"name","hf:doc:metadata"),ce(i,"content",Rt),ce(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,i),a(e,y,t),a(e,r,t),a(e,M,t),h(N,e,t),a(e,b,t),h(C,e,t),a(e,ve,t),a(e,W,t),a(e,ke,t),a(e,G,t),a(e,$e,t),a(e,E,t),a(e,Ne,t),h(R,e,t),a(e,Be,t),a(e,H,t),a(e,Ce,t),a(e,P,t),a(e,ze,t),h(X,e,t),a(e,Ue,t),a(e,V,t),a(e,xe,t),h(Q,e,t),a(e,je,t),a(e,S,t),a(e,Fe,t),a(e,A,t),a(e,Je,t),h(O,e,t),a(e,Ie,t),h(Y,e,t),a(e,Le,t),h(D,e,t),a(e,Ze,t),h(K,e,t),a(e,qe,t),h(ee,e,t),a(e,We,t),a(e,v,t),h(te,v,null),l(v,Ae),l(v,me),l(v,Oe),l(v,pe),l(v,Ye),h(J,v,null),a(e,Ge,t),h(ne,e,t),a(e,Ee,t),a(e,T,t),h(oe,T,null),l(T,De),l(T,he),l(T,Ke),l(T,ue),l(T,et),l(T,fe),l(T,tt),l(T,x),h(se,x,null),l(x,nt),l(x,ge),l(x,ot),h(I,x,null),a(e,Re,t),h(ae,e,t),a(e,He,t),a(e,w,t),h(ie,w,null),l(w,st),l(w,_e),l(w,at),l(w,be),l(w,it),l(w,ye),l(w,rt),l(w,B),h(re,B,null),l(B,lt),l(B,Me),l(B,dt),h(L,B,null),l(B,ct),h(Z,B,null),a(e,Pe,t),h(le,e,t),a(e,Xe,t),a(e,Te,t),Ve=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),J.$set(z);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),I.$set(k);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),L.$set(F);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),Z.$set($)},i(e){Ve||(u(N.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(J.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(I.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(L.$$.fragment,e),u(Z.$$.fragment,e),u(le.$$.fragment,e),Ve=!0)},o(e){f(N.$$.fragment,e),f(C.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(Y.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(J.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(se.$$.fragment,e),f(I.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(L.$$.fragment,e),f(Z.$$.fragment,e),f(le.$$.fragment,e),Ve=!1},d(e){e&&(n(y),n(r),n(M),n(b),n(ve),n(W),n(ke),n(G),n($e),n(E),n(Ne),n(Be),n(H),n(Ce),n(P),n(ze),n(Ue),n(V),n(xe),n(je),n(S),n(Fe),n(A),n(Je),n(Ie),n(Le),n(Ze),n(qe),n(We),n(v),n(Ge),n(Ee),n(T),n(Re),n(He),n(w),n(Pe),n(Xe),n(Te)),n(i),g(N,e),g(C,e),g(R,e),g(X,e),g(Q,e),g(O,e),g(Y,e),g(D,e),g(K,e),g(ee,e),g(te),g(J),g(ne,e),g(oe),g(se),g(I),g(ae,e),g(ie),g(re),g(L),g(Z),g(le,e)}}}const Rt='{"title":"BitNet","local":"bitnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Model Variants","local":"model-variants","sections":[{"title":"Model Details","local":"model-details","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":3},{"title":"Example","local":"example","sections":[],"depth":3}],"depth":2},{"title":"BitNetConfig","local":"transformers.BitNetConfig","sections":[],"depth":2},{"title":"BitNetModel","local":"transformers.BitNetModel","sections":[],"depth":2},{"title":"BitNetForCausalLM","local":"transformers.BitNetForCausalLM","sections":[],"depth":2}],"depth":1}';function Ht(U){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Ft{constructor(i){super(),Jt(this,i,Ht,Et,xt,{})}}export{Dt as component};
