import{s as tt,o as at,n as st}from"../chunks/scheduler.36a0863c.js";import{S as lt,i as nt,g as r,s as l,r as m,A as ot,h as i,f as a,c as n,j as De,u as d,x as p,k as Oe,y as rt,a as s,v as M,d as y,t as j,w,m as it,n as pt}from"../chunks/index.f891bdb2.js";import{T as et}from"../chunks/Tip.a8272f7f.js";import{C as Ee}from"../chunks/CodeBlock.b05e74dc.js";import{H as K,E as ut}from"../chunks/getInferenceSnippets.846bfa3f.js";function ct(Y){let o;return{c(){o=it('Crear un motor de inferencia es un tema complejo, y la "mejor" solución probablemente dependerá de tu caso de uso. ¿Estás en CPU o en GPU? ¿Quieres la latencia más baja, el rendimiento más alto, soporte para muchos modelos o simplemente optimizar altamente un modelo específico? Hay muchas formas de abordar este tema, así que lo que vamos a presentar es un buen valor predeterminado para comenzar, que no necesariamente será la solución más óptima para ti.')},l(u){o=pt(u,'Crear un motor de inferencia es un tema complejo, y la "mejor" solución probablemente dependerá de tu caso de uso. ¿Estás en CPU o en GPU? ¿Quieres la latencia más baja, el rendimiento más alto, soporte para muchos modelos o simplemente optimizar altamente un modelo específico? Hay muchas formas de abordar este tema, así que lo que vamos a presentar es un buen valor predeterminado para comenzar, que no necesariamente será la solución más óptima para ti.')},m(u,c){s(u,o,c)},d(u){u&&a(o)}}}function mt(Y){let o,u=`El ejemplo de código a continuación está escrito intencionalmente como pseudocódigo para facilitar la lectura.
¡No lo ejecutes sin verificar si tiene sentido para los recursos de tu sistema!`;return{c(){o=r("p"),o.textContent=u},l(c){o=i(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-klxax4"&&(o.textContent=u)},m(c,F){s(c,o,F)},p:st,d(c){c&&a(o)}}}function dt(Y){let o,u,c,F,J,O,f,ee,h,Ae='Lo fundamental para entender es que podemos usar un iterador, tal como <a href="pipeline_tutorial#uso-de-pipelines-en-un-conjunto-de-datos">en un conjunto de datos</a>, ya que un servidor web es básicamente un sistema que espera solicitudes y las trata a medida que llegan.',te,b,ke="Por lo general, los servidores web están multiplexados (multihilo, asíncrono, etc.) para manejar varias solicitudes simultáneamente. Por otro lado, los flujos de trabajo (y principalmente los modelos subyacentes) no son realmente ideales para el paralelismo; consumen mucha RAM, por lo que es mejor darles todos los recursos disponibles cuando se están ejecutando o es un trabajo intensivo en cómputo.",ae,v,xe="Vamos a resolver esto haciendo que el servidor web maneje la carga ligera de recibir y enviar solicitudes, y que un único hilo maneje el trabajo real. Este ejemplo va a utilizar <code>starlette</code>. El marco de trabajo no es realmente importante, pero es posible que debas ajustar o cambiar el código si estás utilizando otro para lograr el mismo efecto.",se,$,_e="Crear <code>server.py</code>:",le,C,ne,U,Ne="Ahora puedes empezar con:",oe,g,re,q,Xe="Y puedes consultarlo con:",ie,B,pe,I,Ze="¡Y listo, ahora tienes una buena idea de cómo crear un servidor web!",ue,E,Ge="Lo realmente importante es cargar el modelo solo <strong>una vez</strong>, de modo que no haya copias del modelo en el servidor web. De esta manera, no se utiliza RAM innecesariamente. Luego, el mecanismo de queuing (colas) te permite hacer cosas sofisticadas como acumular algunos elementos antes de inferir para usar el agrupamiento dinámico:",ce,T,me,A,de,k,Ve=`Nuevamente, el código propuesto está optimizado para la legibilidad, no para ser el mejor código.
En primer lugar, no hay límite de tamaño de lote, lo cual generalmente no es una buena idea. Luego, el tiempo de espera se restablece en cada obtención de la cola, lo que significa que podrías esperar mucho más de 1ms antes de ejecutar la inferencia (retrasando la primera solicitud en esa cantidad).`,Me,x,He="Sería mejor tener un único plazo de 1ms.",ye,_,Qe="Esto siempre esperará 1ms incluso si la cola está vacía, lo que podría no ser lo mejor ya que probablemente quieras comenzar a hacer inferencias si no hay nada en la cola. Pero tal vez tenga sentido si el agrupamiento es realmente crucial para tu caso de uso. Nuevamente, no hay una solución única y mejor.",je,N,we,X,fe,Z,ze="Hay muchas cosas que pueden salir mal en producción: falta de memoria, falta de espacio, cargar el modelo podría fallar, la consulta podría ser incorrecta, la consulta podría ser correcta pero aún así fallar debido a una mala configuración del modelo, y así sucesivamente.",Te,G,Pe="Generalmente, es bueno que el servidor muestre los errores al usuario, por lo que agregar muchos bloques <code>try..except</code> para mostrar esos errores es una buena idea. Pero ten en cuenta que también puede ser un riesgo de seguridad revelar todos esos errores dependiendo de tu contexto de seguridad.",Je,V,he,H,We="Los servidores web suelen verse mejor cuando hacen interrupciones de circuitos. Significa que devuelven errores adecuados cuando están sobrecargados en lugar de simplemente esperar la consulta indefinidamente. Devolver un error 503 en lugar de esperar un tiempo muy largo o un error 504 después de mucho tiempo.",be,Q,Se="Esto es relativamente fácil de implementar en el código propuesto ya que hay una sola cola. Mirar el tamaño de la cola es una forma básica de empezar a devolver errores antes de que tu servidor web falle bajo carga.",ve,z,$e,P,Re="Actualmente, PyTorch no es consciente de la asincronía, y el cálculo bloqueará el hilo principal mientras se ejecuta. Esto significa que sería mejor si PyTorch se viera obligado a ejecutarse en su propio hilo/proceso. Esto no se hizo aquí porque el código es mucho más complejo (principalmente porque los hilos, la asincronía y las colas no se llevan bien juntos). Pero en última instancia, hace lo mismo.",Ce,W,Le="Esto sería importante si la inferencia de elementos individuales fuera larga (> 1s) porque en este caso, significa que cada consulta durante la inferencia tendría que esperar 1s antes de recibir incluso un error.",Ue,S,ge,R,Ye='En general, el procesamiento por lotes no es necesariamente una mejora respecto a pasar 1 elemento a la vez (ver <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">procesamiento por lotes</a> para más información). Pero puede ser muy efectivo cuando se usa en el entorno correcto. En la API, no hay procesamiento por lotes dinámico por defecto (demasiada oportunidad para una desaceleración). Pero para la inferencia de BLOOM - que es un modelo muy grande - el procesamiento por lotes dinámico es <strong>esencial</strong> para proporcionar una experiencia decente para todos.',qe,L,Be,D,Ie;return J=new K({props:{title:"Uso de un flujo de trabajo para un servidor web",local:"uso-de-un-flujo-de-trabajo-para-un-servidor-web",headingTag:"h1"}}),f=new et({props:{$$slots:{default:[ct]},$$scope:{ctx:Y}}}),C=new Ee({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMjAlMjAlMjAlMjB3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSklMjAlM0QlMjBhd2FpdCUyMHEuZ2V0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXQlMjAlM0QlMjBwaXBlKHN0cmluZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd2FpdCUyMHJlc3BvbnNlX3EucHV0KG91dCklMEElMEElMEFhcHAlMjAlM0QlMjBTdGFybGV0dGUoJTBBJTIwJTIwJTIwJTIwcm91dGVzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm91dGUoJTIyJTJGJTIyJTJDJTIwaG9tZXBhZ2UlMkMlMjBtZXRob2RzJTNEJTVCJTIyUE9TVCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBJTBBJTBBJTQwYXBwLm9uX2V2ZW50KCUyMnN0YXJ0dXAlMjIpJTBBYXN5bmMlMjBkZWYlMjBzdGFydHVwX2V2ZW50KCklM0ElMEElMjAlMjAlMjAlMjBxJTIwJTNEJTIwYXN5bmNpby5RdWV1ZSgpJTBBJTIwJTIwJTIwJTIwYXBwLm1vZGVsX3F1ZXVlJTIwJTNEJTIwcSUwQSUyMCUyMCUyMCUyMGFzeW5jaW8uY3JlYXRlX3Rhc2soc2VydmVyX2xvb3AocSkp",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)


app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)


<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),g=new Ee({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),B=new Ee({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIydGVzdCUyMCU1Qk1BU0slNUQlMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSUyMyU1QiU3QiUyMnNjb3JlJTIyJTNBMC43NzQyOTM2MDE1MTI5MDg5JTJDJTIydG9rZW4lMjIlM0ExMDEyJTJDJTIydG9rZW5fc3RyJTIyJTNBJTIyLiUyMiUyQyUyMnNlcXVlbmNlJTIyJTNBJTIydGVzdC4lMjIlN0QlMkMuLi4lNUQ=",highlighted:`curl -X POST -d <span class="hljs-string">&quot;test [MASK]&quot;</span> http://localhost:8000/
<span class="hljs-comment">#[{&quot;score&quot;:0.7742936015129089,&quot;token&quot;:1012,&quot;token_str&quot;:&quot;.&quot;,&quot;sequence&quot;:&quot;test.&quot;},...]</span>`,wrap:!1}}),T=new et({props:{warning:!0,$$slots:{default:[mt]},$$scope:{ctx:Y}}}),A=new Ee({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTIwJTIwJTIzJTIwMW1zJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlKHN0cmluZ3MlMkMlMjBiYXRjaF9zaXplJTNEbGVuKHN0cmluZ3MpKSUwQWZvciUyMHJxJTJDJTIwb3V0JTIwaW4lMjB6aXAocXVldWVzJTJDJTIwb3V0cyklM0ElMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJxLnB1dChvdXQp",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)  <span class="hljs-comment"># 1ms</span>
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),N=new K({props:{title:"Algunas cosas que podrías considerar",local:"algunas-cosas-que-podrías-considerar",headingTag:"h2"}}),X=new K({props:{title:"Comprobación de errores",local:"comprobación-de-errores",headingTag:"h3"}}),V=new K({props:{title:"Interrupción de circuito",local:"interrupción-de-circuito",headingTag:"h3"}}),z=new K({props:{title:"Bloqueo del hilo principal",local:"bloqueo-del-hilo-principal",headingTag:"h3"}}),S=new K({props:{title:"Procesamiento por lotes dinámico",local:"procesamiento-por-lotes-dinámico",headingTag:"h3"}}),L=new ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/pipeline_webserver.md"}}),{c(){o=r("meta"),u=l(),c=r("p"),F=l(),m(J.$$.fragment),O=l(),m(f.$$.fragment),ee=l(),h=r("p"),h.innerHTML=Ae,te=l(),b=r("p"),b.textContent=ke,ae=l(),v=r("p"),v.innerHTML=xe,se=l(),$=r("p"),$.innerHTML=_e,le=l(),m(C.$$.fragment),ne=l(),U=r("p"),U.textContent=Ne,oe=l(),m(g.$$.fragment),re=l(),q=r("p"),q.textContent=Xe,ie=l(),m(B.$$.fragment),pe=l(),I=r("p"),I.textContent=Ze,ue=l(),E=r("p"),E.innerHTML=Ge,ce=l(),m(T.$$.fragment),me=l(),m(A.$$.fragment),de=l(),k=r("p"),k.textContent=Ve,Me=l(),x=r("p"),x.textContent=He,ye=l(),_=r("p"),_.textContent=Qe,je=l(),m(N.$$.fragment),we=l(),m(X.$$.fragment),fe=l(),Z=r("p"),Z.textContent=ze,Te=l(),G=r("p"),G.innerHTML=Pe,Je=l(),m(V.$$.fragment),he=l(),H=r("p"),H.textContent=We,be=l(),Q=r("p"),Q.textContent=Se,ve=l(),m(z.$$.fragment),$e=l(),P=r("p"),P.textContent=Re,Ce=l(),W=r("p"),W.textContent=Le,Ue=l(),m(S.$$.fragment),ge=l(),R=r("p"),R.innerHTML=Ye,qe=l(),m(L.$$.fragment),Be=l(),D=r("p"),this.h()},l(e){const t=ot("svelte-u9bgzb",document.head);o=i(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),c=i(e,"P",{}),De(c).forEach(a),F=n(e),d(J.$$.fragment,e),O=n(e),d(f.$$.fragment,e),ee=n(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-khus43"&&(h.innerHTML=Ae),te=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1muberp"&&(b.textContent=ke),ae=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1jc423b"&&(v.innerHTML=xe),se=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-152lf0o"&&($.innerHTML=_e),le=n(e),d(C.$$.fragment,e),ne=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1r1mr95"&&(U.textContent=Ne),oe=n(e),d(g.$$.fragment,e),re=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-mka7u9"&&(q.textContent=Xe),ie=n(e),d(B.$$.fragment,e),pe=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1iklkoa"&&(I.textContent=Ze),ue=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-964dwz"&&(E.innerHTML=Ge),ce=n(e),d(T.$$.fragment,e),me=n(e),d(A.$$.fragment,e),de=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-2vvtjw"&&(k.textContent=Ve),Me=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-151hjed"&&(x.textContent=He),ye=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-5bwvty"&&(_.textContent=Qe),je=n(e),d(N.$$.fragment,e),we=n(e),d(X.$$.fragment,e),fe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-xphdf2"&&(Z.textContent=ze),Te=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-18l0y7q"&&(G.innerHTML=Pe),Je=n(e),d(V.$$.fragment,e),he=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1vl0l17"&&(H.textContent=We),be=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1dcth30"&&(Q.textContent=Se),ve=n(e),d(z.$$.fragment,e),$e=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-16dvc7f"&&(P.textContent=Re),Ce=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-iqrwus"&&(W.textContent=Le),Ue=n(e),d(S.$$.fragment,e),ge=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1asrn37"&&(R.innerHTML=Ye),qe=n(e),d(L.$$.fragment,e),Be=n(e),D=i(e,"P",{}),De(D).forEach(a),this.h()},h(){Oe(o,"name","hf:doc:metadata"),Oe(o,"content",Mt)},m(e,t){rt(document.head,o),s(e,u,t),s(e,c,t),s(e,F,t),M(J,e,t),s(e,O,t),M(f,e,t),s(e,ee,t),s(e,h,t),s(e,te,t),s(e,b,t),s(e,ae,t),s(e,v,t),s(e,se,t),s(e,$,t),s(e,le,t),M(C,e,t),s(e,ne,t),s(e,U,t),s(e,oe,t),M(g,e,t),s(e,re,t),s(e,q,t),s(e,ie,t),M(B,e,t),s(e,pe,t),s(e,I,t),s(e,ue,t),s(e,E,t),s(e,ce,t),M(T,e,t),s(e,me,t),M(A,e,t),s(e,de,t),s(e,k,t),s(e,Me,t),s(e,x,t),s(e,ye,t),s(e,_,t),s(e,je,t),M(N,e,t),s(e,we,t),M(X,e,t),s(e,fe,t),s(e,Z,t),s(e,Te,t),s(e,G,t),s(e,Je,t),M(V,e,t),s(e,he,t),s(e,H,t),s(e,be,t),s(e,Q,t),s(e,ve,t),M(z,e,t),s(e,$e,t),s(e,P,t),s(e,Ce,t),s(e,W,t),s(e,Ue,t),M(S,e,t),s(e,ge,t),s(e,R,t),s(e,qe,t),M(L,e,t),s(e,Be,t),s(e,D,t),Ie=!0},p(e,[t]){const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),f.$set(Fe);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),T.$set(Ke)},i(e){Ie||(y(J.$$.fragment,e),y(f.$$.fragment,e),y(C.$$.fragment,e),y(g.$$.fragment,e),y(B.$$.fragment,e),y(T.$$.fragment,e),y(A.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y(V.$$.fragment,e),y(z.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),Ie=!0)},o(e){j(J.$$.fragment,e),j(f.$$.fragment,e),j(C.$$.fragment,e),j(g.$$.fragment,e),j(B.$$.fragment,e),j(T.$$.fragment,e),j(A.$$.fragment,e),j(N.$$.fragment,e),j(X.$$.fragment,e),j(V.$$.fragment,e),j(z.$$.fragment,e),j(S.$$.fragment,e),j(L.$$.fragment,e),Ie=!1},d(e){e&&(a(u),a(c),a(F),a(O),a(ee),a(h),a(te),a(b),a(ae),a(v),a(se),a($),a(le),a(ne),a(U),a(oe),a(re),a(q),a(ie),a(pe),a(I),a(ue),a(E),a(ce),a(me),a(de),a(k),a(Me),a(x),a(ye),a(_),a(je),a(we),a(fe),a(Z),a(Te),a(G),a(Je),a(he),a(H),a(be),a(Q),a(ve),a($e),a(P),a(Ce),a(W),a(Ue),a(ge),a(R),a(qe),a(Be),a(D)),a(o),w(J,e),w(f,e),w(C,e),w(g,e),w(B,e),w(T,e),w(A,e),w(N,e),w(X,e),w(V,e),w(z,e),w(S,e),w(L,e)}}}const Mt='{"title":"Uso de un flujo de trabajo para un servidor web","local":"uso-de-un-flujo-de-trabajo-para-un-servidor-web","sections":[{"title":"Algunas cosas que podrías considerar","local":"algunas-cosas-que-podrías-considerar","sections":[{"title":"Comprobación de errores","local":"comprobación-de-errores","sections":[],"depth":3},{"title":"Interrupción de circuito","local":"interrupción-de-circuito","sections":[],"depth":3},{"title":"Bloqueo del hilo principal","local":"bloqueo-del-hilo-principal","sections":[],"depth":3},{"title":"Procesamiento por lotes dinámico","local":"procesamiento-por-lotes-dinámico","sections":[],"depth":3}],"depth":2}],"depth":1}';function yt(Y){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends lt{constructor(o){super(),nt(this,o,yt,dt,tt,{})}}export{ht as component};
