import{s as Nl,n as El,o as Hl}from"../chunks/scheduler.bdbef820.js";import{S as Fl,i as zl,g as M,s as a,r as c,A as $l,h as o,f as e,c as n,j as Al,u as p,x as i,k as vl,y as xl,a as t,v as r,d as y,t as m,w as d}from"../chunks/index.33f81d56.js";import{C as j}from"../chunks/CodeBlock.3bad7fc9.js";import{D as Ql}from"../chunks/DocNotebookDropdown.339158fb.js";import{H as Sl,E as ql}from"../chunks/getInferenceSnippets.64cd9466.js";function Ll(Tl){let J,Q,$,S,b,q,u,L,w,fl='知識の蒸留は、より大規模で複雑なモデル (教師) からより小規模で単純なモデル (生徒) に知識を伝達するために使用される手法です。あるモデルから別のモデルに知識を抽出するには、特定のタスク (この場合は画像分類) でトレーニングされた事前トレーニング済み教師モデルを取得し、画像分類でトレーニングされる生徒モデルをランダムに初期化します。次に、学生モデルをトレーニングして、その出力と教師の出力の差を最小限に抑え、動作を模倣します。これは <a href="https://arxiv.org/abs/1503.02531" rel="nofollow">Distilling the Knowledge in a Neural Network by Hinton et al</a> で最初に導入されました。このガイドでは、タスク固有の知識の蒸留を行います。これには <a href="https://huggingface.co/datasets/beans" rel="nofollow">Beans データセット</a> を使用します。',K,U,Cl='このガイドでは、<a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">微調整された ViT モデル</a> (教師モデル) を抽出して <a href="https://huggingface.co/google/mobilenet_v2_1.4_224" rel="nofollow">MobileNet</a> (学生モデル) 🤗 Transformers の <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#trainer" rel="nofollow">Trainer API</a> を使用します。',D,h,gl="蒸留とプロセスの評価に必要なライブラリをインストールしましょう。",P,T,O,f,Zl="この例では、教師モデルとして<code>merve/beans-vit-224</code>モデルを使用しています。これは、Bean データセットに基づいて微調整された<code>google/vit-base-patch16-224-in21k</code>に基づく画像分類モデルです。このモデルをランダムに初期化された MobileNetV2 に抽出します。",ll,C,_l="次に、データセットをロードします。",sl,g,el,Z,Il="この場合、同じ解像度で同じ出力が返されるため、どちらのモデルの画像プロセッサも使用できます。 <code>dataset</code>の<code>map()</code>メソッドを使用して、データセットのすべての分割に前処理を適用します。",tl,_,al,I,Wl="基本的に、我々は生徒モデル（ランダムに初期化されたMobileNet）が教師モデル（微調整されたビジョン変換器）を模倣することを望む。これを実現するために、まず教師と生徒からロジット出力を得る。次に、それぞれのソフトターゲットの重要度を制御するパラメータ<code>temperature</code>で分割する。<code>lambda</code>と呼ばれるパラメータは蒸留ロスの重要度を量る。この例では、<code>temperature=5</code>、<code>lambda=0.5</code>とする。生徒と教師の間の発散を計算するために、Kullback-Leibler発散損失を使用します。2つのデータPとQが与えられたとき、KLダイバージェンスはQを使ってPを表現するためにどれだけの余分な情報が必要かを説明します。もし2つが同じであれば、QからPを説明するために必要な他の情報はないので、それらのKLダイバージェンスはゼロになります。",nl,W,Ml,R,Rl="次に、Hugging Face Hub にログインして、<code>trainer</code>を通じてモデルを Hugging Face Hub にプッシュできるようにします。",ol,G,il,X,Gl="教師モデルと生徒モデルである<code>TrainingArguments</code>を設定しましょう。",cl,Y,pl,B,Xl="<code>compute_metrics</code> 関数を使用して、テスト セットでモデルを評価できます。この関数は、トレーニング プロセス中にモデルの<code>accuracy</code>と<code>f1</code>を計算するために使用されます。",rl,V,yl,k,Yl="定義したトレーニング引数を使用して<code>Trainer</code>を初期化しましょう。データ照合装置も初期化します。",ml,A,dl,v,Bl="これでモデルをトレーニングできるようになりました。",jl,N,Jl,E,Vl="テスト セットでモデルを評価できます。",bl,H,ul,F,kl='テスト セットでは、モデルの精度は 72% に達します。蒸留効率の健全性チェックを行うために、同じハイパーパラメータを使用して Bean データセットで MobileNet を最初からトレーニングし、テスト セットで 63% の精度を観察しました。読者の皆様には、さまざまな事前トレーニング済み教師モデル、学生アーキテクチャ、蒸留パラメータを試していただき、その結果を報告していただくようお勧めします。抽出されたモデルのトレーニング ログとチェックポイントは <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">このリポジトリ</a> にあり、最初からトレーニングされた MobileNetV2 はこの <a href="https://huggingface.co/merve/resnet-mobilenet-beans-5" rel="nofollow">リポジトリ</a>。',wl,z,Ul,x,hl;return b=new Sl({props:{title:"Knowledge Distillation for Computer Vision",local:"knowledge-distillation-for-computer-vision",headingTag:"h1"}}),u=new Ql({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/knowledge_distillation_for_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/knowledge_distillation_for_image_classification.ipynb"}]}}),T=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMHRlbnNvcmJvYXJkJTIwZXZhbHVhdGUlMjAtLXVwZ3JhZGU=",highlighted:"pip install transformers datasets accelerate tensorboard evaluate --upgrade",wrap:!1}}),g=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiZWFucyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>)`,wrap:!1}}),_=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQXRlYWNoZXJfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtZXJ2ZSUyRmJlYW5zLXZpdC0yMjQlMjIpJTBBJTBBZGVmJTIwcHJvY2VzcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfaW5wdXRzJTIwJTNEJTIwdGVhY2hlcl9wcm9jZXNzb3IoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwcm9jZXNzZWRfaW5wdXRzJTBBJTBBcHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2VzcyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
teacher_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">examples</span>):
    processed_inputs = teacher_processor(examples[<span class="hljs-string">&quot;image&quot;</span>])
    <span class="hljs-keyword">return</span> processed_inputs

processed_datasets = dataset.<span class="hljs-built_in">map</span>(process, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageDistilTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, *args, teacher_model=<span class="hljs-literal">None</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.teacher = teacher_model
        self.student = student_model
        self.loss_function = nn.KLDivLoss(reduction=<span class="hljs-string">&quot;batchmean&quot;</span>)
        device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
        self.teacher.to(device)
        self.teacher.<span class="hljs-built_in">eval</span>()
        self.temperature = temperature
        self.lambda_param = lambda_param

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, student, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        student_output = self.student(**inputs)

        <span class="hljs-keyword">with</span> torch.no_grad():
          teacher_output = self.teacher(**inputs)

        <span class="hljs-comment"># Compute soft targets for teacher and student</span>
        soft_teacher = F.softmax(teacher_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)
        soft_student = F.log_softmax(student_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Compute the loss</span>
        distillation_loss = self.loss_function(soft_student, soft_teacher) * (self.temperature ** <span class="hljs-number">2</span>)

        <span class="hljs-comment"># Compute the true label loss</span>
        student_target_loss = student_output.loss

        <span class="hljs-comment"># Calculate final loss</span>
        loss = (<span class="hljs-number">1.</span> - self.lambda_param) * student_target_loss + self.lambda_param * distillation_loss
        <span class="hljs-keyword">return</span> (loss, student_output) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),G=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Y=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBNb2JpbGVOZXRWMkNvbmZpZyUyQyUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIybXktYXdlc29tZS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0RmJTIyJTdCcmVwb19uYW1lJTdEJTJGbG9ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyYWNjdXJhY3klMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0ZW5zb3Jib2FyZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGh1Yl9zdHJhdGVneSUzRCUyMmV2ZXJ5X3NhdmUlMjIlMkMlMEElMjAlMjAlMjAlMjBodWJfbW9kZWxfaWQlM0RyZXBvX25hbWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVscyUyMiU1RC5uYW1lcyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwbW9kZWxzJTBBdGVhY2hlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1lcnZlJTJGYmVhbnMtdml0LTIyNCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMHRyYWluaW5nJTIwTW9iaWxlTmV0VjIlMjBmcm9tJTIwc2NyYXRjaCUwQXN0dWRlbnRfY29uZmlnJTIwJTNEJTIwTW9iaWxlTmV0VjJDb25maWcoKSUwQXN0dWRlbnRfY29uZmlnLm51bV9sYWJlbHMlMjAlM0QlMjBudW1fbGFiZWxzJTBBc3R1ZGVudF9tb2RlbCUyMCUzRCUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihzdHVkZW50X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, MobileNetV2Config, MobileNetV2ForImageClassification

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;my-awesome-model&quot;</span>,
    num_train_epochs=<span class="hljs-number">30</span>,
    fp16=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{repo_name}</span>/logs&quot;</span>,
    logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    report_to=<span class="hljs-string">&quot;tensorboard&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_strategy=<span class="hljs-string">&quot;every_save&quot;</span>,
    hub_model_id=repo_name,
    )

num_labels = <span class="hljs-built_in">len</span>(processed_datasets[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;labels&quot;</span>].names)

<span class="hljs-comment"># initialize models</span>
teacher_model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>,
    num_labels=num_labels,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># training MobileNetV2 from scratch</span>
student_config = MobileNetV2Config()
student_config.num_labels = num_labels
student_model = MobileNetV2ForImageClassification(student_config)`,wrap:!1}}),V=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMGFjYyUyMCUzRCUyMGFjY3VyYWN5LmNvbXB1dGUocmVmZXJlbmNlcyUzRGxhYmVscyUyQyUyMHByZWRpY3Rpb25zJTNEbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFjY3VyYWN5JTIyJTNBJTIwYWNjJTVCJTIyYWNjdXJhY3klMjIlNUQlN0Q=",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    acc = accuracy.compute(references=labels, predictions=np.argmax(predictions, axis=<span class="hljs-number">1</span>))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: acc[<span class="hljs-string">&quot;accuracy&quot;</span>]}`,wrap:!1}}),A=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigpJTBBdHJhaW5lciUyMCUzRCUyMEltYWdlRGlzdGlsVHJhaW5lciglMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEc3R1ZGVudF9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRlYWNoZXJfbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdGVhY2hlcl9leHRyYWN0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDUlMkMlMEElMjAlMjAlMjAlMjBsYW1iZGFfcGFyYW0lM0QwLjUlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

data_collator = DefaultDataCollator()
trainer = ImageDistilTrainer(
    student_model=student_model,
    teacher_model=teacher_model,
    training_args=training_args,
    train_dataset=processed_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=teacher_extractor,
    compute_metrics=compute_metrics,
    temperature=<span class="hljs-number">5</span>,
    lambda_param=<span class="hljs-number">0.5</span>
)`,wrap:!1}}),N=new j({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),H=new j({props:{code:"dHJhaW5lci5ldmFsdWF0ZShwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0ZXN0JTIyJTVEKQ==",highlighted:'trainer.evaluate(processed_datasets[<span class="hljs-string">&quot;test&quot;</span>])',wrap:!1}}),z=new ql({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/knowledge_distillation_for_image_classification.md"}}),{c(){J=M("meta"),Q=a(),$=M("p"),S=a(),c(b.$$.fragment),q=a(),c(u.$$.fragment),L=a(),w=M("p"),w.innerHTML=fl,K=a(),U=M("p"),U.innerHTML=Cl,D=a(),h=M("p"),h.textContent=gl,P=a(),c(T.$$.fragment),O=a(),f=M("p"),f.innerHTML=Zl,ll=a(),C=M("p"),C.textContent=_l,sl=a(),c(g.$$.fragment),el=a(),Z=M("p"),Z.innerHTML=Il,tl=a(),c(_.$$.fragment),al=a(),I=M("p"),I.innerHTML=Wl,nl=a(),c(W.$$.fragment),Ml=a(),R=M("p"),R.innerHTML=Rl,ol=a(),c(G.$$.fragment),il=a(),X=M("p"),X.innerHTML=Gl,cl=a(),c(Y.$$.fragment),pl=a(),B=M("p"),B.innerHTML=Xl,rl=a(),c(V.$$.fragment),yl=a(),k=M("p"),k.innerHTML=Yl,ml=a(),c(A.$$.fragment),dl=a(),v=M("p"),v.textContent=Bl,jl=a(),c(N.$$.fragment),Jl=a(),E=M("p"),E.textContent=Vl,bl=a(),c(H.$$.fragment),ul=a(),F=M("p"),F.innerHTML=kl,wl=a(),c(z.$$.fragment),Ul=a(),x=M("p"),this.h()},l(l){const s=$l("svelte-u9bgzb",document.head);J=o(s,"META",{name:!0,content:!0}),s.forEach(e),Q=n(l),$=o(l,"P",{}),Al($).forEach(e),S=n(l),p(b.$$.fragment,l),q=n(l),p(u.$$.fragment,l),L=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-g6zwxf"&&(w.innerHTML=fl),K=n(l),U=o(l,"P",{"data-svelte-h":!0}),i(U)!=="svelte-61h09j"&&(U.innerHTML=Cl),D=n(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-jic642"&&(h.textContent=gl),P=n(l),p(T.$$.fragment,l),O=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-17bqj69"&&(f.innerHTML=Zl),ll=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-17v1c71"&&(C.textContent=_l),sl=n(l),p(g.$$.fragment,l),el=n(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1dtz5lw"&&(Z.innerHTML=Il),tl=n(l),p(_.$$.fragment,l),al=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-e05tyc"&&(I.innerHTML=Wl),nl=n(l),p(W.$$.fragment,l),Ml=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-193zzpj"&&(R.innerHTML=Rl),ol=n(l),p(G.$$.fragment,l),il=n(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1tcn498"&&(X.innerHTML=Gl),cl=n(l),p(Y.$$.fragment,l),pl=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1kxppjo"&&(B.innerHTML=Xl),rl=n(l),p(V.$$.fragment,l),yl=n(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-xih5j9"&&(k.innerHTML=Yl),ml=n(l),p(A.$$.fragment,l),dl=n(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-syywia"&&(v.textContent=Bl),jl=n(l),p(N.$$.fragment,l),Jl=n(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1udiga3"&&(E.textContent=Vl),bl=n(l),p(H.$$.fragment,l),ul=n(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1sg5l9o"&&(F.innerHTML=kl),wl=n(l),p(z.$$.fragment,l),Ul=n(l),x=o(l,"P",{}),Al(x).forEach(e),this.h()},h(){vl(J,"name","hf:doc:metadata"),vl(J,"content",Kl)},m(l,s){xl(document.head,J),t(l,Q,s),t(l,$,s),t(l,S,s),r(b,l,s),t(l,q,s),r(u,l,s),t(l,L,s),t(l,w,s),t(l,K,s),t(l,U,s),t(l,D,s),t(l,h,s),t(l,P,s),r(T,l,s),t(l,O,s),t(l,f,s),t(l,ll,s),t(l,C,s),t(l,sl,s),r(g,l,s),t(l,el,s),t(l,Z,s),t(l,tl,s),r(_,l,s),t(l,al,s),t(l,I,s),t(l,nl,s),r(W,l,s),t(l,Ml,s),t(l,R,s),t(l,ol,s),r(G,l,s),t(l,il,s),t(l,X,s),t(l,cl,s),r(Y,l,s),t(l,pl,s),t(l,B,s),t(l,rl,s),r(V,l,s),t(l,yl,s),t(l,k,s),t(l,ml,s),r(A,l,s),t(l,dl,s),t(l,v,s),t(l,jl,s),r(N,l,s),t(l,Jl,s),t(l,E,s),t(l,bl,s),r(H,l,s),t(l,ul,s),t(l,F,s),t(l,wl,s),r(z,l,s),t(l,Ul,s),t(l,x,s),hl=!0},p:El,i(l){hl||(y(b.$$.fragment,l),y(u.$$.fragment,l),y(T.$$.fragment,l),y(g.$$.fragment,l),y(_.$$.fragment,l),y(W.$$.fragment,l),y(G.$$.fragment,l),y(Y.$$.fragment,l),y(V.$$.fragment,l),y(A.$$.fragment,l),y(N.$$.fragment,l),y(H.$$.fragment,l),y(z.$$.fragment,l),hl=!0)},o(l){m(b.$$.fragment,l),m(u.$$.fragment,l),m(T.$$.fragment,l),m(g.$$.fragment,l),m(_.$$.fragment,l),m(W.$$.fragment,l),m(G.$$.fragment,l),m(Y.$$.fragment,l),m(V.$$.fragment,l),m(A.$$.fragment,l),m(N.$$.fragment,l),m(H.$$.fragment,l),m(z.$$.fragment,l),hl=!1},d(l){l&&(e(Q),e($),e(S),e(q),e(L),e(w),e(K),e(U),e(D),e(h),e(P),e(O),e(f),e(ll),e(C),e(sl),e(el),e(Z),e(tl),e(al),e(I),e(nl),e(Ml),e(R),e(ol),e(il),e(X),e(cl),e(pl),e(B),e(rl),e(yl),e(k),e(ml),e(dl),e(v),e(jl),e(Jl),e(E),e(bl),e(ul),e(F),e(wl),e(Ul),e(x)),e(J),d(b,l),d(u,l),d(T,l),d(g,l),d(_,l),d(W,l),d(G,l),d(Y,l),d(V,l),d(A,l),d(N,l),d(H,l),d(z,l)}}}const Kl='{"title":"Knowledge Distillation for Computer Vision","local":"knowledge-distillation-for-computer-vision","sections":[],"depth":1}';function Dl(Tl){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Fl{constructor(J){super(),zl(this,J,Dl,Ll,Nl,{})}}export{ts as component};
