import{s as ya,n as ha,o as Ma}from"../chunks/scheduler.bdbef820.js";import{S as ga,i as oa,g as p,s as n,r,A as ua,h as i,f as l,c as e,j as Es,u as j,x as c,k as ma,y as x,a,v as m,d as y,t as h,w as M}from"../chunks/index.33f81d56.js";import{C as o}from"../chunks/CodeBlock.3bad7fc9.js";import{H as g,E as Ja}from"../chunks/getInferenceSnippets.64cd9466.js";function xa(xl){let u,Fs,Ys,Ss,U,Ls,T,Ul=`🤗 Transformers는 자연어처리(NLP), 컴퓨터 비전, 오디오 및 음성 처리 작업에 대한 사전훈련된 최첨단 모델 라이브러리입니다.
이 라이브러리는 트랜스포머 모델뿐만 아니라 컴퓨터 비전 작업을 위한 현대적인 합성곱 신경망과 같은 트랜스포머가 아닌 모델도 포함하고 있습니다.`,As,b,Tl=`스마트폰, 앱, 텔레비전과 같은 오늘날 가장 인기 있는 소비자 제품을 살펴보면, 딥러닝 기술이 그 뒤에 사용되고 있을 확률이 높습니다.
스마트폰으로 촬영한 사진에서 배경 객체를 제거하고 싶다면 어떻게 할까요? 이는 파놉틱 세그멘테이션 작업의 예입니다(아직 이게 무엇인지 모른다면, 다음 섹션에서 설명하겠습니다!).`,Ps,d,bl="이 페이지는 다양한 음성 및 오디오, 컴퓨터 비전, NLP 작업을 🤗 Transformers 라이브러리를 활용하여 다루는 간단한 예제를 3줄의 코드로 제공합니다.",Ks,w,Ds,f,dl=`음성 및 오디오 처리 작업은 다른 모달리티와 약간 다릅니다. 이는 주로 오디오가 연속적인 신호로 입력되기 때문입니다.
텍스트와 달리 원본 오디오 파형(waveform)은 문장이 단어로 나눠지는 것처럼 깔끔하게 이산적인 묶음으로 나눌 수 없습니다.
이를 극복하기 위해 원본 오디오 신호는 일정한 간격으로 샘플링됩니다. 해당 간격 내에서 더 많은 샘플을 취할 경우 샘플링률이 높아지며, 오디오는 원본 오디오 소스에 더 가까워집니다.`,Os,C,wl=`과거의 접근 방식은 오디오에서 유용한 특징을 추출하기 위해 오디오를 전처리하는 것이었습니다.
하지만 현재는 원본 오디오 파형을 특성 인코더에 직접 넣어서 오디오 표현(representation)을 추출하는 것이 더 일반적입니다.
이렇게 하면 전처리 단계가 단순해지고 모델이 가장 중요한 특징을 학습할 수 있습니다.`,st,Z,tt,I,fl="오디오 분류는 오디오 데이터에 미리 정의된 클래스 집합의 레이블을 지정하는 작업입니다. 이는 많은 구체적인 응용 프로그램을 포함한 넓은 범주입니다.",lt,B,Cl="일부 예시는 다음과 같습니다:",at,$,Zl="<li>음향 장면 분류: 오디오에 장면 레이블(“사무실”, “해변”, “경기장”)을 지정합니다.</li> <li>음향 이벤트 감지: 오디오에 소리 이벤트 레이블(“차 경적”, “고래 울음소리”, “유리 파손”)을 지정합니다.</li> <li>태깅: 여러 가지 소리(새 지저귐, 회의에서의 화자 식별)가 포함된 오디오에 레이블을 지정합니다.</li> <li>음악 분류: 음악에 장르 레이블(“메탈”, “힙합”, “컨트리”)을 지정합니다.</li>",nt,W,et,k,pt,G,Il=`자동 음성 인식(ASR)은 음성을 텍스트로 변환하는 작업입니다.
음성은 인간의 자연스러운 의사소통 형태이기 때문에 ASR은 가장 일반적인 오디오 작업 중 하나입니다.
오늘날 ASR 시스템은 스피커, 전화 및 자동차와 같은 “스마트” 기술 제품에 내장되어 있습니다.
우리는 가상 비서에게 음악 재생, 알림 설정 및 날씨 정보를 요청할 수 있습니다.`,it,H,Bl="하지만 트랜스포머 아키텍처가 해결하는 데 도움을 준 핵심 도전 과제 중 하나는 양이 데이터 양이 적은 언어(low-resource language)에 대한 것입니다. 대량의 음성 데이터로 사전 훈련한 후 데이터 양이 적은 언어에서 레이블이 지정된 음성 데이터 1시간만으로 모델을 미세 조정하면 이전의 100배 많은 레이블이 지정된 데이터로 훈련된 ASR 시스템보다 훨씬 더 높은 품질의 결과를 얻을 수 있습니다.",ct,q,rt,v,jt,V,$l='컴퓨터 비전 작업 중 가장 초기의 성공적인 작업 중 하나는 <a href="glossary#convolution">합성곱 신경망(CNN)</a>을 사용하여 우편번호 숫자 이미지를 인식하는 것이었습니다. 이미지는 픽셀로 구성되어 있으며 각 픽셀은 숫자 값으로 표현됩니다. 이로써 이미지를 픽셀 값의 행렬로 나타내는 것이 쉬워집니다. 특정한 픽셀 값의 조합은 이미지의 색상을 의미합니다.',mt,N,Wl="컴퓨터 비전 작업은 일반적으로 다음 두 가지 방법으로 접근 가능합니다:",yt,R,kl="<li><p>합성곱을 사용하여 이미지의 낮은 수준 특징에서 높은 수준의 추상적인 요소까지 계층적으로 학습합니다.</p></li> <li><p>이미지를 패치로 나누고 트랜스포머를 사용하여 점진적으로 각 이미지 패치가 서로 어떠한 방식으로 연관되어 이미지를 형성하는지 학습합니다. <code>CNN</code>에서 선호하는 상향식 접근법과는 달리, 이 방식은 흐릿한 이미지로 초안을 그리고 점진적으로 선명한 이미지로 만들어가는 것과 유사합니다.</p></li>",ht,_,Mt,Q,Gl="이미지 분류는 한 개의 전체 이미지에 미리 정의된 클래스 집합의 레이블을 지정하는 작업입니다.",gt,z,Hl="대부분의 분류 작업과 마찬가지로, 이미지 분류에는 다양한 실용적인 용도가 있으며, 일부 예시는 다음과 같습니다:",ot,Y,ql="<li>의료: 질병을 감지하거나 환자 건강을 모니터링하기 위해 의료 이미지에 레이블을 지정합니다.</li> <li>환경: 위성 이미지를 분류하여 산림 벌채를 감시하고 야생 지역 관리를 위한 정보를 제공하거나 산불을 감지합니다.</li> <li>농업: 작물 이미지를 분류하여 식물 건강을 확인하거나 위성 이미지를 분류하여 토지 이용 관찰에 사용합니다.</li> <li>생태학: 동물이나 식물 종 이미지를 분류하여 야생 동물 개체군을 조사하거나 멸종 위기에 처한 종을 추적합니다.</li>",ut,X,Jt,E,xt,F,vl="이미지 분류와 달리 객체 탐지는 이미지 내에서 여러 객체를 식별하고 바운딩 박스로 정의된 객체의 위치를 파악합니다.",Ut,S,Vl="객체 탐지의 몇 가지 응용 예시는 다음과 같습니다:",Tt,L,Nl="<li>자율 주행 차량: 다른 차량, 보행자 및 신호등과 같은 일상적인 교통 객체를 감지합니다.</li> <li>원격 감지: 재난 모니터링, 도시 계획 및 기상 예측 등을 수행합니다.</li> <li>결함 탐지: 건물의 균열이나 구조적 손상, 제조 결함 등을 탐지합니다.</li>",bt,A,dt,P,wt,K,Rl="이미지 분할은 픽셀 차원의 작업으로, 이미지 내의 모든 픽셀을 클래스에 할당합니다. 이는 객체 탐지와 다릅니다. 객체 탐지는 바운딩 박스를 사용하여 이미지 내의 객체를 레이블링하고 예측하는 반면, 분할은 더 세분화된 작업입니다. 분할은 픽셀 수준에서 객체를 감지할 수 있습니다.",ft,D,_l="이미지 분할에는 여러 유형이 있습니다:",Ct,O,Ql="<li>인스턴스 분할: 개체의 클래스를 레이블링하는 것 외에도, 개체의 각 구분된 인스턴스에도 레이블을 지정합니다 (“개-1”, “개-2” 등).</li> <li>파놉틱 분할: 의미적 분할과 인스턴스 분할의 조합입니다. 각 픽셀을 의미적 클래스로 레이블링하는 <strong>동시에</strong> 개체의 각각 구분된 인스턴스로도 레이블을 지정합니다.</li>",Zt,ss,zl="분할 작업은 자율 주행 차량에서 유용하며, 주변 환경의 픽셀 수준 지도를 생성하여 보행자와 다른 차량 주변에서 안전하게 탐색할 수 있습니다. 또한 의료 영상에서도 유용합니다. 분할 작업이 픽셀 수준에서 객체를 감지할 수 있기 때문에 비정상적인 세포나 장기의 특징을 식별하는 데 도움이 될 수 있습니다. 이미지 분할은 의류 가상 시착이나 카메라를 통해 실제 세계에 가상 개체를 덧씌워 증강 현실 경험을 만드는 등 전자 상거래 분야에서도 사용될 수 있습니다.",It,ts,Bt,ls,$t,as,Yl="깊이 추정은 카메라로부터 이미지 내부의 각 픽셀의 거리를 예측합니다. 이 컴퓨터 비전 작업은 특히 장면 이해와 재구성에 중요합니다. 예를 들어, 자율 주행 차량은 보행자, 교통 표지판 및 다른 차량과 같은 객체와의 거리를 이해하여 장애물과 충돌을 피해야 합니다. 깊이 정보는 또한 2D 이미지에서 3D 표현을 구성하는 데 도움이 되며 생물학적 구조나 건물의 고품질 3D 표현을 생성하는 데 사용될 수 있습니다.",Wt,ns,Xl="깊이 추정에는 두 가지 접근 방식이 있습니다:",kt,es,El="<li>스테레오: 약간 다른 각도에서 촬영된 동일한 이미지 두 장을 비교하여 깊이를 추정합니다.</li> <li>단안: 단일 이미지에서 깊이를 추정합니다.</li>",Gt,ps,Ht,is,qt,cs,Fl="텍스트는 인간이 의사 소통하는 자연스러운 방식 중 하나이기 때문에 자연어처리 역시 가장 일반적인 작업 유형 중 하나입니다. 모델이 인식하는 형식으로 텍스트를 변환하려면 토큰화해야 합니다. 이는 텍스트 시퀀스를 개별 단어 또는 하위 단어(토큰)로 분할한 다음 이러한 토큰을 숫자로 변환하는 것을 의미합니다. 결과적으로 텍스트 시퀀스를 숫자 시퀀스로 표현할 수 있으며, 숫자 시퀀스를 다양한 자연어처리 작업을 해결하기 위한 모델에 입력할 수 있습니다!",vt,rs,Vt,js,Sl="다른 모달리티에서의 분류 작업과 마찬가지로 텍스트 분류는 미리 정의된 클래스 집합에서 텍스트 시퀀스(문장 수준, 단락 또는 문서 등)에 레이블을 지정합니다. 텍스트 분류에는 다양한 실용적인 응용 사례가 있으며, 일부 예시는 다음과 같습니다:",Nt,ms,Ll="<li>감성 분석: 텍스트를 <code>긍정</code> 또는 <code>부정</code>과 같은 어떤 극성에 따라 레이블링하여 정치, 금융, 마케팅과 같은 분야에서 의사 결정에 정보를 제공하고 지원할 수 있습니다.</li> <li>콘텐츠 분류: 텍스트를 주제에 따라 레이블링(날씨, 스포츠, 금융 등)하여 뉴스 및 소셜 미디어 피드에서 정보를 구성하고 필터링하는 데 도움이 될 수 있습니다.</li>",Rt,ys,_t,hs,Qt,Ms,Al='모든 자연어처리 작업에서는 텍스트가 개별 단어나 하위 단어로 분리되어 전처리됩니다. 분리된 단어를 <a href="/glossary#token">토큰</a>이라고 합니다. 토큰 분류는 각 토큰에 미리 정의된 클래스 집합의 레이블을 할당합니다.',zt,gs,Pl="토큰 분류의 두 가지 일반적인 유형은 다음과 같습니다:",Yt,os,Kl="<li>개체명 인식 (NER): 토큰을 조직, 인물, 위치 또는 날짜와 같은 개체 범주에 따라 레이블링합니다. NER은 특히 유전체학적인 환경에서 유전자, 단백질 및 약물 이름에 레이블을 지정하는 데 널리 사용됩니다.</li> <li>품사 태깅 (POS): 명사, 동사, 형용사와 같은 품사에 따라 토큰에 레이블을 할당합니다. POS는 번역 시스템이 동일한 단어가 문법적으로 어떻게 다른지 이해하는 데 도움이 됩니다 (명사로 사용되는 “bank(은행)“과 동사로 사용되는 “bank(예금을 예치하다)“과 같은 경우).</li>",Xt,us,Et,Js,Ft,xs,Dl="질의응답은 또 하나의 토큰 차원의 작업으로, 문맥이 있을 때(개방형 도메인)와 문맥이 없을 때(폐쇄형 도메인) 질문에 대한 답변을 반환합니다. 이 작업은 가상 비서에게 식당이 영업 중인지와 같은 질문을 할 때마다 발생할 수 있습니다. 고객 지원 또는 기술 지원을 제공하거나 검색 엔진이 요청한 정보를 검색하는 데 도움을 줄 수 있습니다.",St,Us,Ol="질문 답변에는 일반적으로 두 가지 유형이 있습니다:",Lt,Ts,sa="<li>추출형: 질문과 문맥이 주어졌을 때, 모델이 주어진 문맥의 일부에서 가져온 텍스트의 범위를 답변으로 합니다.</li> <li>생성형: 질문과 문맥이 주어졌을 때, 주어진 문맥을 통해 답변을 생성합니다. 이 접근 방식은 <code>QuestionAnsweringPipeline</code> 대신 <code>Text2TextGenerationPipeline</code>을 통해 처리됩니다.</li>",At,bs,Pt,ds,Kt,ws,ta="요약은 원본 문서의 의미를 최대한 보존하면서 긴 문서를 짧은 문서로 만드는 작업입니다. 요약은 <code>sequence-to-sequence</code> 작업입니다. 입력보다 짧은 텍스트 시퀀스를 출력합니다. 요약 작업은 독자가 장문 문서들의 주요 포인트를 빠르게 이해하는 데 도움을 줄 수 있습니다. 입법안, 법률 및 금융 문서, 특허 및 과학 논문은 요약 작업이 독자의 시간을 절약하고 독서 보조 도구로 사용될 수 있는 몇 가지 예시입니다.",Dt,fs,la="질문 답변과 마찬가지로 요약에는 두 가지 유형이 있습니다:",Ot,Cs,aa="<li>추출형: 원본 텍스트에서 가장 중요한 문장을 식별하고 추출합니다.</li> <li>생성형: 원본 텍스트에서 목표 요약을 생성합니다. 입력 문서에 없는 새로운 단어를 포함할 수도 있습니다. <code>SummarizationPipeline</code>은 생성형 접근 방식을 사용합니다.</li>",sl,Zs,tl,Is,ll,Bs,na="번역은 한 언어로 된 텍스트 시퀀스를 다른 언어로 변환하는 작업입니다. 이는 서로 다른 배경을 가진 사람들이 서로 소통하는 데 도움을 주는 중요한 역할을 합니다. 더 넓은 대중에게 콘텐츠를 번역하여 전달하거나, 새로운 언어를 배우는 데 도움이 되는 학습 도구가 될 수도 있습니다. 요약과 마찬가지로, 번역은 <code>sequence-to-sequence</code> 작업입니다. 즉, 모델은 입력 시퀀스를 받아서 출력이 되는 목표 시퀀스를 반환합니다.",al,$s,ea="초기의 번역 모델은 대부분 단일 언어로 이루어져 있었지만, 최근에는 많은 언어 쌍 간에 번역을 수행할 수 있는 다중 언어 모델에 대한 관심이 높아지고 있습니다.",nl,Ws,el,ks,pl,Gs,pa="언어 모델링은 텍스트 시퀀스에서 단어를 예측하는 작업입니다. 사전 훈련된 언어 모델은 많은 다른 하위 작업에 따라 미세 조정될 수 있기 때문에 매우 인기 있는 자연어처리 작업이 되었습니다. 최근에는 제로 샷(zero-shot) 또는 퓨 샷(few-shot) 학습이 가능한 대규모 언어 모델(Large Language Models, LLM)에 대한 많은 관심이 발생하고 있습니다. 이는 모델이 명시적으로 훈련되지 않은 작업도 해결할 수 있다는 것을 의미합니다! 언어 모델은 유창하고 설득력 있는 텍스트를 생성하는 데 사용될 수 있지만, 텍스트가 항상 정확하지는 않을 수 있으므로 주의가 필요합니다.",il,Hs,ia="언어 모델링에는 두 가지 유형이 있습니다:",cl,J,qs,Qs,ca="인과적 언어 모델링: 이 모델의 목적은 시퀀스에서 다음 토큰을 예측하는 것이며, 미래 토큰이 마스킹 됩니다.",ol,vs,ul,Vs,zs,ra="마스킹된 언어 모델링: 이 모델의 목적은 시퀀스 내의 마스킹된 토큰을 예측하는 것이며, 시퀀스 내의 모든 토큰에 대한 접근이 제공됩니다.",Jl,Ns,rl,Rs,ja='이 페이지를 통해 각 모달리티의 다양한 작업 유형과 각 작업의 실용적 중요성에 대해 추가적인 배경 정보를 얻으셨기를 바랍니다. 다음 <a href="tasks_explained">섹션</a>에서는 🤗 Transformer가 이러한 작업을 해결하는 <strong>방법</strong>에 대해 알아보실 수 있습니다.',jl,_s,ml,Xs,yl;return U=new g({props:{title:"🤗 Transformers로 할 수 있는 것",local:"what__transformers_can_do",headingTag:"h1"}}),w=new g({props:{title:"오디오",local:"audio",headingTag:"h2"}}),Z=new g({props:{title:"오디오 분류",local:"audio_classification",headingTag:"h3"}}),W=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),k=new g({props:{title:"자동 음성 인식",local:"automatic_speech_recognition",headingTag:"h3"}}),q=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),v=new g({props:{title:"컴퓨터 비전",local:"computer_vision",headingTag:"h2"}}),_=new g({props:{title:"이미지 분류",local:"image_classification",headingTag:"h3"}}),X=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),E=new g({props:{title:"객체 탐지",local:"object_detection",headingTag:"h3"}}),A=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),P=new g({props:{title:"이미지 분할",local:"image_segmentation",headingTag:"h3"}}),ts=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),ls=new g({props:{title:"깊이 추정",local:"depth_estimation",headingTag:"h3"}}),ps=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),is=new g({props:{title:"자연어처리",local:"natural_language_processing",headingTag:"h2"}}),rs=new g({props:{title:"텍스트 분류",local:"text_classification",headingTag:"h3"}}),ys=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),hs=new g({props:{title:"토큰 분류",local:"token_classification",headingTag:"h3"}}),us=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),Js=new g({props:{title:"질의응답",local:"question_answering",headingTag:"h3"}}),bs=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),ds=new g({props:{title:"요약",local:"summarization",headingTag:"h3"}}),Zs=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),Is=new g({props:{title:"번역",local:"translation",headingTag:"h3"}}),Ws=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUtdDUlMkZ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),ks=new g({props:{title:"언어 모델링",local:"language_modeling",headingTag:"h3"}}),vs=new o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),Ns=new o({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),_s=new Ja({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/task_summary.md"}}),{c(){u=p("meta"),Fs=n(),Ys=p("p"),Ss=n(),r(U.$$.fragment),Ls=n(),T=p("p"),T.textContent=Ul,As=n(),b=p("p"),b.textContent=Tl,Ps=n(),d=p("p"),d.textContent=bl,Ks=n(),r(w.$$.fragment),Ds=n(),f=p("p"),f.textContent=dl,Os=n(),C=p("p"),C.textContent=wl,st=n(),r(Z.$$.fragment),tt=n(),I=p("p"),I.textContent=fl,lt=n(),B=p("p"),B.textContent=Cl,at=n(),$=p("ul"),$.innerHTML=Zl,nt=n(),r(W.$$.fragment),et=n(),r(k.$$.fragment),pt=n(),G=p("p"),G.textContent=Il,it=n(),H=p("p"),H.textContent=Bl,ct=n(),r(q.$$.fragment),rt=n(),r(v.$$.fragment),jt=n(),V=p("p"),V.innerHTML=$l,mt=n(),N=p("p"),N.textContent=Wl,yt=n(),R=p("ol"),R.innerHTML=kl,ht=n(),r(_.$$.fragment),Mt=n(),Q=p("p"),Q.textContent=Gl,gt=n(),z=p("p"),z.textContent=Hl,ot=n(),Y=p("ul"),Y.innerHTML=ql,ut=n(),r(X.$$.fragment),Jt=n(),r(E.$$.fragment),xt=n(),F=p("p"),F.textContent=vl,Ut=n(),S=p("p"),S.textContent=Vl,Tt=n(),L=p("ul"),L.innerHTML=Nl,bt=n(),r(A.$$.fragment),dt=n(),r(P.$$.fragment),wt=n(),K=p("p"),K.textContent=Rl,ft=n(),D=p("p"),D.textContent=_l,Ct=n(),O=p("ul"),O.innerHTML=Ql,Zt=n(),ss=p("p"),ss.textContent=zl,It=n(),r(ts.$$.fragment),Bt=n(),r(ls.$$.fragment),$t=n(),as=p("p"),as.textContent=Yl,Wt=n(),ns=p("p"),ns.textContent=Xl,kt=n(),es=p("ul"),es.innerHTML=El,Gt=n(),r(ps.$$.fragment),Ht=n(),r(is.$$.fragment),qt=n(),cs=p("p"),cs.textContent=Fl,vt=n(),r(rs.$$.fragment),Vt=n(),js=p("p"),js.textContent=Sl,Nt=n(),ms=p("ul"),ms.innerHTML=Ll,Rt=n(),r(ys.$$.fragment),_t=n(),r(hs.$$.fragment),Qt=n(),Ms=p("p"),Ms.innerHTML=Al,zt=n(),gs=p("p"),gs.textContent=Pl,Yt=n(),os=p("ul"),os.innerHTML=Kl,Xt=n(),r(us.$$.fragment),Et=n(),r(Js.$$.fragment),Ft=n(),xs=p("p"),xs.textContent=Dl,St=n(),Us=p("p"),Us.textContent=Ol,Lt=n(),Ts=p("ul"),Ts.innerHTML=sa,At=n(),r(bs.$$.fragment),Pt=n(),r(ds.$$.fragment),Kt=n(),ws=p("p"),ws.innerHTML=ta,Dt=n(),fs=p("p"),fs.textContent=la,Ot=n(),Cs=p("ul"),Cs.innerHTML=aa,sl=n(),r(Zs.$$.fragment),tl=n(),r(Is.$$.fragment),ll=n(),Bs=p("p"),Bs.innerHTML=na,al=n(),$s=p("p"),$s.textContent=ea,nl=n(),r(Ws.$$.fragment),el=n(),r(ks.$$.fragment),pl=n(),Gs=p("p"),Gs.textContent=pa,il=n(),Hs=p("p"),Hs.textContent=ia,cl=n(),J=p("ul"),qs=p("li"),Qs=p("p"),Qs.textContent=ca,ol=n(),r(vs.$$.fragment),ul=n(),Vs=p("li"),zs=p("p"),zs.textContent=ra,Jl=n(),r(Ns.$$.fragment),rl=n(),Rs=p("p"),Rs.innerHTML=ja,jl=n(),r(_s.$$.fragment),ml=n(),Xs=p("p"),this.h()},l(s){const t=ua("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),Fs=e(s),Ys=i(s,"P",{}),Es(Ys).forEach(l),Ss=e(s),j(U.$$.fragment,s),Ls=e(s),T=i(s,"P",{"data-svelte-h":!0}),c(T)!=="svelte-10idx7x"&&(T.textContent=Ul),As=e(s),b=i(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-rz0m0r"&&(b.textContent=Tl),Ps=e(s),d=i(s,"P",{"data-svelte-h":!0}),c(d)!=="svelte-d62f10"&&(d.textContent=bl),Ks=e(s),j(w.$$.fragment,s),Ds=e(s),f=i(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-13r673m"&&(f.textContent=dl),Os=e(s),C=i(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-qps12j"&&(C.textContent=wl),st=e(s),j(Z.$$.fragment,s),tt=e(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-18pih3a"&&(I.textContent=fl),lt=e(s),B=i(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-9ctq6o"&&(B.textContent=Cl),at=e(s),$=i(s,"UL",{"data-svelte-h":!0}),c($)!=="svelte-5dixf0"&&($.innerHTML=Zl),nt=e(s),j(W.$$.fragment,s),et=e(s),j(k.$$.fragment,s),pt=e(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-cdyfh4"&&(G.textContent=Il),it=e(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-190cybw"&&(H.textContent=Bl),ct=e(s),j(q.$$.fragment,s),rt=e(s),j(v.$$.fragment,s),jt=e(s),V=i(s,"P",{"data-svelte-h":!0}),c(V)!=="svelte-lp1ekz"&&(V.innerHTML=$l),mt=e(s),N=i(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-uo6axu"&&(N.textContent=Wl),yt=e(s),R=i(s,"OL",{"data-svelte-h":!0}),c(R)!=="svelte-imx589"&&(R.innerHTML=kl),ht=e(s),j(_.$$.fragment,s),Mt=e(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1o1g4f9"&&(Q.textContent=Gl),gt=e(s),z=i(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-14qqsoc"&&(z.textContent=Hl),ot=e(s),Y=i(s,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-1ong27"&&(Y.innerHTML=ql),ut=e(s),j(X.$$.fragment,s),Jt=e(s),j(E.$$.fragment,s),xt=e(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-10dx22t"&&(F.textContent=vl),Ut=e(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1bbfjj6"&&(S.textContent=Vl),Tt=e(s),L=i(s,"UL",{"data-svelte-h":!0}),c(L)!=="svelte-doxpjs"&&(L.innerHTML=Nl),bt=e(s),j(A.$$.fragment,s),dt=e(s),j(P.$$.fragment,s),wt=e(s),K=i(s,"P",{"data-svelte-h":!0}),c(K)!=="svelte-uvfxg5"&&(K.textContent=Rl),ft=e(s),D=i(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1hwst5e"&&(D.textContent=_l),Ct=e(s),O=i(s,"UL",{"data-svelte-h":!0}),c(O)!=="svelte-bh6x2l"&&(O.innerHTML=Ql),Zt=e(s),ss=i(s,"P",{"data-svelte-h":!0}),c(ss)!=="svelte-1spkl8f"&&(ss.textContent=zl),It=e(s),j(ts.$$.fragment,s),Bt=e(s),j(ls.$$.fragment,s),$t=e(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1exjil8"&&(as.textContent=Yl),Wt=e(s),ns=i(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-skr9n9"&&(ns.textContent=Xl),kt=e(s),es=i(s,"UL",{"data-svelte-h":!0}),c(es)!=="svelte-urw9j1"&&(es.innerHTML=El),Gt=e(s),j(ps.$$.fragment,s),Ht=e(s),j(is.$$.fragment,s),qt=e(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-juznik"&&(cs.textContent=Fl),vt=e(s),j(rs.$$.fragment,s),Vt=e(s),js=i(s,"P",{"data-svelte-h":!0}),c(js)!=="svelte-1i4o3md"&&(js.textContent=Sl),Nt=e(s),ms=i(s,"UL",{"data-svelte-h":!0}),c(ms)!=="svelte-5w2u0i"&&(ms.innerHTML=Ll),Rt=e(s),j(ys.$$.fragment,s),_t=e(s),j(hs.$$.fragment,s),Qt=e(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-1hgqh5j"&&(Ms.innerHTML=Al),zt=e(s),gs=i(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-16tsf9c"&&(gs.textContent=Pl),Yt=e(s),os=i(s,"UL",{"data-svelte-h":!0}),c(os)!=="svelte-1wq0vai"&&(os.innerHTML=Kl),Xt=e(s),j(us.$$.fragment,s),Et=e(s),j(Js.$$.fragment,s),Ft=e(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1bb9mft"&&(xs.textContent=Dl),St=e(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-17o3plg"&&(Us.textContent=Ol),Lt=e(s),Ts=i(s,"UL",{"data-svelte-h":!0}),c(Ts)!=="svelte-1ayvag1"&&(Ts.innerHTML=sa),At=e(s),j(bs.$$.fragment,s),Pt=e(s),j(ds.$$.fragment,s),Kt=e(s),ws=i(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-11gr80y"&&(ws.innerHTML=ta),Dt=e(s),fs=i(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-fmz0j8"&&(fs.textContent=la),Ot=e(s),Cs=i(s,"UL",{"data-svelte-h":!0}),c(Cs)!=="svelte-mxtzg1"&&(Cs.innerHTML=aa),sl=e(s),j(Zs.$$.fragment,s),tl=e(s),j(Is.$$.fragment,s),ll=e(s),Bs=i(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-173rkq6"&&(Bs.innerHTML=na),al=e(s),$s=i(s,"P",{"data-svelte-h":!0}),c($s)!=="svelte-4yqe8s"&&($s.textContent=ea),nl=e(s),j(Ws.$$.fragment,s),el=e(s),j(ks.$$.fragment,s),pl=e(s),Gs=i(s,"P",{"data-svelte-h":!0}),c(Gs)!=="svelte-1i9u0s6"&&(Gs.textContent=pa),il=e(s),Hs=i(s,"P",{"data-svelte-h":!0}),c(Hs)!=="svelte-1pvuplr"&&(Hs.textContent=ia),cl=e(s),J=i(s,"UL",{});var hl=Es(J);qs=i(hl,"LI",{});var Ml=Es(qs);Qs=i(Ml,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-bmp22e"&&(Qs.textContent=ca),ol=e(Ml),j(vs.$$.fragment,Ml),Ml.forEach(l),ul=e(hl),Vs=i(hl,"LI",{});var gl=Es(Vs);zs=i(gl,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-axjjse"&&(zs.textContent=ra),Jl=e(gl),j(Ns.$$.fragment,gl),gl.forEach(l),hl.forEach(l),rl=e(s),Rs=i(s,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-sjudlh"&&(Rs.innerHTML=ja),jl=e(s),j(_s.$$.fragment,s),ml=e(s),Xs=i(s,"P",{}),Es(Xs).forEach(l),this.h()},h(){ma(u,"name","hf:doc:metadata"),ma(u,"content",Ua)},m(s,t){x(document.head,u),a(s,Fs,t),a(s,Ys,t),a(s,Ss,t),m(U,s,t),a(s,Ls,t),a(s,T,t),a(s,As,t),a(s,b,t),a(s,Ps,t),a(s,d,t),a(s,Ks,t),m(w,s,t),a(s,Ds,t),a(s,f,t),a(s,Os,t),a(s,C,t),a(s,st,t),m(Z,s,t),a(s,tt,t),a(s,I,t),a(s,lt,t),a(s,B,t),a(s,at,t),a(s,$,t),a(s,nt,t),m(W,s,t),a(s,et,t),m(k,s,t),a(s,pt,t),a(s,G,t),a(s,it,t),a(s,H,t),a(s,ct,t),m(q,s,t),a(s,rt,t),m(v,s,t),a(s,jt,t),a(s,V,t),a(s,mt,t),a(s,N,t),a(s,yt,t),a(s,R,t),a(s,ht,t),m(_,s,t),a(s,Mt,t),a(s,Q,t),a(s,gt,t),a(s,z,t),a(s,ot,t),a(s,Y,t),a(s,ut,t),m(X,s,t),a(s,Jt,t),m(E,s,t),a(s,xt,t),a(s,F,t),a(s,Ut,t),a(s,S,t),a(s,Tt,t),a(s,L,t),a(s,bt,t),m(A,s,t),a(s,dt,t),m(P,s,t),a(s,wt,t),a(s,K,t),a(s,ft,t),a(s,D,t),a(s,Ct,t),a(s,O,t),a(s,Zt,t),a(s,ss,t),a(s,It,t),m(ts,s,t),a(s,Bt,t),m(ls,s,t),a(s,$t,t),a(s,as,t),a(s,Wt,t),a(s,ns,t),a(s,kt,t),a(s,es,t),a(s,Gt,t),m(ps,s,t),a(s,Ht,t),m(is,s,t),a(s,qt,t),a(s,cs,t),a(s,vt,t),m(rs,s,t),a(s,Vt,t),a(s,js,t),a(s,Nt,t),a(s,ms,t),a(s,Rt,t),m(ys,s,t),a(s,_t,t),m(hs,s,t),a(s,Qt,t),a(s,Ms,t),a(s,zt,t),a(s,gs,t),a(s,Yt,t),a(s,os,t),a(s,Xt,t),m(us,s,t),a(s,Et,t),m(Js,s,t),a(s,Ft,t),a(s,xs,t),a(s,St,t),a(s,Us,t),a(s,Lt,t),a(s,Ts,t),a(s,At,t),m(bs,s,t),a(s,Pt,t),m(ds,s,t),a(s,Kt,t),a(s,ws,t),a(s,Dt,t),a(s,fs,t),a(s,Ot,t),a(s,Cs,t),a(s,sl,t),m(Zs,s,t),a(s,tl,t),m(Is,s,t),a(s,ll,t),a(s,Bs,t),a(s,al,t),a(s,$s,t),a(s,nl,t),m(Ws,s,t),a(s,el,t),m(ks,s,t),a(s,pl,t),a(s,Gs,t),a(s,il,t),a(s,Hs,t),a(s,cl,t),a(s,J,t),x(J,qs),x(qs,Qs),x(qs,ol),m(vs,qs,null),x(J,ul),x(J,Vs),x(Vs,zs),x(Vs,Jl),m(Ns,Vs,null),a(s,rl,t),a(s,Rs,t),a(s,jl,t),m(_s,s,t),a(s,ml,t),a(s,Xs,t),yl=!0},p:ha,i(s){yl||(y(U.$$.fragment,s),y(w.$$.fragment,s),y(Z.$$.fragment,s),y(W.$$.fragment,s),y(k.$$.fragment,s),y(q.$$.fragment,s),y(v.$$.fragment,s),y(_.$$.fragment,s),y(X.$$.fragment,s),y(E.$$.fragment,s),y(A.$$.fragment,s),y(P.$$.fragment,s),y(ts.$$.fragment,s),y(ls.$$.fragment,s),y(ps.$$.fragment,s),y(is.$$.fragment,s),y(rs.$$.fragment,s),y(ys.$$.fragment,s),y(hs.$$.fragment,s),y(us.$$.fragment,s),y(Js.$$.fragment,s),y(bs.$$.fragment,s),y(ds.$$.fragment,s),y(Zs.$$.fragment,s),y(Is.$$.fragment,s),y(Ws.$$.fragment,s),y(ks.$$.fragment,s),y(vs.$$.fragment,s),y(Ns.$$.fragment,s),y(_s.$$.fragment,s),yl=!0)},o(s){h(U.$$.fragment,s),h(w.$$.fragment,s),h(Z.$$.fragment,s),h(W.$$.fragment,s),h(k.$$.fragment,s),h(q.$$.fragment,s),h(v.$$.fragment,s),h(_.$$.fragment,s),h(X.$$.fragment,s),h(E.$$.fragment,s),h(A.$$.fragment,s),h(P.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(ps.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(ys.$$.fragment,s),h(hs.$$.fragment,s),h(us.$$.fragment,s),h(Js.$$.fragment,s),h(bs.$$.fragment,s),h(ds.$$.fragment,s),h(Zs.$$.fragment,s),h(Is.$$.fragment,s),h(Ws.$$.fragment,s),h(ks.$$.fragment,s),h(vs.$$.fragment,s),h(Ns.$$.fragment,s),h(_s.$$.fragment,s),yl=!1},d(s){s&&(l(Fs),l(Ys),l(Ss),l(Ls),l(T),l(As),l(b),l(Ps),l(d),l(Ks),l(Ds),l(f),l(Os),l(C),l(st),l(tt),l(I),l(lt),l(B),l(at),l($),l(nt),l(et),l(pt),l(G),l(it),l(H),l(ct),l(rt),l(jt),l(V),l(mt),l(N),l(yt),l(R),l(ht),l(Mt),l(Q),l(gt),l(z),l(ot),l(Y),l(ut),l(Jt),l(xt),l(F),l(Ut),l(S),l(Tt),l(L),l(bt),l(dt),l(wt),l(K),l(ft),l(D),l(Ct),l(O),l(Zt),l(ss),l(It),l(Bt),l($t),l(as),l(Wt),l(ns),l(kt),l(es),l(Gt),l(Ht),l(qt),l(cs),l(vt),l(Vt),l(js),l(Nt),l(ms),l(Rt),l(_t),l(Qt),l(Ms),l(zt),l(gs),l(Yt),l(os),l(Xt),l(Et),l(Ft),l(xs),l(St),l(Us),l(Lt),l(Ts),l(At),l(Pt),l(Kt),l(ws),l(Dt),l(fs),l(Ot),l(Cs),l(sl),l(tl),l(ll),l(Bs),l(al),l($s),l(nl),l(el),l(pl),l(Gs),l(il),l(Hs),l(cl),l(J),l(rl),l(Rs),l(jl),l(ml),l(Xs)),l(u),M(U,s),M(w,s),M(Z,s),M(W,s),M(k,s),M(q,s),M(v,s),M(_,s),M(X,s),M(E,s),M(A,s),M(P,s),M(ts,s),M(ls,s),M(ps,s),M(is,s),M(rs,s),M(ys,s),M(hs,s),M(us,s),M(Js,s),M(bs,s),M(ds,s),M(Zs,s),M(Is,s),M(Ws,s),M(ks,s),M(vs),M(Ns),M(_s,s)}}}const Ua='{"title":"🤗 Transformers로 할 수 있는 것","local":"what__transformers_can_do","sections":[{"title":"오디오","local":"audio","sections":[{"title":"오디오 분류","local":"audio_classification","sections":[],"depth":3},{"title":"자동 음성 인식","local":"automatic_speech_recognition","sections":[],"depth":3}],"depth":2},{"title":"컴퓨터 비전","local":"computer_vision","sections":[{"title":"이미지 분류","local":"image_classification","sections":[],"depth":3},{"title":"객체 탐지","local":"object_detection","sections":[],"depth":3},{"title":"이미지 분할","local":"image_segmentation","sections":[],"depth":3},{"title":"깊이 추정","local":"depth_estimation","sections":[],"depth":3}],"depth":2},{"title":"자연어처리","local":"natural_language_processing","sections":[{"title":"텍스트 분류","local":"text_classification","sections":[],"depth":3},{"title":"토큰 분류","local":"token_classification","sections":[],"depth":3},{"title":"질의응답","local":"question_answering","sections":[],"depth":3},{"title":"요약","local":"summarization","sections":[],"depth":3},{"title":"번역","local":"translation","sections":[],"depth":3},{"title":"언어 모델링","local":"language_modeling","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ta(xl){return Ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends ga{constructor(u){super(),oa(this,u,Ta,xa,ya,{})}}export{Ca as component};
