import{s as Ke,o as Oe,n as es}from"../chunks/scheduler.d586627e.js";import{S as ss,i as as,g as i,s as l,r,A as ts,h as p,f as a,c as n,j as De,u as m,x as h,k as Be,y as ls,a as t,v as c,d,t as u,w as f}from"../chunks/index.8589a59c.js";import{T as ns}from"../chunks/Tip.84e2336e.js";import{C as M}from"../chunks/CodeBlock.dffc9a5b.js";import{H as O,E as is}from"../chunks/getInferenceSnippets.0ddc0a1d.js";function ps(ee){let o,$="Acesse a documentação do <code>pipeline()</code> para obter uma lista completa de tarefas possíveis.";return{c(){o=i("p"),o.innerHTML=$},l(g){o=p(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-18yhfdg"&&(o.innerHTML=$)},m(g,D){t(g,o,D)},p:es,d(g){g&&a(o)}}}function os(ee){let o,$,g,D,b,se,U,He=`Um [pipeline] simplifica o uso dos modelos no <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para a inferência de uma diversidade de tarefas,
como a geração de texto, a segmentação de imagens e a classificação de áudio.
Inclusive, se não tem experiência com alguma modalidade específica ou não compreende o código que forma os modelos,
pode usar eles mesmo assim com o [pipeline]! Este tutorial te ensinará a:`,ae,x,Ve="<li>Utilizar um <code>pipeline()</code> para inferência.</li> <li>Utilizar um tokenizador ou model específico.</li> <li>Utilizar um <code>pipeline()</code> para tarefas de áudio e visão computacional.</li>",te,y,le,T,ne,w,qe=`Mesmo que cada tarefa tenha um <code>pipeline()</code> associado, é mais simples usar a abstração geral do <code>pipeline()</code> que
contém todos os pipelines das tarefas mais específicas.
O <code>pipeline()</code> carrega automaticamenta um modelo predeterminado e um tokenizador com capacidade de inferência para sua
tarefa.`,ie,J,_e="<li>Comece carregando um <code>pipeline()</code> e especifique uma tarefa de inferência:</li>",pe,v,oe,j,Re="<li>Passe seu dado de entrada, no caso um texto, ao <code>pipeline()</code>:</li>",re,Z,me,k,Le="Se tiver mais de uma entrada, passe-a como uma lista:",ce,G,de,I,ze=`Qualquer parâmetro adicional para a sua tarefa também pode ser incluído no <code>pipeline()</code>. A tarefa <code>text-generation</code> tem um método
<code>generate()</code> com vários parâmetros para controlar a saída.
Por exemplo, se quiser gerar mais de uma saída, defina-a no parâmetro <code>num_return_sequences</code>:`,ue,W,fe,C,he,B,Ee=`O <code>pipeline()</code> aceita qualquer modelo do <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Há rótulos adicionais no Model Hub
que te permitem filtrar pelo modelo que gostaria de usar para sua tarefa. Uma vez que tiver escolhido o modelo apropriado,
carregue-o com as classes <code>AutoModelFor</code> e <code>AutoTokenizer</code> correspondentes. Por exemplo, carregue a classe <code>AutoModelForCausalLM</code>
para uma tarefa de modelagem de linguagem causal:`,ge,H,Me,V,Xe="Crie uma <code>pipeline()</code> para a sua tarefa e especifíque o modelo e o tokenizador que foram carregados:",ye,q,je,_,Pe="Passe seu texto de entrada ao <code>pipeline()</code> para gerar algum texto:",$e,R,be,L,Ue,z,Fe=`A flexibilidade do <code>pipeline()</code> significa que também pode-se extender às tarefas de áudio.
La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.`,xe,E,Se=`Por exemplo, classifiquemos a emoção de um breve fragmento do famoso discurso de John F. Kennedy /home/rzimmerdev/dev/transformers/docs/source/pt/pipeline_tutorial.md
Encontre um modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para
reconhecimento de emoções no Model Hub e carregue-o usando o <code>pipeline()</code>:`,Te,X,we,P,Ye="Passe o arquivo de áudio ao <code>pipeline()</code>:",Je,F,ve,S,Ze,Y,Qe=`Finalmente, utilizar um <code>pipeline()</code> para tarefas de visão é praticamente a mesma coisa.
Especifique a sua tarefa de visão e passe a sua imagem ao classificador.
A imagem pode ser um link ou uma rota local à imagem. Por exemplo, que espécie de gato está presente na imagem?`,ke,Q,Ae='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ge,A,Ie,N,We,K,Ce;return b=new O({props:{title:"Pipelines para inferência",local:"pipelines-para-inferência",headingTag:"h1"}}),y=new ns({props:{$$slots:{default:[ps]},$$scope:{ctx:ee}}}),T=new O({props:{title:"Uso do pipeline",local:"uso-do-pipeline",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),G=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new O({props:{title:"Selecionando um modelo e um tokenizador",local:"selecionando-um-modelo-e-um-tokenizador",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),q=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),R=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),L=new O({props:{title:"Pipeline de audio",local:"pipeline-de-audio",headingTag:"h2"}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),F=new M({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`,wrap:!1}}),S=new O({props:{title:"Pipeline de visão computacional",local:"pipeline-de-visão-computacional",headingTag:"h2"}}),A=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`,wrap:!1}}),N=new is({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/pt/pipeline_tutorial.md"}}),{c(){o=i("meta"),$=l(),g=i("p"),D=l(),r(b.$$.fragment),se=l(),U=i("p"),U.innerHTML=He,ae=l(),x=i("ul"),x.innerHTML=Ve,te=l(),r(y.$$.fragment),le=l(),r(T.$$.fragment),ne=l(),w=i("p"),w.innerHTML=qe,ie=l(),J=i("ol"),J.innerHTML=_e,pe=l(),r(v.$$.fragment),oe=l(),j=i("ol"),j.innerHTML=Re,re=l(),r(Z.$$.fragment),me=l(),k=i("p"),k.textContent=Le,ce=l(),r(G.$$.fragment),de=l(),I=i("p"),I.innerHTML=ze,ue=l(),r(W.$$.fragment),fe=l(),r(C.$$.fragment),he=l(),B=i("p"),B.innerHTML=Ee,ge=l(),r(H.$$.fragment),Me=l(),V=i("p"),V.innerHTML=Xe,ye=l(),r(q.$$.fragment),je=l(),_=i("p"),_.innerHTML=Pe,$e=l(),r(R.$$.fragment),be=l(),r(L.$$.fragment),Ue=l(),z=i("p"),z.innerHTML=Fe,xe=l(),E=i("p"),E.innerHTML=Se,Te=l(),r(X.$$.fragment),we=l(),P=i("p"),P.innerHTML=Ye,Je=l(),r(F.$$.fragment),ve=l(),r(S.$$.fragment),Ze=l(),Y=i("p"),Y.innerHTML=Qe,ke=l(),Q=i("p"),Q.innerHTML=Ae,Ge=l(),r(A.$$.fragment),Ie=l(),r(N.$$.fragment),We=l(),K=i("p"),this.h()},l(e){const s=ts("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(a),$=n(e),g=p(e,"P",{}),De(g).forEach(a),D=n(e),m(b.$$.fragment,e),se=n(e),U=p(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-19oh8z4"&&(U.innerHTML=He),ae=n(e),x=p(e,"UL",{"data-svelte-h":!0}),h(x)!=="svelte-18jsh6a"&&(x.innerHTML=Ve),te=n(e),m(y.$$.fragment,e),le=n(e),m(T.$$.fragment,e),ne=n(e),w=p(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-135pr0r"&&(w.innerHTML=qe),ie=n(e),J=p(e,"OL",{"data-svelte-h":!0}),h(J)!=="svelte-157sn41"&&(J.innerHTML=_e),pe=n(e),m(v.$$.fragment,e),oe=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),h(j)!=="svelte-1ouxpvk"&&(j.innerHTML=Re),re=n(e),m(Z.$$.fragment,e),me=n(e),k=p(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-5nw5od"&&(k.textContent=Le),ce=n(e),m(G.$$.fragment,e),de=n(e),I=p(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1w6glba"&&(I.innerHTML=ze),ue=n(e),m(W.$$.fragment,e),fe=n(e),m(C.$$.fragment,e),he=n(e),B=p(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-hbvlde"&&(B.innerHTML=Ee),ge=n(e),m(H.$$.fragment,e),Me=n(e),V=p(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-w3put1"&&(V.innerHTML=Xe),ye=n(e),m(q.$$.fragment,e),je=n(e),_=p(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-qsn026"&&(_.innerHTML=Pe),$e=n(e),m(R.$$.fragment,e),be=n(e),m(L.$$.fragment,e),Ue=n(e),z=p(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-12hxoj"&&(z.innerHTML=Fe),xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-17cq1h3"&&(E.innerHTML=Se),Te=n(e),m(X.$$.fragment,e),we=n(e),P=p(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1khitrh"&&(P.innerHTML=Ye),Je=n(e),m(F.$$.fragment,e),ve=n(e),m(S.$$.fragment,e),Ze=n(e),Y=p(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-bzcqm2"&&(Y.innerHTML=Qe),ke=n(e),Q=p(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1bks2jw"&&(Q.innerHTML=Ae),Ge=n(e),m(A.$$.fragment,e),Ie=n(e),m(N.$$.fragment,e),We=n(e),K=p(e,"P",{}),De(K).forEach(a),this.h()},h(){Be(o,"name","hf:doc:metadata"),Be(o,"content",rs),Be(j,"start","2")},m(e,s){ls(document.head,o),t(e,$,s),t(e,g,s),t(e,D,s),c(b,e,s),t(e,se,s),t(e,U,s),t(e,ae,s),t(e,x,s),t(e,te,s),c(y,e,s),t(e,le,s),c(T,e,s),t(e,ne,s),t(e,w,s),t(e,ie,s),t(e,J,s),t(e,pe,s),c(v,e,s),t(e,oe,s),t(e,j,s),t(e,re,s),c(Z,e,s),t(e,me,s),t(e,k,s),t(e,ce,s),c(G,e,s),t(e,de,s),t(e,I,s),t(e,ue,s),c(W,e,s),t(e,fe,s),c(C,e,s),t(e,he,s),t(e,B,s),t(e,ge,s),c(H,e,s),t(e,Me,s),t(e,V,s),t(e,ye,s),c(q,e,s),t(e,je,s),t(e,_,s),t(e,$e,s),c(R,e,s),t(e,be,s),c(L,e,s),t(e,Ue,s),t(e,z,s),t(e,xe,s),t(e,E,s),t(e,Te,s),c(X,e,s),t(e,we,s),t(e,P,s),t(e,Je,s),c(F,e,s),t(e,ve,s),c(S,e,s),t(e,Ze,s),t(e,Y,s),t(e,ke,s),t(e,Q,s),t(e,Ge,s),c(A,e,s),t(e,Ie,s),c(N,e,s),t(e,We,s),t(e,K,s),Ce=!0},p(e,[s]){const Ne={};s&2&&(Ne.$$scope={dirty:s,ctx:e}),y.$set(Ne)},i(e){Ce||(d(b.$$.fragment,e),d(y.$$.fragment,e),d(T.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(R.$$.fragment,e),d(L.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),Ce=!0)},o(e){u(b.$$.fragment,e),u(y.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),Ce=!1},d(e){e&&(a($),a(g),a(D),a(se),a(U),a(ae),a(x),a(te),a(le),a(ne),a(w),a(ie),a(J),a(pe),a(oe),a(j),a(re),a(me),a(k),a(ce),a(de),a(I),a(ue),a(fe),a(he),a(B),a(ge),a(Me),a(V),a(ye),a(je),a(_),a($e),a(be),a(Ue),a(z),a(xe),a(E),a(Te),a(we),a(P),a(Je),a(ve),a(Ze),a(Y),a(ke),a(Q),a(Ge),a(Ie),a(We),a(K)),a(o),f(b,e),f(y,e),f(T,e),f(v,e),f(Z,e),f(G,e),f(W,e),f(C,e),f(H,e),f(q,e),f(R,e),f(L,e),f(X,e),f(F,e),f(S,e),f(A,e),f(N,e)}}}const rs='{"title":"Pipelines para inferência","local":"pipelines-para-inferência","sections":[{"title":"Uso do pipeline","local":"uso-do-pipeline","sections":[{"title":"Selecionando um modelo e um tokenizador","local":"selecionando-um-modelo-e-um-tokenizador","sections":[],"depth":3}],"depth":2},{"title":"Pipeline de audio","local":"pipeline-de-audio","sections":[],"depth":2},{"title":"Pipeline de visão computacional","local":"pipeline-de-visão-computacional","sections":[],"depth":2}],"depth":1}';function ms(ee){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends ss{constructor(o){super(),as(this,o,ms,os,Ke,{})}}export{gs as component};
