import{s as Ne,o as De,n as Ke}from"../chunks/scheduler.d586627e.js";import{S as Oe,i as es,g as i,s as t,r,A as ss,h as p,f as a,c as n,j as Ae,u as m,x as h,k as We,y as as,a as l,v as c,d,t as u,w as f}from"../chunks/index.8589a59c.js";import{T as ls}from"../chunks/Tip.84e2336e.js";import{C as M}from"../chunks/CodeBlock.47c46d2c.js";import{H as K}from"../chunks/Heading.a70e045b.js";function ts(O){let o,$="Acesse a documentação do <code>pipeline()</code> para obter uma lista completa de tarefas possíveis.";return{c(){o=i("p"),o.innerHTML=$},l(g){o=p(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-18yhfdg"&&(o.innerHTML=$)},m(g,N){l(g,o,N)},p:Ke,d(g){g&&a(o)}}}function ns(O){let o,$,g,N,U,ee,b,Ce=`Um [pipeline] simplifica o uso dos modelos no <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para a inferência de uma diversidade de tarefas,
como a geração de texto, a segmentação de imagens e a classificação de áudio.
Inclusive, se não tem experiência com alguma modalidade específica ou não compreende o código que forma os modelos,
pode usar eles mesmo assim com o [pipeline]! Este tutorial te ensinará a:`,se,x,Be="<li>Utilizar um <code>pipeline()</code> para inferência.</li> <li>Utilizar um tokenizador ou model específico.</li> <li>Utilizar um <code>pipeline()</code> para tarefas de áudio e visão computacional.</li>",ae,y,le,T,te,w,He=`Mesmo que cada tarefa tenha um <code>pipeline()</code> associado, é mais simples usar a abstração geral do <code>pipeline()</code> que
contém todos os pipelines das tarefas mais específicas.
O <code>pipeline()</code> carrega automaticamenta um modelo predeterminado e um tokenizador com capacidade de inferência para sua
tarefa.`,ne,J,Ve="<li>Comece carregando um <code>pipeline()</code> e especifique uma tarefa de inferência:</li>",ie,v,pe,j,qe="<li>Passe seu dado de entrada, no caso um texto, ao <code>pipeline()</code>:</li>",oe,Z,re,k,_e="Se tiver mais de uma entrada, passe-a como uma lista:",me,G,ce,I,Re=`Qualquer parâmetro adicional para a sua tarefa também pode ser incluído no <code>pipeline()</code>. A tarefa <code>text-generation</code> tem um método
<code>generate()</code> com vários parâmetros para controlar a saída.
Por exemplo, se quiser gerar mais de uma saída, defina-a no parâmetro <code>num_return_sequences</code>:`,de,W,ue,C,fe,B,Le=`O <code>pipeline()</code> aceita qualquer modelo do <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Há rótulos adicionais no Model Hub
que te permitem filtrar pelo modelo que gostaria de usar para sua tarefa. Uma vez que tiver escolhido o modelo apropriado,
carregue-o com as classes <code>AutoModelFor</code> e <code>AutoTokenizer</code> correspondentes. Por exemplo, carregue a classe <code>AutoModelForCausalLM</code>
para uma tarefa de modelagem de linguagem causal:`,he,H,ge,V,ze="Crie uma <code>pipeline()</code> para a sua tarefa e especifíque o modelo e o tokenizador que foram carregados:",Me,q,ye,_,Xe="Passe seu texto de entrada ao <code>pipeline()</code> para gerar algum texto:",je,R,$e,L,Ue,z,Ee=`A flexibilidade do <code>pipeline()</code> significa que também pode-se extender às tarefas de áudio.
La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.`,be,X,Pe=`Por exemplo, classifiquemos a emoção de um breve fragmento do famoso discurso de John F. Kennedy /home/rzimmerdev/dev/transformers/docs/source/pt/pipeline_tutorial.md
Encontre um modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para
reconhecimento de emoções no Model Hub e carregue-o usando o <code>pipeline()</code>:`,xe,E,Te,P,Fe="Passe o arquivo de áudio ao <code>pipeline()</code>:",we,F,Je,S,ve,Y,Se=`Finalmente, utilizar um <code>pipeline()</code> para tarefas de visão é praticamente a mesma coisa.
Especifique a sua tarefa de visão e passe a sua imagem ao classificador.
A imagem pode ser um link ou uma rota local à imagem. Por exemplo, que espécie de gato está presente na imagem?`,Ze,Q,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',ke,A,Ge,D,Ie;return U=new K({props:{title:"Pipelines para inferência",local:"pipelines-para-inferência",headingTag:"h1"}}),y=new ls({props:{$$slots:{default:[ts]},$$scope:{ctx:O}}}),T=new K({props:{title:"Uso do pipeline",local:"uso-do-pipeline",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),G=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new K({props:{title:"Selecionando um modelo e um tokenizador",local:"selecionando-um-modelo-e-um-tokenizador",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),q=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),R=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),L=new K({props:{title:"Pipeline de audio",local:"pipeline-de-audio",headingTag:"h2"}}),E=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),F=new M({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`,wrap:!1}}),S=new K({props:{title:"Pipeline de visão computacional",local:"pipeline-de-visão-computacional",headingTag:"h2"}}),A=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`,wrap:!1}}),{c(){o=i("meta"),$=t(),g=i("p"),N=t(),r(U.$$.fragment),ee=t(),b=i("p"),b.innerHTML=Ce,se=t(),x=i("ul"),x.innerHTML=Be,ae=t(),r(y.$$.fragment),le=t(),r(T.$$.fragment),te=t(),w=i("p"),w.innerHTML=He,ne=t(),J=i("ol"),J.innerHTML=Ve,ie=t(),r(v.$$.fragment),pe=t(),j=i("ol"),j.innerHTML=qe,oe=t(),r(Z.$$.fragment),re=t(),k=i("p"),k.textContent=_e,me=t(),r(G.$$.fragment),ce=t(),I=i("p"),I.innerHTML=Re,de=t(),r(W.$$.fragment),ue=t(),r(C.$$.fragment),fe=t(),B=i("p"),B.innerHTML=Le,he=t(),r(H.$$.fragment),ge=t(),V=i("p"),V.innerHTML=ze,Me=t(),r(q.$$.fragment),ye=t(),_=i("p"),_.innerHTML=Xe,je=t(),r(R.$$.fragment),$e=t(),r(L.$$.fragment),Ue=t(),z=i("p"),z.innerHTML=Ee,be=t(),X=i("p"),X.innerHTML=Pe,xe=t(),r(E.$$.fragment),Te=t(),P=i("p"),P.innerHTML=Fe,we=t(),r(F.$$.fragment),Je=t(),r(S.$$.fragment),ve=t(),Y=i("p"),Y.innerHTML=Se,Ze=t(),Q=i("p"),Q.innerHTML=Ye,ke=t(),r(A.$$.fragment),Ge=t(),D=i("p"),this.h()},l(e){const s=ss("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(a),$=n(e),g=p(e,"P",{}),Ae(g).forEach(a),N=n(e),m(U.$$.fragment,e),ee=n(e),b=p(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-19oh8z4"&&(b.innerHTML=Ce),se=n(e),x=p(e,"UL",{"data-svelte-h":!0}),h(x)!=="svelte-18jsh6a"&&(x.innerHTML=Be),ae=n(e),m(y.$$.fragment,e),le=n(e),m(T.$$.fragment,e),te=n(e),w=p(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-135pr0r"&&(w.innerHTML=He),ne=n(e),J=p(e,"OL",{"data-svelte-h":!0}),h(J)!=="svelte-157sn41"&&(J.innerHTML=Ve),ie=n(e),m(v.$$.fragment,e),pe=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),h(j)!=="svelte-1ouxpvk"&&(j.innerHTML=qe),oe=n(e),m(Z.$$.fragment,e),re=n(e),k=p(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-5nw5od"&&(k.textContent=_e),me=n(e),m(G.$$.fragment,e),ce=n(e),I=p(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1w6glba"&&(I.innerHTML=Re),de=n(e),m(W.$$.fragment,e),ue=n(e),m(C.$$.fragment,e),fe=n(e),B=p(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-hbvlde"&&(B.innerHTML=Le),he=n(e),m(H.$$.fragment,e),ge=n(e),V=p(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-w3put1"&&(V.innerHTML=ze),Me=n(e),m(q.$$.fragment,e),ye=n(e),_=p(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-qsn026"&&(_.innerHTML=Xe),je=n(e),m(R.$$.fragment,e),$e=n(e),m(L.$$.fragment,e),Ue=n(e),z=p(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-12hxoj"&&(z.innerHTML=Ee),be=n(e),X=p(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-17cq1h3"&&(X.innerHTML=Pe),xe=n(e),m(E.$$.fragment,e),Te=n(e),P=p(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1khitrh"&&(P.innerHTML=Fe),we=n(e),m(F.$$.fragment,e),Je=n(e),m(S.$$.fragment,e),ve=n(e),Y=p(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-bzcqm2"&&(Y.innerHTML=Se),Ze=n(e),Q=p(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1bks2jw"&&(Q.innerHTML=Ye),ke=n(e),m(A.$$.fragment,e),Ge=n(e),D=p(e,"P",{}),Ae(D).forEach(a),this.h()},h(){We(o,"name","hf:doc:metadata"),We(o,"content",is),We(j,"start","2")},m(e,s){as(document.head,o),l(e,$,s),l(e,g,s),l(e,N,s),c(U,e,s),l(e,ee,s),l(e,b,s),l(e,se,s),l(e,x,s),l(e,ae,s),c(y,e,s),l(e,le,s),c(T,e,s),l(e,te,s),l(e,w,s),l(e,ne,s),l(e,J,s),l(e,ie,s),c(v,e,s),l(e,pe,s),l(e,j,s),l(e,oe,s),c(Z,e,s),l(e,re,s),l(e,k,s),l(e,me,s),c(G,e,s),l(e,ce,s),l(e,I,s),l(e,de,s),c(W,e,s),l(e,ue,s),c(C,e,s),l(e,fe,s),l(e,B,s),l(e,he,s),c(H,e,s),l(e,ge,s),l(e,V,s),l(e,Me,s),c(q,e,s),l(e,ye,s),l(e,_,s),l(e,je,s),c(R,e,s),l(e,$e,s),c(L,e,s),l(e,Ue,s),l(e,z,s),l(e,be,s),l(e,X,s),l(e,xe,s),c(E,e,s),l(e,Te,s),l(e,P,s),l(e,we,s),c(F,e,s),l(e,Je,s),c(S,e,s),l(e,ve,s),l(e,Y,s),l(e,Ze,s),l(e,Q,s),l(e,ke,s),c(A,e,s),l(e,Ge,s),l(e,D,s),Ie=!0},p(e,[s]){const Qe={};s&2&&(Qe.$$scope={dirty:s,ctx:e}),y.$set(Qe)},i(e){Ie||(d(U.$$.fragment,e),d(y.$$.fragment,e),d(T.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(R.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),Ie=!0)},o(e){u(U.$$.fragment,e),u(y.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),Ie=!1},d(e){e&&(a($),a(g),a(N),a(ee),a(b),a(se),a(x),a(ae),a(le),a(te),a(w),a(ne),a(J),a(ie),a(pe),a(j),a(oe),a(re),a(k),a(me),a(ce),a(I),a(de),a(ue),a(fe),a(B),a(he),a(ge),a(V),a(Me),a(ye),a(_),a(je),a($e),a(Ue),a(z),a(be),a(X),a(xe),a(Te),a(P),a(we),a(Je),a(ve),a(Y),a(Ze),a(Q),a(ke),a(Ge),a(D)),a(o),f(U,e),f(y,e),f(T,e),f(v,e),f(Z,e),f(G,e),f(W,e),f(C,e),f(H,e),f(q,e),f(R,e),f(L,e),f(E,e),f(F,e),f(S,e),f(A,e)}}}const is='{"title":"Pipelines para inferência","local":"pipelines-para-inferência","sections":[{"title":"Uso do pipeline","local":"uso-do-pipeline","sections":[{"title":"Selecionando um modelo e um tokenizador","local":"selecionando-um-modelo-e-um-tokenizador","sections":[],"depth":3}],"depth":2},{"title":"Pipeline de audio","local":"pipeline-de-audio","sections":[],"depth":2},{"title":"Pipeline de visão computacional","local":"pipeline-de-visão-computacional","sections":[],"depth":2}],"depth":1}';function ps(O){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Oe{constructor(o){super(),es(this,o,ps,ns,Ne,{})}}export{us as component};
