import{s as rs,o as ws,n as Ts}from"../chunks/scheduler.8c3d61f6.js";import{S as js,i as ms,g as i,s as a,r as J,A as ds,h as p,f as e,c as n,j as cs,u as y,x as M,k as Js,y as us,a as t,v as T,d as r,t as w,w as j}from"../chunks/index.da70eac4.js";import{T as ys}from"../chunks/Tip.1d9b8c37.js";import{C as U}from"../chunks/CodeBlock.a9c4becf.js";import{H as Us,E as bs}from"../chunks/getInferenceSnippets.725ed3d4.js";function hs(tl){let o,b="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){o=i("p"),o.innerHTML=b},l(c){o=p(c,"P",{"data-svelte-h":!0}),M(o)!=="svelte-11qh5l3"&&(o.innerHTML=b)},m(c,m){t(c,o,m)},p:Ts,d(c){c&&e(o)}}}function ks(tl){let o,b='Other types of multi-blocks include <a href="sequential_pipeline_blocks.md">SequentialPipelineBlocks</a> (for linear workflows) and <a href="loop_sequential_pipeline_blocks.md">LoopSequentialPipelineBlocks</a> (for iterative workflows). For information on creating individual blocks, see the <a href="pipeline_block.md">PipelineBlock guide</a>.',c,m,h='Additionally, like all <code>ModularPipelineBlocks</code>, <code>AutoPipelineBlocks</code> are definitions/specifications, not runnable pipelines. You need to convert them into a <code>ModularPipeline</code> to actually execute them. For information on creating and running pipelines, see the <a href="modular_pipeline.md">Modular Pipeline guide</a>.';return{c(){o=i("p"),o.innerHTML=b,c=a(),m=i("p"),m.innerHTML=h},l(d){o=p(d,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1sajd2r"&&(o.innerHTML=b),c=n(d),m=p(d,"P",{"data-svelte-h":!0}),M(m)!=="svelte-670hni"&&(m.innerHTML=h)},m(d,u){t(d,o,u),t(d,c,u),t(d,m,u)},p:Ts,d(d){d&&(e(o),e(c),e(m))}}}function Is(tl){let o,b,c,m,h,d,u,nl,I,Ql="<code>AutoPipelineBlocks</code> is a subclass of <code>ModularPipelineBlocks</code>. It is a multi-block that automatically selects which sub-blocks to run based on the inputs provided at runtime, creating conditional workflows that adapt to different scenarios. The main purpose is convenience and portability - for developers, you can package everything into one workflow, making it easier to share and use.",il,B,Vl="In this tutorial, we will show you how to create an <code>AutoPipelineBlocks</code> and learn more about how the conditional selection works.",pl,k,ol,N,Sl="For example, you might want to support text-to-image and image-to-image tasks. Instead of creating two separate pipelines, you can create an <code>AutoPipelineBlocks</code> that automatically chooses the workflow based on whether an <code>image</code> input is provided.",Ml,f,Rl='Let’s see an example. We’ll use the helper function from the <a href="./pipeline_block.md">PipelineBlock guide</a> to create our blocks:',cl,E,Fl="<strong>Helper Function</strong>",Jl,g,yl,C,zl="Now let’s create a dummy <code>AutoPipelineBlocks</code> that includes dummy text-to-image, image-to-image, and inpaint pipelines.",Tl,G,rl,_,ql="Now we have created an <code>AutoPipelineBlocks</code> that contains 3 sub-blocks. Notice the warning message at the top - this automatically appears in every <code>ModularPipelineBlocks</code> that contains <code>AutoPipelineBlocks</code> to remind end users that dynamic block selection happens at runtime.",wl,Z,jl,W,$l="Check out the documentation with <code>print(auto_pipeline.doc)</code>:",ml,A,dl,Y,Pl="There is a fundamental trade-off of AutoPipelineBlocks: it trades clarity for convenience. While it is really easy for packaging multiple workflows, it can become confusing without proper documentation. e.g. if we just throw a pipeline at you and tell you that it contains 3 sub-blocks and takes 3 inputs <code>prompt</code>, <code>image</code> and <code>mask</code>, and ask you to run an image-to-image workflow: if you don’t have any prior knowledge on how these pipelines work, you would be pretty clueless, right?",ul,x,Ll="This pipeline we just made though, has a docstring that shows all available inputs and workflows and explains how to use each with different inputs. So it’s really helpful for users. For example, it’s clear that you need to pass <code>image</code> to run img2img. This is why the description field is absolutely critical for AutoPipelineBlocks. We highly recommend you to explain the conditional logic very well for each <code>AutoPipelineBlocks</code> you would make. We also recommend to always test individual pipelines first before packaging them into AutoPipelineBlocks.",Ul,v,Dl="Let’s run this auto pipeline with different inputs to see if the conditional logic works as described. Remember that we have added <code>print</code> in each <code>PipelineBlock</code>’s <code>__call__</code> method to print out its workflow name, so it should be easy to tell which one is running:",bl,X,hl,H,Kl="However, even with documentation, it can become very confusing when AutoPipelineBlocks are combined with other blocks. The complexity grows quickly when you have nested AutoPipelineBlocks or use them as sub-blocks in larger pipelines.",kl,Q,Ol="Let’s make another <code>AutoPipelineBlocks</code> - this one only contains one block, and it does not include <code>None</code> in its <code>block_trigger_inputs</code> (which corresponds to the default block to run when none of the trigger inputs are provided). This means this block will be skipped if the trigger input (<code>ip_adapter_image</code>) is not provided at runtime.",Il,V,Bl,S,ls="Now let’s combine these 2 auto blocks together into a <code>SequentialPipelineBlocks</code>:",Nl,R,fl,F,ss="Let’s take a look: now things get more confusing. In this particular example, you could still try to explain the conditional logic in the <code>description</code> field here - there are only 4 possible execution paths so it’s doable. However, since this is a <code>SequentialPipelineBlocks</code> that could contain many more blocks, the complexity can quickly get out of hand as the number of blocks increases.",El,z,gl,q,es="This is when the <code>get_execution_blocks()</code> method comes in handy - it basically extracts a <code>SequentialPipelineBlocks</code> that only contains the blocks that are actually run based on your inputs.",Cl,$,ts="Let’s try some examples:",Gl,P,as="<code>mask</code>: we expect it to skip the first ip-adapter since <code>ip_adapter_image</code> is not provided, and then run the inpaint for the second block.",_l,L,Zl,D,ns="Let’s also actually run the pipeline to confirm:",Wl,K,Al,O,is="Try a few more:",Yl,ll,xl,sl,ps="In summary, <code>AutoPipelineBlocks</code> is a good tool for packaging multiple workflows into a single, convenient interface and it can greatly simplify the user experience. However, always provide clear descriptions explaining the conditional logic, test individual pipelines first before combining them, and use <code>get_execution_blocks()</code> to understand runtime behavior in complex compositions.",vl,el,Xl,al,Hl;return h=new Us({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h1"}}),u=new ys({props:{warning:!0,$$slots:{default:[hs]},$$scope:{ctx:tl}}}),k=new ys({props:{$$slots:{default:[ks]},$$scope:{ctx:tl}}}),g=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> PipelineBlock, InputParam, OutputParam
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_block</span>(<span class="hljs-params">inputs=[], intermediate_inputs=[], intermediate_outputs=[], block_fn=<span class="hljs-literal">None</span>, description=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">class</span> <span class="hljs-title class_">TestBlock</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
        model_name = <span class="hljs-string">&quot;test&quot;</span>
        
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_outputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> description <span class="hljs-keyword">if</span> description <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;&quot;</span>
            
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
            block_state = self.get_block_state(state)
            <span class="hljs-keyword">if</span> block_fn <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                block_state = block_fn(block_state, state)
            self.set_block_state(state, block_state)
            <span class="hljs-keyword">return</span> components, state
    
    <span class="hljs-keyword">return</span> TestBlock`,wrap:!1}}),G=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> AutoPipelineBlocks 

<span class="hljs-comment"># These are dummy blocks and we only focus on &quot;inputs&quot; for our purpose</span>
inputs = [InputParam(name=<span class="hljs-string">&quot;prompt&quot;</span>)]
<span class="hljs-comment"># block_fn prints out which workflow is running so we can see the execution order at runtime</span>
block_fn = <span class="hljs-keyword">lambda</span> x, y: <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;running the text-to-image workflow&quot;</span>)
block_t2i_cls = make_block(inputs=inputs, block_fn=block_fn, description=<span class="hljs-string">&quot;I&#x27;m a text-to-image workflow!&quot;</span>)

inputs = [InputParam(name=<span class="hljs-string">&quot;prompt&quot;</span>), InputParam(name=<span class="hljs-string">&quot;image&quot;</span>)]
block_fn = <span class="hljs-keyword">lambda</span> x, y: <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;running the image-to-image workflow&quot;</span>)
block_i2i_cls = make_block(inputs=inputs, block_fn=block_fn, description=<span class="hljs-string">&quot;I&#x27;m a image-to-image workflow!&quot;</span>)

inputs = [InputParam(name=<span class="hljs-string">&quot;prompt&quot;</span>), InputParam(name=<span class="hljs-string">&quot;image&quot;</span>), InputParam(name=<span class="hljs-string">&quot;mask&quot;</span>)]
block_fn = <span class="hljs-keyword">lambda</span> x, y: <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;running the inpaint workflow&quot;</span>)
block_inpaint_cls = make_block(inputs=inputs, block_fn=block_fn, description=<span class="hljs-string">&quot;I&#x27;m a inpaint workflow!&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">AutoImageBlocks</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    <span class="hljs-comment"># List of sub-block classes to choose from</span>
    block_classes = [block_inpaint_cls, block_i2i_cls, block_t2i_cls]
    <span class="hljs-comment"># Names for each block in the same order</span>
    block_names = [<span class="hljs-string">&quot;inpaint&quot;</span>, <span class="hljs-string">&quot;img2img&quot;</span>, <span class="hljs-string">&quot;text2img&quot;</span>]
    <span class="hljs-comment"># Trigger inputs that determine which block to run</span>
    <span class="hljs-comment"># - &quot;mask&quot; triggers inpaint workflow</span>
    <span class="hljs-comment"># - &quot;image&quot; triggers img2img workflow (but only if mask is not provided) </span>
    <span class="hljs-comment"># - if none of above, runs the text2img workflow (default)</span>
    block_trigger_inputs = [<span class="hljs-string">&quot;mask&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-comment"># Description is extremely important for AutoPipelineBlocks</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">&quot;Pipeline generates images given different types of conditions!\\n&quot;</span>
            + <span class="hljs-string">&quot;This is an auto pipeline block that works for text2img, img2img and inpainting tasks.\\n&quot;</span>
            + <span class="hljs-string">&quot; - inpaint workflow is run when \`mask\` is provided.\\n&quot;</span>
            + <span class="hljs-string">&quot; - img2img workflow is run when \`image\` is provided (but only when \`mask\` is not provided).\\n&quot;</span>
            + <span class="hljs-string">&quot; - text2img workflow is run when neither \`image\` nor \`mask\` is provided.\\n&quot;</span>
        )

<span class="hljs-comment"># Create the blocks</span>
auto_blocks = AutoImageBlocks()
<span class="hljs-comment"># convert to pipeline</span>
auto_pipeline = auto_blocks.init_pipeline()`,wrap:!1}}),Z=new U({props:{code:"QXV0b0ltYWdlQmxvY2tzKCUwQSUyMCUyMENsYXNzJTNBJTIwQXV0b1BpcGVsaW5lQmxvY2tzJTBBJTBBJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTIwJTIwVGhpcyUyMHBpcGVsaW5lJTIwY29udGFpbnMlMjBibG9ja3MlMjB0aGF0JTIwYXJlJTIwc2VsZWN0ZWQlMjBhdCUyMHJ1bnRpbWUlMjBiYXNlZCUyMG9uJTIwaW5wdXRzLiUwQSUyMCUyMFRyaWdnZXIlMjBJbnB1dHMlM0ElMjAlNUInbWFzayclMkMlMjAnaW1hZ2UnJTVEJTBBJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBJTBBJTIwJTIwRGVzY3JpcHRpb24lM0ElMjBQaXBlbGluZSUyMGdlbmVyYXRlcyUyMGltYWdlcyUyMGdpdmVuJTIwZGlmZmVyZW50JTIwdHlwZXMlMjBvZiUyMGNvbmRpdGlvbnMhJTBBJTIwJTIwJTIwJTIwJTIwJTIwVGhpcyUyMGlzJTIwYW4lMjBhdXRvJTIwcGlwZWxpbmUlMjBibG9jayUyMHRoYXQlMjB3b3JrcyUyMGZvciUyMHRleHQyaW1nJTJDJTIwaW1nMmltZyUyMGFuZCUyMGlucGFpbnRpbmclMjB0YXNrcy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtJTIwaW5wYWludCUyMHdvcmtmbG93JTIwaXMlMjBydW4lMjB3aGVuJTIwJTYwbWFzayU2MCUyMGlzJTIwcHJvdmlkZWQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGltZzJpbWclMjB3b3JrZmxvdyUyMGlzJTIwcnVuJTIwd2hlbiUyMCU2MGltYWdlJTYwJTIwaXMlMjBwcm92aWRlZCUyMChidXQlMjBvbmx5JTIwd2hlbiUyMCU2MG1hc2slNjAlMjBpcyUyMG5vdCUyMHByb3ZpZGVkKS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtJTIwdGV4dDJpbWclMjB3b3JrZmxvdyUyMGlzJTIwcnVuJTIwd2hlbiUyMG5laXRoZXIlMjAlNjBpbWFnZSU2MCUyMG5vciUyMCU2MG1hc2slNjAlMjBpcyUyMHByb3ZpZGVkLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUwQSUwQSUwQSUyMCUyMFN1Yi1CbG9ja3MlM0ElMEElMjAlMjAlMjAlMjAlRTIlODAlQTIlMjBpbnBhaW50JTIwJTVCdHJpZ2dlciUzQSUyMG1hc2slNUQlMjAoVGVzdEJsb2NrKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMERlc2NyaXB0aW9uJTNBJTIwSSdtJTIwYSUyMGlucGFpbnQlMjB3b3JrZmxvdyElMEElMEElMjAlMjAlMjAlMjAlRTIlODAlQTIlMjBpbWcyaW1nJTIwJTVCdHJpZ2dlciUzQSUyMGltYWdlJTVEJTIwKFRlc3RCbG9jayklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXNjcmlwdGlvbiUzQSUyMEknbSUyMGElMjBpbWFnZS10by1pbWFnZSUyMHdvcmtmbG93ISUwQSUwQSUyMCUyMCUyMCUyMCVFMiU4MCVBMiUyMHRleHQyaW1nJTIwJTVCZGVmYXVsdCU1RCUyMChUZXN0QmxvY2spJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGVzY3JpcHRpb24lM0ElMjBJJ20lMjBhJTIwdGV4dC10by1pbWFnZSUyMHdvcmtmbG93ISUwQSUwQSk=",highlighted:`AutoImageBlocks(
  Class: AutoPipelineBlocks

  ====================================================================================================
  This pipeline contains blocks that are selected at runtime based on inputs.
  Trigger Inputs: [<span class="hljs-string">&#x27;mask&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>]
  ====================================================================================================


  Description: Pipeline generates images given different types of conditions!
      This <span class="hljs-keyword">is</span> an auto pipeline block that works <span class="hljs-keyword">for</span> text2img, img2img <span class="hljs-keyword">and</span> inpainting tasks.
       - inpaint workflow <span class="hljs-keyword">is</span> run when \`mask\` <span class="hljs-keyword">is</span> provided.
       - img2img workflow <span class="hljs-keyword">is</span> run when \`image\` <span class="hljs-keyword">is</span> provided (but only when \`mask\` <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> provided).
       - text2img workflow <span class="hljs-keyword">is</span> run when neither \`image\` nor \`mask\` <span class="hljs-keyword">is</span> provided.
      


  Sub-Blocks:
    • inpaint [trigger: mask] (TestBlock)
       Description: I<span class="hljs-string">&#x27;m a inpaint workflow!

    • img2img [trigger: image] (TestBlock)
       Description: I&#x27;</span>m a image-to-image workflow!

    • text2img [default] (TestBlock)
       Description: I<span class="hljs-string">&#x27;m a text-to-image workflow!

)</span>`,wrap:!1}}),A=new U({props:{code:"cHJpbnQoYXV0b19waXBlbGluZS5kb2MpJTBBJTBBJTBBJTBBJTBB",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(auto_pipeline.doc)\n<span class="hljs-keyword">class</span> <span class="hljs-title class_">AutoImageBlocks</span>\n\n  Pipeline generates images given different types of conditions!\n  This <span class="hljs-keyword">is</span> an auto pipeline block that works <span class="hljs-keyword">for</span> text2img, img2img <span class="hljs-keyword">and</span> inpainting tasks.\n   - inpaint workflow <span class="hljs-keyword">is</span> run when `mask` <span class="hljs-keyword">is</span> provided.\n   - img2img workflow <span class="hljs-keyword">is</span> run when `image` <span class="hljs-keyword">is</span> provided (but only when `mask` <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> provided).\n   - text2img workflow <span class="hljs-keyword">is</span> run when neither `image` nor `mask` <span class="hljs-keyword">is</span> provided.\n\n  Inputs:\n\n      prompt (`<span class="hljs-literal">None</span>`, *optional*):\n\n      image (`<span class="hljs-literal">None</span>`, *optional*):\n\n      mask (`<span class="hljs-literal">None</span>`, *optional*):',wrap:!1}}),X=new U({props:{code:"XyUyMCUzRCUyMGF1dG9fcGlwZWxpbmUoaW1hZ2UlM0QlMjJpbWFnZSUyMiUyQyUyMG1hc2slM0QlMjJtYXNrJTIyKSUwQV8lMjAlM0QlMjBhdXRvX3BpcGVsaW5lKGltYWdlJTNEJTIyaW1hZ2UlMjIpJTBBXyUyMCUzRCUyMGF1dG9fcGlwZWxpbmUocHJvbXB0JTNEJTIycHJvbXB0JTIyKSUwQV8lMjAlM0QlMjBhdXRvX3BpcGVsaW5lKGltYWdlJTNEJTIycHJvbXB0JTIyJTJDJTIwbWFzayUzRCUyMm1hc2slMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>_ = auto_pipeline(image=<span class="hljs-string">&quot;image&quot;</span>, mask=<span class="hljs-string">&quot;mask&quot;</span>)
running the inpaint workflow
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = auto_pipeline(image=<span class="hljs-string">&quot;image&quot;</span>)
running the image-to-image workflow
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = auto_pipeline(prompt=<span class="hljs-string">&quot;prompt&quot;</span>)
running the text-to-image workflow
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = auto_pipeline(image=<span class="hljs-string">&quot;prompt&quot;</span>, mask=<span class="hljs-string">&quot;mask&quot;</span>)
running the inpaint workflow`,wrap:!1}}),V=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyMEluc2VydGFibGVEaWN0JTBBaW5wdXRzJTIwJTNEJTIwJTVCSW5wdXRQYXJhbShuYW1lJTNEJTIyaXBfYWRhcHRlcl9pbWFnZSUyMiklNUQlMEFibG9ja19mbiUyMCUzRCUyMGxhbWJkYSUyMHglMkMlMjB5JTNBJTIwcHJpbnQoJTIycnVubmluZyUyMHRoZSUyMGlwLWFkYXB0ZXIlMjB3b3JrZmxvdyUyMiklMEFibG9ja19pcGFfY2xzJTIwJTNEJTIwbWFrZV9ibG9jayhpbnB1dHMlM0RpbnB1dHMlMkMlMjBibG9ja19mbiUzRGJsb2NrX2ZuJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJJJ20lMjBhJTIwSVAtYWRhcHRlciUyMHdvcmtmbG93ISUyMiklMEElMEFjbGFzcyUyMEF1dG9JUEFkYXB0ZXIoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJibG9ja19pcGFfY2xzJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJpcC1hZGFwdGVyJTIyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfdHJpZ2dlcl9pbnB1dHMlMjAlM0QlMjAlNUIlMjJpcF9hZGFwdGVyX2ltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBkZXNjcmlwdGlvbihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlJ1biUyMElQJTIwQWRhcHRlciUyMHN0ZXAlMjBpZiUyMCU2MGlwX2FkYXB0ZXJfaW1hZ2UlNjAlMjBpcyUyMHByb3ZpZGVkLiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks, InsertableDict
inputs = [InputParam(name=<span class="hljs-string">&quot;ip_adapter_image&quot;</span>)]
block_fn = <span class="hljs-keyword">lambda</span> x, y: <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;running the ip-adapter workflow&quot;</span>)
block_ipa_cls = make_block(inputs=inputs, block_fn=block_fn, description=<span class="hljs-string">&quot;I&#x27;m a IP-adapter workflow!&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">AutoIPAdapter</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [block_ipa_cls]
    block_names = [<span class="hljs-string">&quot;ip-adapter&quot;</span>]
    block_trigger_inputs = [<span class="hljs-string">&quot;ip_adapter_image&quot;</span>]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Run IP Adapter step if \`ip_adapter_image\` is provided.&quot;</span>`,wrap:!1}}),R=new U({props:{code:"YXV0b19pcGFfYmxvY2tzJTIwJTNEJTIwQXV0b0lQQWRhcHRlcigpJTBBYmxvY2tzX2RpY3QlMjAlM0QlMjBJbnNlcnRhYmxlRGljdCgpJTBBYmxvY2tzX2RpY3QlNUIlMjJpcC1hZGFwdGVyJTIyJTVEJTIwJTNEJTIwYXV0b19pcGFfYmxvY2tzJTBBYmxvY2tzX2RpY3QlNUIlMjJpbWFnZS1nZW5lcmF0aW9uJTIyJTVEJTIwJTNEJTIwYXV0b19ibG9ja3MlMEFhbGxfYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoYmxvY2tzX2RpY3QpJTBBcGlwZWxpbmUlMjAlM0QlMjBhbGxfYmxvY2tzLmluaXRfcGlwZWxpbmUoKQ==",highlighted:`auto_ipa_blocks = AutoIPAdapter()
blocks_dict = InsertableDict()
blocks_dict[<span class="hljs-string">&quot;ip-adapter&quot;</span>] = auto_ipa_blocks
blocks_dict[<span class="hljs-string">&quot;image-generation&quot;</span>] = auto_blocks
all_blocks = SequentialPipelineBlocks.from_blocks_dict(blocks_dict)
pipeline = all_blocks.init_pipeline()`,wrap:!1}}),z=new U({props:{code:"YWxsX2Jsb2NrcyUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_blocks
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  ====================================================================================================
  This pipeline contains blocks that are selected at runtime based on inputs.
  Trigger Inputs: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;mask&#x27;</span>, <span class="hljs-string">&#x27;ip_adapter_image&#x27;</span>]
  Use \`get_execution_blocks()\` <span class="hljs-keyword">with</span> <span class="hljs-built_in">input</span> names to see selected blocks (e.g. \`get_execution_blocks(<span class="hljs-string">&#x27;image&#x27;</span>)\`).
  ====================================================================================================


  Description: 


  Sub-Blocks:
    [<span class="hljs-number">0</span>] ip-adapter (AutoIPAdapter)
       Description: Run IP Adapter step <span class="hljs-keyword">if</span> \`ip_adapter_image\` <span class="hljs-keyword">is</span> provided.
                   

    [<span class="hljs-number">1</span>] image-generation (AutoImageBlocks)
       Description: Pipeline generates images given different types of conditions!
                   This <span class="hljs-keyword">is</span> an auto pipeline block that works <span class="hljs-keyword">for</span> text2img, img2img <span class="hljs-keyword">and</span> inpainting tasks.
                    - inpaint workflow <span class="hljs-keyword">is</span> run when \`mask\` <span class="hljs-keyword">is</span> provided.
                    - img2img workflow <span class="hljs-keyword">is</span> run when \`image\` <span class="hljs-keyword">is</span> provided (but only when \`mask\` <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> provided).
                    - text2img workflow <span class="hljs-keyword">is</span> run when neither \`image\` nor \`mask\` <span class="hljs-keyword">is</span> provided.
                   

)
`,wrap:!1}}),L=new U({props:{code:"YWxsX2Jsb2Nrcy5nZXRfZXhlY3V0aW9uX2Jsb2NrcygnbWFzaycpJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_blocks.get_execution_blocks(<span class="hljs-string">&#x27;mask&#x27;</span>)
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  Description: 


  Sub-Blocks:
    [<span class="hljs-number">0</span>] image-generation (TestBlock)
       Description: I<span class="hljs-string">&#x27;m a inpaint workflow!

)</span>`,wrap:!1}}),K=new U({props:{code:"XyUyMCUzRCUyMHBpcGVsaW5lKG1hc2slM0QlMjJtYXNrJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipeline(mask=<span class="hljs-string">&quot;mask&quot;</span>)
skipping auto block: AutoIPAdapter
running the inpaint workflow`,wrap:!1}}),ll=new U({props:{code:"cHJpbnQoZiUyMmlucHV0cyUzQSUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0ElMjIpJTBBYmxvY2tzX3NlbGVjdCUyMCUzRCUyMGFsbF9ibG9ja3MuZ2V0X2V4ZWN1dGlvbl9ibG9ja3MoJ2lwX2FkYXB0ZXJfaW1hZ2UnKSUwQXByaW50KGYlMjJleHBlY3RlZF9leGVjdXRpb25fYmxvY2tzJTNBJTIwJTdCYmxvY2tzX3NlbGVjdCU3RCUyMiklMEFwcmludChmJTIyYWN0dWFsJTIwZXhlY3V0aW9uJTIwYmxvY2tzJTNBJTIyKSUwQV8lMjAlM0QlMjBwaXBlbGluZShpcF9hZGFwdGVyX2ltYWdlJTNEJTIyaXBfYWRhcHRlcl9pbWFnZSUyMiUyQyUyMHByb21wdCUzRCUyMnByb21wdCUyMiklMEElMjMlMjBleHBlY3QlMjB0byUyMHNlZSUyMGlwLWFkYXB0ZXIlMjAlMkIlMjB0ZXh0MmltZyUwQSUwQXByaW50KGYlMjJpbnB1dHMlM0ElMjBpbWFnZSUzQSUyMiklMEFibG9ja3Nfc2VsZWN0JTIwJTNEJTIwYWxsX2Jsb2Nrcy5nZXRfZXhlY3V0aW9uX2Jsb2NrcygnaW1hZ2UnKSUwQXByaW50KGYlMjJleHBlY3RlZF9leGVjdXRpb25fYmxvY2tzJTNBJTIwJTdCYmxvY2tzX3NlbGVjdCU3RCUyMiklMEFwcmludChmJTIyYWN0dWFsJTIwZXhlY3V0aW9uJTIwYmxvY2tzJTNBJTIyKSUwQV8lMjAlM0QlMjBwaXBlbGluZShpbWFnZSUzRCUyMmltYWdlJTIyJTJDJTIwcHJvbXB0JTNEJTIycHJvbXB0JTIyKSUwQSUyMyUyMGV4cGVjdCUyMHRvJTIwc2VlJTIwaW1nMmltZyUwQSUwQXByaW50KGYlMjJpbnB1dHMlM0ElMjBwcm9tcHQlM0ElMjIpJTBBYmxvY2tzX3NlbGVjdCUyMCUzRCUyMGFsbF9ibG9ja3MuZ2V0X2V4ZWN1dGlvbl9ibG9ja3MoJ3Byb21wdCcpJTBBcHJpbnQoZiUyMmV4cGVjdGVkX2V4ZWN1dGlvbl9ibG9ja3MlM0ElMjAlN0JibG9ja3Nfc2VsZWN0JTdEJTIyKSUwQXByaW50KGYlMjJhY3R1YWwlMjBleGVjdXRpb24lMjBibG9ja3MlM0ElMjIpJTBBXyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRCUyMnByb21wdCUyMiklMEElMjMlMjBleHBlY3QlMjB0byUyMHNlZSUyMHRleHQyaW1nJTIwKHByb21wdCUyMGlzJTIwbm90JTIwYSUyMHRyaWdnZXIlMjBpbnB1dCUyMHNvJTIwZmFsbGJhY2slMjB0byUyMGRlZmF1bHQpJTBBJTBBcHJpbnQoZiUyMmlucHV0cyUzQSUyMG1hc2slMjAlMkIlMjBpcF9hZGFwdGVyX2ltYWdlJTNBJTIyKSUwQWJsb2Nrc19zZWxlY3QlMjAlM0QlMjBhbGxfYmxvY2tzLmdldF9leGVjdXRpb25fYmxvY2tzKCdtYXNrJyUyQydpcF9hZGFwdGVyX2ltYWdlJyklMEFwcmludChmJTIyZXhwZWN0ZWRfZXhlY3V0aW9uX2Jsb2NrcyUzQSUyMCU3QmJsb2Nrc19zZWxlY3QlN0QlMjIpJTBBcHJpbnQoZiUyMmFjdHVhbCUyMGV4ZWN1dGlvbiUyMGJsb2NrcyUzQSUyMiklMEFfJTIwJTNEJTIwcGlwZWxpbmUobWFzayUzRCUyMm1hc2slMjIlMkMlMjBpcF9hZGFwdGVyX2ltYWdlJTNEJTIyaXBfYWRhcHRlcl9pbWFnZSUyMiklMEElMjMlMjBleHBlY3QlMjB0byUyMHNlZSUyMGlwLWFkYXB0ZXIlMjAlMkIlMjBpbnBhaW50",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;inputs: ip_adapter_image:&quot;</span>)
blocks_select = all_blocks.get_execution_blocks(<span class="hljs-string">&#x27;ip_adapter_image&#x27;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;expected_execution_blocks: <span class="hljs-subst">{blocks_select}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;actual execution blocks:&quot;</span>)
_ = pipeline(ip_adapter_image=<span class="hljs-string">&quot;ip_adapter_image&quot;</span>, prompt=<span class="hljs-string">&quot;prompt&quot;</span>)
<span class="hljs-comment"># expect to see ip-adapter + text2img</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;inputs: image:&quot;</span>)
blocks_select = all_blocks.get_execution_blocks(<span class="hljs-string">&#x27;image&#x27;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;expected_execution_blocks: <span class="hljs-subst">{blocks_select}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;actual execution blocks:&quot;</span>)
_ = pipeline(image=<span class="hljs-string">&quot;image&quot;</span>, prompt=<span class="hljs-string">&quot;prompt&quot;</span>)
<span class="hljs-comment"># expect to see img2img</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;inputs: prompt:&quot;</span>)
blocks_select = all_blocks.get_execution_blocks(<span class="hljs-string">&#x27;prompt&#x27;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;expected_execution_blocks: <span class="hljs-subst">{blocks_select}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;actual execution blocks:&quot;</span>)
_ = pipeline(prompt=<span class="hljs-string">&quot;prompt&quot;</span>)
<span class="hljs-comment"># expect to see text2img (prompt is not a trigger input so fallback to default)</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;inputs: mask + ip_adapter_image:&quot;</span>)
blocks_select = all_blocks.get_execution_blocks(<span class="hljs-string">&#x27;mask&#x27;</span>,<span class="hljs-string">&#x27;ip_adapter_image&#x27;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;expected_execution_blocks: <span class="hljs-subst">{blocks_select}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;actual execution blocks:&quot;</span>)
_ = pipeline(mask=<span class="hljs-string">&quot;mask&quot;</span>, ip_adapter_image=<span class="hljs-string">&quot;ip_adapter_image&quot;</span>)
<span class="hljs-comment"># expect to see ip-adapter + inpaint</span>`,wrap:!1}}),el=new bs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/auto_pipeline_blocks.md"}}),{c(){o=i("meta"),b=a(),c=i("p"),m=a(),J(h.$$.fragment),d=a(),J(u.$$.fragment),nl=a(),I=i("p"),I.innerHTML=Ql,il=a(),B=i("p"),B.innerHTML=Vl,pl=a(),J(k.$$.fragment),ol=a(),N=i("p"),N.innerHTML=Sl,Ml=a(),f=i("p"),f.innerHTML=Rl,cl=a(),E=i("p"),E.innerHTML=Fl,Jl=a(),J(g.$$.fragment),yl=a(),C=i("p"),C.innerHTML=zl,Tl=a(),J(G.$$.fragment),rl=a(),_=i("p"),_.innerHTML=ql,wl=a(),J(Z.$$.fragment),jl=a(),W=i("p"),W.innerHTML=$l,ml=a(),J(A.$$.fragment),dl=a(),Y=i("p"),Y.innerHTML=Pl,ul=a(),x=i("p"),x.innerHTML=Ll,Ul=a(),v=i("p"),v.innerHTML=Dl,bl=a(),J(X.$$.fragment),hl=a(),H=i("p"),H.textContent=Kl,kl=a(),Q=i("p"),Q.innerHTML=Ol,Il=a(),J(V.$$.fragment),Bl=a(),S=i("p"),S.innerHTML=ls,Nl=a(),J(R.$$.fragment),fl=a(),F=i("p"),F.innerHTML=ss,El=a(),J(z.$$.fragment),gl=a(),q=i("p"),q.innerHTML=es,Cl=a(),$=i("p"),$.textContent=ts,Gl=a(),P=i("p"),P.innerHTML=as,_l=a(),J(L.$$.fragment),Zl=a(),D=i("p"),D.textContent=ns,Wl=a(),J(K.$$.fragment),Al=a(),O=i("p"),O.textContent=is,Yl=a(),J(ll.$$.fragment),xl=a(),sl=i("p"),sl.innerHTML=ps,vl=a(),J(el.$$.fragment),Xl=a(),al=i("p"),this.h()},l(l){const s=ds("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(e),b=n(l),c=p(l,"P",{}),cs(c).forEach(e),m=n(l),y(h.$$.fragment,l),d=n(l),y(u.$$.fragment,l),nl=n(l),I=p(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-mnhl3k"&&(I.innerHTML=Ql),il=n(l),B=p(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-2zzq1v"&&(B.innerHTML=Vl),pl=n(l),y(k.$$.fragment,l),ol=n(l),N=p(l,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1vl4ct9"&&(N.innerHTML=Sl),Ml=n(l),f=p(l,"P",{"data-svelte-h":!0}),M(f)!=="svelte-6r1dwm"&&(f.innerHTML=Rl),cl=n(l),E=p(l,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1doi555"&&(E.innerHTML=Fl),Jl=n(l),y(g.$$.fragment,l),yl=n(l),C=p(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-j4ivop"&&(C.innerHTML=zl),Tl=n(l),y(G.$$.fragment,l),rl=n(l),_=p(l,"P",{"data-svelte-h":!0}),M(_)!=="svelte-ab78gz"&&(_.innerHTML=ql),wl=n(l),y(Z.$$.fragment,l),jl=n(l),W=p(l,"P",{"data-svelte-h":!0}),M(W)!=="svelte-gdbz8g"&&(W.innerHTML=$l),ml=n(l),y(A.$$.fragment,l),dl=n(l),Y=p(l,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1hyz85d"&&(Y.innerHTML=Pl),ul=n(l),x=p(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-w9jep0"&&(x.innerHTML=Ll),Ul=n(l),v=p(l,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1ohmy0h"&&(v.innerHTML=Dl),bl=n(l),y(X.$$.fragment,l),hl=n(l),H=p(l,"P",{"data-svelte-h":!0}),M(H)!=="svelte-jdpirs"&&(H.textContent=Kl),kl=n(l),Q=p(l,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1p46svu"&&(Q.innerHTML=Ol),Il=n(l),y(V.$$.fragment,l),Bl=n(l),S=p(l,"P",{"data-svelte-h":!0}),M(S)!=="svelte-s6ib93"&&(S.innerHTML=ls),Nl=n(l),y(R.$$.fragment,l),fl=n(l),F=p(l,"P",{"data-svelte-h":!0}),M(F)!=="svelte-ec72dx"&&(F.innerHTML=ss),El=n(l),y(z.$$.fragment,l),gl=n(l),q=p(l,"P",{"data-svelte-h":!0}),M(q)!=="svelte-93ywld"&&(q.innerHTML=es),Cl=n(l),$=p(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-duj019"&&($.textContent=ts),Gl=n(l),P=p(l,"P",{"data-svelte-h":!0}),M(P)!=="svelte-5e2q2p"&&(P.innerHTML=as),_l=n(l),y(L.$$.fragment,l),Zl=n(l),D=p(l,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1ekzn1m"&&(D.textContent=ns),Wl=n(l),y(K.$$.fragment,l),Al=n(l),O=p(l,"P",{"data-svelte-h":!0}),M(O)!=="svelte-183uoi5"&&(O.textContent=is),Yl=n(l),y(ll.$$.fragment,l),xl=n(l),sl=p(l,"P",{"data-svelte-h":!0}),M(sl)!=="svelte-9lxtc7"&&(sl.innerHTML=ps),vl=n(l),y(el.$$.fragment,l),Xl=n(l),al=p(l,"P",{}),cs(al).forEach(e),this.h()},h(){Js(o,"name","hf:doc:metadata"),Js(o,"content",Bs)},m(l,s){us(document.head,o),t(l,b,s),t(l,c,s),t(l,m,s),T(h,l,s),t(l,d,s),T(u,l,s),t(l,nl,s),t(l,I,s),t(l,il,s),t(l,B,s),t(l,pl,s),T(k,l,s),t(l,ol,s),t(l,N,s),t(l,Ml,s),t(l,f,s),t(l,cl,s),t(l,E,s),t(l,Jl,s),T(g,l,s),t(l,yl,s),t(l,C,s),t(l,Tl,s),T(G,l,s),t(l,rl,s),t(l,_,s),t(l,wl,s),T(Z,l,s),t(l,jl,s),t(l,W,s),t(l,ml,s),T(A,l,s),t(l,dl,s),t(l,Y,s),t(l,ul,s),t(l,x,s),t(l,Ul,s),t(l,v,s),t(l,bl,s),T(X,l,s),t(l,hl,s),t(l,H,s),t(l,kl,s),t(l,Q,s),t(l,Il,s),T(V,l,s),t(l,Bl,s),t(l,S,s),t(l,Nl,s),T(R,l,s),t(l,fl,s),t(l,F,s),t(l,El,s),T(z,l,s),t(l,gl,s),t(l,q,s),t(l,Cl,s),t(l,$,s),t(l,Gl,s),t(l,P,s),t(l,_l,s),T(L,l,s),t(l,Zl,s),t(l,D,s),t(l,Wl,s),T(K,l,s),t(l,Al,s),t(l,O,s),t(l,Yl,s),T(ll,l,s),t(l,xl,s),t(l,sl,s),t(l,vl,s),T(el,l,s),t(l,Xl,s),t(l,al,s),Hl=!0},p(l,[s]){const os={};s&2&&(os.$$scope={dirty:s,ctx:l}),u.$set(os);const Ms={};s&2&&(Ms.$$scope={dirty:s,ctx:l}),k.$set(Ms)},i(l){Hl||(r(h.$$.fragment,l),r(u.$$.fragment,l),r(k.$$.fragment,l),r(g.$$.fragment,l),r(G.$$.fragment,l),r(Z.$$.fragment,l),r(A.$$.fragment,l),r(X.$$.fragment,l),r(V.$$.fragment,l),r(R.$$.fragment,l),r(z.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),Hl=!0)},o(l){w(h.$$.fragment,l),w(u.$$.fragment,l),w(k.$$.fragment,l),w(g.$$.fragment,l),w(G.$$.fragment,l),w(Z.$$.fragment,l),w(A.$$.fragment,l),w(X.$$.fragment,l),w(V.$$.fragment,l),w(R.$$.fragment,l),w(z.$$.fragment,l),w(L.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(el.$$.fragment,l),Hl=!1},d(l){l&&(e(b),e(c),e(m),e(d),e(nl),e(I),e(il),e(B),e(pl),e(ol),e(N),e(Ml),e(f),e(cl),e(E),e(Jl),e(yl),e(C),e(Tl),e(rl),e(_),e(wl),e(jl),e(W),e(ml),e(dl),e(Y),e(ul),e(x),e(Ul),e(v),e(bl),e(hl),e(H),e(kl),e(Q),e(Il),e(Bl),e(S),e(Nl),e(fl),e(F),e(El),e(gl),e(q),e(Cl),e($),e(Gl),e(P),e(_l),e(Zl),e(D),e(Wl),e(Al),e(O),e(Yl),e(xl),e(sl),e(vl),e(Xl),e(al)),e(o),j(h,l),j(u,l),j(k,l),j(g,l),j(G,l),j(Z,l),j(A,l),j(X,l),j(V,l),j(R,l),j(z,l),j(L,l),j(K,l),j(ll,l),j(el,l)}}}const Bs='{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":1}';function Ns(tl){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends js{constructor(o){super(),ms(this,o,Ns,Is,rs,{})}}export{_s as component};
