import{s as ue,n as we,o as ye}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as fe,g as l,s as i,u as c,A as je,h as n,f as e,c as o,j as h,v as d,y as m,k as p,o as r,a,w as M,d as g,t as u,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Ht){let y,ht,st,mt,J,v,at,k,Vt,D,Yt="ECA-ResNet",ct,Z,zt='An <strong>ECA ResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that utilises an <a href="https://paperswithcode.com/method/efficient-channel-attention" rel="nofollow">Efficient Channel Attention module</a>. Efficient Channel Attention is an architectural unit based on <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> that reduces model complexity without dimensionality reduction.',dt,f,U,lt,$,At,q,Ft="How do I use this model on an image?",Mt,N,Pt="To load a pretrained model:",gt,W,ut,E,Lt="To load and preprocess the image:",wt,B,yt,_,Dt="To get the model predictions:",Jt,G,ft,Q,qt="To get the top-5 predictions class names:",jt,V,Tt,A,Kt="Replace the model name with the variant you want to use, e.g. <code>ecaresnet101d</code>. You can find the IDs in the model summaries at the top of this page.",bt,R,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,j,C,nt,X,Rt,K,te="How do I finetune this model?",Ut,S,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,H,It,Y,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,T,I,it,z,Xt,O,ae="How do I train this model?",kt,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,b,x,ot,P,St,tt,ne="Citation",$t,L,Nt,pt,Wt;return k=new rt({}),$=new rt({}),W=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VjYXJlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),V=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),X=new rt({}),H=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWNhcmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QndhbmcyMDIwZWNhbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JFQ0EtTmV0JTNBJTIwRWZmaWNpZW50JTIwQ2hhbm5lbCUyMEF0dGVudGlvbiUyMGZvciUyMERlZXAlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JRaWxvbmclMjBXYW5nJTIwYW5kJTIwQmFuZ2d1JTIwV3UlMjBhbmQlMjBQZW5nZmVpJTIwWmh1JTIwYW5kJTIwUGVpaHVhJTIwTGklMjBhbmQlMjBXYW5nbWVuZyUyMFp1byUyMGFuZCUyMFFpbmdodWElMjBIdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMC4wMzE1MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{wang2020ecanet,
      title={ECA-Net: Efficient Channel Attention for Deep Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qilong Wang and Banggu Wu and Pengfei Zhu and Peihua Li and Wangmeng Zuo and Qinghua Hu}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1910.03151}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){y=l("meta"),ht=i(),st=l("p"),mt=i(),J=l("h1"),v=l("a"),at=l("span"),c(k.$$.fragment),Vt=i(),D=l("span"),D.textContent=Yt,ct=i(),Z=l("p"),Z.innerHTML=zt,dt=i(),f=l("h2"),U=l("a"),lt=l("span"),c($.$$.fragment),At=i(),q=l("span"),q.textContent=Ft,Mt=i(),N=l("p"),N.textContent=Pt,gt=i(),c(W.$$.fragment),ut=i(),E=l("p"),E.textContent=Lt,wt=i(),c(B.$$.fragment),yt=i(),_=l("p"),_.textContent=Dt,Jt=i(),c(G.$$.fragment),ft=i(),Q=l("p"),Q.textContent=qt,jt=i(),c(V.$$.fragment),Tt=i(),A=l("p"),A.innerHTML=Kt,bt=i(),R=l("p"),R.innerHTML=Ot,vt=i(),j=l("h2"),C=l("a"),nt=l("span"),c(X.$$.fragment),Rt=i(),K=l("span"),K.textContent=te,Ut=i(),S=l("p"),S.textContent=ee,Ct=i(),c(H.$$.fragment),It=i(),Y=l("p"),Y.innerHTML=se,xt=i(),T=l("h2"),I=l("a"),it=l("span"),c(z.$$.fragment),Xt=i(),O=l("span"),O.textContent=ae,kt=i(),F=l("p"),F.innerHTML=le,Zt=i(),b=l("h2"),x=l("a"),ot=l("span"),c(P.$$.fragment),St=i(),tt=l("span"),tt.textContent=ne,$t=i(),c(L.$$.fragment),Nt=i(),pt=l("p"),this.h()},l(t){const s=je("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=o(t),st=n(t,"P",{}),h(st).forEach(e),mt=o(t),J=n(t,"H1",{class:!0});var Et=h(J);v=n(Et,"A",{id:!0,class:!0,href:!0});var ie=h(v);at=n(ie,"SPAN",{});var oe=h(at);d(k.$$.fragment,oe),oe.forEach(e),ie.forEach(e),Vt=o(Et),D=n(Et,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-10bzrcc"&&(D.textContent=Yt),Et.forEach(e),ct=o(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1ly2dl5"&&(Z.innerHTML=zt),dt=o(t),f=n(t,"H2",{class:!0});var Bt=h(f);U=n(Bt,"A",{id:!0,class:!0,href:!0});var pe=h(U);lt=n(pe,"SPAN",{});var re=h(lt);d($.$$.fragment,re),re.forEach(e),pe.forEach(e),At=o(Bt),q=n(Bt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Bt.forEach(e),Mt=o(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),gt=o(t),d(W.$$.fragment,t),ut=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Lt),wt=o(t),d(B.$$.fragment,t),yt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),Jt=o(t),d(G.$$.fragment,t),ft=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-19cnvx1"&&(Q.textContent=qt),jt=o(t),d(V.$$.fragment,t),Tt=o(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-r0xl90"&&(A.innerHTML=Kt),bt=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1wmi3ea"&&(R.innerHTML=Ot),vt=o(t),j=n(t,"H2",{class:!0});var _t=h(j);C=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(X.$$.fragment,me),me.forEach(e),he.forEach(e),Rt=o(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=o(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-9sr7nh"&&(S.textContent=ee),Ct=o(t),d(H.$$.fragment,t),It=o(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1kguc51"&&(Y.innerHTML=se),xt=o(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(I);it=n(ce,"SPAN",{});var de=h(it);d(z.$$.fragment,de),de.forEach(e),ce.forEach(e),Xt=o(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),kt=o(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),Zt=o(t),b=n(t,"H2",{class:!0});var Qt=h(b);x=n(Qt,"A",{id:!0,class:!0,href:!0});var Me=h(x);ot=n(Me,"SPAN",{});var ge=h(ot);d(P.$$.fragment,ge),ge.forEach(e),Me.forEach(e),St=o(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Qt.forEach(e),$t=o(t),d(L.$$.fragment,t),Nt=o(t),pt=n(t,"P",{}),h(pt).forEach(e),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(be)),p(v,"id","ecaresnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#ecaresnet"),p(J,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(f,"class","relative group"),p(C,"id","how-do-i-finetune-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-finetune-this-model"),p(j,"class","relative group"),p(I,"id","how-do-i-train-this-model"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p(x,"id","citation"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,y),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,v),r(v,at),M(k,at,null),r(J,Vt),r(J,D),a(t,ct,s),a(t,Z,s),a(t,dt,s),a(t,f,s),r(f,U),r(U,lt),M($,lt,null),r(f,At),r(f,q),a(t,Mt,s),a(t,N,s),a(t,gt,s),M(W,t,s),a(t,ut,s),a(t,E,s),a(t,wt,s),M(B,t,s),a(t,yt,s),a(t,_,s),a(t,Jt,s),M(G,t,s),a(t,ft,s),a(t,Q,s),a(t,jt,s),M(V,t,s),a(t,Tt,s),a(t,A,s),a(t,bt,s),a(t,R,s),a(t,vt,s),a(t,j,s),r(j,C),r(C,nt),M(X,nt,null),r(j,Rt),r(j,K),a(t,Ut,s),a(t,S,s),a(t,Ct,s),M(H,t,s),a(t,It,s),a(t,Y,s),a(t,xt,s),a(t,T,s),r(T,I),r(I,it),M(z,it,null),r(T,Xt),r(T,O),a(t,kt,s),a(t,F,s),a(t,Zt,s),a(t,b,s),r(b,x),r(x,ot),M(P,ot,null),r(b,St),r(b,tt),a(t,$t,s),M(L,t,s),a(t,Nt,s),a(t,pt,s),Wt=!0},p:we,i(t){Wt||(g(k.$$.fragment,t),g($.$$.fragment,t),g(W.$$.fragment,t),g(B.$$.fragment,t),g(G.$$.fragment,t),g(V.$$.fragment,t),g(X.$$.fragment,t),g(H.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Wt=!0)},o(t){u(k.$$.fragment,t),u($.$$.fragment,t),u(W.$$.fragment,t),u(B.$$.fragment,t),u(G.$$.fragment,t),u(V.$$.fragment,t),u(X.$$.fragment,t),u(H.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Wt=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e(Z),e(dt),e(f),e(Mt),e(N),e(gt),e(ut),e(E),e(wt),e(yt),e(_),e(Jt),e(ft),e(Q),e(jt),e(Tt),e(A),e(bt),e(R),e(vt),e(j),e(Ut),e(S),e(Ct),e(It),e(Y),e(xt),e(T),e(kt),e(F),e(Zt),e(b),e($t),e(Nt),e(pt)),e(y),w(k),w($),w(W,t),w(B,t),w(G,t),w(V,t),w(X),w(H,t),w(z),w(P),w(L,t)}}}const be={local:"ecaresnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"ECA-ResNet"};function ve(Ht){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ke extends Je{constructor(y){super(),fe(this,y,ve,Te,ue,{})}}export{ke as component};
