import{s as wt,n as dt,o as Jt}from"../chunks/scheduler.85c25b89.js";import{S as ut,i as Tt,g as a,s as o,u as m,A as Ut,h as n,f as t,c as p,j as r,v as c,y as h,k as M,o as i,a as e,w as j,d as y,t as w,x as d}from"../chunks/index.9633332f.js";import{I as il}from"../chunks/IconCopyLink.a4acffac.js";import{C as tl}from"../chunks/CodeBlock.00597c71.js";function gt(Xl){let J,rl,sl,hl,u,C,el,k,_l,L,Hl="MobileNet v3",ml,Z,Fl='<strong>MobileNetV3</strong> is a convolutional neural network that is designed for mobile phone CPUs. The network design includes the use of a <a href="https://paperswithcode.com/method/hard-swish" rel="nofollow">hard swish activation</a> and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation</a> modules in the <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">MBConv blocks</a>.',cl,T,f,al,N,Rl,q,zl="How do I use this model on an image?",jl,B,Dl="To load a pretrained model:",yl,E,wl,x,Pl="To load and preprocess the image:",dl,W,Jl,$,Ll="To get the model predictions:",ul,G,Tl,Q,ql="To get the top-5 predictions class names:",Ul,_,gl,R,Kl="Replace the model name with the variant you want to use, e.g. <code>mobilenetv3_large_100</code>. You can find the IDs in the model summaries at the top of this page.",bl,Y,Ol='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Cl,U,A,nl,S,Yl,K,lt="How do I finetune this model?",fl,V,tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Al,X,Il,H,st=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,vl,g,I,ol,F,Sl,O,et="How do I train this model?",kl,z,at='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zl,b,v,pl,D,Vl,ll,nt="Citation",Nl,P,Bl,Ml,El;return k=new il({}),N=new il({}),E=new tl({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYzX2xhcmdlXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),W=new tl({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new tl({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),_=new tl({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new il({}),X=new tl({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new il({}),D=new il({}),P=new tl({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1905-02244,</span>
  author    = {Andrew Howard <span class="hljs-keyword">and</span>
               Mark Sandler <span class="hljs-keyword">and</span>
               Grace Chu <span class="hljs-keyword">and</span>
               Liang{-}Chieh Chen <span class="hljs-keyword">and</span>
               Bo Chen <span class="hljs-keyword">and</span>
               Mingxing Tan <span class="hljs-keyword">and</span>
               Weijun Wang <span class="hljs-keyword">and</span>
               Yukun Zhu <span class="hljs-keyword">and</span>
               Ruoming Pang <span class="hljs-keyword">and</span>
               Vijay Vasudevan <span class="hljs-keyword">and</span>
               Quoc V. Le <span class="hljs-keyword">and</span>
               Hartwig Adam},
  title     = {Searching for MobileNetV3},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1905.02244},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1905-02244.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`}}),{c(){J=a("meta"),rl=o(),sl=a("p"),hl=o(),u=a("h1"),C=a("a"),el=a("span"),m(k.$$.fragment),_l=o(),L=a("span"),L.textContent=Hl,ml=o(),Z=a("p"),Z.innerHTML=Fl,cl=o(),T=a("h2"),f=a("a"),al=a("span"),m(N.$$.fragment),Rl=o(),q=a("span"),q.textContent=zl,jl=o(),B=a("p"),B.textContent=Dl,yl=o(),m(E.$$.fragment),wl=o(),x=a("p"),x.textContent=Pl,dl=o(),m(W.$$.fragment),Jl=o(),$=a("p"),$.textContent=Ll,ul=o(),m(G.$$.fragment),Tl=o(),Q=a("p"),Q.textContent=ql,Ul=o(),m(_.$$.fragment),gl=o(),R=a("p"),R.innerHTML=Kl,bl=o(),Y=a("p"),Y.innerHTML=Ol,Cl=o(),U=a("h2"),A=a("a"),nl=a("span"),m(S.$$.fragment),Yl=o(),K=a("span"),K.textContent=lt,fl=o(),V=a("p"),V.textContent=tt,Al=o(),m(X.$$.fragment),Il=o(),H=a("p"),H.innerHTML=st,vl=o(),g=a("h2"),I=a("a"),ol=a("span"),m(F.$$.fragment),Sl=o(),O=a("span"),O.textContent=et,kl=o(),z=a("p"),z.innerHTML=at,Zl=o(),b=a("h2"),v=a("a"),pl=a("span"),m(D.$$.fragment),Vl=o(),ll=a("span"),ll.textContent=nt,Nl=o(),m(P.$$.fragment),Bl=o(),Ml=a("p"),this.h()},l(l){const s=Ut("svelte-1phssyn",document.head);J=n(s,"META",{name:!0,content:!0}),s.forEach(t),rl=p(l),sl=n(l,"P",{}),r(sl).forEach(t),hl=p(l),u=n(l,"H1",{class:!0});var xl=r(u);C=n(xl,"A",{id:!0,class:!0,href:!0});var ot=r(C);el=n(ot,"SPAN",{});var pt=r(el);c(k.$$.fragment,pt),pt.forEach(t),ot.forEach(t),_l=p(xl),L=n(xl,"SPAN",{"data-svelte-h":!0}),h(L)!=="svelte-1i22jt5"&&(L.textContent=Hl),xl.forEach(t),ml=p(l),Z=n(l,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1xpy3t9"&&(Z.innerHTML=Fl),cl=p(l),T=n(l,"H2",{class:!0});var Wl=r(T);f=n(Wl,"A",{id:!0,class:!0,href:!0});var Mt=r(f);al=n(Mt,"SPAN",{});var it=r(al);c(N.$$.fragment,it),it.forEach(t),Mt.forEach(t),Rl=p(Wl),q=n(Wl,"SPAN",{"data-svelte-h":!0}),h(q)!=="svelte-1c1hspn"&&(q.textContent=zl),Wl.forEach(t),jl=p(l),B=n(l,"P",{"data-svelte-h":!0}),h(B)!=="svelte-18ywhxh"&&(B.textContent=Dl),yl=p(l),c(E.$$.fragment,l),wl=p(l),x=n(l,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1c2ipa8"&&(x.textContent=Pl),dl=p(l),c(W.$$.fragment,l),Jl=p(l),$=n(l,"P",{"data-svelte-h":!0}),h($)!=="svelte-1n9qsq1"&&($.textContent=Ll),ul=p(l),c(G.$$.fragment,l),Tl=p(l),Q=n(l,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-19cnvx1"&&(Q.textContent=ql),Ul=p(l),c(_.$$.fragment,l),gl=p(l),R=n(l,"P",{"data-svelte-h":!0}),h(R)!=="svelte-w2zjew"&&(R.innerHTML=Kl),bl=p(l),Y=n(l,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=Ol),Cl=p(l),U=n(l,"H2",{class:!0});var $l=r(U);A=n($l,"A",{id:!0,class:!0,href:!0});var rt=r(A);nl=n(rt,"SPAN",{});var ht=r(nl);c(S.$$.fragment,ht),ht.forEach(t),rt.forEach(t),Yl=p($l),K=n($l,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-1viv4qv"&&(K.textContent=lt),$l.forEach(t),fl=p(l),V=n(l,"P",{"data-svelte-h":!0}),h(V)!=="svelte-9sr7nh"&&(V.textContent=tt),Al=p(l),c(X.$$.fragment,l),Il=p(l),H=n(l,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1kguc51"&&(H.innerHTML=st),vl=p(l),g=n(l,"H2",{class:!0});var Gl=r(g);I=n(Gl,"A",{id:!0,class:!0,href:!0});var mt=r(I);ol=n(mt,"SPAN",{});var ct=r(ol);c(F.$$.fragment,ct),ct.forEach(t),mt.forEach(t),Sl=p(Gl),O=n(Gl,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1ce591d"&&(O.textContent=et),Gl.forEach(t),kl=p(l),z=n(l,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1n0coha"&&(z.innerHTML=at),Zl=p(l),b=n(l,"H2",{class:!0});var Ql=r(b);v=n(Ql,"A",{id:!0,class:!0,href:!0});var jt=r(v);pl=n(jt,"SPAN",{});var yt=r(pl);c(D.$$.fragment,yt),yt.forEach(t),jt.forEach(t),Vl=p(Ql),ll=n(Ql,"SPAN",{"data-svelte-h":!0}),h(ll)!=="svelte-15mb3gy"&&(ll.textContent=nt),Ql.forEach(t),Nl=p(l),c(P.$$.fragment,l),Bl=p(l),Ml=n(l,"P",{}),r(Ml).forEach(t),this.h()},h(){M(J,"name","hf:doc:metadata"),M(J,"content",JSON.stringify(bt)),M(C,"id","mobilenet-v3"),M(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(C,"href","#mobilenet-v3"),M(u,"class","relative group"),M(f,"id","how-do-i-use-this-model-on-an-image"),M(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(f,"href","#how-do-i-use-this-model-on-an-image"),M(T,"class","relative group"),M(A,"id","how-do-i-finetune-this-model"),M(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(A,"href","#how-do-i-finetune-this-model"),M(U,"class","relative group"),M(I,"id","how-do-i-train-this-model"),M(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(I,"href","#how-do-i-train-this-model"),M(g,"class","relative group"),M(v,"id","citation"),M(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(v,"href","#citation"),M(b,"class","relative group")},m(l,s){i(document.head,J),e(l,rl,s),e(l,sl,s),e(l,hl,s),e(l,u,s),i(u,C),i(C,el),j(k,el,null),i(u,_l),i(u,L),e(l,ml,s),e(l,Z,s),e(l,cl,s),e(l,T,s),i(T,f),i(f,al),j(N,al,null),i(T,Rl),i(T,q),e(l,jl,s),e(l,B,s),e(l,yl,s),j(E,l,s),e(l,wl,s),e(l,x,s),e(l,dl,s),j(W,l,s),e(l,Jl,s),e(l,$,s),e(l,ul,s),j(G,l,s),e(l,Tl,s),e(l,Q,s),e(l,Ul,s),j(_,l,s),e(l,gl,s),e(l,R,s),e(l,bl,s),e(l,Y,s),e(l,Cl,s),e(l,U,s),i(U,A),i(A,nl),j(S,nl,null),i(U,Yl),i(U,K),e(l,fl,s),e(l,V,s),e(l,Al,s),j(X,l,s),e(l,Il,s),e(l,H,s),e(l,vl,s),e(l,g,s),i(g,I),i(I,ol),j(F,ol,null),i(g,Sl),i(g,O),e(l,kl,s),e(l,z,s),e(l,Zl,s),e(l,b,s),i(b,v),i(v,pl),j(D,pl,null),i(b,Vl),i(b,ll),e(l,Nl,s),j(P,l,s),e(l,Bl,s),e(l,Ml,s),El=!0},p:dt,i(l){El||(y(k.$$.fragment,l),y(N.$$.fragment,l),y(E.$$.fragment,l),y(W.$$.fragment,l),y(G.$$.fragment,l),y(_.$$.fragment,l),y(S.$$.fragment,l),y(X.$$.fragment,l),y(F.$$.fragment,l),y(D.$$.fragment,l),y(P.$$.fragment,l),El=!0)},o(l){w(k.$$.fragment,l),w(N.$$.fragment,l),w(E.$$.fragment,l),w(W.$$.fragment,l),w(G.$$.fragment,l),w(_.$$.fragment,l),w(S.$$.fragment,l),w(X.$$.fragment,l),w(F.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),El=!1},d(l){l&&(t(rl),t(sl),t(hl),t(u),t(ml),t(Z),t(cl),t(T),t(jl),t(B),t(yl),t(wl),t(x),t(dl),t(Jl),t($),t(ul),t(Tl),t(Q),t(Ul),t(gl),t(R),t(bl),t(Y),t(Cl),t(U),t(fl),t(V),t(Al),t(Il),t(H),t(vl),t(g),t(kl),t(z),t(Zl),t(b),t(Nl),t(Bl),t(Ml)),t(J),d(k),d(N),d(E,l),d(W,l),d(G,l),d(_,l),d(S),d(X,l),d(F),d(D),d(P,l)}}}const bt={local:"mobilenet-v3",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"MobileNet v3"};function Ct(Xl){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends ut{constructor(J){super(),Tt(this,J,Ct,gt,wt,{})}}export{kt as component};
