import{s as ot,n as pt,o as dt}from"../chunks/scheduler.6062bdaf.js";import{S as mt,i as ct,g as r,s as a,r as p,A as ht,h as i,f as s,c as n,j as rt,u as d,x as o,k as it,y as ut,a as l,v as m,d as c,t as h,w as u}from"../chunks/index.4bca734e.js";import{C as q}from"../chunks/CodeBlock.cbbddafc.js";import{H as K,E as ft}from"../chunks/index.60dd99e8.js";function yt(Ve){let f,te,O,se,y,le,M,ze="You want to add a new model for <code>Better Transformer</code>, the fast path of PyTorch Transformer API? Check this guideline!",ae,b,ne,w,Re=`In theory, any model that has a transformer encoder layer, similar to the classic encoder described in the <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">“Attention Is All You Need”</a> paper should be supported.
More specifically, a model that has an encoder block with a MultiHead-Attention module (with pre or post-attention layer norm) should be convertible to its <code>BetterTransformer</code> equivalent. The conditions can be summarized as follows:`,re,T,Ne='<li>Use classic Multi Head attention module (for example, <a href="https://arxiv.org/abs/2006.03654" rel="nofollow">DeBERTa</a> cannot be supported)</li> <li>Use either <code>gelu</code> or <code>relu</code> activation function</li> <li>Have an even number of attention heads</li> <li>Do not use any attention bias (for eg <code>T5</code> uses attention bias, therefore cannot be supported)</li> <li><code>eps</code> must be equal between the first and second layer norms for each layer</li>',ie,j,oe,_,pe,U,Qe="First, go to <code>optimum/bettertransformer/__init__.py</code> and you’ll see the dictionary <code>BetterTransformerManager.MODEL_MAPPING</code>. This should contain the mapping between a model type, and the <code>Tuple[str, BetterTransformerBaseLayer]</code> composed of the name of the <code>nn.Module</code> that can be converted to its <code>BetterTransformer</code> equivalent, and effectively the equivalent <code>BetterTransformer</code> layer class.",de,J,Ae="Let us try to do it step by step for <code>Bert</code>, first we need to identify the layers that needs to be replaced:",me,$,ce,g,Fe="You can clearly see that the layers that need to be replaced are the <code>BertLayer</code> modules since they contain the whole encoder layer module.",he,C,ue,k,Xe=`Check that the identified module is not already copied from another module (by inspecting the source code in <a href="https://github.com/huggingface/transformers" rel="nofollow"><code>transformers</code></a> and checking that the class definition does not start with <code># Copied from ...</code>) - and if not, create a class in <code>bettertransformer/models/encoder_model.py</code>.
Start with those lines:`,fe,v,ye,B,Se="Now, make sure to fill all the necessary attributes, the list of attributes are:",Me,I,Ye="<li><code>in_proj_weight</code></li> <li><code>in_proj_bias</code></li> <li><code>out_proj_weight</code></li> <li><code>out_proj_bias</code></li> <li><code>linear1_weight</code></li> <li><code>linear1_bias</code></li> <li><code>linear2_weight</code></li> <li><code>linear2_bias</code></li> <li><code>norm1_eps</code></li> <li><code>norm1_weight</code></li> <li><code>norm1_bias</code></li> <li><code>norm2_weight</code></li> <li><code>norm2_bias</code></li> <li><code>num_heads</code></li> <li><code>embed_dim</code></li>",be,Z,Pe='Note that these attributes correspond to all the components that are necessary to run a Transformer Encoder module, check the figure 1 on the <a href="https://arxiv.org/pdf/1706.03762.pdf" rel="nofollow">“Attention Is All You Need”</a> paper.',we,L,De='Once you filled all these attributes (sometimes the <code>query</code>, <code>key</code> and <code>value</code> layers needs to be “contiguified”, check the <a href="https://github.com/huggingface/optimum/blob/main/optimum/bettertransformer/models/encoder_models.py" rel="nofollow"><code>modeling_encoder.py</code></a> file to understand more.)',Te,G,qe="Make sure also to add the lines:",je,H,_e,W,Ue,x,Ke="First of all, start with the line <code>super().forward_checker()</code>, this is needed so that the parent class can run all the safety checkers before.",Je,E,Oe="After the first forward pass, the hidden states needs to be <em>nested</em> using the attention mask. Once they are nested, the attention mask is not needed anymore, therefore can be set to <code>None</code>. This is how the forward pass is built for <code>Bert</code>, these lines should remain pretty much similar across models, but sometimes the shapes of the attention masks are different across models.",$e,V,ge,z,et="Once the <code>hidden_states</code> are nested, call <code>torch._transformer_encoder_layer_fwd</code> using the right arguments as follows:",Ce,R,ke,N,tt="At the last layer, it is important to “un-nest” the hidden_states so that it can be processed by the next modules, this is done in these lines:",ve,Q,Be,A,st="Also make sure to return a <code>tuple</code> to follow the convention of <code>transformers</code>.",Ie,F,lt="The best way to reproduce this experiment on your own model is to try it by get some inspiration from the provided modeling scripts. Of course, we will be happy to help you converting your model if you open an issue or a Pull Request on <code>optimum</code>!",Ze,X,Le,S,at="As a last step, make sure to update the <code>BetterTransformerManager.MODEL_MAPPING</code> dictionary in <code>optimum/bettertransformer/__init__.py</code> with the correct names, and you should be ready to convert your model. For example, for Bert that would be:",Ge,Y,He,P,nt='Try it out with the conversion method that is presented in the <a href="../tutorials/convert">tutorials sections</a>!',We,D,xe,ee,Ee;return y=new K({props:{title:"Adding BetterTransformer support for new architectures",local:"adding-bettertransformer-support-for-new-architectures",headingTag:"h1"}}),b=new K({props:{title:"Models that should be supported",local:"models-that-should-be-supported",headingTag:"h2"}}),j=new K({props:{title:"How to convert a model into its BetterTransformer format?",local:"how-to-convert-a-model-into-its-bettertransformer-format",headingTag:"h2"}}),_=new K({props:{title:"Step 1: Identifying the source layer to change",local:"step-1-identifying-the-source-layer-to-change",headingTag:"h3"}}),$=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFwcmludChtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
...
          (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
          (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
        )
      )
      (<span class="hljs-number">11</span>): BertLayer(
        (attention): BertAttention(
          (self): BertSelfAttention(
            (query): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (key): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (value): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
          )
          (output): BertSelfOutput(
            (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
            (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
            (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
          )
        )
        (intermediate): BertIntermediate(
          (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">3072</span>, bias=<span class="hljs-literal">True</span>)
          (intermediate_act_fn): GELUActivation()
        )
        (output): BertOutput(
          (dense): Linear(in_features=<span class="hljs-number">3072</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
          (LayerNorm): LayerNorm((<span class="hljs-number">768</span>,), eps=<span class="hljs-number">1e-12</span>, elementwise_affine=<span class="hljs-literal">True</span>)
          (dropout): Dropout(p=<span class="hljs-number">0.1</span>, inplace=<span class="hljs-literal">False</span>)
        )
      )
    )
  )
  (pooler): BertPooler(
    (dense): Linear(in_features=<span class="hljs-number">768</span>, out_features=<span class="hljs-number">768</span>, bias=<span class="hljs-literal">True</span>)
    (activation): Tanh()
  )
)`,wrap:!1}}),C=new K({props:{title:"Step 2: Building the xxxLayerBetterTransformer module",local:"step-2-building-the-xxxlayerbettertransformer-module",headingTag:"h3"}}),v=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwLi5iYXNlJTIwaW1wb3J0JTIwQmV0dGVyVHJhbnNmb3JtZXJCYXNlTGF5ZXIlMEElMEElMEFjbGFzcyUyMEJlcnRMYXllckJldHRlclRyYW5zZm9ybWVyKEJldHRlclRyYW5zZm9ybWVyQmFzZUxheWVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiZXJ0X2xheWVyJTJDJTIwY29uZmlnKSUzQSUwQS4uLg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> ..base <span class="hljs-keyword">import</span> BetterTransformerBaseLayer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">BertLayerBetterTransformer</span>(<span class="hljs-title class_ inherited__">BetterTransformerBaseLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bert_layer, config</span>):
...`,wrap:!1}}),H=new q({props:{code:"c2VsZi5pc19sYXN0X2xheWVyJTIwJTNEJTIwRmFsc2UlMEFzZWxmLnZhbGlkYXRlX2JldHRlcnRyYW5zZm9ybWVyKCk=",highlighted:`self.is_last_layer = <span class="hljs-literal">False</span>
self.validate_bettertransformer()`,wrap:!1}}),W=new K({props:{title:"Step 3: Building the forward pass",local:"step-3-building-the-forward-pass",headingTag:"h3"}}),V=new q({props:{code:"c3VwZXIoKS5mb3J3YXJkX2NoZWNrZXIoKSUwQSUwQWlmJTIwaGlkZGVuX3N0YXRlcy5pc19uZXN0ZWQlM0ElMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUyMCUzRCUyME5vbmUlMEElMEFpZiUyMGF0dGVudGlvbl9tYXNrJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwYXR0ZW50aW9uJTIwbWFzayUyMGNvbWVzJTIwaW4lMjB3aXRoJTIwdmFsdWVzJTIwMCUyMGFuZCUyMC1pbmYuJTIwd2UlMjBjb252ZXJ0JTIwdG8lMjB0b3JjaC5ubi5UcmFuc2Zvcm1lckVuY29kZXIlMjBzdHlsZSUyMGJvb2wlMjBtYXNrJTBBJTIwJTIwJTIwJTIwJTIzJTIwMC0lM0VmYWxzZS0lM0VrZWVwJTIwdGhpcyUyMHRva2VuJTIwLWluZi0lM0V0cnVlLSUzRW1hc2slMjB0aGlzJTIwdG9rZW4lMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUyMCUzRCUyMGF0dGVudGlvbl9tYXNrLmJvb2woKSUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTIwJTNEJTIwdG9yY2gucmVzaGFwZShhdHRlbnRpb25fbWFzayUyQyUyMChhdHRlbnRpb25fbWFzay5zaGFwZSU1QjAlNUQlMkMlMjBhdHRlbnRpb25fbWFzay5zaGFwZSU1Qi0xJTVEKSklMEElMjAlMjAlMjAlMjBzZXFsZW4lMjAlM0QlMjBhdHRlbnRpb25fbWFzay5zaGFwZSU1QjElNUQlMEElMjAlMjAlMjAlMjBsZW5ndGhzJTIwJTNEJTIwdG9yY2guc3VtKH5hdHRlbnRpb25fbWFzayUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBhbGwoJTVCbCUyMCUzRCUzRCUyMHNlcWxlbiUyMGZvciUyMGwlMjBpbiUyMGxlbmd0aHMlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLl9uZXN0ZWRfdGVuc29yX2Zyb21fbWFzayhoaWRkZW5fc3RhdGVzJTJDJTIwfmF0dGVudGlvbl9tYXNrKSUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTIwJTNEJTIwTm9uZQ==",highlighted:`<span class="hljs-built_in">super</span>().forward_checker()

<span class="hljs-keyword">if</span> hidden_states.is_nested:
    attention_mask = <span class="hljs-literal">None</span>

<span class="hljs-keyword">if</span> attention_mask <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># attention mask comes in with values 0 and -inf. we convert to torch.nn.TransformerEncoder style bool mask</span>
    <span class="hljs-comment"># 0-&gt;false-&gt;keep this token -inf-&gt;true-&gt;mask this token</span>
    attention_mask = attention_mask.<span class="hljs-built_in">bool</span>()
    attention_mask = torch.reshape(attention_mask, (attention_mask.shape[<span class="hljs-number">0</span>], attention_mask.shape[-<span class="hljs-number">1</span>]))
    seqlen = attention_mask.shape[<span class="hljs-number">1</span>]
    lengths = torch.<span class="hljs-built_in">sum</span>(~attention_mask, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">all</span>([l == seqlen <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> lengths]):
        hidden_states = torch._nested_tensor_from_mask(hidden_states, ~attention_mask)
    attention_mask = <span class="hljs-literal">None</span>`,wrap:!1}}),R=new q({props:{code:"aGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLl90cmFuc2Zvcm1lcl9lbmNvZGVyX2xheWVyX2Z3ZCglMEElMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5lbWJlZF9kaW0lMkMlMEElMjAlMjAlMjAlMjBzZWxmLm51bV9oZWFkcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYuaW5fcHJval93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmluX3Byb2pfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYub3V0X3Byb2pfd2VpZ2h0JTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5vdXRfcHJval9iaWFzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi51c2VfZ2VsdSUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybV9maXJzdCUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybTFfZXBzJTJDJTBBJTIwJTIwJTIwJTIwc2VsZi5ub3JtMV93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLm5vcm0xX2JpYXMlMkMlMEElMjAlMjAlMjAlMjBzZWxmLm5vcm0yX3dlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubm9ybTJfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyMV93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmxpbmVhcjFfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyMl93ZWlnaHQlMkMlMEElMjAlMjAlMjAlMjBzZWxmLmxpbmVhcjJfYmlhcyUyQyUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTJDJTBBKQ==",highlighted:`hidden_states = torch._transformer_encoder_layer_fwd(
    hidden_states,
    self.embed_dim,
    self.num_heads,
    self.in_proj_weight,
    self.in_proj_bias,
    self.out_proj_weight,
    self.out_proj_bias,
    self.use_gelu,
    self.norm_first,
    self.norm1_eps,
    self.norm1_weight,
    self.norm1_bias,
    self.norm2_weight,
    self.norm2_bias,
    self.linear1_weight,
    self.linear1_bias,
    self.linear2_weight,
    self.linear2_bias,
    attention_mask,
)`,wrap:!1}}),Q=new q({props:{code:"aWYlMjBoaWRkZW5fc3RhdGVzLmlzX25lc3RlZCUyMGFuZCUyMHNlbGYuaXNfbGFzdF9sYXllciUzQSUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBoaWRkZW5fc3RhdGVzLnRvX3BhZGRlZF90ZW5zb3IoMC4wKSUwQXJldHVybiUyMChoaWRkZW5fc3RhdGVzJTJDKQ==",highlighted:`<span class="hljs-keyword">if</span> hidden_states.is_nested <span class="hljs-keyword">and</span> self.is_last_layer:
    hidden_states = hidden_states.to_padded_tensor(<span class="hljs-number">0.0</span>)
<span class="hljs-keyword">return</span> (hidden_states,)`,wrap:!1}}),X=new K({props:{title:"Step 4: Sanity check!",local:"step-4-sanity-check",headingTag:"h3"}}),Y=new q({props:{code:"TU9ERUxfTUFQUElORyUyMCUzRCUyMCU3QiUwQSUyMCUyMC4uLiUwQSUyMCUyMCUyMmJlcnQlMjIlM0ElMjAoJTIyQmVydExheWVyJTIyJTJDJTIwQmVydExheWVyQmV0dGVyVHJhbnNmb3JtZXIpJTJDJTBBJTIwJTIwLi4uJTBBJTdE",highlighted:`MODEL_MAPPING = {
  <span class="hljs-params">...</span>
  <span class="hljs-string">&quot;bert&quot;</span>: (<span class="hljs-string">&quot;BertLayer&quot;</span>, BertLayerBetterTransformer),
  <span class="hljs-params">...</span>
}`,wrap:!1}}),D=new ft({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/bettertransformer/tutorials/contribute.mdx"}}),{c(){f=r("meta"),te=a(),O=r("p"),se=a(),p(y.$$.fragment),le=a(),M=r("p"),M.innerHTML=ze,ae=a(),p(b.$$.fragment),ne=a(),w=r("p"),w.innerHTML=Re,re=a(),T=r("ul"),T.innerHTML=Ne,ie=a(),p(j.$$.fragment),oe=a(),p(_.$$.fragment),pe=a(),U=r("p"),U.innerHTML=Qe,de=a(),J=r("p"),J.innerHTML=Ae,me=a(),p($.$$.fragment),ce=a(),g=r("p"),g.innerHTML=Fe,he=a(),p(C.$$.fragment),ue=a(),k=r("p"),k.innerHTML=Xe,fe=a(),p(v.$$.fragment),ye=a(),B=r("p"),B.textContent=Se,Me=a(),I=r("ul"),I.innerHTML=Ye,be=a(),Z=r("p"),Z.innerHTML=Pe,we=a(),L=r("p"),L.innerHTML=De,Te=a(),G=r("p"),G.textContent=qe,je=a(),p(H.$$.fragment),_e=a(),p(W.$$.fragment),Ue=a(),x=r("p"),x.innerHTML=Ke,Je=a(),E=r("p"),E.innerHTML=Oe,$e=a(),p(V.$$.fragment),ge=a(),z=r("p"),z.innerHTML=et,Ce=a(),p(R.$$.fragment),ke=a(),N=r("p"),N.textContent=tt,ve=a(),p(Q.$$.fragment),Be=a(),A=r("p"),A.innerHTML=st,Ie=a(),F=r("p"),F.innerHTML=lt,Ze=a(),p(X.$$.fragment),Le=a(),S=r("p"),S.innerHTML=at,Ge=a(),p(Y.$$.fragment),He=a(),P=r("p"),P.innerHTML=nt,We=a(),p(D.$$.fragment),xe=a(),ee=r("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(s),te=n(e),O=i(e,"P",{}),rt(O).forEach(s),se=n(e),d(y.$$.fragment,e),le=n(e),M=i(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-fjb411"&&(M.innerHTML=ze),ae=n(e),d(b.$$.fragment,e),ne=n(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1mz23z"&&(w.innerHTML=Re),re=n(e),T=i(e,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-150t55z"&&(T.innerHTML=Ne),ie=n(e),d(j.$$.fragment,e),oe=n(e),d(_.$$.fragment,e),pe=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1uu4te"&&(U.innerHTML=Qe),de=n(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-tebxht"&&(J.innerHTML=Ae),me=n(e),d($.$$.fragment,e),ce=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1u5h2cp"&&(g.innerHTML=Fe),he=n(e),d(C.$$.fragment,e),ue=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1xokngn"&&(k.innerHTML=Xe),fe=n(e),d(v.$$.fragment,e),ye=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-uvge3w"&&(B.textContent=Se),Me=n(e),I=i(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1288vg4"&&(I.innerHTML=Ye),be=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-36itom"&&(Z.innerHTML=Pe),we=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1w9i2ol"&&(L.innerHTML=De),Te=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ox6xuq"&&(G.textContent=qe),je=n(e),d(H.$$.fragment,e),_e=n(e),d(W.$$.fragment,e),Ue=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-b1r4nj"&&(x.innerHTML=Ke),Je=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-15jw7gk"&&(E.innerHTML=Oe),$e=n(e),d(V.$$.fragment,e),ge=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-k6rck4"&&(z.innerHTML=et),Ce=n(e),d(R.$$.fragment,e),ke=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-w3i56c"&&(N.textContent=tt),ve=n(e),d(Q.$$.fragment,e),Be=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-3l1x7l"&&(A.innerHTML=st),Ie=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1yfg992"&&(F.innerHTML=lt),Ze=n(e),d(X.$$.fragment,e),Le=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1g75he3"&&(S.innerHTML=at),Ge=n(e),d(Y.$$.fragment,e),He=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-aqcdsq"&&(P.innerHTML=nt),We=n(e),d(D.$$.fragment,e),xe=n(e),ee=i(e,"P",{}),rt(ee).forEach(s),this.h()},h(){it(f,"name","hf:doc:metadata"),it(f,"content",Mt)},m(e,t){ut(document.head,f),l(e,te,t),l(e,O,t),l(e,se,t),m(y,e,t),l(e,le,t),l(e,M,t),l(e,ae,t),m(b,e,t),l(e,ne,t),l(e,w,t),l(e,re,t),l(e,T,t),l(e,ie,t),m(j,e,t),l(e,oe,t),m(_,e,t),l(e,pe,t),l(e,U,t),l(e,de,t),l(e,J,t),l(e,me,t),m($,e,t),l(e,ce,t),l(e,g,t),l(e,he,t),m(C,e,t),l(e,ue,t),l(e,k,t),l(e,fe,t),m(v,e,t),l(e,ye,t),l(e,B,t),l(e,Me,t),l(e,I,t),l(e,be,t),l(e,Z,t),l(e,we,t),l(e,L,t),l(e,Te,t),l(e,G,t),l(e,je,t),m(H,e,t),l(e,_e,t),m(W,e,t),l(e,Ue,t),l(e,x,t),l(e,Je,t),l(e,E,t),l(e,$e,t),m(V,e,t),l(e,ge,t),l(e,z,t),l(e,Ce,t),m(R,e,t),l(e,ke,t),l(e,N,t),l(e,ve,t),m(Q,e,t),l(e,Be,t),l(e,A,t),l(e,Ie,t),l(e,F,t),l(e,Ze,t),m(X,e,t),l(e,Le,t),l(e,S,t),l(e,Ge,t),m(Y,e,t),l(e,He,t),l(e,P,t),l(e,We,t),m(D,e,t),l(e,xe,t),l(e,ee,t),Ee=!0},p:pt,i(e){Ee||(c(y.$$.fragment,e),c(b.$$.fragment,e),c(j.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),Ee=!0)},o(e){h(y.$$.fragment,e),h(b.$$.fragment,e),h(j.$$.fragment,e),h(_.$$.fragment,e),h($.$$.fragment,e),h(C.$$.fragment,e),h(v.$$.fragment,e),h(H.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),Ee=!1},d(e){e&&(s(te),s(O),s(se),s(le),s(M),s(ae),s(ne),s(w),s(re),s(T),s(ie),s(oe),s(pe),s(U),s(de),s(J),s(me),s(ce),s(g),s(he),s(ue),s(k),s(fe),s(ye),s(B),s(Me),s(I),s(be),s(Z),s(we),s(L),s(Te),s(G),s(je),s(_e),s(Ue),s(x),s(Je),s(E),s($e),s(ge),s(z),s(Ce),s(ke),s(N),s(ve),s(Be),s(A),s(Ie),s(F),s(Ze),s(Le),s(S),s(Ge),s(He),s(P),s(We),s(xe),s(ee)),s(f),u(y,e),u(b,e),u(j,e),u(_,e),u($,e),u(C,e),u(v,e),u(H,e),u(W,e),u(V,e),u(R,e),u(Q,e),u(X,e),u(Y,e),u(D,e)}}}const Mt='{"title":"Adding BetterTransformer support for new architectures","local":"adding-bettertransformer-support-for-new-architectures","sections":[{"title":"Models that should be supported","local":"models-that-should-be-supported","sections":[],"depth":2},{"title":"How to convert a model into its BetterTransformer format?","local":"how-to-convert-a-model-into-its-bettertransformer-format","sections":[{"title":"Step 1: Identifying the source layer to change","local":"step-1-identifying-the-source-layer-to-change","sections":[],"depth":3},{"title":"Step 2: Building the xxxLayerBetterTransformer module","local":"step-2-building-the-xxxlayerbettertransformer-module","sections":[],"depth":3},{"title":"Step 3: Building the forward pass","local":"step-3-building-the-forward-pass","sections":[],"depth":3},{"title":"Step 4: Sanity check!","local":"step-4-sanity-check","sections":[],"depth":3}],"depth":2}],"depth":1}';function bt(Ve){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends mt{constructor(f){super(),ct(this,f,bt,yt,ot,{})}}export{Ut as component};
