import{s as Ns,o as us,n as ds}from"../chunks/scheduler.c59d9fbb.js";import{S as Ys,i as Ds,g as i,s as a,r as U,A as Rs,h as e,f as M,c as n,j as ms,u as J,x as t,k as bs,y as os,a as T,v as y,d as j,t as p,w as I}from"../chunks/index.a47918e3.js";import{T as xs}from"../chunks/Tip.3fcf4aa4.js";import{C as w}from"../chunks/CodeBlock.936db8cd.js";import{H as ns}from"../chunks/Heading.604bc707.js";function Vs(wl){let C,r="In practice, we found <code>num_epochs</code>, <code>max_steps</code>, and <code>body_learning_rate</code> to be the most important hyperparameters for the contrastive learning process.";return{c(){C=i("p"),C.innerHTML=r},l(c){C=e(c,"P",{"data-svelte-h":!0}),t(C)!=="svelte-21oc50"&&(C.innerHTML=r)},m(c,pl){T(c,C,pl)},p:ds,d(c){c&&M(C)}}}function ks(wl){let C,r,c,pl,A,il,g,Us="SetFit models are often very quick to train, making them very suitable for hyperparameter optimization (HPO) to select the best hyperparameters.",el,h,Js="This guide will show you how to apply HPO for SetFit.",Cl,m,tl,b,ys="To use HPO, first install the <code>optuna</code> backend:",cl,N,Ol,u,js="To use this method, you need to define two functions:",rl,d,ps="<li><code>model_init()</code>: A function that instantiates the model to be used. If provided, each call to <code>train()</code> will start from a new instance of the model as given by this function.</li> <li><code>hp_space()</code>: A function that defines the hyperparameter search space.</li>",Al,Y,Is="Here is an example of a <code>model_init()</code> function that we’ll use to scan over the hyperparameters associated with the classification head in <code>SetFitModel</code>:",gl,D,hl,R,ws="Then, to scan over hyperparameters associated with the SetFit training process, we can define a <code>hp_space(trial)</code> function as follows:",ml,o,bl,O,Nl,x,is="The next step is to prepare a dataset.",ul,V,dl,k,es='After which we can instantiate a <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.Trainer">Trainer</a> and commence HPO via <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.DistillationTrainer.hyperparameter_search">Trainer.hyperparameter_search()</a>. I’ve split up the logs from each trial into separate codeblocks for readability:',Yl,F,Dl,z,Rl,Q,ol,Z,xl,B,Vl,W,kl,X,Fl,E,zl,G,Ql,_,Zl,f,Bl,S,Cs="Let’s observe the best found hyperparameters:",Wl,v,Xl,H,El,$,ts=`Finally, you can apply the hyperparameters you found to the trainer, and lock in the optimal model, before training for
a final time.`,Gl,q,_l,L,fl,K,cs="For peace of mind, we can evaluate this model once more:",Sl,P,vl,ll,Hl,sl,Os="As expected, the accuracy matches that of the best run.",$l,Ml,ql,Tl,rs="As a comparison, let’s observe the same metrics for the same setup but with the default training arguments:",Ll,al,Kl,nl,Pl,Ul,As="42.35% versus 47.85%! Quite a big difference for just a few minutes of hyperparameter searching.",ls,Jl,ss,yl,gs="This snippet shows the entire hyperparameter optimization strategy in an end-to-end example:",Ms,jl,Ts,Il,as;return A=new ns({props:{title:"Hyperparameter Optimization",local:"hyperparameter-optimization",headingTag:"h1"}}),m=new ns({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),N=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYQ==",highlighted:"pip install optuna",wrap:!1}}),D=new w({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBBbnklMEElMEFkZWYlMjBtb2RlbF9pbml0KHBhcmFtcyUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMFNldEZpdE1vZGVsJTNBJTBBJTIwJTIwJTIwJTIwcGFyYW1zJTIwJTNEJTIwcGFyYW1zJTIwb3IlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBtYXhfaXRlciUyMCUzRCUyMHBhcmFtcy5nZXQoJTIybWF4X2l0ZXIlMjIlMkMlMjAxMDApJTBBJTIwJTIwJTIwJTIwc29sdmVyJTIwJTNEJTIwcGFyYW1zLmdldCglMjJzb2x2ZXIlMjIlMkMlMjAlMjJsaWJsaW5lYXIlMjIpJTBBJTIwJTIwJTIwJTIwcGFyYW1zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGVhZF9wYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfaXRlciUyMiUzQSUyMG1heF9pdGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc29sdmVyJTIyJTNBJTIwc29sdmVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUyQyUyMCoqcGFyYW1zKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">params: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; SetFitModel:
    params = params <span class="hljs-keyword">or</span> {}
    max_iter = params.get(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">100</span>)
    solver = params.get(<span class="hljs-string">&quot;solver&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>)
    params = {
        <span class="hljs-string">&quot;head_params&quot;</span>: {
            <span class="hljs-string">&quot;max_iter&quot;</span>: max_iter,
            <span class="hljs-string">&quot;solver&quot;</span>: solver,
        }
    }
    <span class="hljs-keyword">return</span> SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, **params)`,wrap:!1}}),o=new w({props:{code:"ZnJvbSUyMG9wdHVuYSUyMGltcG9ydCUyMFRyaWFsJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBVbmlvbiUwQSUwQWRlZiUyMGhwX3NwYWNlKHRyaWFsJTNBJTIwVHJpYWwpJTIwLSUzRSUyMERpY3QlNUJzdHIlMkMlMjBVbmlvbiU1QmZsb2F0JTJDJTIwaW50JTJDJTIwc3RyJTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9keV9sZWFybmluZ19yYXRlJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9mbG9hdCglMjJib2R5X2xlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtMyUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX2Vwb2NocyUyMiUzQSUyMHRyaWFsLnN1Z2dlc3RfaW50KCUyMm51bV9lcG9jaHMlMjIlMkMlMjAxJTJDJTIwMyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJiYXRjaF9zaXplJTIyJTJDJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlZWQlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2ludCglMjJzZWVkJTIyJTJDJTIwMSUyQyUyMDQwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9pdGVyJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9pbnQoJTIybWF4X2l0ZXIlMjIlMkMlMjA1MCUyQyUyMDMwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzb2x2ZXIlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2NhdGVnb3JpY2FsKCUyMnNvbHZlciUyMiUyQyUyMCU1QiUyMm5ld3Rvbi1jZyUyMiUyQyUyMCUyMmxiZmdzJTIyJTJDJTIwJTIybGlibGluZWFyJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">from</span> optuna <span class="hljs-keyword">import</span> Trial
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">hp_space</span>(<span class="hljs-params">trial: Trial</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">str</span>]]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;body_learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;body_learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-3</span>, log=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;num_epochs&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;num_epochs&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>),
        <span class="hljs-string">&quot;batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>]),
        <span class="hljs-string">&quot;seed&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;seed&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">40</span>),
        <span class="hljs-string">&quot;max_iter&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">50</span>, <span class="hljs-number">300</span>),
        <span class="hljs-string">&quot;solver&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;solver&quot;</span>, [<span class="hljs-string">&quot;newton-cg&quot;</span>, <span class="hljs-string">&quot;lbfgs&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>]),
    }`,wrap:!1}}),O=new xs({props:{$$slots:{default:[Vs]},$$scope:{ctx:wl}}}),V=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBzYW1wbGVfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyU2V0Rml0JTJGZW1vdGlvbiUyMiklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwc2FtcGxlX2RhdGFzZXQoZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbGFiZWxfY29sdW1uJTNEJTIybGFiZWwlMjIlMkMlMjBudW1fc2FtcGxlcyUzRDgpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer, sample_dataset

dataset = load_dataset(<span class="hljs-string">&quot;SetFit/emotion&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),F=new w({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0ZXN0X2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pbml0JTNEbW9kZWxfaW5pdCUyQyUwQSklMEFiZXN0X3J1biUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTIwaHBfc3BhY2UlM0RocF9zcGFjZSUyQyUyMG5fdHJpYWxzJTNEMTAp",highlighted:`trainer = Trainer(
    train_dataset=train_dataset,
    eval_dataset=test_dataset,
    model_init=model_init,
)
best_run = trainer.hyperparameter_search(direction=<span class="hljs-string">&quot;maximize&quot;</span>, hp_space=hp_space, n_trials=<span class="hljs-number">10</span>)`,wrap:!1}}),z=new w({props:{code:"JTVCSSUyMDIwMjMtMTEtMTQlMjAyMCUzQTM2JTNBNTUlMkM3MzYlNUQlMjBBJTIwbmV3JTIwc3R1ZHklMjBjcmVhdGVkJTIwaW4lMjBtZW1vcnklMjB3aXRoJTIwbmFtZSUzQSUyMG5vLW5hbWUtZDljNmVjMjktYzVkOC00OGEyLThmMDktMjk5YjFmMzc0MGYxJTBBVHJpYWwlM0ElMjAlN0InYm9keV9sZWFybmluZ19yYXRlJyUzQSUyMDEuOTM3Mzk3NTg2ODg1NzAzZS0wNiUyQyUyMCdudW1fZXBvY2hzJyUzQSUyMDMlMkMlMjAnYmF0Y2hfc2l6ZSclM0ElMjAzMiUyQyUyMCdzZWVkJyUzQSUyMDE2JTJDJTIwJ21heF9pdGVyJyUzQSUyMDIyMyUyQyUyMCdzb2x2ZXInJTNBJTIwJ25ld3Rvbi1jZyclN0QlMEFtb2RlbF9oZWFkLnBrbCUyMG5vdCUyMGZvdW5kJTIwb24lMjBIdWdnaW5nRmFjZSUyMEh1YiUyQyUyMGluaXRpYWxpc2luZyUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZCUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzLiUyMFlvdSUyMHNob3VsZCUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bnN0cmVhbSUyMHRhc2slMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2UuJTBBKioqKiolMjBSdW5uaW5nJTIwdHJhaW5pbmclMjAqKioqKiUwQSUyMCUyME51bSUyMGV4YW1wbGVzJTIwJTNEJTIwNjAlMEElMjAlMjBOdW0lMjBlcG9jaHMlMjAlM0QlMjAzJTBBJTIwJTIwVG90YWwlMjBvcHRpbWl6YXRpb24lMjBzdGVwcyUyMCUzRCUyMDE4MCUwQSUyMCUyMFRvdGFsJTIwdHJhaW4lMjBiYXRjaCUyMHNpemUlMjAlM0QlMjAzMiUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjI2JTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMS4wNzYzMzE5OTI3MTQyNzk1ZS0wNyUyQyUyMCdlcG9jaCclM0ElMjAwLjAyJTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMjA2OSUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDEuNTU0NzAxNzY3MjUzOTU5NGUtMDYlMkMlMjAnZXBvY2gnJTNBJTIwMC44MyU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjIxNDUlMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjA5LjU2NzM5NTQ5MDc5MzU5NWUtMDclMkMlMjAnZXBvY2gnJTNBJTIwMS42NyU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjIyMzYlMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjAzLjU4Nzc3MzMwOTA0NzU5OGUtMDclMkMlMjAnZXBvY2gnJTNBJTIwMi41JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMzYuMTI5OSUyQyUyMCd0cmFpbl9zYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwMTU5LjQyNSUyQyUyMCd0cmFpbl9zdGVwc19wZXJfc2Vjb25kJyUzQSUyMDQuOTgyJTJDJTIwJ2Vwb2NoJyUzQSUyMDMuMCU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQTEwMCUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCU3QyUyMDE4MCUyRjE4MCUyMCU1QjAwJTNBMjklM0MwMCUzQTAwJTJDJTIwJTIwNi4wMml0JTJGcyU1RCUyMCUwQSoqKioqJTIwUnVubmluZyUyMGV2YWx1YXRpb24lMjAqKioqKiUwQSU1QkklMjAyMDIzLTExLTE0JTIwMjAlM0EzNyUzQTMzJTJDODk1JTVEJTIwVHJpYWwlMjAwJTIwZmluaXNoZWQlMjB3aXRoJTIwdmFsdWUlM0ElMjAwLjQ0JTIwYW5kJTIwcGFyYW1ldGVycyUzQSUyMCU3Qidib2R5X2xlYXJuaW5nX3JhdGUnJTNBJTIwMS45MzczOTc1ODY4ODU3MDNlLTA2JTJDJTIwJ251bV9lcG9jaHMnJTNBJTIwMyUyQyUyMCdiYXRjaF9zaXplJyUzQSUyMDMyJTJDJTIwJ3NlZWQnJTNBJTIwMTYlMkMlMjAnbWF4X2l0ZXInJTNBJTIwMjIzJTJDJTIwJ3NvbHZlciclM0ElMjAnbmV3dG9uLWNnJyU3RC4lMjBCZXN0JTIwaXMlMjB0cmlhbCUyMDAlMjB3aXRoJTIwdmFsdWUlM0ElMjAwLjQ0Lg==",highlighted:`[I <span class="hljs-number">2023</span><span class="hljs-number">-11</span><span class="hljs-number">-14</span> <span class="hljs-number">20</span>:<span class="hljs-number">36</span>:<span class="hljs-number">55</span>,<span class="hljs-number">736</span>] A <span class="hljs-built_in">new</span> study created <span class="hljs-keyword">in</span> memory <span class="hljs-keyword">with</span> <span class="hljs-type">name</span>: <span class="hljs-keyword">no</span>-<span class="hljs-type">name</span>-d9c6ec29-c5d8<span class="hljs-number">-48</span>a2<span class="hljs-number">-8</span>f09<span class="hljs-number">-299</span>b1f3740f1
Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">1.937397586885703e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">223</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> <span class="hljs-built_in">found</span> <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN this model <span class="hljs-keyword">on</span> a downstream task <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">3</span>
  Total optimization steps = <span class="hljs-number">180</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.26</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.0763319927142795e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2069</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.5547017672539594e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2145</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">9.567395490793595e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.67</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2236</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.587773309047598e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.5</span>}                                                                                   
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">36.1299</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">159.425</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">4.982</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">3.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">180</span>/<span class="hljs-number">180</span> [<span class="hljs-number">00</span>:<span class="hljs-number">29</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.02</span>it/s] 
***** Running evaluation *****
[I <span class="hljs-number">2023</span><span class="hljs-number">-11</span><span class="hljs-number">-14</span> <span class="hljs-number">20</span>:<span class="hljs-number">37</span>:<span class="hljs-number">33</span>,<span class="hljs-number">895</span>] Trial <span class="hljs-number">0</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.44</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">1.937397586885703e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">223</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">0</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.44</span>.`,wrap:!1}}),Q=new w({props:{code:"VHJpYWwlM0ElMjAlN0InYm9keV9sZWFybmluZ19yYXRlJyUzQSUyMDAuMDAwOTQ2NDQ5ODM4NzA1NjA0JTJDJTIwJ251bV9lcG9jaHMnJTNBJTIwMiUyQyUyMCdiYXRjaF9zaXplJyUzQSUyMDE2JTJDJTIwJ3NlZWQnJTNBJTIwOCUyQyUyMCdtYXhfaXRlciclM0ElMjA2MCUyQyUyMCdzb2x2ZXInJTNBJTIwJ2xpYmxpbmVhciclN0QlMEFtb2RlbF9oZWFkLnBrbCUyMG5vdCUyMGZvdW5kJTIwb24lMjBIdWdnaW5nRmFjZSUyMEh1YiUyQyUyMGluaXRpYWxpc2luZyUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZCUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzLiUyMFlvdSUyMHNob3VsZCUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bnN0cmVhbSUyMHRhc2slMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2UuJTBBKioqKiolMjBSdW5uaW5nJTIwdHJhaW5pbmclMjAqKioqKiUwQSUyMCUyME51bSUyMGV4YW1wbGVzJTIwJTNEJTIwMTIwJTBBJTIwJTIwTnVtJTIwZXBvY2hzJTIwJTNEJTIwMiUwQSUyMCUyMFRvdGFsJTIwb3B0aW1pemF0aW9uJTIwc3RlcHMlMjAlM0QlMjAyNDAlMEElMjAlMjBUb3RhbCUyMHRyYWluJTIwYmF0Y2glMjBzaXplJTIwJTNEJTIwMTYlMEElN0InZW1iZWRkaW5nX2xvc3MnJTNBJTIwMC4yMzU0JTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMy45NDM1NDA5OTQ2MDY2ODNlLTA1JTJDJTIwJ2Vwb2NoJyUzQSUyMDAuMDElN0QlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElN0InZW1iZWRkaW5nX2xvc3MnJTNBJTIwMC4yNDE5JTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMC4wMDA4MzI1MjUzMjEwODM2MzMyJTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNDIlN0QlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElN0InZW1iZWRkaW5nX2xvc3MnJTNBJTIwMC4zNjAxJTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMC4wMDA2MTM0Mzk3MTAyNzIxNTA4JTJDJTIwJ2Vwb2NoJyUzQSUyMDAuODMlN0QlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElN0InZW1iZWRkaW5nX2xvc3MnJTNBJTIwMC4yNjk0JTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMC4wMDAzOTQzNTQwOTk0NjA2NjgzNSUyQyUyMCdlcG9jaCclM0ElMjAxLjI1JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMjQ5NiUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDAuMDAwMTc1MjY4NDg4NjQ5MTg1OSUyQyUyMCdlcG9jaCclM0ElMjAxLjY3JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMzMuNTAxNSUyQyUyMCd0cmFpbl9zYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwMTE0LjYyMiUyQyUyMCd0cmFpbl9zdGVwc19wZXJfc2Vjb25kJyUzQSUyMDcuMTY0JTJDJTIwJ2Vwb2NoJyUzQSUyMDIuMCU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQTEwMCUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCU3QyUyMDI0MCUyRjI0MCUyMCU1QjAwJTNBMzMlM0MwMCUzQTAwJTJDJTIwJTIwNy4xNml0JTJGcyU1RCUyMCUwQSoqKioqJTIwUnVubmluZyUyMGV2YWx1YXRpb24lMjAqKioqKiUwQSU1QkklMjAyMDIzLTExLTE0JTIwMjAlM0EzOCUzQTA5JTJDNDg1JTVEJTIwVHJpYWwlMjAxJTIwZmluaXNoZWQlMjB3aXRoJTIwdmFsdWUlM0ElMjAwLjIwNyUyMGFuZCUyMHBhcmFtZXRlcnMlM0ElMjAlN0InYm9keV9sZWFybmluZ19yYXRlJyUzQSUyMDAuMDAwOTQ2NDQ5ODM4NzA1NjA0JTJDJTIwJ251bV9lcG9jaHMnJTNBJTIwMiUyQyUyMCdiYXRjaF9zaXplJyUzQSUyMDE2JTJDJTIwJ3NlZWQnJTNBJTIwOCUyQyUyMCdtYXhfaXRlciclM0ElMjA2MCUyQyUyMCdzb2x2ZXInJTNBJTIwJ2xpYmxpbmVhciclN0QuJTIwQmVzdCUyMGlzJTIwdHJpYWwlMjAwJTIwd2l0aCUyMHZhbHVlJTNBJTIwMC40NC4=",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.000946449838705604</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">60</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">120</span>
  Num epochs = <span class="hljs-number">2</span>
  Total optimization steps = <span class="hljs-number">240</span>
  Total train batch size = <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2354</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.943540994606683e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2419</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0008325253210836332</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.42</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.3601</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0006134397102721508</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2694</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.00039435409946066835</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.25</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2496</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0001752684886491859</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.67</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">33.5015</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">114.622</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">7.164</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">240</span>/<span class="hljs-number">240</span> [<span class="hljs-number">00</span>:<span class="hljs-number">33</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">7.16</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:38:09,485</span>] Trial <span class="hljs-number">1</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.207</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.000946449838705604</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">60</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">0</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.44</span>.`,wrap:!1}}),Z=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">8.050718146495058e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">20</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">260</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">60</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2499</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.3417863577491763e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1714</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.490873730832418e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">9.5338</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">201.388</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.293</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                      
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:<span class="hljs-number">09</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.30</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:38:21,069</span>] Trial <span class="hljs-number">2</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.436</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">8.050718146495058e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">20</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">260</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">0</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.44</span>.`,wrap:!1}}),B=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.000995585414046506</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">29</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">60</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2556</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.00016593090234108434</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0625</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0001843676692678715</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">9.5629</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">200.776</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.274</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                      
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:<span class="hljs-number">09</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.28</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:38:32,890</span>] Trial <span class="hljs-number">3</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.283</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.000995585414046506</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">29</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">0</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.44</span>.`,wrap:!1}}),W=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">8.541092571911196e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">223</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">3</span>
  Total optimization steps = <span class="hljs-number">180</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2578</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.745051428839553e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1725</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">6.8539631749904665e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1589</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.217823492301825e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.67</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1153</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.5816838096131844e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.5</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">28.3099</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">203.462</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.358</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">3.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">180</span>/<span class="hljs-number">180</span> [<span class="hljs-number">00</span>:<span class="hljs-number">28</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.36</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:39:03,196</span>] Trial <span class="hljs-number">4</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4415</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">8.541092571911196e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">223</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">4</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4415</span>.`,wrap:!1}}),X=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">2.3916782417792657e-05</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">258</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">30</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">30</span>
  Total train batch size = <span class="hljs-number">64</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2478</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.972260805930886e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.03</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">6.4905</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">295.818</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">4.622</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                      
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">30</span>/<span class="hljs-number">30</span> [<span class="hljs-number">00</span>:<span class="hljs-number">06</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">4.62</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:39:12,024</span>] Trial <span class="hljs-number">5</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4345</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">2.3916782417792657e-05</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">258</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">4</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4415</span>.`,wrap:!1}}),E=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.00012856431493122938</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">29</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">97</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}
model_head.pkl <span class="hljs-keyword">not</span> found <span class="hljs-keyword">on</span> HuggingFace Hub, initialising classification head <span class="hljs-keyword">with</span> random weights. You should TRAIN <span class="hljs-keyword">this</span> model <span class="hljs-keyword">on</span> a downstream task to use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">60</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2556</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.1427385821871562e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.023</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.380820646874618e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                   
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">9.2295</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">208.029</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.501</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                      
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:<span class="hljs-number">09</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.50</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:39:23,302</span>] Trial <span class="hljs-number">6</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4675</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.00012856431493122938</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">29</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">97</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;liblinear&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">6</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4675</span>.`,wrap:!1}}),G=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">3.839168294105717e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">297</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}
***** Running training *****
  Num examples = <span class="hljs-number">120</span>
  Num epochs = <span class="hljs-number">3</span>
  Total optimization steps = <span class="hljs-number">360</span>
  Total train batch size = <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2357</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.066435637251588e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2268</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.6732783060888037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.42</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1308</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.0808140631712545e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2032</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.4883498202537057e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.25</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1617</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.8958855773361567e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.67</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1363</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.3034213344186077e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.08</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1559</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.109570915010587e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.5</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1761</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.1849284858350979e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.92</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">49.8712</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">115.497</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">7.219</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">3.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">360</span>/<span class="hljs-number">360</span> [<span class="hljs-number">00</span>:<span class="hljs-number">49</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">7.22</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:40:15,350</span>] Trial <span class="hljs-number">7</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.442</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">3.839168294105717e-06</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">297</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">6</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4675</span>.`,wrap:!1}}),_=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.0005575631179396824</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">31</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">264</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}
***** Running training *****
  Num examples = <span class="hljs-number">60</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">60</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2588</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">9.29271863232804e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0025</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.00010325242924808932</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">9.4608</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">202.942</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.342</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                      
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:<span class="hljs-number">09</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.34</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:40:26,886</span>] Trial <span class="hljs-number">8</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4785</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.0005575631179396824</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">31</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">264</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;newton-cg&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">8</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4785</span>.`,wrap:!1}}),f=new w({props:{code:"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",highlighted:`Trial: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.00021830594983845785</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">38</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">267</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}
***** Running training *****
  Num examples = <span class="hljs-number">120</span>
  Num epochs = <span class="hljs-number">2</span>
  Total optimization steps = <span class="hljs-number">240</span>
  Total train batch size = <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2356</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">9.096081243269076e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.071</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.00019202838180234718</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.42</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0021</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.000141494597117519</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0018</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">9.096081243269078e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.25</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0012</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.0427027747862565e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.67</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">32.7462</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">117.265</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">7.329</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">240</span>/<span class="hljs-number">240</span> [<span class="hljs-number">00</span>:<span class="hljs-number">32</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">7.33</span>it/s] 
***** Running evaluation *****
[<span class="hljs-meta">I 2023-11-14 20:41:01,722</span>] Trial <span class="hljs-number">9</span> finished <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4615</span> <span class="hljs-keyword">and</span> parameters: {<span class="hljs-string">&#x27;body_learning_rate&#x27;</span>: <span class="hljs-number">0.00021830594983845785</span>, <span class="hljs-string">&#x27;num_epochs&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;seed&#x27;</span>: <span class="hljs-number">38</span>, <span class="hljs-string">&#x27;max_iter&#x27;</span>: <span class="hljs-number">267</span>, <span class="hljs-string">&#x27;solver&#x27;</span>: <span class="hljs-string">&#x27;lbfgs&#x27;</span>}. Best <span class="hljs-keyword">is</span> trial <span class="hljs-number">8</span> <span class="hljs-keyword">with</span> <span class="hljs-keyword">value</span>: <span class="hljs-number">0.4785</span>.`,wrap:!1}}),v=new w({props:{code:"cHJpbnQoYmVzdF9ydW4p",highlighted:'<span class="hljs-built_in">print</span>(best_run)',wrap:!1}}),H=new w({props:{code:"QmVzdFJ1bihydW5faWQlM0QnOCclMkMlMjBvYmplY3RpdmUlM0QwLjQ3ODUlMkMlMjBoeXBlcnBhcmFtZXRlcnMlM0QlN0InYm9keV9sZWFybmluZ19yYXRlJyUzQSUyMDAuMDAwNTU3NTYzMTE3OTM5NjgyNCUyQyUyMCdudW1fZXBvY2hzJyUzQSUyMDElMkMlMjAnYmF0Y2hfc2l6ZSclM0ElMjAzMiUyQyUyMCdzZWVkJyUzQSUyMDMxJTJDJTIwJ21heF9pdGVyJyUzQSUyMDI2NCUyQyUyMCdzb2x2ZXInJTNBJTIwJ25ld3Rvbi1jZyclN0QlMkMlMjBiYWNrZW5kJTNEJTNDb3B0dW5hLnN0dWR5LnN0dWR5LlN0dWR5JTIwb2JqZWN0JTIwYXQlMjAweDAwMDAwMUUwODhCOEMzMTAlM0Up",highlighted:'<span class="hljs-constructor">BestRun(<span class="hljs-params">run_id</span>=&#x27;8&#x27;, <span class="hljs-params">objective</span>=0.4785, <span class="hljs-params">hyperparameters</span>={&#x27;<span class="hljs-params">body_learning_rate</span>&#x27;: 0.0005575631179396824, &#x27;<span class="hljs-params">num_epochs</span>&#x27;: 1, &#x27;<span class="hljs-params">batch_size</span>&#x27;: 32, &#x27;<span class="hljs-params">seed</span>&#x27;: 31, &#x27;<span class="hljs-params">max_iter</span>&#x27;: 264, &#x27;<span class="hljs-params">solver</span>&#x27;: &#x27;<span class="hljs-params">newton</span>-<span class="hljs-params">cg</span>&#x27;}, <span class="hljs-params">backend</span>=&lt;<span class="hljs-params">optuna</span>.<span class="hljs-params">study</span>.<span class="hljs-params">study</span>.Study <span class="hljs-params">object</span> <span class="hljs-params">at</span> 0x000001E088B8C310&gt;)</span>',wrap:!1}}),q=new w({props:{code:"dHJhaW5lci5hcHBseV9oeXBlcnBhcmFtZXRlcnMoYmVzdF9ydW4uaHlwZXJwYXJhbWV0ZXJzJTJDJTIwZmluYWxfbW9kZWwlM0RUcnVlKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer.apply_hyperparameters(best_run.hyperparameters, final_model=<span class="hljs-literal">True</span>)
trainer.train()`,wrap:!1}}),L=new w({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">1</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2588</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">9.29271863232804e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0025</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.00010325242924808932</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">9.4331</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">203.54</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">6.361</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                       
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:09&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.</span>36it/s] `,wrap:!1}}),P=new w({props:{code:"bWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),ll=new w({props:{code:"KioqKiolMjBSdW5uaW5nJTIwZXZhbHVhdGlvbiUyMCoqKioqJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuNDc4NSU3RA==",highlighted:`<span class="hljs-bullet">***** </span>Running evaluation <span class="hljs-strong">*****</span>
{<span class="hljs-emphasis">&#x27;accuracy&#x27;</span>: 0.4785}`,wrap:!1}}),Ml=new ns({props:{title:"Baseline",local:"baseline",headingTag:"h2"}}),al=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5lciUyQyUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyU2V0Rml0JTJGZW1vdGlvbiUyMiklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwc2FtcGxlX2RhdGFzZXQoZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbGFiZWxfY29sdW1uJTNEJTIybGFiZWwlMjIlMkMlMjBudW1fc2FtcGxlcyUzRDgpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0ZXN0X2RhdGFzZXQlMkMlMEEpJTBBdHJhaW5lci50cmFpbigpJTBBJTBBbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, sample_dataset

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

dataset = load_dataset(<span class="hljs-string">&quot;SetFit/emotion&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

trainer = Trainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=test_dataset,
)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),nl=new w({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">120</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">1</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">120</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.246</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.6666666666666667e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1734</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.2962962962962964e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.42</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0411</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.7037037037037037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">23.8184</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">80.61</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">5.038</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                       
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">120</span>/<span class="hljs-number">120</span> [<span class="hljs-number">00</span>:<span class="hljs-number">17</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.</span>83it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.4235</span>}`,wrap:!1}}),Jl=new ns({props:{title:"End-to-end",local:"end-to-end",headingTag:"h2"}}),jl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, sample_dataset
<span class="hljs-keyword">from</span> optuna <span class="hljs-keyword">import</span> Trial
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Union</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">params: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; SetFitModel:
    params = params <span class="hljs-keyword">or</span> {}
    max_iter = params.get(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">100</span>)
    solver = params.get(<span class="hljs-string">&quot;solver&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>)
    params = {
        <span class="hljs-string">&quot;head_params&quot;</span>: {
            <span class="hljs-string">&quot;max_iter&quot;</span>: max_iter,
            <span class="hljs-string">&quot;solver&quot;</span>: solver,
        }
    }
    <span class="hljs-keyword">return</span> SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, **params)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">hp_space</span>(<span class="hljs-params">trial: Trial</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">str</span>]]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;body_learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;body_learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-3</span>, log=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;num_epochs&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;num_epochs&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>),
        <span class="hljs-string">&quot;batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>]),
        <span class="hljs-string">&quot;seed&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;seed&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">40</span>),
        <span class="hljs-string">&quot;max_iter&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">50</span>, <span class="hljs-number">300</span>),
        <span class="hljs-string">&quot;solver&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;solver&quot;</span>, [<span class="hljs-string">&quot;newton-cg&quot;</span>, <span class="hljs-string">&quot;lbfgs&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>]),
    }

dataset = load_dataset(<span class="hljs-string">&quot;SetFit/emotion&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

trainer = Trainer(
    train_dataset=train_dataset,
    eval_dataset=test_dataset,
    model_init=model_init,
)
best_run = trainer.hyperparameter_search(direction=<span class="hljs-string">&quot;maximize&quot;</span>, hp_space=hp_space, n_trials=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(best_run)

trainer.apply_hyperparameters(best_run.hyperparameters, final_model=<span class="hljs-literal">True</span>)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.4785}</span>`,wrap:!1}}),{c(){C=i("meta"),r=a(),c=i("p"),pl=a(),U(A.$$.fragment),il=a(),g=i("p"),g.textContent=Us,el=a(),h=i("p"),h.textContent=Js,Cl=a(),U(m.$$.fragment),tl=a(),b=i("p"),b.innerHTML=ys,cl=a(),U(N.$$.fragment),Ol=a(),u=i("p"),u.textContent=js,rl=a(),d=i("ul"),d.innerHTML=ps,Al=a(),Y=i("p"),Y.innerHTML=Is,gl=a(),U(D.$$.fragment),hl=a(),R=i("p"),R.innerHTML=ws,ml=a(),U(o.$$.fragment),bl=a(),U(O.$$.fragment),Nl=a(),x=i("p"),x.textContent=is,ul=a(),U(V.$$.fragment),dl=a(),k=i("p"),k.innerHTML=es,Yl=a(),U(F.$$.fragment),Dl=a(),U(z.$$.fragment),Rl=a(),U(Q.$$.fragment),ol=a(),U(Z.$$.fragment),xl=a(),U(B.$$.fragment),Vl=a(),U(W.$$.fragment),kl=a(),U(X.$$.fragment),Fl=a(),U(E.$$.fragment),zl=a(),U(G.$$.fragment),Ql=a(),U(_.$$.fragment),Zl=a(),U(f.$$.fragment),Bl=a(),S=i("p"),S.textContent=Cs,Wl=a(),U(v.$$.fragment),Xl=a(),U(H.$$.fragment),El=a(),$=i("p"),$.textContent=ts,Gl=a(),U(q.$$.fragment),_l=a(),U(L.$$.fragment),fl=a(),K=i("p"),K.textContent=cs,Sl=a(),U(P.$$.fragment),vl=a(),U(ll.$$.fragment),Hl=a(),sl=i("p"),sl.textContent=Os,$l=a(),U(Ml.$$.fragment),ql=a(),Tl=i("p"),Tl.textContent=rs,Ll=a(),U(al.$$.fragment),Kl=a(),U(nl.$$.fragment),Pl=a(),Ul=i("p"),Ul.textContent=As,ls=a(),U(Jl.$$.fragment),ss=a(),yl=i("p"),yl.textContent=gs,Ms=a(),U(jl.$$.fragment),Ts=a(),Il=i("p"),this.h()},l(l){const s=Rs("svelte-u9bgzb",document.head);C=e(s,"META",{name:!0,content:!0}),s.forEach(M),r=n(l),c=e(l,"P",{}),ms(c).forEach(M),pl=n(l),J(A.$$.fragment,l),il=n(l),g=e(l,"P",{"data-svelte-h":!0}),t(g)!=="svelte-gyfj2q"&&(g.textContent=Us),el=n(l),h=e(l,"P",{"data-svelte-h":!0}),t(h)!=="svelte-1ywkflw"&&(h.textContent=Js),Cl=n(l),J(m.$$.fragment,l),tl=n(l),b=e(l,"P",{"data-svelte-h":!0}),t(b)!=="svelte-113p5ez"&&(b.innerHTML=ys),cl=n(l),J(N.$$.fragment,l),Ol=n(l),u=e(l,"P",{"data-svelte-h":!0}),t(u)!=="svelte-1h1g3w1"&&(u.textContent=js),rl=n(l),d=e(l,"UL",{"data-svelte-h":!0}),t(d)!=="svelte-16e6dsc"&&(d.innerHTML=ps),Al=n(l),Y=e(l,"P",{"data-svelte-h":!0}),t(Y)!=="svelte-gq9zgk"&&(Y.innerHTML=Is),gl=n(l),J(D.$$.fragment,l),hl=n(l),R=e(l,"P",{"data-svelte-h":!0}),t(R)!=="svelte-ke50ct"&&(R.innerHTML=ws),ml=n(l),J(o.$$.fragment,l),bl=n(l),J(O.$$.fragment,l),Nl=n(l),x=e(l,"P",{"data-svelte-h":!0}),t(x)!=="svelte-1qtg42h"&&(x.textContent=is),ul=n(l),J(V.$$.fragment,l),dl=n(l),k=e(l,"P",{"data-svelte-h":!0}),t(k)!=="svelte-181d9yq"&&(k.innerHTML=es),Yl=n(l),J(F.$$.fragment,l),Dl=n(l),J(z.$$.fragment,l),Rl=n(l),J(Q.$$.fragment,l),ol=n(l),J(Z.$$.fragment,l),xl=n(l),J(B.$$.fragment,l),Vl=n(l),J(W.$$.fragment,l),kl=n(l),J(X.$$.fragment,l),Fl=n(l),J(E.$$.fragment,l),zl=n(l),J(G.$$.fragment,l),Ql=n(l),J(_.$$.fragment,l),Zl=n(l),J(f.$$.fragment,l),Bl=n(l),S=e(l,"P",{"data-svelte-h":!0}),t(S)!=="svelte-18cskto"&&(S.textContent=Cs),Wl=n(l),J(v.$$.fragment,l),Xl=n(l),J(H.$$.fragment,l),El=n(l),$=e(l,"P",{"data-svelte-h":!0}),t($)!=="svelte-p8mtac"&&($.textContent=ts),Gl=n(l),J(q.$$.fragment,l),_l=n(l),J(L.$$.fragment,l),fl=n(l),K=e(l,"P",{"data-svelte-h":!0}),t(K)!=="svelte-1d2j42g"&&(K.textContent=cs),Sl=n(l),J(P.$$.fragment,l),vl=n(l),J(ll.$$.fragment,l),Hl=n(l),sl=e(l,"P",{"data-svelte-h":!0}),t(sl)!=="svelte-1r9h9t7"&&(sl.textContent=Os),$l=n(l),J(Ml.$$.fragment,l),ql=n(l),Tl=e(l,"P",{"data-svelte-h":!0}),t(Tl)!=="svelte-1eprbbz"&&(Tl.textContent=rs),Ll=n(l),J(al.$$.fragment,l),Kl=n(l),J(nl.$$.fragment,l),Pl=n(l),Ul=e(l,"P",{"data-svelte-h":!0}),t(Ul)!=="svelte-1vsfg9a"&&(Ul.textContent=As),ls=n(l),J(Jl.$$.fragment,l),ss=n(l),yl=e(l,"P",{"data-svelte-h":!0}),t(yl)!=="svelte-3wos3z"&&(yl.textContent=gs),Ms=n(l),J(jl.$$.fragment,l),Ts=n(l),Il=e(l,"P",{}),ms(Il).forEach(M),this.h()},h(){bs(C,"name","hf:doc:metadata"),bs(C,"content",Fs)},m(l,s){os(document.head,C),T(l,r,s),T(l,c,s),T(l,pl,s),y(A,l,s),T(l,il,s),T(l,g,s),T(l,el,s),T(l,h,s),T(l,Cl,s),y(m,l,s),T(l,tl,s),T(l,b,s),T(l,cl,s),y(N,l,s),T(l,Ol,s),T(l,u,s),T(l,rl,s),T(l,d,s),T(l,Al,s),T(l,Y,s),T(l,gl,s),y(D,l,s),T(l,hl,s),T(l,R,s),T(l,ml,s),y(o,l,s),T(l,bl,s),y(O,l,s),T(l,Nl,s),T(l,x,s),T(l,ul,s),y(V,l,s),T(l,dl,s),T(l,k,s),T(l,Yl,s),y(F,l,s),T(l,Dl,s),y(z,l,s),T(l,Rl,s),y(Q,l,s),T(l,ol,s),y(Z,l,s),T(l,xl,s),y(B,l,s),T(l,Vl,s),y(W,l,s),T(l,kl,s),y(X,l,s),T(l,Fl,s),y(E,l,s),T(l,zl,s),y(G,l,s),T(l,Ql,s),y(_,l,s),T(l,Zl,s),y(f,l,s),T(l,Bl,s),T(l,S,s),T(l,Wl,s),y(v,l,s),T(l,Xl,s),y(H,l,s),T(l,El,s),T(l,$,s),T(l,Gl,s),y(q,l,s),T(l,_l,s),y(L,l,s),T(l,fl,s),T(l,K,s),T(l,Sl,s),y(P,l,s),T(l,vl,s),y(ll,l,s),T(l,Hl,s),T(l,sl,s),T(l,$l,s),y(Ml,l,s),T(l,ql,s),T(l,Tl,s),T(l,Ll,s),y(al,l,s),T(l,Kl,s),y(nl,l,s),T(l,Pl,s),T(l,Ul,s),T(l,ls,s),y(Jl,l,s),T(l,ss,s),T(l,yl,s),T(l,Ms,s),y(jl,l,s),T(l,Ts,s),T(l,Il,s),as=!0},p(l,[s]){const hs={};s&2&&(hs.$$scope={dirty:s,ctx:l}),O.$set(hs)},i(l){as||(j(A.$$.fragment,l),j(m.$$.fragment,l),j(N.$$.fragment,l),j(D.$$.fragment,l),j(o.$$.fragment,l),j(O.$$.fragment,l),j(V.$$.fragment,l),j(F.$$.fragment,l),j(z.$$.fragment,l),j(Q.$$.fragment,l),j(Z.$$.fragment,l),j(B.$$.fragment,l),j(W.$$.fragment,l),j(X.$$.fragment,l),j(E.$$.fragment,l),j(G.$$.fragment,l),j(_.$$.fragment,l),j(f.$$.fragment,l),j(v.$$.fragment,l),j(H.$$.fragment,l),j(q.$$.fragment,l),j(L.$$.fragment,l),j(P.$$.fragment,l),j(ll.$$.fragment,l),j(Ml.$$.fragment,l),j(al.$$.fragment,l),j(nl.$$.fragment,l),j(Jl.$$.fragment,l),j(jl.$$.fragment,l),as=!0)},o(l){p(A.$$.fragment,l),p(m.$$.fragment,l),p(N.$$.fragment,l),p(D.$$.fragment,l),p(o.$$.fragment,l),p(O.$$.fragment,l),p(V.$$.fragment,l),p(F.$$.fragment,l),p(z.$$.fragment,l),p(Q.$$.fragment,l),p(Z.$$.fragment,l),p(B.$$.fragment,l),p(W.$$.fragment,l),p(X.$$.fragment,l),p(E.$$.fragment,l),p(G.$$.fragment,l),p(_.$$.fragment,l),p(f.$$.fragment,l),p(v.$$.fragment,l),p(H.$$.fragment,l),p(q.$$.fragment,l),p(L.$$.fragment,l),p(P.$$.fragment,l),p(ll.$$.fragment,l),p(Ml.$$.fragment,l),p(al.$$.fragment,l),p(nl.$$.fragment,l),p(Jl.$$.fragment,l),p(jl.$$.fragment,l),as=!1},d(l){l&&(M(r),M(c),M(pl),M(il),M(g),M(el),M(h),M(Cl),M(tl),M(b),M(cl),M(Ol),M(u),M(rl),M(d),M(Al),M(Y),M(gl),M(hl),M(R),M(ml),M(bl),M(Nl),M(x),M(ul),M(dl),M(k),M(Yl),M(Dl),M(Rl),M(ol),M(xl),M(Vl),M(kl),M(Fl),M(zl),M(Ql),M(Zl),M(Bl),M(S),M(Wl),M(Xl),M(El),M($),M(Gl),M(_l),M(fl),M(K),M(Sl),M(vl),M(Hl),M(sl),M($l),M(ql),M(Tl),M(Ll),M(Kl),M(Pl),M(Ul),M(ls),M(ss),M(yl),M(Ms),M(Ts),M(Il)),M(C),I(A,l),I(m,l),I(N,l),I(D,l),I(o,l),I(O,l),I(V,l),I(F,l),I(z,l),I(Q,l),I(Z,l),I(B,l),I(W,l),I(X,l),I(E,l),I(G,l),I(_,l),I(f,l),I(v,l),I(H,l),I(q,l),I(L,l),I(P,l),I(ll,l),I(Ml,l),I(al,l),I(nl,l),I(Jl,l),I(jl,l)}}}const Fs='{"title":"Hyperparameter Optimization","local":"hyperparameter-optimization","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Baseline","local":"baseline","sections":[],"depth":2},{"title":"End-to-end","local":"end-to-end","sections":[],"depth":2}],"depth":1}';function zs(wl){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Ys{constructor(C){super(),Ds(this,C,zs,ks,Ns,{})}}export{Es as component};
