import{s as kn,z as jn,o as In,n as Kt}from"../chunks/scheduler.182ea377.js";import{S as Gn,i as Bn,g as a,s,r as m,A as Zn,h as l,f as n,c as i,j as U,u,x as d,k as x,y as c,a as o,v as h,d as f,t as g,w as _}from"../chunks/index.abf12888.js";import{D as Z}from"../chunks/Docstring.93f6f462.js";import{C as Ue}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ot}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as $}from"../chunks/Heading.16916d63.js";function Vn(V){let p,J="Examples:",M,b,w;return b=new Ue({props:{code:"ZnJvbSUyMGRpZmZ1c2lvbnMlMjBpbXBvcnQlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyd2FycC1haSUyRld1ZXJzdGNoZW4lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbWFnZSUyMG9mJTIwYSUyMHNoaWJhJTIwaW51JTJDJTIwZG9ubmluZyUyMGElMjBzcGFjZXN1aXQlMjBhbmQlMjBoZWxtZXQlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusions <span class="hljs-keyword">import</span> WuerstchenCombinedPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WuerstchenCombinedPipeline.from_pretrained(<span class="hljs-string">&quot;warp-ai/Wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=s(),m(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=i(r),u(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),h(b,r,y),w=!0},p:Kt,i(r){w||(f(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function Dn(V){let p,J="Examples:",M,b,w;return b=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMEElMEFwcmlvcl9waXBlJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=s(),m(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=i(r),u(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),h(b,r,y),w=!0},p:Kt,i(r){w||(f(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function En(V){let p,J="Examples:",M,b,w;return b=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMkMlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lJTBBJTBBcHJpb3JfcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5fcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5EZWNvZGVyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbiglMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGltYWdlJTIwb2YlMjBhJTIwc2hpYmElMjBpbnUlMkMlMjBkb25uaW5nJTIwYSUyMHNwYWNlc3VpdCUyMGFuZCUyMGhlbG1ldCUyMiUwQXByaW9yX291dHB1dCUyMCUzRCUyMHBpcGUocHJvbXB0KSUwQWltYWdlcyUyMCUzRCUyMGdlbl9waXBlKHByaW9yX291dHB1dC5pbWFnZV9lbWJlZGRpbmdzJTJDJTIwcHJvbXB0JTNEcHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline, WuerstchenDecoderPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_pipe = WuerstchenDecoderPipeline.from_pretrain(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = gen_pipe(prior_output.image_embeddings, prompt=prompt)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,M=s(),m(b.$$.fragment)},l(r){p=l(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=J),M=i(r),u(b.$$.fragment,r)},m(r,y){o(r,p,y),o(r,M,y),h(b,r,y),w=!0},p:Kt,i(r){w||(f(b.$$.fragment,r),w=!0)},o(r){g(b.$$.fragment,r),w=!1},d(r){r&&(n(p),n(M)),_(b,r)}}}function An(V){let p,J,M,b,w,r,y,en,Se,R,tn='<a href="https://huggingface.co/papers/2306.00637" rel="nofollow">Wuerstchen: An Efficient Architecture for Large-Scale Text-to-Image Diffusion Models</a> is by Pablo Pernias, Dominic Rampas, Mats L. Richter and Christopher Pal and Marc Aubreville.',He,Q,nn="The abstract from the paper is:",Fe,q,on="<em>We introduce Würstchen, a novel architecture for text-to-image synthesis that combines competitive performance with unprecedented cost-effectiveness for large-scale text-to-image diffusion models. A key contribution of our work is to develop a latent diffusion technique in which we learn a detailed but extremely compact semantic image representation used to guide the diffusion process. This highly compressed representation of an image provides much more detailed guidance compared to latent representations of language and this significantly reduces the computational requirements to achieve state-of-the-art results. Our approach also improves the quality of text-conditioned image generation based on our user preference study. The training requirements of our approach consists of 24,602 A100-GPU hours - compared to Stable Diffusion 2.1’s 200,000 GPU hours. Our approach also requires less training data to achieve these results. Furthermore, our compact latent representations allows us to perform inference over twice as fast, slashing the usual costs and carbon footprint of a state-of-the-art (SOTA) diffusion model significantly, without compromising the end performance. In a broader comparison against SOTA models our approach is substantially more efficient and compares favorably in terms of image quality. We believe that this work motivates more emphasis on the prioritization of both performance and computational accessibility.</em>",Ye,S,ze,H,sn='Würstchen is a diffusion model, whose text-conditional model works in a highly compressed latent space of images. Why is this important? Compressing data can reduce computational costs for both training and inference by magnitudes. Training on 1024x1024 images is way more expensive than training on 32x32. Usually, other works make use of a relatively small compression, in the range of 4x - 8x spatial compression. Würstchen takes this to an extreme. Through its novel design, we achieve a 42x spatial compression. This was unseen before because common methods fail to faithfully reconstruct detailed images after 16x spatial compression. Würstchen employs a two-stage compression, what we call Stage A and Stage B. Stage A is a VQGAN, and Stage B is a Diffusion Autoencoder (more details can be found in the <a href="https://huggingface.co/papers/2306.00637" rel="nofollow">paper</a>). A third model, Stage C, is learned in that highly compressed latent space. This training requires fractions of the compute used for current top-performing models, while also allowing cheaper and faster inference.',Oe,F,Ke,Y,rn="After the initial paper release, we have improved numerous things in the architecture, training and sampling, making Würstchen competitive to current state-of-the-art models in many ways. We are excited to release this new version together with Diffusers. Here is a list of the improvements.",et,z,an="<li>Higher resolution (1024x1024 up to 2048x2048)</li> <li>Faster inference</li> <li>Multi Aspect Resolution Sampling</li> <li>Better quality</li>",tt,O,ln="We are releasing 3 checkpoints for the text-conditional image generation model (Stage C). Those are:",nt,K,cn="<li>v2-base</li> <li>v2-aesthetic</li> <li><strong>(default)</strong> v2-interpolated (50% interpolation between v2-base and v2-aesthetic)</li>",ot,ee,pn=`We recommend using v2-interpolated, as it has a nice touch of both photorealism and aesthetics. Use v2-base for finetunings as it does not have a style bias and use v2-aesthetic for very artistic generations.
A comparison can be seen here:`,st,te,dn,it,ne,rt,oe,mn="For the sake of usability, Würstchen can be used with a single pipeline. This pipeline can be used as follows:",at,se,lt,ie,un='For explanation purposes, we can also initialize the two main pipelines of Würstchen individually. Würstchen consists of 3 stages: Stage C, Stage B, Stage A. They all have different jobs and work only together. When generating text-conditional images, Stage C will first generate the latents in a very compressed latent space. This is what happens in the <code>prior_pipeline</code>. Afterwards, the generated latents will be passed to Stage B, which decompresses the latents into a bigger latent space of a VQGAN. These latents can then be decoded by Stage A, which is a VQGAN, into the pixel-space. Stage B &amp; Stage A are both encapsulated in the <code>decoder_pipeline</code>. For more details, take a look at the <a href="https://huggingface.co/papers/2306.00637" rel="nofollow">paper</a>.',ct,re,pt,ae,dt,le,hn="You can make use of <code>torch.compile</code> function and gain a speed-up of about 2-3x:",mt,ce,ut,pe,ht,de,fn=`<li>Due to the high compression employed by Würstchen, generations can lack a good amount
of detail. To our human eye, this is especially noticeable in faces, hands etc.</li> <li><strong>Images can only be generated in 128-pixel steps</strong>, e.g. the next higher resolution
after 1024x1024 is 1152x1152</li> <li>The model lacks the ability to render correct text in images</li> <li>The model often does not achieve photorealism</li> <li>Difficult compositional prompts are hard for the model</li>`,ft,me,gn='The original codebase, as well as experimental ideas, can be found at <a href="https://github.com/dome272/Wuerstchen" rel="nofollow">dome272/Wuerstchen</a>.',gt,ue,_t,v,he,$t,$e,_n="Combined Pipeline for text-to-image generation using Wuerstchen",jt,je,bn=`This model inherits from <a href="/docs/diffusers/v0.27.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,kt,j,fe,It,ke,wn="Function invoked when calling the pipeline for generation.",Gt,D,Bt,E,ge,Zt,Ie,Mn=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Vt,A,_e,Dt,Ge,yn=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,bt,be,wt,T,we,Et,Be,vn="Pipeline for generating image prior for Wuerstchen.",At,Ze,Tn=`This model inherits from <a href="/docs/diffusers/v0.27.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Xt,Ve,Wn="The pipeline also inherits the following loading methods:",Lt,De,xn='<li><a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Nt,k,Me,Rt,Ee,Jn="Function invoked when calling the pipeline for generation.",Qt,X,Mt,ye,yt,G,ve,qt,Ae,Pn="Output class for WuerstchenPriorPipeline.",vt,Te,Tt,P,We,St,Xe,Cn="Pipeline for generating images from the Wuerstchen model.",Ht,Le,Un=`This model inherits from <a href="/docs/diffusers/v0.27.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ft,I,xe,Yt,Ne,$n="Function invoked when calling the pipeline for generation.",zt,L,Wt,Je,xt,Pe,Jt,qe,Pt;return w=new $({props:{title:"Würstchen",local:"würstchen",headingTag:"h1"}}),S=new $({props:{title:"Würstchen Overview",local:"würstchen-overview",headingTag:"h2"}}),F=new $({props:{title:"Würstchen v2 comes to Diffusers",local:"würstchen-v2-comes-to-diffusers",headingTag:"h2"}}),ne=new $({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h2"}}),se=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBbnRocm9wb21vcnBoaWMlMjBjYXQlMjBkcmVzc2VkJTIwYXMlMjBhJTIwZmlyZSUyMGZpZ2h0ZXIlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxNTM2JTJDJTBBJTIwJTIwJTIwJTIwcHJpb3JfdGltZXN0ZXBzJTNEREVGQVVMVF9TVEFHRV9DX1RJTUVTVEVQUyUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX2d1aWRhbmNlX3NjYWxlJTNENC4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMiUyQyUwQSkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipe = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
images = pipe(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`,wrap:!1}}),re=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlbkRlY29kZXJQaXBlbGluZSUyQyUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMud3VlcnN0Y2hlbiUyMGltcG9ydCUyMERFRkFVTFRfU1RBR0VfQ19USU1FU1RFUFMlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5mbG9hdDE2JTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMiUwQSUwQXByaW9yX3BpcGVsaW5lJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUwQSkudG8oZGV2aWNlKSUwQWRlY29kZXJfcGlwZWxpbmUlMjAlM0QlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMEEpLnRvKGRldmljZSklMEElMEFjYXB0aW9uJTIwJTNEJTIwJTIyQW50aHJvcG9tb3JwaGljJTIwY2F0JTIwZHJlc3NlZCUyMGFzJTIwYSUyMGZpcmUlMjBmaWdodGVyJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTBBJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcHJpb3JfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEY2FwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDE1MzYlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlM0RERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzX3Blcl9wcm9tcHQlMkMlMEEpJTBBZGVjb2Rlcl9vdXRwdXQlMjAlM0QlMjBkZWNvZGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkZGluZ3MlM0Rwcmlvcl9vdXRwdXQuaW1hZ2VfZW1iZWRkaW5ncyUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZGVjb2Rlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenDecoderPipeline, WuerstchenPriorPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

device = <span class="hljs-string">&quot;cuda&quot;</span>
dtype = torch.float16
num_images_per_prompt = <span class="hljs-number">2</span>

prior_pipeline = WuerstchenPriorPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=dtype
).to(device)
decoder_pipeline = WuerstchenDecoderPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=dtype
).to(device)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior_output = prior_pipeline(
    prompt=caption,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1536</span>,
    timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=num_images_per_prompt,
)
decoder_output = decoder_pipeline(
    image_embeddings=prior_output.image_embeddings,
    prompt=caption,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
).images[<span class="hljs-number">0</span>]
decoder_output`,wrap:!1}}),ae=new $({props:{title:"Speed-Up Inference",local:"speed-up-inference",headingTag:"h2"}}),ce=new Ue({props:{code:"cHJpb3JfcGlwZWxpbmUucHJpb3IlMjAlM0QlMjB0b3JjaC5jb21waWxlKHByaW9yX3BpcGVsaW5lLnByaW9yJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBZGVjb2Rlcl9waXBlbGluZS5kZWNvZGVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShkZWNvZGVyX3BpcGVsaW5lLmRlY29kZXIlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`prior_pipeline.prior = torch.<span class="hljs-built_in">compile</span>(prior_pipeline.prior, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
decoder_pipeline.decoder = torch.<span class="hljs-built_in">compile</span>(decoder_pipeline.decoder, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new $({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),ue=new $({props:{title:"WuerstchenCombinedPipeline",local:"diffusers.WuerstchenCombinedPipeline",headingTag:"h2"}}),he=new Z({props:{name:"class diffusers.WuerstchenCombinedPipeline",anchor:"diffusers.WuerstchenCombinedPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModel"},{name:"prior_prior",val:": WuerstchenPrior"},{name:"prior_scheduler",val:": DDPMWuerstchenScheduler"}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The decoder tokenizer to be used for text inputs.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The decoder text encoder to be used for text inputs.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The decoder model to be used for decoder image generation pipeline.`,name:"decoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for decoder image generation pipeline.`,name:"scheduler"},{anchor:"diffusers.WuerstchenCombinedPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model to be used for decoder image generation pipeline.`,name:"vqgan"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The prior tokenizer to be used for text inputs.`,name:"prior_tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The prior text encoder to be used for text inputs.`,name:"prior_text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<code>WuerstchenPrior</code>) &#x2014;
The prior model to be used for prior pipeline.`,name:"prior_prior"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for prior pipeline.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L43"}}),fe=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_num_inference_steps",val:": int = 60"},{name:"prior_timesteps",val:": Optional = None"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"num_inference_steps",val:": int = 12"},{name:"decoder_timesteps",val:": Optional = None"},{name:"decoder_guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation for the prior and decoder.`,name:"prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>prior_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>prior_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked
to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>Union[int, Dict[float, int]]</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of prior denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. For more specific timestep spacing, you can pass customized
<code>prior_timesteps</code>`,name:"prior_num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of decoder denoising steps. More denoising steps usually lead to a higher quality image at
the expense of slower inference. For more specific timestep spacing, you can pass customized
<code>timesteps</code>`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_timesteps",description:`<strong>prior_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the prior. If not defined, equal spaced
<code>prior_num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"prior_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_timesteps",description:`<strong>decoder_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the decoder. If not defined, equal spaced
<code>num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"decoder_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_guidance_scale",description:`<strong>decoder_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"decoder_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L143",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`}}),D=new Ot({props:{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.example",$$slots:{default:[Vn]},$$scope:{ctx:V}}}),ge=new Z({props:{name:"enable_model_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L115"}}),_e=new Z({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L125"}}),be=new $({props:{title:"WuerstchenPriorPipeline",local:"diffusers.WuerstchenPriorPipeline",headingTag:"h2"}}),we=new Z({props:{name:"class diffusers.WuerstchenPriorPipeline",anchor:"diffusers.WuerstchenPriorPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"prior",val:": WuerstchenPrior"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"latent_mean",val:": float = 42.0"},{name:"latent_std",val:": float = 1.0"},{name:"resolution_multiple",val:": float = 42.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.prior",description:`<strong>prior</strong> (<code>Prior</code>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.WuerstchenPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_mean",description:`<strong>latent_mean</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.0) &#x2014;
Mean value for latent diffusers.`,name:"latent_mean"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_std",description:`<strong>latent_std</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 1.0) &#x2014;
Standard value for latent diffusers.`,name:"latent_std"},{anchor:"diffusers.WuerstchenPriorPipeline.resolution_multiple",description:`<strong>resolution_multiple</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.67) &#x2014;
Default resolution for multiple images generated.`,name:"resolution_multiple"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L65"}}),Me=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"num_inference_steps",val:": int = 60"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.WuerstchenPriorPipelineOutput</code> or <code>tuple</code> <code>~pipelines.WuerstchenPriorPipelineOutput</code> if
<code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated image embeddings.</p>
`}}),X=new Ot({props:{anchor:"diffusers.WuerstchenPriorPipeline.__call__.example",$$slots:{default:[Dn]},$$scope:{ctx:V}}}),ye=new $({props:{title:"WuerstchenPriorPipelineOutput",local:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",headingTag:"h2"}}),ve=new Z({props:{name:"class diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",parameters:[{name:"image_embeddings",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.FloatTensor</code> or <code>np.ndarray</code>) &#x2014;
Prior image embeddings for text prompt`,name:"image_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L51"}}),Te=new $({props:{title:"WuerstchenDecoderPipeline",local:"diffusers.WuerstchenDecoderPipeline",headingTag:"h2"}}),We=new Z({props:{name:"class diffusers.WuerstchenDecoderPipeline",anchor:"diffusers.WuerstchenDecoderPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"latent_dim_scale",val:": float = 10.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenDecoderPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The CLIP text encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The WuerstchenDiffNeXt unet decoder.`,name:"decoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model.`,name:"vqgan"},{anchor:"diffusers.WuerstchenDecoderPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenDecoderPipeline.latent_dim_scale",description:`<strong>latent_dim_scale</strong> (float, <code>optional</code>, defaults to 10.67) &#x2014;
Multiplier to determine the VQ latent space size from the image embeddings. If the image embeddings are
height=24 and width=24, the VQ latent shape needs to be height=int(24<em>10.67)=256 and
width=int(24</em>10.67)=256 in order to match the training conditions.`,name:"latent_dim_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L51"}}),xe=new Z({props:{name:"__call__",anchor:"diffusers.WuerstchenDecoderPipeline.__call__",parameters:[{name:"image_embeddings",val:": Union"},{name:"prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 12"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.image_embedding",description:`<strong>image_embedding</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
Image Embeddings either extracted from an image or generated by a Prior Model.`,name:"image_embedding"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L208",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated image
embeddings.</p>
`}}),L=new Ot({props:{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.example",$$slots:{default:[En]},$$scope:{ctx:V}}}),Je=new $({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Pe=new Ue({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTQwbWlzYyU3QnBlcm5pYXMyMDIzd3VlcnN0Y2hlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCV3VlcnN0Y2hlbiUzQSUyMEFuJTIwRWZmaWNpZW50JTIwQXJjaGl0ZWN0dXJlJTIwZm9yJTIwTGFyZ2UtU2NhbGUlMjBUZXh0LXRvLUltYWdlJTIwRGlmZnVzaW9uJTIwTW9kZWxzJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUGFibG8lMjBQZXJuaWFzJTIwYW5kJTIwRG9taW5pYyUyMFJhbXBhcyUyMGFuZCUyME1hdHMlMjBMLiUyMFJpY2h0ZXIlMjBhbmQlMjBDaHJpc3RvcGhlciUyMEouJTIwUGFsJTIwYW5kJTIwTWFyYyUyMEF1YnJldmlsbGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIzMDYuMDA2MzclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RA==",highlighted:`      @misc{pernias2023wuerstchen,
            title={Wuerstchen: An Efficient Architecture for Large-<span class="hljs-keyword">Scale </span>Text-to-Image <span class="hljs-keyword">Diffusion </span>Models},
            author={Pablo Pernias <span class="hljs-keyword">and </span>Dominic Rampas <span class="hljs-keyword">and </span>Mats L. Richter <span class="hljs-keyword">and </span>Christopher <span class="hljs-keyword">J. </span>Pal <span class="hljs-keyword">and </span>Marc Aubreville},
            year={<span class="hljs-number">2023</span>},
            eprint={<span class="hljs-number">2306</span>.<span class="hljs-number">00637</span>},
            archivePrefix={arXiv},
            primaryClass={cs.CV}
      }`,wrap:!1}}),{c(){p=a("meta"),J=s(),M=a("p"),b=s(),m(w.$$.fragment),r=s(),y=a("img"),Se=s(),R=a("p"),R.innerHTML=tn,He=s(),Q=a("p"),Q.textContent=nn,Fe=s(),q=a("p"),q.innerHTML=on,Ye=s(),m(S.$$.fragment),ze=s(),H=a("p"),H.innerHTML=sn,Oe=s(),m(F.$$.fragment),Ke=s(),Y=a("p"),Y.textContent=rn,et=s(),z=a("ul"),z.innerHTML=an,tt=s(),O=a("p"),O.textContent=ln,nt=s(),K=a("ul"),K.innerHTML=cn,ot=s(),ee=a("p"),ee.textContent=pn,st=s(),te=a("img"),it=s(),m(ne.$$.fragment),rt=s(),oe=a("p"),oe.textContent=mn,at=s(),m(se.$$.fragment),lt=s(),ie=a("p"),ie.innerHTML=un,ct=s(),m(re.$$.fragment),pt=s(),m(ae.$$.fragment),dt=s(),le=a("p"),le.innerHTML=hn,mt=s(),m(ce.$$.fragment),ut=s(),m(pe.$$.fragment),ht=s(),de=a("ul"),de.innerHTML=fn,ft=s(),me=a("p"),me.innerHTML=gn,gt=s(),m(ue.$$.fragment),_t=s(),v=a("div"),m(he.$$.fragment),$t=s(),$e=a("p"),$e.textContent=_n,jt=s(),je=a("p"),je.innerHTML=bn,kt=s(),j=a("div"),m(fe.$$.fragment),It=s(),ke=a("p"),ke.textContent=wn,Gt=s(),m(D.$$.fragment),Bt=s(),E=a("div"),m(ge.$$.fragment),Zt=s(),Ie=a("p"),Ie.innerHTML=Mn,Vt=s(),A=a("div"),m(_e.$$.fragment),Dt=s(),Ge=a("p"),Ge.innerHTML=yn,bt=s(),m(be.$$.fragment),wt=s(),T=a("div"),m(we.$$.fragment),Et=s(),Be=a("p"),Be.textContent=vn,At=s(),Ze=a("p"),Ze.innerHTML=Tn,Xt=s(),Ve=a("p"),Ve.textContent=Wn,Lt=s(),De=a("ul"),De.innerHTML=xn,Nt=s(),k=a("div"),m(Me.$$.fragment),Rt=s(),Ee=a("p"),Ee.textContent=Jn,Qt=s(),m(X.$$.fragment),Mt=s(),m(ye.$$.fragment),yt=s(),G=a("div"),m(ve.$$.fragment),qt=s(),Ae=a("p"),Ae.textContent=Pn,vt=s(),m(Te.$$.fragment),Tt=s(),P=a("div"),m(We.$$.fragment),St=s(),Xe=a("p"),Xe.textContent=Cn,Ht=s(),Le=a("p"),Le.innerHTML=Un,Ft=s(),I=a("div"),m(xe.$$.fragment),Yt=s(),Ne=a("p"),Ne.textContent=$n,zt=s(),m(L.$$.fragment),Wt=s(),m(Je.$$.fragment),xt=s(),m(Pe.$$.fragment),Jt=s(),qe=a("p"),this.h()},l(e){const t=Zn("svelte-u9bgzb",document.head);p=l(t,"META",{name:!0,content:!0}),t.forEach(n),J=i(e),M=l(e,"P",{}),U(M).forEach(n),b=i(e),u(w.$$.fragment,e),r=i(e),y=l(e,"IMG",{src:!0}),Se=i(e),R=l(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-hm8v9i"&&(R.innerHTML=tn),He=i(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1cwsb16"&&(Q.textContent=nn),Fe=i(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-10ea9cr"&&(q.innerHTML=on),Ye=i(e),u(S.$$.fragment,e),ze=i(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1i2c2wf"&&(H.innerHTML=sn),Oe=i(e),u(F.$$.fragment,e),Ke=i(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-idonvk"&&(Y.textContent=rn),et=i(e),z=l(e,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-hwtnnt"&&(z.innerHTML=an),tt=i(e),O=l(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-bpk4lp"&&(O.textContent=ln),nt=i(e),K=l(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-holqkq"&&(K.innerHTML=cn),ot=i(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-izmk3f"&&(ee.textContent=pn),st=i(e),te=l(e,"IMG",{src:!0,width:!0}),it=i(e),u(ne.$$.fragment,e),rt=i(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-q6mitm"&&(oe.textContent=mn),at=i(e),u(se.$$.fragment,e),lt=i(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-16aw41o"&&(ie.innerHTML=un),ct=i(e),u(re.$$.fragment,e),pt=i(e),u(ae.$$.fragment,e),dt=i(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-13xqqkt"&&(le.innerHTML=hn),mt=i(e),u(ce.$$.fragment,e),ut=i(e),u(pe.$$.fragment,e),ht=i(e),de=l(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-157ejdo"&&(de.innerHTML=fn),ft=i(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1674xah"&&(me.innerHTML=gn),gt=i(e),u(ue.$$.fragment,e),_t=i(e),v=l(e,"DIV",{class:!0});var W=U(v);u(he.$$.fragment,W),$t=i(W),$e=l(W,"P",{"data-svelte-h":!0}),d($e)!=="svelte-19cx0lp"&&($e.textContent=_n),jt=i(W),je=l(W,"P",{"data-svelte-h":!0}),d(je)!=="svelte-12y6y1l"&&(je.innerHTML=bn),kt=i(W),j=l(W,"DIV",{class:!0});var B=U(j);u(fe.$$.fragment,B),It=i(B),ke=l(B,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-v78lg8"&&(ke.textContent=wn),Gt=i(B),u(D.$$.fragment,B),B.forEach(n),Bt=i(W),E=l(W,"DIV",{class:!0});var Ce=U(E);u(ge.$$.fragment,Ce),Zt=i(Ce),Ie=l(Ce,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-d7vywi"&&(Ie.innerHTML=Mn),Ce.forEach(n),Vt=i(W),A=l(W,"DIV",{class:!0});var Ct=U(A);u(_e.$$.fragment,Ct),Dt=i(Ct),Ge=l(Ct,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-a2a0wt"&&(Ge.innerHTML=yn),Ct.forEach(n),W.forEach(n),bt=i(e),u(be.$$.fragment,e),wt=i(e),T=l(e,"DIV",{class:!0});var C=U(T);u(we.$$.fragment,C),Et=i(C),Be=l(C,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1atgjon"&&(Be.textContent=vn),At=i(C),Ze=l(C,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-12y6y1l"&&(Ze.innerHTML=Tn),Xt=i(C),Ve=l(C,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-14s6m4u"&&(Ve.textContent=Wn),Lt=i(C),De=l(C,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-huuykq"&&(De.innerHTML=xn),Nt=i(C),k=l(C,"DIV",{class:!0});var Re=U(k);u(Me.$$.fragment,Re),Rt=i(Re),Ee=l(Re,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-v78lg8"&&(Ee.textContent=Jn),Qt=i(Re),u(X.$$.fragment,Re),Re.forEach(n),C.forEach(n),Mt=i(e),u(ye.$$.fragment,e),yt=i(e),G=l(e,"DIV",{class:!0});var Ut=U(G);u(ve.$$.fragment,Ut),qt=i(Ut),Ae=l(Ut,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-cw9h8a"&&(Ae.textContent=Pn),Ut.forEach(n),vt=i(e),u(Te.$$.fragment,e),Tt=i(e),P=l(e,"DIV",{class:!0});var N=U(P);u(We.$$.fragment,N),St=i(N),Xe=l(N,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-iulkbf"&&(Xe.textContent=Cn),Ht=i(N),Le=l(N,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-12y6y1l"&&(Le.innerHTML=Un),Ft=i(N),I=l(N,"DIV",{class:!0});var Qe=U(I);u(xe.$$.fragment,Qe),Yt=i(Qe),Ne=l(Qe,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-v78lg8"&&(Ne.textContent=$n),zt=i(Qe),u(L.$$.fragment,Qe),Qe.forEach(n),N.forEach(n),Wt=i(e),u(Je.$$.fragment,e),xt=i(e),u(Pe.$$.fragment,e),Jt=i(e),qe=l(e,"P",{}),U(qe).forEach(n),this.h()},h(){x(p,"name","hf:doc:metadata"),x(p,"content",Xn),jn(y.src,en="https://github.com/dome272/Wuerstchen/assets/61938694/0617c863-165a-43ee-9303-2a17299a0cf9")||x(y,"src",en),jn(te.src,dn="https://github.com/dome272/Wuerstchen/assets/61938694/2914830f-cbd3-461c-be64-d50734f4b49d")||x(te,"src",dn),x(te,"width","500"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,p),o(e,J,t),o(e,M,t),o(e,b,t),h(w,e,t),o(e,r,t),o(e,y,t),o(e,Se,t),o(e,R,t),o(e,He,t),o(e,Q,t),o(e,Fe,t),o(e,q,t),o(e,Ye,t),h(S,e,t),o(e,ze,t),o(e,H,t),o(e,Oe,t),h(F,e,t),o(e,Ke,t),o(e,Y,t),o(e,et,t),o(e,z,t),o(e,tt,t),o(e,O,t),o(e,nt,t),o(e,K,t),o(e,ot,t),o(e,ee,t),o(e,st,t),o(e,te,t),o(e,it,t),h(ne,e,t),o(e,rt,t),o(e,oe,t),o(e,at,t),h(se,e,t),o(e,lt,t),o(e,ie,t),o(e,ct,t),h(re,e,t),o(e,pt,t),h(ae,e,t),o(e,dt,t),o(e,le,t),o(e,mt,t),h(ce,e,t),o(e,ut,t),h(pe,e,t),o(e,ht,t),o(e,de,t),o(e,ft,t),o(e,me,t),o(e,gt,t),h(ue,e,t),o(e,_t,t),o(e,v,t),h(he,v,null),c(v,$t),c(v,$e),c(v,jt),c(v,je),c(v,kt),c(v,j),h(fe,j,null),c(j,It),c(j,ke),c(j,Gt),h(D,j,null),c(v,Bt),c(v,E),h(ge,E,null),c(E,Zt),c(E,Ie),c(v,Vt),c(v,A),h(_e,A,null),c(A,Dt),c(A,Ge),o(e,bt,t),h(be,e,t),o(e,wt,t),o(e,T,t),h(we,T,null),c(T,Et),c(T,Be),c(T,At),c(T,Ze),c(T,Xt),c(T,Ve),c(T,Lt),c(T,De),c(T,Nt),c(T,k),h(Me,k,null),c(k,Rt),c(k,Ee),c(k,Qt),h(X,k,null),o(e,Mt,t),h(ye,e,t),o(e,yt,t),o(e,G,t),h(ve,G,null),c(G,qt),c(G,Ae),o(e,vt,t),h(Te,e,t),o(e,Tt,t),o(e,P,t),h(We,P,null),c(P,St),c(P,Xe),c(P,Ht),c(P,Le),c(P,Ft),c(P,I),h(xe,I,null),c(I,Yt),c(I,Ne),c(I,zt),h(L,I,null),o(e,Wt,t),h(Je,e,t),o(e,xt,t),h(Pe,e,t),o(e,Jt,t),o(e,qe,t),Pt=!0},p(e,[t]){const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),D.$set(W);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),X.$set(B);const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),L.$set(Ce)},i(e){Pt||(f(w.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(ae.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(D.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(X.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(We.$$.fragment,e),f(xe.$$.fragment,e),f(L.$$.fragment,e),f(Je.$$.fragment,e),f(Pe.$$.fragment,e),Pt=!0)},o(e){g(w.$$.fragment,e),g(S.$$.fragment,e),g(F.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(ae.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(D.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(X.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(We.$$.fragment,e),g(xe.$$.fragment,e),g(L.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),Pt=!1},d(e){e&&(n(J),n(M),n(b),n(r),n(y),n(Se),n(R),n(He),n(Q),n(Fe),n(q),n(Ye),n(ze),n(H),n(Oe),n(Ke),n(Y),n(et),n(z),n(tt),n(O),n(nt),n(K),n(ot),n(ee),n(st),n(te),n(it),n(rt),n(oe),n(at),n(lt),n(ie),n(ct),n(pt),n(dt),n(le),n(mt),n(ut),n(ht),n(de),n(ft),n(me),n(gt),n(_t),n(v),n(bt),n(wt),n(T),n(Mt),n(yt),n(G),n(vt),n(Tt),n(P),n(Wt),n(xt),n(Jt),n(qe)),n(p),_(w,e),_(S,e),_(F,e),_(ne,e),_(se,e),_(re,e),_(ae,e),_(ce,e),_(pe,e),_(ue,e),_(he),_(fe),_(D),_(ge),_(_e),_(be,e),_(we),_(Me),_(X),_(ye,e),_(ve),_(Te,e),_(We),_(xe),_(L),_(Je,e),_(Pe,e)}}}const Xn='{"title":"Würstchen","local":"würstchen","sections":[{"title":"Würstchen Overview","local":"würstchen-overview","sections":[],"depth":2},{"title":"Würstchen v2 comes to Diffusers","local":"würstchen-v2-comes-to-diffusers","sections":[],"depth":2},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":2},{"title":"Speed-Up Inference","local":"speed-up-inference","sections":[],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"WuerstchenCombinedPipeline","local":"diffusers.WuerstchenCombinedPipeline","sections":[],"depth":2},{"title":"WuerstchenPriorPipeline","local":"diffusers.WuerstchenPriorPipeline","sections":[],"depth":2},{"title":"WuerstchenPriorPipelineOutput","local":"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput","sections":[],"depth":2},{"title":"WuerstchenDecoderPipeline","local":"diffusers.WuerstchenDecoderPipeline","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ln(V){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends Gn{constructor(p){super(),Bn(this,p,Ln,An,kn,{})}}export{Fn as component};
