import{s as Ms,n as us,o as ws}from"../chunks/scheduler.bdbef820.js";import{S as bs,i as js,g as i,s as l,r as d,A as Js,h as r,f as s,c as n,j as fs,u as o,x as p,k as ys,y as Ts,a as t,v as c,d as m,t as h,w as f}from"../chunks/index.c0aea24a.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as u,E as _s}from"../chunks/EditOnGithub.725ee0c1.js";function gs(Ra){let M,Ze,ge,Xe,w,ke,b,Ba=`There are two types of dataset objects, a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
Whichever type of dataset you choose to use or create depends on the size of the dataset.
In general, an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is ideal for big datasets (think hundreds of GBs!) due to its lazy behavior and speed advantages, while a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> is great for everything else.
This page will compare the differences between a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> to help you pick the right dataset object for you.`,Ie,j,Ce,J,Fa=`When you have a regular <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, you can access it using <code>my_dataset[0]</code>. This provides random access to the rows.
Such datasets are also called “map-style” datasets.
For example you can download ImageNet-1k like this and access any row:`,Ge,T,$e,_,Ya=`But one caveat is that you must have the entire dataset stored on your disk or in memory, which blocks you from accessing datasets bigger than the disk.
Because it can become inconvenient for big datasets, there exists another type of dataset, the <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
When you have an <code>IterableDataset</code>, you can access it using a <code>for</code> loop to load the data progressively as you iterate over the dataset.
This way, only a small fraction of examples is loaded in memory, and you don’t write anything on disk.`,ve,g,xa="For example, you can stream the ImageNet-1k dataset without downloading it on disk:",Ve,U,Re,Z,za=`Streaming can read online data without writing any file to disk.
For example, you can stream datasets made out of multiple shards, each of which is hundreds of gigabytes like <a href="https://huggingface.co/datasets/c4" rel="nofollow">C4</a>, <a href="https://huggingface.co/datasets/oscar" rel="nofollow">OSCAR</a> or <a href="https://huggingface.co/datasets/laion/laion2B-en" rel="nofollow">LAION-2B</a>.
Learn more about how to stream a dataset in the <a href="./stream">Dataset Streaming Guide</a>.`,Be,X,Wa="This is not the only difference though, because the “lazy” behavior of an <code>IterableDataset</code> is also present when it comes to dataset creation and processing.",Fe,k,Ye,I,Qa='You can create a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using lists or dictionaries, and the data is entirely converted to Arrow so you can easily access any row:',xe,C,ze,G,Na=`To create an <code>IterableDataset</code> on the other hand, you must provide a “lazy” way to load the data.
In Python, we generally use generator functions. These functions <code>yield</code> one example at a time, which means you can’t access a row by slicing it like a regular <code>Dataset</code>:`,We,$,Qe,v,Ne,V,Da='It is possible to convert local or remote data files to an Arrow <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/v2.20.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',De,R,He,B,Ha="However, this requires a conversion step from CSV to Arrow format, which takes time and disk space if your dataset is big.",Se,F,Sa=`To save disk space and skip the conversion step, you can define an <code>IterableDataset</code> by streaming from the local files directly.
This way, the data is read progressively from the local files as you iterate over the dataset:`,Ee,Y,Ae,x,Ea=`Many file formats are supported, like CSV, JSONL, and Parquet, as well as image and audio files.
You can find more information in the corresponding guides for loading <a href="./tabular_load">tabular</a>, <a href="./nlp_load">text</a>, <a href="./image_load">vision</a>, and <a href="./audio_load%5D">audio</a> datasets.`,Le,z,qe,W,Aa=`When you process a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object using <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a>, the entire dataset is processed immediately and returned.
This is similar to how <code>pandas</code> works for example.`,Pe,Q,Ke,N,La=`On the other hand, due to the “lazy” nature of an <code>IterableDataset</code>, calling <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> does not apply your <code>map</code> function over the full dataset.
Instead, your <code>map</code> function is applied on-the-fly.`,Oe,D,qa="Because of that, you can chain multiple processing steps and they will all run at once when you start iterating over the dataset:",ea,H,aa,S,sa,E,Pa=`When you shuffle a <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a>, you apply an exact shuffling of the dataset.
It works by taking a list of indices <code>[0, 1, 2, ... len(my_dataset) - 1]</code> and shuffling this list.
Then, accessing <code>my_dataset[0]</code> returns the row and index defined by the first element of the indices mapping that has been shuffled:`,ta,A,la,L,Ka=`Since we don’t have random access to the rows in the case of an <code>IterableDataset</code>, we can’t use a shuffled list of indices and access a row at an arbitrary position.
This prevents the use of exact shuffling.
Instead, a fast approximate shuffling is used in <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It uses a shuffle buffer to sample random examples iteratively from the dataset.
Since the dataset is still read iteratively, it provides excellent speed performance:`,na,q,ia,P,Oa='But using a shuffle buffer is not enough to provide a satisfactory shuffling for machine learning model training. So <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> also shuffles the dataset shards if your dataset is made of multiple files or sources:',ra,K,pa,O,da,ee,es=`Regular <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> objects are based on Arrow which provides fast random access to the rows.
Thanks to memory mapping and the fact that Arrow is an in-memory format, reading data from disk doesn’t do expensive system calls and deserialization.
It provides even faster data loading when iterating using a <code>for</code> loop by iterating on contiguous Arrow record batches.`,oa,ae,as=`However as soon as your <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping (via <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a> for example), the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
This may take a lot of time depending of the size of your dataset though:`,ca,se,ma,te,ss=`In this case, we recommend switching to an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leveraging its fast approximate shuffling method <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It only shuffles the shards order and adds a shuffle buffer to your dataset, which keeps the speed of your dataset optimal.
You can also reshuffle the dataset easily:`,ha,le,fa,ne,ts=`If you’re using your dataset on multiple epochs, the effective seed to shuffle the shards order in the shuffle buffer is <code>seed + epoch</code>.
It makes it easy to reshuffle a dataset between epochs:`,ya,ie,Ma,re,ua,pe,ls="If you training loop stops, you may want to restart the training from where it was. To do so you can save a checkpoint of your model and optimizers, as well as your data loader.",wa,de,ns="To restart the iteration of a map-style dataset, you can simply skip the first examples:",ba,oe,ja,ce,is="But if you use a <code>DataLoader</code> with a <code>Sampler</code>, you should instead save the state of your sampler (you might have write a custom sampler that allows resuming).",Ja,me,rs='On the other hand, iterable datasets don’t provide random access to a specific example inde to resume from. But you can use <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.state_dict">IterableDataset.state_dict()</a> and <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset.load_state_dict">IterableDataset.load_state_dict()</a> to resume from a checkpoint instead, similarly to what you can do for models and optimizers:',Ta,he,_a,fe,ps="Under the hood, the iterable dataset keeps track of the current shard being read and the example index in the current shard and it stores this info in the <code>state_dict</code>.",ga,ye,ds=`To resume from a checkpoint, the dataset skips all the shards that were previously read to restart from the current shard.
Then it reads the shard and skips examples until it reaches the exact example from the checkpoint.`,Ua,Me,os="Therefore restarting a dataset is quite fast, since it will not re-read the shards that have already been iterated on. Still, resuming a dataset is generally not instantaneous since it has to restart reading from the beginning of the current shard and skip examples until it reaches the checkpoint location.",Za,ue,cs='This can be used with the <code>StatefulDataLoader</code> from <code>torchdata</code>, see <a href="./use_with_pytorch#stream-data">streaming with a PyTorch DataLoader</a>.',Xa,we,ka,be,ms='If you want to benefit from the “lazy” behavior of an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> or their speed advantages, you can switch your map-style <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> to an <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Ia,je,Ca,Je,hs='If you want to shuffle your dataset or <a href="./use_with_pytorch#stream-data">use it with a PyTorch DataLoader</a>, we recommend generating a sharded <a href="/docs/datasets/v2.20.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Ga,Te,$a,_e,va,Ue,Va;return w=new u({props:{title:"Differences between Dataset and IterableDataset",local:"differences-between-dataset-and-iterabledataset",headingTag:"h1"}}),j=new u({props:{title:"Downloading and streaming",local:"downloading-and-streaming",headingTag:"h2"}}),T=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUyMCUyMCUyMyUyMGRvd25sb2FkcyUyMHRoZSUyMGZ1bGwlMjBkYXRhc2V0JTBBcHJpbnQoaW1hZ2VuZXQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)  <span class="hljs-comment"># downloads the full dataset</span>
<span class="hljs-built_in">print</span>(imagenet[<span class="hljs-number">0</span>])`,wrap:!1}}),U=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMjAlMjAlMjMlMjB3aWxsJTIwc3RhcnQlMjBsb2FkaW5nJTIwdGhlJTIwZGF0YSUyMHdoZW4lMjBpdGVyYXRlZCUyMG92ZXIlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBpbWFnZW5ldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># will start loading the data when iterated over</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> imagenet:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),k=new u({props:{title:"Creating map-style datasets and iterable datasets",local:"creating-map-style-datasets-and-iterable-datasets",headingTag:"h2"}}),C=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmNvbF8xJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCU3RCklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = Dataset.from_dict({<span class="hljs-string">&quot;col_1&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]})
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),$=new y({props:{code:"ZGVmJTIwbXlfZ2VuZXJhdG9yKG4pJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMCU3QiUyMmNvbF8xJTIyJTNBJTIwaSU3RCUwQSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMm4lMjIlM0ElMjAxMCU3RCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n</span>):
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
        <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;col_1&quot;</span>: i}

my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs={<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>})
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),v=new u({props:{title:"Loading local files entirely and progressively",local:"loading-local-files-entirely-and-progressively",headingTag:"h2"}}),R=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),Y=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwbXlfaXRlcmFibGVfZGF0YXNldCUzQSUyMCUyMCUyMyUyMHRoaXMlMjByZWFkcyUyMHRoZSUyMENTViUyMGZpbGUlMjBwcm9ncmVzc2l2ZWx5JTIwYXMlMjB5b3UlMjBpdGVyYXRlJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># this reads the CSV file progressively as you iterate over the dataset</span>
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),z=new u({props:{title:"Eager data processing and lazy data processing",local:"eager-data-processing-and-lazy-data-processing",headingTag:"h2"}}),Q=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQubWFwKHByb2Nlc3NfZm4pJTIwJTIwJTIzJTIwcHJvY2Vzc19mbiUyMGlzJTIwYXBwbGllZCUyMG9uJTIwYWxsJTIwdGhlJTIwZXhhbXBsZXMlMjBvZiUyMHRoZSUyMGRhdGFzZXQlMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = my_dataset.<span class="hljs-built_in">map</span>(process_fn)  <span class="hljs-comment"># process_fn is applied on all the examples of the dataset</span>
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),H=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQubWFwKHByb2Nlc3NfZm5fMSklMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5maWx0ZXIoZmlsdGVyX2ZuKSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0Lm1hcChwcm9jZXNzX2ZuXzIpJTBBJTBBJTIzJTIwcHJvY2Vzc19mbl8xJTJDJTIwZmlsdGVyX2ZuJTIwYW5kJTIwcHJvY2Vzc19mbl8yJTIwYXJlJTIwYXBwbGllZCUyMG9uLXRoZS1mbHklMjB3aGVuJTIwaXRlcmF0aW5nJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_1)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">filter</span>(filter_fn)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_2)

<span class="hljs-comment"># process_fn_1, filter_fn and process_fn_2 are applied on-the-fly when iterating over the dataset</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),S=new u({props:{title:"Exact and fast approximate shuffling",local:"exact-and-fast-approximate-shuffling",headingTag:"h2"}}),A=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBcHJpbnQobXlfZGF0YXNldCU1QjAlNUQp",highlighted:`my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),q=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIlMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwU3RyZWFtJTIwZnJvbSUyMHRoZSUyMGludGVybmV0JTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMzklMEElMEElMjMlMjBTdHJlYW0lMjBmcm9tJTIwbG9jYWwlMjBmaWxlcyUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlN0IlMjJ0cmFpbiUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QuY3N2JTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQlMEElMEElMjMlMjBGcm9tJTIwYSUyMGdlbmVyYXRvciUyMGZ1bmN0aW9uJTBBZGVmJTIwbXlfZ2VuZXJhdG9yKG4lMkMlMjBzb3VyY2VzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHNvdXJjZSUyMGluJTIwc291cmNlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGVfaWRfZm9yX2N1cnJlbnRfc291cmNlJTIwaW4lMjByYW5nZShuKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTdCJTIyZXhhbXBsZV9pZCUyMiUzQSUyMGYlMjIlN0Jzb3VyY2UlN0RfJTdCZXhhbXBsZV9pZF9mb3JfY3VycmVudF9zb3VyY2UlN0QlMjIlN0QlMEElMEFnZW5fa3dhcmdzJTIwJTNEJTIwJTdCJTIybiUyMiUzQSUyMDEwJTJDJTIwJTIyc291cmNlcyUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QlMjIlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDI0KSU1RCU3RCUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRGdlbl9rd2FyZ3MpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQ=",highlighted:`<span class="hljs-comment"># Stream from the internet</span>
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 39</span>

<span class="hljs-comment"># Stream from local files</span>
data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>.csv&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>

<span class="hljs-comment"># From a generator function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n, sources</span>):
    <span class="hljs-keyword">for</span> source <span class="hljs-keyword">in</span> sources:
        <span class="hljs-keyword">for</span> example_id_for_current_source <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
            <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;example_id&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{source}</span>_<span class="hljs-subst">{example_id_for_current_source}</span>&quot;</span>}

gen_kwargs = {<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;sources&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs=gen_kwargs)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),O=new u({props:{title:"Speed differences",local:"speed-differences",headingTag:"h2"}}),se=new y({props:{code:"bXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjB1cCUyMHRvJTIwMTB4JTIwc2xvd2VyJTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuZmxhdHRlbl9pbmRpY2VzKCklMjAlMjAlMjMlMjByZXdyaXRlJTIwdGhlJTIwc2h1ZmZsZWQlMjBkYXRhc2V0JTIwb24lMjBkaXNrJTIwYXMlMjBjb250aWd1b3VzJTIwY2h1bmtzJTIwb2YlMjBkYXRhJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTIwYWdhaW4=",highlighted:`my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast</span>
my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># up to 10x slower</span>
my_dataset = my_dataset.flatten_indices()  <span class="hljs-comment"># rewrite the shuffled dataset on disk as contiguous chunks of data</span>
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast again</span>`,wrap:!1}}),le=new y({props:{code:"Zm9yJTIwZXhhbXBsZSUyMGluJTIwZW51bWVyYXRlKG15X2l0ZXJhYmxlX2RhdGFzZXQpJTNBJTIwJTIwJTIzJTIwZmFzdCUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEFzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5zaHVmZmxlKHNlZWQlM0Q0MiUyQyUyMGJ1ZmZlcl9zaXplJTNEMTAwKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGVudW1lcmF0ZShzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0KSUzQSUyMCUyMCUyMyUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDEzMzclMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMjAlMjAlMjMlMjByZXNodWZmbGluZyUyMHVzaW5nJTIwYW5vdGhlciUyMHNlZWQlMjBpcyUyMGluc3RhbnRhbmVvdXMlMEElMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBlbnVtZXJhdGUoc2h1ZmZsZWRfaXRlcmFibGVfZGF0YXNldCklM0ElMjAlMjAlMjMlMjBzdGlsbCUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(my_iterable_dataset):  <span class="hljs-comment"># fast</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># as fast as before</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">1337</span>, buffer_size=<span class="hljs-number">100</span>)  <span class="hljs-comment"># reshuffling using another seed is instantaneous</span>

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># still as fast as before</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),ie=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG5fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMG15X2l0ZXJhYmxlX2RhdGFzZXQlM0ElMjAlMjAlMjMlMjBmYXN0JTIwJTJCJTIwcmVzaHVmZmxlZCUyMGF0JTIwZWFjaCUyMGVwb2NoJTIwdXNpbmclMjAlNjBlZmZlY3RpdmVfc2VlZCUyMCUzRCUyMHNlZWQlMjAlMkIlMjBlcG9jaCU2MCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):
    my_iterable_dataset.set_epoch(epoch)
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># fast + reshuffled at each epoch using \`effective_seed = seed + epoch\`</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),re=new u({props:{title:"Checkpoint and resuming differences",local:"checkpoint-and-resuming-differences",headingTag:"h2"}}),oe=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2VsZWN0KHJhbmdlKHN0YXJ0X2luZGV4JTJDJTIwbGVuKGRhdGFzZXQpKSk=",highlighted:'my_dataset = my_dataset.select(<span class="hljs-built_in">range</span>(start_index, <span class="hljs-built_in">len</span>(dataset)))',wrap:!1}}),he=new y({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmElMjIlM0ElMjByYW5nZSg2KSU3RCkudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMyklMEElMjMlMjBzYXZlJTIwaW4lMjB0aGUlMjBtaWRkbGUlMjBvZiUyMHRyYWluaW5nJTBBc3RhdGVfZGljdCUyMCUzRCUyMGl0ZXJhYmxlX2RhdGFzZXQuc3RhdGVfZGljdCgpJTBBJTIzJTIwYW5kJTIwcmVzdW1lJTIwbGF0ZXIlMEFpdGVyYWJsZV9kYXRhc2V0LmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: <span class="hljs-built_in">range</span>(<span class="hljs-number">6</span>)}).to_iterable_dataset(num_shards=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save in the middle of training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = iterable_dataset.state_dict()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and resume later</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset.load_state_dict(state_dict)`,wrap:!1}}),we=new u({props:{title:"Switch from map-style to iterable",local:"switch-from-map-style-to-iterable",headingTag:"h2"}}),je=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldCgp",highlighted:"my_iterable_dataset = my_dataset.to_iterable_dataset()",wrap:!1}}),Te=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTAyNCklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMTAyNA==",highlighted:`my_iterable_dataset = my_dataset.to_iterable_dataset(num_shards=<span class="hljs-number">1024</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),_e=new _s({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/about_mapstyle_vs_iterable.mdx"}}),{c(){M=i("meta"),Ze=l(),ge=i("p"),Xe=l(),d(w.$$.fragment),ke=l(),b=i("p"),b.innerHTML=Ba,Ie=l(),d(j.$$.fragment),Ce=l(),J=i("p"),J.innerHTML=Fa,Ge=l(),d(T.$$.fragment),$e=l(),_=i("p"),_.innerHTML=Ya,ve=l(),g=i("p"),g.textContent=xa,Ve=l(),d(U.$$.fragment),Re=l(),Z=i("p"),Z.innerHTML=za,Be=l(),X=i("p"),X.innerHTML=Wa,Fe=l(),d(k.$$.fragment),Ye=l(),I=i("p"),I.innerHTML=Qa,xe=l(),d(C.$$.fragment),ze=l(),G=i("p"),G.innerHTML=Na,We=l(),d($.$$.fragment),Qe=l(),d(v.$$.fragment),Ne=l(),V=i("p"),V.innerHTML=Da,De=l(),d(R.$$.fragment),He=l(),B=i("p"),B.textContent=Ha,Se=l(),F=i("p"),F.innerHTML=Sa,Ee=l(),d(Y.$$.fragment),Ae=l(),x=i("p"),x.innerHTML=Ea,Le=l(),d(z.$$.fragment),qe=l(),W=i("p"),W.innerHTML=Aa,Pe=l(),d(Q.$$.fragment),Ke=l(),N=i("p"),N.innerHTML=La,Oe=l(),D=i("p"),D.textContent=qa,ea=l(),d(H.$$.fragment),aa=l(),d(S.$$.fragment),sa=l(),E=i("p"),E.innerHTML=Pa,ta=l(),d(A.$$.fragment),la=l(),L=i("p"),L.innerHTML=Ka,na=l(),d(q.$$.fragment),ia=l(),P=i("p"),P.innerHTML=Oa,ra=l(),d(K.$$.fragment),pa=l(),d(O.$$.fragment),da=l(),ee=i("p"),ee.innerHTML=es,oa=l(),ae=i("p"),ae.innerHTML=as,ca=l(),d(se.$$.fragment),ma=l(),te=i("p"),te.innerHTML=ss,ha=l(),d(le.$$.fragment),fa=l(),ne=i("p"),ne.innerHTML=ts,ya=l(),d(ie.$$.fragment),Ma=l(),d(re.$$.fragment),ua=l(),pe=i("p"),pe.textContent=ls,wa=l(),de=i("p"),de.textContent=ns,ba=l(),d(oe.$$.fragment),ja=l(),ce=i("p"),ce.innerHTML=is,Ja=l(),me=i("p"),me.innerHTML=rs,Ta=l(),d(he.$$.fragment),_a=l(),fe=i("p"),fe.innerHTML=ps,ga=l(),ye=i("p"),ye.textContent=ds,Ua=l(),Me=i("p"),Me.textContent=os,Za=l(),ue=i("p"),ue.innerHTML=cs,Xa=l(),d(we.$$.fragment),ka=l(),be=i("p"),be.innerHTML=ms,Ia=l(),d(je.$$.fragment),Ca=l(),Je=i("p"),Je.innerHTML=hs,Ga=l(),d(Te.$$.fragment),$a=l(),d(_e.$$.fragment),va=l(),Ue=i("p"),this.h()},l(e){const a=Js("svelte-u9bgzb",document.head);M=r(a,"META",{name:!0,content:!0}),a.forEach(s),Ze=n(e),ge=r(e,"P",{}),fs(ge).forEach(s),Xe=n(e),o(w.$$.fragment,e),ke=n(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-10wiv24"&&(b.innerHTML=Ba),Ie=n(e),o(j.$$.fragment,e),Ce=n(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-rvpx3x"&&(J.innerHTML=Fa),Ge=n(e),o(T.$$.fragment,e),$e=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-15wk3ur"&&(_.innerHTML=Ya),ve=n(e),g=r(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-p27tn9"&&(g.textContent=xa),Ve=n(e),o(U.$$.fragment,e),Re=n(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-qlt0xf"&&(Z.innerHTML=za),Be=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1ik5e8b"&&(X.innerHTML=Wa),Fe=n(e),o(k.$$.fragment,e),Ye=n(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qe9a7s"&&(I.innerHTML=Qa),xe=n(e),o(C.$$.fragment,e),ze=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-z2r7k0"&&(G.innerHTML=Na),We=n(e),o($.$$.fragment,e),Qe=n(e),o(v.$$.fragment,e),Ne=n(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1hbbq36"&&(V.innerHTML=Da),De=n(e),o(R.$$.fragment,e),He=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gryvti"&&(B.textContent=Ha),Se=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-gn3sd"&&(F.innerHTML=Sa),Ee=n(e),o(Y.$$.fragment,e),Ae=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-u916f6"&&(x.innerHTML=Ea),Le=n(e),o(z.$$.fragment,e),qe=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-4o5ap4"&&(W.innerHTML=Aa),Pe=n(e),o(Q.$$.fragment,e),Ke=n(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-156683b"&&(N.innerHTML=La),Oe=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-vsuw18"&&(D.textContent=qa),ea=n(e),o(H.$$.fragment,e),aa=n(e),o(S.$$.fragment,e),sa=n(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-otd4jm"&&(E.innerHTML=Pa),ta=n(e),o(A.$$.fragment,e),la=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-16p0l17"&&(L.innerHTML=Ka),na=n(e),o(q.$$.fragment,e),ia=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1ecocnc"&&(P.innerHTML=Oa),ra=n(e),o(K.$$.fragment,e),pa=n(e),o(O.$$.fragment,e),da=n(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-d5h4gw"&&(ee.innerHTML=es),oa=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1g0pepe"&&(ae.innerHTML=as),ca=n(e),o(se.$$.fragment,e),ma=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-z1spep"&&(te.innerHTML=ss),ha=n(e),o(le.$$.fragment,e),fa=n(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1yhobsx"&&(ne.innerHTML=ts),ya=n(e),o(ie.$$.fragment,e),Ma=n(e),o(re.$$.fragment,e),ua=n(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-tb764k"&&(pe.textContent=ls),wa=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1vtsyk"&&(de.textContent=ns),ba=n(e),o(oe.$$.fragment,e),ja=n(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-xju6it"&&(ce.innerHTML=is),Ja=n(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-vt91i2"&&(me.innerHTML=rs),Ta=n(e),o(he.$$.fragment,e),_a=n(e),fe=r(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-ul64r3"&&(fe.innerHTML=ps),ga=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-fghrva"&&(ye.textContent=ds),Ua=n(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1i92o70"&&(Me.textContent=os),Za=n(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1r4w1a2"&&(ue.innerHTML=cs),Xa=n(e),o(we.$$.fragment,e),ka=n(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-hv3d86"&&(be.innerHTML=ms),Ia=n(e),o(je.$$.fragment,e),Ca=n(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-p4iqof"&&(Je.innerHTML=hs),Ga=n(e),o(Te.$$.fragment,e),$a=n(e),o(_e.$$.fragment,e),va=n(e),Ue=r(e,"P",{}),fs(Ue).forEach(s),this.h()},h(){ys(M,"name","hf:doc:metadata"),ys(M,"content",Us)},m(e,a){Ts(document.head,M),t(e,Ze,a),t(e,ge,a),t(e,Xe,a),c(w,e,a),t(e,ke,a),t(e,b,a),t(e,Ie,a),c(j,e,a),t(e,Ce,a),t(e,J,a),t(e,Ge,a),c(T,e,a),t(e,$e,a),t(e,_,a),t(e,ve,a),t(e,g,a),t(e,Ve,a),c(U,e,a),t(e,Re,a),t(e,Z,a),t(e,Be,a),t(e,X,a),t(e,Fe,a),c(k,e,a),t(e,Ye,a),t(e,I,a),t(e,xe,a),c(C,e,a),t(e,ze,a),t(e,G,a),t(e,We,a),c($,e,a),t(e,Qe,a),c(v,e,a),t(e,Ne,a),t(e,V,a),t(e,De,a),c(R,e,a),t(e,He,a),t(e,B,a),t(e,Se,a),t(e,F,a),t(e,Ee,a),c(Y,e,a),t(e,Ae,a),t(e,x,a),t(e,Le,a),c(z,e,a),t(e,qe,a),t(e,W,a),t(e,Pe,a),c(Q,e,a),t(e,Ke,a),t(e,N,a),t(e,Oe,a),t(e,D,a),t(e,ea,a),c(H,e,a),t(e,aa,a),c(S,e,a),t(e,sa,a),t(e,E,a),t(e,ta,a),c(A,e,a),t(e,la,a),t(e,L,a),t(e,na,a),c(q,e,a),t(e,ia,a),t(e,P,a),t(e,ra,a),c(K,e,a),t(e,pa,a),c(O,e,a),t(e,da,a),t(e,ee,a),t(e,oa,a),t(e,ae,a),t(e,ca,a),c(se,e,a),t(e,ma,a),t(e,te,a),t(e,ha,a),c(le,e,a),t(e,fa,a),t(e,ne,a),t(e,ya,a),c(ie,e,a),t(e,Ma,a),c(re,e,a),t(e,ua,a),t(e,pe,a),t(e,wa,a),t(e,de,a),t(e,ba,a),c(oe,e,a),t(e,ja,a),t(e,ce,a),t(e,Ja,a),t(e,me,a),t(e,Ta,a),c(he,e,a),t(e,_a,a),t(e,fe,a),t(e,ga,a),t(e,ye,a),t(e,Ua,a),t(e,Me,a),t(e,Za,a),t(e,ue,a),t(e,Xa,a),c(we,e,a),t(e,ka,a),t(e,be,a),t(e,Ia,a),c(je,e,a),t(e,Ca,a),t(e,Je,a),t(e,Ga,a),c(Te,e,a),t(e,$a,a),c(_e,e,a),t(e,va,a),t(e,Ue,a),Va=!0},p:us,i(e){Va||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(R.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(he.$$.fragment,e),m(we.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(_e.$$.fragment,e),Va=!0)},o(e){h(w.$$.fragment,e),h(j.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(k.$$.fragment,e),h(C.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Te.$$.fragment,e),h(_e.$$.fragment,e),Va=!1},d(e){e&&(s(Ze),s(ge),s(Xe),s(ke),s(b),s(Ie),s(Ce),s(J),s(Ge),s($e),s(_),s(ve),s(g),s(Ve),s(Re),s(Z),s(Be),s(X),s(Fe),s(Ye),s(I),s(xe),s(ze),s(G),s(We),s(Qe),s(Ne),s(V),s(De),s(He),s(B),s(Se),s(F),s(Ee),s(Ae),s(x),s(Le),s(qe),s(W),s(Pe),s(Ke),s(N),s(Oe),s(D),s(ea),s(aa),s(sa),s(E),s(ta),s(la),s(L),s(na),s(ia),s(P),s(ra),s(pa),s(da),s(ee),s(oa),s(ae),s(ca),s(ma),s(te),s(ha),s(fa),s(ne),s(ya),s(Ma),s(ua),s(pe),s(wa),s(de),s(ba),s(ja),s(ce),s(Ja),s(me),s(Ta),s(_a),s(fe),s(ga),s(ye),s(Ua),s(Me),s(Za),s(ue),s(Xa),s(ka),s(be),s(Ia),s(Ca),s(Je),s(Ga),s($a),s(va),s(Ue)),s(M),f(w,e),f(j,e),f(T,e),f(U,e),f(k,e),f(C,e),f($,e),f(v,e),f(R,e),f(Y,e),f(z,e),f(Q,e),f(H,e),f(S,e),f(A,e),f(q,e),f(K,e),f(O,e),f(se,e),f(le,e),f(ie,e),f(re,e),f(oe,e),f(he,e),f(we,e),f(je,e),f(Te,e),f(_e,e)}}}const Us='{"title":"Differences between Dataset and IterableDataset","local":"differences-between-dataset-and-iterabledataset","sections":[{"title":"Downloading and streaming","local":"downloading-and-streaming","sections":[],"depth":2},{"title":"Creating map-style datasets and iterable datasets","local":"creating-map-style-datasets-and-iterable-datasets","sections":[],"depth":2},{"title":"Loading local files entirely and progressively","local":"loading-local-files-entirely-and-progressively","sections":[],"depth":2},{"title":"Eager data processing and lazy data processing","local":"eager-data-processing-and-lazy-data-processing","sections":[],"depth":2},{"title":"Exact and fast approximate shuffling","local":"exact-and-fast-approximate-shuffling","sections":[],"depth":2},{"title":"Speed differences","local":"speed-differences","sections":[],"depth":2},{"title":"Checkpoint and resuming differences","local":"checkpoint-and-resuming-differences","sections":[],"depth":2},{"title":"Switch from map-style to iterable","local":"switch-from-map-style-to-iterable","sections":[],"depth":2}],"depth":1}';function Zs(Ra){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends bs{constructor(M){super(),js(this,M,Zs,gs,Ms,{})}}export{Gs as component};
