import{s as xn,A as Un,o as jn,n as eo}from"../chunks/scheduler.01eeda35.js";import{S as Wn,i as Gn,g as l,s as n,r as h,A as Zn,h as d,f as t,c as a,j as I,u as p,x as b,k as M,y as i,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.6dd51b66.js";import{T as pt}from"../chunks/Tip.de9bae2b.js";import{D as W}from"../chunks/Docstring.cb556860.js";import{C as Ke}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Qt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as J,E as Vn}from"../chunks/index.58fe8f9d.js";function Bn(C){let r,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',c,y,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){r=l("p"),r.innerHTML=T,c=n(),y=l("p"),y.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-nz63kd"&&(r.innerHTML=T),c=a(m),y=d(m,"P",{"data-svelte-h":!0}),b(y)!=="svelte-aze40l"&&(y.innerHTML=v)},m(m,w){s(m,r,w),s(m,c,w),s(m,y,w)},p:eo,d(m){m&&(t(r),t(c),t(y))}}}function Fn(C){let r,T;return r=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbk1vZGVsJTJDJTIwQ2hhbWVsZW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMGNoYW1lbGVvbiUyMGNoYW1lbGVvbi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDaGFtZWxlb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjaGFtZWxlb24tN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonModel, ChameleonConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a chameleon chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ChameleonConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(r.$$.fragment)},l(c){p(r.$$.fragment,c)},m(c,y){g(r,c,y),T=!0},p:eo,i(c){T||(f(r.$$.fragment,c),T=!0)},o(c){u(r.$$.fragment,c),T=!1},d(c){_(r,c)}}}function Rn(C){let r,T=`Although the recipe for forward pass needs to be defined within
this function, one should call the <code>Module</code> instance afterwards
instead of this since the former takes care of running the
registered hooks while the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-rqqap8"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:eo,d(c){c&&t(r)}}}function Nn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:eo,d(c){c&&t(r)}}}function Pn(C){let r,T="Example:",c,y,v;return y=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDaGFtZWxlb25Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YSUyRmNoYW1lbGVvbi03YiUyMiklMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtZXRhJTJGY2hhbWVsZW9uLTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ChameleonModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta/chameleon-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonModel.from_pretrained(<span class="hljs-string">&quot;meta/chameleon-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){r=l("p"),r.textContent=T,c=n(),h(y.$$.fragment)},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=T),c=a(m),p(y.$$.fragment,m)},m(m,w){s(m,r,w),s(m,c,w),g(y,m,w),v=!0},p:eo,i(m){v||(f(y.$$.fragment,m),v=!0)},o(m){u(y.$$.fragment,m),v=!1},d(m){m&&(t(r),t(c)),_(y,m)}}}function Hn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:eo,d(c){c&&t(r)}}}function qn(C){let r,T="Example:",c,y,v;return y=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXByb2Nlc3NvciUyMCUzRCUyMENoYW1lbGVvblByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMHVzZWQlMjB0byUyMGtub3clMjBhJTIwbG90JTIwYWJvdXQlMjBjb25zdGVsbGF0aW9ucyUyMHdoZW4lMjBJJTIwd2FzJTIweW91bmdlciUyQyUyMGJ1dCUyMGFzJTIwSSUyMGdyZXclMjBvbGRlciUyQyUyMEklMjBmb3Jnb3QlMjBtb3N0JTIwb2YlMjB3aGF0JTIwSSUyMGtuZXcuJTIwVGhlc2UlMjBhcmUlMjB0aGUlMjBvbmx5JTIwdHdvJTIwY29uc3RlbGxhdGlvbnMlMjB0aGF0JTIwSSUyMHJlYWxseSUyMHJlbWVtYmVyJTIwbm93LiUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0VJJTIwd291bGQlMjBsaWtlJTIwZm9yJTIweW91JTIwdG8lMjB0ZWxsJTIwbWUlMjBhYm91dCUyMDMlMjBtb3JlJTIwY29uc3RlbGxhdGlvbnMlMjBhbmQlMjBnaXZlJTIwbWUlMjBhJTIwbGl0dGxlJTIwYml0JTIwb2YlMjBoaXN0b3J5JTIwYWJvdXQlMjB0aGUlMjBjb25zdGVsbGF0aW9uLiUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZuaW5lcGxhbmV0cy5vcmclMkZ3cC1jb250ZW50JTJGdXBsb2FkcyUyRjIwMjAlMkYxMiUyRnRoZS1iaWctZGlwcGVyLTEuanBnJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCglMjJodHRwcyUzQSUyRiUyRnd3dy5reGFuLmNvbSUyRndwLWNvbnRlbnQlMkZ1cGxvYWRzJTJGc2l0ZXMlMkY0MCUyRjIwMjAlMkYxMCUyRk9SSU9OLmpwZyUyMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEJTVCaW1hZ2UlMkMlMjBpbWFnZV8yJTVEJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSUyQyUyMHRvcmNoLmJmbG9hdDE2KSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I used to know a lot about constellations when I was younger, but as I grew older, I forgot most of what I knew. These are the only two constellations that I really remember now.&lt;image&gt;&lt;image&gt;I would like for you to tell me about 3 more constellations and give me a little bit of history about the constellation.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://nineplanets.org/wp-content/uploads/2020/12/the-big-dipper-1.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://www.kxan.com/wp-content/uploads/sites/40/2020/10/ORION.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=[image, image_2], text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=T,c=n(),h(y.$$.fragment)},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=T),c=a(m),p(y.$$.fragment,m)},m(m,w){s(m,r,w),s(m,c,w),g(y,m,w),v=!0},p:eo,i(m){v||(f(y.$$.fragment,m),v=!0)},o(m){u(y.$$.fragment,m),v=!1},d(m){m&&(t(r),t(c)),_(y,m)}}}function En(C){let r,T,c,y,v,m,w,Xt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Co,ae,Jo,se,St='The Chameleon model was proposed in <a href="https://arxiv.org/abs/2405.09818v1" rel="nofollow">Chameleon: Mixed-Modal Early-Fusion Foundation Models</a> by META AI Chameleon Team. Chameleon is a Vision-Language Model that use vector quantization to tokenize images which enables the model to generate multimodal output. The model takes images and texts as input, including an interleaved format, and generates textual response. Image generation module is not released yet.',ko,re,At="The abstract from the paper is the following:",$o,ie,Dt=`<em>We present Chameleon, a family of early-fusion token-based mixed-modal models capable of understanding and generating images and text in any arbitrary sequence. We outline a stable training
approach from inception, an alignment recipe, and an architectural parameterization tailored for the
early-fusion, token-based, mixed-modal setting. The models are evaluated on a comprehensive range
of tasks, including visual question answering, image captioning, text generation, image generation, and
long-form mixed modal generation. Chameleon demonstrates broad and general capabilities, including
state-of-the-art performance in image captioning tasks, outperforms Llama-2 in text-only tasks while
being competitive with models such as Mixtral 8x7B and Gemini-Pro, and performs non-trivial image
generation, all in a single model. It also matches or exceeds the performance of much larger models,
including Gemini Pro and GPT-4V, according to human judgments on a new long-form mixed-modal
generation evaluation, where either the prompt or outputs contain mixed sequences of both images and
text. Chameleon marks a significant step forward in unified modeling of full multimodal documents</em>`,zo,q,Ot,Io,le,Kt='Chameleon incorporates a vector quantizer module to transform images into discrete tokens. That also enables image generation using an auto-regressive transformer. Taken from the <a href="https://arxiv.org/abs/2405.09818v1">original paper.</a>',xo,de,en=`This model was contributed by <a href="https://huggingface.co/joaogante" rel="nofollow">joaogante</a> and <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/facebookresearch/chameleon" rel="nofollow">here</a>.`,Uo,ce,jo,me,on="<li><p>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to set <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</p></li> <li><p>Note that Chameleon was tuned for safety alignment. If the model is refusing to answer, consider asking a more concrete question, instead of an open question.</p></li> <li><p>Chameleon generates in chat format which means that the generated text will always be the “assistant’s turn”. You can enable a text completion generation by passing <code>return_for_text_completion=True</code> when calling the processor.</p></li>",Wo,he,tn=`<p>[!NOTE]
Chameleon implementation in Transformers uses a special image token to indicate where to merge image embeddings. For special image token we didn’t add a new one but used one of the reserved tokens: <code>&lt;reserved08707&gt;</code>. You have to add <code>&lt;image&gt;</code> to your prompt in the place where the image should be embedded for correct generation.</p>`,Go,pe,Zo,ge,Vo,fe,nn=`Chameleon is a gated model so make sure to have access and login to Hugging Face Hub using a token.
Here’s how to load the model and perform inference in half-precision (<code>torch.bfloat16</code>):`,Bo,ue,Fo,_e,Ro,be,an="Chameleon can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",No,ye,Po,Te,Ho,ve,qo,we,sn="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",Eo,E,Lo,Me,rn="Simply change the snippet above with:",Yo,Ce,Qo,Je,Xo,ke,ln='The models supports both, Flash-Attention 2 and PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> which can be enables for optimization. SDPA is the default options when you load the model, If you want to switch for Flash Attention 2, first make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository</a> regarding that package installation. Simply change the snippet above with:',So,$e,Ao,ze,Do,x,Ie,gt,oo,dn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>. It is used to instantiate a
chameleon model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,ft,to,cn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ut,L,Oo,xe,Ko,P,Ue,_t,no,mn=`This is the configuration class to store the configuration of a <code>ChameleonVQModel</code>. It is used to instantiate a
<code>ChameleonVQModel</code> according to the specified arguments, defining the model architecture.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a
configuration with the defaults will yield a similar configuration to the VQModel of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,et,je,ot,k,We,bt,ao,hn=`Constructs a Chameleon processor which wraps a Chameleon image processor and a Chameleon tokenizer into a single
processor.`,yt,so,pn=`<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonProcessor">ChameleonProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonProcessor.decode">decode()</a> for more information.`,Tt,Y,Ge,vt,ro,gn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,wt,Q,Ze,Mt,io,fn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,tt,Ve,nt,B,Be,Ct,lo,un="Constructs a Chameleon image processor.",Jt,X,Fe,kt,co,_n="Preprocess an image or batch of images.",at,Re,st,$,Ne,$t,mo,bn=`The VQ-VAE model used in Chameleon for encoding/decoding images into discrete tokens.
This model follows the “Make-a-scene: Scene-based text-to-image generation with human priors” paper from
<a href="https://arxiv.org/abs/2203.13131" rel="nofollow">Oran Gafni, Adam Polyak, Oron Ashual, Shelly Sheynin, Devi Parikh, and Yaniv Taigman</a>.`,zt,ho,yn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,po,Tn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,G,Pe,Ut,go,vn="Define the computation performed at every call.",jt,fo,wn="Should be overridden by all subclasses.",Wt,S,rt,He,it,z,qe,Gt,uo,Mn=`The bare chameleon Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zt,_o,Cn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vt,bo,Jn="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>ChameleonDecoderLayer</code>",Bt,Z,Ee,Ft,yo,kn='The <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a> forward method, overrides the <code>__call__</code> special method.',Rt,A,Nt,D,lt,Le,dt,U,Ye,Pt,To,$n=`Chameleon Model with a head on top used for outputting logits for next token prediction.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ht,vo,zn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qt,V,Qe,Et,wo,In='The <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonForConditionalGeneration">ChameleonForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Lt,O,Yt,K,ct,Xe,mt,Mo,ht;return v=new J({props:{title:"Chameleon",local:"chameleon",headingTag:"h1"}}),ae=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new J({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),pe=new J({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ge=new J({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),ue=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDaGFtZWxlb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGY2hhbWVsZW9uLTdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwcHJvbXB0JTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlM0NpbWFnZSUzRSUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHRleHQlM0Rwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQSUwQSUyMyUyMGF1dG9yZWdyZXNzaXZlbHklMjBjb21wbGV0ZSUyMHByb21wdCUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFwcmludChwcm9jZXNzb3IuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)
model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt</span>
url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;What do you see in this image?&lt;image&gt;&quot;</span>

inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),_e=new J({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),ye=new Ke({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batched prompt, where the first one is a multi-image prompt and the second is not</span>
prompts = [
    <span class="hljs-string">&quot;What do these images have in common?&lt;image&gt;&lt;image&gt;&quot;</span>,
    <span class="hljs-string">&quot;&lt;image&gt;What is shown in this image?&quot;</span>
]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),Te=new J({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ve=new J({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),E=new pt({props:{$$slots:{default:[Bn]},$$scope:{ctx:C}}}),Ce=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Je=new J({props:{title:"Use Flash-Attention 2 and SDPA to further speed-up generation",local:"use-flash-attention-2-and-sdpa-to-further-speed-up-generation",headingTag:"h3"}}),$e=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration

model_id = <span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>
model = ChameleonForConditionalGeneration.from_pretrained(
    model_id,
    torch_dtype=torch.bfloat16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),ze=new J({props:{title:"ChameleonConfig",local:"transformers.ChameleonConfig",headingTag:"h2"}}),Ie=new W({props:{name:"class transformers.ChameleonConfig",anchor:"transformers.ChameleonConfig",parameters:[{name:"vocab_size",val:" = 65536"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 32"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"model_parallel_size",val:" = 1"},{name:"swin_norm",val:" = False"},{name:"vq_config",val:" = None"},{name:"vocabulary_map",val:" = None"},{name:"mlp_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Vocabulary size of the chameleon model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>; this includes text and image tokens.`,name:"vocab_size"},{anchor:"transformers.ChameleonConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.ChameleonConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.ChameleonConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.ChameleonConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.ChameleonConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.ChameleonConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.ChameleonConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Chameleon supports up to 4096 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.ChameleonConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ChameleonConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.ChameleonConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.ChameleonConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.ChameleonConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.ChameleonConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.ChameleonConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.ChameleonConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.ChameleonConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.ChameleonConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.ChameleonConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.ChameleonConfig.model_parallel_size",description:`<strong>model_parallel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of shards used when training the model. This will be used in qk layernorm because the original Chameleon inference
doesn&#x2019;t do reduction in those layers and each rank has its own biases.`,name:"model_parallel_size"},{anchor:"transformers.ChameleonConfig.swin_norm",description:`<strong>swin_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use Swin Transformer normalization.`,name:"swin_norm"},{anchor:"transformers.ChameleonConfig.vq_config",description:`<strong>vq_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
ChameleonVQConfig instance containing the configuration for the VQ-VAE model.`,name:"vq_config"},{anchor:"transformers.ChameleonConfig.vocabulary_map",description:`<strong>vocabulary_map</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the vocabulary map from the tokenizer. Used to obtain tokens from the image inputs.`,name:"vocabulary_map"},{anchor:"transformers.ChameleonConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/configuration_chameleon.py#L100"}}),L=new Qt({props:{anchor:"transformers.ChameleonConfig.example",$$slots:{default:[Fn]},$$scope:{ctx:C}}}),xe=new J({props:{title:"ChameleonVQVAEConfig",local:"transformers.ChameleonVQVAEConfig",headingTag:"h2"}}),Ue=new W({props:{name:"class transformers.ChameleonVQVAEConfig",anchor:"transformers.ChameleonVQVAEConfig",parameters:[{name:"embed_dim",val:": int = 256"},{name:"num_embeddings",val:": int = 8192"},{name:"double_latent",val:": bool = False"},{name:"latent_channels",val:": int = 256"},{name:"resolution",val:": int = 512"},{name:"in_channels",val:": int = 3"},{name:"base_channels",val:": int = 128"},{name:"channel_multiplier",val:": typing.List[int] = [1, 1, 2, 2, 4]"},{name:"num_res_blocks",val:": int = 2"},{name:"attn_resolutions",val:": typing.List[int] = None"},{name:"dropout",val:": float = 0.0"},{name:"attn_type",val:": str = 'vanilla'"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of each embedding vector.`,name:"embed_dim"},{anchor:"transformers.ChameleonVQVAEConfig.num_embeddings",description:`<strong>num_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Number of codebook embeddings.`,name:"num_embeddings"},{anchor:"transformers.ChameleonVQVAEConfig.double_latent",description:`<strong>double_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use double z channels.`,name:"double_latent"},{anchor:"transformers.ChameleonVQVAEConfig.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels for the latent space.`,name:"latent_channels"},{anchor:"transformers.ChameleonVQVAEConfig.resolution",description:`<strong>resolution</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Resolution of the input images.`,name:"resolution"},{anchor:"transformers.ChameleonVQVAEConfig.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of input channels.`,name:"in_channels"},{anchor:"transformers.ChameleonVQVAEConfig.base_channels",description:`<strong>base_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Base channel count.`,name:"base_channels"},{anchor:"transformers.ChameleonVQVAEConfig.channel_multiplier",description:`<strong>channel_multiplier</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1, 2, 2, 4]</code>) &#x2014;
Channel multipliers for each resolution.`,name:"channel_multiplier"},{anchor:"transformers.ChameleonVQVAEConfig.num_res_blocks",description:`<strong>num_res_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of residual blocks.`,name:"num_res_blocks"},{anchor:"transformers.ChameleonVQVAEConfig.attn_resolutions",description:`<strong>attn_resolutions</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Resolutions to apply attention.`,name:"attn_resolutions"},{anchor:"transformers.ChameleonVQVAEConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout rate.`,name:"dropout"},{anchor:"transformers.ChameleonVQVAEConfig.attn_type",description:`<strong>attn_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;vanilla&quot;</code>) &#x2014;
Attention type used in VQ-GAN encoder. Can be &#x201C;vanilla&#x201D; or None.`,name:"attn_type"},{anchor:"transformers.ChameleonVQVAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/configuration_chameleon.py#L26"}}),je=new J({props:{title:"ChameleonProcessor",local:"transformers.ChameleonProcessor",headingTag:"h2"}}),We=new W({props:{name:"class transformers.ChameleonProcessor",anchor:"transformers.ChameleonProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"image_seq_length",val:": int = 1024"},{name:"image_token",val:": str = '<image>'"}],parametersDescription:[{anchor:"transformers.ChameleonProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ChameleonProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ChameleonProcessor.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.ChameleonProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
The special token used to indicate image in the text.`,name:"image_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L44"}}),Ge=new W({props:{name:"batch_decode",anchor:"transformers.ChameleonProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L151"}}),Ze=new W({props:{name:"decode",anchor:"transformers.ChameleonProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L159"}}),Ve=new J({props:{title:"ChameleonImageProcessor",local:"transformers.ChameleonImageProcessor",headingTag:"h2"}}),Be=new W({props:{name:"class transformers.ChameleonImageProcessor",anchor:"transformers.ChameleonImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = 1"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.0078"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 512}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to 1) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to {&#x201C;height&#x201D; &#x2014; 512, &#x201C;width&#x201D;: 512}):
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to 0.0078) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/image_processing_chameleon.py#L47"}}),Fe=new W({props:{name:"preprocess",anchor:"transformers.ChameleonImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.ChameleonImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ChameleonImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ChameleonImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/image_processing_chameleon.py#L171"}}),Re=new J({props:{title:"ChameleonVQVAE",local:"transformers.ChameleonVQVAE",headingTag:"h2"}}),Ne=new W({props:{name:"class transformers.ChameleonVQVAE",anchor:"transformers.ChameleonVQVAE",parameters:[{name:"config",val:": ChameleonVQVAEConfig"}],parametersDescription:[{anchor:"transformers.ChameleonVQVAE.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonVQVAEConfig">ChameleonVQVAEConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1088"}}),Pe=new W({props:{name:"_forward_unimplemented",anchor:"transformers.ChameleonVQVAE.forward",parameters:[{name:"*input",val:": typing.Any"}],source:"https://github.com/huggingface/transformers/blob/main/src/torch/nn/modules/module.py#L386"}}),S=new pt({props:{$$slots:{default:[Rn]},$$scope:{ctx:C}}}),He=new J({props:{title:"ChameleonModel",local:"transformers.ChameleonModel",headingTag:"h2"}}),qe=new W({props:{name:"class transformers.ChameleonModel",anchor:"transformers.ChameleonModel",parameters:[{name:"config",val:": ChameleonConfig"}],parametersDescription:[{anchor:"transformers.ChameleonModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig">ChameleonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.ChameleonModel.config",description:"<strong>config</strong> &#x2014; ChameleonConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1196"}}),Ee=new W({props:{name:"forward",anchor:"transformers.ChameleonModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ChameleonModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__">ChameleonImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ChameleonModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ChameleonModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Should always be a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance and the model will output the same cache instance.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1248",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new pt({props:{$$slots:{default:[Nn]},$$scope:{ctx:C}}}),D=new Qt({props:{anchor:"transformers.ChameleonModel.forward.example",$$slots:{default:[Pn]},$$scope:{ctx:C}}}),Le=new J({props:{title:"ChameleonForConditionalGeneration",local:"transformers.ChameleonForConditionalGeneration",headingTag:"h2"}}),Ye=new W({props:{name:"class transformers.ChameleonForConditionalGeneration",anchor:"transformers.ChameleonForConditionalGeneration",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig">ChameleonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1515"}}),Qe=new W({props:{name:"forward",anchor:"transformers.ChameleonForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__">ChameleonImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Should always be a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance and the model will output the same cache instance.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1549",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new pt({props:{$$slots:{default:[Hn]},$$scope:{ctx:C}}}),K=new Qt({props:{anchor:"transformers.ChameleonForConditionalGeneration.forward.example",$$slots:{default:[qn]},$$scope:{ctx:C}}}),Xe=new Vn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/chameleon.md"}}),{c(){r=l("meta"),T=n(),c=l("p"),y=n(),h(v.$$.fragment),m=n(),w=l("div"),w.innerHTML=Xt,Co=n(),h(ae.$$.fragment),Jo=n(),se=l("p"),se.innerHTML=St,ko=n(),re=l("p"),re.textContent=At,$o=n(),ie=l("p"),ie.innerHTML=Dt,zo=n(),q=l("img"),Io=n(),le=l("small"),le.innerHTML=Kt,xo=n(),de=l("p"),de.innerHTML=en,Uo=n(),h(ce.$$.fragment),jo=n(),me=l("ul"),me.innerHTML=on,Wo=n(),he=l("blockquote"),he.innerHTML=tn,Go=n(),h(pe.$$.fragment),Zo=n(),h(ge.$$.fragment),Vo=n(),fe=l("p"),fe.innerHTML=nn,Bo=n(),h(ue.$$.fragment),Fo=n(),h(_e.$$.fragment),Ro=n(),be=l("p"),be.textContent=an,No=n(),h(ye.$$.fragment),Po=n(),h(Te.$$.fragment),Ho=n(),h(ve.$$.fragment),qo=n(),we=l("p"),we.innerHTML=sn,Eo=n(),h(E.$$.fragment),Lo=n(),Me=l("p"),Me.textContent=rn,Yo=n(),h(Ce.$$.fragment),Qo=n(),h(Je.$$.fragment),Xo=n(),ke=l("p"),ke.innerHTML=ln,So=n(),h($e.$$.fragment),Ao=n(),h(ze.$$.fragment),Do=n(),x=l("div"),h(Ie.$$.fragment),gt=n(),oo=l("p"),oo.innerHTML=dn,ft=n(),to=l("p"),to.innerHTML=cn,ut=n(),h(L.$$.fragment),Oo=n(),h(xe.$$.fragment),Ko=n(),P=l("div"),h(Ue.$$.fragment),_t=n(),no=l("p"),no.innerHTML=mn,et=n(),h(je.$$.fragment),ot=n(),k=l("div"),h(We.$$.fragment),bt=n(),ao=l("p"),ao.textContent=hn,yt=n(),so=l("p"),so.innerHTML=pn,Tt=n(),Y=l("div"),h(Ge.$$.fragment),vt=n(),ro=l("p"),ro.innerHTML=gn,wt=n(),Q=l("div"),h(Ze.$$.fragment),Mt=n(),io=l("p"),io.innerHTML=fn,tt=n(),h(Ve.$$.fragment),nt=n(),B=l("div"),h(Be.$$.fragment),Ct=n(),lo=l("p"),lo.textContent=un,Jt=n(),X=l("div"),h(Fe.$$.fragment),kt=n(),co=l("p"),co.textContent=_n,at=n(),h(Re.$$.fragment),st=n(),$=l("div"),h(Ne.$$.fragment),$t=n(),mo=l("p"),mo.innerHTML=bn,zt=n(),ho=l("p"),ho.innerHTML=yn,It=n(),po=l("p"),po.innerHTML=Tn,xt=n(),G=l("div"),h(Pe.$$.fragment),Ut=n(),go=l("p"),go.textContent=vn,jt=n(),fo=l("p"),fo.textContent=wn,Wt=n(),h(S.$$.fragment),rt=n(),h(He.$$.fragment),it=n(),z=l("div"),h(qe.$$.fragment),Gt=n(),uo=l("p"),uo.innerHTML=Mn,Zt=n(),_o=l("p"),_o.innerHTML=Cn,Vt=n(),bo=l("p"),bo.innerHTML=Jn,Bt=n(),Z=l("div"),h(Ee.$$.fragment),Ft=n(),yo=l("p"),yo.innerHTML=kn,Rt=n(),h(A.$$.fragment),Nt=n(),h(D.$$.fragment),lt=n(),h(Le.$$.fragment),dt=n(),U=l("div"),h(Ye.$$.fragment),Pt=n(),To=l("p"),To.innerHTML=$n,Ht=n(),vo=l("p"),vo.innerHTML=zn,qt=n(),V=l("div"),h(Qe.$$.fragment),Et=n(),wo=l("p"),wo.innerHTML=In,Lt=n(),h(O.$$.fragment),Yt=n(),h(K.$$.fragment),ct=n(),h(Xe.$$.fragment),mt=n(),Mo=l("p"),this.h()},l(e){const o=Zn("svelte-u9bgzb",document.head);r=d(o,"META",{name:!0,content:!0}),o.forEach(t),T=a(e),c=d(e,"P",{}),I(c).forEach(t),y=a(e),p(v.$$.fragment,e),m=a(e),w=d(e,"DIV",{class:!0,"data-svelte-h":!0}),b(w)!=="svelte-b95w5j"&&(w.innerHTML=Xt),Co=a(e),p(ae.$$.fragment,e),Jo=a(e),se=d(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-1pzfvxv"&&(se.innerHTML=St),ko=a(e),re=d(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-vfdo9a"&&(re.textContent=At),$o=a(e),ie=d(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-b403ub"&&(ie.innerHTML=Dt),zo=a(e),q=d(e,"IMG",{src:!0,alt:!0,width:!0}),Io=a(e),le=d(e,"SMALL",{"data-svelte-h":!0}),b(le)!=="svelte-tuggwl"&&(le.innerHTML=Kt),xo=a(e),de=d(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-18is37e"&&(de.innerHTML=en),Uo=a(e),p(ce.$$.fragment,e),jo=a(e),me=d(e,"UL",{"data-svelte-h":!0}),b(me)!=="svelte-1xww0u5"&&(me.innerHTML=on),Wo=a(e),he=d(e,"BLOCKQUOTE",{"data-svelte-h":!0}),b(he)!=="svelte-1buypb9"&&(he.innerHTML=tn),Go=a(e),p(pe.$$.fragment,e),Zo=a(e),p(ge.$$.fragment,e),Vo=a(e),fe=d(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1mp252t"&&(fe.innerHTML=nn),Bo=a(e),p(ue.$$.fragment,e),Fo=a(e),p(_e.$$.fragment,e),Ro=a(e),be=d(e,"P",{"data-svelte-h":!0}),b(be)!=="svelte-55qtep"&&(be.textContent=an),No=a(e),p(ye.$$.fragment,e),Po=a(e),p(Te.$$.fragment,e),Ho=a(e),p(ve.$$.fragment,e),qo=a(e),we=d(e,"P",{"data-svelte-h":!0}),b(we)!=="svelte-1y3bqqy"&&(we.innerHTML=sn),Eo=a(e),p(E.$$.fragment,e),Lo=a(e),Me=d(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-gwf9h7"&&(Me.textContent=rn),Yo=a(e),p(Ce.$$.fragment,e),Qo=a(e),p(Je.$$.fragment,e),Xo=a(e),ke=d(e,"P",{"data-svelte-h":!0}),b(ke)!=="svelte-131jlth"&&(ke.innerHTML=ln),So=a(e),p($e.$$.fragment,e),Ao=a(e),p(ze.$$.fragment,e),Do=a(e),x=d(e,"DIV",{class:!0});var F=I(x);p(Ie.$$.fragment,F),gt=a(F),oo=d(F,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-1u2yjdc"&&(oo.innerHTML=dn),ft=a(F),to=d(F,"P",{"data-svelte-h":!0}),b(to)!=="svelte-o55m63"&&(to.innerHTML=cn),ut=a(F),p(L.$$.fragment,F),F.forEach(t),Oo=a(e),p(xe.$$.fragment,e),Ko=a(e),P=d(e,"DIV",{class:!0});var Se=I(P);p(Ue.$$.fragment,Se),_t=a(Se),no=d(Se,"P",{"data-svelte-h":!0}),b(no)!=="svelte-a6ih2f"&&(no.innerHTML=mn),Se.forEach(t),et=a(e),p(je.$$.fragment,e),ot=a(e),k=d(e,"DIV",{class:!0});var j=I(k);p(We.$$.fragment,j),bt=a(j),ao=d(j,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-8u0vzv"&&(ao.textContent=hn),yt=a(j),so=d(j,"P",{"data-svelte-h":!0}),b(so)!=="svelte-12nqtpn"&&(so.innerHTML=pn),Tt=a(j),Y=d(j,"DIV",{class:!0});var Ae=I(Y);p(Ge.$$.fragment,Ae),vt=a(Ae),ro=d(Ae,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-1o9eza"&&(ro.innerHTML=gn),Ae.forEach(t),wt=a(j),Q=d(j,"DIV",{class:!0});var De=I(Q);p(Ze.$$.fragment,De),Mt=a(De),io=d(De,"P",{"data-svelte-h":!0}),b(io)!=="svelte-kk16qw"&&(io.innerHTML=fn),De.forEach(t),j.forEach(t),tt=a(e),p(Ve.$$.fragment,e),nt=a(e),B=d(e,"DIV",{class:!0});var H=I(B);p(Be.$$.fragment,H),Ct=a(H),lo=d(H,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-p2ya4c"&&(lo.textContent=un),Jt=a(H),X=d(H,"DIV",{class:!0});var Oe=I(X);p(Fe.$$.fragment,Oe),kt=a(Oe),co=d(Oe,"P",{"data-svelte-h":!0}),b(co)!=="svelte-1x3yxsa"&&(co.textContent=_n),Oe.forEach(t),H.forEach(t),at=a(e),p(Re.$$.fragment,e),st=a(e),$=d(e,"DIV",{class:!0});var R=I($);p(Ne.$$.fragment,R),$t=a(R),mo=d(R,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-1yzmrhf"&&(mo.innerHTML=bn),zt=a(R),ho=d(R,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-6pahdo"&&(ho.innerHTML=yn),It=a(R),po=d(R,"P",{"data-svelte-h":!0}),b(po)!=="svelte-hswkmf"&&(po.innerHTML=Tn),xt=a(R),G=d(R,"DIV",{class:!0});var ee=I(G);p(Pe.$$.fragment,ee),Ut=a(ee),go=d(ee,"P",{"data-svelte-h":!0}),b(go)!=="svelte-1q5ym45"&&(go.textContent=vn),jt=a(ee),fo=d(ee,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-w8wo9i"&&(fo.textContent=wn),Wt=a(ee),p(S.$$.fragment,ee),ee.forEach(t),R.forEach(t),rt=a(e),p(He.$$.fragment,e),it=a(e),z=d(e,"DIV",{class:!0});var N=I(z);p(qe.$$.fragment,N),Gt=a(N),uo=d(N,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-1wqurg6"&&(uo.innerHTML=Mn),Zt=a(N),_o=d(N,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-hswkmf"&&(_o.innerHTML=Cn),Vt=a(N),bo=d(N,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-18w1z2r"&&(bo.innerHTML=Jn),Bt=a(N),Z=d(N,"DIV",{class:!0});var oe=I(Z);p(Ee.$$.fragment,oe),Ft=a(oe),yo=d(oe,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-1ytkjtr"&&(yo.innerHTML=kn),Rt=a(oe),p(A.$$.fragment,oe),Nt=a(oe),p(D.$$.fragment,oe),oe.forEach(t),N.forEach(t),lt=a(e),p(Le.$$.fragment,e),dt=a(e),U=d(e,"DIV",{class:!0});var te=I(U);p(Ye.$$.fragment,te),Pt=a(te),To=d(te,"P",{"data-svelte-h":!0}),b(To)!=="svelte-18exftd"&&(To.innerHTML=$n),Ht=a(te),vo=d(te,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-hswkmf"&&(vo.innerHTML=zn),qt=a(te),V=d(te,"DIV",{class:!0});var ne=I(V);p(Qe.$$.fragment,ne),Et=a(ne),wo=d(ne,"P",{"data-svelte-h":!0}),b(wo)!=="svelte-vjqkx9"&&(wo.innerHTML=In),Lt=a(ne),p(O.$$.fragment,ne),Yt=a(ne),p(K.$$.fragment,ne),ne.forEach(t),te.forEach(t),ct=a(e),p(Xe.$$.fragment,e),mt=a(e),Mo=d(e,"P",{}),I(Mo).forEach(t),this.h()},h(){M(r,"name","hf:doc:metadata"),M(r,"content",Ln),M(w,"class","flex flex-wrap space-x-1"),Un(q.src,Ot="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/chameleon_arch.png")||M(q,"src",Ot),M(q,"alt","drawing"),M(q,"width","600"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,r),s(e,T,o),s(e,c,o),s(e,y,o),g(v,e,o),s(e,m,o),s(e,w,o),s(e,Co,o),g(ae,e,o),s(e,Jo,o),s(e,se,o),s(e,ko,o),s(e,re,o),s(e,$o,o),s(e,ie,o),s(e,zo,o),s(e,q,o),s(e,Io,o),s(e,le,o),s(e,xo,o),s(e,de,o),s(e,Uo,o),g(ce,e,o),s(e,jo,o),s(e,me,o),s(e,Wo,o),s(e,he,o),s(e,Go,o),g(pe,e,o),s(e,Zo,o),g(ge,e,o),s(e,Vo,o),s(e,fe,o),s(e,Bo,o),g(ue,e,o),s(e,Fo,o),g(_e,e,o),s(e,Ro,o),s(e,be,o),s(e,No,o),g(ye,e,o),s(e,Po,o),g(Te,e,o),s(e,Ho,o),g(ve,e,o),s(e,qo,o),s(e,we,o),s(e,Eo,o),g(E,e,o),s(e,Lo,o),s(e,Me,o),s(e,Yo,o),g(Ce,e,o),s(e,Qo,o),g(Je,e,o),s(e,Xo,o),s(e,ke,o),s(e,So,o),g($e,e,o),s(e,Ao,o),g(ze,e,o),s(e,Do,o),s(e,x,o),g(Ie,x,null),i(x,gt),i(x,oo),i(x,ft),i(x,to),i(x,ut),g(L,x,null),s(e,Oo,o),g(xe,e,o),s(e,Ko,o),s(e,P,o),g(Ue,P,null),i(P,_t),i(P,no),s(e,et,o),g(je,e,o),s(e,ot,o),s(e,k,o),g(We,k,null),i(k,bt),i(k,ao),i(k,yt),i(k,so),i(k,Tt),i(k,Y),g(Ge,Y,null),i(Y,vt),i(Y,ro),i(k,wt),i(k,Q),g(Ze,Q,null),i(Q,Mt),i(Q,io),s(e,tt,o),g(Ve,e,o),s(e,nt,o),s(e,B,o),g(Be,B,null),i(B,Ct),i(B,lo),i(B,Jt),i(B,X),g(Fe,X,null),i(X,kt),i(X,co),s(e,at,o),g(Re,e,o),s(e,st,o),s(e,$,o),g(Ne,$,null),i($,$t),i($,mo),i($,zt),i($,ho),i($,It),i($,po),i($,xt),i($,G),g(Pe,G,null),i(G,Ut),i(G,go),i(G,jt),i(G,fo),i(G,Wt),g(S,G,null),s(e,rt,o),g(He,e,o),s(e,it,o),s(e,z,o),g(qe,z,null),i(z,Gt),i(z,uo),i(z,Zt),i(z,_o),i(z,Vt),i(z,bo),i(z,Bt),i(z,Z),g(Ee,Z,null),i(Z,Ft),i(Z,yo),i(Z,Rt),g(A,Z,null),i(Z,Nt),g(D,Z,null),s(e,lt,o),g(Le,e,o),s(e,dt,o),s(e,U,o),g(Ye,U,null),i(U,Pt),i(U,To),i(U,Ht),i(U,vo),i(U,qt),i(U,V),g(Qe,V,null),i(V,Et),i(V,wo),i(V,Lt),g(O,V,null),i(V,Yt),g(K,V,null),s(e,ct,o),g(Xe,e,o),s(e,mt,o),s(e,Mo,o),ht=!0},p(e,[o]){const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),E.$set(F);const Se={};o&2&&(Se.$$scope={dirty:o,ctx:e}),L.$set(Se);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),S.$set(j);const Ae={};o&2&&(Ae.$$scope={dirty:o,ctx:e}),A.$set(Ae);const De={};o&2&&(De.$$scope={dirty:o,ctx:e}),D.$set(De);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),O.$set(H);const Oe={};o&2&&(Oe.$$scope={dirty:o,ctx:e}),K.$set(Oe)},i(e){ht||(f(v.$$.fragment,e),f(ae.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(E.$$.fragment,e),f(Ce.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(ze.$$.fragment,e),f(Ie.$$.fragment,e),f(L.$$.fragment,e),f(xe.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ze.$$.fragment,e),f(Ve.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(Ne.$$.fragment,e),f(Pe.$$.fragment,e),f(S.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(Le.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(Xe.$$.fragment,e),ht=!0)},o(e){u(v.$$.fragment,e),u(ae.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(E.$$.fragment,e),u(Ce.$$.fragment,e),u(Je.$$.fragment,e),u($e.$$.fragment,e),u(ze.$$.fragment,e),u(Ie.$$.fragment,e),u(L.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(We.$$.fragment,e),u(Ge.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(Be.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Pe.$$.fragment,e),u(S.$$.fragment,e),u(He.$$.fragment,e),u(qe.$$.fragment,e),u(Ee.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(Le.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(Xe.$$.fragment,e),ht=!1},d(e){e&&(t(T),t(c),t(y),t(m),t(w),t(Co),t(Jo),t(se),t(ko),t(re),t($o),t(ie),t(zo),t(q),t(Io),t(le),t(xo),t(de),t(Uo),t(jo),t(me),t(Wo),t(he),t(Go),t(Zo),t(Vo),t(fe),t(Bo),t(Fo),t(Ro),t(be),t(No),t(Po),t(Ho),t(qo),t(we),t(Eo),t(Lo),t(Me),t(Yo),t(Qo),t(Xo),t(ke),t(So),t(Ao),t(Do),t(x),t(Oo),t(Ko),t(P),t(et),t(ot),t(k),t(tt),t(nt),t(B),t(at),t(st),t($),t(rt),t(it),t(z),t(lt),t(dt),t(U),t(ct),t(mt),t(Mo)),t(r),_(v,e),_(ae,e),_(ce,e),_(pe,e),_(ge,e),_(ue,e),_(_e,e),_(ye,e),_(Te,e),_(ve,e),_(E,e),_(Ce,e),_(Je,e),_($e,e),_(ze,e),_(Ie),_(L),_(xe,e),_(Ue),_(je,e),_(We),_(Ge),_(Ze),_(Ve,e),_(Be),_(Fe),_(Re,e),_(Ne),_(Pe),_(S),_(He,e),_(qe),_(Ee),_(A),_(D),_(Le,e),_(Ye),_(Qe),_(O),_(K),_(Xe,e)}}}const Ln='{"title":"Chameleon","local":"chameleon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 and SDPA to further speed-up generation","local":"use-flash-attention-2-and-sdpa-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"ChameleonConfig","local":"transformers.ChameleonConfig","sections":[],"depth":2},{"title":"ChameleonVQVAEConfig","local":"transformers.ChameleonVQVAEConfig","sections":[],"depth":2},{"title":"ChameleonProcessor","local":"transformers.ChameleonProcessor","sections":[],"depth":2},{"title":"ChameleonImageProcessor","local":"transformers.ChameleonImageProcessor","sections":[],"depth":2},{"title":"ChameleonVQVAE","local":"transformers.ChameleonVQVAE","sections":[],"depth":2},{"title":"ChameleonModel","local":"transformers.ChameleonModel","sections":[],"depth":2},{"title":"ChameleonForConditionalGeneration","local":"transformers.ChameleonForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Yn(C){return jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ea extends Wn{constructor(r){super(),Gn(this,r,Yn,En,xn,{})}}export{ea as component};
