import{s as Dt,A as Ht,o as Xt,n as Ie}from"../chunks/scheduler.01eeda35.js";import{S as St,i as Vt,g as d,s as a,r as h,A as qt,h as c,f as o,c as i,j as I,u as g,x as y,k as T,y as p,a as s,v as f,d as u,t as _,w as b}from"../chunks/index.6dd51b66.js";import{T as $t}from"../chunks/Tip.de9bae2b.js";import{D as E}from"../chunks/Docstring.cb556860.js";import{C as Mt}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Tt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as q,E as At}from"../chunks/index.58fe8f9d.js";function Yt(M){let n,w=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){n=d("p"),n.innerHTML=w},l(l){n=c(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-j665pk"&&(n.innerHTML=w)},m(l,m){s(l,n,m)},p:Ie,d(l){l&&o(n)}}}function Qt(M){let n,w="Example:",l,m,v;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdMUE5Nb2RlbCUyQyUyMEdMUE5Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR0xQTiUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR0xQTkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GLPNModel, GLPNConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GLPN vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GLPNConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,l=a(),h(m.$$.fragment)},l(r){n=c(r,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=w),l=i(r),g(m.$$.fragment,r)},m(r,$){s(r,n,$),s(r,l,$),f(m,r,$),v=!0},p:Ie,i(r){v||(u(m.$$.fragment,r),v=!0)},o(r){_(m.$$.fragment,r),v=!1},d(r){r&&(o(n),o(l)),b(m,r)}}}function Ot(M){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(l){n=c(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(l,m){s(l,n,m)},p:Ie,d(l){l&&o(n)}}}function Kt(M){let n,w="Example:",l,m,v;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">15</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,l=a(),h(m.$$.fragment)},l(r){n=c(r,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=w),l=i(r),g(m.$$.fragment,r)},m(r,$){s(r,n,$),s(r,l,$),f(m,r,$),v=!0},p:Ie,i(r){v||(u(m.$$.fragment,r),v=!0)},o(r){_(m.$$.fragment,r),v=!1},d(r){r&&(o(n),o(l)),b(m,r)}}}function eo(M){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(l){n=c(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(l,m){s(l,n,m)},p:Ie,d(l){l&&o(n)}}}function to(M){let n,w="Examples:",l,m,v;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,l=a(),h(m.$$.fragment)},l(r){n=c(r,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(r),g(m.$$.fragment,r)},m(r,$){s(r,n,$),s(r,l,$),f(m,r,$),v=!0},p:Ie,i(r){v||(u(m.$$.fragment,r),v=!0)},o(r){_(m.$$.fragment,r),v=!1},d(r){r&&(o(n),o(l)),b(m,r)}}}function oo(M){let n,w,l,m,v,r,$,Pt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Je,F,ze,A,Ee,Y,Nt=`The GLPN model was proposed in <a href="https://arxiv.org/abs/2201.07436" rel="nofollow">Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth</a>  by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
GLPN combines <a href="segformer">SegFormer</a>’s hierarchical mix-Transformer with a lightweight decoder for monocular depth estimation. The proposed decoder shows better performance than the previously proposed decoders, with considerably
less computational complexity.`,Fe,Q,Gt="The abstract from the paper is the following:",Re,O,Lt="<em>Depth estimation from a single image is an important task that can be applied to various fields in computer vision, and has grown rapidly with the development of convolutional neural networks. In this paper, we propose a novel structure and training strategy for monocular depth estimation to further improve the prediction accuracy of the network. We deploy a hierarchical transformer encoder to capture and convey the global context, and design a lightweight yet powerful decoder to generate an estimated depth map while considering local connectivity. By constructing connected paths between multi-scale local features and the global decoding stream with our proposed selective feature fusion module, the network can integrate both representations and recover fine details. In addition, the proposed decoder shows better performance than the previously proposed decoders, with considerably less computational complexity. Furthermore, we improve the depth-specific augmentation method by utilizing an important observation in depth estimation to enhance the model. Our network achieves state-of-the-art performance over the challenging depth dataset NYU Depth V2. Extensive experiments have been conducted to validate and show the effectiveness of the proposed approach. Finally, our model shows better generalisation ability and robustness than other comparative models.</em>",ke,R,xt,Ze,K,Ct='Summary of the approach. Taken from the <a href="https://arxiv.org/abs/2201.07436" target="_blank">original paper</a>.',We,ee,jt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/vinvino02/GLPDepth" rel="nofollow">here</a>.',Be,te,De,oe,It="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with GLPN.",He,ne,Ut='<li>Demo notebooks for <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/GLPN" rel="nofollow">here</a>.</li> <li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li>',Xe,se,Se,P,re,st,$e,Jt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>. It is used to instantiate an GLPN
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the GLPN
<a href="https://huggingface.co/vinvino02/glpn-kitti" rel="nofollow">vinvino02/glpn-kitti</a> architecture.`,rt,Te,zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,at,k,Ve,ae,qe,U,ie,it,Z,le,lt,Me,Et="Preprocess an image or a batch of images.",Ae,de,Ye,L,ce,dt,Pe,Ft="Constructs a GLPN image processor.",ct,W,me,mt,Ne,Rt="Preprocess the given images.",Qe,pe,Oe,x,he,pt,Ge,kt=`The bare GLPN encoder (Mix-Transformer) outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ht,N,ge,gt,Le,Zt='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> forward method, overrides the <code>__call__</code> special method.',ft,B,ut,D,Ke,fe,et,C,ue,_t,xe,Wt=`GLPN Model transformer with a lightweight depth estimation head on top e.g. for KITTI, NYUv2.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,bt,G,_e,yt,Ce,Bt='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',wt,H,vt,X,tt,be,ot,Ue,nt;return v=new q({props:{title:"GLPN",local:"glpn",headingTag:"h1"}}),F=new $t({props:{$$slots:{default:[Yt]},$$scope:{ctx:M}}}),A=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),te=new q({props:{title:"Resources",local:"resources",headingTag:"h2"}}),se=new q({props:{title:"GLPNConfig",local:"transformers.GLPNConfig",headingTag:"h2"}}),re=new E({props:{name:"class transformers.GLPNConfig",anchor:"transformers.GLPNConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"num_encoder_blocks",val:" = 4"},{name:"depths",val:" = [2, 2, 2, 2]"},{name:"sr_ratios",val:" = [8, 4, 2, 1]"},{name:"hidden_sizes",val:" = [32, 64, 160, 256]"},{name:"patch_sizes",val:" = [7, 3, 3, 3]"},{name:"strides",val:" = [4, 2, 2, 2]"},{name:"num_attention_heads",val:" = [1, 2, 5, 8]"},{name:"mlp_ratios",val:" = [4, 4, 4, 4]"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"drop_path_rate",val:" = 0.1"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = 64"},{name:"max_depth",val:" = 10"},{name:"head_in_index",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.GLPNConfig.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of encoder blocks (i.e. stages in the Mix Transformer encoder).`,name:"num_encoder_blocks"},{anchor:"transformers.GLPNConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2, 2]</code>) &#x2014;
The number of layers in each encoder block.`,name:"depths"},{anchor:"transformers.GLPNConfig.sr_ratios",description:`<strong>sr_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 4, 2, 1]</code>) &#x2014;
Sequence reduction ratios in each encoder block.`,name:"sr_ratios"},{anchor:"transformers.GLPNConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 160, 256]</code>) &#x2014;
Dimension of each of the encoder blocks.`,name:"hidden_sizes"},{anchor:"transformers.GLPNConfig.patch_sizes",description:`<strong>patch_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[7, 3, 3, 3]</code>) &#x2014;
Patch size before each encoder block.`,name:"patch_sizes"},{anchor:"transformers.GLPNConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 2, 2]</code>) &#x2014;
Stride before each encoder block.`,name:"strides"},{anchor:"transformers.GLPNConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 5, 8]</code>) &#x2014;
Number of attention heads for each attention layer in each block of the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GLPNConfig.mlp_ratios",description:`<strong>mlp_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 4, 4, 4]</code>) &#x2014;
Ratio of the size of the hidden layer compared to the size of the input layer of the Mix FFNs in the
encoder blocks.`,name:"mlp_ratios"},{anchor:"transformers.GLPNConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.GLPNConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.GLPNConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.GLPNConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GLPNConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for stochastic depth, used in the blocks of the Transformer encoder.`,name:"drop_path_rate"},{anchor:"transformers.GLPNConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GLPNConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The dimension of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.GLPNConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum depth of the decoder.`,name:"max_depth"},{anchor:"transformers.GLPNConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the head.`,name:"head_in_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/configuration_glpn.py#L24"}}),k=new Tt({props:{anchor:"transformers.GLPNConfig.example",$$slots:{default:[Qt]},$$scope:{ctx:M}}}),ae=new q({props:{title:"GLPNFeatureExtractor",local:"transformers.GLPNFeatureExtractor",headingTag:"h2"}}),ie=new E({props:{name:"class transformers.GLPNFeatureExtractor",anchor:"transformers.GLPNFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/feature_extraction_glpn.py#L26"}}),le=new E({props:{name:"__call__",anchor:"transformers.GLPNFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L40"}}),de=new q({props:{title:"GLPNImageProcessor",local:"transformers.GLPNImageProcessor",headingTag:"h2"}}),ce=new E({props:{name:"class transformers.GLPNImageProcessor",anchor:"transformers.GLPNImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:" = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions, rounding them down to the closest multiple of
<code>size_divisor</code>. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the closest
multiple of <code>size_divisor</code>. Can be overridden by <code>size_divisor</code> in <code>preprocess</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.). Can be
overridden by <code>do_rescale</code> in <code>preprocess</code>.`,name:"do_rescale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L50"}}),me=new E({props:{name:"preprocess",anchor:"transformers.GLPNImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), transformers.utils.generic.TensorType, typing.List[ForwardRef('PIL.Image.Image')], typing.List[transformers.utils.generic.TensorType]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>TensorType</code> or <code>List[np.ndarray]</code> or <code>List[TensorType]</code>) &#x2014;
Images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the input such that the (height, width) dimensions are a multiple of <code>size_divisor</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.preprocess.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisor</code>) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the
closest multiple of <code>size_divisor</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PIL.Image</code> resampling filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.GLPNImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GLPNImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GLPNImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L134"}}),pe=new q({props:{title:"GLPNModel",local:"transformers.GLPNModel",headingTag:"h2"}}),he=new E({props:{name:"class transformers.GLPNModel",anchor:"transformers.GLPNModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L474"}}),ge=new E({props:{name:"forward",anchor:"transformers.GLPNModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new $t({props:{$$slots:{default:[Ot]},$$scope:{ctx:M}}}),D=new Tt({props:{anchor:"transformers.GLPNModel.forward.example",$$slots:{default:[Kt]},$$scope:{ctx:M}}}),fe=new q({props:{title:"GLPNForDepthEstimation",local:"transformers.GLPNForDepthEstimation",headingTag:"h2"}}),ue=new E({props:{name:"class transformers.GLPNForDepthEstimation",anchor:"transformers.GLPNForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L675"}}),_e=new E({props:{name:"forward",anchor:"transformers.GLPNForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GLPNForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L690",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new $t({props:{$$slots:{default:[eo]},$$scope:{ctx:M}}}),X=new Tt({props:{anchor:"transformers.GLPNForDepthEstimation.forward.example",$$slots:{default:[to]},$$scope:{ctx:M}}}),be=new At({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/glpn.md"}}),{c(){n=d("meta"),w=a(),l=d("p"),m=a(),h(v.$$.fragment),r=a(),$=d("div"),$.innerHTML=Pt,Je=a(),h(F.$$.fragment),ze=a(),h(A.$$.fragment),Ee=a(),Y=d("p"),Y.innerHTML=Nt,Fe=a(),Q=d("p"),Q.textContent=Gt,Re=a(),O=d("p"),O.innerHTML=Lt,ke=a(),R=d("img"),Ze=a(),K=d("small"),K.innerHTML=Ct,We=a(),ee=d("p"),ee.innerHTML=jt,Be=a(),h(te.$$.fragment),De=a(),oe=d("p"),oe.textContent=It,He=a(),ne=d("ul"),ne.innerHTML=Ut,Xe=a(),h(se.$$.fragment),Se=a(),P=d("div"),h(re.$$.fragment),st=a(),$e=d("p"),$e.innerHTML=Jt,rt=a(),Te=d("p"),Te.innerHTML=zt,at=a(),h(k.$$.fragment),Ve=a(),h(ae.$$.fragment),qe=a(),U=d("div"),h(ie.$$.fragment),it=a(),Z=d("div"),h(le.$$.fragment),lt=a(),Me=d("p"),Me.textContent=Et,Ae=a(),h(de.$$.fragment),Ye=a(),L=d("div"),h(ce.$$.fragment),dt=a(),Pe=d("p"),Pe.textContent=Ft,ct=a(),W=d("div"),h(me.$$.fragment),mt=a(),Ne=d("p"),Ne.textContent=Rt,Qe=a(),h(pe.$$.fragment),Oe=a(),x=d("div"),h(he.$$.fragment),pt=a(),Ge=d("p"),Ge.innerHTML=kt,ht=a(),N=d("div"),h(ge.$$.fragment),gt=a(),Le=d("p"),Le.innerHTML=Zt,ft=a(),h(B.$$.fragment),ut=a(),h(D.$$.fragment),Ke=a(),h(fe.$$.fragment),et=a(),C=d("div"),h(ue.$$.fragment),_t=a(),xe=d("p"),xe.innerHTML=Wt,bt=a(),G=d("div"),h(_e.$$.fragment),yt=a(),Ce=d("p"),Ce.innerHTML=Bt,wt=a(),h(H.$$.fragment),vt=a(),h(X.$$.fragment),tt=a(),h(be.$$.fragment),ot=a(),Ue=d("p"),this.h()},l(e){const t=qt("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),w=i(e),l=c(e,"P",{}),I(l).forEach(o),m=i(e),g(v.$$.fragment,e),r=i(e),$=c(e,"DIV",{class:!0,"data-svelte-h":!0}),y($)!=="svelte-13t8s2t"&&($.innerHTML=Pt),Je=i(e),g(F.$$.fragment,e),ze=i(e),g(A.$$.fragment,e),Ee=i(e),Y=c(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1rdmycr"&&(Y.innerHTML=Nt),Fe=i(e),Q=c(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-vfdo9a"&&(Q.textContent=Gt),Re=i(e),O=c(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-l8ay4x"&&(O.innerHTML=Lt),ke=i(e),R=c(e,"IMG",{src:!0,alt:!0,width:!0}),Ze=i(e),K=c(e,"SMALL",{"data-svelte-h":!0}),y(K)!=="svelte-bacs7t"&&(K.innerHTML=Ct),We=i(e),ee=c(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1grdklu"&&(ee.innerHTML=jt),Be=i(e),g(te.$$.fragment,e),De=i(e),oe=c(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-fq64ti"&&(oe.textContent=It),He=i(e),ne=c(e,"UL",{"data-svelte-h":!0}),y(ne)!=="svelte-pb93f4"&&(ne.innerHTML=Ut),Xe=i(e),g(se.$$.fragment,e),Se=i(e),P=c(e,"DIV",{class:!0});var j=I(P);g(re.$$.fragment,j),st=i(j),$e=c(j,"P",{"data-svelte-h":!0}),y($e)!=="svelte-qzaip8"&&($e.innerHTML=Jt),rt=i(j),Te=c(j,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-o55m63"&&(Te.innerHTML=zt),at=i(j),g(k.$$.fragment,j),j.forEach(o),Ve=i(e),g(ae.$$.fragment,e),qe=i(e),U=c(e,"DIV",{class:!0});var ye=I(U);g(ie.$$.fragment,ye),it=i(ye),Z=c(ye,"DIV",{class:!0});var we=I(Z);g(le.$$.fragment,we),lt=i(we),Me=c(we,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-khengj"&&(Me.textContent=Et),we.forEach(o),ye.forEach(o),Ae=i(e),g(de.$$.fragment,e),Ye=i(e),L=c(e,"DIV",{class:!0});var J=I(L);g(ce.$$.fragment,J),dt=i(J),Pe=c(J,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-1e6g6g5"&&(Pe.textContent=Ft),ct=i(J),W=c(J,"DIV",{class:!0});var ve=I(W);g(me.$$.fragment,ve),mt=i(ve),Ne=c(ve,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-tvrlms"&&(Ne.textContent=Rt),ve.forEach(o),J.forEach(o),Qe=i(e),g(pe.$$.fragment,e),Oe=i(e),x=c(e,"DIV",{class:!0});var z=I(x);g(he.$$.fragment,z),pt=i(z),Ge=c(z,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-dvd88g"&&(Ge.innerHTML=kt),ht=i(z),N=c(z,"DIV",{class:!0});var S=I(N);g(ge.$$.fragment,S),gt=i(S),Le=c(S,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-1brtns"&&(Le.innerHTML=Zt),ft=i(S),g(B.$$.fragment,S),ut=i(S),g(D.$$.fragment,S),S.forEach(o),z.forEach(o),Ke=i(e),g(fe.$$.fragment,e),et=i(e),C=c(e,"DIV",{class:!0});var je=I(C);g(ue.$$.fragment,je),_t=i(je),xe=c(je,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-1ec4khr"&&(xe.innerHTML=Wt),bt=i(je),G=c(je,"DIV",{class:!0});var V=I(G);g(_e.$$.fragment,V),yt=i(V),Ce=c(V,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1vek7n8"&&(Ce.innerHTML=Bt),wt=i(V),g(H.$$.fragment,V),vt=i(V),g(X.$$.fragment,V),V.forEach(o),je.forEach(o),tt=i(e),g(be.$$.fragment,e),ot=i(e),Ue=c(e,"P",{}),I(Ue).forEach(o),this.h()},h(){T(n,"name","hf:doc:metadata"),T(n,"content",no),T($,"class","flex flex-wrap space-x-1"),Ht(R.src,xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/glpn_architecture.jpg")||T(R,"src",xt),T(R,"alt","drawing"),T(R,"width","600"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,n),s(e,w,t),s(e,l,t),s(e,m,t),f(v,e,t),s(e,r,t),s(e,$,t),s(e,Je,t),f(F,e,t),s(e,ze,t),f(A,e,t),s(e,Ee,t),s(e,Y,t),s(e,Fe,t),s(e,Q,t),s(e,Re,t),s(e,O,t),s(e,ke,t),s(e,R,t),s(e,Ze,t),s(e,K,t),s(e,We,t),s(e,ee,t),s(e,Be,t),f(te,e,t),s(e,De,t),s(e,oe,t),s(e,He,t),s(e,ne,t),s(e,Xe,t),f(se,e,t),s(e,Se,t),s(e,P,t),f(re,P,null),p(P,st),p(P,$e),p(P,rt),p(P,Te),p(P,at),f(k,P,null),s(e,Ve,t),f(ae,e,t),s(e,qe,t),s(e,U,t),f(ie,U,null),p(U,it),p(U,Z),f(le,Z,null),p(Z,lt),p(Z,Me),s(e,Ae,t),f(de,e,t),s(e,Ye,t),s(e,L,t),f(ce,L,null),p(L,dt),p(L,Pe),p(L,ct),p(L,W),f(me,W,null),p(W,mt),p(W,Ne),s(e,Qe,t),f(pe,e,t),s(e,Oe,t),s(e,x,t),f(he,x,null),p(x,pt),p(x,Ge),p(x,ht),p(x,N),f(ge,N,null),p(N,gt),p(N,Le),p(N,ft),f(B,N,null),p(N,ut),f(D,N,null),s(e,Ke,t),f(fe,e,t),s(e,et,t),s(e,C,t),f(ue,C,null),p(C,_t),p(C,xe),p(C,bt),p(C,G),f(_e,G,null),p(G,yt),p(G,Ce),p(G,wt),f(H,G,null),p(G,vt),f(X,G,null),s(e,tt,t),f(be,e,t),s(e,ot,t),s(e,Ue,t),nt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),F.$set(j);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),k.$set(ye);const we={};t&2&&(we.$$scope={dirty:t,ctx:e}),B.$set(we);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),D.$set(J);const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),H.$set(ve);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),X.$set(z)},i(e){nt||(u(v.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(k.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(B.$$.fragment,e),u(D.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(be.$$.fragment,e),nt=!0)},o(e){_(v.$$.fragment,e),_(F.$$.fragment,e),_(A.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(k.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(B.$$.fragment,e),_(D.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(H.$$.fragment,e),_(X.$$.fragment,e),_(be.$$.fragment,e),nt=!1},d(e){e&&(o(w),o(l),o(m),o(r),o($),o(Je),o(ze),o(Ee),o(Y),o(Fe),o(Q),o(Re),o(O),o(ke),o(R),o(Ze),o(K),o(We),o(ee),o(Be),o(De),o(oe),o(He),o(ne),o(Xe),o(Se),o(P),o(Ve),o(qe),o(U),o(Ae),o(Ye),o(L),o(Qe),o(Oe),o(x),o(Ke),o(et),o(C),o(tt),o(ot),o(Ue)),o(n),b(v,e),b(F,e),b(A,e),b(te,e),b(se,e),b(re),b(k),b(ae,e),b(ie),b(le),b(de,e),b(ce),b(me),b(pe,e),b(he),b(ge),b(B),b(D),b(fe,e),b(ue),b(_e),b(H),b(X),b(be,e)}}}const no='{"title":"GLPN","local":"glpn","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GLPNConfig","local":"transformers.GLPNConfig","sections":[],"depth":2},{"title":"GLPNFeatureExtractor","local":"transformers.GLPNFeatureExtractor","sections":[],"depth":2},{"title":"GLPNImageProcessor","local":"transformers.GLPNImageProcessor","sections":[],"depth":2},{"title":"GLPNModel","local":"transformers.GLPNModel","sections":[],"depth":2},{"title":"GLPNForDepthEstimation","local":"transformers.GLPNForDepthEstimation","sections":[],"depth":2}],"depth":1}';function so(M){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ho extends St{constructor(n){super(),Vt(this,n,so,oo,Dt,{})}}export{ho as component};
