import{s as us,o as fs,n as X}from"../chunks/scheduler.01eeda35.js";import{S as gs,i as _s,g as l,s,r as u,A as bs,h as d,f as o,c as a,j as W,u as f,x as c,k as z,l as ps,y as p,a as n,v as g,d as _,t as b,w as M}from"../chunks/index.6dd51b66.js";import{T as Jt}from"../chunks/Tip.de9bae2b.js";import{D as N}from"../chunks/Docstring.cb556860.js";import{C as zt}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Gt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as V,E as Ms}from"../chunks/index.58fe8f9d.js";function ys(w){let i,v='It is designed for intermediate use. We strongly recommend using the original <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">implementation</a> to infer the model in real-time streaming.';return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1l3jd0r"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function vs(w){let i,v="The original model is synchronized text with audio by padding the text in between each token enunciation.",m,h,y="To follow the example of the following image, <code>&quot;Hello, I&#39;m Moshi&quot;</code> could be transformed to <code>&quot;Hello,&lt;pad&gt;&lt;unk&gt;I&#39;m Moshi&quot;</code>.";return{c(){i=l("p"),i.textContent=v,m=s(),h=l("p"),h.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1se1hi6"&&(i.textContent=v),m=a(r),h=d(r,"P",{"data-svelte-h":!0}),c(h)!=="svelte-nhkay6"&&(h.innerHTML=y)},m(r,T){n(r,i,T),n(r,m,T),n(r,h,T)},p:X,d(r){r&&(o(i),o(m),o(h))}}}function Ts(w){let i,v="Example:",m,h,y;return h=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaUNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb3NoaUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBrbWhmJTJGaGYtbW9zaGlrbyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBbW9zaGlfY29uZmlnJTIwJTNEJTIwTW9zaGlDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyJTJDJTIwY29uZmlnJTNEbW9zaGlfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiConfig,
<span class="hljs-meta">... </span>    MoshiForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiForConditionalGeneration (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_config = MoshiConfig.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>, config=moshi_config)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function ws(w){let i,v="Example:",m,h,y;return h=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaURlcHRoQ29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwTW9zaGlEZXB0aERlY29kZXIlMkMlMEEpJTBBJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME1vc2hpRGVwdGhDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNb3NoaURlcHRoRGVjb2RlciUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwa21oZiUyRmhmLW1vc2hpa28lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1vc2hpRGVwdGhEZWNvZGVyKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiDepthConfig,
<span class="hljs-meta">... </span>    MoshiDepthDecoder,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiDepthConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiDepthDecoder (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiDepthDecoder(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function ks(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function xs(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function Cs(w){let i,v="Example:",m,h,y;return h=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb3NoaUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwZmF2b3JpdGUlMjBjb25kaW1lbnQlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MoshiForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForCausalLM.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function $s(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function zs(w){let i,v="Examples:",m,h,y;return h=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEFpbnB1dHMlMjAlM0QlMjBtb3NoaS5nZXRfdW5jb25kaXRpb25hbF9pbnB1dHMoKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTJDJTIwc2VxX2xlbiUyQyUyMHRleHRfdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = moshi.get_unconditional_inputs()

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, ).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz, seq_len, text_vocab_size)</span>
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">32000</span>])`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-kvfsh7"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function js(w){let i,v="Example:",m,h,y;return h=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIya21oZiUyRmhmLW1vc2hpa28tcHl0b3JjaC1iZjE2JTIyKSUwQSUwQSUyMyUyMGdldCUyMHRoZSUyMHVuY29uZGl0aW9uYWwlMjAob3IlMjAnbnVsbCcpJTIwaW5wdXRzJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko-pytorch-bf16&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Js(w){let i,v,m,h,y,r,T,pn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ft,ie,Wt,re,un='The Moshi model was proposed in <a href="https://kyutai.org/Moshi.pdf" rel="nofollow">Moshi: a speech-text foundation model for real-time dialogue</a> by Alexandre Défossez, Laurent Mazaré, Manu Orsini, Amélie Royer, Patrick Pérez, Hervé Jégou, Edouard Grave and Neil Zeghidour.',Zt,le,fn="Moshi is a speech-text foundation model that casts spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. Moshi also predicts time-aligned text tokens as a prefix to audio tokens. This “Inner Monologue” method significantly improves the linguistic quality of generated speech and provides streaming speech recognition and text-to-speech. As a result, Moshi is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice.",It,D,gn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_architecture.png"/>',Lt,de,_n="The abstract from the paper is the following:",Ht,ce,bn="<em>We introduce Moshi, a speech-text foundation model and full-duplex spoken dialogue framework. Current systems for spoken dialogue rely on pipelines of independent components, namely voice activity detection, speech recognition, textual dialogue and text-to-speech. Such frameworks cannot emulate the experience of real conversations. First, their complexity induces a latency of several seconds between interactions. Second, text being the intermediate modality for dialogue, non-linguistic information that modifies meaning— such as emotion or non-speech sounds— is lost in the interaction. Finally, they rely on a segmentation into speaker turns, which does not take into account overlapping speech, interruptions and interjections. Moshi solves these independent issues altogether by casting spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. We moreover extend the hierarchical semantic-to-acoustic token generation of previous work to first predict time-aligned text tokens as a prefix to audio tokens. Not only this “Inner Monologue” method significantly improves the linguistic quality of generated speech, but we also illustrate how it can provide streaming speech recognition and text-to-speech. Our resulting model is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice, and is available at github.com/kyutai-labs/moshi.</em>",Ut,he,Mn="Moshi deals with 3 streams of information:",Bt,me,yn="<li>The user’s audio</li> <li>Moshi’s audio</li> <li>Moshi’s textual output</li>",Nt,pe,vn=`Similarly to <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>, audio is represented with audio codebooks, which can be interpreted like tokens. The main difference between text tokens and audio codebooks is that audio codebooks introduce an additional dimension of information.
Text tokens are typically of dim <code>(batch_size, sequence_length)</code> but audio tokens are of dim <code>(batch_size, num_codebooks, sequence_length)</code>.`,qt,ue,Tn="Moshi’s made of 3 components:",Rt,fe,wn="<strong>1. The main decoder (Helium in the paper)</strong>",Vt,ge,kn='It corresponds to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a>. It is strictly a classic text LLM, that uses an architecture similar to <code>~GemmaForCausalLM</code>. In other words, it takes text tokens, embeds them, pass them through the decoder and a language head, to get text logits.',Xt,_e,xn="<strong>2. The depth decoder</strong>",Pt,be,Cn="On its own, it’s also a classic LLM, but this time, instead of generating over the time dimension, it generates over the codebook dimension.",Dt,Me,$n="It also means that its context length is <code>num_codebooks</code>, thus it can’t generate more than <code>num_codebooks</code>.",Et,ye,zn="Note that each timestamp - i.e each codebook - gets its own set of Linear Layers and Embeddings.",Yt,ve,jn='<strong>3. <a href="/docs/transformers/main/en/model_doc/mimi#transformers.MimiModel">MimiModel</a></strong>',St,Te,Jn='It’s the audio encoder from Kyutai, that has recently been integrated to transformers, which is used to “tokenize” audio. It has the same use that <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">~EncodecModel</a> has in <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>.',At,we,Ot,ke,Gn="The original checkpoints can be converted using the conversion script <code>src/transformers/models/moshi/convert_moshi_transformers.py</code>",Qt,xe,Kt,Ce,Fn="This implementation has two main aims:",eo,$e,Wn="<li>quickly test model generation by simplifying the original API</li> <li>simplify training. A training guide will come soon, but user contributions are welcomed!</li>",to,E,oo,ze,Zn="<strong>1. Model generation</strong>",no,je,In="Moshi is a streaming auto-regressive model with two streams of audio. To put it differently, one audio stream corresponds to what the model said/will say and the other audio stream corresponds to what the user said/will say.",so,Je,Ln='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> thus needs 3 inputs:',ao,Ge,Hn="<li><code>input_ids</code> - corresponding to the text token history</li> <li><code>moshi_input_values</code> or <code>moshi_audio_codes</code>- corresponding to the model audio history</li> <li><code>user_input_values</code> or <code>user_audio_codes</code> - corresponding to the user audio history</li>",io,Fe,Un="These three inputs must be synchronized. Meaning that their lengths must correspond to the same number of tokens.",ro,We,Bn="You can dynamically use the 3 inputs depending on what you want to test:",lo,Ze,Nn="<li>Simply check the model response to an user prompt - in that case, <code>input_ids</code> can be filled with pad tokens and <code>user_input_values</code> can be a zero tensor of the same shape than the user prompt.</li> <li>Test more complex behaviour - in that case, you must be careful about how the input tokens are synchronized with the audios.</li>",co,Y,ho,S,qn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_text_sync.png"/>',mo,Ie,Rn='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> then auto-regressively feeds to itself its own audio stream, but since it doesn’t have access to the user input stream while using <code>transformers</code>, it will thus <strong>assume that the user is producing blank audio</strong>.',po,Le,uo,He,Vn="<strong>2. Model training</strong>",fo,Ue,Xn="Most of the work has to be done during data creation/pre-processing, because of the need to align/synchronize streams.",go,Be,Pn='Once it’s done, you can simply forward <code>text_labels</code> and <code>audio_labels</code> to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.forward">MoshiForConditionalGeneration.forward()</a>, alongside the usual inputs, to get the model loss.',_o,Ne,Dn="A training guide will come soon, but user contributions are welcomed!",bo,qe,Mo,Re,En="<li><p>The input streams are embedded and combined into <code>inputs_embeds</code>.</p></li> <li><p><code>inputs_embeds</code> is passed through the main decoder, which processes it like a normal LLM would.</p></li> <li><p>The main decoder outputs <code>text logits</code> but also its <code>last hidden state</code> which is called <code>temporal context</code> in the paper.</p></li> <li><p>The depth decoder switches the dimension on which we forward / generate (codebooks instead of time). It uses the token generated from <code>text logits</code>  and the <code>temporal context</code> to auto-regressively generate audio codebooks.</p></li>",yo,Ve,Yn='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">Yoach Lacombe (ylacombe)</a>.',vo,Xe,Sn='The original code can be found <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">here</a>.',To,Pe,wo,x,De,Io,ct,An=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a>. It is used to instantiate a
Moshi model according to the specified arguments, defining the audio encoder, Moshi depth decoder and Moshi decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Moshiko model,
e.g. <a href="https://huggingface.co/kmhf/hf-moshiko" rel="nofollow">kmhf/hf-moshiko</a>`,Lo,ht,On=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ho,A,Uo,O,Ee,Bo,mt,Qn='Instantiate a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a> (or a derived class) from an audio encoder configuration.',ko,Ye,xo,j,Se,No,pt,Kn=`This is the configuration class to store the configuration of a <code>MoshiDepthDecoder</code>. It is used to instantiate a
Moshi depth decoder model according to the specified arguments, defining the Moshi depth decoder config.`,qo,ut,es=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ro,Q,Co,Ae,$o,C,Oe,Vo,ft,ts=`The bare Moshi Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xo,gt,os=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Po,_t,ns="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>MoshiDecoderLayer</code>",Do,q,Qe,Eo,bt,ss='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a> forward method, overrides the <code>__call__</code> special method.',Yo,K,zo,Ke,jo,J,et,So,Mt,as=`The Moshi decoder model with a text language modelling head on top. Only usable for text.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ao,yt,is=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oo,Z,tt,Qo,vt,rs='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Ko,ee,en,te,Jo,ot,Go,k,nt,tn,Tt,ls=`The original Moshi model with an audio encoder, a Moshi depth decoder and a Moshi decoder, for speech-to-speech.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,on,wt,ds=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,nn,I,st,sn,kt,cs='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration">MoshiForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',an,oe,rn,ne,ln,se,at,dn,xt,hs="Generates sequences of text token ids and audio tokens ids.",cn,R,it,hn,Ct,ms=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,mn,ae,Fo,rt,Wo,jt,Zo;return y=new V({props:{title:"Moshi",local:"moshi",headingTag:"h1"}}),ie=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new V({props:{title:"Tips:",local:"tips",headingTag:"h2"}}),xe=new V({props:{title:"How to use the model:",local:"how-to-use-the-model",headingTag:"h3"}}),E=new Jt({props:{$$slots:{default:[ys]},$$scope:{ctx:w}}}),Y=new Jt({props:{$$slots:{default:[vs]},$$scope:{ctx:w}}}),Le=new zt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch, math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration, AutoFeatureExtractor, AutoTokenizer


<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;kyutai/moshiko-pytorch-bf16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;kyutai/moshiko-pytorch-bf16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dtype = torch.bfloat16

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare user input audio </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = librispeech_dummy.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=feature_extractor.sampling_rate))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_sample = librispeech_dummy[-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>user_input_values = feature_extractor(raw_audio=audio_sample, sampling_rate=feature_extractor.sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=device, dtype=dtype)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input values - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_input_values = torch.zeros_like(user_input_values.input_values)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input ids - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_tokens = math.ceil(moshi_input_values.shape[-<span class="hljs-number">1</span>] * waveform_to_token_ratio)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((<span class="hljs-number">1</span>, num_tokens), device=device, dtype=torch.int64) * tokenizer.encode(<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate 25 new tokens (around 2s of audio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(input_ids=input_ids, user_input_values=user_input_values.input_values, moshi_input_values=moshi_input_values, max_new_tokens=<span class="hljs-number">25</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text_tokens = output.sequences
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_waveforms = output.audio_sequences`,wrap:!1}}),qe=new V({props:{title:"How does the model forward the inputs / generate:",local:"how-does-the-model-forward-the-inputs--generate",headingTag:"h3"}}),Pe=new V({props:{title:"MoshiConfig",local:"transformers.MoshiConfig",headingTag:"h2"}}),De=new N({props:{name:"class transformers.MoshiConfig",anchor:"transformers.MoshiConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = None"},{name:"max_position_embeddings",val:" = 3000"},{name:"rope_theta",val:" = 10000.0"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 3000"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 22528"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the layers and the pooler layer of the main decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the main decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoshiConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
Sliding window attention window size. If not specified, will default to <code>3000</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the main decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>depth__config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the depth decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L149"}}),A=new Gt({props:{anchor:"transformers.MoshiConfig.example",$$slots:{default:[Ts]},$$scope:{ctx:w}}}),Ee=new N({props:{name:"from_audio_encoder_config",anchor:"transformers.MoshiConfig.from_audio_encoder_config",parameters:[{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a></p>
`}}),Ye=new V({props:{title:"MoshiDepthConfig",local:"transformers.MoshiDepthConfig",headingTag:"h2"}}),Se=new N({props:{name:"class transformers.MoshiDepthConfig",anchor:"transformers.MoshiDepthConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 1024"},{name:"input_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 6"},{name:"num_attention_heads",val:" = 16"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 9"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 8"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 5632"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiDepthConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDepthDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDepthDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiDepthConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer of the depth decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiDepthConfig.input_size",description:`<strong>input_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the input hidden states. Used to connect the main decoder to the depth decoder.`,name:"input_size"},{anchor:"transformers.MoshiDepthConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of depth decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiDepthConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the depth decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiDepthConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiDepthConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiDepthConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 9) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiDepthConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the depth decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiDepthConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiDepthConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiDepthConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiDepthConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Sliding window attention window size. If not specified, will default to <code>8</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiDepthConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiDepthConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the depth decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiDepthConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiDepthConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiDepthConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiDepthConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L25"}}),Q=new Gt({props:{anchor:"transformers.MoshiDepthConfig.example",$$slots:{default:[ws]},$$scope:{ctx:w}}}),Ae=new V({props:{title:"MoshiModel",local:"transformers.MoshiModel",headingTag:"h2"}}),Oe=new N({props:{name:"class transformers.MoshiModel",anchor:"transformers.MoshiModel",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MoshiModel.config",description:"<strong>config</strong> &#x2014; MoshiConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1419"}}),Qe=new N({props:{name:"forward",anchor:"transformers.MoshiModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.List[torch.FloatTensor], transformers.cache_utils.Cache, NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoshiModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MoshiModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1455"}}),K=new Jt({props:{$$slots:{default:[ks]},$$scope:{ctx:w}}}),Ke=new V({props:{title:"MoshiForCausalLM",local:"transformers.MoshiForCausalLM",headingTag:"h2"}}),et=new N({props:{name:"class transformers.MoshiForCausalLM",anchor:"transformers.MoshiForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1733"}}),tt=new N({props:{name:"forward",anchor:"transformers.MoshiForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.List[torch.FloatTensor], transformers.cache_utils.Cache, NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MoshiForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoshiForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MoshiForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1768",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Jt({props:{$$slots:{default:[xs]},$$scope:{ctx:w}}}),te=new Gt({props:{anchor:"transformers.MoshiForCausalLM.forward.example",$$slots:{default:[Cs]},$$scope:{ctx:w}}}),ot=new V({props:{title:"MoshiForConditionalGeneration",local:"transformers.MoshiForConditionalGeneration",headingTag:"h2"}}),nt=new N({props:{name:"class transformers.MoshiForConditionalGeneration",anchor:"transformers.MoshiForConditionalGeneration",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1883"}}),st=new N({props:{name:"forward",anchor:"transformers.MoshiForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"text_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"audio_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence text tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_input_values",description:"<strong>user_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio user prompt for the generation.",name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_audio_codes",description:"<strong>user_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio user prompt for the generation. Has priority over </code>user_input_values<code>and represents the audio &quot;tokens&quot; of</code>user_input_values` once passed through the audio encoder.",name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_input_values",description:"<strong>moshi_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio Moshi prompt for the generation.",name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_audio_codes",description:"<strong>moshi_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio Moshi prompt for the generation. Has priority over </code>moshi_input_values<code>and represents the audio &quot;tokens&quot; of</code>moshi_input_values` once passed through the audio encoder.",name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>input_ids</code> and <code>inputs_embeds</code> are both unset, <code>inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.`,name:"past_key_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.text_labels",description:`<strong>text_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for text language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"text_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.audio_labels",description:`<strong>audio_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_codebooks, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.audio_vocab_size]</code>`,name:"audio_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1918",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Jt({props:{$$slots:{default:[$s]},$$scope:{ctx:w}}}),ne=new Gt({props:{anchor:"transformers.MoshiForConditionalGeneration.forward.example",$$slots:{default:[zs]},$$scope:{ctx:w}}}),at=new N({props:{name:"generate",anchor:"transformers.MoshiForConditionalGeneration.generate",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_audio_waveforms",val:": typing.Optional[bool] = True"},{name:"return_audio_codes",val:": typing.Optional[bool] = None"},{name:"concat_unconditional_inputs",val:": typing.Optional[bool] = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.generate.input_ids",description:"<strong>input_ids</strong> (<code>torch.Tensor </code>of shape `(batch_size, sequence_length), <em>optional</em>) &#x2014;\nThe sequence used as a text prompt for the generation.",name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_input_values",description:"<strong>user_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio user prompt for the generation.",name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_audio_codes",description:"<strong>user_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio user prompt for the generation. Has priority over </code>user_input_values<code>and represents the audio &quot;tokens&quot; of</code>user_input_values` once passed through the audio encoder.",name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_input_values",description:"<strong>moshi_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio Moshi prompt for the generation.",name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_audio_codes",description:"<strong>moshi_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio Moshi prompt for the generation. Has priority over </code>moshi_input_values<code>and represents the audio &quot;tokens&quot; of</code>moshi_input_values` once passed through the audio encoder.",name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> and the audio inputs you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert the inputs into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_waveforms",description:`<strong>return_audio_waveforms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t generate the audio waveforms.`,name:"return_audio_waveforms"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_codes",description:`<strong>return_audio_codes</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, will also returns the generated audio codes, i.e the intermediate audio &#x201C;tokens&#x201D; which transforms to <code>audio_sequences</code> once passed through the audio decoder.`,name:"return_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.concat_unconditional_inputs",description:`<strong>concat_unconditional_inputs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t concatenate initial audio and text tokens.`,name:"concat_unconditional_inputs"},{anchor:"transformers.MoshiForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Remaining dictionary of keyword arguments that are passed to the <code>generate</code> method. Refers to the
original <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow"><code>generate</code> docstrings</a>
for more information on how to use them.
Note that keywords with a <em>depth_</em> prefix will be input for the <code>generate</code> method of the
depth decoder. Otherwise, the latter will use its default generation config.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2201",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>MoshiConditionalGenerationGenerateOutput</code></p>
`}}),it=new N({props:{name:"get_unconditional_inputs",anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"},{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.max_new_tokens",description:`<strong>max_new_tokens</strong> (int, <em>optional</em>) &#x2014;
Number of tokens to generate for each sample. More tokens means longer audio samples, at the expense of
longer inference (since more audio tokens need to be generated per sample).`,name:"max_new_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2663"}}),ae=new Gt({props:{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.example",$$slots:{default:[js]},$$scope:{ctx:w}}}),rt=new Ms({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moshi.md"}}),{c(){i=l("meta"),v=s(),m=l("p"),h=s(),u(y.$$.fragment),r=s(),T=l("div"),T.innerHTML=pn,Ft=s(),u(ie.$$.fragment),Wt=s(),re=l("p"),re.innerHTML=un,Zt=s(),le=l("p"),le.textContent=fn,It=s(),D=l("div"),D.innerHTML=gn,Lt=s(),de=l("p"),de.textContent=_n,Ht=s(),ce=l("p"),ce.innerHTML=bn,Ut=s(),he=l("p"),he.textContent=Mn,Bt=s(),me=l("ol"),me.innerHTML=yn,Nt=s(),pe=l("p"),pe.innerHTML=vn,qt=s(),ue=l("p"),ue.textContent=Tn,Rt=s(),fe=l("p"),fe.innerHTML=wn,Vt=s(),ge=l("p"),ge.innerHTML=kn,Xt=s(),_e=l("p"),_e.innerHTML=xn,Pt=s(),be=l("p"),be.textContent=Cn,Dt=s(),Me=l("p"),Me.innerHTML=$n,Et=s(),ye=l("p"),ye.textContent=zn,Yt=s(),ve=l("p"),ve.innerHTML=jn,St=s(),Te=l("p"),Te.innerHTML=Jn,At=s(),u(we.$$.fragment),Ot=s(),ke=l("p"),ke.innerHTML=Gn,Qt=s(),u(xe.$$.fragment),Kt=s(),Ce=l("p"),Ce.textContent=Fn,eo=s(),$e=l("ol"),$e.innerHTML=Wn,to=s(),u(E.$$.fragment),oo=s(),ze=l("p"),ze.innerHTML=Zn,no=s(),je=l("p"),je.textContent=In,so=s(),Je=l("p"),Je.innerHTML=Ln,ao=s(),Ge=l("ol"),Ge.innerHTML=Hn,io=s(),Fe=l("p"),Fe.textContent=Un,ro=s(),We=l("p"),We.textContent=Bn,lo=s(),Ze=l("ol"),Ze.innerHTML=Nn,co=s(),u(Y.$$.fragment),ho=s(),S=l("div"),S.innerHTML=qn,mo=s(),Ie=l("p"),Ie.innerHTML=Rn,po=s(),u(Le.$$.fragment),uo=s(),He=l("p"),He.innerHTML=Vn,fo=s(),Ue=l("p"),Ue.textContent=Xn,go=s(),Be=l("p"),Be.innerHTML=Pn,_o=s(),Ne=l("p"),Ne.textContent=Dn,bo=s(),u(qe.$$.fragment),Mo=s(),Re=l("ol"),Re.innerHTML=En,yo=s(),Ve=l("p"),Ve.innerHTML=Yn,vo=s(),Xe=l("p"),Xe.innerHTML=Sn,To=s(),u(Pe.$$.fragment),wo=s(),x=l("div"),u(De.$$.fragment),Io=s(),ct=l("p"),ct.innerHTML=An,Lo=s(),ht=l("p"),ht.innerHTML=On,Ho=s(),u(A.$$.fragment),Uo=s(),O=l("div"),u(Ee.$$.fragment),Bo=s(),mt=l("p"),mt.innerHTML=Qn,ko=s(),u(Ye.$$.fragment),xo=s(),j=l("div"),u(Se.$$.fragment),No=s(),pt=l("p"),pt.innerHTML=Kn,qo=s(),ut=l("p"),ut.innerHTML=es,Ro=s(),u(Q.$$.fragment),Co=s(),u(Ae.$$.fragment),$o=s(),C=l("div"),u(Oe.$$.fragment),Vo=s(),ft=l("p"),ft.innerHTML=ts,Xo=s(),gt=l("p"),gt.innerHTML=os,Po=s(),_t=l("p"),_t.innerHTML=ns,Do=s(),q=l("div"),u(Qe.$$.fragment),Eo=s(),bt=l("p"),bt.innerHTML=ss,Yo=s(),u(K.$$.fragment),zo=s(),u(Ke.$$.fragment),jo=s(),J=l("div"),u(et.$$.fragment),So=s(),Mt=l("p"),Mt.innerHTML=as,Ao=s(),yt=l("p"),yt.innerHTML=is,Oo=s(),Z=l("div"),u(tt.$$.fragment),Qo=s(),vt=l("p"),vt.innerHTML=rs,Ko=s(),u(ee.$$.fragment),en=s(),u(te.$$.fragment),Jo=s(),u(ot.$$.fragment),Go=s(),k=l("div"),u(nt.$$.fragment),tn=s(),Tt=l("p"),Tt.innerHTML=ls,on=s(),wt=l("p"),wt.innerHTML=ds,nn=s(),I=l("div"),u(st.$$.fragment),sn=s(),kt=l("p"),kt.innerHTML=cs,an=s(),u(oe.$$.fragment),rn=s(),u(ne.$$.fragment),ln=s(),se=l("div"),u(at.$$.fragment),dn=s(),xt=l("p"),xt.textContent=hs,cn=s(),R=l("div"),u(it.$$.fragment),hn=s(),Ct=l("p"),Ct.textContent=ms,mn=s(),u(ae.$$.fragment),Fo=s(),u(rt.$$.fragment),Wo=s(),jt=l("p"),this.h()},l(e){const t=bs("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(o),v=a(e),m=d(e,"P",{}),W(m).forEach(o),h=a(e),f(y.$$.fragment,e),r=a(e),T=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-b95w5j"&&(T.innerHTML=pn),Ft=a(e),f(ie.$$.fragment,e),Wt=a(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1ram3sl"&&(re.innerHTML=un),Zt=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-10cdxpm"&&(le.textContent=fn),It=a(e),D=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(D)!=="svelte-mbh6d3"&&(D.innerHTML=gn),Lt=a(e),de=d(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-vfdo9a"&&(de.textContent=_n),Ht=a(e),ce=d(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-ffvq6r"&&(ce.innerHTML=bn),Ut=a(e),he=d(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-4ue2cs"&&(he.textContent=Mn),Bt=a(e),me=d(e,"OL",{"data-svelte-h":!0}),c(me)!=="svelte-1jvfsgp"&&(me.innerHTML=yn),Nt=a(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1ml9jf7"&&(pe.innerHTML=vn),qt=a(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-14liuk7"&&(ue.textContent=Tn),Rt=a(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-p16krn"&&(fe.innerHTML=wn),Vt=a(e),ge=d(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1q2q7g4"&&(ge.innerHTML=kn),Xt=a(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-mrya4j"&&(_e.innerHTML=xn),Pt=a(e),be=d(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1rssv50"&&(be.textContent=Cn),Dt=a(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-17ugm1v"&&(Me.innerHTML=$n),Et=a(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1omq70l"&&(ye.textContent=zn),Yt=a(e),ve=d(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-17ls77v"&&(ve.innerHTML=jn),St=a(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-133xg3y"&&(Te.innerHTML=Jn),At=a(e),f(we.$$.fragment,e),Ot=a(e),ke=d(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-w8i26r"&&(ke.innerHTML=Gn),Qt=a(e),f(xe.$$.fragment,e),Kt=a(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1bexf7"&&(Ce.textContent=Fn),eo=a(e),$e=d(e,"OL",{"data-svelte-h":!0}),c($e)!=="svelte-pl202q"&&($e.innerHTML=Wn),to=a(e),f(E.$$.fragment,e),oo=a(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-29ux01"&&(ze.innerHTML=Zn),no=a(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1qxprua"&&(je.textContent=In),so=a(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-rsiv03"&&(Je.innerHTML=Ln),ao=a(e),Ge=d(e,"OL",{"data-svelte-h":!0}),c(Ge)!=="svelte-1h129yn"&&(Ge.innerHTML=Hn),io=a(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-mxzqdb"&&(Fe.textContent=Un),ro=a(e),We=d(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-u8oyt7"&&(We.textContent=Bn),lo=a(e),Ze=d(e,"OL",{"data-svelte-h":!0}),c(Ze)!=="svelte-1171zt7"&&(Ze.innerHTML=Nn),co=a(e),f(Y.$$.fragment,e),ho=a(e),S=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(S)!=="svelte-1tji7z9"&&(S.innerHTML=qn),mo=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-kta7w9"&&(Ie.innerHTML=Rn),po=a(e),f(Le.$$.fragment,e),uo=a(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-1byzz9w"&&(He.innerHTML=Vn),fo=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-2rjz94"&&(Ue.textContent=Xn),go=a(e),Be=d(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-78mjvt"&&(Be.innerHTML=Pn),_o=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-nu560a"&&(Ne.textContent=Dn),bo=a(e),f(qe.$$.fragment,e),Mo=a(e),Re=d(e,"OL",{"data-svelte-h":!0}),c(Re)!=="svelte-sd14aa"&&(Re.innerHTML=En),yo=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-xte361"&&(Ve.innerHTML=Yn),vo=a(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-ow5c16"&&(Xe.innerHTML=Sn),To=a(e),f(Pe.$$.fragment,e),wo=a(e),x=d(e,"DIV",{class:!0});var G=W(x);f(De.$$.fragment,G),Io=a(G),ct=d(G,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1bo9y8q"&&(ct.innerHTML=An),Lo=a(G),ht=d(G,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-o55m63"&&(ht.innerHTML=On),Ho=a(G),f(A.$$.fragment,G),Uo=a(G),O=d(G,"DIV",{class:!0});var lt=W(O);f(Ee.$$.fragment,lt),Bo=a(lt),mt=d(lt,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1i23l1v"&&(mt.innerHTML=Qn),lt.forEach(o),G.forEach(o),ko=a(e),f(Ye.$$.fragment,e),xo=a(e),j=d(e,"DIV",{class:!0});var L=W(j);f(Se.$$.fragment,L),No=a(L),pt=d(L,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-1o2zxrk"&&(pt.innerHTML=Kn),qo=a(L),ut=d(L,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-o55m63"&&(ut.innerHTML=es),Ro=a(L),f(Q.$$.fragment,L),L.forEach(o),Co=a(e),f(Ae.$$.fragment,e),$o=a(e),C=d(e,"DIV",{class:!0});var F=W(C);f(Oe.$$.fragment,F),Vo=a(F),ft=d(F,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-1hn43q6"&&(ft.innerHTML=ts),Xo=a(F),gt=d(F,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-hswkmf"&&(gt.innerHTML=os),Po=a(F),_t=d(F,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-8vjzhz"&&(_t.innerHTML=ns),Do=a(F),q=d(F,"DIV",{class:!0});var P=W(q);f(Qe.$$.fragment,P),Eo=a(P),bt=d(P,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-te41l3"&&(bt.innerHTML=ss),Yo=a(P),f(K.$$.fragment,P),P.forEach(o),F.forEach(o),zo=a(e),f(Ke.$$.fragment,e),jo=a(e),J=d(e,"DIV",{class:!0});var H=W(J);f(et.$$.fragment,H),So=a(H),Mt=d(H,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-199lvu9"&&(Mt.innerHTML=as),Ao=a(H),yt=d(H,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-hswkmf"&&(yt.innerHTML=is),Oo=a(H),Z=d(H,"DIV",{class:!0});var U=W(Z);f(tt.$$.fragment,U),Qo=a(U),vt=d(U,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-2k89wz"&&(vt.innerHTML=rs),Ko=a(U),f(ee.$$.fragment,U),en=a(U),f(te.$$.fragment,U),U.forEach(o),H.forEach(o),Jo=a(e),f(ot.$$.fragment,e),Go=a(e),k=d(e,"DIV",{class:!0});var $=W(k);f(nt.$$.fragment,$),tn=a($),Tt=d($,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-6aoagg"&&(Tt.innerHTML=ls),on=a($),wt=d($,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-hswkmf"&&(wt.innerHTML=ds),nn=a($),I=d($,"DIV",{class:!0});var B=W(I);f(st.$$.fragment,B),sn=a(B),kt=d(B,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-10ij2kh"&&(kt.innerHTML=cs),an=a(B),f(oe.$$.fragment,B),rn=a(B),f(ne.$$.fragment,B),B.forEach(o),ln=a($),se=d($,"DIV",{class:!0});var dt=W(se);f(at.$$.fragment,dt),dn=a(dt),xt=d(dt,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-8p80bg"&&(xt.textContent=hs),dt.forEach(o),cn=a($),R=d($,"DIV",{class:!0});var $t=W(R);f(it.$$.fragment,$t),hn=a($t),Ct=d($t,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-99wdq5"&&(Ct.textContent=ms),mn=a($t),f(ae.$$.fragment,$t),$t.forEach(o),$.forEach(o),Fo=a(e),f(rt.$$.fragment,e),Wo=a(e),jt=d(e,"P",{}),W(jt).forEach(o),this.h()},h(){z(i,"name","hf:doc:metadata"),z(i,"content",Gs),z(T,"class","flex flex-wrap space-x-1"),ps(D,"text-align","center"),ps(S,"text-align","center"),z(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,i),n(e,v,t),n(e,m,t),n(e,h,t),g(y,e,t),n(e,r,t),n(e,T,t),n(e,Ft,t),g(ie,e,t),n(e,Wt,t),n(e,re,t),n(e,Zt,t),n(e,le,t),n(e,It,t),n(e,D,t),n(e,Lt,t),n(e,de,t),n(e,Ht,t),n(e,ce,t),n(e,Ut,t),n(e,he,t),n(e,Bt,t),n(e,me,t),n(e,Nt,t),n(e,pe,t),n(e,qt,t),n(e,ue,t),n(e,Rt,t),n(e,fe,t),n(e,Vt,t),n(e,ge,t),n(e,Xt,t),n(e,_e,t),n(e,Pt,t),n(e,be,t),n(e,Dt,t),n(e,Me,t),n(e,Et,t),n(e,ye,t),n(e,Yt,t),n(e,ve,t),n(e,St,t),n(e,Te,t),n(e,At,t),g(we,e,t),n(e,Ot,t),n(e,ke,t),n(e,Qt,t),g(xe,e,t),n(e,Kt,t),n(e,Ce,t),n(e,eo,t),n(e,$e,t),n(e,to,t),g(E,e,t),n(e,oo,t),n(e,ze,t),n(e,no,t),n(e,je,t),n(e,so,t),n(e,Je,t),n(e,ao,t),n(e,Ge,t),n(e,io,t),n(e,Fe,t),n(e,ro,t),n(e,We,t),n(e,lo,t),n(e,Ze,t),n(e,co,t),g(Y,e,t),n(e,ho,t),n(e,S,t),n(e,mo,t),n(e,Ie,t),n(e,po,t),g(Le,e,t),n(e,uo,t),n(e,He,t),n(e,fo,t),n(e,Ue,t),n(e,go,t),n(e,Be,t),n(e,_o,t),n(e,Ne,t),n(e,bo,t),g(qe,e,t),n(e,Mo,t),n(e,Re,t),n(e,yo,t),n(e,Ve,t),n(e,vo,t),n(e,Xe,t),n(e,To,t),g(Pe,e,t),n(e,wo,t),n(e,x,t),g(De,x,null),p(x,Io),p(x,ct),p(x,Lo),p(x,ht),p(x,Ho),g(A,x,null),p(x,Uo),p(x,O),g(Ee,O,null),p(O,Bo),p(O,mt),n(e,ko,t),g(Ye,e,t),n(e,xo,t),n(e,j,t),g(Se,j,null),p(j,No),p(j,pt),p(j,qo),p(j,ut),p(j,Ro),g(Q,j,null),n(e,Co,t),g(Ae,e,t),n(e,$o,t),n(e,C,t),g(Oe,C,null),p(C,Vo),p(C,ft),p(C,Xo),p(C,gt),p(C,Po),p(C,_t),p(C,Do),p(C,q),g(Qe,q,null),p(q,Eo),p(q,bt),p(q,Yo),g(K,q,null),n(e,zo,t),g(Ke,e,t),n(e,jo,t),n(e,J,t),g(et,J,null),p(J,So),p(J,Mt),p(J,Ao),p(J,yt),p(J,Oo),p(J,Z),g(tt,Z,null),p(Z,Qo),p(Z,vt),p(Z,Ko),g(ee,Z,null),p(Z,en),g(te,Z,null),n(e,Jo,t),g(ot,e,t),n(e,Go,t),n(e,k,t),g(nt,k,null),p(k,tn),p(k,Tt),p(k,on),p(k,wt),p(k,nn),p(k,I),g(st,I,null),p(I,sn),p(I,kt),p(I,an),g(oe,I,null),p(I,rn),g(ne,I,null),p(k,ln),p(k,se),g(at,se,null),p(se,dn),p(se,xt),p(k,cn),p(k,R),g(it,R,null),p(R,hn),p(R,Ct),p(R,mn),g(ae,R,null),n(e,Fo,t),g(rt,e,t),n(e,Wo,t),n(e,jt,t),Zo=!0},p(e,[t]){const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),E.$set(G);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),Y.$set(lt);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),A.$set(L);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),Q.$set(F);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),K.$set(P);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),ee.$set(H);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),te.$set(U);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),oe.$set($);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),ne.$set(B);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),ae.$set(dt)},i(e){Zo||(_(y.$$.fragment,e),_(ie.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(E.$$.fragment,e),_(Y.$$.fragment,e),_(Le.$$.fragment,e),_(qe.$$.fragment,e),_(Pe.$$.fragment,e),_(De.$$.fragment,e),_(A.$$.fragment,e),_(Ee.$$.fragment,e),_(Ye.$$.fragment,e),_(Se.$$.fragment,e),_(Q.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Qe.$$.fragment,e),_(K.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(st.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(at.$$.fragment,e),_(it.$$.fragment,e),_(ae.$$.fragment,e),_(rt.$$.fragment,e),Zo=!0)},o(e){b(y.$$.fragment,e),b(ie.$$.fragment,e),b(we.$$.fragment,e),b(xe.$$.fragment,e),b(E.$$.fragment,e),b(Y.$$.fragment,e),b(Le.$$.fragment,e),b(qe.$$.fragment,e),b(Pe.$$.fragment,e),b(De.$$.fragment,e),b(A.$$.fragment,e),b(Ee.$$.fragment,e),b(Ye.$$.fragment,e),b(Se.$$.fragment,e),b(Q.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(Qe.$$.fragment,e),b(K.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(st.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(at.$$.fragment,e),b(it.$$.fragment,e),b(ae.$$.fragment,e),b(rt.$$.fragment,e),Zo=!1},d(e){e&&(o(v),o(m),o(h),o(r),o(T),o(Ft),o(Wt),o(re),o(Zt),o(le),o(It),o(D),o(Lt),o(de),o(Ht),o(ce),o(Ut),o(he),o(Bt),o(me),o(Nt),o(pe),o(qt),o(ue),o(Rt),o(fe),o(Vt),o(ge),o(Xt),o(_e),o(Pt),o(be),o(Dt),o(Me),o(Et),o(ye),o(Yt),o(ve),o(St),o(Te),o(At),o(Ot),o(ke),o(Qt),o(Kt),o(Ce),o(eo),o($e),o(to),o(oo),o(ze),o(no),o(je),o(so),o(Je),o(ao),o(Ge),o(io),o(Fe),o(ro),o(We),o(lo),o(Ze),o(co),o(ho),o(S),o(mo),o(Ie),o(po),o(uo),o(He),o(fo),o(Ue),o(go),o(Be),o(_o),o(Ne),o(bo),o(Mo),o(Re),o(yo),o(Ve),o(vo),o(Xe),o(To),o(wo),o(x),o(ko),o(xo),o(j),o(Co),o($o),o(C),o(zo),o(jo),o(J),o(Jo),o(Go),o(k),o(Fo),o(Wo),o(jt)),o(i),M(y,e),M(ie,e),M(we,e),M(xe,e),M(E,e),M(Y,e),M(Le,e),M(qe,e),M(Pe,e),M(De),M(A),M(Ee),M(Ye,e),M(Se),M(Q),M(Ae,e),M(Oe),M(Qe),M(K),M(Ke,e),M(et),M(tt),M(ee),M(te),M(ot,e),M(nt),M(st),M(oe),M(ne),M(at),M(it),M(ae),M(rt,e)}}}const Gs='{"title":"Moshi","local":"moshi","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Tips:","local":"tips","sections":[{"title":"How to use the model:","local":"how-to-use-the-model","sections":[],"depth":3},{"title":"How does the model forward the inputs / generate:","local":"how-does-the-model-forward-the-inputs--generate","sections":[],"depth":3}],"depth":2},{"title":"MoshiConfig","local":"transformers.MoshiConfig","sections":[],"depth":2},{"title":"MoshiDepthConfig","local":"transformers.MoshiDepthConfig","sections":[],"depth":2},{"title":"MoshiModel","local":"transformers.MoshiModel","sections":[],"depth":2},{"title":"MoshiForCausalLM","local":"transformers.MoshiForCausalLM","sections":[],"depth":2},{"title":"MoshiForConditionalGeneration","local":"transformers.MoshiForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Fs(w){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends gs{constructor(i){super(),_s(this,i,Fs,Js,us,{})}}export{Ns as component};
