import{s as gl,o as Rl,n as vl}from"../chunks/scheduler.01eeda35.js";import{S as Xl,i as zl,g as p,s as a,r as c,A as Hl,h as i,f as s,c as n,j as Gl,u as r,x as J,k as Tl,y as $l,a as t,v as y,d,t as w,w as m}from"../chunks/index.6dd51b66.js";import{T as Ql}from"../chunks/Tip.de9bae2b.js";import{C as b}from"../chunks/CodeBlock.19ec9b8c.js";import{H as hl,E as Yl}from"../chunks/index.58fe8f9d.js";function Sl(q){let o,C='The <a href="https://github.com/huggingface/transformers/blob/9985d06add07a4cc691dc54a7e34f54205c04d40/src/transformers/utils/import_utils.py#L2286" rel="nofollow">clear_import_cache</a> utility is very useful when you’re iteratively modifying and developing model code. It removes all cached Transformers modules and allows Python to reload the modified code without constantly restarting your environment.',U,T,h;return T=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuaW1wb3J0X3V0aWxzJTIwaW1wb3J0JTIwY2xlYXJfaW1wb3J0X2NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUyMyUyMG1vZGlmaWNhdGlvbnMlMjB0byUyMG1vZGVsJTIwY29kZSUwQSUyMyUyMGNsZWFyJTIwY2FjaGUlMjB0byUyMHJlbG9hZCUyMG1vZGlmaWVkJTIwY29kZSUwQWNsZWFyX2ltcG9ydF9jYWNoZSgpJTBBJTIzJTIwcmUtaW1wb3J0JTIwdG8lMjB1c2UlMjB1cGRhdGVkJTIwY29kZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers.utils.import_utils <span class="hljs-keyword">import</span> clear_import_cache

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-comment"># modifications to model code</span>
<span class="hljs-comment"># clear cache to reload modified code</span>
clear_import_cache()
<span class="hljs-comment"># re-import to use updated code</span>
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)`,wrap:!1}}),{c(){o=p("p"),o.innerHTML=C,U=a(),c(T.$$.fragment)},l(M){o=i(M,"P",{"data-svelte-h":!0}),J(o)!=="svelte-qq0ajk"&&(o.innerHTML=C),U=n(M),r(T.$$.fragment,M)},m(M,j){t(M,o,j),t(M,U,j),y(T,M,j),h=!0},p:vl,i(M){h||(d(T.$$.fragment,M),h=!0)},o(M){w(T.$$.fragment,M),h=!1},d(M){M&&(s(o),s(U)),m(T,M)}}}function Vl(q){let o,C,U,T,h,M,j,jl='Another way to customize a model is to modify their components, rather than writing a new model entirely, allowing you to tailor a model to your specific use case. For example, you can add new layers or optimize the attention mechanism of an architecture. Customizations are applied directly to a Transformers model so that you can continue to use features such as <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and the <a href="https://huggingface.co/docs/peft/en/index" rel="nofollow">PEFT</a> library.',F,k,Ul='This guide will show you how to customize a models attention mechanism in order to apply <a href="https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora" rel="nofollow">Low-Rank Adaptation (LoRA)</a> to it.',x,I,E,Z,D,_,Il='<a href="./model_doc/sam">Segment Anything</a> is an image segmentation model, and it combines the query-key-value (<code>qkv</code>) projection in its attention mechanisms. To reduce the number of trainable parameters and computational overhead, you can apply LoRA to the <code>qkv</code> projection. This requires splitting the <code>qkv</code> projection so that you can separately target the <code>q</code> and <code>v</code> with LoRA.',K,A,ul="<li>Create a custom attention class, <code>SamVisionAttentionSplit</code>, by subclassing the original <code>SamVisionAttention</code> class. In the <code>__init__</code>, delete the combined <code>qkv</code> and create a separate linear layer for <code>q</code>, <code>k</code> and <code>v</code>.</li>",P,B,O,u,fl="<li>The <code>_split_qkv_load_hook</code> function splits the pretrained <code>qkv</code> weights into separate <code>q</code>, <code>k</code>, and <code>v</code> weights when loading the model to ensure compatibility with any pretrained model.</li>",ll,W,el,f,bl="<li>In the <code>forward</code> pass, <code>q</code>, <code>k</code>, and <code>v</code> are computed separately while the rest of the attention mechanism remains the same.</li>",sl,G,tl,g,Cl="Assign the custom <code>SamVisionAttentionSplit</code> class to the original models <code>SamVisionAttention</code> module to replace it. All instances of <code>SamVisionAttention</code> in the model is replaced with the split attention version.",al,R,kl='Load the model with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.',nl,v,Ml,X,ol,z,Zl="With separate <code>q</code>, <code>k</code>, and <code>v</code> projections, apply LoRA to <code>q</code> and <code>v</code>.",pl,H,_l='Create a <a href="https://huggingface.co/docs/peft/package_reference/config#peft.PeftConfig" rel="nofollow">LoraConfig</a> and specify the rank <code>r</code>, <code>lora_alpha</code>, <code>lora_dropout</code>, <code>task_type</code>, and most importantly, the modules to target.',il,$,cl,Q,Al='Pass the model and <a href="https://huggingface.co/docs/peft/package_reference/config#peft.PeftConfig" rel="nofollow">LoraConfig</a> to <a href="https://huggingface.co/docs/peft/package_reference/peft_model#peft.get_peft_model" rel="nofollow">get_peft_model</a> to apply LoRA to the model.',rl,Y,Jl,S,Bl='Call <a href="https://huggingface.co/docs/peft/package_reference/peft_model#peft.PeftMixedModel.print_trainable_parameters" rel="nofollow">print_trainable_parameters</a> to view the number of parameters you’re training as a result versus the total number of parameters.',yl,V,dl,L,wl,N,ml;return h=new hl({props:{title:"Customizing model components",local:"customizing-model-components",headingTag:"h1"}}),I=new Ql({props:{warning:!1,$$slots:{default:[Sl]},$$scope:{ctx:q}}}),Z=new hl({props:{title:"Attention class",local:"attention-class",headingTag:"h2"}}),B=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5zYW0ubW9kZWxpbmdfc2FtJTIwaW1wb3J0JTIwU2FtVmlzaW9uQXR0ZW50aW9uJTBBJTBBY2xhc3MlMjBTYW1WaXNpb25BdHRlbnRpb25TcGxpdChTYW1WaXNpb25BdHRlbnRpb24lMkMlMjBubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUyQyUyMHdpbmRvd19zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnJTJDJTIwd2luZG93X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcmVtb3ZlJTIwY29tYmluZWQlMjBxa3YlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWwlMjBzZWxmLnFrdiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNlcGFyYXRlJTIwcSUyQyUyMGslMkMlMjB2JTIwcHJvamVjdGlvbnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnElMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmslMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnYlMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9yZWdpc3Rlcl9sb2FkX3N0YXRlX2RpY3RfcHJlX2hvb2soc2VsZi5zcGxpdF9xX2tfdl9sb2FkX2hvb2sp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> transformers.models.sam.modeling_sam <span class="hljs-keyword">import</span> SamVisionAttention

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SamVisionAttentionSplit</span>(SamVisionAttention, nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, window_size</span>):
        <span class="hljs-built_in">super</span>().__init__(config, window_size)
        <span class="hljs-comment"># remove combined qkv</span>
        <span class="hljs-keyword">del</span> self.qkv
        <span class="hljs-comment"># separate q, k, v projections</span>
        self.q = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.k = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.v = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self._register_load_state_dict_pre_hook(self.split_q_k_v_load_hook)`,wrap:!1}}),W=new b({props:{code:"JTIwJTIwJTIwJTIwZGVmJTIwc3BsaXRfcV9rX3ZfbG9hZF9ob29rKHNlbGYlMkMlMjBzdGF0ZV9kaWN0JTJDJTIwcHJlZml4JTJDJTIwKmFyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5c190b19kZWxldGUlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrZXklMjBpbiUyMGxpc3Qoc3RhdGVfZGljdC5rZXlzKCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAlMjJxa3YuJTIyJTIwaW4lMjBrZXklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzcGxpdCUyMHElMkMlMjBrJTJDJTIwdiUyMGZyb20lMjB0aGUlMjBjb21iaW5lZCUyMHByb2plY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxJTJDJTIwayUyQyUyMHYlMjAlM0QlMjBzdGF0ZV9kaWN0JTVCa2V5JTVELmNodW5rKDMlMkMlMjBkaW0lM0QwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlcGxhY2UlMjB3aXRoJTIwaW5kaXZpZHVhbCUyMHElMkMlMjBrJTJDJTIwdiUyMHByb2plY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJxLiUyMiklNUQlMjAlM0QlMjBxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJrLiUyMiklNUQlMjAlM0QlMjBrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJ2LiUyMiklNUQlMjAlM0QlMjB2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWFyayUyMHRoZSUyMG9sZCUyMHFrdiUyMGtleSUyMGZvciUyMGRlbGV0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5c190b19kZWxldGUuYXBwZW5kKGtleSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjByZW1vdmUlMjBvbGQlMjBxa3YlMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTIwaW4lMjBrZXlzX3RvX2RlbGV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMHN0YXRlX2RpY3QlNUJrZXklNUQ=",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">split_q_k_v_load_hook</span>(<span class="hljs-params">self, state_dict, prefix, *args</span>):
        keys_to_delete = []
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(state_dict.keys()):
            <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;qkv.&quot;</span> <span class="hljs-keyword">in</span> key:
                <span class="hljs-comment"># split q, k, v from the combined projection</span>
                q, k, v = state_dict[key].chunk(<span class="hljs-number">3</span>, dim=<span class="hljs-number">0</span>)
                <span class="hljs-comment"># replace with individual q, k, v projections</span>
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;q.&quot;</span>)] = q
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;k.&quot;</span>)] = k
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;v.&quot;</span>)] = v
                <span class="hljs-comment"># mark the old qkv key for deletion</span>
                keys_to_delete.append(key)
        
        <span class="hljs-comment"># remove old qkv keys</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys_to_delete:
            <span class="hljs-keyword">del</span> state_dict[key]`,wrap:!1}}),G=new b({props:{code:"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",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor, output_attentions=<span class="hljs-literal">False</span></span>) -&gt; torch.Tensor:
        batch_size, height, width, _ = hidden_states.shape
        qkv_shapes = (batch_size *  self.num_attention_heads,  height * width, -<span class="hljs-number">1</span>)
        query = self.q(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        key = self.k(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        value = self.v(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)

        attn_weights = (query * self.scale) @ key.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        <span class="hljs-keyword">if</span> self.use_rel_pos:
            attn_weights = self.add_decomposed_rel_pos(
                attn_weights, query, self.rel_pos_h, self.rel_pos_w, (height, width), (height, width)
            )

        attn_weights = torch.nn.functional.softmax(attn_weights, dtype=torch.float32, dim=-<span class="hljs-number">1</span>).to(query.dtype)
        attn_probs = nn.functional.dropout(attn_weights, p=self.dropout, training=self.training)
        attn_output = (attn_probs @ value).reshape(batch_size, self.num_attention_heads, height, width, -<span class="hljs-number">1</span>)
        attn_output = attn_output.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>).reshape(batch_size, height, width, -<span class="hljs-number">1</span>)
        attn_output = self.proj(attn_output)

        <span class="hljs-keyword">if</span> output_attentions:
            outputs = (attn_output, attn_weights)
        <span class="hljs-keyword">else</span>:
            outputs = (attn_output, <span class="hljs-literal">None</span>)
        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),v=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuc2FtJTIwaW1wb3J0JTIwbW9kZWxpbmdfc2FtJTBBJTBBJTIzJTIwcmVwbGFjZSUyMHRoZSUyMGF0dGVudGlvbiUyMGNsYXNzJTIwaW4lMjB0aGUlMjBtb2RlbGluZ19zYW0lMjBtb2R1bGUlMEFtb2RlbGluZ19zYW0uU2FtVmlzaW9uQXR0ZW50aW9uJTIwJTNEJTIwU2FtVmlzaW9uQXR0ZW50aW9uU3BsaXQlMEElMEElMjMlMjBsb2FkJTIwdGhlJTIwcHJldHJhaW5lZCUyMFNBTSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBTYW1Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWJhc2UlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel
<span class="hljs-keyword">from</span> transformers.models.sam <span class="hljs-keyword">import</span> modeling_sam

<span class="hljs-comment"># replace the attention class in the modeling_sam module</span>
modeling_sam.SamVisionAttention = SamVisionAttentionSplit

<span class="hljs-comment"># load the pretrained SAM model</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),X=new hl({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),$=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGFwcGx5JTIwTG9SQSUyMHRvJTIwcSUyMGFuZCUyMHYlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnElMjIlMkMlMjAlMjJ2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIybWFzay1nZW5lcmF0aW9uJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    <span class="hljs-comment"># apply LoRA to q and v</span>
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    task_type=<span class="hljs-string">&quot;mask-generation&quot;</span>
)`,wrap:!1}}),Y=new b({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:"model = get_peft_model(model, config)",wrap:!1}}),V=new b({props:{code:"bW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDYwOCUyQzI1NiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDk0JTJDMzQzJTJDNzI4JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC42NDQ3JTIy",highlighted:`model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 608,256 || all params: 94,343,728 || trainable%: 0.6447&quot;</span>`,wrap:!1}}),L=new Yl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/how_to_hack_models.md"}}),{c(){o=p("meta"),C=a(),U=p("p"),T=a(),c(h.$$.fragment),M=a(),j=p("p"),j.innerHTML=jl,F=a(),k=p("p"),k.innerHTML=Ul,x=a(),c(I.$$.fragment),E=a(),c(Z.$$.fragment),D=a(),_=p("p"),_.innerHTML=Il,K=a(),A=p("ol"),A.innerHTML=ul,P=a(),c(B.$$.fragment),O=a(),u=p("ol"),u.innerHTML=fl,ll=a(),c(W.$$.fragment),el=a(),f=p("ol"),f.innerHTML=bl,sl=a(),c(G.$$.fragment),tl=a(),g=p("p"),g.innerHTML=Cl,al=a(),R=p("p"),R.innerHTML=kl,nl=a(),c(v.$$.fragment),Ml=a(),c(X.$$.fragment),ol=a(),z=p("p"),z.innerHTML=Zl,pl=a(),H=p("p"),H.innerHTML=_l,il=a(),c($.$$.fragment),cl=a(),Q=p("p"),Q.innerHTML=Al,rl=a(),c(Y.$$.fragment),Jl=a(),S=p("p"),S.innerHTML=Bl,yl=a(),c(V.$$.fragment),dl=a(),c(L.$$.fragment),wl=a(),N=p("p"),this.h()},l(l){const e=Hl("svelte-u9bgzb",document.head);o=i(e,"META",{name:!0,content:!0}),e.forEach(s),C=n(l),U=i(l,"P",{}),Gl(U).forEach(s),T=n(l),r(h.$$.fragment,l),M=n(l),j=i(l,"P",{"data-svelte-h":!0}),J(j)!=="svelte-gf3z1d"&&(j.innerHTML=jl),F=n(l),k=i(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1rh1a31"&&(k.innerHTML=Ul),x=n(l),r(I.$$.fragment,l),E=n(l),r(Z.$$.fragment,l),D=n(l),_=i(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-64c6cg"&&(_.innerHTML=Il),K=n(l),A=i(l,"OL",{"data-svelte-h":!0}),J(A)!=="svelte-1i23me3"&&(A.innerHTML=ul),P=n(l),r(B.$$.fragment,l),O=n(l),u=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(u)!=="svelte-11rant"&&(u.innerHTML=fl),ll=n(l),r(W.$$.fragment,l),el=n(l),f=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(f)!=="svelte-6hmxrg"&&(f.innerHTML=bl),sl=n(l),r(G.$$.fragment,l),tl=n(l),g=i(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-nkh0b4"&&(g.innerHTML=Cl),al=n(l),R=i(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-f5b0fs"&&(R.innerHTML=kl),nl=n(l),r(v.$$.fragment,l),Ml=n(l),r(X.$$.fragment,l),ol=n(l),z=i(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1km26rk"&&(z.innerHTML=Zl),pl=n(l),H=i(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1hvvkbj"&&(H.innerHTML=_l),il=n(l),r($.$$.fragment,l),cl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-1gzm1t1"&&(Q.innerHTML=Al),rl=n(l),r(Y.$$.fragment,l),Jl=n(l),S=i(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-1ctingj"&&(S.innerHTML=Bl),yl=n(l),r(V.$$.fragment,l),dl=n(l),r(L.$$.fragment,l),wl=n(l),N=i(l,"P",{}),Gl(N).forEach(s),this.h()},h(){Tl(o,"name","hf:doc:metadata"),Tl(o,"content",Ll),Tl(u,"start","2"),Tl(f,"start","3")},m(l,e){$l(document.head,o),t(l,C,e),t(l,U,e),t(l,T,e),y(h,l,e),t(l,M,e),t(l,j,e),t(l,F,e),t(l,k,e),t(l,x,e),y(I,l,e),t(l,E,e),y(Z,l,e),t(l,D,e),t(l,_,e),t(l,K,e),t(l,A,e),t(l,P,e),y(B,l,e),t(l,O,e),t(l,u,e),t(l,ll,e),y(W,l,e),t(l,el,e),t(l,f,e),t(l,sl,e),y(G,l,e),t(l,tl,e),t(l,g,e),t(l,al,e),t(l,R,e),t(l,nl,e),y(v,l,e),t(l,Ml,e),y(X,l,e),t(l,ol,e),t(l,z,e),t(l,pl,e),t(l,H,e),t(l,il,e),y($,l,e),t(l,cl,e),t(l,Q,e),t(l,rl,e),y(Y,l,e),t(l,Jl,e),t(l,S,e),t(l,yl,e),y(V,l,e),t(l,dl,e),y(L,l,e),t(l,wl,e),t(l,N,e),ml=!0},p(l,[e]){const Wl={};e&2&&(Wl.$$scope={dirty:e,ctx:l}),I.$set(Wl)},i(l){ml||(d(h.$$.fragment,l),d(I.$$.fragment,l),d(Z.$$.fragment,l),d(B.$$.fragment,l),d(W.$$.fragment,l),d(G.$$.fragment,l),d(v.$$.fragment,l),d(X.$$.fragment,l),d($.$$.fragment,l),d(Y.$$.fragment,l),d(V.$$.fragment,l),d(L.$$.fragment,l),ml=!0)},o(l){w(h.$$.fragment,l),w(I.$$.fragment,l),w(Z.$$.fragment,l),w(B.$$.fragment,l),w(W.$$.fragment,l),w(G.$$.fragment,l),w(v.$$.fragment,l),w(X.$$.fragment,l),w($.$$.fragment,l),w(Y.$$.fragment,l),w(V.$$.fragment,l),w(L.$$.fragment,l),ml=!1},d(l){l&&(s(C),s(U),s(T),s(M),s(j),s(F),s(k),s(x),s(E),s(D),s(_),s(K),s(A),s(P),s(O),s(u),s(ll),s(el),s(f),s(sl),s(tl),s(g),s(al),s(R),s(nl),s(Ml),s(ol),s(z),s(pl),s(H),s(il),s(cl),s(Q),s(rl),s(Jl),s(S),s(yl),s(dl),s(wl),s(N)),s(o),m(h,l),m(I,l),m(Z,l),m(B,l),m(W,l),m(G,l),m(v,l),m(X,l),m($,l),m(Y,l),m(V,l),m(L,l)}}}const Ll='{"title":"Customizing model components","local":"customizing-model-components","sections":[{"title":"Attention class","local":"attention-class","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2}],"depth":1}';function Nl(q){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Xl{constructor(o){super(),zl(this,o,Nl,Vl,gl,{})}}export{Kl as component};
