import{s as Pt,o as Qt,n as Xo}from"../chunks/scheduler.01eeda35.js";import{S as Ht,i as qt,g as i,s as n,r as p,A as Dt,h as r,f as t,c as s,j as Z,u as h,x as m,k as C,y as c,a,v as g,d as f,t as u,w as y}from"../chunks/index.6dd51b66.js";import{T as Yt}from"../chunks/Tip.de9bae2b.js";import{D as G}from"../chunks/Docstring.cb556860.js";import{C as X}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Xt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as V,E as Ot}from"../chunks/index.58fe8f9d.js";function Kt(B){let d,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',M,_,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){d=i("p"),d.innerHTML=T,M=n(),_=i("p"),_.innerHTML=v},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-nz63kd"&&(d.innerHTML=T),M=s(l),_=r(l,"P",{"data-svelte-h":!0}),m(_)!=="svelte-aze40l"&&(_.innerHTML=v)},m(l,b){a(l,d,b),a(l,M,b),a(l,_,b)},p:Xo,d(l){l&&(t(d),t(M),t(_))}}}function ea(B){let d,T="Example:",M,_,v;return _=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhQ29uZmlnJTJDJTIwQ0xJUFZpc2lvbkNvbmZpZyUyQyUyMExsYW1hQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVAtdmlzaW9uJTIwY29uZmlnJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMENMSVBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwTGxhbWFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb0xsYXZhJTIwdmlkZW9fbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFZpZGVvTGxhdmFDb25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB2aWRlb19sbGF2YS0xLjUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoLlava video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoLlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=i("p"),d.textContent=T,M=n(),p(_.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),M=s(l),h(_.$$.fragment,l)},m(l,b){a(l,d,b),a(l,M,b),g(_,l,b),v=!0},p:Xo,i(l){v||(f(_.$$.fragment,l),v=!0)},o(l){u(_.$$.fragment,l),v=!1},d(l){l&&(t(d),t(M)),y(_,l)}}}function oa(B){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=T},l(M){d=r(M,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(M,_){a(M,d,_)},p:Xo,d(M){M&&t(d)}}}function ta(B){let d,T="Example:",M,_,v;return _=new X({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBhdiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVmlkZW9MbGF2YVByb2Nlc3NvciUyQyUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMEFkZWYlMjByZWFkX3ZpZGVvX3B5YXYoY29udGFpbmVyJTJDJTIwaW5kaWNlcyklM0ElMEElMjAlMjAlMjAlMjAnJyclMEElMjAlMjAlMjAlMjBEZWNvZGUlMjB0aGUlMjB2aWRlbyUyMHdpdGglMjBQeUFWJTIwZGVjb2Rlci4lMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGFpbmVyJTIwKCU2MGF2LmNvbnRhaW5lci5pbnB1dC5JbnB1dENvbnRhaW5lciU2MCklM0ElMjBQeUFWJTIwY29udGFpbmVyLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGljZXMlMjAoJTYwTGlzdCU1QmludCU1RCU2MCklM0ElMjBMaXN0JTIwb2YlMjBmcmFtZSUyMGluZGljZXMlMjB0byUyMGRlY29kZS4lMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwKG5wLm5kYXJyYXkpJTNBJTIwbnAlMjBhcnJheSUyMG9mJTIwZGVjb2RlZCUyMGZyYW1lcyUyMG9mJTIwc2hhcGUlMjAobnVtX2ZyYW1lcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTJDJTIwMykuJTBBJTIwJTIwJTIwJTIwJycnJTBBJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwY29udGFpbmVyLnNlZWsoMCklMEElMjAlMjAlMjAlMjBzdGFydF9pbmRleCUyMCUzRCUyMGluZGljZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwZW5kX2luZGV4JTIwJTNEJTIwaW5kaWNlcyU1Qi0xJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGZyYW1lJTIwaW4lMjBlbnVtZXJhdGUoY29udGFpbmVyLmRlY29kZSh2aWRlbyUzRDApKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUyMGVuZF9pbmRleCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNFJTNEJTIwc3RhcnRfaW5kZXglMjBhbmQlMjBpJTIwaW4lMjBpbmRpY2VzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnJhbWVzLmFwcGVuZChmcmFtZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBucC5zdGFjayglNUJ4LnRvX25kYXJyYXkoZm9ybWF0JTNEJTIycmdiMjQlMjIpJTIwZm9yJTIweCUyMGluJTIwZnJhbWVzJTVEKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwVmlkZW9MbGF2YVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFJTVDbldoeSUyMGlzJTIwdGhpcyUyMHZpZGVvJTIwZnVubnklM0YlMjBBU1NJU1RBTlQlM0ElMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJyYXVzaGFuLXRlc3RpbmctaGYlMkZ2aWRlb3MtdGVzdCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyc2FtcGxlX2RlbW9fMS5tcDQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWNvbnRhaW5lciUyMCUzRCUyMGF2Lm9wZW4odmlkZW9fcGF0aCklMEElMEElMjMlMjBzYW1wbGUlMjB1bmlmb3JtbHklMjA4JTIwZnJhbWVzJTIwZnJvbSUyMHRoZSUyMHZpZGVvJTBBdG90YWxfZnJhbWVzJTIwJTNEJTIwY29udGFpbmVyLnN0cmVhbXMudmlkZW8lNUIwJTVELmZyYW1lcyUwQWluZGljZXMlMjAlM0QlMjBucC5hcmFuZ2UoMCUyQyUyMHRvdGFsX2ZyYW1lcyUyQyUyMHRvdGFsX2ZyYW1lcyUyMCUyRiUyMDgpLmFzdHlwZShpbnQpJTBBY2xpcCUyMCUzRCUyMHJlYWRfdmlkZW9fcHlhdihjb250YWluZXIlMkMlMjBpbmRpY2VzKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwdmlkZW9zJTNEY2xpcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q4MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQlMEElMEElMjMlMjB0byUyMGdlbmVyYXRlJTIwZnJvbSUyMGltYWdlJTIwYW5kJTIwdmlkZW8lMjBtaXglMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbkhvdyUyMG1hbnklMjBjYXRzJTIwZG8lMjB5b3UlMjBzZWUlM0YlMjBBU1NJU1RBTlQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJVU0VSJTNBJTIwJTNDdmlkZW8lM0UlNUNuV2h5JTIwaXMlMjB0aGlzJTIwdmlkZW8lMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMiUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjB2aWRlb3MlM0RjbGlwJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNENTApJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaProcessor, VideoLlavaForConditionalGeneration


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">80</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is playing with a Wii remote while sitting on the floor, and the baby is wearing glasses.Ъ. The baby&#x27;s actions are amusing because it is a young child trying to interact with a video game, which is not a typical activity for a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to generate from image and video mix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats do you see? ASSISTANT:&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;USER:   How many cats do you see? ASSISTANT: There are two cats visible in the image. (or three, if you count the one in the background).&#x27;</span>, <span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because it shows a baby sitting on a bed and playing with a Wii remote.Ъ. The baby is holding the remote&#x27;</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=T,M=n(),p(_.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),M=s(l),h(_.$$.fragment,l)},m(l,b){a(l,d,b),a(l,M,b),g(_,l,b),v=!0},p:Xo,i(l){v||(f(_.$$.fragment,l),v=!0)},o(l){u(_.$$.fragment,l),v=!1},d(l){l&&(t(d),t(M)),y(_,l)}}}function aa(B){let d,T,M,_,v,l,b,gt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',eo,P,oo,Q,ft="Video-LLaVa is an open-source multimodal LLM trained by fine-tuning LlamA/Vicuna on multimodal instruction-following data generated by Llava1.5 and VideChat. It is an auto-regressive language model, based on the transformer architecture. Video-LLaVa unifies visual representations to the language feature space, and enables an LLM to perform visual reasoning capabilities on both images and videos simultaneously.",to,H,ut='The Video-LLaVA model was proposed in <a href="https://arxiv.org/abs/2311.10122" rel="nofollow">Video-LLaVA: Learning United Visual Representation by Alignment Before Projection</a> by Bin Lin, Yang Ye, Bin Zhu, Jiaxi Cui, Munang Ning, Peng Jin, Li Yuan.',ao,q,yt="The abstract from the paper is the following:",no,D,_t=`<em>The Large Vision-Language Model (LVLM) has enhanced the performance of various downstream tasks in
visual-language understanding. Most existing approaches
encode images and videos into separate feature spaces,
which are then fed as inputs to large language models.
However, due to the lack of unified tokenization for images and videos, namely misalignment before projection, it
becomes challenging for a Large Language Model (LLM)
to learn multi-modal interactions from several poor projection layers. In this work, we unify visual representation into the language feature space to advance the foundational LLM towards a unified LVLM. As a result, we establish a simple but robust LVLM baseline, Video-LLaVA,
which learns from a mixed dataset of images and videos,
mutually enhancing each other. Video-LLaVA achieves superior performances on a broad range of 9 image benchmarks across 5 image question-answering datasets and 4
image benchmark toolkits. Additionally, our Video-LLaVA
also outperforms Video-ChatGPT by 5.8%, 9.9%, 18.6%,
and 10.1% on MSRVTT, MSVD, TGIF, and ActivityNet, respectively. Notably, extensive experiments demonstrate that
Video-LLaVA mutually benefits images and videos within
a unified visual representation, outperforming models designed specifically for images or videos. We aim for this
work to provide modest insights into the multi-modal inputs
for the LLM</em>`,so,O,io,K,Mt="<li><p>We advise users to use padding_side=“left” when computing batched generation as it leads to more accurate results. Simply make sure to call processor.tokenizer.padding_side = “left” before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images/videos in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li> <li><p>Note that the video inputs should have exactly 8 frames at the input, since the models were trained in that setting.</p></li>",ro,ee,vt=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/PKU-YuanGroup/Video-LLaVA" rel="nofollow">here</a>.`,lo,oe,bt="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",co,te,mo,ae,po,ne,Tt="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",ho,se,go,ie,wt="For multiple turns conversation change the prompt format to:",fo,re,uo,le,yo,de,Jt="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",_o,ce,Mo,me,vo,pe,bo,he,jt="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. his allows for efficient deployment on resource-constrained cases.",To,ge,Ut="First make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",wo,W,Jo,fe,It='Load the quantized model by simply adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',jo,ue,Uo,ye,Io,_e,Vt='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',Vo,Me,kt="First, make sure to install the latest version of Flash Attention 2:",ko,ve,Co,be,Ct='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',Lo,Te,Lt="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",Zo,we,Bo,Je,zo,w,je,Po,Re,Zt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a>. It is used to instantiate an
VideoLlava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the like LanguageBind/Video-LLaVA-7B-hf.`,Qo,Ne,Bt='e.g. <a href="https://huggingface.co/LanguageBind/Video-LLaVA-7B-hf" rel="nofollow">LanguageBind/Video-LLaVA-7B-hf</a>',Ho,Ee,zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,qo,x,Go,Ue,Wo,j,Ie,Do,Se,Gt="Constructs a CLIP image processor.",Oo,$,Ve,Ko,Ae,Wt="Preprocess an image or batch of images.",et,F,ke,ot,Ye,xt=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,xo,Ce,$o,J,Le,tt,Xe,$t="Constructs a VideoLlava processor which wraps a VideoLlava image processor and a Llava tokenizer into a single processor.",at,Pe,Ft=`<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor">VideoLlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor.decode">decode()</a> for more information.`,nt,R,Ze,st,Qe,Rt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,it,N,Be,rt,He,Nt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Fo,ze,Ro,U,Ge,lt,qe,Et=`The VideoLlava model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,dt,De,St=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ct,k,We,mt,Oe,At='The <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',pt,E,ht,S,No,xe,Eo,Ke,So;return v=new V({props:{title:"Video-LLaVA",local:"video-llava",headingTag:"h1"}}),P=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),O=new V({props:{title:"Usage tips:",local:"usage-tips",headingTag:"h2"}}),te=new V({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ae=new V({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),se=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaProcessor

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the model in half-precision</span>
model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.arrau, sampling uniformly 8 frames</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For better results, we recommend to prompt the model in the following format</span>
prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this funny? ASSISTANT:&quot;</span>
inputs = processor(text=prompt, videos=video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),re=new X({props:{code:"JTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFJTVDbldoYXQlMjBkbyUyMHlvdSUyMHNlZSUyMGluJTIwdGhpcyUyMHZpZGVvJTNGJTIwQVNTSVNUQU5UJTNBJTIwQSUyMGJhYnklMjByZWFkaW5nJTIwYSUyMGJvb2suJTIwVVNFUiUzQSUyMFdoeSUyMGlzJTIwdGhlJTIwaXQlMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMg==",highlighted:'<span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhat do you see in this video? ASSISTANT: A baby reading a book. USER: Why is the it funny? ASSISTANT:&quot;</span>',wrap:!1}}),le=new V({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),ce=new X({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZyb20lMjBpbWFnZSUyMGFuZCUyMHZpZGVvJTIwbWl4ZWQlMjBpbnB1dHMlMEElMjMlMjBMb2FkJTIwYW5kJTIwaW1hZ2UlMjBhbmQlMjB3cml0ZSUyMGElMjBuZXclMjBwcm9tcHQlMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbkhvdyUyMG1hbnklMjBjYXRzJTIwYXJlJTIwdGhlcmUlMjBpbiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIwVGhlcmUlMjBhcmUlMjB0d28lMjBjYXRzLiUyMFVTRVIlM0ElMjAlM0N2aWRlbyUzRSU1Q25XaHklMjBpcyUyMHRoaXMlMjB2aWRlbyUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHZpZGVvcyUzRGNsaXAlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Generate from image and video mixed inputs</span>
<span class="hljs-comment"># Load and image and write a new prompt</span>
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats are there in the image? ASSISTANT: There are two cats. USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>

inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),me=new V({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),pe=new V({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),W=new Yt({props:{$$slots:{default:[Kt]},$$scope:{ctx:B}}}),ue=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ye=new V({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),ve=new X({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),we=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkxhbmd1YWdlQmluZCUyRlZpZGVvLUxMYVZBLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration

model = VideoLlavaForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Je=new V({props:{title:"VideoLlavaConfig",local:"transformers.VideoLlavaConfig",headingTag:"h2"}}),je=new G({props:{name:"class transformers.VideoLlavaConfig",anchor:"transformers.VideoLlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"video_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_seq_length",val:" = 256"},{name:"video_seq_length",val:" = 2056"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>VideoLlavaVisionConfig</code>, <em>optional</em>) &#x2014;
Custom vision config or dict. Defaults to <code>CLIPVisionConfig</code> if not indicated.`,name:"vision_config"},{anchor:"transformers.VideoLlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>) &#x2014;
The config object of the text backbone. Can be any of <code>LlamaConfig</code> or <code>MistralConfig</code>.
Defaults to <code>LlamaConfig</code> if not indicated.`,name:"text_config"},{anchor:"transformers.VideoLlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.VideoLlavaConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.VideoLlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.VideoLlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the CLIP backbone.
Can be either &#x201C;full&#x201D; to select all features or &#x201C;default&#x201D; to select features without <code>CLS</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.VideoLlavaConfig.video_seq_length",description:`<strong>video_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 2056) &#x2014;
Sequence length of one video embedding.`,name:"video_seq_length"},{anchor:"transformers.VideoLlavaConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/configuration_video_llava.py#L24"}}),x=new Xt({props:{anchor:"transformers.VideoLlavaConfig.example",$$slots:{default:[ea]},$$scope:{ctx:B}}}),Ue=new V({props:{title:"VideoLlavaImageProcessor",local:"transformers.VideoLlavaImageProcessor",headingTag:"h2"}}),Ie=new G({props:{name:"class transformers.VideoLlavaImageProcessor",anchor:"transformers.VideoLlavaImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L49"}}),Ve=new G({props:{name:"preprocess",anchor:"transformers.VideoLlavaImageProcessor.preprocess",parameters:[{name:"images",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]] = None"},{name:"videos",val:": typing.List[typing.Union[list['PIL.Image.Image'], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), list['np.ndarray'], list['torch.Tensor'], list[list['PIL.Image.Image']], list[list['np.ndarray']], list[list['torch.Tensor']]]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
List of images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>, <em>optional</em>) &#x2014;
List of videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L172"}}),ke=new G({props:{name:"resize",anchor:"transformers.VideoLlavaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.VideoLlavaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L123"}}),Ce=new V({props:{title:"VideoLlavaProcessor",local:"transformers.VideoLlavaProcessor",headingTag:"h2"}}),Le=new G({props:{name:"class transformers.VideoLlavaProcessor",anchor:"transformers.VideoLlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = 14"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"chat_template",val:" = None"},{name:"num_additional_image_tokens",val:" = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VideoLlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.VideoLlavaProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.VideoLlavaProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.VideoLlavaProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.VideoLlavaProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.VideoLlavaProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L33"}}),Ze=new G({props:{name:"batch_decode",anchor:"transformers.VideoLlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L208"}}),Be=new G({props:{name:"decode",anchor:"transformers.VideoLlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L216"}}),ze=new V({props:{title:"VideoLlavaForConditionalGeneration",local:"transformers.VideoLlavaForConditionalGeneration",headingTag:"h2"}}),Ge=new G({props:{name:"class transformers.VideoLlavaForConditionalGeneration",anchor:"transformers.VideoLlavaForConditionalGeneration",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L245"}}),We=new G({props:{name:"forward",anchor:"transformers.VideoLlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_images",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values_videos",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L362",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig"
>VideoLlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Yt({props:{$$slots:{default:[oa]},$$scope:{ctx:B}}}),S=new Xt({props:{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.example",$$slots:{default:[ta]},$$scope:{ctx:B}}}),xe=new Ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/video_llava.md"}}),{c(){d=i("meta"),T=n(),M=i("p"),_=n(),p(v.$$.fragment),l=n(),b=i("div"),b.innerHTML=gt,eo=n(),p(P.$$.fragment),oo=n(),Q=i("p"),Q.textContent=ft,to=n(),H=i("p"),H.innerHTML=ut,ao=n(),q=i("p"),q.textContent=yt,no=n(),D=i("p"),D.innerHTML=_t,so=n(),p(O.$$.fragment),io=n(),K=i("ul"),K.innerHTML=Mt,ro=n(),ee=i("p"),ee.innerHTML=vt,lo=n(),oe=i("blockquote"),oe.innerHTML=bt,co=n(),p(te.$$.fragment),mo=n(),p(ae.$$.fragment),po=n(),ne=i("p"),ne.innerHTML=Tt,ho=n(),p(se.$$.fragment),go=n(),ie=i("p"),ie.textContent=wt,fo=n(),p(re.$$.fragment),uo=n(),p(le.$$.fragment),yo=n(),de=i("p"),de.textContent=Jt,_o=n(),p(ce.$$.fragment),Mo=n(),p(me.$$.fragment),vo=n(),p(pe.$$.fragment),bo=n(),he=i("p"),he.textContent=jt,To=n(),ge=i("p"),ge.innerHTML=Ut,wo=n(),p(W.$$.fragment),Jo=n(),fe=i("p"),fe.innerHTML=It,jo=n(),p(ue.$$.fragment),Uo=n(),p(ye.$$.fragment),Io=n(),_e=i("p"),_e.innerHTML=Vt,Vo=n(),Me=i("p"),Me.textContent=kt,ko=n(),p(ve.$$.fragment),Co=n(),be=i("p"),be.innerHTML=Ct,Lo=n(),Te=i("p"),Te.innerHTML=Lt,Zo=n(),p(we.$$.fragment),Bo=n(),p(Je.$$.fragment),zo=n(),w=i("div"),p(je.$$.fragment),Po=n(),Re=i("p"),Re.innerHTML=Zt,Qo=n(),Ne=i("p"),Ne.innerHTML=Bt,Ho=n(),Ee=i("p"),Ee.innerHTML=zt,qo=n(),p(x.$$.fragment),Go=n(),p(Ue.$$.fragment),Wo=n(),j=i("div"),p(Ie.$$.fragment),Do=n(),Se=i("p"),Se.textContent=Gt,Oo=n(),$=i("div"),p(Ve.$$.fragment),Ko=n(),Ae=i("p"),Ae.textContent=Wt,et=n(),F=i("div"),p(ke.$$.fragment),ot=n(),Ye=i("p"),Ye.textContent=xt,xo=n(),p(Ce.$$.fragment),$o=n(),J=i("div"),p(Le.$$.fragment),tt=n(),Xe=i("p"),Xe.textContent=$t,at=n(),Pe=i("p"),Pe.innerHTML=Ft,nt=n(),R=i("div"),p(Ze.$$.fragment),st=n(),Qe=i("p"),Qe.innerHTML=Rt,it=n(),N=i("div"),p(Be.$$.fragment),rt=n(),He=i("p"),He.innerHTML=Nt,Fo=n(),p(ze.$$.fragment),Ro=n(),U=i("div"),p(Ge.$$.fragment),lt=n(),qe=i("p"),qe.innerHTML=Et,dt=n(),De=i("p"),De.innerHTML=St,ct=n(),k=i("div"),p(We.$$.fragment),mt=n(),Oe=i("p"),Oe.innerHTML=At,pt=n(),p(E.$$.fragment),ht=n(),p(S.$$.fragment),No=n(),p(xe.$$.fragment),Eo=n(),Ke=i("p"),this.h()},l(e){const o=Dt("svelte-u9bgzb",document.head);d=r(o,"META",{name:!0,content:!0}),o.forEach(t),T=s(e),M=r(e,"P",{}),Z(M).forEach(t),_=s(e),h(v.$$.fragment,e),l=s(e),b=r(e,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-b95w5j"&&(b.innerHTML=gt),eo=s(e),h(P.$$.fragment,e),oo=s(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-81xura"&&(Q.textContent=ft),to=s(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-v87k6c"&&(H.innerHTML=ut),ao=s(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-vfdo9a"&&(q.textContent=yt),no=s(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-sk56aa"&&(D.innerHTML=_t),so=s(e),h(O.$$.fragment,e),io=s(e),K=r(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-s3c9rf"&&(K.innerHTML=Mt),ro=s(e),ee=r(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1lvcrum"&&(ee.innerHTML=vt),lo=s(e),oe=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),m(oe)!=="svelte-nygwxc"&&(oe.innerHTML=bt),co=s(e),h(te.$$.fragment,e),mo=s(e),h(ae.$$.fragment,e),po=s(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1pauxcy"&&(ne.innerHTML=Tt),ho=s(e),h(se.$$.fragment,e),go=s(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1hi3kkd"&&(ie.textContent=wt),fo=s(e),h(re.$$.fragment,e),uo=s(e),h(le.$$.fragment,e),yo=s(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1ngvr6w"&&(de.textContent=Jt),_o=s(e),h(ce.$$.fragment,e),Mo=s(e),h(me.$$.fragment,e),vo=s(e),h(pe.$$.fragment,e),bo=s(e),he=r(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-uomo89"&&(he.textContent=jt),To=s(e),ge=r(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-mhaycu"&&(ge.innerHTML=Ut),wo=s(e),h(W.$$.fragment,e),Jo=s(e),fe=r(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1niphgd"&&(fe.innerHTML=It),jo=s(e),h(ue.$$.fragment,e),Uo=s(e),h(ye.$$.fragment,e),Io=s(e),_e=r(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-m1vtfc"&&(_e.innerHTML=Vt),Vo=s(e),Me=r(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-13kjllm"&&(Me.textContent=kt),ko=s(e),h(ve.$$.fragment,e),Co=s(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-dzzatn"&&(be.innerHTML=Ct),Lo=s(e),Te=r(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-z3ioid"&&(Te.innerHTML=Lt),Zo=s(e),h(we.$$.fragment,e),Bo=s(e),h(Je.$$.fragment,e),zo=s(e),w=r(e,"DIV",{class:!0});var I=Z(w);h(je.$$.fragment,I),Po=s(I),Re=r(I,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-h7bus0"&&(Re.innerHTML=Zt),Qo=s(I),Ne=r(I,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-q9hjjl"&&(Ne.innerHTML=Bt),Ho=s(I),Ee=r(I,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-o55m63"&&(Ee.innerHTML=zt),qo=s(I),h(x.$$.fragment,I),I.forEach(t),Go=s(e),h(Ue.$$.fragment,e),Wo=s(e),j=r(e,"DIV",{class:!0});var L=Z(j);h(Ie.$$.fragment,L),Do=s(L),Se=r(L,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-x48p92"&&(Se.textContent=Gt),Oo=s(L),$=r(L,"DIV",{class:!0});var $e=Z($);h(Ve.$$.fragment,$e),Ko=s($e),Ae=r($e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1x3yxsa"&&(Ae.textContent=Wt),$e.forEach(t),et=s(L),F=r(L,"DIV",{class:!0});var Fe=Z(F);h(ke.$$.fragment,Fe),ot=s(Fe),Ye=r(Fe,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1qmgo6y"&&(Ye.textContent=xt),Fe.forEach(t),L.forEach(t),xo=s(e),h(Ce.$$.fragment,e),$o=s(e),J=r(e,"DIV",{class:!0});var z=Z(J);h(Le.$$.fragment,z),tt=s(z),Xe=r(z,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-15aq8e1"&&(Xe.textContent=$t),at=s(z),Pe=r(z,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-138492i"&&(Pe.innerHTML=Ft),nt=s(z),R=r(z,"DIV",{class:!0});var Ao=Z(R);h(Ze.$$.fragment,Ao),st=s(Ao),Qe=r(Ao,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1o9eza"&&(Qe.innerHTML=Rt),Ao.forEach(t),it=s(z),N=r(z,"DIV",{class:!0});var Yo=Z(N);h(Be.$$.fragment,Yo),rt=s(Yo),He=r(Yo,"P",{"data-svelte-h":!0}),m(He)!=="svelte-kk16qw"&&(He.innerHTML=Nt),Yo.forEach(t),z.forEach(t),Fo=s(e),h(ze.$$.fragment,e),Ro=s(e),U=r(e,"DIV",{class:!0});var A=Z(U);h(Ge.$$.fragment,A),lt=s(A),qe=r(A,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1qwtcy"&&(qe.innerHTML=Et),dt=s(A),De=r(A,"P",{"data-svelte-h":!0}),m(De)!=="svelte-hswkmf"&&(De.innerHTML=St),ct=s(A),k=r(A,"DIV",{class:!0});var Y=Z(k);h(We.$$.fragment,Y),mt=s(Y),Oe=r(Y,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-fmp8gd"&&(Oe.innerHTML=At),pt=s(Y),h(E.$$.fragment,Y),ht=s(Y),h(S.$$.fragment,Y),Y.forEach(t),A.forEach(t),No=s(e),h(xe.$$.fragment,e),Eo=s(e),Ke=r(e,"P",{}),Z(Ke).forEach(t),this.h()},h(){C(d,"name","hf:doc:metadata"),C(d,"content",na),C(b,"class","flex flex-wrap space-x-1"),C(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){c(document.head,d),a(e,T,o),a(e,M,o),a(e,_,o),g(v,e,o),a(e,l,o),a(e,b,o),a(e,eo,o),g(P,e,o),a(e,oo,o),a(e,Q,o),a(e,to,o),a(e,H,o),a(e,ao,o),a(e,q,o),a(e,no,o),a(e,D,o),a(e,so,o),g(O,e,o),a(e,io,o),a(e,K,o),a(e,ro,o),a(e,ee,o),a(e,lo,o),a(e,oe,o),a(e,co,o),g(te,e,o),a(e,mo,o),g(ae,e,o),a(e,po,o),a(e,ne,o),a(e,ho,o),g(se,e,o),a(e,go,o),a(e,ie,o),a(e,fo,o),g(re,e,o),a(e,uo,o),g(le,e,o),a(e,yo,o),a(e,de,o),a(e,_o,o),g(ce,e,o),a(e,Mo,o),g(me,e,o),a(e,vo,o),g(pe,e,o),a(e,bo,o),a(e,he,o),a(e,To,o),a(e,ge,o),a(e,wo,o),g(W,e,o),a(e,Jo,o),a(e,fe,o),a(e,jo,o),g(ue,e,o),a(e,Uo,o),g(ye,e,o),a(e,Io,o),a(e,_e,o),a(e,Vo,o),a(e,Me,o),a(e,ko,o),g(ve,e,o),a(e,Co,o),a(e,be,o),a(e,Lo,o),a(e,Te,o),a(e,Zo,o),g(we,e,o),a(e,Bo,o),g(Je,e,o),a(e,zo,o),a(e,w,o),g(je,w,null),c(w,Po),c(w,Re),c(w,Qo),c(w,Ne),c(w,Ho),c(w,Ee),c(w,qo),g(x,w,null),a(e,Go,o),g(Ue,e,o),a(e,Wo,o),a(e,j,o),g(Ie,j,null),c(j,Do),c(j,Se),c(j,Oo),c(j,$),g(Ve,$,null),c($,Ko),c($,Ae),c(j,et),c(j,F),g(ke,F,null),c(F,ot),c(F,Ye),a(e,xo,o),g(Ce,e,o),a(e,$o,o),a(e,J,o),g(Le,J,null),c(J,tt),c(J,Xe),c(J,at),c(J,Pe),c(J,nt),c(J,R),g(Ze,R,null),c(R,st),c(R,Qe),c(J,it),c(J,N),g(Be,N,null),c(N,rt),c(N,He),a(e,Fo,o),g(ze,e,o),a(e,Ro,o),a(e,U,o),g(Ge,U,null),c(U,lt),c(U,qe),c(U,dt),c(U,De),c(U,ct),c(U,k),g(We,k,null),c(k,mt),c(k,Oe),c(k,pt),g(E,k,null),c(k,ht),g(S,k,null),a(e,No,o),g(xe,e,o),a(e,Eo,o),a(e,Ke,o),So=!0},p(e,[o]){const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),W.$set(I);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),x.$set(L);const $e={};o&2&&($e.$$scope={dirty:o,ctx:e}),E.$set($e);const Fe={};o&2&&(Fe.$$scope={dirty:o,ctx:e}),S.$set(Fe)},i(e){So||(f(v.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(pe.$$.fragment,e),f(W.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(x.$$.fragment,e),f(Ue.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(ke.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(Ze.$$.fragment,e),f(Be.$$.fragment,e),f(ze.$$.fragment,e),f(Ge.$$.fragment,e),f(We.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(xe.$$.fragment,e),So=!0)},o(e){u(v.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(W.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(x.$$.fragment,e),u(Ue.$$.fragment,e),u(Ie.$$.fragment,e),u(Ve.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(Le.$$.fragment,e),u(Ze.$$.fragment,e),u(Be.$$.fragment,e),u(ze.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(xe.$$.fragment,e),So=!1},d(e){e&&(t(T),t(M),t(_),t(l),t(b),t(eo),t(oo),t(Q),t(to),t(H),t(ao),t(q),t(no),t(D),t(so),t(io),t(K),t(ro),t(ee),t(lo),t(oe),t(co),t(mo),t(po),t(ne),t(ho),t(go),t(ie),t(fo),t(uo),t(yo),t(de),t(_o),t(Mo),t(vo),t(bo),t(he),t(To),t(ge),t(wo),t(Jo),t(fe),t(jo),t(Uo),t(Io),t(_e),t(Vo),t(Me),t(ko),t(Co),t(be),t(Lo),t(Te),t(Zo),t(Bo),t(zo),t(w),t(Go),t(Wo),t(j),t(xo),t($o),t(J),t(Fo),t(Ro),t(U),t(No),t(Eo),t(Ke)),t(d),y(v,e),y(P,e),y(O,e),y(te,e),y(ae,e),y(se,e),y(re,e),y(le,e),y(ce,e),y(me,e),y(pe,e),y(W,e),y(ue,e),y(ye,e),y(ve,e),y(we,e),y(Je,e),y(je),y(x),y(Ue,e),y(Ie),y(Ve),y(ke),y(Ce,e),y(Le),y(Ze),y(Be),y(ze,e),y(Ge),y(We),y(E),y(S),y(xe,e)}}}const na='{"title":"Video-LLaVA","local":"video-llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips:","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"VideoLlavaConfig","local":"transformers.VideoLlavaConfig","sections":[],"depth":2},{"title":"VideoLlavaImageProcessor","local":"transformers.VideoLlavaImageProcessor","sections":[],"depth":2},{"title":"VideoLlavaProcessor","local":"transformers.VideoLlavaProcessor","sections":[],"depth":2},{"title":"VideoLlavaForConditionalGeneration","local":"transformers.VideoLlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function sa(B){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ha extends Ht{constructor(d){super(),qt(this,d,sa,aa,Pt,{})}}export{ha as component};
