import{s as Yt,o as St,n as wt}from"../chunks/scheduler.01eeda35.js";import{S as Pt,i as Dt,g as p,s as a,r as d,A as Kt,h as f,f as l,c as s,j as Ht,u,x as M,k as It,y as Ot,a as n,v as b,d as c,t as y,w as h}from"../chunks/index.6dd51b66.js";import{T as el}from"../chunks/Tip.de9bae2b.js";import{C as Z}from"../chunks/CodeBlock.19ec9b8c.js";import{H as R,E as tl}from"../chunks/index.58fe8f9d.js";import{H as ll,a as xt}from"../chunks/HfOption.f7f04550.js";function nl(k){let o,U="Quantizing a model in 8-bit halves the memory-usage, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently distribute the weights across all available GPUs.",J,T,m,g,j='By default, all other modules such as <a href="https://pytorch.org/docs/stable/generated/torch.nn.LayerNorm.html" rel="nofollow">torch.nn.LayerNorm</a> are set to the default torch dtype. You can change the data type of these modules with the <code>torch_dtype</code> parameter. Setting <code>torch_dtype=&quot;auto&quot;</code> loads the model in the data type defined in a model’s <code>config.json</code> file.',B,w,C,_,z='Once a model is quantized to 8-bit, you can’t push the quantized weights to the Hub unless you’re using the latest version of Transformers and bitsandbytes. If you have the latest versions, then you can push the 8-bit model to the Hub with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>. The quantization config.json file is pushed first, followed by the quantized model weights.',v,r,$;return T=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, 
    quantization_config=quantization_config
)`,wrap:!1}}),w=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWxfOGJpdC5tb2RlbC5kZWNvZGVyLmxheWVycyU1Qi0xJTVELmZpbmFsX2xheWVyX25vcm0ud2VpZ2h0LmR0eXBl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, 
    quantization_config=quantization_config, 
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>
)
model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),r=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tNTYwbSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, 
    quantization_config=quantization_config
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),{c(){o=p("p"),o.innerHTML=U,J=a(),d(T.$$.fragment),m=a(),g=p("p"),g.innerHTML=j,B=a(),d(w.$$.fragment),C=a(),_=p("p"),_.innerHTML=z,v=a(),d(r.$$.fragment)},l(i){o=f(i,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1752qjf"&&(o.innerHTML=U),J=s(i),u(T.$$.fragment,i),m=s(i),g=f(i,"P",{"data-svelte-h":!0}),M(g)!=="svelte-110db1o"&&(g.innerHTML=j),B=s(i),u(w.$$.fragment,i),C=s(i),_=f(i,"P",{"data-svelte-h":!0}),M(_)!=="svelte-13qaumd"&&(_.innerHTML=z),v=s(i),u(r.$$.fragment,i)},m(i,W){n(i,o,W),n(i,J,W),b(T,i,W),n(i,m,W),n(i,g,W),n(i,B,W),b(w,i,W),n(i,C,W),n(i,_,W),n(i,v,W),b(r,i,W),$=!0},p:wt,i(i){$||(c(T.$$.fragment,i),c(w.$$.fragment,i),c(r.$$.fragment,i),$=!0)},o(i){y(T.$$.fragment,i),y(w.$$.fragment,i),y(r.$$.fragment,i),$=!1},d(i){i&&(l(o),l(J),l(m),l(g),l(B),l(C),l(_),l(v)),h(T,i),h(w,i),h(r,i)}}}function al(k){let o,U="Quantizing a model in 4-bit reduces your memory-usage by 4x, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently distribute the weights across all available GPUs.",J,T,m,g,j='By default, all other modules such as <a href="https://pytorch.org/docs/stable/generated/torch.nn.LayerNorm.html" rel="nofollow">torch.nn.LayerNorm</a> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.. Setting <code>torch_dtype=&quot;auto&quot;</code> loads the model in the data type defined in a model’s <code>config.json</code> file.',B,w,C,_,z='Make sure you have the latest bitsandbytes version so you can serialize 4-bit models and push them to the Hub with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>. Use <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> to save the 4-bit model locally.',v;return T=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlKSUwQSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    quantization_config=quantization_config
)`,wrap:!1}}),w=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWxfNGJpdC5tb2RlbC5kZWNvZGVyLmxheWVycyU1Qi0xJTVELmZpbmFsX2xheWVyX25vcm0ud2VpZ2h0LmR0eXBl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    quantization_config=quantization_config, 
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>
)
model_4bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),{c(){o=p("p"),o.innerHTML=U,J=a(),d(T.$$.fragment),m=a(),g=p("p"),g.innerHTML=j,B=a(),d(w.$$.fragment),C=a(),_=p("p"),_.innerHTML=z},l(r){o=f(r,"P",{"data-svelte-h":!0}),M(o)!=="svelte-vgig40"&&(o.innerHTML=U),J=s(r),u(T.$$.fragment,r),m=s(r),g=f(r,"P",{"data-svelte-h":!0}),M(g)!=="svelte-5p58r6"&&(g.innerHTML=j),B=s(r),u(w.$$.fragment,r),C=s(r),_=f(r,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1flcsk7"&&(_.innerHTML=z)},m(r,$){n(r,o,$),n(r,J,$),b(T,r,$),n(r,m,$),n(r,g,$),n(r,B,$),b(w,r,$),n(r,C,$),n(r,_,$),v=!0},p:wt,i(r){v||(c(T.$$.fragment,r),c(w.$$.fragment,r),v=!0)},o(r){y(T.$$.fragment,r),y(w.$$.fragment,r),v=!1},d(r){r&&(l(o),l(J),l(m),l(g),l(B),l(C),l(_)),h(T,r),h(w,r)}}}function sl(k){let o,U,J,T;return o=new xt({props:{id:"bnb",option:"8-bit",$$slots:{default:[nl]},$$scope:{ctx:k}}}),J=new xt({props:{id:"bnb",option:"4-bit",$$slots:{default:[al]},$$scope:{ctx:k}}}),{c(){d(o.$$.fragment),U=a(),d(J.$$.fragment)},l(m){u(o.$$.fragment,m),U=s(m),u(J.$$.fragment,m)},m(m,g){b(o,m,g),n(m,U,g),b(J,m,g),T=!0},p(m,g){const j={};g&2&&(j.$$scope={dirty:g,ctx:m}),o.$set(j);const B={};g&2&&(B.$$scope={dirty:g,ctx:m}),J.$set(B)},i(m){T||(c(o.$$.fragment,m),c(J.$$.fragment,m),T=!0)},o(m){y(o.$$.fragment,m),y(J.$$.fragment,m),T=!1},d(m){m&&l(U),h(o,m),h(J,m)}}}function il(k){let o,U="8 and 4-bit training is only supported for training <em>extra</em> parameters.";return{c(){o=p("p"),o.innerHTML=U},l(J){o=f(J,"P",{"data-svelte-h":!0}),M(o)!=="svelte-14e2693"&&(o.innerHTML=U)},m(J,T){n(J,o,T)},p:wt,d(J){J&&l(o)}}}function ol(k){let o,U,J,T,m,g,j,B='<a href="https://github.com/bitsandbytes-foundation/bitsandbytes" rel="nofollow">bitsandbytes</a> features the LLM.int8 and QLoRA quantization to enable accessible large language model inference and training.',w,C,_='<a href="https://hf.co/papers/2208.07339" rel="nofollow">LLM.int8()</a> is a quantization method that aims to make large language model inference more accessible without significant degradation. Unlike naive 8-bit quantization, which can result in loss of critical information and accuracy, LLM.int8() dynamically adapts to ensure sensitive components of the computation retain higher precision when needed.',z,v,r="QLoRA, or 4-bit quantization, compresses a model even further to 4-bits and inserts a small set of trainable low-rank adaptation (LoRA) weights to allowing training.",$,i,W='<p><strong>Note:</strong> For a user-friendly quantization experience, you can use the <code>bitsandbytes</code> <a href="https://huggingface.co/spaces/bnb-community/bnb-my-repo" rel="nofollow">community space</a>.</p>',Ze,q,$t="Run the command below to install bitsandbytes.",je,F,Be,G,Ut='Quantize a model by passing a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <a href="https://pytorch.org/docs/stable/generated/torch.nn.Linear.html" rel="nofollow">torch.nn.Linear</a> layers.',We,N,Re,X,ke,E,_t="Check your memory footprint with <code>get_memory_footprint</code>.",ze,Q,Ne,A,Ct='Load quantized models with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> without a <code>quantization_config</code>.',Xe,V,qe,L,Fe,H,vt="This section explores some of the specific features of 8-bit quantization, such as offloading, outlier thresholds, skipping module conversion, and finetuning.",Ge,I,Ee,x,Zt='8-bit models can offload weights between the CPU and GPU to fit very large models into memory. The weights dispatched to the CPU are stored in <strong>float32</strong> and aren’t converted to 8-bit. For example, enable offloading for <a href="https://huggingface.co/bigscience/bloom-1b7" rel="nofollow">bigscience/bloom-1b7</a> through <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>.',Qe,Y,Ae,S,jt="Design a custom device map to fit everything on your GPU except for the <code>lm_head</code>, which is dispatched to the CPU.",Ve,P,Le,D,Bt="Now load your model with the custom <code>device_map</code> and <code>quantization_config</code>.",He,K,Ie,O,xe,ee,Wt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",Ye,te,Rt='To find the best threshold for your model, experiment with the <code>llm_int8_threshold</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>. For example, setting the threshold to <code>0.0</code> significantly speeds up inference at the potential cost of some accuracy loss.',Se,le,Pe,ne,De,ae,kt='For some models, like <a href="model_doc/jukebox">Jukebox</a>, you don’t need to quantize every module to 8-bit because it can actually cause instability. With Jukebox, there are several <code>lm_head</code> modules that should be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>.',Ke,se,Oe,ie,et,oe,zt='The <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> library supports fine-tuning large models like <a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">flan-t5-large</a> and <a href="https://huggingface.co/facebook/opt-6.7b" rel="nofollow">facebook/opt-6.7b</a> with 8-bit quantization. You don’t need to pass the <code>device_map</code> parameter for training because it automatically loads your model on a GPU. However, you can still customize the device map with the <code>device_map</code> parameter (<code>device_map=&quot;auto&quot;</code> should only be used for inference).',tt,re,lt,me,Nt="This section explores some of the specific features of 4-bit quantization, such as changing the compute data type, the Normal Float 4 (NF4) data type, and nested quantization.",nt,pe,at,de,Xt='Change the data type from float32 (the default value) to bf16 in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> to speedup computation.',st,fe,it,ue,ot,be,qt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models.',rt,ce,mt,ye,Ft="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",pt,he,dt,Me,Gt='Nested quantization can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter. For example, with nested quantization, you can finetune a <a href="https://huggingface.co/meta-llama/Llama-2-13b" rel="nofollow">Llama-13b</a> model on a 16GB NVIDIA T4 GPU with a sequence length of 1024, a batch size of 1, and enable gradient accumulation with 4 steps.',ft,Je,ut,ge,bt,Te,Et='Once quantized, you can <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.dequantize">dequantize()</a> a model to the original precision but this may result in some quality loss. Make sure you have enough GPU memory to fit the dequantized model.',ct,we,yt,$e,ht,Ue,Qt='Learn more about the details of 8-bit quantization in <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a>.',Mt,_e,At='Try 4-bit quantization in this <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">notebook</a> and learn more about it’s details in <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a>.',Jt,Ce,gt,ve,Tt;return m=new R({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),F=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXM=",highlighted:"pip install --upgrade transformers accelerate bitsandbytes",wrap:!1}}),N=new ll({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[sl]},$$scope:{ctx:k}}}),X=new el({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:k}}}),Q=new Z({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),V=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),L=new R({props:{title:"LLM.int8",local:"llmint8",headingTag:"h2"}}),I=new R({props:{title:"Offloading",local:"offloading",headingTag:"h3"}}),Y=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new Z({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),K=new Z({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),O=new R({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),le=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUlMEEpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">0.0</span>,
    llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),ne=new R({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),se=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ie=new R({props:{title:"Finetuning",local:"finetuning",headingTag:"h3"}}),re=new R({props:{title:"QLoRA",local:"qlora",headingTag:"h2"}}),pe=new R({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),fe=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),ue=new R({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),ce=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=nf4_config)`,wrap:!1}}),he=new R({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),Je=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi0xM2ItY2hhdC1oZiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0Rkb3VibGVfcXVhbnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-13b-chat-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=double_quant_config)`,wrap:!1}}),ge=new R({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),we=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSkpJTBBbW9kZWwuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>, BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>))
model.dequantize()`,wrap:!1}}),$e=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ce=new tl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=p("meta"),U=a(),J=p("p"),T=a(),d(m.$$.fragment),g=a(),j=p("p"),j.innerHTML=B,w=a(),C=p("p"),C.innerHTML=_,z=a(),v=p("p"),v.textContent=r,$=a(),i=p("blockquote"),i.innerHTML=W,Ze=a(),q=p("p"),q.textContent=$t,je=a(),d(F.$$.fragment),Be=a(),G=p("p"),G.innerHTML=Ut,We=a(),d(N.$$.fragment),Re=a(),d(X.$$.fragment),ke=a(),E=p("p"),E.innerHTML=_t,ze=a(),d(Q.$$.fragment),Ne=a(),A=p("p"),A.innerHTML=Ct,Xe=a(),d(V.$$.fragment),qe=a(),d(L.$$.fragment),Fe=a(),H=p("p"),H.textContent=vt,Ge=a(),d(I.$$.fragment),Ee=a(),x=p("p"),x.innerHTML=Zt,Qe=a(),d(Y.$$.fragment),Ae=a(),S=p("p"),S.innerHTML=jt,Ve=a(),d(P.$$.fragment),Le=a(),D=p("p"),D.innerHTML=Bt,He=a(),d(K.$$.fragment),Ie=a(),d(O.$$.fragment),xe=a(),ee=p("p"),ee.textContent=Wt,Ye=a(),te=p("p"),te.innerHTML=Rt,Se=a(),d(le.$$.fragment),Pe=a(),d(ne.$$.fragment),De=a(),ae=p("p"),ae.innerHTML=kt,Ke=a(),d(se.$$.fragment),Oe=a(),d(ie.$$.fragment),et=a(),oe=p("p"),oe.innerHTML=zt,tt=a(),d(re.$$.fragment),lt=a(),me=p("p"),me.textContent=Nt,nt=a(),d(pe.$$.fragment),at=a(),de=p("p"),de.innerHTML=Xt,st=a(),d(fe.$$.fragment),it=a(),d(ue.$$.fragment),ot=a(),be=p("p"),be.innerHTML=qt,rt=a(),d(ce.$$.fragment),mt=a(),ye=p("p"),ye.innerHTML=Ft,pt=a(),d(he.$$.fragment),dt=a(),Me=p("p"),Me.innerHTML=Gt,ft=a(),d(Je.$$.fragment),ut=a(),d(ge.$$.fragment),bt=a(),Te=p("p"),Te.innerHTML=Et,ct=a(),d(we.$$.fragment),yt=a(),d($e.$$.fragment),ht=a(),Ue=p("p"),Ue.innerHTML=Qt,Mt=a(),_e=p("p"),_e.innerHTML=At,Jt=a(),d(Ce.$$.fragment),gt=a(),ve=p("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);o=f(t,"META",{name:!0,content:!0}),t.forEach(l),U=s(e),J=f(e,"P",{}),Ht(J).forEach(l),T=s(e),u(m.$$.fragment,e),g=s(e),j=f(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-xcj7ov"&&(j.innerHTML=B),w=s(e),C=f(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-ehhzma"&&(C.innerHTML=_),z=s(e),v=f(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1sd0mpj"&&(v.textContent=r),$=s(e),i=f(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(i)!=="svelte-18yyxaf"&&(i.innerHTML=W),Ze=s(e),q=f(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-nn1zee"&&(q.textContent=$t),je=s(e),u(F.$$.fragment,e),Be=s(e),G=f(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-nvcemd"&&(G.innerHTML=Ut),We=s(e),u(N.$$.fragment,e),Re=s(e),u(X.$$.fragment,e),ke=s(e),E=f(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-3u2pq"&&(E.innerHTML=_t),ze=s(e),u(Q.$$.fragment,e),Ne=s(e),A=f(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-5ab1q1"&&(A.innerHTML=Ct),Xe=s(e),u(V.$$.fragment,e),qe=s(e),u(L.$$.fragment,e),Fe=s(e),H=f(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-9650w3"&&(H.textContent=vt),Ge=s(e),u(I.$$.fragment,e),Ee=s(e),x=f(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1jt3bby"&&(x.innerHTML=Zt),Qe=s(e),u(Y.$$.fragment,e),Ae=s(e),S=f(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-80v3vx"&&(S.innerHTML=jt),Ve=s(e),u(P.$$.fragment,e),Le=s(e),D=f(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1oaka12"&&(D.innerHTML=Bt),He=s(e),u(K.$$.fragment,e),Ie=s(e),u(O.$$.fragment,e),xe=s(e),ee=f(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-ur5rgd"&&(ee.textContent=Wt),Ye=s(e),te=f(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1jcweb0"&&(te.innerHTML=Rt),Se=s(e),u(le.$$.fragment,e),Pe=s(e),u(ne.$$.fragment,e),De=s(e),ae=f(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1f7c9ag"&&(ae.innerHTML=kt),Ke=s(e),u(se.$$.fragment,e),Oe=s(e),u(ie.$$.fragment,e),et=s(e),oe=f(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-18qfkz8"&&(oe.innerHTML=zt),tt=s(e),u(re.$$.fragment,e),lt=s(e),me=f(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1b1i0z0"&&(me.textContent=Nt),nt=s(e),u(pe.$$.fragment,e),at=s(e),de=f(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-cv16qb"&&(de.innerHTML=Xt),st=s(e),u(fe.$$.fragment,e),it=s(e),u(ue.$$.fragment,e),ot=s(e),be=f(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-vfa0sb"&&(be.innerHTML=qt),rt=s(e),u(ce.$$.fragment,e),mt=s(e),ye=f(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1qoc2ct"&&(ye.innerHTML=Ft),pt=s(e),u(he.$$.fragment,e),dt=s(e),Me=f(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1jt2w56"&&(Me.innerHTML=Gt),ft=s(e),u(Je.$$.fragment,e),ut=s(e),u(ge.$$.fragment,e),bt=s(e),Te=f(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-192l2ej"&&(Te.innerHTML=Et),ct=s(e),u(we.$$.fragment,e),yt=s(e),u($e.$$.fragment,e),ht=s(e),Ue=f(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-km4860"&&(Ue.innerHTML=Qt),Mt=s(e),_e=f(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-96sk4r"&&(_e.innerHTML=At),Jt=s(e),u(Ce.$$.fragment,e),gt=s(e),ve=f(e,"P",{}),Ht(ve).forEach(l),this.h()},h(){It(o,"name","hf:doc:metadata"),It(o,"content",rl)},m(e,t){Ot(document.head,o),n(e,U,t),n(e,J,t),n(e,T,t),b(m,e,t),n(e,g,t),n(e,j,t),n(e,w,t),n(e,C,t),n(e,z,t),n(e,v,t),n(e,$,t),n(e,i,t),n(e,Ze,t),n(e,q,t),n(e,je,t),b(F,e,t),n(e,Be,t),n(e,G,t),n(e,We,t),b(N,e,t),n(e,Re,t),b(X,e,t),n(e,ke,t),n(e,E,t),n(e,ze,t),b(Q,e,t),n(e,Ne,t),n(e,A,t),n(e,Xe,t),b(V,e,t),n(e,qe,t),b(L,e,t),n(e,Fe,t),n(e,H,t),n(e,Ge,t),b(I,e,t),n(e,Ee,t),n(e,x,t),n(e,Qe,t),b(Y,e,t),n(e,Ae,t),n(e,S,t),n(e,Ve,t),b(P,e,t),n(e,Le,t),n(e,D,t),n(e,He,t),b(K,e,t),n(e,Ie,t),b(O,e,t),n(e,xe,t),n(e,ee,t),n(e,Ye,t),n(e,te,t),n(e,Se,t),b(le,e,t),n(e,Pe,t),b(ne,e,t),n(e,De,t),n(e,ae,t),n(e,Ke,t),b(se,e,t),n(e,Oe,t),b(ie,e,t),n(e,et,t),n(e,oe,t),n(e,tt,t),b(re,e,t),n(e,lt,t),n(e,me,t),n(e,nt,t),b(pe,e,t),n(e,at,t),n(e,de,t),n(e,st,t),b(fe,e,t),n(e,it,t),b(ue,e,t),n(e,ot,t),n(e,be,t),n(e,rt,t),b(ce,e,t),n(e,mt,t),n(e,ye,t),n(e,pt,t),b(he,e,t),n(e,dt,t),n(e,Me,t),n(e,ft,t),b(Je,e,t),n(e,ut,t),b(ge,e,t),n(e,bt,t),n(e,Te,t),n(e,ct,t),b(we,e,t),n(e,yt,t),b($e,e,t),n(e,ht,t),n(e,Ue,t),n(e,Mt,t),n(e,_e,t),n(e,Jt,t),b(Ce,e,t),n(e,gt,t),n(e,ve,t),Tt=!0},p(e,[t]){const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),N.$set(Vt);const Lt={};t&2&&(Lt.$$scope={dirty:t,ctx:e}),X.$set(Lt)},i(e){Tt||(c(m.$$.fragment,e),c(F.$$.fragment,e),c(N.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(V.$$.fragment,e),c(L.$$.fragment,e),c(I.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(Je.$$.fragment,e),c(ge.$$.fragment,e),c(we.$$.fragment,e),c($e.$$.fragment,e),c(Ce.$$.fragment,e),Tt=!0)},o(e){y(m.$$.fragment,e),y(F.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(V.$$.fragment,e),y(L.$$.fragment,e),y(I.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(fe.$$.fragment,e),y(ue.$$.fragment,e),y(ce.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(ge.$$.fragment,e),y(we.$$.fragment,e),y($e.$$.fragment,e),y(Ce.$$.fragment,e),Tt=!1},d(e){e&&(l(U),l(J),l(T),l(g),l(j),l(w),l(C),l(z),l(v),l($),l(i),l(Ze),l(q),l(je),l(Be),l(G),l(We),l(Re),l(ke),l(E),l(ze),l(Ne),l(A),l(Xe),l(qe),l(Fe),l(H),l(Ge),l(Ee),l(x),l(Qe),l(Ae),l(S),l(Ve),l(Le),l(D),l(He),l(Ie),l(xe),l(ee),l(Ye),l(te),l(Se),l(Pe),l(De),l(ae),l(Ke),l(Oe),l(et),l(oe),l(tt),l(lt),l(me),l(nt),l(at),l(de),l(st),l(it),l(ot),l(be),l(rt),l(mt),l(ye),l(pt),l(dt),l(Me),l(ft),l(ut),l(bt),l(Te),l(ct),l(yt),l(ht),l(Ue),l(Mt),l(_e),l(Jt),l(gt),l(ve)),l(o),h(m,e),h(F,e),h(N,e),h(X,e),h(Q,e),h(V,e),h(L,e),h(I,e),h(Y,e),h(P,e),h(K,e),h(O,e),h(le,e),h(ne,e),h(se,e),h(ie,e),h(re,e),h(pe,e),h(fe,e),h(ue,e),h(ce,e),h(he,e),h(Je,e),h(ge,e),h(we,e),h($e,e),h(Ce,e)}}}const rl='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"LLM.int8","local":"llmint8","sections":[{"title":"Offloading","local":"offloading","sections":[],"depth":3},{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3},{"title":"Finetuning","local":"finetuning","sections":[],"depth":3}],"depth":2},{"title":"QLoRA","local":"qlora","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ml(k){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends Pt{constructor(o){super(),Dt(this,o,ml,ol,Yt,{})}}export{yl as component};
