import{s as dl,o as cl,n as ul}from"../chunks/scheduler.36a0863c.js";import{S as Tl,i as Jl,g as i,s,r as m,A as wl,h as o,f as l,c as n,j as Ml,u as M,x as r,k as pl,y as Ul,a,v as p,d,t as c,w as u}from"../chunks/index.f891bdb2.js";import{T as yl}from"../chunks/Tip.a8272f7f.js";import{C as w}from"../chunks/CodeBlock.b05e74dc.js";import{H as Ie,E as jl}from"../chunks/index.c6b8cc89.js";function Cl(fe){let T,y="Si planeas ejecutar varias pruebas, reinicie el kernel de Python entre cada prueba para borrar correctamente la memoria.";return{c(){T=i("p"),T.textContent=y},l(J){T=o(J,"P",{"data-svelte-h":!0}),r(T)!=="svelte-k5e8r3"&&(T.textContent=y)},m(J,je){a(J,T,je)},p:ul,d(J){J&&l(T)}}}function Il(fe){let T,y,J,je,j,Ae,C,gt="Para entender las técnicas de optimización del rendimiento que se pueden aplicar para mejorar la eficiencia en la velocidad del entrenamiento de los modelos y la utilización de la memoria, es útil familiarizarse con cómo se utiliza la GPU durante el entrenamiento y cómo varía la intensidad de cálculo según la operación realizada.",Se,I,Lt="Empecemos explorando un ejemplo enfocado en la utilización de la GPU y la ejecución del entrenamiento de un modelo. Para la demostración, necesitaremos instalar algunas bibliotecas:",ge,f,Le,A,bt="La biblioteca <code>nvidia-ml-py3</code> nos permite monitorear la utilización de memoria de los modelos desde Python. Es posible que estés familiarizado con el comando <code>nvidia-smi</code> en la terminal, esta biblioteca nos permite acceder a la misma información en Python directamente.",be,S,zt="Luego, creamos algunos datos ficticios: IDs de tokens aleatorios entre 100 y 30000 y etiquetas binarias para un clasificador. En total, obtenemos 512 secuencias cada una con longitud 512 y las almacenamos en un <code>Dataset</code> con formato PyTorch.",ze,g,he,L,ht='Para imprimir estadísticas resumidas para la utilización de la GPU y la ejecución del entrenamiento con <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#transformers.Trainer" rel="nofollow"><code>Trainer</code></a>, definimos dos funciones auxiliares:',ve,b,Qe,z,vt="Comencemos comprobando que la memoria GPU este libre:",Re,h,$e,v,Qt="Parece estar bien: la memoria de la GPU no está ocupada como esperaríamos antes de cargar cualquier modelo. Si no es el caso en tu máquina, asegúrate de detener todos los procesos que estén utilizando la memoria de la GPU. Sin embargo, no toda la memoria libre de la GPU puede ser utilizada por el usuario. Cuando se carga un modelo en la GPU, también se cargan los kernels, lo que puede ocupar 1-2GB de memoria. Para ver cuánta memoria será ocupada por defecto, cargemos un tensor diminuto en la GPU, lo que también desencadena la carga de los kernels.",Ge,Q,xe,R,Rt="Vemos que los kernels solos ocupan 1,3GB de memoria de la GPU. Ahora, veamos cuánto espacio ocupa el modelo.",_e,$,Ee,G,$t="Primero, cargamos el modelo <code>google-bert/bert-large-uncased</code>. Los pesos del modelo son cargados directamente en la GPU para que podamos verificar cuánto espacio ocupan solo los pesos.",Pe,x,Be,_,Gt="Podemos ver que los pesos del modelo solos ocupan 1,3 GB de memoria de la GPU. El número exacto depende de la GPU específica que estés utilizando. Ten en cuenta que en GPUs más modernas, un modelo puede ocupar más espacio ya que los pesos se cargan de manera optimizada lo cual acelera el uso del modelo. Ahora también podemos verificar rápidamente si obtenemos el mismo resultado que con la CLI de <code>nvidia-smi</code>:",Ve,E,ke,P,qe,B,xt="Obtenemos el mismo número que antes y también puedes ver que estamos utilizando una GPU V100 con 16GB de memoria. Ahora podemos empezar a entrenar el modelo y ver cómo cambia el consumo de memoria de la GPU. Primero, configuramos algunos argumentos de entrenamiento estándar:",Ze,V,He,U,We,k,Ne,q,_t='Vamos a utilizar el <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#transformers.Trainer" rel="nofollow"><code>Trainer</code></a> y entrenar el modelo sin utilizar ninguna técnica de optimización del rendimiento de la GPU y un tamaño de lote de 4:',Xe,Z,De,H,Fe,W,Et=`Vemos que incluso un tamaño de lote relativamente pequeño casi llena toda la memoria de nuestra GPU. Sin embargo, un tamaño de lote más grande a menudo puede resultar en una convergencia del modelo más rápida o un mejor rendimiento final. Así que idealmente queremos ajustar el tamaño del lote a las necesidades del modelo y no a las limitaciones de la GPU. Lo interesante es que utilizamos mucha más memoria que el tamaño del modelo.
Para entender un poco mejor por qué es el caso, echemos un vistazo a las operaciones y necesidades de memoria de un modelo.`,Ye,N,Ke,X,Pt="La arquitectura de los transformers incluye 3 grupos principales de operaciones agrupadas a continuación por intensidad de cálculo.",Oe,D,Bt="<li><p><strong>Contracciones de Tensores</strong></p> <p>Las capas lineales y componentes de la Atención Multi-Head realizan <strong>multiplicaciones matriciales por lotes</strong>. Estas operaciones son la parte más intensiva en cálculo del entrenamiento de los transformers.</p></li> <li><p><strong>Normalizaciones Estadísticas</strong></p> <p>Softmax y normalización de capas son menos intensivas en cálculo que las contracciones de tensores, e implican una o más <strong>operaciones de reducción</strong>, cuyo resultado se aplica luego mediante un mapa.</p></li> <li><p><strong>Operadores por Elemento</strong></p> <p>Estos son los operadores restantes: <strong>sesgos, dropout, activaciones y conexiones residuales</strong>. Estas son las operaciones menos intensivas en cálculo.</p></li>",et,F,Vt="Este conocimiento puede ser útil al analizar cuellos de botella de rendimiento.",tt,Y,kt='Este resumen se deriva de <a href="https://arxiv.org/abs/2007.00072" rel="nofollow">Data Movement Is All You Need: A Case Study on Optimizing Transformers 2020</a>',lt,K,at,O,qt="Hemos visto que al entrenar un modelo se utiliza mucha más memoria que solo poner el modelo en la GPU. Esto se debe a que hay muchos componentes durante el entrenamiento que utilizan memoria de la GPU. Los componentes en memoria de la GPU son los siguientes:",st,ee,Zt="<li>pesos del modelo</li> <li>estados del optimizador</li> <li>gradientes</li> <li>activaciones hacia adelante guardadas para el cálculo del gradiente</li> <li>buffers temporales</li> <li>memoria específica de funcionalidad</li>",nt,te,Ht="Un modelo típico entrenado en precisión mixta con AdamW requiere 18 bytes por parámetro del modelo más memoria de activación. Para la inferencia no hay estados del optimizador ni gradientes, por lo que podemos restarlos. Y así terminamos con 6 bytes por parámetro del modelo para la inferencia en precisión mixta, más la memoria de activación.",it,le,Wt="Veámoslo a detalle:",ot,ae,Nt="<strong>Pesos del Modelo:</strong>",rt,se,Xt="<li>4 bytes por número de parámetros para entrenamiento en fp32</li> <li>6 bytes por número de parámetros para entrenamiento en precisión mixta (mantiene un modelo en fp32 y uno en fp16 en memoria)</li>",mt,ne,Dt="<strong>Estados del Optimizador:</strong>",Mt,ie,Ft='<li>8 bytes por número de parámetros para un AdamW normal (mantiene 2 estados)</li> <li>2 bytes por número de parámetros para optimizadores de 8 bits como <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a></li> <li>4 bytes por número de parámetros para optimizadores como SGD con momentum (mantiene solo 1 estado)</li>',pt,oe,Yt="<strong>Gradientes</strong>",dt,re,Kt="<li>4 bytes por número de parámetros para entrenamiento en fp32 o precisión mixta (los gradientes siempre se mantienen en fp32)</li>",ct,me,Ot="<strong>Activaciones hacia Adelante</strong>",ut,Me,el="<li>El tamaño depende de muchos factores, los principales siendo la longitud de la secuencia, el tamaño oculto y el tamaño de lote.</li>",Tt,pe,tl="Hay entradas y salidas que se pasan y se devuelven por las funciones hacia adelante y hacia atrás, y las activaciones hacia adelante (<em>forward activations</em>) guardadas para el cálculo del gradiente.",Jt,de,ll="<strong>Memoria Temporal</strong>",wt,ce,al="Además, hay todas clases de variables temporales que se liberan una vez que se completa el cálculo, pero en el momento podrían requerir memoria adicional y podrían provocar un error de memoria insuficiente. Por lo tanto, al codificar es crucial pensar estratégicamente sobre tales variables temporales y a veces liberarlas explícitamente tan pronto como ya no se necesitan.",Ut,ue,sl="<strong>Memoria Específica de Funcionalidad</strong>",yt,Te,nl="Entonces, su software podría tener necesidades especiales de memoria. Por ejemplo, al generar texto mediante la búsqueda por haz, el software necesita mantener múltiples copias de las entradas y salidas.",jt,Je,il="<strong>Velocidad de Ejecución <code>forward</code> vs <code>backward</code></strong>",Ct,we,ol="Para convoluciones y capas lineales, hay 2x flops en la ejecución hacia atrás (<code>backward</code>) en comparación con la ejecución hacia adelante (<code>forward</code>), lo que generalmente se traduce en ~2x más lento (a veces más, porque los tamaños en la ejecución hacia atrás tienden a ser más complejos). Las activaciones suelen ser limitadas por ancho de banda, y es típico que una activación tenga que leer más datos en la ejecución hacia atrás que en la ejecución hacia adelante (por ejemplo, la activación hacia adelante lee una vez, escribe una vez, la activación hacia atrás lee dos veces, gradOutput y salida de la ejecución hacia adelante, y escribe una vez, gradInput).",It,Ue,rl='Como puedes ver, hay potencialmente unos pocos lugares donde podríamos ahorrar memoria de la GPU o acelerar operaciones. Ahora que entiendes qué afecta la utilización de la GPU y la velocidad de cálculo, consulta la página de documentación <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one" rel="nofollow">Métodos y herramientas para entrenamiento eficiente en una sola GPU</a> para aprender sobre técnicas de optimización del rendimiento.',ft,ye,At,Ce,St;return j=new Ie({props:{title:"Anatomía del entrenamiento de los modelos",local:"anatomía-del-entrenamiento-de-los-modelos",headingTag:"h1"}}),f=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMG52aWRpYS1tbC1weTM=",highlighted:"pip install transformers datasets accelerate nvidia-ml-py3",wrap:!1}}),g=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQSUwQXNlcV9sZW4lMkMlMjBkYXRhc2V0X3NpemUlMjAlM0QlMjA1MTIlMkMlMjA1MTIlMEFkdW1teV9kYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5wdXRfaWRzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMTAwJTJDJTIwMzAwMDAlMkMlMjAoZGF0YXNldF9zaXplJTJDJTIwc2VxX2xlbikpJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMCUyQyUyMDElMkMlMjAoZGF0YXNldF9zaXplKSklMkMlMEElN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGR1bW15X2RhdGEpJTBBZHMuc2V0X2Zvcm1hdCglMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span>seq_len, dataset_size = <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dummy_data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;input_ids&quot;</span>: np.random.randint(<span class="hljs-number">100</span>, <span class="hljs-number">30000</span>, (dataset_size, seq_len)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;labels&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, (dataset_size)),
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(dummy_data)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds.set_format(<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),b=new w({props:{code:"ZnJvbSUyMHB5bnZtbCUyMGltcG9ydCUyMColMEElMEElMEFkZWYlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKSUzQSUwQSUyMCUyMCUyMCUyMG52bWxJbml0KCklMEElMjAlMjAlMjAlMjBoYW5kbGUlMjAlM0QlMjBudm1sRGV2aWNlR2V0SGFuZGxlQnlJbmRleCgwKSUwQSUyMCUyMCUyMCUyMGluZm8lMjAlM0QlMjBudm1sRGV2aWNlR2V0TWVtb3J5SW5mbyhoYW5kbGUpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG1lbW9yeSUyMG9jY3VwaWVkJTNBJTIwJTdCaW5mby51c2VkJTJGJTJGMTAyNCoqMiU3RCUyME1CLiUyMiklMEElMEElMEFkZWYlMjBwcmludF9zdW1tYXJ5KHJlc3VsdCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGltZSUzQSUyMCU3QnJlc3VsdC5tZXRyaWNzJTVCJ3RyYWluX3J1bnRpbWUnJTVEJTNBLjJmJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGVzJTJGc2Vjb25kJTNBJTIwJTdCcmVzdWx0Lm1ldHJpY3MlNUIndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyU1RCUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pynvml <span class="hljs-keyword">import</span> *


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_gpu_utilization</span>():
<span class="hljs-meta">... </span>    nvmlInit()
<span class="hljs-meta">... </span>    handle = nvmlDeviceGetHandleByIndex(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    info = nvmlDeviceGetMemoryInfo(handle)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory occupied: <span class="hljs-subst">{info.used//<span class="hljs-number">1024</span>**<span class="hljs-number">2</span>}</span> MB.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_summary</span>(<span class="hljs-params">result</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_runtime&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Samples/second: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    print_gpu_utilization()`,wrap:!1}}),h=new w({props:{code:"cHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">0</span> MB.`,wrap:!1}}),Q=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEF0b3JjaC5vbmVzKCgxJTJDJTIwMSkpLnRvKCUyMmN1ZGElMjIpJTBBcHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>torch.ones((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">1343</span> MB.`,wrap:!1}}),$=new Ie({props:{title:"Cargar el Modelo",local:"cargar-el-modelo",headingTag:"h2"}}),x=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1sYXJnZS11bmNhc2VkJTIyKS50byglMjJjdWRhJTIyKSUwQXByaW50X2dwdV91dGlsaXphdGlvbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification


<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">2631</span> MB.`,wrap:!1}}),E=new w({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),P=new w({props:{code:"VHVlJTIwSmFuJTIwMTElMjAwOCUzQTU4JTNBMDUlMjAyMDIyJTBBJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkIlMEElN0MlMjBOVklESUEtU01JJTIwNDYwLjkxLjAzJTIwJTIwJTIwJTIwRHJpdmVyJTIwVmVyc2lvbiUzQSUyMDQ2MC45MS4wMyUyMCUyMCUyMCUyMENVREElMjBWZXJzaW9uJTNBJTIwMTEuMiUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3Qy0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkItLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSU3QyUyMEdQVSUyMCUyME5hbWUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQZXJzaXN0ZW5jZS1NJTdDJTIwQnVzLUlkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGlzcC5BJTIwJTdDJTIwVm9sYXRpbGUlMjBVbmNvcnIuJTIwRUNDJTIwJTdDJTBBJTdDJTIwRmFuJTIwJTIwVGVtcCUyMCUyMFBlcmYlMjAlMjBQd3IlM0FVc2FnZSUyRkNhcCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1lbW9yeS1Vc2FnZSUyMCU3QyUyMEdQVS1VdGlsJTIwJTIwQ29tcHV0ZSUyME0uJTIwJTdDJTBBJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTUlHJTIwTS4lMjAlN0MlMEElN0MlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMkIlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMkIlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlN0MlMEElN0MlMjAlMjAlMjAwJTIwJTIwVGVzbGElMjBWMTAwLVNYTTIuLi4lMjAlMjBPbiUyMCUyMCUyMCU3QyUyMDAwMDAwMDAwJTNBMDAlM0EwNC4wJTIwT2ZmJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyMCU3QyUwQSU3QyUyME4lMkZBJTIwJTIwJTIwMzdDJTIwJTIwJTIwJTIwUDAlMjAlMjAlMjAlMjAzOVclMjAlMkYlMjAzMDBXJTIwJTdDJTIwJTIwJTIwMjYzMU1pQiUyMCUyRiUyMDE2MTYwTWlCJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwMCUyNSUyMCUyMCUyMCUyMCUyMCUyMERlZmF1bHQlMjAlN0MlMEElN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOJTJGQSUyMCU3QyUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkItLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCJTBBJTdDJTIwUHJvY2Vzc2VzJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwR1BVJTIwJTIwJTIwR0klMjAlMjAlMjBDSSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFBJRCUyMCUyMCUyMFR5cGUlMjAlMjAlMjBQcm9jZXNzJTIwbmFtZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdQVSUyME1lbW9yeSUyMCU3QyUwQSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElEJTIwJTIwJTIwSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVc2FnZSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCU3QyUwQSU3QyUyMCUyMCUyMCUyMDAlMjAlMjAlMjBOJTJGQSUyMCUyME4lMkZBJTIwJTIwJTIwJTIwJTIwJTIwMzcyMSUyMCUyMCUyMCUyMCUyMCUyMEMlMjAlMjAlMjAuLi5udnMlMkZjb2RlcGFycm90JTJGYmluJTJGcHl0aG9uJTIwJTIwJTIwJTIwJTIwMjYyOU1pQiUyMCU3QyUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJC",highlighted:`Tue Jan 11 08:58:05 2022
+-----------------------------------------------------------------------------+
| NVIDIA-SMI 460.91.03    Driver Version: 460.91.03    CUDA Version: 11.2     |
|-------------------------------+----------------------+----------------------+
| GPU  Name        Persistence-M| Bus-Id        Disp.A | Volatile Uncorr. ECC |
| Fan  Temp  Perf  Pwr:Usage/Cap|         Memory-Usage | GPU-Util  Compute M. |
|                               |                      |               MIG M. |
|===============================+======================+======================|
|   0  Tesla V100-SXM2...  On   | 00000000:00:04.0 Off |                    0 |
| N/A   37C    P0    39W / 300W |   2631MiB / 16160MiB |      0%      Default |
|                               |                      |                  N/A |
+-------------------------------+----------------------+----------------------+

+-----------------------------------------------------------------------------+
| Processes:                                                                  |
|  GPU   GI   CI        PID   Type   Process name                  GPU Memory |
|        ID   ID                                                   Usage      |
|=============================================================================|
|    0   N/A  N/A      3721      C   ...nvs/codeparrot/bin/python     2629MiB |
+-----------------------------------------------------------------------------+`,wrap:!1}}),V=new w({props:{code:"ZGVmYXVsdF9hcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0X2RpciUyMiUzQSUyMCUyMnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc3RyYXRlZ3klMjIlM0ElMjAlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV90cmFpbl9lcG9jaHMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybG9nX2xldmVsJTIyJTNBJTIwJTIyZXJyb3IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBvcnRfdG8lMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTdE",highlighted:`default_args = {
    <span class="hljs-string">&quot;output_dir&quot;</span>: <span class="hljs-string">&quot;tmp&quot;</span>,
    <span class="hljs-string">&quot;eval_strategy&quot;</span>: <span class="hljs-string">&quot;steps&quot;</span>,
    <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;log_level&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
    <span class="hljs-string">&quot;report_to&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
}`,wrap:!1}}),U=new yl({props:{$$slots:{default:[Cl]},$$scope:{ctx:fe}}}),k=new Ie({props:{title:"Utilización de la memoria en el entrenamiento",local:"utilización-de-la-memoria-en-el-entrenamiento",headingTag:"h2"}}),Z=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUyQyUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKSUwQSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3MpJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzKSUwQXJlc3VsdCUyMCUzRCUyMHRyYWluZXIudHJhaW4oKSUwQXByaW50X3N1bW1hcnkocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer, logging

<span class="hljs-meta">&gt;&gt;&gt; </span>logging.set_verbosity_error()


<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(model=model, args=training_args, train_dataset=ds)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = trainer.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>print_summary(result)`,wrap:!1}}),H=new w({props:{code:"VGltZSUzQSUyMDU3LjgyJTBBU2FtcGxlcyUyRnNlY29uZCUzQSUyMDguODYlMEFHUFUlMjBtZW1vcnklMjBvY2N1cGllZCUzQSUyMDE0OTQ5JTIwTUIu",highlighted:`<span class="hljs-keyword">Time:</span> 57.82
Samples/second: 8.86
GPU memory occupied: 14949 MB.`,wrap:!1}}),N=new Ie({props:{title:"Anatomía de las Operaciones del Modelo",local:"anatomía-de-las-operaciones-del-modelo",headingTag:"h2"}}),K=new Ie({props:{title:"Anatomía de la Memoria del Modelo",local:"anatomía-de-la-memoria-del-modelo",headingTag:"h2"}}),ye=new jl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/model_memory_anatomy.md"}}),{c(){T=i("meta"),y=s(),J=i("p"),je=s(),m(j.$$.fragment),Ae=s(),C=i("p"),C.textContent=gt,Se=s(),I=i("p"),I.textContent=Lt,ge=s(),m(f.$$.fragment),Le=s(),A=i("p"),A.innerHTML=bt,be=s(),S=i("p"),S.innerHTML=zt,ze=s(),m(g.$$.fragment),he=s(),L=i("p"),L.innerHTML=ht,ve=s(),m(b.$$.fragment),Qe=s(),z=i("p"),z.textContent=vt,Re=s(),m(h.$$.fragment),$e=s(),v=i("p"),v.textContent=Qt,Ge=s(),m(Q.$$.fragment),xe=s(),R=i("p"),R.textContent=Rt,_e=s(),m($.$$.fragment),Ee=s(),G=i("p"),G.innerHTML=$t,Pe=s(),m(x.$$.fragment),Be=s(),_=i("p"),_.innerHTML=Gt,Ve=s(),m(E.$$.fragment),ke=s(),m(P.$$.fragment),qe=s(),B=i("p"),B.textContent=xt,Ze=s(),m(V.$$.fragment),He=s(),m(U.$$.fragment),We=s(),m(k.$$.fragment),Ne=s(),q=i("p"),q.innerHTML=_t,Xe=s(),m(Z.$$.fragment),De=s(),m(H.$$.fragment),Fe=s(),W=i("p"),W.textContent=Et,Ye=s(),m(N.$$.fragment),Ke=s(),X=i("p"),X.textContent=Pt,Oe=s(),D=i("ol"),D.innerHTML=Bt,et=s(),F=i("p"),F.textContent=Vt,tt=s(),Y=i("p"),Y.innerHTML=kt,lt=s(),m(K.$$.fragment),at=s(),O=i("p"),O.textContent=qt,st=s(),ee=i("ol"),ee.innerHTML=Zt,nt=s(),te=i("p"),te.textContent=Ht,it=s(),le=i("p"),le.textContent=Wt,ot=s(),ae=i("p"),ae.innerHTML=Nt,rt=s(),se=i("ul"),se.innerHTML=Xt,mt=s(),ne=i("p"),ne.innerHTML=Dt,Mt=s(),ie=i("ul"),ie.innerHTML=Ft,pt=s(),oe=i("p"),oe.innerHTML=Yt,dt=s(),re=i("ul"),re.innerHTML=Kt,ct=s(),me=i("p"),me.innerHTML=Ot,ut=s(),Me=i("ul"),Me.innerHTML=el,Tt=s(),pe=i("p"),pe.innerHTML=tl,Jt=s(),de=i("p"),de.innerHTML=ll,wt=s(),ce=i("p"),ce.textContent=al,Ut=s(),ue=i("p"),ue.innerHTML=sl,yt=s(),Te=i("p"),Te.textContent=nl,jt=s(),Je=i("p"),Je.innerHTML=il,Ct=s(),we=i("p"),we.innerHTML=ol,It=s(),Ue=i("p"),Ue.innerHTML=rl,ft=s(),m(ye.$$.fragment),At=s(),Ce=i("p"),this.h()},l(e){const t=wl("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=n(e),J=o(e,"P",{}),Ml(J).forEach(l),je=n(e),M(j.$$.fragment,e),Ae=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1u3l1vf"&&(C.textContent=gt),Se=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-zaihpz"&&(I.textContent=Lt),ge=n(e),M(f.$$.fragment,e),Le=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-128nk8t"&&(A.innerHTML=bt),be=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ldlc9p"&&(S.innerHTML=zt),ze=n(e),M(g.$$.fragment,e),he=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-b5n9g9"&&(L.innerHTML=ht),ve=n(e),M(b.$$.fragment,e),Qe=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tk9h60"&&(z.textContent=vt),Re=n(e),M(h.$$.fragment,e),$e=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-15av7js"&&(v.textContent=Qt),Ge=n(e),M(Q.$$.fragment,e),xe=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1lugkf0"&&(R.textContent=Rt),_e=n(e),M($.$$.fragment,e),Ee=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1l1yt22"&&(G.innerHTML=$t),Pe=n(e),M(x.$$.fragment,e),Be=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-gx2my2"&&(_.innerHTML=Gt),Ve=n(e),M(E.$$.fragment,e),ke=n(e),M(P.$$.fragment,e),qe=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ihlyji"&&(B.textContent=xt),Ze=n(e),M(V.$$.fragment,e),He=n(e),M(U.$$.fragment,e),We=n(e),M(k.$$.fragment,e),Ne=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1y4c0kp"&&(q.innerHTML=_t),Xe=n(e),M(Z.$$.fragment,e),De=n(e),M(H.$$.fragment,e),Fe=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-zma0ww"&&(W.textContent=Et),Ye=n(e),M(N.$$.fragment,e),Ke=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-u9ol0g"&&(X.textContent=Pt),Oe=n(e),D=o(e,"OL",{"data-svelte-h":!0}),r(D)!=="svelte-1nh733x"&&(D.innerHTML=Bt),et=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-s2v38z"&&(F.textContent=Vt),tt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-xtlxys"&&(Y.innerHTML=kt),lt=n(e),M(K.$$.fragment,e),at=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1tdy7v2"&&(O.textContent=qt),st=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-y7tmdj"&&(ee.innerHTML=Zt),nt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1se9g5t"&&(te.textContent=Ht),it=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1pj1uhu"&&(le.textContent=Wt),ot=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-18vig8m"&&(ae.innerHTML=Nt),rt=n(e),se=o(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-1dz5i2d"&&(se.innerHTML=Xt),mt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1h0il29"&&(ne.innerHTML=Dt),Mt=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1951j4h"&&(ie.innerHTML=Ft),pt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1rlfp1l"&&(oe.innerHTML=Yt),dt=n(e),re=o(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-1lavlwz"&&(re.innerHTML=Kt),ct=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1d36pu6"&&(me.innerHTML=Ot),ut=n(e),Me=o(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-9a87j2"&&(Me.innerHTML=el),Tt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1cw0vgy"&&(pe.innerHTML=tl),Jt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-fq0cxx"&&(de.innerHTML=ll),wt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-wv7qt1"&&(ce.textContent=al),Ut=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-mv1xjr"&&(ue.innerHTML=sl),yt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-188lrm3"&&(Te.textContent=nl),jt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-btgv3n"&&(Je.innerHTML=il),Ct=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1q0j08"&&(we.innerHTML=ol),It=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-t9y5o1"&&(Ue.innerHTML=rl),ft=n(e),M(ye.$$.fragment,e),At=n(e),Ce=o(e,"P",{}),Ml(Ce).forEach(l),this.h()},h(){pl(T,"name","hf:doc:metadata"),pl(T,"content",fl)},m(e,t){Ul(document.head,T),a(e,y,t),a(e,J,t),a(e,je,t),p(j,e,t),a(e,Ae,t),a(e,C,t),a(e,Se,t),a(e,I,t),a(e,ge,t),p(f,e,t),a(e,Le,t),a(e,A,t),a(e,be,t),a(e,S,t),a(e,ze,t),p(g,e,t),a(e,he,t),a(e,L,t),a(e,ve,t),p(b,e,t),a(e,Qe,t),a(e,z,t),a(e,Re,t),p(h,e,t),a(e,$e,t),a(e,v,t),a(e,Ge,t),p(Q,e,t),a(e,xe,t),a(e,R,t),a(e,_e,t),p($,e,t),a(e,Ee,t),a(e,G,t),a(e,Pe,t),p(x,e,t),a(e,Be,t),a(e,_,t),a(e,Ve,t),p(E,e,t),a(e,ke,t),p(P,e,t),a(e,qe,t),a(e,B,t),a(e,Ze,t),p(V,e,t),a(e,He,t),p(U,e,t),a(e,We,t),p(k,e,t),a(e,Ne,t),a(e,q,t),a(e,Xe,t),p(Z,e,t),a(e,De,t),p(H,e,t),a(e,Fe,t),a(e,W,t),a(e,Ye,t),p(N,e,t),a(e,Ke,t),a(e,X,t),a(e,Oe,t),a(e,D,t),a(e,et,t),a(e,F,t),a(e,tt,t),a(e,Y,t),a(e,lt,t),p(K,e,t),a(e,at,t),a(e,O,t),a(e,st,t),a(e,ee,t),a(e,nt,t),a(e,te,t),a(e,it,t),a(e,le,t),a(e,ot,t),a(e,ae,t),a(e,rt,t),a(e,se,t),a(e,mt,t),a(e,ne,t),a(e,Mt,t),a(e,ie,t),a(e,pt,t),a(e,oe,t),a(e,dt,t),a(e,re,t),a(e,ct,t),a(e,me,t),a(e,ut,t),a(e,Me,t),a(e,Tt,t),a(e,pe,t),a(e,Jt,t),a(e,de,t),a(e,wt,t),a(e,ce,t),a(e,Ut,t),a(e,ue,t),a(e,yt,t),a(e,Te,t),a(e,jt,t),a(e,Je,t),a(e,Ct,t),a(e,we,t),a(e,It,t),a(e,Ue,t),a(e,ft,t),p(ye,e,t),a(e,At,t),a(e,Ce,t),St=!0},p(e,[t]){const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),U.$set(ml)},i(e){St||(d(j.$$.fragment,e),d(f.$$.fragment,e),d(g.$$.fragment,e),d(b.$$.fragment,e),d(h.$$.fragment,e),d(Q.$$.fragment,e),d($.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(V.$$.fragment,e),d(U.$$.fragment,e),d(k.$$.fragment,e),d(Z.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(K.$$.fragment,e),d(ye.$$.fragment,e),St=!0)},o(e){c(j.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(b.$$.fragment,e),c(h.$$.fragment,e),c(Q.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(P.$$.fragment,e),c(V.$$.fragment,e),c(U.$$.fragment,e),c(k.$$.fragment,e),c(Z.$$.fragment,e),c(H.$$.fragment,e),c(N.$$.fragment,e),c(K.$$.fragment,e),c(ye.$$.fragment,e),St=!1},d(e){e&&(l(y),l(J),l(je),l(Ae),l(C),l(Se),l(I),l(ge),l(Le),l(A),l(be),l(S),l(ze),l(he),l(L),l(ve),l(Qe),l(z),l(Re),l($e),l(v),l(Ge),l(xe),l(R),l(_e),l(Ee),l(G),l(Pe),l(Be),l(_),l(Ve),l(ke),l(qe),l(B),l(Ze),l(He),l(We),l(Ne),l(q),l(Xe),l(De),l(Fe),l(W),l(Ye),l(Ke),l(X),l(Oe),l(D),l(et),l(F),l(tt),l(Y),l(lt),l(at),l(O),l(st),l(ee),l(nt),l(te),l(it),l(le),l(ot),l(ae),l(rt),l(se),l(mt),l(ne),l(Mt),l(ie),l(pt),l(oe),l(dt),l(re),l(ct),l(me),l(ut),l(Me),l(Tt),l(pe),l(Jt),l(de),l(wt),l(ce),l(Ut),l(ue),l(yt),l(Te),l(jt),l(Je),l(Ct),l(we),l(It),l(Ue),l(ft),l(At),l(Ce)),l(T),u(j,e),u(f,e),u(g,e),u(b,e),u(h,e),u(Q,e),u($,e),u(x,e),u(E,e),u(P,e),u(V,e),u(U,e),u(k,e),u(Z,e),u(H,e),u(N,e),u(K,e),u(ye,e)}}}const fl='{"title":"Anatomía del entrenamiento de los modelos","local":"anatomía-del-entrenamiento-de-los-modelos","sections":[{"title":"Cargar el Modelo","local":"cargar-el-modelo","sections":[],"depth":2},{"title":"Utilización de la memoria en el entrenamiento","local":"utilización-de-la-memoria-en-el-entrenamiento","sections":[],"depth":2},{"title":"Anatomía de las Operaciones del Modelo","local":"anatomía-de-las-operaciones-del-modelo","sections":[],"depth":2},{"title":"Anatomía de la Memoria del Modelo","local":"anatomía-de-la-memoria-del-modelo","sections":[],"depth":2}],"depth":1}';function Al(fe){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Tl{constructor(T){super(),Jl(this,T,Al,Il,dl,{})}}export{hl as component};
