import{s as mt,y as ht,o as dt}from"../chunks/scheduler.d6170356.js";import{S as ft,i as ut,g as n,s as l,r as m,A as gt,h as o,f as s,c as i,j as Qe,u as h,x as r,k as M,y as wt,a,v as d,d as f,t as u,w as g,m as Mt,n as yt}from"../chunks/index.fcd4cc08.js";import{T as Tt}from"../chunks/Tip.b09c67cf.js";import{C as se}from"../chunks/CodeBlock.7b16bdef.js";import{H as ee}from"../chunks/Heading.8660bd0e.js";function bt(ae){let p;return{c(){p=Mt("Only port 8501 is allowed for Streamlit Spaces (default port). As a result if you provide a `config.toml` file for your Space make sure the default port is not overriden.")},l(w){p=yt(w,"Only port 8501 is allowed for Streamlit Spaces (default port). As a result if you provide a `config.toml` file for your Space make sure the default port is not overriden.")},m(w,b){a(w,p,b)},d(w){w&&s(p)}}}function jt(ae){let p,w,b,le,j,ie,J,Ge='<strong>Streamlit</strong> gives users freedom to build a full-featured web app with Python in a <em>reactive</em> way. Your code is rerun each time the state of the app changes. Streamlit is also great for data visualization and supports several charting libraries such as Bokeh, Plotly, and Altair. Read this <a href="https://huggingface.co/blog/streamlit-spaces" rel="nofollow">blog post</a> about building and hosting Streamlit apps in Spaces.',ne,S,Ye='Selecting <strong>Streamlit</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Space with the latest version of Streamlit by setting the <code>sdk</code> property to <code>streamlit</code> in your <code>README.md</code> file’s YAML block. If you’d like to change the Streamlit version, you can edit the <code>sdk_version</code> property.',oe,$,qe='To use Streamlit in a Space, select <strong>Streamlit</strong> as the SDK when you create a Space through the <a href="https://huggingface.co/new-space" rel="nofollow"><strong>New Space</strong> form</a>. This will create a repository with a <code>README.md</code> that contains the following properties in the YAML configuration block:',re,v,pe,U,Ee='You can edit the <code>sdk_version</code>, but note that issues may occur when you use an unsupported Streamlit version. Not all Streamlit versions are supported, so please refer to the <a href="./spaces-config-reference">reference section</a> to see which versions are available.',ce,I,Fe='For in-depth information about Streamlit, refer to the <a href="https://docs.streamlit.io/" rel="nofollow">Streamlit documentation</a>.',me,y,he,Z,de,B,Ae='In the following sections, you’ll learn the basics of creating a Space, configuring it, and deploying your code to it. We’ll create a <strong>Hot Dog Classifier</strong> Space with Streamlit that’ll be used to demo the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which can detect whether a given picture contains a hot dog 🌭',fe,k,Pe='You can find a completed version of this hosted at <a href="https://huggingface.co/spaces/NimaBoscarino/hotdog-streamlit" rel="nofollow">NimaBoscarino/hotdog-streamlit</a>.',ue,W,ge,H,Xe='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Streamlit</strong> as our SDK. Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing.',we,L,Me,_,De='For the <strong>Hot Dog Classifier</strong> we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model, so we need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',ye,C,Te,z,Ve="The Spaces runtime will handle installing the dependencies!",be,x,je,N,Ke="To create the Streamlit app, make a new file in the repository called <strong>app.py</strong>, and add the following code:",Je,R,Se,Q,Oe='This Python script uses a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to load the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which is used by the Streamlit interface. The Streamlit app will expect you to upload an image, which it’ll then classify as <em>hot dog</em> or <em>not hot dog</em>. Once you’ve saved the code to the <strong>app.py</strong> file, visit the <strong>App</strong> tab to see your app in action!',$e,T,et='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit-dark.png"/>',ve,G,Ue,Y,tt="You can use the HTML <code>&lt;iframe&gt;</code> tag to embed a Streamlit Space as an inline frame on other webpages. Simply include the URL of your Space, ending with the <code>.hf.space</code> suffix. To find the URL of your Space, you can use the “Embed this Space” button from the Spaces options.",Ie,q,st="For example, the demo above can be embedded in these docs with the following tag:",Ze,E,Be,c,at,ke,F,lt="Please note that we have added <code>?embed=true</code> to the URL, which activates the embed mode of the Streamlit app, removing some spacers and the footer for slim embeds.",We,A,He,P,it='Streamlit has supported automatic iframe resizing since <a href="https://docs.streamlit.io/library/changelog#version-1170" rel="nofollow">1.17.0</a> so that the size of the parent iframe is automatically adjusted to fit the content volume of the embedded Streamlit application.',Le,X,nt='It relies on the <a href="https://github.com/davidjbradshaw/iframe-resizer" rel="nofollow"><code>iFrame Resizer</code></a> library, for which you need to add a few lines of code, as in the following example where',_e,D,ot="<li><code>id</code> is set to <code>&lt;iframe /&gt;</code> that is used to specify the auto-resize target.</li> <li>The <code>iFrame Resizer</code> is loaded via the <code>script</code> tag.</li> <li>The <code>iFrameResize()</code> function is called with the ID of the target <code>iframe</code> element, so that its size changes automatically.</li>",Ce,V,rt='We can pass options to the first argument of <code>iFrameResize()</code>. See <a href="https://github.com/davidjbradshaw/iframe-resizer/blob/master/docs/parent_page/options.md" rel="nofollow">the document</a> for the details.',ze,K,xe,O,pt='Additionally, you can checkout <a href="./spaces-embed">our documentation</a>.',Ne,te,Re;return j=new ee({props:{title:"Streamlit Spaces",local:"streamlit-spaces",headingTag:"h1"}}),v=new se({props:{code:"c2RrJTNBJTIwc3RyZWFtbGl0JTBBc2RrX3ZlcnNpb24lM0ElMjAxLjI1LjAlMjAlMjMlMjBUaGUlMjBsYXRlc3QlMjBzdXBwb3J0ZWQlMjB2ZXJzaW9u",highlighted:`<span class="hljs-attr">sdk:</span> <span class="hljs-string">streamlit</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">1.25</span><span class="hljs-number">.0</span> <span class="hljs-comment"># The latest supported version</span>`,wrap:!1}}),y=new Tt({props:{warning:!0,$$slots:{default:[bt]},$$scope:{ctx:ae}}}),Z=new ee({props:{title:"Your First Streamlit Space: Hot Dog Classifier",local:"your-first-streamlit-space-hot-dog-classifier",headingTag:"h2"}}),W=new ee({props:{title:"Create a new Streamlit Space",local:"create-a-new-streamlit-space",headingTag:"h2"}}),L=new ee({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),C=new se({props:{code:"dHJhbnNmb3JtZXJzJTBBdG9yY2g=",highlighted:`<span class="hljs-attribute">transformers
torch</span>`,wrap:!1}}),x=new ee({props:{title:"Create the Streamlit app",local:"create-the-streamlit-app",headingTag:"h2"}}),R=new se({props:{code:"aW1wb3J0JTIwc3RyZWFtbGl0JTIwYXMlMjBzdCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRmhvdGRvZy1ub3QtaG90ZG9nJTIyKSUwQSUwQXN0LnRpdGxlKCUyMkhvdCUyMERvZyUzRiUyME9yJTIwTm90JTNGJTIyKSUwQSUwQWZpbGVfbmFtZSUyMCUzRCUyMHN0LmZpbGVfdXBsb2FkZXIoJTIyVXBsb2FkJTIwYSUyMGhvdCUyMGRvZyUyMGNhbmRpZGF0ZSUyMGltYWdlJTIyKSUwQSUwQWlmJTIwZmlsZV9uYW1lJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwY29sMSUyQyUyMGNvbDIlMjAlM0QlMjBzdC5jb2x1bW5zKDIpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGZpbGVfbmFtZSklMEElMjAlMjAlMjAlMjBjb2wxLmltYWdlKGltYWdlJTJDJTIwdXNlX2NvbHVtbl93aWR0aCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSklMEElMEElMjAlMjAlMjAlMjBjb2wyLmhlYWRlciglMjJQcm9iYWJpbGl0aWVzJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMHAlMjBpbiUyMHByZWRpY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sMi5zdWJoZWFkZXIoZiUyMiU3QiUyMHAlNUInbGFiZWwnJTVEJTIwJTdEJTNBJTIwJTdCJTIwcm91bmQocCU1QidzY29yZSclNUQlMjAqJTIwMTAwJTJDJTIwMSklN0QlMjUlMjIp",highlighted:`<span class="hljs-keyword">import</span> streamlit <span class="hljs-keyword">as</span> st
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;julien-c/hotdog-not-hotdog&quot;</span>)

st.title(<span class="hljs-string">&quot;Hot Dog? Or Not?&quot;</span>)

file_name = st.file_uploader(<span class="hljs-string">&quot;Upload a hot dog candidate image&quot;</span>)

<span class="hljs-keyword">if</span> file_name <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    col1, col2 = st.columns(<span class="hljs-number">2</span>)

    image = Image.<span class="hljs-built_in">open</span>(file_name)
    col1.image(image, use_column_width=<span class="hljs-literal">True</span>)
    predictions = pipeline(image)

    col2.header(<span class="hljs-string">&quot;Probabilities&quot;</span>)
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> predictions:
        col2.subheader(<span class="hljs-string">f&quot;<span class="hljs-subst">{ p[<span class="hljs-string">&#x27;label&#x27;</span>] }</span>: <span class="hljs-subst">{ <span class="hljs-built_in">round</span>(p[<span class="hljs-string">&#x27;score&#x27;</span>] * <span class="hljs-number">100</span>, <span class="hljs-number">1</span>)}</span>%&quot;</span>)`,wrap:!1}}),G=new ee({props:{title:"Embed Streamlit Spaces on other webpages",local:"embed-streamlit-spaces-on-other-webpages",headingTag:"h2"}}),E=new se({props:{code:"JTNDaWZyYW1lJTBBJTIwJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZOaW1hQm9zY2FyaW5vLWhvdGRvZy1zdHJlYW1saXQuaGYuc3BhY2UlM0ZlbWJlZCUzRHRydWUlMjIlMEElMjAlMjB0aXRsZSUzRCUyMk15JTIwYXdlc29tZSUyMFN0cmVhbWxpdCUyMFNwYWNlJTIyJTBBJTNFJTNDJTJGaWZyYW1lJTNF",highlighted:`&lt;iframe
  src<span class="hljs-operator">=</span><span class="hljs-string">&quot;https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true&quot;</span>
  title<span class="hljs-operator">=</span><span class="hljs-string">&quot;My awesome Streamlit Space&quot;</span>
&gt;&lt;/iframe&gt;`,wrap:!1}}),A=new ee({props:{title:"Embed Streamlit Spaces with auto-resizing IFrames",local:"embed-streamlit-spaces-with-auto-resizing-iframes",headingTag:"h2"}}),K=new se({props:{code:"JTNDaWZyYW1lJTBBJTA5aWQlM0QlMjJ5b3VyLWlmcmFtZS1pZCUyMiUwQSUwOXNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGJTNDc3BhY2Utc3ViZG9tYWluJTNFLmhmLnNwYWNlJTIyJTBBJTA5ZnJhbWVib3JkZXIlM0QlMjIwJTIyJTBBJTA5d2lkdGglM0QlMjI4NTAlMjIlMEElMDloZWlnaHQlM0QlMjI0NTAlMjIlMEElM0UlM0MlMkZpZnJhbWUlM0UlMEElM0NzY3JpcHQlMjBzcmMlM0QlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkZpZnJhbWUtcmVzaXplciU0MDQuMy40JTJGanMlMkZpZnJhbWVSZXNpemVyLm1pbi5qcyUyMiUzRSUzQyUyRnNjcmlwdCUzRSUwQSUzQ3NjcmlwdCUzRSUwQSUyMCUyMGlGcmFtZVJlc2l6ZSglN0IlN0QlMkMlMjAlMjIlMjN5b3VyLWlmcmFtZS1pZCUyMiklMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">iframe</span>
	<span class="hljs-attr">id</span>=<span class="hljs-string">&quot;your-iframe-id&quot;</span>
	<span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://&lt;space-subdomain&gt;.hf.space&quot;</span>
	<span class="hljs-attr">frameborder</span>=<span class="hljs-string">&quot;0&quot;</span>
	<span class="hljs-attr">width</span>=<span class="hljs-string">&quot;850&quot;</span>
	<span class="hljs-attr">height</span>=<span class="hljs-string">&quot;450&quot;</span>
&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">iframe</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/iframe-resizer@4.3.4/js/iframeResizer.min.js&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span>&gt;</span><span class="language-javascript">
  <span class="hljs-title function_">iFrameResize</span>({}, <span class="hljs-string">&quot;#your-iframe-id&quot;</span>)
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),{c(){p=n("meta"),w=l(),b=n("p"),le=l(),m(j.$$.fragment),ie=l(),J=n("p"),J.innerHTML=Ge,ne=l(),S=n("p"),S.innerHTML=Ye,oe=l(),$=n("p"),$.innerHTML=qe,re=l(),m(v.$$.fragment),pe=l(),U=n("p"),U.innerHTML=Ee,ce=l(),I=n("p"),I.innerHTML=Fe,me=l(),m(y.$$.fragment),he=l(),m(Z.$$.fragment),de=l(),B=n("p"),B.innerHTML=Ae,fe=l(),k=n("p"),k.innerHTML=Pe,ue=l(),m(W.$$.fragment),ge=l(),H=n("p"),H.innerHTML=Xe,we=l(),m(L.$$.fragment),Me=l(),_=n("p"),_.innerHTML=De,ye=l(),m(C.$$.fragment),Te=l(),z=n("p"),z.textContent=Ve,be=l(),m(x.$$.fragment),je=l(),N=n("p"),N.innerHTML=Ke,Je=l(),m(R.$$.fragment),Se=l(),Q=n("p"),Q.innerHTML=Oe,$e=l(),T=n("div"),T.innerHTML=et,ve=l(),m(G.$$.fragment),Ue=l(),Y=n("p"),Y.innerHTML=tt,Ie=l(),q=n("p"),q.textContent=st,Ze=l(),m(E.$$.fragment),Be=l(),c=n("iframe"),ke=l(),F=n("p"),F.innerHTML=lt,We=l(),m(A.$$.fragment),He=l(),P=n("p"),P.innerHTML=it,Le=l(),X=n("p"),X.innerHTML=nt,_e=l(),D=n("ul"),D.innerHTML=ot,Ce=l(),V=n("p"),V.innerHTML=rt,ze=l(),m(K.$$.fragment),xe=l(),O=n("p"),O.innerHTML=pt,Ne=l(),te=n("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=i(e),b=o(e,"P",{}),Qe(b).forEach(s),le=i(e),h(j.$$.fragment,e),ie=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-155nn9c"&&(J.innerHTML=Ge),ne=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-fhngw3"&&(S.innerHTML=Ye),oe=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1lndvi6"&&($.innerHTML=qe),re=i(e),h(v.$$.fragment,e),pe=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-rlzh8f"&&(U.innerHTML=Ee),ce=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1i51m04"&&(I.innerHTML=Fe),me=i(e),h(y.$$.fragment,e),he=i(e),h(Z.$$.fragment,e),de=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-w37as0"&&(B.innerHTML=Ae),fe=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1yuvt6i"&&(k.innerHTML=Pe),ue=i(e),h(W.$$.fragment,e),ge=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-7i2a6u"&&(H.innerHTML=Xe),we=i(e),h(L.$$.fragment,e),Me=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-12qvnza"&&(_.innerHTML=De),ye=i(e),h(C.$$.fragment,e),Te=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-pc1ide"&&(z.textContent=Ve),be=i(e),h(x.$$.fragment,e),je=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s8aj3m"&&(N.innerHTML=Ke),Je=i(e),h(R.$$.fragment,e),Se=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1lyf612"&&(Q.innerHTML=Oe),$e=i(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-10soa41"&&(T.innerHTML=et),ve=i(e),h(G.$$.fragment,e),Ue=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-h9u7cp"&&(Y.innerHTML=tt),Ie=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-m5fkq0"&&(q.textContent=st),Ze=i(e),h(E.$$.fragment,e),Be=i(e),c=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Qe(c).forEach(s),ke=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-190mgpd"&&(F.innerHTML=lt),We=i(e),h(A.$$.fragment,e),He=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1pycgf5"&&(P.innerHTML=it),Le=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1na14o1"&&(X.innerHTML=nt),_e=i(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-13i7z0x"&&(D.innerHTML=ot),Ce=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hn154n"&&(V.innerHTML=rt),ze=i(e),h(K.$$.fragment,e),xe=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-18gaz5u"&&(O.innerHTML=pt),Ne=i(e),te=o(e,"P",{}),Qe(te).forEach(s),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",Jt),M(T,"class","flex justify-center"),ht(c.src,at="https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true")||M(c,"src",at),M(c,"frameborder","0"),M(c,"height","364"),M(c,"title","Streamlit app"),M(c,"class","container p-0 flex-grow space-iframe"),M(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),M(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){wt(document.head,p),a(e,w,t),a(e,b,t),a(e,le,t),d(j,e,t),a(e,ie,t),a(e,J,t),a(e,ne,t),a(e,S,t),a(e,oe,t),a(e,$,t),a(e,re,t),d(v,e,t),a(e,pe,t),a(e,U,t),a(e,ce,t),a(e,I,t),a(e,me,t),d(y,e,t),a(e,he,t),d(Z,e,t),a(e,de,t),a(e,B,t),a(e,fe,t),a(e,k,t),a(e,ue,t),d(W,e,t),a(e,ge,t),a(e,H,t),a(e,we,t),d(L,e,t),a(e,Me,t),a(e,_,t),a(e,ye,t),d(C,e,t),a(e,Te,t),a(e,z,t),a(e,be,t),d(x,e,t),a(e,je,t),a(e,N,t),a(e,Je,t),d(R,e,t),a(e,Se,t),a(e,Q,t),a(e,$e,t),a(e,T,t),a(e,ve,t),d(G,e,t),a(e,Ue,t),a(e,Y,t),a(e,Ie,t),a(e,q,t),a(e,Ze,t),d(E,e,t),a(e,Be,t),a(e,c,t),a(e,ke,t),a(e,F,t),a(e,We,t),d(A,e,t),a(e,He,t),a(e,P,t),a(e,Le,t),a(e,X,t),a(e,_e,t),a(e,D,t),a(e,Ce,t),a(e,V,t),a(e,ze,t),d(K,e,t),a(e,xe,t),a(e,O,t),a(e,Ne,t),a(e,te,t),Re=!0},p(e,[t]){const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),y.$set(ct)},i(e){Re||(f(j.$$.fragment,e),f(v.$$.fragment,e),f(y.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),f(C.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),f(G.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),Re=!0)},o(e){u(j.$$.fragment,e),u(v.$$.fragment,e),u(y.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),Re=!1},d(e){e&&(s(w),s(b),s(le),s(ie),s(J),s(ne),s(S),s(oe),s($),s(re),s(pe),s(U),s(ce),s(I),s(me),s(he),s(de),s(B),s(fe),s(k),s(ue),s(ge),s(H),s(we),s(Me),s(_),s(ye),s(Te),s(z),s(be),s(je),s(N),s(Je),s(Se),s(Q),s($e),s(T),s(ve),s(Ue),s(Y),s(Ie),s(q),s(Ze),s(Be),s(c),s(ke),s(F),s(We),s(He),s(P),s(Le),s(X),s(_e),s(D),s(Ce),s(V),s(ze),s(xe),s(O),s(Ne),s(te)),s(p),g(j,e),g(v,e),g(y,e),g(Z,e),g(W,e),g(L,e),g(C,e),g(x,e),g(R,e),g(G,e),g(E,e),g(A,e),g(K,e)}}}const Jt='{"title":"Streamlit Spaces","local":"streamlit-spaces","sections":[{"title":"Your First Streamlit Space: Hot Dog Classifier","local":"your-first-streamlit-space-hot-dog-classifier","sections":[],"depth":2},{"title":"Create a new Streamlit Space","local":"create-a-new-streamlit-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the Streamlit app","local":"create-the-streamlit-app","sections":[],"depth":2},{"title":"Embed Streamlit Spaces on other webpages","local":"embed-streamlit-spaces-on-other-webpages","sections":[],"depth":2},{"title":"Embed Streamlit Spaces with auto-resizing IFrames","local":"embed-streamlit-spaces-with-auto-resizing-iframes","sections":[],"depth":2}],"depth":1}';function St(ae){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends ft{constructor(p){super(),ut(this,p,St,jt,mt,{})}}export{Bt as component};
