import{s as Ms,o as ms,n as k}from"../chunks/scheduler.01eeda35.js";import{S as cs,i as fs,g as f,s as i,r as y,A as ds,h as d,f as l,c as r,j as is,u as T,x as u,k as rs,y as us,a as n,v as w,d as J,t as h,w as U}from"../chunks/index.6dd51b66.js";import{T as be}from"../chunks/Tip.de9bae2b.js";import{C as g}from"../chunks/CodeBlock.864da1b0.js";import{H as $e,E as ys}from"../chunks/EditOnGithub.7faefd25.js";import{H as ps,a as gt}from"../chunks/HfOption.f7f04550.js";function Ts(C){let s,m="It may be easier to start from scratch if you’re creating an entirely new model. But for models that are very similar to an existing one in Transformers, it is faster to reuse or subclass the same configuration and model class.";return{c(){s=f("p"),s.textContent=m},l(a){s=d(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1fncjxx"&&(s.textContent=m)},m(a,M){n(a,s,M)},p:k,d(a){a&&l(s)}}}function ws(C){let s,m="It is useful to check the validity of some of the parameters. In the example below, a check is implemented to ensure <code>block_type</code> and <code>stem_type</code> belong to one of the predefined values.",a,M,o='Add <code>model_type</code> to the configuration class to enable <a href="./models#autoclass">AutoClass</a> support.';return{c(){s=f("p"),s.innerHTML=m,a=i(),M=f("p"),M.innerHTML=o},l(c){s=d(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1blxo10"&&(s.innerHTML=m),a=r(c),M=d(c,"P",{"data-svelte-h":!0}),u(M)!=="svelte-knjw4y"&&(M.innerHTML=o)},m(c,j){n(c,s,j),n(c,a,j),n(c,M,j)},p:k,d(c){c&&(l(s),l(a),l(M))}}}function Js(C){let s,m='Add <code>config_class</code> to the model class to enable <a href="#autoclass-support">AutoClass</a> support.';return{c(){s=f("p"),s.innerHTML=m},l(a){s=d(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-uz1anr"&&(s.innerHTML=m)},m(a,M){n(a,s,M)},p:k,d(a){a&&l(s)}}}function hs(C){let s,m="Define a mapping between the block types and classes. Everything else is created by passing the configuration class to the ResNet model class.",a,M,o,c,j;return M=new be({props:{warning:!1,$$slots:{default:[Js]},$$scope:{ctx:C}}}),c=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig

BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),{c(){s=f("p"),s.textContent=m,a=i(),y(M.$$.fragment),o=i(),y(c.$$.fragment)},l(p){s=d(p,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11rb22b"&&(s.textContent=m),a=r(p),T(M.$$.fragment,p),o=r(p),T(c.$$.fragment,p)},m(p,b){n(p,s,b),n(p,a,b),w(M,p,b),n(p,o,b),w(c,p,b),j=!0},p(p,b){const $={};b&2&&($.$$scope={dirty:b,ctx:p}),M.$set($)},i(p){j||(J(M.$$.fragment,p),J(c.$$.fragment,p),j=!0)},o(p){h(M.$$.fragment,p),h(c.$$.fragment,p),j=!1},d(p){p&&(l(s),l(a),l(o)),U(M,p),U(c,p)}}}function Us(C){let s,m='Add <code>config_class</code> to the model class to enable <a href="#autoclass-support">AutoClass</a> support.';return{c(){s=f("p"),s.innerHTML=m},l(a){s=d(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-uz1anr"&&(s.innerHTML=m)},m(a,M){n(a,s,M)},p:k,d(a){a&&l(s)}}}function js(C){let s,m="The <code>forward</code> method needs to be rewrittten to calculate the loss for each logit if labels are available. Otherwise, the ResNet model class is the same.",a,M,o,c,j;return M=new be({props:{warning:!1,$$slots:{default:[Us]},$$scope:{ctx:C}}}),c=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5jcm9zc19lbnRyb3B5KGxvZ2l0cyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb3NzJTIyJTNBJTIwbG9zcyUyQyUyMCUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RA==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.functional.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),{c(){s=f("p"),s.innerHTML=m,a=i(),y(M.$$.fragment),o=i(),y(c.$$.fragment)},l(p){s=d(p,"P",{"data-svelte-h":!0}),u(s)!=="svelte-qve8f4"&&(s.innerHTML=m),a=r(p),T(M.$$.fragment,p),o=r(p),T(c.$$.fragment,p)},m(p,b){n(p,s,b),n(p,a,b),w(M,p,b),n(p,o,b),w(c,p,b),j=!0},p(p,b){const $={};b&2&&($.$$scope={dirty:b,ctx:p}),M.$set($)},i(p){j||(J(M.$$.fragment,p),J(c.$$.fragment,p),j=!0)},o(p){h(M.$$.fragment,p),h(c.$$.fragment,p),j=!1},d(p){p&&(l(s),l(a),l(o)),U(M,p),U(c,p)}}}function Cs(C){let s,m,a,M;return s=new gt({props:{id:"resnet",option:"ResnetModel",$$slots:{default:[hs]},$$scope:{ctx:C}}}),a=new gt({props:{id:"resnet",option:"ResnetModelForImageClassification",$$slots:{default:[js]},$$scope:{ctx:C}}}),{c(){y(s.$$.fragment),m=i(),y(a.$$.fragment)},l(o){T(s.$$.fragment,o),m=r(o),T(a.$$.fragment,o)},m(o,c){w(s,o,c),n(o,m,c),w(a,o,c),M=!0},p(o,c){const j={};c&2&&(j.$$scope={dirty:c,ctx:o}),s.$set(j);const p={};c&2&&(p.$$scope={dirty:c,ctx:o}),a.$set(p)},i(o){M||(J(s.$$.fragment,o),J(a.$$.fragment,o),M=!0)},o(o){h(s.$$.fragment,o),h(a.$$.fragment,o),M=!1},d(o){o&&l(m),U(s,o),U(a,o)}}}function bs(C){let s,m='The first argument to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig.register">AutoConfig.register()</a> must match the <code>model_type</code> attribute in the custom configuration class, and the first argument to <code>AutoModel.register()</code> must match the <code>config_class</code> of the custom model class.';return{c(){s=f("p"),s.innerHTML=m},l(a){s=d(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-85qkln"&&(s.innerHTML=m)},m(a,M){n(a,s,M)},p:k,d(a){a&&l(s)}}}function gs(C){let s,m="When copying a Transformers’ model file, replace all relative imports at the top of the <code>modeling.py</code> file to import from Transformers instead.";return{c(){s=f("p"),s.innerHTML=m},l(a){s=d(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-u8ahuf"&&(s.innerHTML=m)},m(a,M){n(a,s,M)},p:k,d(a){a&&l(s)}}}function $s(C){let s,m;return s=new g({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),{c(){y(s.$$.fragment)},l(a){T(s.$$.fragment,a)},m(a,M){w(s,a,M),m=!0},p:k,i(a){m||(J(s.$$.fragment,a),m=!0)},o(a){h(s.$$.fragment,a),m=!1},d(a){U(s,a)}}}function _s(C){let s,m;return s=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),{c(){y(s.$$.fragment)},l(a){T(s.$$.fragment,a)},m(a,M){w(s,a,M),m=!0},p:k,i(a){m||(J(s.$$.fragment,a),m=!0)},o(a){h(s.$$.fragment,a),m=!1},d(a){U(s,a)}}}function Is(C){let s,m,a,M;return s=new gt({props:{id:"push",option:"huggingface-CLI",$$slots:{default:[$s]},$$scope:{ctx:C}}}),a=new gt({props:{id:"push",option:"notebook",$$slots:{default:[_s]},$$scope:{ctx:C}}}),{c(){y(s.$$.fragment),m=i(),y(a.$$.fragment)},l(o){T(s.$$.fragment,o),m=r(o),T(a.$$.fragment,o)},m(o,c){w(s,o,c),n(o,m,c),w(a,o,c),M=!0},p(o,c){const j={};c&2&&(j.$$scope={dirty:c,ctx:o}),s.$set(j);const p={};c&2&&(p.$$scope={dirty:c,ctx:o}),a.$set(p)},i(o){M||(J(s.$$.fragment,o),J(a.$$.fragment,o),M=!0)},o(o){h(s.$$.fragment,o),h(a.$$.fragment,o),M=!1},d(o){o&&l(m),U(s,o),U(a,o)}}}function Zs(C){let s,m,a,M,o,c,j,p='Transformers models are designed to be customizable. A models code is fully contained in the <a href="https://github.com/huggingface/transformers/tree/main/src/transformers/models" rel="nofollow">model</a> subfolder of the Transformers repository. Each folder contains a <code>modeling.py</code> and a <code>configuration.py</code> file. Copy these files to start customizing a model.',b,$,_e,B,$t='This guide will show you how to customize a ResNet model, enable <a href="./models#autoclass">AutoClass</a> support, and share it on the Hub.',Ie,N,Ze,R,_t='A configuration, given by the base <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> class, contains all the necessary information to build a model. This is where you’ll configure the attributes of the custom ResNet model. Different attributes gives different ResNet model types.',Ae,W,It="The main rules for customizing a configuration are:",ve,X,Zt='<li>A custom configuration must subclass <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This ensures a custom model has all the functionality of a Transformers’ model such as <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>, <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>, and <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>.</li> <li>The <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> <code>__init__</code> must accept any <code>kwargs</code> and they must be passed to the superclass <code>__init__</code>. <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> has more fields than the ones set in your custom configuration, so when you load a configuration with <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>, those fields need to be accepted by your configuration and passed to the superclass.</li>',ke,_,Be,G,Ne,Q,At='Save the configuration to a JSON file in your custom model folder, <code>custom-resnet</code>, with <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>.',Re,V,We,Y,Xe,x,vt='With the custom ResNet configuration, you can now create and customize the model. The model subclasses the base <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> class. Like <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, inheriting from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> and initializing the superclass with the configuration extends Transformers’ functionalities such as saving and loading to the custom model.',Ge,H,kt="Transformers’ models follow the convention of accepting a <code>config</code> object in the <code>__init__</code> method. This passes the entire <code>config</code> to the model sublayers, instead of breaking the <code>config</code> object into multiple arguments that are individually passed to the sublayers.",Qe,z,Bt="Writing models this way produces simpler code with a clear source of truth for any hyperparameters. It also makes it easier to reuse code from other Transformers’ models.",Ve,E,Nt="You’ll create two ResNet models, a barebones ResNet model that outputs the hidden states and a ResNet model with an image classification head.",Ye,I,xe,F,Rt='A model can return any output format. Returning a dictionary (like <code>ResnetModelForImageClassification</code>) with losses when labels are available makes the custom model compatible with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>. For other output formats, you’ll need your own training loop or a different library for training.',He,L,Wt="Instantiate the custom model class with the configuration.",ze,S,Ee,P,Xt="At this point, you can load pretrained weights into the model or train it from scratch. In this guide, you’ll load pretrained weights.",Fe,q,Gt='Load the pretrained weights from the <a href="https://hf.co/docs/timm/index" rel="nofollow">timm</a> library, and then transfer those weights to the custom model with <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html#torch.nn.Module.load_state_dict" rel="nofollow">load_state_dict</a>.',Le,D,Se,K,Pe,O,Qt='The <a href="./models#model-classes">AutoClass</a> API is a shortcut for automatically loading the correct architecture for a given model. It is convenient to enable this for users loading your custom model.',qe,ee,Vt='Make sure you have the <code>model_type</code> attribute (must be different from existing model types) in the configuration class and <code>config_class</code> attribute in the model class. Use the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig.register">register()</a> method to add the custom configuration and model to the <a href="./models#model-classes">AutoClass</a> API.',De,Z,Ke,te,Oe,se,Yt='Your custom model code is now compatible with the <a href="./models#autoclass">AutoClass</a> API. Users can load the model with the <a href="./model_doc/auto#automodel">AutoModel</a> or <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForImageClassification">AutoModelForImageClassification</a> classes.',et,le,tt,ne,xt='Upload a custom model to the <a href="https://hf.co/models" rel="nofollow">Hub</a> to allow other users to easily load and use it.',st,ae,Ht="Ensure the model directory is structured correctly as shown below. The directory should contain:",lt,oe,zt="<li><code>modeling.py</code>: Contains the code for <code>ResnetModel</code> and <code>ResnetModelForImageClassification</code>. This file can rely on relative imports to other files as long as they’re in the same directory.</li>",nt,A,at,ie,Et="<li><code>configuration.py</code>: Contains the code for <code>ResnetConfig</code>.</li> <li><code>__init__.py</code>: Can be empty, this file allows Python <code>resnet_model</code> to be used as a module.</li>",ot,re,it,pe,Ft="To share the model, import the ResNet model and configuration.",rt,Me,pt,me,Lt='Copy the code from the model and configuration files. To make sure the AutoClass objects are saved with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, call the <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.register_for_auto_class">register_for_auto_class()</a> method. This modifies the configuration JSON file to include the AutoClass objects and mapping.',Mt,ce,St="For a model, pick the appropriate <code>AutoModelFor</code> class based on the task.",mt,fe,ct,de,Pt="To map more than one task to the model, edit <code>auto_map</code> in the configuration JSON file directly.",ft,ue,dt,ye,qt="Create the configuration and model and load pretrained weights into it.",ut,Te,yt,we,Dt="The model is ready to be pushed to the Hub now. Log in to your Hugging Face account from the command line or notebook.",Tt,v,wt,Je,Kt='Call <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> on the model to upload the model to the Hub.',Jt,he,ht,Ue,Ot='The pretrained weights, configuration, <code>modeling.py</code> and <code>configuration.py</code> files should all be uploaded to the Hub now in a <a href="https://hf.co/sgugger/custom-resnet50d" rel="nofollow">repository</a> under your namespace.',Ut,je,es='Because a custom model doesn’t use the same modeling code as a Transformers’ model, you need to add <code>trust_remode_code=True</code> in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> to load it. Refer to the load <a href="./models#custom-models">custom models</a> section for more information.',jt,Ce,Ct,ge,bt;return o=new $e({props:{title:"Customizing models",local:"customizing-models",headingTag:"h1"}}),$=new be({props:{warning:!1,$$slots:{default:[Ts]},$$scope:{ctx:C}}}),N=new $e({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),_=new be({props:{warning:!1,$$slots:{default:[ws]},$$scope:{ctx:C}}}),G=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),V=new g({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),Y=new $e({props:{title:"Model",local:"model",headingTag:"h2"}}),I=new ps({props:{id:"resnet",options:["ResnetModel","ResnetModelForImageClassification"],$$slots:{default:[Cs]},$$scope:{ctx:C}}}),S=new g({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),D=new g({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),K=new $e({props:{title:"AutoClass",local:"autoclass",headingTag:"h2"}}),Z=new be({props:{warning:!1,$$slots:{default:[bs]},$$scope:{ctx:C}}}),te=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),le=new $e({props:{title:"Upload",local:"upload",headingTag:"h2"}}),A=new be({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:C}}}),re=new g({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.py
    ├── configuration_resnet.py
    └── modeling_resnet.py`,wrap:!1}}),Me=new g({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),fe=new g({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),ue=new g({props:{code:"JTIyYXV0b19tYXAlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBdXRvQ29uZmlnJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b01vZGVsJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b01vZGVsRm9yJTNDVGFzayUzRSUyMiUzQSUyMCUyMiUzQ3lvdXItcmVwby1uYW1lJTNFLS0lM0Njb25maWctbmFtZSUzRSUyMiUyQyUyMCUyMCUyMCUyMCUwQSU3RCUyQw==",highlighted:`<span class="hljs-attr">&quot;auto_map&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;AutoConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;AutoModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;AutoModelFor&lt;Task&gt;&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>    
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),Te=new g({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),v=new ps({props:{id:"push",options:["huggingface-CLI","notebook"],$$slots:{default:[Is]},$$scope:{ctx:C}}}),he=new g({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Ce=new ys({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/custom_models.md"}}),{c(){s=f("meta"),m=i(),a=f("p"),M=i(),y(o.$$.fragment),c=i(),j=f("p"),j.innerHTML=p,b=i(),y($.$$.fragment),_e=i(),B=f("p"),B.innerHTML=$t,Ie=i(),y(N.$$.fragment),Ze=i(),R=f("p"),R.innerHTML=_t,Ae=i(),W=f("p"),W.textContent=It,ve=i(),X=f("ol"),X.innerHTML=Zt,ke=i(),y(_.$$.fragment),Be=i(),y(G.$$.fragment),Ne=i(),Q=f("p"),Q.innerHTML=At,Re=i(),y(V.$$.fragment),We=i(),y(Y.$$.fragment),Xe=i(),x=f("p"),x.innerHTML=vt,Ge=i(),H=f("p"),H.innerHTML=kt,Qe=i(),z=f("p"),z.textContent=Bt,Ve=i(),E=f("p"),E.textContent=Nt,Ye=i(),y(I.$$.fragment),xe=i(),F=f("p"),F.innerHTML=Rt,He=i(),L=f("p"),L.textContent=Wt,ze=i(),y(S.$$.fragment),Ee=i(),P=f("p"),P.textContent=Xt,Fe=i(),q=f("p"),q.innerHTML=Gt,Le=i(),y(D.$$.fragment),Se=i(),y(K.$$.fragment),Pe=i(),O=f("p"),O.innerHTML=Qt,qe=i(),ee=f("p"),ee.innerHTML=Vt,De=i(),y(Z.$$.fragment),Ke=i(),y(te.$$.fragment),Oe=i(),se=f("p"),se.innerHTML=Yt,et=i(),y(le.$$.fragment),tt=i(),ne=f("p"),ne.innerHTML=xt,st=i(),ae=f("p"),ae.textContent=Ht,lt=i(),oe=f("ul"),oe.innerHTML=zt,nt=i(),y(A.$$.fragment),at=i(),ie=f("ul"),ie.innerHTML=Et,ot=i(),y(re.$$.fragment),it=i(),pe=f("p"),pe.textContent=Ft,rt=i(),y(Me.$$.fragment),pt=i(),me=f("p"),me.innerHTML=Lt,Mt=i(),ce=f("p"),ce.innerHTML=St,mt=i(),y(fe.$$.fragment),ct=i(),de=f("p"),de.innerHTML=Pt,ft=i(),y(ue.$$.fragment),dt=i(),ye=f("p"),ye.textContent=qt,ut=i(),y(Te.$$.fragment),yt=i(),we=f("p"),we.textContent=Dt,Tt=i(),y(v.$$.fragment),wt=i(),Je=f("p"),Je.innerHTML=Kt,Jt=i(),y(he.$$.fragment),ht=i(),Ue=f("p"),Ue.innerHTML=Ot,Ut=i(),je=f("p"),je.innerHTML=es,jt=i(),y(Ce.$$.fragment),Ct=i(),ge=f("p"),this.h()},l(e){const t=ds("svelte-u9bgzb",document.head);s=d(t,"META",{name:!0,content:!0}),t.forEach(l),m=r(e),a=d(e,"P",{}),is(a).forEach(l),M=r(e),T(o.$$.fragment,e),c=r(e),j=d(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-5wc2cb"&&(j.innerHTML=p),b=r(e),T($.$$.fragment,e),_e=r(e),B=d(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-16ngbma"&&(B.innerHTML=$t),Ie=r(e),T(N.$$.fragment,e),Ze=r(e),R=d(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1vhwbfb"&&(R.innerHTML=_t),Ae=r(e),W=d(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-oqy407"&&(W.textContent=It),ve=r(e),X=d(e,"OL",{"data-svelte-h":!0}),u(X)!=="svelte-18r32m3"&&(X.innerHTML=Zt),ke=r(e),T(_.$$.fragment,e),Be=r(e),T(G.$$.fragment,e),Ne=r(e),Q=d(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-6ifsxm"&&(Q.innerHTML=At),Re=r(e),T(V.$$.fragment,e),We=r(e),T(Y.$$.fragment,e),Xe=r(e),x=d(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-iqv92h"&&(x.innerHTML=vt),Ge=r(e),H=d(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-32mnnr"&&(H.innerHTML=kt),Qe=r(e),z=d(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1fd3lx3"&&(z.textContent=Bt),Ve=r(e),E=d(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-11yxpzf"&&(E.textContent=Nt),Ye=r(e),T(I.$$.fragment,e),xe=r(e),F=d(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1m135g5"&&(F.innerHTML=Rt),He=r(e),L=d(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-13aotg2"&&(L.textContent=Wt),ze=r(e),T(S.$$.fragment,e),Ee=r(e),P=d(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-kq4isl"&&(P.textContent=Xt),Fe=r(e),q=d(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-k2yqgl"&&(q.innerHTML=Gt),Le=r(e),T(D.$$.fragment,e),Se=r(e),T(K.$$.fragment,e),Pe=r(e),O=d(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-egsig4"&&(O.innerHTML=Qt),qe=r(e),ee=d(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-xqqlt4"&&(ee.innerHTML=Vt),De=r(e),T(Z.$$.fragment,e),Ke=r(e),T(te.$$.fragment,e),Oe=r(e),se=d(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-wcup49"&&(se.innerHTML=Yt),et=r(e),T(le.$$.fragment,e),tt=r(e),ne=d(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-cqmp5n"&&(ne.innerHTML=xt),st=r(e),ae=d(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-m7pn28"&&(ae.textContent=Ht),lt=r(e),oe=d(e,"UL",{"data-svelte-h":!0}),u(oe)!=="svelte-133jbrd"&&(oe.innerHTML=zt),nt=r(e),T(A.$$.fragment,e),at=r(e),ie=d(e,"UL",{"data-svelte-h":!0}),u(ie)!=="svelte-do471y"&&(ie.innerHTML=Et),ot=r(e),T(re.$$.fragment,e),it=r(e),pe=d(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-49n23v"&&(pe.textContent=Ft),rt=r(e),T(Me.$$.fragment,e),pt=r(e),me=d(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-13h6t3b"&&(me.innerHTML=Lt),Mt=r(e),ce=d(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1i5bgv6"&&(ce.innerHTML=St),mt=r(e),T(fe.$$.fragment,e),ct=r(e),de=d(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-ulgn02"&&(de.innerHTML=Pt),ft=r(e),T(ue.$$.fragment,e),dt=r(e),ye=d(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-5xnqws"&&(ye.textContent=qt),ut=r(e),T(Te.$$.fragment,e),yt=r(e),we=d(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-14u51dd"&&(we.textContent=Dt),Tt=r(e),T(v.$$.fragment,e),wt=r(e),Je=d(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-py7y0f"&&(Je.innerHTML=Kt),Jt=r(e),T(he.$$.fragment,e),ht=r(e),Ue=d(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-iimdkz"&&(Ue.innerHTML=Ot),Ut=r(e),je=d(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1nlwcbw"&&(je.innerHTML=es),jt=r(e),T(Ce.$$.fragment,e),Ct=r(e),ge=d(e,"P",{}),is(ge).forEach(l),this.h()},h(){rs(s,"name","hf:doc:metadata"),rs(s,"content",As)},m(e,t){us(document.head,s),n(e,m,t),n(e,a,t),n(e,M,t),w(o,e,t),n(e,c,t),n(e,j,t),n(e,b,t),w($,e,t),n(e,_e,t),n(e,B,t),n(e,Ie,t),w(N,e,t),n(e,Ze,t),n(e,R,t),n(e,Ae,t),n(e,W,t),n(e,ve,t),n(e,X,t),n(e,ke,t),w(_,e,t),n(e,Be,t),w(G,e,t),n(e,Ne,t),n(e,Q,t),n(e,Re,t),w(V,e,t),n(e,We,t),w(Y,e,t),n(e,Xe,t),n(e,x,t),n(e,Ge,t),n(e,H,t),n(e,Qe,t),n(e,z,t),n(e,Ve,t),n(e,E,t),n(e,Ye,t),w(I,e,t),n(e,xe,t),n(e,F,t),n(e,He,t),n(e,L,t),n(e,ze,t),w(S,e,t),n(e,Ee,t),n(e,P,t),n(e,Fe,t),n(e,q,t),n(e,Le,t),w(D,e,t),n(e,Se,t),w(K,e,t),n(e,Pe,t),n(e,O,t),n(e,qe,t),n(e,ee,t),n(e,De,t),w(Z,e,t),n(e,Ke,t),w(te,e,t),n(e,Oe,t),n(e,se,t),n(e,et,t),w(le,e,t),n(e,tt,t),n(e,ne,t),n(e,st,t),n(e,ae,t),n(e,lt,t),n(e,oe,t),n(e,nt,t),w(A,e,t),n(e,at,t),n(e,ie,t),n(e,ot,t),w(re,e,t),n(e,it,t),n(e,pe,t),n(e,rt,t),w(Me,e,t),n(e,pt,t),n(e,me,t),n(e,Mt,t),n(e,ce,t),n(e,mt,t),w(fe,e,t),n(e,ct,t),n(e,de,t),n(e,ft,t),w(ue,e,t),n(e,dt,t),n(e,ye,t),n(e,ut,t),w(Te,e,t),n(e,yt,t),n(e,we,t),n(e,Tt,t),w(v,e,t),n(e,wt,t),n(e,Je,t),n(e,Jt,t),w(he,e,t),n(e,ht,t),n(e,Ue,t),n(e,Ut,t),n(e,je,t),n(e,jt,t),w(Ce,e,t),n(e,Ct,t),n(e,ge,t),bt=!0},p(e,[t]){const ts={};t&2&&(ts.$$scope={dirty:t,ctx:e}),$.$set(ts);const ss={};t&2&&(ss.$$scope={dirty:t,ctx:e}),_.$set(ss);const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),I.$set(ls);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),Z.$set(ns);const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),A.$set(as);const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),v.$set(os)},i(e){bt||(J(o.$$.fragment,e),J($.$$.fragment,e),J(N.$$.fragment,e),J(_.$$.fragment,e),J(G.$$.fragment,e),J(V.$$.fragment,e),J(Y.$$.fragment,e),J(I.$$.fragment,e),J(S.$$.fragment,e),J(D.$$.fragment,e),J(K.$$.fragment,e),J(Z.$$.fragment,e),J(te.$$.fragment,e),J(le.$$.fragment,e),J(A.$$.fragment,e),J(re.$$.fragment,e),J(Me.$$.fragment,e),J(fe.$$.fragment,e),J(ue.$$.fragment,e),J(Te.$$.fragment,e),J(v.$$.fragment,e),J(he.$$.fragment,e),J(Ce.$$.fragment,e),bt=!0)},o(e){h(o.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(_.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(I.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(A.$$.fragment,e),h(re.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Te.$$.fragment,e),h(v.$$.fragment,e),h(he.$$.fragment,e),h(Ce.$$.fragment,e),bt=!1},d(e){e&&(l(m),l(a),l(M),l(c),l(j),l(b),l(_e),l(B),l(Ie),l(Ze),l(R),l(Ae),l(W),l(ve),l(X),l(ke),l(Be),l(Ne),l(Q),l(Re),l(We),l(Xe),l(x),l(Ge),l(H),l(Qe),l(z),l(Ve),l(E),l(Ye),l(xe),l(F),l(He),l(L),l(ze),l(Ee),l(P),l(Fe),l(q),l(Le),l(Se),l(Pe),l(O),l(qe),l(ee),l(De),l(Ke),l(Oe),l(se),l(et),l(tt),l(ne),l(st),l(ae),l(lt),l(oe),l(nt),l(at),l(ie),l(ot),l(it),l(pe),l(rt),l(pt),l(me),l(Mt),l(ce),l(mt),l(ct),l(de),l(ft),l(dt),l(ye),l(ut),l(yt),l(we),l(Tt),l(wt),l(Je),l(Jt),l(ht),l(Ue),l(Ut),l(je),l(jt),l(Ct),l(ge)),l(s),U(o,e),U($,e),U(N,e),U(_,e),U(G,e),U(V,e),U(Y,e),U(I,e),U(S,e),U(D,e),U(K,e),U(Z,e),U(te,e),U(le,e),U(A,e),U(re,e),U(Me,e),U(fe,e),U(ue,e),U(Te,e),U(v,e),U(he,e),U(Ce,e)}}}const As='{"title":"Customizing models","local":"customizing-models","sections":[{"title":"Configuration","local":"configuration","sections":[],"depth":2},{"title":"Model","local":"model","sections":[],"depth":2},{"title":"AutoClass","local":"autoclass","sections":[],"depth":2},{"title":"Upload","local":"upload","sections":[],"depth":2}],"depth":1}';function vs(C){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends cs{constructor(s){super(),fs(this,s,vs,Zs,Ms,{})}}export{Gs as component};
