import{s as Pe,n as qe,o as Ke}from"../chunks/scheduler.01eeda35.js";import{S as Ae,i as Oe,g as p,s as l,r as m,A as es,h as i,f as t,c as n,j as Le,u as J,x as o,k as Ve,y as ss,a,v as r,d as w,t as c,w as T}from"../chunks/index.6dd51b66.js";import{C as u}from"../chunks/CodeBlock.864da1b0.js";import{D as ts}from"../chunks/DocNotebookDropdown.54e76c6c.js";import{H as as,E as ls}from"../chunks/EditOnGithub.7faefd25.js";function ns(Ze){let h,q,L,K,g,A,d,O,b,We="Image-to-Image task is the task where an application receives an image and outputs another image. This has various subtasks, including image enhancement (super resolution, low light enhancement, deraining and so on), image inpainting, and more.",ee,f,xe="This guide will show you how to:",se,I,_e="<li>Use an image-to-image pipeline for super resolution task,</li> <li>Run image-to-image models for same task without a pipeline.</li>",te,j,De="Note that as of the time this guide is released, <code>image-to-image</code> pipeline only supports super resolution task.",ae,U,Ne="Let’s begin by installing the necessary libraries.",le,$,ne,C,Se='We can now initialize the pipeline with a <a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR model</a>. We can then infer with the pipeline by calling it with an image. As of now, only <a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR models</a> are supported in this pipeline.',pe,v,ie,k,Re="Now, let’s load an image.",oe,V,me,Z,Je,y,Ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',re,W,ze="We can now do inference with the pipeline. We will get an upscaled version of the cat image.",we,x,ce,_,Te,D,Be="If you wish to do inference yourself with no pipeline, you can use the <code>Swin2SRForImageSuperResolution</code> and <code>Swin2SRImageProcessor</code> classes of transformers. We will use the same model checkpoint for this. Let’s initialize the model and the processor.",ue,N,he,S,He="<code>pipeline</code> abstracts away the preprocessing and postprocessing steps that we have to do ourselves, so let’s preprocess the image. We will pass the image to the processor and then move the pixel values to GPU.",ye,R,Me,G,Qe="We can now infer the image by passing pixel values to the model.",ge,z,de,B,Ye="Output is an object of type <code>ImageSuperResolutionOutput</code> that looks like below 👇",be,H,fe,Q,Xe="We need to get the <code>reconstruction</code> and post-process it for visualization. Let’s see how it looks like.",Ie,Y,je,X,Ee="We need to squeeze the output and get rid of axis 0, clip the values, then convert it to be numpy float. Then we will arrange axes to have the shape [1072, 880], and finally, bring the output back to range [0, 255].",Ue,E,$e,M,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',Ce,F,ve,P,ke;return g=new as({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),d=new ts({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"}]}}),$=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZS50ZXN0X3V0aWxzLnRlc3RpbmclMjBpbXBvcnQlMjBnZXRfYmFja2VuZCUwQSUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBZGV2aWNlJTJDJTIwXyUyQyUyMF8lMjAlM0QlMjBnZXRfYmFja2VuZCgpJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS10by1pbWFnZSUyMiUyQyUyMG1vZGVsJTNEJTIyY2FpZGFzJTJGc3dpbjJTUi1saWdodHdlaWdodC14Mi02NCUyMiUyQyUyMGRldmljZSUzRGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend
<span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
device, _, _ = get_backend()
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),Z=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),_=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),N=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),R=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),z=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),H=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),Y=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),E=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),F=new ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_to_image.md"}}),{c(){h=p("meta"),q=l(),L=p("p"),K=l(),m(g.$$.fragment),A=l(),m(d.$$.fragment),O=l(),b=p("p"),b.textContent=We,ee=l(),f=p("p"),f.textContent=xe,se=l(),I=p("ul"),I.innerHTML=_e,te=l(),j=p("p"),j.innerHTML=De,ae=l(),U=p("p"),U.textContent=Ne,le=l(),m($.$$.fragment),ne=l(),C=p("p"),C.innerHTML=Se,pe=l(),m(v.$$.fragment),ie=l(),k=p("p"),k.textContent=Re,oe=l(),m(V.$$.fragment),me=l(),m(Z.$$.fragment),Je=l(),y=p("div"),y.innerHTML=Ge,re=l(),W=p("p"),W.textContent=ze,we=l(),m(x.$$.fragment),ce=l(),m(_.$$.fragment),Te=l(),D=p("p"),D.innerHTML=Be,ue=l(),m(N.$$.fragment),he=l(),S=p("p"),S.innerHTML=He,ye=l(),m(R.$$.fragment),Me=l(),G=p("p"),G.textContent=Qe,ge=l(),m(z.$$.fragment),de=l(),B=p("p"),B.innerHTML=Ye,be=l(),m(H.$$.fragment),fe=l(),Q=p("p"),Q.innerHTML=Xe,Ie=l(),m(Y.$$.fragment),je=l(),X=p("p"),X.textContent=Ee,Ue=l(),m(E.$$.fragment),$e=l(),M=p("div"),M.innerHTML=Fe,Ce=l(),m(F.$$.fragment),ve=l(),P=p("p"),this.h()},l(e){const s=es("svelte-u9bgzb",document.head);h=i(s,"META",{name:!0,content:!0}),s.forEach(t),q=n(e),L=i(e,"P",{}),Le(L).forEach(t),K=n(e),J(g.$$.fragment,e),A=n(e),J(d.$$.fragment,e),O=n(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1m5ab0h"&&(b.textContent=We),ee=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1aff4p7"&&(f.textContent=xe),se=n(e),I=i(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1dytd0b"&&(I.innerHTML=_e),te=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-j21dpj"&&(j.innerHTML=De),ae=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-2ffb0z"&&(U.textContent=Ne),le=n(e),J($.$$.fragment,e),ne=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-6x8yac"&&(C.innerHTML=Se),pe=n(e),J(v.$$.fragment,e),ie=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dx2hkj"&&(k.textContent=Re),oe=n(e),J(V.$$.fragment,e),me=n(e),J(Z.$$.fragment,e),Je=n(e),y=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-muvbux"&&(y.innerHTML=Ge),re=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-jehike"&&(W.textContent=ze),we=n(e),J(x.$$.fragment,e),ce=n(e),J(_.$$.fragment,e),Te=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-7mqp02"&&(D.innerHTML=Be),ue=n(e),J(N.$$.fragment,e),he=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-cwlggi"&&(S.innerHTML=He),ye=n(e),J(R.$$.fragment,e),Me=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-z8yxu1"&&(G.textContent=Qe),ge=n(e),J(z.$$.fragment,e),de=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-yf1rhn"&&(B.innerHTML=Ye),be=n(e),J(H.$$.fragment,e),fe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-nzl4n2"&&(Q.innerHTML=Xe),Ie=n(e),J(Y.$$.fragment,e),je=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-z07gu"&&(X.textContent=Ee),Ue=n(e),J(E.$$.fragment,e),$e=n(e),M=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(M)!=="svelte-1u1oaeg"&&(M.innerHTML=Fe),Ce=n(e),J(F.$$.fragment,e),ve=n(e),P=i(e,"P",{}),Le(P).forEach(t),this.h()},h(){Ve(h,"name","hf:doc:metadata"),Ve(h,"content",ps),Ve(y,"class","flex justify-center"),Ve(M,"class","flex justify-center")},m(e,s){ss(document.head,h),a(e,q,s),a(e,L,s),a(e,K,s),r(g,e,s),a(e,A,s),r(d,e,s),a(e,O,s),a(e,b,s),a(e,ee,s),a(e,f,s),a(e,se,s),a(e,I,s),a(e,te,s),a(e,j,s),a(e,ae,s),a(e,U,s),a(e,le,s),r($,e,s),a(e,ne,s),a(e,C,s),a(e,pe,s),r(v,e,s),a(e,ie,s),a(e,k,s),a(e,oe,s),r(V,e,s),a(e,me,s),r(Z,e,s),a(e,Je,s),a(e,y,s),a(e,re,s),a(e,W,s),a(e,we,s),r(x,e,s),a(e,ce,s),r(_,e,s),a(e,Te,s),a(e,D,s),a(e,ue,s),r(N,e,s),a(e,he,s),a(e,S,s),a(e,ye,s),r(R,e,s),a(e,Me,s),a(e,G,s),a(e,ge,s),r(z,e,s),a(e,de,s),a(e,B,s),a(e,be,s),r(H,e,s),a(e,fe,s),a(e,Q,s),a(e,Ie,s),r(Y,e,s),a(e,je,s),a(e,X,s),a(e,Ue,s),r(E,e,s),a(e,$e,s),a(e,M,s),a(e,Ce,s),r(F,e,s),a(e,ve,s),a(e,P,s),ke=!0},p:qe,i(e){ke||(w(g.$$.fragment,e),w(d.$$.fragment,e),w($.$$.fragment,e),w(v.$$.fragment,e),w(V.$$.fragment,e),w(Z.$$.fragment,e),w(x.$$.fragment,e),w(_.$$.fragment,e),w(N.$$.fragment,e),w(R.$$.fragment,e),w(z.$$.fragment,e),w(H.$$.fragment,e),w(Y.$$.fragment,e),w(E.$$.fragment,e),w(F.$$.fragment,e),ke=!0)},o(e){c(g.$$.fragment,e),c(d.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(Z.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),c(z.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),ke=!1},d(e){e&&(t(q),t(L),t(K),t(A),t(O),t(b),t(ee),t(f),t(se),t(I),t(te),t(j),t(ae),t(U),t(le),t(ne),t(C),t(pe),t(ie),t(k),t(oe),t(me),t(Je),t(y),t(re),t(W),t(we),t(ce),t(Te),t(D),t(ue),t(he),t(S),t(ye),t(Me),t(G),t(ge),t(de),t(B),t(be),t(fe),t(Q),t(Ie),t(je),t(X),t(Ue),t($e),t(M),t(Ce),t(ve),t(P)),t(h),T(g,e),T(d,e),T($,e),T(v,e),T(V,e),T(Z,e),T(x,e),T(_,e),T(N,e),T(R,e),T(z,e),T(H,e),T(Y,e),T(E,e),T(F,e)}}}const ps='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function is(Ze){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Ae{constructor(h){super(),Oe(this,h,is,ns,Pe,{})}}export{cs as component};
