import{s as fe,o as Te,n as Je}from"../chunks/scheduler.01eeda35.js";import{S as be,i as je,g as i,s as n,r as C,A as we,h as r,f as a,c as l,j as ue,u as W,x as h,k as Me,y as Ue,a as s,v as X,d as I,t as R,w as B}from"../chunks/index.6dd51b66.js";import{T as _e}from"../chunks/Tip.de9bae2b.js";import{C as ye}from"../chunks/CodeBlock.864da1b0.js";import{H as ae,E as ke}from"../chunks/EditOnGithub.7faefd25.js";function ge(V){let o,m="Caching should only be used for <strong>inference</strong>. It may cause unexpected errors if it’s enabled during training.";return{c(){o=i("p"),o.innerHTML=m},l(c){o=r(c,"P",{"data-svelte-h":!0}),h(o)!=="svelte-16dnkl8"&&(o.innerHTML=m)},m(c,G){s(c,o,G)},p:Je,d(c){c&&a(o)}}}function ve(V){let o,m,c,G,d,x,u,se="Imagine you’re having a conversation with someone, and instead of remembering what they previously said, they have to start from scratch every time you respond. This would be slow and inefficient, right?",Y,M,ne="You can extend this analogy to transformer models. Autoregressive model generation can be slow because it makes a prediction one token at a time. Each new prediction is dependent on all the previous context.",F,y,le="To predict the 1000th token, the model requires information from the previous 999 tokens. The information is represented as matrix multiplications across the token representations.",H,f,oe="To predict the 1001th token, you need the same information from the previous 999 tokens in addition to any information from the 1000th token. This is a lot of matrix multiplications a model has to compute over and over for each token!",Q,T,ie="A key-value (KV) cache eliminates this inefficiency by storing kv pairs derived from the attention layers of previously processed tokens. The stored kv pairs are retrieved from the cache and reused for subsequent tokens, avoiding the need to recompute.",E,p,$,J,z,b,re='When you use Transformers’ <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> class, the self-attention module performs several critical steps to integrate past and present information.',S,j,ce='<li><p>The attention module concatenates current kv pairs with past kv pairs stored in the cache. This creates attentions weights with the shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. The current and past kv pairs are essentially combined to compute the attention scores, ensuring a model is aware of previous context and the current input.</p></li> <li><p>When the <code>forward</code> method is called iteratively, it’s crucial that the attention mask shape matches the combined length of the past and current kv pairs. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is typically handled internally in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but if you want to implement your own generation loop with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a>, keep this in mind! The attention mask should hold the past and current token values.</p></li> <li><p>It is also important to be aware of the <code>cache_position</code>. This is important if you want to reuse a prefilled <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> with the <code>forward</code> method because you have to pass a valid <code>cache_position</code> value. This indicates the input positions in a sequence. <code>cache_position</code> is unaffected by padding, and it always adds one more position for each token. For example, if a kv cache contains 10 tokens - regardless of pad tokens - the cache position for the next token should be <code>torch.tensor([10])</code>.</p></li>',A,w,he='The example below demonstrates how to create a generation loop with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>. As discussed, the attention mask is a concatenation of past and current token values and <code>1</code> is added to the cache position for the next token.',q,U,L,_,D,k,pe='Before the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> class, the cache used to be stored as a tuple of tuples of tensors. This format has is dynamic because it grows as text is generated, similar to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>.',K,g,me='If your project depends on this legacy format, you can convert between <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a> and a tuple of tuples as shown below with the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache.from_legacy_cache">from_legacy_cache()</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache.to_legacy_cache">DynamicCache.to_legacy_cache()</a> functions. This is helpful if you have custom logic for manipulating a cache in a specific format.',P,v,O,Z,ee,N,te;return d=new ae({props:{title:"Caching",local:"caching",headingTag:"h1"}}),p=new _e({props:{warning:!0,$$slots:{default:[ge]},$$scope:{ctx:V}}}),J=new ae({props:{title:"Cache class",local:"cache-class",headingTag:"h2"}}),U=new ye({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)

past_key_values = DynamicCache()
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

generated_ids = inputs.input_ids
cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
    <span class="hljs-comment"># Greedily sample one next token</span>
    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Prepare inputs for the next generation step by leaaving unprocessed tokens, in our case we have only one new token</span>
    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;[INST] Hello, what&#x27;s your name. [/INST]  Hello! My name is LLaMA,&quot;</span>`,wrap:!1}}),_=new ae({props:{title:"Legacy cache format",local:"legacy-cache-format",headingTag:"h2"}}),v=new ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwRHluYW1pY0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwJTYwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTYwJTIwaXMlMjByZXF1aXJlZCUyMHRvJTIwcmV0dXJuJTIwdGhlJTIwY2FjaGUlMjBhbmQlMjAlNjByZXR1cm5fbGVnYWN5X2NhY2hlJTYwJTIwZm9yY2VzJTIwdGhlJTIwcmV0dXJuZWQlMjBjYWNoZSUwQSUyMyUyMGluJTIwdGhlJTIwdGhlJTIwbGVnYWN5JTIwZm9ybWF0JTBBZ2VuZXJhdGlvbl9vdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjByZXR1cm5fbGVnYWN5X2NhY2hlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENSklMEElMEFjYWNoZSUyMCUzRCUyMER5bmFtaWNDYWNoZS5mcm9tX2xlZ2FjeV9jYWNoZShnZW5lcmF0aW9uX291dHB1dHMucGFzdF9rZXlfdmFsdWVzKSUwQWxlZ2FjeV9mb3JtYXRfY2FjaGUlMjAlM0QlMjBjYWNoZS50b19sZWdhY3lfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># \`return_dict_in_generate=True\` is required to return the cache and \`return_legacy_cache\` forces the returned cache</span>
<span class="hljs-comment"># in the the legacy format</span>
generation_outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, return_legacy_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">5</span>)

cache = DynamicCache.from_legacy_cache(generation_outputs.past_key_values)
legacy_format_cache = cache.to_legacy_cache()`,wrap:!1}}),Z=new ke({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/cache_explanation.md"}}),{c(){o=i("meta"),m=n(),c=i("p"),G=n(),C(d.$$.fragment),x=n(),u=i("p"),u.textContent=se,Y=n(),M=i("p"),M.textContent=ne,F=n(),y=i("p"),y.textContent=le,H=n(),f=i("p"),f.textContent=oe,Q=n(),T=i("p"),T.textContent=ie,E=n(),C(p.$$.fragment),$=n(),C(J.$$.fragment),z=n(),b=i("p"),b.innerHTML=re,S=n(),j=i("ol"),j.innerHTML=ce,A=n(),w=i("p"),w.innerHTML=he,q=n(),C(U.$$.fragment),L=n(),C(_.$$.fragment),D=n(),k=i("p"),k.innerHTML=pe,K=n(),g=i("p"),g.innerHTML=me,P=n(),C(v.$$.fragment),O=n(),C(Z.$$.fragment),ee=n(),N=i("p"),this.h()},l(e){const t=we("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(a),m=l(e),c=r(e,"P",{}),ue(c).forEach(a),G=l(e),W(d.$$.fragment,e),x=l(e),u=r(e,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1vgfrh0"&&(u.textContent=se),Y=l(e),M=r(e,"P",{"data-svelte-h":!0}),h(M)!=="svelte-110unin"&&(M.textContent=ne),F=l(e),y=r(e,"P",{"data-svelte-h":!0}),h(y)!=="svelte-1sc0ng3"&&(y.textContent=le),H=l(e),f=r(e,"P",{"data-svelte-h":!0}),h(f)!=="svelte-stwnf4"&&(f.textContent=oe),Q=l(e),T=r(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-k1lwaa"&&(T.textContent=ie),E=l(e),W(p.$$.fragment,e),$=l(e),W(J.$$.fragment,e),z=l(e),b=r(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1lou13p"&&(b.innerHTML=re),S=l(e),j=r(e,"OL",{"data-svelte-h":!0}),h(j)!=="svelte-n5r1rw"&&(j.innerHTML=ce),A=l(e),w=r(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1iezevk"&&(w.innerHTML=he),q=l(e),W(U.$$.fragment,e),L=l(e),W(_.$$.fragment,e),D=l(e),k=r(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1vvjhyo"&&(k.innerHTML=pe),K=l(e),g=r(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-ybkw46"&&(g.innerHTML=me),P=l(e),W(v.$$.fragment,e),O=l(e),W(Z.$$.fragment,e),ee=l(e),N=r(e,"P",{}),ue(N).forEach(a),this.h()},h(){Me(o,"name","hf:doc:metadata"),Me(o,"content",Ze)},m(e,t){Ue(document.head,o),s(e,m,t),s(e,c,t),s(e,G,t),X(d,e,t),s(e,x,t),s(e,u,t),s(e,Y,t),s(e,M,t),s(e,F,t),s(e,y,t),s(e,H,t),s(e,f,t),s(e,Q,t),s(e,T,t),s(e,E,t),X(p,e,t),s(e,$,t),X(J,e,t),s(e,z,t),s(e,b,t),s(e,S,t),s(e,j,t),s(e,A,t),s(e,w,t),s(e,q,t),X(U,e,t),s(e,L,t),X(_,e,t),s(e,D,t),s(e,k,t),s(e,K,t),s(e,g,t),s(e,P,t),X(v,e,t),s(e,O,t),X(Z,e,t),s(e,ee,t),s(e,N,t),te=!0},p(e,[t]){const de={};t&2&&(de.$$scope={dirty:t,ctx:e}),p.$set(de)},i(e){te||(I(d.$$.fragment,e),I(p.$$.fragment,e),I(J.$$.fragment,e),I(U.$$.fragment,e),I(_.$$.fragment,e),I(v.$$.fragment,e),I(Z.$$.fragment,e),te=!0)},o(e){R(d.$$.fragment,e),R(p.$$.fragment,e),R(J.$$.fragment,e),R(U.$$.fragment,e),R(_.$$.fragment,e),R(v.$$.fragment,e),R(Z.$$.fragment,e),te=!1},d(e){e&&(a(m),a(c),a(G),a(x),a(u),a(Y),a(M),a(F),a(y),a(H),a(f),a(Q),a(T),a(E),a($),a(z),a(b),a(S),a(j),a(A),a(w),a(q),a(L),a(D),a(k),a(K),a(g),a(P),a(O),a(ee),a(N)),a(o),B(d,e),B(p,e),B(J,e),B(U,e),B(_,e),B(v,e),B(Z,e)}}}const Ze='{"title":"Caching","local":"caching","sections":[{"title":"Cache class","local":"cache-class","sections":[],"depth":2},{"title":"Legacy cache format","local":"legacy-cache-format","sections":[],"depth":2}],"depth":1}';function Ce(V){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ge extends be{constructor(o){super(),je(this,o,Ce,ve,fe,{})}}export{Ge as component};
