import{s as Re,n as Oe,o as je}from"../chunks/scheduler.85c25b89.js";import{S as Ae,i as Fe,g as a,s as l,r as p,A as Be,h as s,f as t,c as i,j as T,u,x as c,k as M,y as o,a as n,v as f,d as g,t as _,w as h}from"../chunks/index.c9bcf812.js";import{D as W}from"../chunks/Docstring.bf903474.js";import{H as Z}from"../chunks/getInferenceSnippets.aac3c85c.js";function Ge(we){let b,ee,X,te,C,re,w,Le="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",le,L,ie,E,oe,D,Ee="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",ne,d,H,he,z,U,$e,O,De="Provides the list of supported model types for parallelization.",be,$,k,ve,j,He="Returns a tuple of 3 booleans where:",ze,A,Ue="<li>The first element indicates if tensor parallelism can be used for this model,</li> <li>The second element indicates if sequence parallelism can be used on top of tensor parallelism for this model,</li> <li>The third element indicates if pipeline parallelism can be used for this model.</li>",ye,y,q,xe,F,ke="Returns the parallelizer class associated to the model.",ae,I,se,S,de,V,qe="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",me,m,N,Pe,B,Ie="Context manager that makes the loading of a model lazy for model parallelism:",Te,G,Se=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,Me,J,Ve="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",pe,v,R,Ce,K,Ne=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,ue,Y,ce;return C=new Z({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),L=new Z({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),E=new Z({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),H=new W({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/parallelizers_manager.py#L53"}}),U=new W({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/parallelizers_manager.py#L64"}}),k=new W({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": typing.Union[str, transformers.modeling_utils.PreTrainedModel, optimum.neuron.utils.peft_utils.NeuronPeftModel]"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/parallelizers_manager.py#L87"}}),q=new W({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": typing.Union[str, transformers.modeling_utils.PreTrainedModel, optimum.neuron.utils.peft_utils.NeuronPeftModel]"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/parallelizers_manager.py#L112"}}),I=new Z({props:{title:"Utils",local:"utils",headingTag:"h2"}}),S=new Z({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),N=new W({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/utils.py#L1669"}}),R=new W({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": typing.Type[ForwardRef('torch.optim.Optimizer')]"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0/optimum/neuron/distributed/utils.py#L1716"}}),{c(){b=a("meta"),ee=l(),X=a("p"),te=l(),p(C.$$.fragment),re=l(),w=a("p"),w.innerHTML=Le,le=l(),p(L.$$.fragment),ie=l(),p(E.$$.fragment),oe=l(),D=a("p"),D.innerHTML=Ee,ne=l(),d=a("div"),p(H.$$.fragment),he=l(),z=a("div"),p(U.$$.fragment),$e=l(),O=a("p"),O.textContent=De,be=l(),$=a("div"),p(k.$$.fragment),ve=l(),j=a("p"),j.textContent=He,ze=l(),A=a("ul"),A.innerHTML=Ue,ye=l(),y=a("div"),p(q.$$.fragment),xe=l(),F=a("p"),F.textContent=ke,ae=l(),p(I.$$.fragment),se=l(),p(S.$$.fragment),de=l(),V=a("p"),V.textContent=qe,me=l(),m=a("div"),p(N.$$.fragment),Pe=l(),B=a("p"),B.textContent=Ie,Te=l(),G=a("ul"),G.innerHTML=Se,Me=l(),J=a("p"),J.innerHTML=Ve,pe=l(),v=a("div"),p(R.$$.fragment),Ce=l(),K=a("p"),K.textContent=Ne,ue=l(),Y=a("p"),this.h()},l(e){const r=Be("svelte-u9bgzb",document.head);b=s(r,"META",{name:!0,content:!0}),r.forEach(t),ee=i(e),X=s(e,"P",{}),T(X).forEach(t),te=i(e),u(C.$$.fragment,e),re=i(e),w=s(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-it0u39"&&(w.innerHTML=Le),le=i(e),u(L.$$.fragment,e),ie=i(e),u(E.$$.fragment,e),oe=i(e),D=s(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1x1mrd0"&&(D.innerHTML=Ee),ne=i(e),d=s(e,"DIV",{class:!0});var x=T(d);u(H.$$.fragment,x),he=i(x),z=s(x,"DIV",{class:!0});var fe=T(z);u(U.$$.fragment,fe),$e=i(fe),O=s(fe,"P",{"data-svelte-h":!0}),c(O)!=="svelte-esrxt2"&&(O.textContent=De),fe.forEach(t),be=i(x),$=s(x,"DIV",{class:!0});var Q=T($);u(k.$$.fragment,Q),ve=i(Q),j=s(Q,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1pefsnq"&&(j.textContent=He),ze=i(Q),A=s(Q,"UL",{"data-svelte-h":!0}),c(A)!=="svelte-1dpu6ok"&&(A.innerHTML=Ue),Q.forEach(t),ye=i(x),y=s(x,"DIV",{class:!0});var ge=T(y);u(q.$$.fragment,ge),xe=i(ge),F=s(ge,"P",{"data-svelte-h":!0}),c(F)!=="svelte-3qe9b8"&&(F.textContent=ke),ge.forEach(t),x.forEach(t),ae=i(e),u(I.$$.fragment,e),se=i(e),u(S.$$.fragment,e),de=i(e),V=s(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-4ddlue"&&(V.textContent=qe),me=i(e),m=s(e,"DIV",{class:!0});var P=T(m);u(N.$$.fragment,P),Pe=i(P),B=s(P,"P",{"data-svelte-h":!0}),c(B)!=="svelte-bh7x4"&&(B.textContent=Ie),Te=i(P),G=s(P,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-1j7gypf"&&(G.innerHTML=Se),Me=i(P),J=s(P,"P",{"data-svelte-h":!0}),c(J)!=="svelte-oha5tr"&&(J.innerHTML=Ve),P.forEach(t),pe=i(e),v=s(e,"DIV",{class:!0});var _e=T(v);u(R.$$.fragment,_e),Ce=i(_e),K=s(_e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1agud9l"&&(K.textContent=Ne),_e.forEach(t),ue=i(e),Y=s(e,"P",{}),T(Y).forEach(t),this.h()},h(){M(b,"name","hf:doc:metadata"),M(b,"content",Je),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,b),n(e,ee,r),n(e,X,r),n(e,te,r),f(C,e,r),n(e,re,r),n(e,w,r),n(e,le,r),f(L,e,r),n(e,ie,r),f(E,e,r),n(e,oe,r),n(e,D,r),n(e,ne,r),n(e,d,r),f(H,d,null),o(d,he),o(d,z),f(U,z,null),o(z,$e),o(z,O),o(d,be),o(d,$),f(k,$,null),o($,ve),o($,j),o($,ze),o($,A),o(d,ye),o(d,y),f(q,y,null),o(y,xe),o(y,F),n(e,ae,r),f(I,e,r),n(e,se,r),f(S,e,r),n(e,de,r),n(e,V,r),n(e,me,r),n(e,m,r),f(N,m,null),o(m,Pe),o(m,B),o(m,Te),o(m,G),o(m,Me),o(m,J),n(e,pe,r),n(e,v,r),f(R,v,null),o(v,Ce),o(v,K),n(e,ue,r),n(e,Y,r),ce=!0},p:Oe,i(e){ce||(g(C.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(H.$$.fragment,e),g(U.$$.fragment,e),g(k.$$.fragment,e),g(q.$$.fragment,e),g(I.$$.fragment,e),g(S.$$.fragment,e),g(N.$$.fragment,e),g(R.$$.fragment,e),ce=!0)},o(e){_(C.$$.fragment,e),_(L.$$.fragment,e),_(E.$$.fragment,e),_(H.$$.fragment,e),_(U.$$.fragment,e),_(k.$$.fragment,e),_(q.$$.fragment,e),_(I.$$.fragment,e),_(S.$$.fragment,e),_(N.$$.fragment,e),_(R.$$.fragment,e),ce=!1},d(e){e&&(t(ee),t(X),t(te),t(re),t(w),t(le),t(ie),t(oe),t(D),t(ne),t(d),t(ae),t(se),t(de),t(V),t(me),t(m),t(pe),t(v),t(ue),t(Y)),t(b),h(C,e),h(L,e),h(E,e),h(H),h(U),h(k),h(q),h(I,e),h(S,e),h(N),h(R)}}}const Je='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ke(we){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends Ae{constructor(b){super(),Fe(this,b,Ke,Ge,Re,{})}}export{Ze as component};
