import{s as ue,n as ge,o as Me}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as fe,g as l,s as o,u as c,A as je,h as n,f as e,c as p,j as h,v as d,y as m,k as i,o as r,a,w,d as y,t as u,x as g}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Ht){let M,ht,st,mt,J,U,at,W,Qt,D,At="CSP-ResNet",ct,$,Ft='<strong>CSPResNet</strong> is a convolutional neural network where we apply the Cross Stage Partial Network (CSPNet) approach to <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>. The CSPNet partitions the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',dt,f,v,lt,x,Yt,q,zt="How do I use this model on an image?",wt,N,Pt="To load a pretrained model:",yt,Z,ut,B,Lt="To load and preprocess the image:",gt,E,Mt,_,Dt="To get the model predictions:",Jt,G,ft,S,qt="To get the top-5 predictions class names:",jt,Q,Tt,Y,Kt="Replace the model name with the variant you want to use, e.g. <code>cspresnet50</code>. You can find the IDs in the model summaries at the top of this page.",bt,V,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,j,C,nt,R,Vt,K,te="How do I finetune this model?",vt,X,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,H,It,A,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,T,I,ot,F,Rt,O,ae="How do I train this model?",Wt,z,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,k,pt,P,Xt,tt,ne="Citation",xt,L,Nt,it,Zt;return W=new rt({}),x=new rt({}),Z=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcHJlc25ldDUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new rt({}),H=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwcmVzbmV0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QndhbmcyMDE5Y3NwbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JDU1BOZXQlM0ElMjBBJTIwTmV3JTIwQmFja2JvbmUlMjB0aGF0JTIwY2FuJTIwRW5oYW5jZSUyMExlYXJuaW5nJTIwQ2FwYWJpbGl0eSUyMG9mJTIwQ05OJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTIwYW5kJTIwSS1IYXUlMjBZZWglMjBhbmQlMjBZdWVoLUh1YSUyMFd1JTIwYW5kJTIwUGluZy1ZYW5nJTIwQ2hlbiUyMGFuZCUyMEp1bi1XZWklMjBIc2llaCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMS4xMTkyOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{wang2019cspnet,
      title={CSPNet: A New <span class="hljs-keyword">Backbone </span>that can Enhance Learning Capability of CNN}, 
      author={Chien-Yao Wang <span class="hljs-keyword">and </span>Hong-Yuan Mark Liao <span class="hljs-keyword">and </span>I-Hau Yeh <span class="hljs-keyword">and </span>Yueh-Hua Wu <span class="hljs-keyword">and </span>Ping-Yang Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jun-Wei </span>Hsieh},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">11929</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){M=l("meta"),ht=o(),st=l("p"),mt=o(),J=l("h1"),U=l("a"),at=l("span"),c(W.$$.fragment),Qt=o(),D=l("span"),D.textContent=At,ct=o(),$=l("p"),$.innerHTML=Ft,dt=o(),f=l("h2"),v=l("a"),lt=l("span"),c(x.$$.fragment),Yt=o(),q=l("span"),q.textContent=zt,wt=o(),N=l("p"),N.textContent=Pt,yt=o(),c(Z.$$.fragment),ut=o(),B=l("p"),B.textContent=Lt,gt=o(),c(E.$$.fragment),Mt=o(),_=l("p"),_.textContent=Dt,Jt=o(),c(G.$$.fragment),ft=o(),S=l("p"),S.textContent=qt,jt=o(),c(Q.$$.fragment),Tt=o(),Y=l("p"),Y.innerHTML=Kt,bt=o(),V=l("p"),V.innerHTML=Ot,Ut=o(),j=l("h2"),C=l("a"),nt=l("span"),c(R.$$.fragment),Vt=o(),K=l("span"),K.textContent=te,vt=o(),X=l("p"),X.textContent=ee,Ct=o(),c(H.$$.fragment),It=o(),A=l("p"),A.innerHTML=se,kt=o(),T=l("h2"),I=l("a"),ot=l("span"),c(F.$$.fragment),Rt=o(),O=l("span"),O.textContent=ae,Wt=o(),z=l("p"),z.innerHTML=le,$t=o(),b=l("h2"),k=l("a"),pt=l("span"),c(P.$$.fragment),Xt=o(),tt=l("span"),tt.textContent=ne,xt=o(),c(L.$$.fragment),Nt=o(),it=l("p"),this.h()},l(t){const s=je("svelte-1phssyn",document.head);M=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),J=n(t,"H1",{class:!0});var Bt=h(J);U=n(Bt,"A",{id:!0,class:!0,href:!0});var oe=h(U);at=n(oe,"SPAN",{});var pe=h(at);d(W.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Qt=p(Bt),D=n(Bt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1mnb1d1"&&(D.textContent=At),Bt.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-n2j5o6"&&($.innerHTML=Ft),dt=p(t),f=n(t,"H2",{class:!0});var Et=h(f);v=n(Et,"A",{id:!0,class:!0,href:!0});var ie=h(v);lt=n(ie,"SPAN",{});var re=h(lt);d(x.$$.fragment,re),re.forEach(e),ie.forEach(e),Yt=p(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),Et.forEach(e),wt=p(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),yt=p(t),d(Z.$$.fragment,t),ut=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c2ipa8"&&(B.textContent=Lt),gt=p(t),d(E.$$.fragment,t),Mt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),Jt=p(t),d(G.$$.fragment,t),ft=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-19cnvx1"&&(S.textContent=qt),jt=p(t),d(Q.$$.fragment,t),Tt=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1dfb3g"&&(Y.innerHTML=Kt),bt=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wmi3ea"&&(V.innerHTML=Ot),Ut=p(t),j=n(t,"H2",{class:!0});var _t=h(j);C=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(R.$$.fragment,me),me.forEach(e),he.forEach(e),Vt=p(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),vt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-9sr7nh"&&(X.textContent=ee),Ct=p(t),d(H.$$.fragment,t),It=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1kguc51"&&(A.innerHTML=se),kt=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(I);ot=n(ce,"SPAN",{});var de=h(ot);d(F.$$.fragment,de),de.forEach(e),ce.forEach(e),Rt=p(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),Wt=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=le),$t=p(t),b=n(t,"H2",{class:!0});var St=h(b);k=n(St,"A",{id:!0,class:!0,href:!0});var we=h(k);pt=n(we,"SPAN",{});var ye=h(pt);d(P.$$.fragment,ye),ye.forEach(e),we.forEach(e),Xt=p(St),tt=n(St,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),St.forEach(e),xt=p(t),d(L.$$.fragment,t),Nt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(M,"name","hf:doc:metadata"),i(M,"content",JSON.stringify(be)),i(U,"id","cspresnet"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#cspresnet"),i(J,"class","relative group"),i(v,"id","how-do-i-use-this-model-on-an-image"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#how-do-i-use-this-model-on-an-image"),i(f,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(j,"class","relative group"),i(I,"id","how-do-i-train-this-model"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,M),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,U),r(U,at),w(W,at,null),r(J,Qt),r(J,D),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,f,s),r(f,v),r(v,lt),w(x,lt,null),r(f,Yt),r(f,q),a(t,wt,s),a(t,N,s),a(t,yt,s),w(Z,t,s),a(t,ut,s),a(t,B,s),a(t,gt,s),w(E,t,s),a(t,Mt,s),a(t,_,s),a(t,Jt,s),w(G,t,s),a(t,ft,s),a(t,S,s),a(t,jt,s),w(Q,t,s),a(t,Tt,s),a(t,Y,s),a(t,bt,s),a(t,V,s),a(t,Ut,s),a(t,j,s),r(j,C),r(C,nt),w(R,nt,null),r(j,Vt),r(j,K),a(t,vt,s),a(t,X,s),a(t,Ct,s),w(H,t,s),a(t,It,s),a(t,A,s),a(t,kt,s),a(t,T,s),r(T,I),r(I,ot),w(F,ot,null),r(T,Rt),r(T,O),a(t,Wt,s),a(t,z,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,pt),w(P,pt,null),r(b,Xt),r(b,tt),a(t,xt,s),w(L,t,s),a(t,Nt,s),a(t,it,s),Zt=!0},p:ge,i(t){Zt||(y(W.$$.fragment,t),y(x.$$.fragment,t),y(Z.$$.fragment,t),y(E.$$.fragment,t),y(G.$$.fragment,t),y(Q.$$.fragment,t),y(R.$$.fragment,t),y(H.$$.fragment,t),y(F.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Zt=!0)},o(t){u(W.$$.fragment,t),u(x.$$.fragment,t),u(Z.$$.fragment,t),u(E.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(R.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Zt=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e($),e(dt),e(f),e(wt),e(N),e(yt),e(ut),e(B),e(gt),e(Mt),e(_),e(Jt),e(ft),e(S),e(jt),e(Tt),e(Y),e(bt),e(V),e(Ut),e(j),e(vt),e(X),e(Ct),e(It),e(A),e(kt),e(T),e(Wt),e(z),e($t),e(b),e(xt),e(Nt),e(it)),e(M),g(W),g(x),g(Z,t),g(E,t),g(G,t),g(Q,t),g(R),g(H,t),g(F),g(P),g(L,t)}}}const be={local:"cspresnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"CSP-ResNet"};function Ue(Ht){return Me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Je{constructor(M){super(),fe(this,M,Ue,Te,ue,{})}}export{We as component};
