import{s as It,n as kt,o as Wt}from"../chunks/scheduler.85c25b89.js";import{S as At,i as Bt,g as p,s as l,r as m,A as Et,h as i,f as e,c as n,j as xt,u as o,x as M,k as Ct,y as vt,a,v as r,d as c,t as g,w as h}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Gt}from"../chunks/getInferenceSnippets.e17aa01c.js";function Nt(jt){let j,V,Q,H,d,S,u,dt="Extending  “shallow” skip connections, <strong>Dense Layer Aggregation (DLA)</strong> incorporates more depth and sharing. The authors introduce two structures for deep layer aggregation (DLA): iterative deep aggregation (IDA) and hierarchical deep aggregation (HDA). These structures are expressed through an architectural framework, independent of the choice of backbone, for compatibility with current and future networks.",z,y,ut="IDA focuses on fusing resolutions and scales while HDA focuses on merging features from all modules and channels. IDA follows the base hierarchy to refine resolution and aggregate scale stage-bystage. HDA assembles its own hierarchy of tree-structured connections that cross and merge stages to aggregate different levels of representation.",F,J,D,w,yt="To load a pretrained model:",L,f,q,T,Jt="To load and preprocess the image:",P,b,K,U,wt="To get the model predictions:",O,$,tt,Z,ft="To get the top-5 predictions class names:",st,x,et,C,Tt="Replace the model name with the variant you want to use, e.g. <code>dla102</code>. You can find the IDs in the model summaries at the top of this page.",at,I,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,k,nt,W,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,A,it,B,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,E,ot,v,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,G,ct,N,gt,X,ht,Y,Mt;return d=new _({props:{title:"Deep Layer Aggregation",local:"deep-layer-aggregation",headingTag:"h1"}}),J=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RsYTEwMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGxhMTAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),N=new R({props:{code:"JTQwbWlzYyU3Qnl1MjAxOWRlZXAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkRlZXAlMjBMYXllciUyMEFnZ3JlZ2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRmlzaGVyJTIwWXUlMjBhbmQlMjBEZXF1YW4lMjBXYW5nJTIwYW5kJTIwRXZhbiUyMFNoZWxoYW1lciUyMGFuZCUyMFRyZXZvciUyMERhcnJlbGwlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDY0ODQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{yu2019deep,
      title={Deep Layer Aggregation}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Fisher Yu and Dequan Wang and Evan Shelhamer and Trevor Darrell}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1707.06484}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),X=new Gt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/dla.mdx"}}),{c(){j=p("meta"),V=l(),Q=p("p"),H=l(),m(d.$$.fragment),S=l(),u=p("p"),u.innerHTML=dt,z=l(),y=p("p"),y.textContent=ut,F=l(),m(J.$$.fragment),D=l(),w=p("p"),w.textContent=yt,L=l(),m(f.$$.fragment),q=l(),T=p("p"),T.textContent=Jt,P=l(),m(b.$$.fragment),K=l(),U=p("p"),U.textContent=wt,O=l(),m($.$$.fragment),tt=l(),Z=p("p"),Z.textContent=ft,st=l(),m(x.$$.fragment),et=l(),C=p("p"),C.innerHTML=Tt,at=l(),I=p("p"),I.innerHTML=bt,lt=l(),m(k.$$.fragment),nt=l(),W=p("p"),W.textContent=Ut,pt=l(),m(A.$$.fragment),it=l(),B=p("p"),B.innerHTML=$t,mt=l(),m(E.$$.fragment),ot=l(),v=p("p"),v.innerHTML=Zt,rt=l(),m(G.$$.fragment),ct=l(),m(N.$$.fragment),gt=l(),m(X.$$.fragment),ht=l(),Y=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(e),V=n(t),Q=i(t,"P",{}),xt(Q).forEach(e),H=n(t),o(d.$$.fragment,t),S=n(t),u=i(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-ztimnn"&&(u.innerHTML=dt),z=n(t),y=i(t,"P",{"data-svelte-h":!0}),M(y)!=="svelte-148crxx"&&(y.textContent=ut),F=n(t),o(J.$$.fragment,t),D=n(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-18ywhxh"&&(w.textContent=yt),L=n(t),o(f.$$.fragment,t),q=n(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),P=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-19cnvx1"&&(Z.textContent=ft),st=n(t),o(x.$$.fragment,t),et=n(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16eylps"&&(C.innerHTML=Tt),at=n(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1wmi3ea"&&(I.innerHTML=bt),lt=n(t),o(k.$$.fragment,t),nt=n(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-9sr7nh"&&(W.textContent=Ut),pt=n(t),o(A.$$.fragment,t),it=n(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=$t),mt=n(t),o(E.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-xtxxu6"&&(v.innerHTML=Zt),rt=n(t),o(G.$$.fragment,t),ct=n(t),o(N.$$.fragment,t),gt=n(t),o(X.$$.fragment,t),ht=n(t),Y=i(t,"P",{}),xt(Y).forEach(e),this.h()},h(){Ct(j,"name","hf:doc:metadata"),Ct(j,"content",Xt)},m(t,s){vt(document.head,j),a(t,V,s),a(t,Q,s),a(t,H,s),r(d,t,s),a(t,S,s),a(t,u,s),a(t,z,s),a(t,y,s),a(t,F,s),r(J,t,s),a(t,D,s),a(t,w,s),a(t,L,s),r(f,t,s),a(t,q,s),a(t,T,s),a(t,P,s),r(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,Z,s),a(t,st,s),r(x,t,s),a(t,et,s),a(t,C,s),a(t,at,s),a(t,I,s),a(t,lt,s),r(k,t,s),a(t,nt,s),a(t,W,s),a(t,pt,s),r(A,t,s),a(t,it,s),a(t,B,s),a(t,mt,s),r(E,t,s),a(t,ot,s),a(t,v,s),a(t,rt,s),r(G,t,s),a(t,ct,s),r(N,t,s),a(t,gt,s),r(X,t,s),a(t,ht,s),a(t,Y,s),Mt=!0},p:kt,i(t){Mt||(c(d.$$.fragment,t),c(J.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(k.$$.fragment,t),c(A.$$.fragment,t),c(E.$$.fragment,t),c(G.$$.fragment,t),c(N.$$.fragment,t),c(X.$$.fragment,t),Mt=!0)},o(t){g(d.$$.fragment,t),g(J.$$.fragment,t),g(f.$$.fragment,t),g(b.$$.fragment,t),g($.$$.fragment,t),g(x.$$.fragment,t),g(k.$$.fragment,t),g(A.$$.fragment,t),g(E.$$.fragment,t),g(G.$$.fragment,t),g(N.$$.fragment,t),g(X.$$.fragment,t),Mt=!1},d(t){t&&(e(V),e(Q),e(H),e(S),e(u),e(z),e(y),e(F),e(D),e(w),e(L),e(q),e(T),e(P),e(K),e(U),e(O),e(tt),e(Z),e(st),e(et),e(C),e(at),e(I),e(lt),e(nt),e(W),e(pt),e(it),e(B),e(mt),e(ot),e(v),e(rt),e(ct),e(gt),e(ht),e(Y)),e(j),h(d,t),h(J,t),h(f,t),h(b,t),h($,t),h(x,t),h(k,t),h(A,t),h(E,t),h(G,t),h(N,t),h(X,t)}}}const Xt='{"title":"Deep Layer Aggregation","local":"deep-layer-aggregation","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends At{constructor(j){super(),Bt(this,j,Rt,Nt,It,{})}}export{Ht as component};
