import{s as Ct,n as $t,o as Wt}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as kt,g as p,s as l,r as i,A as Gt,h as m,f as e,c as n,j as Ut,u as o,x as M,k as It,y as Bt,a,v as r,d as h,t as c,w as g}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.e573519b.js";import{H as R,E as Nt}from"../chunks/getInferenceSnippets.5d4c70d5.js";function xt(gt){let y,_,V,X,w,H,J,Mt='<strong>CSPResNet</strong> is a convolutional neural network where we apply the Cross Stage Partial Network (CSPNet) approach to <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>. The CSPNet partitions the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',z,d,F,T,yt="To load a pretrained model:",A,j,L,u,wt="To load and preprocess the image:",P,f,D,b,Jt="To get the model predictions:",q,U,K,I,dt="To get the top-5 predictions class names:",O,C,tt,$,Tt="Replace the model name with the variant you want to use, e.g. <code>cspresnet50</code>. You can find the IDs in the model summaries at the top of this page.",st,W,jt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,Z,at,k,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,G,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,N,mt,x,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,Q,ot,Y,rt,E,ht,S,ct;return w=new R({props:{title:"CSP-ResNet",local:"csp-resnet",headingTag:"h1"}}),d=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),j=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcHJlc25ldDUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwcmVzbmV0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Y=new v({props:{code:"JTQwbWlzYyU3QndhbmcyMDE5Y3NwbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JDU1BOZXQlM0ElMjBBJTIwTmV3JTIwQmFja2JvbmUlMjB0aGF0JTIwY2FuJTIwRW5oYW5jZSUyMExlYXJuaW5nJTIwQ2FwYWJpbGl0eSUyMG9mJTIwQ05OJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTIwYW5kJTIwSS1IYXUlMjBZZWglMjBhbmQlMjBZdWVoLUh1YSUyMFd1JTIwYW5kJTIwUGluZy1ZYW5nJTIwQ2hlbiUyMGFuZCUyMEp1bi1XZWklMjBIc2llaCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMS4xMTkyOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{wang2019cspnet,
      title={CSPNet: A New <span class="hljs-keyword">Backbone </span>that can Enhance Learning Capability of CNN}, 
      author={Chien-Yao Wang <span class="hljs-keyword">and </span>Hong-Yuan Mark Liao <span class="hljs-keyword">and </span>I-Hau Yeh <span class="hljs-keyword">and </span>Yueh-Hua Wu <span class="hljs-keyword">and </span>Ping-Yang Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jun-Wei </span>Hsieh},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">11929</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),E=new Nt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/csp-resnet.mdx"}}),{c(){y=p("meta"),_=l(),V=p("p"),X=l(),i(w.$$.fragment),H=l(),J=p("p"),J.innerHTML=Mt,z=l(),i(d.$$.fragment),F=l(),T=p("p"),T.textContent=yt,A=l(),i(j.$$.fragment),L=l(),u=p("p"),u.textContent=wt,P=l(),i(f.$$.fragment),D=l(),b=p("p"),b.textContent=Jt,q=l(),i(U.$$.fragment),K=l(),I=p("p"),I.textContent=dt,O=l(),i(C.$$.fragment),tt=l(),$=p("p"),$.innerHTML=Tt,st=l(),W=p("p"),W.innerHTML=jt,et=l(),i(Z.$$.fragment),at=l(),k=p("p"),k.textContent=ut,lt=l(),i(G.$$.fragment),nt=l(),B=p("p"),B.innerHTML=ft,pt=l(),i(N.$$.fragment),mt=l(),x=p("p"),x.innerHTML=bt,it=l(),i(Q.$$.fragment),ot=l(),i(Y.$$.fragment),rt=l(),i(E.$$.fragment),ht=l(),S=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),_=n(t),V=m(t,"P",{}),Ut(V).forEach(e),X=n(t),o(w.$$.fragment,t),H=n(t),J=m(t,"P",{"data-svelte-h":!0}),M(J)!=="svelte-n2j5o6"&&(J.innerHTML=Mt),z=n(t),o(d.$$.fragment,t),F=n(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=yt),A=n(t),o(j.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=wt),P=n(t),o(f.$$.fragment,t),D=n(t),b=m(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),q=n(t),o(U.$$.fragment,t),K=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=dt),O=n(t),o(C.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1dfb3g"&&($.innerHTML=Tt),st=n(t),W=m(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1wmi3ea"&&(W.innerHTML=jt),et=n(t),o(Z.$$.fragment,t),at=n(t),k=m(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-9sr7nh"&&(k.textContent=ut),lt=n(t),o(G.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(N.$$.fragment,t),mt=n(t),x=m(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-xtxxu6"&&(x.innerHTML=bt),it=n(t),o(Q.$$.fragment,t),ot=n(t),o(Y.$$.fragment,t),rt=n(t),o(E.$$.fragment,t),ht=n(t),S=m(t,"P",{}),Ut(S).forEach(e),this.h()},h(){It(y,"name","hf:doc:metadata"),It(y,"content",Qt)},m(t,s){Bt(document.head,y),a(t,_,s),a(t,V,s),a(t,X,s),r(w,t,s),a(t,H,s),a(t,J,s),a(t,z,s),r(d,t,s),a(t,F,s),a(t,T,s),a(t,A,s),r(j,t,s),a(t,L,s),a(t,u,s),a(t,P,s),r(f,t,s),a(t,D,s),a(t,b,s),a(t,q,s),r(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),r(C,t,s),a(t,tt,s),a(t,$,s),a(t,st,s),a(t,W,s),a(t,et,s),r(Z,t,s),a(t,at,s),a(t,k,s),a(t,lt,s),r(G,t,s),a(t,nt,s),a(t,B,s),a(t,pt,s),r(N,t,s),a(t,mt,s),a(t,x,s),a(t,it,s),r(Q,t,s),a(t,ot,s),r(Y,t,s),a(t,rt,s),r(E,t,s),a(t,ht,s),a(t,S,s),ct=!0},p:$t,i(t){ct||(h(w.$$.fragment,t),h(d.$$.fragment,t),h(j.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(Y.$$.fragment,t),h(E.$$.fragment,t),ct=!0)},o(t){c(w.$$.fragment,t),c(d.$$.fragment,t),c(j.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(C.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(N.$$.fragment,t),c(Q.$$.fragment,t),c(Y.$$.fragment,t),c(E.$$.fragment,t),ct=!1},d(t){t&&(e(_),e(V),e(X),e(H),e(J),e(z),e(F),e(T),e(A),e(L),e(u),e(P),e(D),e(b),e(q),e(K),e(I),e(O),e(tt),e($),e(st),e(W),e(et),e(at),e(k),e(lt),e(nt),e(B),e(pt),e(mt),e(x),e(it),e(ot),e(rt),e(ht),e(S)),e(y),g(w,t),g(d,t),g(j,t),g(f,t),g(U,t),g(C,t),g(Z,t),g(G,t),g(N,t),g(Q,t),g(Y,t),g(E,t)}}}const Qt='{"title":"CSP-ResNet","local":"csp-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yt(gt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Zt{constructor(y){super(),kt(this,y,Yt,xt,Ct,{})}}export{Rt as component};
