import{s as Ct,n as Gt,o as Wt}from"../chunks/scheduler.85c25b89.js";import{S as Nt,i as vt,g as p,s as a,r as m,A as Bt,h as i,f as l,c as n,j as Zt,u as o,x as M,k as xt,y as kt,a as e,v as c,d as r,t as h,w as g}from"../chunks/index.c9837788.js";import{C as _}from"../chunks/CodeBlock.e573519b.js";import{H as z,E as Et}from"../chunks/getInferenceSnippets.5d4c70d5.js";function Qt(Jt){let J,Y,R,H,u,S,d,ut='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution</a> layers.',A,j,dt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,w,L,y,jt="To load a pretrained model:",D,T,P,f,wt="To load and preprocess the image:",q,b,K,U,yt="To get the model predictions:",O,$,tt,I,Tt="To get the top-5 predictions class names:",st,Z,lt,x,ft="Replace the model name with the variant you want to use, e.g. <code>gluon_xception65</code>. You can find the IDs in the model summaries at the top of this page.",et,C,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,G,nt,W,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,it,v,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,B,ot,k,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,E,rt,Q,ht,X,gt,V,Mt;return u=new z({props:{title:"(Gluon) Xception",local:"gluon-xception",headingTag:"h1"}}),w=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3hjZXB0aW9uNjUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25feGNlcHRpb242NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new _({props:{code:"JTQwbWlzYyU3QmNob2xsZXQyMDE3eGNlcHRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlhjZXB0aW9uJTNBJTIwRGVlcCUyMExlYXJuaW5nJTIwd2l0aCUyMERlcHRod2lzZSUyMFNlcGFyYWJsZSUyMENvbnZvbHV0aW9ucyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkZyYW4lQzMlQTdvaXMlMjBDaG9sbGV0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxNjEwLjAyMzU3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{chollet2017xception,
      title={Xception: Deep Learning with Depthwise Separable Convolutions}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{François Chollet}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2017}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1610.02357}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),X=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-xception.mdx"}}),{c(){J=p("meta"),Y=a(),R=p("p"),H=a(),m(u.$$.fragment),S=a(),d=p("p"),d.innerHTML=ut,A=a(),j=p("p"),j.innerHTML=dt,F=a(),m(w.$$.fragment),L=a(),y=p("p"),y.textContent=jt,D=a(),m(T.$$.fragment),P=a(),f=p("p"),f.textContent=wt,q=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=yt,O=a(),m($.$$.fragment),tt=a(),I=p("p"),I.textContent=Tt,st=a(),m(Z.$$.fragment),lt=a(),x=p("p"),x.innerHTML=ft,et=a(),C=p("p"),C.innerHTML=bt,at=a(),m(G.$$.fragment),nt=a(),W=p("p"),W.textContent=Ut,pt=a(),m(N.$$.fragment),it=a(),v=p("p"),v.innerHTML=$t,mt=a(),m(B.$$.fragment),ot=a(),k=p("p"),k.innerHTML=It,ct=a(),m(E.$$.fragment),rt=a(),m(Q.$$.fragment),ht=a(),m(X.$$.fragment),gt=a(),V=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),Y=n(t),R=i(t,"P",{}),Zt(R).forEach(l),H=n(t),o(u.$$.fragment,t),S=n(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-2dpud"&&(d.innerHTML=ut),A=n(t),j=i(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1vag5uc"&&(j.innerHTML=dt),F=n(t),o(w.$$.fragment,t),L=n(t),y=i(t,"P",{"data-svelte-h":!0}),M(y)!=="svelte-18ywhxh"&&(y.textContent=jt),D=n(t),o(T.$$.fragment,t),P=n(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),q=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=yt),O=n(t),o($.$$.fragment,t),tt=n(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=Tt),st=n(t),o(Z.$$.fragment,t),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-zau0t5"&&(x.innerHTML=ft),et=n(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1wmi3ea"&&(C.innerHTML=bt),at=n(t),o(G.$$.fragment,t),nt=n(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-9sr7nh"&&(W.textContent=Ut),pt=n(t),o(N.$$.fragment,t),it=n(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1kguc51"&&(v.innerHTML=$t),mt=n(t),o(B.$$.fragment,t),ot=n(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-xtxxu6"&&(k.innerHTML=It),ct=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ht=n(t),o(X.$$.fragment,t),gt=n(t),V=i(t,"P",{}),Zt(V).forEach(l),this.h()},h(){xt(J,"name","hf:doc:metadata"),xt(J,"content",Xt)},m(t,s){kt(document.head,J),e(t,Y,s),e(t,R,s),e(t,H,s),c(u,t,s),e(t,S,s),e(t,d,s),e(t,A,s),e(t,j,s),e(t,F,s),c(w,t,s),e(t,L,s),e(t,y,s),e(t,D,s),c(T,t,s),e(t,P,s),e(t,f,s),e(t,q,s),c(b,t,s),e(t,K,s),e(t,U,s),e(t,O,s),c($,t,s),e(t,tt,s),e(t,I,s),e(t,st,s),c(Z,t,s),e(t,lt,s),e(t,x,s),e(t,et,s),e(t,C,s),e(t,at,s),c(G,t,s),e(t,nt,s),e(t,W,s),e(t,pt,s),c(N,t,s),e(t,it,s),e(t,v,s),e(t,mt,s),c(B,t,s),e(t,ot,s),e(t,k,s),e(t,ct,s),c(E,t,s),e(t,rt,s),c(Q,t,s),e(t,ht,s),c(X,t,s),e(t,gt,s),e(t,V,s),Mt=!0},p:Gt,i(t){Mt||(r(u.$$.fragment,t),r(w.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(Z.$$.fragment,t),r(G.$$.fragment,t),r(N.$$.fragment,t),r(B.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),r(X.$$.fragment,t),Mt=!0)},o(t){h(u.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),Mt=!1},d(t){t&&(l(Y),l(R),l(H),l(S),l(d),l(A),l(j),l(F),l(L),l(y),l(D),l(P),l(f),l(q),l(K),l(U),l(O),l(tt),l(I),l(st),l(lt),l(x),l(et),l(C),l(at),l(nt),l(W),l(pt),l(it),l(v),l(mt),l(ot),l(k),l(ct),l(rt),l(ht),l(gt),l(V)),l(J),g(u,t),g(w,t),g(T,t),g(b,t),g($,t),g(Z,t),g(G,t),g(N,t),g(B,t),g(E,t),g(Q,t),g(X,t)}}}const Xt='{"title":"(Gluon) Xception","local":"gluon-xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _t(Jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Nt{constructor(J){super(),vt(this,J,_t,Qt,Ct,{})}}export{Ht as component};
