import{s as xs,n as Ns,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as Ws,g as p,s as e,r as i,A as ks,h as m,f as t,c as n,j as Us,u as o,x as g,k as Is,y as Bs,a,v as c,d as r,t as M,w as h}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.e573519b.js";import{H as X,E as Gs}from"../chunks/getInferenceSnippets.5d4c70d5.js";function Cs(hs){let J,S,Y,_,d,z,j,gs='<strong>Res2NeXt</strong> is an image model that employs a variation on <a href="https://paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> bottleneck residual blocks. The motivation is to be able to represent features at multiple scales. This is achieved through a novel building block for CNNs that constructs hierarchical residual-like connections within one single residual block. This represents multi-scale features at a granular level and increases the range of receptive fields for each network layer.',H,y,A,u,Js="To load a pretrained model:",F,T,L,w,ds="To load and preprocess the image:",D,b,P,f,js="To get the model predictions:",q,U,K,I,ys="To get the top-5 predictions class names:",O,x,ss,N,us="Replace the model name with the variant you want to use, e.g. <code>res2next50</code>. You can find the IDs in the model summaries at the top of this page.",ls,$,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,Z,as,W,ws="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,k,ns,B,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,ms,C,fs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,E,os,Q,cs,v,rs,V,Ms;return d=new X({props:{title:"Res2NeXt",local:"res2next",headingTag:"h1"}}),y=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlczJuZXh0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzMm5leHQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new R({props:{code:"JTQwYXJ0aWNsZSU3Qkdhb18yMDIxJTJDJTBBJTIwJTIwJTIwdGl0bGUlM0QlN0JSZXMyTmV0JTNBJTIwQSUyME5ldyUyME11bHRpLVNjYWxlJTIwQmFja2JvbmUlMjBBcmNoaXRlY3R1cmUlN0QlMkMlMEElMjAlMjAlMjB2b2x1bWUlM0QlN0I0MyU3RCUyQyUwQSUyMCUyMCUyMElTU04lM0QlN0IxOTM5LTM1MzklN0QlMkMlMEElMjAlMjAlMjB1cmwlM0QlN0JodHRwJTNBJTJGJTJGZHguZG9pLm9yZyUyRjEwLjExMDklMkZUUEFNSS4yMDE5LjI5Mzg3NTglN0QlMkMlMEElMjAlMjAlMjBET0klM0QlN0IxMC4xMTA5JTJGdHBhbWkuMjAxOS4yOTM4NzU4JTdEJTJDJTBBJTIwJTIwJTIwbnVtYmVyJTNEJTdCMiU3RCUyQyUwQSUyMCUyMCUyMGpvdXJuYWwlM0QlN0JJRUVFJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBQYXR0ZXJuJTIwQW5hbHlzaXMlMjBhbmQlMjBNYWNoaW5lJTIwSW50ZWxsaWdlbmNlJTdEJTJDJTBBJTIwJTIwJTIwcHVibGlzaGVyJTNEJTdCSW5zdGl0dXRlJTIwb2YlMjBFbGVjdHJpY2FsJTIwYW5kJTIwRWxlY3Ryb25pY3MlMjBFbmdpbmVlcnMlMjAoSUVFRSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JHYW8lMkMlMjBTaGFuZy1IdWElMjBhbmQlMjBDaGVuZyUyQyUyME1pbmctTWluZyUyMGFuZCUyMFpoYW8lMkMlMjBLYWklMjBhbmQlMjBaaGFuZyUyQyUyMFhpbi1ZdSUyMGFuZCUyMFlhbmclMkMlMjBNaW5nLUhzdWFuJTIwYW5kJTIwVG9yciUyQyUyMFBoaWxpcCU3RCUyQyUwQSUyMCUyMCUyMHllYXIlM0QlN0IyMDIxJTdEJTJDJTBBJTIwJTIwJTIwbW9udGglM0QlN0JGZWIlN0QlMkMlMEElMjAlMjAlMjBwYWdlcyUzRCU3QjY1MiVFMiU4MCU5MzY2MiU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Gao_2021,
   title={Res2Net: A New Multi-Scale Backbone Architecture}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{43}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1939-3539}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1109/TPAMI.2019.2938758}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1109/tpami.2019.2938758}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{2}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{IEEE Transactions on Pattern Analysis and Machine Intelligence}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Institute of Electrical and Electronics Engineers (IEEE)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Gao, Shang-Hua and Cheng, Ming-Ming and Zhao, Kai and Zhang, Xin-Yu and Yang, Ming-Hsuan and Torr, Philip}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2021}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Feb}</span><span class="language-xml">,
   pages=</span><span class="hljs-template-variable">{652–662}</span><span class="language-xml">
}</span>`,wrap:!1}}),v=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/res2next.mdx"}}),{c(){J=p("meta"),S=e(),Y=p("p"),_=e(),i(d.$$.fragment),z=e(),j=p("p"),j.innerHTML=gs,H=e(),i(y.$$.fragment),A=e(),u=p("p"),u.textContent=Js,F=e(),i(T.$$.fragment),L=e(),w=p("p"),w.textContent=ds,D=e(),i(b.$$.fragment),P=e(),f=p("p"),f.textContent=js,q=e(),i(U.$$.fragment),K=e(),I=p("p"),I.textContent=ys,O=e(),i(x.$$.fragment),ss=e(),N=p("p"),N.innerHTML=us,ls=e(),$=p("p"),$.innerHTML=Ts,ts=e(),i(Z.$$.fragment),as=e(),W=p("p"),W.textContent=ws,es=e(),i(k.$$.fragment),ns=e(),B=p("p"),B.innerHTML=bs,ps=e(),i(G.$$.fragment),ms=e(),C=p("p"),C.innerHTML=fs,is=e(),i(E.$$.fragment),os=e(),i(Q.$$.fragment),cs=e(),i(v.$$.fragment),rs=e(),V=p("p"),this.h()},l(s){const l=ks("svelte-u9bgzb",document.head);J=m(l,"META",{name:!0,content:!0}),l.forEach(t),S=n(s),Y=m(s,"P",{}),Us(Y).forEach(t),_=n(s),o(d.$$.fragment,s),z=n(s),j=m(s,"P",{"data-svelte-h":!0}),g(j)!=="svelte-ayu0xr"&&(j.innerHTML=gs),H=n(s),o(y.$$.fragment,s),A=n(s),u=m(s,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=Js),F=n(s),o(T.$$.fragment,s),L=n(s),w=m(s,"P",{"data-svelte-h":!0}),g(w)!=="svelte-1c2ipa8"&&(w.textContent=ds),D=n(s),o(b.$$.fragment,s),P=n(s),f=m(s,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1n9qsq1"&&(f.textContent=js),q=n(s),o(U.$$.fragment,s),K=n(s),I=m(s,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=ys),O=n(s),o(x.$$.fragment,s),ss=n(s),N=m(s,"P",{"data-svelte-h":!0}),g(N)!=="svelte-199rhg"&&(N.innerHTML=us),ls=n(s),$=m(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-1wmi3ea"&&($.innerHTML=Ts),ts=n(s),o(Z.$$.fragment,s),as=n(s),W=m(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=ws),es=n(s),o(k.$$.fragment,s),ns=n(s),B=m(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=bs),ps=n(s),o(G.$$.fragment,s),ms=n(s),C=m(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-xtxxu6"&&(C.innerHTML=fs),is=n(s),o(E.$$.fragment,s),os=n(s),o(Q.$$.fragment,s),cs=n(s),o(v.$$.fragment,s),rs=n(s),V=m(s,"P",{}),Us(V).forEach(t),this.h()},h(){Is(J,"name","hf:doc:metadata"),Is(J,"content",Es)},m(s,l){Bs(document.head,J),a(s,S,l),a(s,Y,l),a(s,_,l),c(d,s,l),a(s,z,l),a(s,j,l),a(s,H,l),c(y,s,l),a(s,A,l),a(s,u,l),a(s,F,l),c(T,s,l),a(s,L,l),a(s,w,l),a(s,D,l),c(b,s,l),a(s,P,l),a(s,f,l),a(s,q,l),c(U,s,l),a(s,K,l),a(s,I,l),a(s,O,l),c(x,s,l),a(s,ss,l),a(s,N,l),a(s,ls,l),a(s,$,l),a(s,ts,l),c(Z,s,l),a(s,as,l),a(s,W,l),a(s,es,l),c(k,s,l),a(s,ns,l),a(s,B,l),a(s,ps,l),c(G,s,l),a(s,ms,l),a(s,C,l),a(s,is,l),c(E,s,l),a(s,os,l),c(Q,s,l),a(s,cs,l),c(v,s,l),a(s,rs,l),a(s,V,l),Ms=!0},p:Ns,i(s){Ms||(r(d.$$.fragment,s),r(y.$$.fragment,s),r(T.$$.fragment,s),r(b.$$.fragment,s),r(U.$$.fragment,s),r(x.$$.fragment,s),r(Z.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(Q.$$.fragment,s),r(v.$$.fragment,s),Ms=!0)},o(s){M(d.$$.fragment,s),M(y.$$.fragment,s),M(T.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(x.$$.fragment,s),M(Z.$$.fragment,s),M(k.$$.fragment,s),M(G.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),M(v.$$.fragment,s),Ms=!1},d(s){s&&(t(S),t(Y),t(_),t(z),t(j),t(H),t(A),t(u),t(F),t(L),t(w),t(D),t(P),t(f),t(q),t(K),t(I),t(O),t(ss),t(N),t(ls),t($),t(ts),t(as),t(W),t(es),t(ns),t(B),t(ps),t(ms),t(C),t(is),t(os),t(cs),t(rs),t(V)),t(J),h(d,s),h(y,s),h(T,s),h(b,s),h(U,s),h(x,s),h(Z,s),h(k,s),h(G,s),h(E,s),h(Q,s),h(v,s)}}}const Es='{"title":"Res2NeXt","local":"res2next","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(hs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Zs{constructor(J){super(),Ws(this,J,Qs,Cs,xs,{})}}export{Xs as component};
