import{s as Gn,o as Fn,n as Un}from"../chunks/scheduler.49e4e380.js";import{S as Zn,i as Wn,g as a,s as l,r as u,A as _n,h as r,f as t,c as s,j as Jn,u as p,x as o,k as vn,y as Rn,a as i,v as m,d as c,t as M,w as f}from"../chunks/index.fb15006d.js";import{T as zn}from"../chunks/Tip.f590f2e1.js";import{Y as Cn}from"../chunks/Youtube.42918e4e.js";import{C as g}from"../chunks/CodeBlock.f39e0d63.js";import{C as Hn}from"../chunks/CourseFloatingBanner.3ce48d00.js";import{F as En}from"../chunks/FrameworkSwitchCourse.f837e098.js";import{H as Oe}from"../chunks/Heading.5d1ab858.js";function In(y){let d,h='💡 Wenn du dein Modell während des Trainings automatisch in das Hub hochladen möchtest, kann in <code>TrainingArguments</code> das Argument <code>push_to_hub=True</code> angegeben werden. Darüber erfahren wir in <a href="/course/chapter4/3">Kapitel 4</a> mehr.';return{c(){d=a("p"),d.innerHTML=h},l(b){d=r(b,"P",{"data-svelte-h":!0}),o(d)!=="svelte-ssdwbi"&&(d.innerHTML=h)},m(b,w){i(b,d,w)},p:Un,d(b){b&&t(d)}}}function Vn(y){let d,h="✏️ <strong>Probier es aus!</strong> Fein-tune ein Modell mit dem GLUE SST-2 Datensatz, indem du die Datenverarbeitung aus Abschnitt 2 verwendest.";return{c(){d=a("p"),d.innerHTML=h},l(b){d=r(b,"P",{"data-svelte-h":!0}),o(d)!=="svelte-psk4g8"&&(d.innerHTML=h)},m(b,w){i(b,d,w)},p:Un,d(b){b&&t(d)}}}function Xn(y){let d,h,b,w,T,ue,j,pe,J,me,v,ce,z,en='🤗 Transformers stellt eine <code>Trainer</code>-Klasse bereit, mit der du Modelle auf deinen Datensätzen fein-tunen kannst. Nachdem die Datenverarbeitung im letzten Abschnitt abgeschlossen ist, bleiben nur noch wenige Schritte, um den <code>Trainer</code> zu definieren. Der schwierigste Teil ist die Vorbereitung der Umgebung um <code>Trainer.train()</code> auszuführen, da dies auf einer CPU sehr langsam läuft. Wenn keine GPU verfügbar ist, kannst du bei [Google Colab] (<a href="https://colab.research.google.com/" rel="nofollow">https://colab.research.google.com/</a>) auf kostenlose GPUs oder TPUs zugreifen.',Me,U,nn="In den folgenden Code-Beispielen wird davon ausgegangen, dass du die Beispiele aus dem vorherigen Abschnitt bereits ausgeführt hast. Hier ist eine kurze Zusammenfassung, die dir zeigt, was erwartet wird:",fe,G,be,F,ge,Z,tn="Als erstes müssen wir eine Klasse <code>TrainingArguments</code> definieren, die alle Hyperparameter enthält, die der <code>Trainer</code> für das Training und die Evaluation verwendet. Das einzige Argument das hier angegeben werden muss, ist ein Verzeichnis in dem das trainierte Modell sowie die Checkpoints gespeichert werden. Für alles andere können die Standardeinstellungen verwendet werden. Diese sollten für ein grundlegendes Fein-tunen ausreichen.",he,W,we,$,Te,_,ln='Der zweite Schritt ist die Definition unseres Modells. Wie im <a href="/course/chapter2">vorherigen Kapitel</a> verwenden wir die Klasse <code>AutoModelForSequenceClassification</code> mit zwei Labels:',$e,R,ke,C,sn='Du wirst feststellen, dass du im Gegensatz zu <a href="/course/chapter2">Kapitel 2</a> eine Warnung erhältst, nachdem du dieses vortrainierte Modell instanziiert hast. Der Grund dafür ist, dass BERT nicht auf die Klassifizierung von Satzpaaren vortrainiert wurde. Deshalb wurde der Kopf des vortrainierten Modells verworfen und stattdessen ein neuer Kopf hinzugefügt, der für die Klassifizierung von Sequenzen geeignet ist. Diese Warnungen weisen darauf hin, dass Teile der Gewichtung nicht verwendet wurden (die Gewichte für den verworfenen Kopf) und dass einige andere zufällig initialisiert wurden (die Gewichte für den neuen Kopf). Abschließend werden wir aufgefordert, das Modell zu trainieren, und genau das werden wir jetzt tun.',ye,H,an="Sobald wir unser Modell haben, können wir einen <code>Trainer</code> definieren, indem wir alle bisher erstellten Objekte übergeben - das <code>Modell</code>, die <code>training_args</code>, die Trainings- und Validierungsdaten, unseren <code>data_collator</code> und unseren <code>tokenizer</code>:",je,E,Je,I,rn="Merke: Wenn der <code>tokenizer</code> übergeben wird, wie wir es hier getan haben, wird der vom <code>Trainer</code> verwendete <code>data_collator</code> standardmäßig ein <code>DataCollatorWithPadding</code> sein, wie er zuvor definiert wurde. Deshalb kannst du die Zeile <code>data_collator=data_collator</code> in diesem Aufruf weglassen. Unabhängig davon war es trotzdem wichtig, diesen Teil der Verarbeitung in Abschnitt 2 zu zeigen!",ve,V,dn="Um das Modell auf unserem Datensatz fein-tunen zu können, müssen wir nur die Methode <code>train()</code> unseres <code>Trainers</code> aufrufen:",ze,X,Ue,B,on="Dadurch wird das Fein-tunen gestartet (was auf einer GPU ein paar Minuten dauern sollte) und der Trainingsverlust wird alle 500 Schritte gemeldet. Es wird jedoch nicht zurückgegeben, wie gut (oder schlecht) das Modell funktioniert. Dies liegt an folgenden Punkten:",Ge,A,un="<li>Wir haben dem <code>Trainer</code> nicht mitgeteilt die Performance in der Trainingsschleife auszuwerten, indem wir <code>evaluation_strategy</code> entweder auf <code>&quot;steps&quot;</code> (alle <code>eval_steps</code> auswerten) oder <code>&quot;epoch&quot;</code> (am Ende jeder Epoche evaluieren) gesetzt haben.</li> <li>Wir haben dem <code>Trainer</code> keine Funktion <code>compute_metrics()</code> zur Verfügung gestellt, um während der Evaluation eine Metrik zu berechnen (sonst hätte die Evaluation nur den Verlust ausgegeben, was keine sehr intuitive Zahl ist).</li>",Fe,x,Ze,Y,pn="Im Folgenden wird gezeigt, wie wir eine <code>compute_metrics()</code>-Funktion erstellen und sie beim nächsten Training verwenden können. Die Funktion muss ein <code>EvalPrediction</code>-Objekt (ein bennantes Tupel mit einem <code>predictions</code>-Feld und einem <code>label_ids</code>-Feld) annehmen und ein Dictionary zurückgeben, das Strings auf Floats abbildet (die Strings sind die Namen der zurückgegebenen Metriken und die Floats ihre zugehörigen Werte). Um Vorhersagen von unserem Modell zu erhalten, können wir den Befehl “Trainer.predict()” verwenden:",We,L,_e,D,Re,N,mn="Die Ausgabe der <code>predict()</code>-Methode ist ein weiteres benanntes Tupel mit drei Feldern: <code>predictions</code>, <code>label_ids</code> und <code>metrics</code>. Das Feld <code>metrics</code> enthält den Verlust des übergebenen Datensatzes sowie Zeitangaben dazu, wie lange die Vorhersage insgesamt und im Durchschnitt gedauert hat. Sobald wir unsere Funktion <code>compute_metrics()</code> fertiggestellt haben und sie an den <code>Trainer</code> übergeben, enthält dieses Feld auch die von der <code>compute_metrics()</code>-Funktion zurückgegebenen Metriken.",Ce,Q,cn='Die Vorhersagen in <code>predictions</code> sind ein zweidimensionales Array mit der Form 408 x 2 (408 ist die Anzahl der Elemente unseres Datensatzes). Das sind die Logits für jedes Element des Datensatzes, das wir an <code>predict()</code> übergeben haben (siehe <a href="/course/chapter2">vorheriges Kapitel</a> dass alle Transformer Modelle Logits zurückgeben). Um diese in Vorhersagen umzuwandeln, die wir mit den Labels vergleichen können, müssen wir den Index mit dem höchsten Wert auf der zweiten Achse nehmen:',He,q,Ee,P,Mn='Jetzt können wir diese Vorhersagen in <code>preds</code> mit den Labels vergleichen. Wir greifen auf die Metriken aus der 🤗 Bibliothek <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> zurück, um unsere Funktion <code>compute_metric()</code> zu erstellen. Die mit dem MRPC-Datensatz verbundenen Metriken können genauso einfach geladen werden, wie wir den Datensatz geladen haben, diesmal mit der Funktion <code>evaluate.load()</code>. Das zurückgegebene Objekt verfügt über eine Berechnungsmethode, mit der wir die Metrik auswerten können:',Ie,S,Ve,K,Xe,O,fn='Die genauen Ergebnisse können variieren, da die zufällige Initialisierung des Modellkopfes den Optimierungsverlauf und damit die Metriken verändern kann. Hier hat das Modell eine Genauigkeit von 85,78 % über die Validierungsdaten und eine F1-Maß von 89,97 erreicht hat. Dies sind die beiden Kennzahlen, die zur Bewertung der Ergebnisse des MRPC-Datensatzes für den GLUE-Benchmark verwendet werden. In der Tabelle im [BERT-Paper] (<a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">https://arxiv.org/pdf/1810.04805.pdf</a>) wird für das Basismodell ein F1-Maß von 88,9 angegeben. Das Paper hat das <code>uncased</code> Modell verwendet, während wir derzeit das <code>cased</code> Modell verwenden, was das bessere Ergebnis erklärt.',Be,ee,bn="Zusammenfassend ergibt das unsere Funktion <code>compute_metrics()</code>:",Ae,ne,xe,te,gn="Um diese Funktion in Aktion zu sehen, definieren wir einen neuen <code>Trainer</code> mit der Funktion “compute_metrics()”, um am Ende jeder Epoche Metriken zu melden:",Ye,ie,Le,le,hn="Hier ein Hinweis, dass wir ein neues <code>TrainingArguments</code> errstellen, dessen <code>evaluation_strategy</code> auf <code>&quot;epoch&quot;</code> gesetzt ist, und ein neues Modell definieren - andernfalls würden wir nur das Training des momentanen Modells fortführen, das wir bereits trainiert haben. Um einen neuen Trainingslauf zu starten, führen wir folgendes aus:",De,se,Ne,ae,wn="Nun werden am Ende jeder Epoche zusätzlich zu den Trainingsverlusten auch die Validierungsverluste und -metriken gemeldet. Auch hier kann die Genauigkeit/F1-Maß aufgrund der zufälligen Initialisierung des Modells zu unserem Beispiel variieren, aber sie sollte in etwa gleich sein.",Qe,re,Tn="Der <code>Trainer</code> funktioniert sofort auf mehreren GPUs oder TPUs und bietet zahlreiche Optionen, wie z. B. Training mit gemischter Genauigkeit (verwende <code>fp16 = True</code> in deinen Trainingsargumenten). In Kapitel 10 gehen wir auf alle Funktionen ein, die die <code>Trainer</code>-Klasse bereitstellt.",qe,de,$n="Damit ist die Einführung in das Fein-tunen mit der <code>Trainer</code> API abgeschlossen. Beispiele für die gängigsten CL-Aufgaben werden in Kapitel 7 gegeben, aber jetzt schauen wir uns erst einmal an, wie man das Gleiche in PyTorch bewerkstelligen kann.",Pe,k,Se,oe,Ke;return T=new En({props:{fw:y[0]}}),j=new Oe({props:{title:"Fine-tuning eine Modells mit der Trainer API",local:"fine-tuning-eine-modells-mit-der-trainer-api",headingTag:"h1"}}),J=new Hn({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/de/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/de/chapter3/section3.ipynb"}]}}),v=new Cn({props:{id:"nvBXf7s7vTI"}}),G=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),F=new Oe({props:{title:"Training",local:"training",headingTag:"h3"}}),W=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),$=new zn({props:{$$slots:{default:[In]},$$scope:{ctx:y}}}),R=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new g({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),x=new Oe({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),L=new g({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),D=new g({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),q=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),S=new g({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),K=new g({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),ne=new g({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),ie=new g({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),se=new g({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),k=new zn({props:{$$slots:{default:[Vn]},$$scope:{ctx:y}}}),{c(){d=a("meta"),h=l(),b=a("p"),w=l(),u(T.$$.fragment),ue=l(),u(j.$$.fragment),pe=l(),u(J.$$.fragment),me=l(),u(v.$$.fragment),ce=l(),z=a("p"),z.innerHTML=en,Me=l(),U=a("p"),U.textContent=nn,fe=l(),u(G.$$.fragment),be=l(),u(F.$$.fragment),ge=l(),Z=a("p"),Z.innerHTML=tn,he=l(),u(W.$$.fragment),we=l(),u($.$$.fragment),Te=l(),_=a("p"),_.innerHTML=ln,$e=l(),u(R.$$.fragment),ke=l(),C=a("p"),C.innerHTML=sn,ye=l(),H=a("p"),H.innerHTML=an,je=l(),u(E.$$.fragment),Je=l(),I=a("p"),I.innerHTML=rn,ve=l(),V=a("p"),V.innerHTML=dn,ze=l(),u(X.$$.fragment),Ue=l(),B=a("p"),B.textContent=on,Ge=l(),A=a("ol"),A.innerHTML=un,Fe=l(),u(x.$$.fragment),Ze=l(),Y=a("p"),Y.innerHTML=pn,We=l(),u(L.$$.fragment),_e=l(),u(D.$$.fragment),Re=l(),N=a("p"),N.innerHTML=mn,Ce=l(),Q=a("p"),Q.innerHTML=cn,He=l(),u(q.$$.fragment),Ee=l(),P=a("p"),P.innerHTML=Mn,Ie=l(),u(S.$$.fragment),Ve=l(),u(K.$$.fragment),Xe=l(),O=a("p"),O.innerHTML=fn,Be=l(),ee=a("p"),ee.innerHTML=bn,Ae=l(),u(ne.$$.fragment),xe=l(),te=a("p"),te.innerHTML=gn,Ye=l(),u(ie.$$.fragment),Le=l(),le=a("p"),le.innerHTML=hn,De=l(),u(se.$$.fragment),Ne=l(),ae=a("p"),ae.textContent=wn,Qe=l(),re=a("p"),re.innerHTML=Tn,qe=l(),de=a("p"),de.innerHTML=$n,Pe=l(),u(k.$$.fragment),Se=l(),oe=a("p"),this.h()},l(e){const n=_n("svelte-u9bgzb",document.head);d=r(n,"META",{name:!0,content:!0}),n.forEach(t),h=s(e),b=r(e,"P",{}),Jn(b).forEach(t),w=s(e),p(T.$$.fragment,e),ue=s(e),p(j.$$.fragment,e),pe=s(e),p(J.$$.fragment,e),me=s(e),p(v.$$.fragment,e),ce=s(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-9d2807"&&(z.innerHTML=en),Me=s(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1s4hy72"&&(U.textContent=nn),fe=s(e),p(G.$$.fragment,e),be=s(e),p(F.$$.fragment,e),ge=s(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-vfqe9h"&&(Z.innerHTML=tn),he=s(e),p(W.$$.fragment,e),we=s(e),p($.$$.fragment,e),Te=s(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-d0b7yv"&&(_.innerHTML=ln),$e=s(e),p(R.$$.fragment,e),ke=s(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-9zvea3"&&(C.innerHTML=sn),ye=s(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-wwe4zi"&&(H.innerHTML=an),je=s(e),p(E.$$.fragment,e),Je=s(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1tk35u1"&&(I.innerHTML=rn),ve=s(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1dw6zzx"&&(V.innerHTML=dn),ze=s(e),p(X.$$.fragment,e),Ue=s(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-aqyj1w"&&(B.textContent=on),Ge=s(e),A=r(e,"OL",{"data-svelte-h":!0}),o(A)!=="svelte-814nqm"&&(A.innerHTML=un),Fe=s(e),p(x.$$.fragment,e),Ze=s(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-19anrgh"&&(Y.innerHTML=pn),We=s(e),p(L.$$.fragment,e),_e=s(e),p(D.$$.fragment,e),Re=s(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-dibgb"&&(N.innerHTML=mn),Ce=s(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-srb3qk"&&(Q.innerHTML=cn),He=s(e),p(q.$$.fragment,e),Ee=s(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1ipx9m0"&&(P.innerHTML=Mn),Ie=s(e),p(S.$$.fragment,e),Ve=s(e),p(K.$$.fragment,e),Xe=s(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1roxbmr"&&(O.innerHTML=fn),Be=s(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1xoww1g"&&(ee.innerHTML=bn),Ae=s(e),p(ne.$$.fragment,e),xe=s(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-ppv177"&&(te.innerHTML=gn),Ye=s(e),p(ie.$$.fragment,e),Le=s(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-z8nmap"&&(le.innerHTML=hn),De=s(e),p(se.$$.fragment,e),Ne=s(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-t9fcc9"&&(ae.textContent=wn),Qe=s(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1nf0rt5"&&(re.innerHTML=Tn),qe=s(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-jerq58"&&(de.innerHTML=$n),Pe=s(e),p(k.$$.fragment,e),Se=s(e),oe=r(e,"P",{}),Jn(oe).forEach(t),this.h()},h(){vn(d,"name","hf:doc:metadata"),vn(d,"content",Bn)},m(e,n){Rn(document.head,d),i(e,h,n),i(e,b,n),i(e,w,n),m(T,e,n),i(e,ue,n),m(j,e,n),i(e,pe,n),m(J,e,n),i(e,me,n),m(v,e,n),i(e,ce,n),i(e,z,n),i(e,Me,n),i(e,U,n),i(e,fe,n),m(G,e,n),i(e,be,n),m(F,e,n),i(e,ge,n),i(e,Z,n),i(e,he,n),m(W,e,n),i(e,we,n),m($,e,n),i(e,Te,n),i(e,_,n),i(e,$e,n),m(R,e,n),i(e,ke,n),i(e,C,n),i(e,ye,n),i(e,H,n),i(e,je,n),m(E,e,n),i(e,Je,n),i(e,I,n),i(e,ve,n),i(e,V,n),i(e,ze,n),m(X,e,n),i(e,Ue,n),i(e,B,n),i(e,Ge,n),i(e,A,n),i(e,Fe,n),m(x,e,n),i(e,Ze,n),i(e,Y,n),i(e,We,n),m(L,e,n),i(e,_e,n),m(D,e,n),i(e,Re,n),i(e,N,n),i(e,Ce,n),i(e,Q,n),i(e,He,n),m(q,e,n),i(e,Ee,n),i(e,P,n),i(e,Ie,n),m(S,e,n),i(e,Ve,n),m(K,e,n),i(e,Xe,n),i(e,O,n),i(e,Be,n),i(e,ee,n),i(e,Ae,n),m(ne,e,n),i(e,xe,n),i(e,te,n),i(e,Ye,n),m(ie,e,n),i(e,Le,n),i(e,le,n),i(e,De,n),m(se,e,n),i(e,Ne,n),i(e,ae,n),i(e,Qe,n),i(e,re,n),i(e,qe,n),i(e,de,n),i(e,Pe,n),m(k,e,n),i(e,Se,n),i(e,oe,n),Ke=!0},p(e,[n]){const kn={};n&1&&(kn.fw=e[0]),T.$set(kn);const yn={};n&2&&(yn.$$scope={dirty:n,ctx:e}),$.$set(yn);const jn={};n&2&&(jn.$$scope={dirty:n,ctx:e}),k.$set(jn)},i(e){Ke||(c(T.$$.fragment,e),c(j.$$.fragment,e),c(J.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(F.$$.fragment,e),c(W.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(q.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(se.$$.fragment,e),c(k.$$.fragment,e),Ke=!0)},o(e){M(T.$$.fragment,e),M(j.$$.fragment,e),M(J.$$.fragment,e),M(v.$$.fragment,e),M(G.$$.fragment,e),M(F.$$.fragment,e),M(W.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(E.$$.fragment,e),M(X.$$.fragment,e),M(x.$$.fragment,e),M(L.$$.fragment,e),M(D.$$.fragment,e),M(q.$$.fragment,e),M(S.$$.fragment,e),M(K.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(se.$$.fragment,e),M(k.$$.fragment,e),Ke=!1},d(e){e&&(t(h),t(b),t(w),t(ue),t(pe),t(me),t(ce),t(z),t(Me),t(U),t(fe),t(be),t(ge),t(Z),t(he),t(we),t(Te),t(_),t($e),t(ke),t(C),t(ye),t(H),t(je),t(Je),t(I),t(ve),t(V),t(ze),t(Ue),t(B),t(Ge),t(A),t(Fe),t(Ze),t(Y),t(We),t(_e),t(Re),t(N),t(Ce),t(Q),t(He),t(Ee),t(P),t(Ie),t(Ve),t(Xe),t(O),t(Be),t(ee),t(Ae),t(xe),t(te),t(Ye),t(Le),t(le),t(De),t(Ne),t(ae),t(Qe),t(re),t(qe),t(de),t(Pe),t(Se),t(oe)),t(d),f(T,e),f(j,e),f(J,e),f(v,e),f(G,e),f(F,e),f(W,e),f($,e),f(R,e),f(E,e),f(X,e),f(x,e),f(L,e),f(D,e),f(q,e),f(S,e),f(K,e),f(ne,e),f(ie,e),f(se,e),f(k,e)}}}const Bn='{"title":"Fine-tuning eine Modells mit der Trainer API","local":"fine-tuning-eine-modells-mit-der-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function An(y,d,h){let b="pt";return Fn(()=>{const w=new URLSearchParams(window.location.search);h(0,b=w.get("fw")||"pt")}),[b]}class Sn extends Zn{constructor(d){super(),Wn(this,d,An,Xn,Gn,{})}}export{Sn as component};
