import{s as At,o as qt,n as Pt}from"../chunks/scheduler.9bc65507.js";import{S as St,i as Kt,g as o,s,r as p,A as Dt,h as r,f as a,c as n,j as Yt,u as i,x as b,k as we,y as Ot,a as l,v as d,d as m,t as f,w as u}from"../chunks/index.707bf1b6.js";import{T as zt}from"../chunks/Tip.c2ecdbf4.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{D as ea}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as T}from"../chunks/Heading.342b1fa6.js";function ta(ye){let c,y="You can load a PEFT adapter with either an <code>AutoModelFor</code> class or the base model class like <code>OPTForCausalLM</code> or <code>LlamaForCausalLM</code>.";return{c(){c=o("p"),c.innerHTML=y},l(M){c=r(M,"P",{"data-svelte-h":!0}),b(c)!=="svelte-1cdoj9o"&&(c.innerHTML=y)},m(M,w){l(M,c,w)},p:Pt,d(M){M&&a(c)}}}function aa(ye){let c,y='If you aren’t familiar with fine-tuning a model with <a href="/docs/transformers/v4.39.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the <a href="training">Fine-tune a pretrained model</a> tutorial.';return{c(){c=o("p"),c.innerHTML=y},l(M){c=r(M,"P",{"data-svelte-h":!0}),b(c)!=="svelte-w21w8r"&&(c.innerHTML=y)},m(M,w){l(M,c,w)},p:Pt,d(M){M&&a(c)}}}function la(ye){let c,y,M,w,k,$e,Z,ge,v,Tt='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it. The adapters are trained to learn task-specific information. This approach has been shown to be very memory-efficient with lower compute usage while producing results comparable to a fully fine-tuned model.',Je,U,wt="Adapters trained with PEFT are also usually an order of magnitude smaller than the full model, making it convenient to share, store, and load them.",Ce,$,$t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a OPTForCausalLM model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',_e,F,gt='If you’re interested in learning more about the 🤗 PEFT library, check out the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',ke,W,Ze,j,Jt="Get started by installing 🤗 PEFT:",ve,B,Ue,R,Ct="If you want to try out the brand new features, you might be interested in installing the library from source:",Fe,V,We,E,je,G,_t="🤗 Transformers natively supports some PEFT methods, meaning you can load adapter weights stored locally or on the Hub and easily run or train them with a few lines of code. The following methods are supported:",Be,x,kt='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',Re,X,Zt='If you want to use other PEFT methods, such as prompt learning or prompt tuning, or about the 🤗 PEFT library in general, please refer to the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',Ve,H,Ee,L,vt="To load and use a PEFT adapter model from 🤗 Transformers, make sure the Hub repository or local directory contains an <code>adapter_config.json</code> file and the adapter weights, as shown in the example image above. Then you can load the PEFT adapter model using the <code>AutoModelFor</code> class. For example, to load a PEFT adapter model for causal language modeling:",Ge,Q,Ut='<li>specify the PEFT model id</li> <li>pass it to the <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> class</li>',xe,I,Xe,g,He,N,Ft="You can also load a PEFT adapter by calling the <code>load_adapter</code> method:",Le,Y,Qe,z,Ie,P,Wt='The <code>bitsandbytes</code> integration supports 8bit and 4bit precision data types, which are useful for loading large models because it saves memory (see the <code>bitsandbytes</code> integration <a href="./quantization#bitsandbytes-integration">guide</a> to learn more). Add the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters to <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and set <code>device_map=&quot;auto&quot;</code> to effectively distribute the model to your hardware:',Ne,A,Ye,q,ze,S,jt="You can use <code>~peft.PeftModel.add_adapter</code> to add a new adapter to a model with an existing adapter as long as the new adapter is the same type as the current one. For example, if you have an existing LoRA adapter attached to a model:",Pe,K,Ae,D,Bt="To add a new adapter:",qe,O,Se,ee,Rt="Now you can use <code>~peft.PeftModel.set_adapter</code> to set which adapter to use:",Ke,te,De,ae,Oe,le,Vt="Once you’ve added an adapter to a model, you can enable or disable the adapter module. To enable the adapter module:",et,se,tt,ne,Et="To disable the adapter module:",at,oe,lt,re,st,pe,Gt='PEFT adapters are supported by the <a href="/docs/transformers/v4.39.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> class so that you can train an adapter for your specific use case. It only requires adding a few more lines of code. For example, to train a LoRA adapter:',nt,J,ot,ie,xt="<li>Define your adapter configuration with the task type and hyperparameters (see <code>~peft.LoraConfig</code> for more details about what the hyperparameters do).</li>",rt,de,pt,C,Xt="<li>Add adapter to the model.</li>",it,me,dt,_,Ht='<li>Now you can pass the model to <a href="/docs/transformers/v4.39.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>!</li>',mt,fe,ft,ue,Lt="To save your trained adapter and load it back:",ut,be,bt,ce,ct,Me,Qt="You can also fine-tune additional trainable adapters on top of a model that has adapters attached by passing <code>modules_to_save</code> in your PEFT config. For example, if you want to also fine-tune the lm_head on top of a model with a LoRA adapter:",Mt,he,ht,Te,yt;return k=new T({props:{title:"Load adapters with 🤗 PEFT",local:"load-adapters-with--peft",headingTag:"h1"}}),Z=new ea({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"}]}}),W=new T({props:{title:"Setup",local:"setup",headingTag:"h2"}}),B=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),V=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),E=new T({props:{title:"Supported PEFT models",local:"supported-peft-models",headingTag:"h2"}}),H=new T({props:{title:"Load a PEFT adapter",local:"load-a-peft-adapter",headingTag:"h2"}}),I=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),g=new zt({props:{$$slots:{default:[ta]},$$scope:{ctx:ye}}}),Y=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),z=new T({props:{title:"Load in 8bit or 4bit",local:"load-in-8bit-or-4bit",headingTag:"h2"}}),A=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),q=new T({props:{title:"Add a new adapter",local:"add-a-new-adapter",headingTag:"h2"}}),K=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),O=new h({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),te=new h({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ae=new T({props:{title:"Enable and disable adapters",local:"enable-and-disable-adapters",headingTag:"h2"}}),se=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),oe=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),re=new T({props:{title:"Train a PEFT adapter",local:"train-a-peft-adapter",headingTag:"h2"}}),J=new zt({props:{$$slots:{default:[aa]},$$scope:{ctx:ye}}}),de=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),me=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),fe=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),be=new h({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),ce=new T({props:{title:"Add additional trainable layers to a PEFT adapter",local:"add-additional-trainable-layers-to-a-peft-adapter",headingTag:"h2"}}),he=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model.add_adapter(lora_config)`,wrap:!1}}),{c(){c=o("meta"),y=s(),M=o("p"),w=s(),p(k.$$.fragment),$e=s(),p(Z.$$.fragment),ge=s(),v=o("p"),v.innerHTML=Tt,Je=s(),U=o("p"),U.textContent=wt,Ce=s(),$=o("div"),$.innerHTML=$t,_e=s(),F=o("p"),F.innerHTML=gt,ke=s(),p(W.$$.fragment),Ze=s(),j=o("p"),j.textContent=Jt,ve=s(),p(B.$$.fragment),Ue=s(),R=o("p"),R.textContent=Ct,Fe=s(),p(V.$$.fragment),We=s(),p(E.$$.fragment),je=s(),G=o("p"),G.textContent=_t,Be=s(),x=o("ul"),x.innerHTML=kt,Re=s(),X=o("p"),X.innerHTML=Zt,Ve=s(),p(H.$$.fragment),Ee=s(),L=o("p"),L.innerHTML=vt,Ge=s(),Q=o("ol"),Q.innerHTML=Ut,xe=s(),p(I.$$.fragment),Xe=s(),p(g.$$.fragment),He=s(),N=o("p"),N.innerHTML=Ft,Le=s(),p(Y.$$.fragment),Qe=s(),p(z.$$.fragment),Ie=s(),P=o("p"),P.innerHTML=Wt,Ne=s(),p(A.$$.fragment),Ye=s(),p(q.$$.fragment),ze=s(),S=o("p"),S.innerHTML=jt,Pe=s(),p(K.$$.fragment),Ae=s(),D=o("p"),D.textContent=Bt,qe=s(),p(O.$$.fragment),Se=s(),ee=o("p"),ee.innerHTML=Rt,Ke=s(),p(te.$$.fragment),De=s(),p(ae.$$.fragment),Oe=s(),le=o("p"),le.textContent=Vt,et=s(),p(se.$$.fragment),tt=s(),ne=o("p"),ne.textContent=Et,at=s(),p(oe.$$.fragment),lt=s(),p(re.$$.fragment),st=s(),pe=o("p"),pe.innerHTML=Gt,nt=s(),p(J.$$.fragment),ot=s(),ie=o("ol"),ie.innerHTML=xt,rt=s(),p(de.$$.fragment),pt=s(),C=o("ol"),C.innerHTML=Xt,it=s(),p(me.$$.fragment),dt=s(),_=o("ol"),_.innerHTML=Ht,mt=s(),p(fe.$$.fragment),ft=s(),ue=o("p"),ue.textContent=Lt,ut=s(),p(be.$$.fragment),bt=s(),p(ce.$$.fragment),ct=s(),Me=o("p"),Me.innerHTML=Qt,Mt=s(),p(he.$$.fragment),ht=s(),Te=o("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),M=r(e,"P",{}),Yt(M).forEach(a),w=n(e),i(k.$$.fragment,e),$e=n(e),i(Z.$$.fragment,e),ge=n(e),v=r(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-378l9l"&&(v.innerHTML=Tt),Je=n(e),U=r(e,"P",{"data-svelte-h":!0}),b(U)!=="svelte-nc5pgb"&&(U.textContent=wt),Ce=n(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),b($)!=="svelte-1gn6iv2"&&($.innerHTML=$t),_e=n(e),F=r(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1ldq9i6"&&(F.innerHTML=gt),ke=n(e),i(W.$$.fragment,e),Ze=n(e),j=r(e,"P",{"data-svelte-h":!0}),b(j)!=="svelte-1rn19ih"&&(j.textContent=Jt),ve=n(e),i(B.$$.fragment,e),Ue=n(e),R=r(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-cgwmeo"&&(R.textContent=Ct),Fe=n(e),i(V.$$.fragment,e),We=n(e),i(E.$$.fragment,e),je=n(e),G=r(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-5xdqaf"&&(G.textContent=_t),Be=n(e),x=r(e,"UL",{"data-svelte-h":!0}),b(x)!=="svelte-1ulyaf4"&&(x.innerHTML=kt),Re=n(e),X=r(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-8y8234"&&(X.innerHTML=Zt),Ve=n(e),i(H.$$.fragment,e),Ee=n(e),L=r(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-c3wuk0"&&(L.innerHTML=vt),Ge=n(e),Q=r(e,"OL",{"data-svelte-h":!0}),b(Q)!=="svelte-1a34kfr"&&(Q.innerHTML=Ut),xe=n(e),i(I.$$.fragment,e),Xe=n(e),i(g.$$.fragment,e),He=n(e),N=r(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1l4y13r"&&(N.innerHTML=Ft),Le=n(e),i(Y.$$.fragment,e),Qe=n(e),i(z.$$.fragment,e),Ie=n(e),P=r(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-1sn7am7"&&(P.innerHTML=Wt),Ne=n(e),i(A.$$.fragment,e),Ye=n(e),i(q.$$.fragment,e),ze=n(e),S=r(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1xpot6r"&&(S.innerHTML=jt),Pe=n(e),i(K.$$.fragment,e),Ae=n(e),D=r(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1t2m746"&&(D.textContent=Bt),qe=n(e),i(O.$$.fragment,e),Se=n(e),ee=r(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-adr915"&&(ee.innerHTML=Rt),Ke=n(e),i(te.$$.fragment,e),De=n(e),i(ae.$$.fragment,e),Oe=n(e),le=r(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-gwuro2"&&(le.textContent=Vt),et=n(e),i(se.$$.fragment,e),tt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-tzq689"&&(ne.textContent=Et),at=n(e),i(oe.$$.fragment,e),lt=n(e),i(re.$$.fragment,e),st=n(e),pe=r(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1vl183r"&&(pe.innerHTML=Gt),nt=n(e),i(J.$$.fragment,e),ot=n(e),ie=r(e,"OL",{"data-svelte-h":!0}),b(ie)!=="svelte-28sdvg"&&(ie.innerHTML=xt),rt=n(e),i(de.$$.fragment,e),pt=n(e),C=r(e,"OL",{start:!0,"data-svelte-h":!0}),b(C)!=="svelte-1qk52ef"&&(C.innerHTML=Xt),it=n(e),i(me.$$.fragment,e),dt=n(e),_=r(e,"OL",{start:!0,"data-svelte-h":!0}),b(_)!=="svelte-1mvere5"&&(_.innerHTML=Ht),mt=n(e),i(fe.$$.fragment,e),ft=n(e),ue=r(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1nalv2a"&&(ue.textContent=Lt),ut=n(e),i(be.$$.fragment,e),bt=n(e),i(ce.$$.fragment,e),ct=n(e),Me=r(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-6009n9"&&(Me.innerHTML=Qt),Mt=n(e),i(he.$$.fragment,e),ht=n(e),Te=r(e,"P",{}),Yt(Te).forEach(a),this.h()},h(){we(c,"name","hf:doc:metadata"),we(c,"content",sa),we($,"class","flex flex-col justify-center"),we(C,"start","2"),we(_,"start","3")},m(e,t){Ot(document.head,c),l(e,y,t),l(e,M,t),l(e,w,t),d(k,e,t),l(e,$e,t),d(Z,e,t),l(e,ge,t),l(e,v,t),l(e,Je,t),l(e,U,t),l(e,Ce,t),l(e,$,t),l(e,_e,t),l(e,F,t),l(e,ke,t),d(W,e,t),l(e,Ze,t),l(e,j,t),l(e,ve,t),d(B,e,t),l(e,Ue,t),l(e,R,t),l(e,Fe,t),d(V,e,t),l(e,We,t),d(E,e,t),l(e,je,t),l(e,G,t),l(e,Be,t),l(e,x,t),l(e,Re,t),l(e,X,t),l(e,Ve,t),d(H,e,t),l(e,Ee,t),l(e,L,t),l(e,Ge,t),l(e,Q,t),l(e,xe,t),d(I,e,t),l(e,Xe,t),d(g,e,t),l(e,He,t),l(e,N,t),l(e,Le,t),d(Y,e,t),l(e,Qe,t),d(z,e,t),l(e,Ie,t),l(e,P,t),l(e,Ne,t),d(A,e,t),l(e,Ye,t),d(q,e,t),l(e,ze,t),l(e,S,t),l(e,Pe,t),d(K,e,t),l(e,Ae,t),l(e,D,t),l(e,qe,t),d(O,e,t),l(e,Se,t),l(e,ee,t),l(e,Ke,t),d(te,e,t),l(e,De,t),d(ae,e,t),l(e,Oe,t),l(e,le,t),l(e,et,t),d(se,e,t),l(e,tt,t),l(e,ne,t),l(e,at,t),d(oe,e,t),l(e,lt,t),d(re,e,t),l(e,st,t),l(e,pe,t),l(e,nt,t),d(J,e,t),l(e,ot,t),l(e,ie,t),l(e,rt,t),d(de,e,t),l(e,pt,t),l(e,C,t),l(e,it,t),d(me,e,t),l(e,dt,t),l(e,_,t),l(e,mt,t),d(fe,e,t),l(e,ft,t),l(e,ue,t),l(e,ut,t),d(be,e,t),l(e,bt,t),d(ce,e,t),l(e,ct,t),l(e,Me,t),l(e,Mt,t),d(he,e,t),l(e,ht,t),l(e,Te,t),yt=!0},p(e,[t]){const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),g.$set(It);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),J.$set(Nt)},i(e){yt||(m(k.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(I.$$.fragment,e),m(g.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(J.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),yt=!0)},o(e){f(k.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(E.$$.fragment,e),f(H.$$.fragment,e),f(I.$$.fragment,e),f(g.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(J.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(be.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),yt=!1},d(e){e&&(a(y),a(M),a(w),a($e),a(ge),a(v),a(Je),a(U),a(Ce),a($),a(_e),a(F),a(ke),a(Ze),a(j),a(ve),a(Ue),a(R),a(Fe),a(We),a(je),a(G),a(Be),a(x),a(Re),a(X),a(Ve),a(Ee),a(L),a(Ge),a(Q),a(xe),a(Xe),a(He),a(N),a(Le),a(Qe),a(Ie),a(P),a(Ne),a(Ye),a(ze),a(S),a(Pe),a(Ae),a(D),a(qe),a(Se),a(ee),a(Ke),a(De),a(Oe),a(le),a(et),a(tt),a(ne),a(at),a(lt),a(st),a(pe),a(nt),a(ot),a(ie),a(rt),a(pt),a(C),a(it),a(dt),a(_),a(mt),a(ft),a(ue),a(ut),a(bt),a(ct),a(Me),a(Mt),a(ht),a(Te)),a(c),u(k,e),u(Z,e),u(W,e),u(B,e),u(V,e),u(E,e),u(H,e),u(I,e),u(g,e),u(Y,e),u(z,e),u(A,e),u(q,e),u(K,e),u(O,e),u(te,e),u(ae,e),u(se,e),u(oe,e),u(re,e),u(J,e),u(de,e),u(me,e),u(fe,e),u(be,e),u(ce,e),u(he,e)}}}const sa='{"title":"Load adapters with 🤗 PEFT","local":"load-adapters-with--peft","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Supported PEFT models","local":"supported-peft-models","sections":[],"depth":2},{"title":"Load a PEFT adapter","local":"load-a-peft-adapter","sections":[],"depth":2},{"title":"Load in 8bit or 4bit","local":"load-in-8bit-or-4bit","sections":[],"depth":2},{"title":"Add a new adapter","local":"add-a-new-adapter","sections":[],"depth":2},{"title":"Enable and disable adapters","local":"enable-and-disable-adapters","sections":[],"depth":2},{"title":"Train a PEFT adapter","local":"train-a-peft-adapter","sections":[],"depth":2},{"title":"Add additional trainable layers to a PEFT adapter","local":"add-additional-trainable-layers-to-a-peft-adapter","sections":[],"depth":2}],"depth":1}';function na(ye){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends St{constructor(c){super(),Kt(this,c,na,la,At,{})}}export{fa as component};
