import{s as Ye,n as De,o as Re}from"../chunks/scheduler.389d799c.js";import{S as Oe,i as Ke,g as o,s as a,r,A as tn,h as i,f as n,c as l,j as ze,u as p,x as d,k as Qe,y as en,a as s,v as c,d as u,t as h,w as m}from"../chunks/index.8f81d18f.js";import{C as g}from"../chunks/CodeBlock.3845caa1.js";import{H as ht,E as nn}from"../chunks/EditOnGithub.33306dfe.js";function sn(ge){let f,ft,mt,Tt,T,Mt,M,yt,y,fe="Below you can find a version table of currently available Hugging Face DLCs. The table doesn’t include the full <code>image_uri</code> here are two examples on how to construct those if needed.",wt,w,Te="<strong>Manually construction the <code>image_uri</code></strong>",jt,j,Me="<code>{dlc-aws-account-id}.dkr.ecr.{region}.amazonaws.com/huggingface-{framework}-{(training | inference)}:{framework-version}-transformers{transformers-version}-{device}-{python-version}-{device-tag}</code>",bt,b,ye='<li><code>dlc-aws-account-id</code>: The AWS account ID of the account that owns the ECR repository. You can find them in the <a href="https://github.com/aws/sagemaker-python-sdk/blob/e0b9d38e1e3b48647a02af23c4be54980e53dc61/src/sagemaker/image_uri_config/huggingface.json#L21" rel="nofollow">here</a></li> <li><code>region</code>: The AWS region where you want to use it.</li> <li><code>framework</code>: The framework you want to use, either <code>pytorch</code> or <code>tensorflow</code>.</li> <li><code>(training | inference)</code>: The training or inference mode.</li> <li><code>framework-version</code>: The version of the framework you want to use.</li> <li><code>transformers-version</code>: The version of the transformers library you want to use.</li> <li><code>device</code>: The device you want to use, either <code>cpu</code> or <code>gpu</code>.</li> <li><code>python-version</code>: The version of the python of the DLC.</li> <li><code>device-tag</code>: The device tag you want to use. The device tag can include os version and cuda version</li>',Jt,J,we="<strong>Example 1: PyTorch Training:</strong> <code>763104351884.dkr.ecr.us-west-2.amazonaws.com/huggingface-pytorch-training:1.6.0-transformers4.4.2-gpu-py36-cu110-ubuntu18.04</code> <strong>Example 2: Tensorflow Inference:</strong> <code>763104351884.dkr.ecr.us-east-1.amazonaws.com/huggingface-tensorflow-inference:2.4.1-transformers4.6.1-cpu-py37-ubuntu18.04</code>",It,I,kt,k,je=`The Training DLC overview includes all released and available Hugging Face Training DLCs. It includes PyTorch and TensorFlow flavored
versions for GPU.`,Ut,U,be="<thead><tr><th>🤗 Transformers version</th> <th>🤗 Datasets version</th> <th>PyTorch/TensorFlow version</th> <th>type</th> <th>device</th> <th>Python Version</th></tr></thead> <tbody><tr><td>4.4.2</td> <td>1.5.0</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.4.2</td> <td>1.5.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.5.0</td> <td>1.5.0</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.5.0</td> <td>1.5.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>PyTorch 1.6.0</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>PyTorch 1.7.1</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>1.6.2</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>PyTorch 1.8.1</td> <td>training</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>PyTorch 1.9.0</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>TensorFlow 2.4.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>1.11.0</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>1.12.1</td> <td>PyTorch 1.9.0</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>1.12.1</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>1.15.1</td> <td>PyTorch 1.9.1</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>1.15.1</td> <td>TensorFlow 2.5.1</td> <td>training</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.17.0</td> <td>1.18.4</td> <td>PyTorch 1.10.2</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>1.18.4</td> <td>TensorFlow 2.6.3</td> <td>training</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.26.0</td> <td>2.9.0</td> <td>PyTorch 1.13.1</td> <td>training</td> <td>GPU</td> <td>3.9</td></tr></tbody>",vt,v,_t,_,Je=`The Inference DLC overview includes all released and available Hugging Face Inference DLCs. It includes PyTorch and TensorFlow flavored
versions for CPU, GPU & AWS Inferentia.`,$t,$,Ie="<thead><tr><th>🤗 Transformers version</th> <th>PyTorch/TensorFlow version</th> <th>type</th> <th>device</th> <th>Python Version</th></tr></thead> <tbody><tr><td>4.6.1</td> <td>PyTorch 1.7.1</td> <td>inference</td> <td>CPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>PyTorch 1.7.1</td> <td>inference</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.6.1</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.6.1</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.8.1</td> <td>inference</td> <td>GPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.8.1</td> <td>inference</td> <td>CPU</td> <td>3.6</td></tr> <tr><td>4.10.2</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.4.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.10.2</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.11.0</td> <td>PyTorch 1.9.0</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.11.0</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>GPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.12.3</td> <td>TensorFlow 2.5.1</td> <td>inference</td> <td>CPU</td> <td>3.7</td></tr> <tr><td>4.12.3</td> <td>PyTorch 1.9.1</td> <td>inference</td> <td>Inferentia</td> <td>3.7</td></tr> <tr><td>4.17.0</td> <td>PyTorch 1.10.2</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>TensorFlow 2.6.3</td> <td>inference</td> <td>GPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>PyTorch 1.10.2</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.17.0</td> <td>TensorFlow 2.6.3</td> <td>inference</td> <td>CPU</td> <td>3.8</td></tr> <tr><td>4.26.0</td> <td>PyTorch 1.13.1</td> <td>inference</td> <td>CPU</td> <td>3.9</td></tr> <tr><td>4.26.0</td> <td>PyTorch 1.13.1</td> <td>inference</td> <td>GPU</td> <td>3.9</td></tr></tbody>",Pt,P,Ct,C,ke='Example Jupyter notebooks that demonstrate how to build, train, and deploy <a href="https://github.com/huggingface/transformers" rel="nofollow">Hugging Face Transformers</a> using <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html" rel="nofollow">Amazon SageMaker</a> and the <a href="https://sagemaker.readthedocs.io/en/stable/" rel="nofollow">Amazon SageMaker Python SDK</a>.',Ht,H,Ue='<thead><tr><th>Notebook</th> <th>Type</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">01 Getting started with PyTorch</a></td> <td>Training</td> <td>Getting started end-to-end example on how to fine-tune a pre-trained Hugging Face Transformer for Text-Classification using PyTorch</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/02_getting_started_tensorflow/sagemaker-notebook.ipynb" rel="nofollow">02 getting started with TensorFlow</a></td> <td>Training</td> <td>Getting started end-to-end example on how to fine-tune a pre-trained Hugging Face Transformer for Text-Classification using TensorFlow</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/03_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">03 Distributed Training: Data Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use distributed training with data-parallelism strategy for fine-tuning a pre-trained Hugging Face Transformer for Question-Answering using Amazon SageMaker Data Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/04_distributed_training_model_parallelism/sagemaker-notebook.ipynb" rel="nofollow">04 Distributed Training: Model Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use distributed training with model-parallelism strategy to pre-trained Hugging Face Transformer using Amazon SageMaker Model Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/05_spot_instances/sagemaker-notebook.ipynb" rel="nofollow">05 How to use Spot Instances &amp; Checkpointing</a></td> <td>Training</td> <td>End-to-end example on how to use Spot Instances and Checkpointing to reduce training cost</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/06_sagemaker_metrics/sagemaker-notebook.ipynb" rel="nofollow">06 Experiment Tracking with SageMaker Metrics</a></td> <td>Training</td> <td>End-to-end example on how to use SageMaker metrics to track your experiments and training jobs</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/07_tensorflow_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">07 Distributed Training: Data Parallelism</a></td> <td>Training</td> <td>End-to-end example on how to use Amazon SageMaker Data Parallelism with TensorFlow</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/08_distributed_summarization_bart_t5/sagemaker-notebook.ipynb" rel="nofollow">08 Distributed Training: Summarization with T5/BART</a></td> <td>Training</td> <td>End-to-end example on how to fine-tune BART/T5 for Summarization using Amazon SageMaker Data Parallelism</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/09_image_classification_vision_transformer/sagemaker-notebook.ipynb" rel="nofollow">09 Vision: Fine-tune ViT</a></td> <td>Training</td> <td>End-to-end example on how to fine-tune Vision Transformer for Image-Classification</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">10 Deploy HF Transformer from Amazon S3</a></td> <td>Inference</td> <td>End-to-end example on how to deploy a model from Amazon S3</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">11 Deploy HF Transformer from Hugging Face Hub</a></td> <td>Inference</td> <td>End-to-end example on how to deploy a model from the Hugging Face Hub</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">12 Batch Processing with Amazon SageMaker Batch Transform</a></td> <td>Inference</td> <td>End-to-end example on how to do batch processing with Amazon SageMaker Batch Transform</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/13_deploy_and_autoscaling_transformers/sagemaker-notebook.ipynb" rel="nofollow">13 Autoscaling SageMaker Endpoints</a></td> <td>Inference</td> <td>End-to-end example on how to do use autoscaling for a HF Endpoint</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/14_train_and_push_to_hub/sagemaker-notebook.ipynb" rel="nofollow">14 Fine-tune and push to Hub</a></td> <td>Training</td> <td>End-to-end example on how to do use the Hugging Face Hub as MLOps backend for saving checkpoints during training</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/15_training_compiler/sagemaker-notebook.ipynb" rel="nofollow">15 Training Compiler</a></td> <td>Training</td> <td>End-to-end example on how to do use Amazon SageMaker Training Compiler to speed up training time</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/16_async_inference_hf_hub/sagemaker-notebook.ipynb" rel="nofollow">16 Asynchronous Inference</a></td> <td>Inference</td> <td>End-to-end example on how to do use Amazon SageMaker Asynchronous Inference endpoints with Hugging Face Transformers</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/17_custom_inference_script/sagemaker-notebook.ipynb" rel="nofollow">17 Custom inference.py script</a></td> <td>Inference</td> <td>End-to-end example on how to create a custom inference.py for Sentence Transformers and sentence embeddings</td></tr> <tr><td><a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/18_inferentia_inference/sagemaker-notebook.ipynb" rel="nofollow">18 AWS Inferentia</a></td> <td>Inference</td> <td>End-to-end example on how to AWS Inferentia to speed up inference time</td></tr></tbody>',Bt,B,Gt,G,ve='The Inference Toolkit accepts inputs in the <code>inputs</code> key, and supports additional <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipelines</code></a> parameters in the <code>parameters</code> key. You can provide any of the supported <code>kwargs</code> from <code>pipelines</code> as <code>parameters</code>.',Et,E,_e="Tasks supported by the Inference Toolkit API include:",qt,q,$e="<li><strong><code>text-classification</code></strong></li> <li><strong><code>sentiment-analysis</code></strong></li> <li><strong><code>token-classification</code></strong></li> <li><strong><code>feature-extraction</code></strong></li> <li><strong><code>fill-mask</code></strong></li> <li><strong><code>summarization</code></strong></li> <li><strong><code>translation_xx_to_yy</code></strong></li> <li><strong><code>text2text-generation</code></strong></li> <li><strong><code>text-generation</code></strong></li> <li><strong><code>audio-classificatin</code></strong></li> <li><strong><code>automatic-speech-recognition</code></strong></li> <li><strong><code>conversational</code></strong></li> <li><strong><code>image-classification</code></strong></li> <li><strong><code>image-segmentation</code></strong></li> <li><strong><code>object-detection</code></strong></li> <li><strong><code>table-question-answering</code></strong></li> <li><strong><code>zero-shot-classification</code></strong></li> <li><strong><code>zero-shot-image-classification</code></strong></li>",xt,x,Pe="See the following request examples for some of the tasks:",Ft,F,Ce="<strong><code>text-classification</code></strong>",St,S,Wt,W,He="<strong><code>sentiment-analysis</code></strong>",At,A,Xt,X,Be="<strong><code>token-classification</code></strong>",Zt,Z,Lt,L,Ge="<strong><code>question-answering</code></strong>",Nt,N,Vt,V,Ee="<strong><code>zero-shot-classification</code></strong>",zt,z,Qt,Q,qe="<strong><code>table-question-answering</code></strong>",Yt,Y,Dt,D,xe="<strong><code>parameterized-request</code></strong>",Rt,R,Ot,O,Kt,K,Fe="The Inference Toolkit implements various additional environment variables to simplify deployment. A complete list of Hugging Face specific environment variables is shown below:",te,tt,Se="<strong><code>HF_TASK</code></strong>",ee,et,We='<code>HF_TASK</code> defines the task for the 🤗 Transformers pipeline used . See <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a> for a complete list of tasks.',ne,nt,se,st,Ae="<strong><code>HF_MODEL_ID</code></strong>",ae,at,Xe='<code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="https://huggingface.co/models" rel="nofollow">hf.co/models</a> when creating a SageMaker endpoint. All of the 🤗 Hub’s 10,000+ models are available through this environment variable.',le,lt,oe,ot,Ze="<strong><code>HF_MODEL_REVISION</code></strong>",ie,it,Le="<code>HF_MODEL_REVISION</code> is an extension to <code>HF_MODEL_ID</code> and allows you to define or pin a model revision to make sure you always load the same model on your SageMaker endpoint.",de,dt,re,rt,Ne="<strong><code>HF_API_TOKEN</code></strong>",pe,pt,Ve='<code>HF_API_TOKEN</code> defines your Hugging Face authorization token. The <code>HF_API_TOKEN</code> is used as a HTTP bearer authorization for remote files like private models. You can find your token under <a href="https://huggingface.co/settings/tokens" rel="nofollow">Settings</a> of your Hugging Face account.',ce,ct,ue,ut,he,gt,me;return T=new ht({props:{title:"Reference",local:"reference",headingTag:"h1"}}),M=new ht({props:{title:"Deep Learning Container",local:"deep-learning-container",headingTag:"h2"}}),I=new ht({props:{title:"Training DLC Overview",local:"training-dlc-overview",headingTag:"h2"}}),v=new ht({props:{title:"Inference DLC Overview",local:"inference-dlc-overview",headingTag:"h2"}}),P=new ht({props:{title:"Hugging Face Transformers Amazon SageMaker Examples",local:"hugging-face-transformers-amazon-sagemaker-examples",headingTag:"h2"}}),B=new ht({props:{title:"Inference Toolkit API",local:"inference-toolkit-api",headingTag:"h2"}}),S=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyRG9uJ3QlMjB3YXN0ZSUyMHlvdXIlMjB0aW1lLiUyMCUyMFdlJTIwaGFkJTIwdHdvJTIwZGlmZmVyZW50JTIwcGVvcGxlJTIwY29tZSUyMHRvJTIwb3VyJTIwaG91c2UlMjB0byUyMGdpdmUlMjB1cyUyMGVzdGltYXRlcyUyMGZvciUwQWElMjBkZWNrJTIwKG9uZSUyMG9mJTIwdGhlbSUyMHRoZSUyME9XTkVSKS4lMjAlMjBCb3RoJTIwdGltZXMlMkMlMjB3ZSUyMG5ldmVyJTIwaGVhcmQlMjBmcm9tJTIwdGhlbS4lMjAlMjBOb3QlMjBhJTIwY2FsbCUyQyUyMG5vdCUyMHRoZSUyMGVzdGltYXRlJTJDJTIwbm90aGluZy4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Don&#x27;t waste your time.  We had two different people come to our house to give us estimates for
a deck (one of them the OWNER).  Both times, we never heard from them.  Not a call, not the estimate, nothing.&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Z=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBTeWx2YWluJTIwYW5kJTIwSSUyMHdvcmslMjBhdCUyMEh1Z2dpbmclMjBGYWNlJTIwaW4lMjBCcm9va2x5bi4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My name is Sylvain and I work at Hugging Face in Brooklyn.&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),N=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB1c2VkJTIwZm9yJTIwaW5mZXJlbmNlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwTmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjB1c2VkJTIwd2l0aCUyMHNhZ2VtYWtlciUyMGZvciUyMGluZmVyZW5jZS4lMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is used for inference?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),z=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTIwJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;candidate_labels&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;refund&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;legal&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;faq&quot;</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWJsZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJDb250cmlidXRvcnMlMjIlM0ElMjAlNUIlMjI2NTElMjIlMkMlMjAlMjI3NyUyMiUyQyUyMCUyMjM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMiUzQSUyMCU1QiUyMlB5dGhvbiUyMiUyQyUyMCUyMlB5dGhvbiUyMiUyQyUyMCUyMlJ1c3QlMkMlMjBQeXRob24lMjBhbmQlMjBOb2RlSlMlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;query&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;table&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;Repository&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Transformers&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Datasets&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Tokenizers&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Stars&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;36542&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;4512&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;3934&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Contributors&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;651&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;77&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;34&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Programming language&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new g({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySHVnZ2luZyUyMEZhY2UlMkMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMFZlbnR1cmVCZWF0JUUyJTgwJTk5cyUyMElubm92YXRpb24lMjBpbiUyME5hdHVyYWwlMjBMYW5ndWFnZSUyMFByb2Nlc3MlMkZVbmRlcnN0YW5kaW5nJTIwQXdhcmQlMjBmb3IlMjAyMDIxJTJDJTIwaXMlMjBsb29raW5nJTIwdG8lMjBsZXZlbCUyMHRoZSUyMHBsYXlpbmclMjBmaWVsZC4lMjBUaGUlMjB0ZWFtJTJDJTIwbGF1bmNoZWQlMjBieSUyMENsJUMzJUE5bWVudCUyMERlbGFuZ3VlJTIwYW5kJTIwSnVsaWVuJTIwQ2hhdW1vbmQlMjBpbiUyMDIwMTYlMkMlMjB3YXMlMjByZWNvZ25pemVkJTIwZm9yJTIwaXRzJTIwd29yayUyMGluJTIwZGVtb2NyYXRpemluZyUyME5MUCUyQyUyMHRoZSUyMGdsb2JhbCUyMG1hcmtldCUyMHZhbHVlJTIwZm9yJTIwd2hpY2glMjBpcyUyMGV4cGVjdGVkJTIwdG8lMjBoaXQlMjAlMjQzNS4xJTIwYmlsbGlvbiUyMGJ5JTIwMjAyNi4lMjBUaGlzJTIwd2VlayUyQyUyMEdvb2dsZSVFMiU4MCU5OXMlMjBmb3JtZXIlMjBoZWFkJTIwb2YlMjBFdGhpY2FsJTIwQUklMjBNYXJnYXJldCUyME1pdGNoZWxsJTIwam9pbmVkJTIwdGhlJTIwdGVhbS4lMjIlMkMlMEElMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVwZXRpdGlvbl9wZW5hbHR5JTIyJTNBJTIwNC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVuZ3RoX3BlbmFsdHklMjIlM0ElMjAxLjUlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hugging Face, the winner of VentureBeat’s Innovation in Natural Language Process/Understanding Award for 2021, is looking to level the playing field. The team, launched by Clément Delangue and Julien Chaumond in 2016, was recognized for its work in democratizing NLP, the global market value for which is expected to hit $35.1 billion by 2026. This week, Google’s former head of Ethical AI Margaret Mitchell joined the team.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;length_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.5</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),O=new ht({props:{title:"Inference Toolkit environment variables",local:"inference-toolkit-environment-variables",headingTag:"h2"}}),nt=new g({props:{code:"SEZfVEFTSyUzRCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMg==",highlighted:'HF_TASK=<span class="hljs-string">&quot;question-answering&quot;</span>',wrap:!1}}),lt=new g({props:{code:"SEZfTU9ERUxfSUQlM0QlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMg==",highlighted:'HF_MODEL_ID=<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>',wrap:!1}}),dt=new g({props:{code:"SEZfTU9ERUxfUkVWSVNJT04lM0QlMjIwM2I0ZDE5NmMxOWQwYTczYzdlMDMyMjY4NGU5N2RiMWVjMzk3NjEzJTIy",highlighted:'HF_MODEL_REVISION=<span class="hljs-string">&quot;03b4d196c19d0a73c7e0322684e97db1ec397613&quot;</span>',wrap:!1}}),ct=new g({props:{code:"SEZfQVBJX1RPS0VOJTNEJTIyYXBpX1hYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYJTIy",highlighted:'HF_API_TOKEN=<span class="hljs-string">&quot;api_XXXXXXXXXXXXXXXXXXXXXXXXXXXXX&quot;</span>',wrap:!1}}),ut=new nn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/reference.md"}}),{c(){f=o("meta"),ft=a(),mt=o("p"),Tt=a(),r(T.$$.fragment),Mt=a(),r(M.$$.fragment),yt=a(),y=o("p"),y.innerHTML=fe,wt=a(),w=o("p"),w.innerHTML=Te,jt=a(),j=o("p"),j.innerHTML=Me,bt=a(),b=o("ul"),b.innerHTML=ye,Jt=a(),J=o("p"),J.innerHTML=we,It=a(),r(I.$$.fragment),kt=a(),k=o("p"),k.textContent=je,Ut=a(),U=o("table"),U.innerHTML=be,vt=a(),r(v.$$.fragment),_t=a(),_=o("p"),_.textContent=Je,$t=a(),$=o("table"),$.innerHTML=Ie,Pt=a(),r(P.$$.fragment),Ct=a(),C=o("p"),C.innerHTML=ke,Ht=a(),H=o("table"),H.innerHTML=Ue,Bt=a(),r(B.$$.fragment),Gt=a(),G=o("p"),G.innerHTML=ve,Et=a(),E=o("p"),E.textContent=_e,qt=a(),q=o("ul"),q.innerHTML=$e,xt=a(),x=o("p"),x.textContent=Pe,Ft=a(),F=o("p"),F.innerHTML=Ce,St=a(),r(S.$$.fragment),Wt=a(),W=o("p"),W.innerHTML=He,At=a(),r(A.$$.fragment),Xt=a(),X=o("p"),X.innerHTML=Be,Zt=a(),r(Z.$$.fragment),Lt=a(),L=o("p"),L.innerHTML=Ge,Nt=a(),r(N.$$.fragment),Vt=a(),V=o("p"),V.innerHTML=Ee,zt=a(),r(z.$$.fragment),Qt=a(),Q=o("p"),Q.innerHTML=qe,Yt=a(),r(Y.$$.fragment),Dt=a(),D=o("p"),D.innerHTML=xe,Rt=a(),r(R.$$.fragment),Ot=a(),r(O.$$.fragment),Kt=a(),K=o("p"),K.textContent=Fe,te=a(),tt=o("p"),tt.innerHTML=Se,ee=a(),et=o("p"),et.innerHTML=We,ne=a(),r(nt.$$.fragment),se=a(),st=o("p"),st.innerHTML=Ae,ae=a(),at=o("p"),at.innerHTML=Xe,le=a(),r(lt.$$.fragment),oe=a(),ot=o("p"),ot.innerHTML=Ze,ie=a(),it=o("p"),it.innerHTML=Le,de=a(),r(dt.$$.fragment),re=a(),rt=o("p"),rt.innerHTML=Ne,pe=a(),pt=o("p"),pt.innerHTML=Ve,ce=a(),r(ct.$$.fragment),ue=a(),r(ut.$$.fragment),he=a(),gt=o("p"),this.h()},l(t){const e=tn("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(n),ft=l(t),mt=i(t,"P",{}),ze(mt).forEach(n),Tt=l(t),p(T.$$.fragment,t),Mt=l(t),p(M.$$.fragment,t),yt=l(t),y=i(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1s4u3mt"&&(y.innerHTML=fe),wt=l(t),w=i(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1u646kx"&&(w.innerHTML=Te),jt=l(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1f0bs4o"&&(j.innerHTML=Me),bt=l(t),b=i(t,"UL",{"data-svelte-h":!0}),d(b)!=="svelte-1tys959"&&(b.innerHTML=ye),Jt=l(t),J=i(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-grd5uv"&&(J.innerHTML=we),It=l(t),p(I.$$.fragment,t),kt=l(t),k=i(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1byqlum"&&(k.textContent=je),Ut=l(t),U=i(t,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-7ymlvg"&&(U.innerHTML=be),vt=l(t),p(v.$$.fragment,t),_t=l(t),_=i(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-14ncie8"&&(_.textContent=Je),$t=l(t),$=i(t,"TABLE",{"data-svelte-h":!0}),d($)!=="svelte-iqlig"&&($.innerHTML=Ie),Pt=l(t),p(P.$$.fragment,t),Ct=l(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1crg1k0"&&(C.innerHTML=ke),Ht=l(t),H=i(t,"TABLE",{"data-svelte-h":!0}),d(H)!=="svelte-6do7ie"&&(H.innerHTML=Ue),Bt=l(t),p(B.$$.fragment,t),Gt=l(t),G=i(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-12z3iiy"&&(G.innerHTML=ve),Et=l(t),E=i(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-14avis7"&&(E.textContent=_e),qt=l(t),q=i(t,"UL",{"data-svelte-h":!0}),d(q)!=="svelte-1swzyw"&&(q.innerHTML=$e),xt=l(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-fqnqo8"&&(x.textContent=Pe),Ft=l(t),F=i(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-zp6pme"&&(F.innerHTML=Ce),St=l(t),p(S.$$.fragment,t),Wt=l(t),W=i(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-zfr1l6"&&(W.innerHTML=He),At=l(t),p(A.$$.fragment,t),Xt=l(t),X=i(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1a5sljg"&&(X.innerHTML=Be),Zt=l(t),p(Z.$$.fragment,t),Lt=l(t),L=i(t,"P",{"data-svelte-h":!0}),d(L)!=="svelte-7ht279"&&(L.innerHTML=Ge),Nt=l(t),p(N.$$.fragment,t),Vt=l(t),V=i(t,"P",{"data-svelte-h":!0}),d(V)!=="svelte-455rcs"&&(V.innerHTML=Ee),zt=l(t),p(z.$$.fragment,t),Qt=l(t),Q=i(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-w6paxw"&&(Q.innerHTML=qe),Yt=l(t),p(Y.$$.fragment,t),Dt=l(t),D=i(t,"P",{"data-svelte-h":!0}),d(D)!=="svelte-17c454l"&&(D.innerHTML=xe),Rt=l(t),p(R.$$.fragment,t),Ot=l(t),p(O.$$.fragment,t),Kt=l(t),K=i(t,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1hi83ly"&&(K.textContent=Fe),te=l(t),tt=i(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-op5ire"&&(tt.innerHTML=Se),ee=l(t),et=i(t,"P",{"data-svelte-h":!0}),d(et)!=="svelte-x44ycw"&&(et.innerHTML=We),ne=l(t),p(nt.$$.fragment,t),se=l(t),st=i(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-at3940"&&(st.innerHTML=Ae),ae=l(t),at=i(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-7pv5qy"&&(at.innerHTML=Xe),le=l(t),p(lt.$$.fragment,t),oe=l(t),ot=i(t,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1cqzoxg"&&(ot.innerHTML=Ze),ie=l(t),it=i(t,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1xh4jnx"&&(it.innerHTML=Le),de=l(t),p(dt.$$.fragment,t),re=l(t),rt=i(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-y1zqs5"&&(rt.innerHTML=Ne),pe=l(t),pt=i(t,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-wfdtbd"&&(pt.innerHTML=Ve),ce=l(t),p(ct.$$.fragment,t),ue=l(t),p(ut.$$.fragment,t),he=l(t),gt=i(t,"P",{}),ze(gt).forEach(n),this.h()},h(){Qe(f,"name","hf:doc:metadata"),Qe(f,"content",an)},m(t,e){en(document.head,f),s(t,ft,e),s(t,mt,e),s(t,Tt,e),c(T,t,e),s(t,Mt,e),c(M,t,e),s(t,yt,e),s(t,y,e),s(t,wt,e),s(t,w,e),s(t,jt,e),s(t,j,e),s(t,bt,e),s(t,b,e),s(t,Jt,e),s(t,J,e),s(t,It,e),c(I,t,e),s(t,kt,e),s(t,k,e),s(t,Ut,e),s(t,U,e),s(t,vt,e),c(v,t,e),s(t,_t,e),s(t,_,e),s(t,$t,e),s(t,$,e),s(t,Pt,e),c(P,t,e),s(t,Ct,e),s(t,C,e),s(t,Ht,e),s(t,H,e),s(t,Bt,e),c(B,t,e),s(t,Gt,e),s(t,G,e),s(t,Et,e),s(t,E,e),s(t,qt,e),s(t,q,e),s(t,xt,e),s(t,x,e),s(t,Ft,e),s(t,F,e),s(t,St,e),c(S,t,e),s(t,Wt,e),s(t,W,e),s(t,At,e),c(A,t,e),s(t,Xt,e),s(t,X,e),s(t,Zt,e),c(Z,t,e),s(t,Lt,e),s(t,L,e),s(t,Nt,e),c(N,t,e),s(t,Vt,e),s(t,V,e),s(t,zt,e),c(z,t,e),s(t,Qt,e),s(t,Q,e),s(t,Yt,e),c(Y,t,e),s(t,Dt,e),s(t,D,e),s(t,Rt,e),c(R,t,e),s(t,Ot,e),c(O,t,e),s(t,Kt,e),s(t,K,e),s(t,te,e),s(t,tt,e),s(t,ee,e),s(t,et,e),s(t,ne,e),c(nt,t,e),s(t,se,e),s(t,st,e),s(t,ae,e),s(t,at,e),s(t,le,e),c(lt,t,e),s(t,oe,e),s(t,ot,e),s(t,ie,e),s(t,it,e),s(t,de,e),c(dt,t,e),s(t,re,e),s(t,rt,e),s(t,pe,e),s(t,pt,e),s(t,ce,e),c(ct,t,e),s(t,ue,e),c(ut,t,e),s(t,he,e),s(t,gt,e),me=!0},p:De,i(t){me||(u(T.$$.fragment,t),u(M.$$.fragment,t),u(I.$$.fragment,t),u(v.$$.fragment,t),u(P.$$.fragment,t),u(B.$$.fragment,t),u(S.$$.fragment,t),u(A.$$.fragment,t),u(Z.$$.fragment,t),u(N.$$.fragment,t),u(z.$$.fragment,t),u(Y.$$.fragment,t),u(R.$$.fragment,t),u(O.$$.fragment,t),u(nt.$$.fragment,t),u(lt.$$.fragment,t),u(dt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),me=!0)},o(t){h(T.$$.fragment,t),h(M.$$.fragment,t),h(I.$$.fragment,t),h(v.$$.fragment,t),h(P.$$.fragment,t),h(B.$$.fragment,t),h(S.$$.fragment,t),h(A.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(z.$$.fragment,t),h(Y.$$.fragment,t),h(R.$$.fragment,t),h(O.$$.fragment,t),h(nt.$$.fragment,t),h(lt.$$.fragment,t),h(dt.$$.fragment,t),h(ct.$$.fragment,t),h(ut.$$.fragment,t),me=!1},d(t){t&&(n(ft),n(mt),n(Tt),n(Mt),n(yt),n(y),n(wt),n(w),n(jt),n(j),n(bt),n(b),n(Jt),n(J),n(It),n(kt),n(k),n(Ut),n(U),n(vt),n(_t),n(_),n($t),n($),n(Pt),n(Ct),n(C),n(Ht),n(H),n(Bt),n(Gt),n(G),n(Et),n(E),n(qt),n(q),n(xt),n(x),n(Ft),n(F),n(St),n(Wt),n(W),n(At),n(Xt),n(X),n(Zt),n(Lt),n(L),n(Nt),n(Vt),n(V),n(zt),n(Qt),n(Q),n(Yt),n(Dt),n(D),n(Rt),n(Ot),n(Kt),n(K),n(te),n(tt),n(ee),n(et),n(ne),n(se),n(st),n(ae),n(at),n(le),n(oe),n(ot),n(ie),n(it),n(de),n(re),n(rt),n(pe),n(pt),n(ce),n(ue),n(he),n(gt)),n(f),m(T,t),m(M,t),m(I,t),m(v,t),m(P,t),m(B,t),m(S,t),m(A,t),m(Z,t),m(N,t),m(z,t),m(Y,t),m(R,t),m(O,t),m(nt,t),m(lt,t),m(dt,t),m(ct,t),m(ut,t)}}}const an='{"title":"Reference","local":"reference","sections":[{"title":"Deep Learning Container","local":"deep-learning-container","sections":[],"depth":2},{"title":"Training DLC Overview","local":"training-dlc-overview","sections":[],"depth":2},{"title":"Inference DLC Overview","local":"inference-dlc-overview","sections":[],"depth":2},{"title":"Hugging Face Transformers Amazon SageMaker Examples","local":"hugging-face-transformers-amazon-sagemaker-examples","sections":[],"depth":2},{"title":"Inference Toolkit API","local":"inference-toolkit-api","sections":[],"depth":2},{"title":"Inference Toolkit environment variables","local":"inference-toolkit-environment-variables","sections":[],"depth":2}],"depth":1}';function ln(ge){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Oe{constructor(f){super(),Ke(this,f,ln,sn,Ye,{})}}export{cn as component};
