import{s as zs,o as Es,n as pl}from"../chunks/scheduler.22bf70d2.js";import{S as Ss,i as Hs,g as M,s as a,r as o,A as Ls,h as i,f as t,c as n,j as Fs,u as c,x as r,k as Qs,y as Ds,a as s,v as m,d as w,t as J,w as y}from"../chunks/index.59178e06.js";import{T as al}from"../chunks/Tip.75d940ba.js";import{C as h}from"../chunks/CodeBlock.f7047b13.js";import{H as nl,E as Ps}from"../chunks/EditOnGithub.86314611.js";function qs(d){let p,U='This tutorial is also available as a Jupyter Notebook <a href="https://github.com/huggingface/notebooks/blob/main/examples/accelerate_examples/simple_cv_example.ipynb" rel="nofollow">here</a>';return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1tjynav"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function Ks(d){let p,U="CUDA can’t be initialized more than once on a multi-GPU system. It’s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1cflfr7"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function Os(d){let p,U="The code has been split up to allow for explanations on each section. A full version that can be copy and pasted will be available at the end";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1eykicx"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function ea(d){let p,U=`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the <a href="../concept_guides/training_tpu">TPU best practices</a>
to learn why`;return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1aol2se"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function la(d){let p,U="You build the model here so that the seed also controls the new weight initialization";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-j432sg"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function ta(d){let p,U="There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1y658j6"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function sa(d){let p,U="Notice how the <code>node_rank</code> has changed";return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dj1i7x"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:pl,d(T){T&&t(p)}}}function aa(d){let p,U,T,j,G,il,g,St=`This tutorial teaches you how to fine tune a computer vision model with 🤗 Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`,rl,u,ol,_,cl,W,Ht="Before any training can be performed, a 🤗 Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:",ml,k,wl,B,Lt='However, if general defaults are fine and you are <em>not</em> running on a TPU, 🤗Accelerate has a utility to quickly write your GPU configuration into a config file via <a href="/docs/accelerate/v0.30.1/en/package_reference/utilities#accelerate.commands.config.default.write_basic_config">utils.write_basic_config()</a>.',Jl,v,Dt="The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this.",yl,b,Tl,Y,hl,A,Ul,N,Pt="Next you should prepare your dataset. As mentioned at earlier, great care should be taken when preparing the <code>DataLoaders</code> and model to make sure that <strong>nothing</strong> is put on <em>any</em> GPU.",jl,X,qt="If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later.",dl,R,Kt='Make sure the dataset is downloaded based on the directions <a href="https://github.com/huggingface/accelerate/tree/main/examples#simple-vision-example" rel="nofollow">here</a>',ul,V,bl,x,Ot="First you need to create a function to extract the class name based on a filename:",Il,F,fl,Q,Cl,z,es="In the case here, the label is <code>beagle</code>. Using regex you can extract the label from the filename:",$l,E,Zl,S,Gl,H,ls="And you can see it properly returned the right name for our file:",gl,L,_l,D,ts="Next a <code>Dataset</code> class should be made to handle grabbing the image and the label:",Wl,P,kl,q,ss=`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`,Bl,K,vl,O,as="Next gather all the labels:",Yl,ee,Al,le,ns=`Next, you should make a <code>get_dataloaders</code> function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your <code>DataLoaders</code>, they must be built using this method.`,Nl,te,Xl,se,ps="Finally, you should import the scheduler to be used later:",Rl,ae,Vl,ne,xl,pe,Ms='Now you can build the training loop. <a href="/docs/accelerate/v0.30.1/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> works by passing in a function to call that will be ran across the distributed system.',Fl,Me,is="Here is a basic training loop for the animal classification problem:",Ql,I,zl,ie,El,re,rs='First you should set the seed and create an <a href="/docs/accelerate/v0.30.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object as early in the training loop as possible.',Sl,f,Hl,oe,os="Next you should build your dataloaders and create your model:",Ll,ce,Dl,C,Pl,me,cs=`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`,ql,we,Kl,Je,ms="Normalizing the batches of images will make training a little faster:",Ol,ye,et,Te,ws="To make these constants available on the active device, you should set it to the Accelerator’s device:",lt,he,tt,Ue,Js="Next instantiate the rest of the PyTorch classes used for training:",st,je,at,de,ys='Before passing everything to <a href="/docs/accelerate/v0.30.1/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.',nt,$,pt,ue,Mt,be,Ts="Now train the model:",it,Ie,rt,fe,hs=`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`,ot,Ce,ct,$e,Us="Next you have the rest of your standard PyTorch loop:",mt,Ze,wt,Ge,js="Before finally the last major difference.",Jt,ge,ds=`When performing distributed evaluation, the predictions and labels need to be passed through
<a href="/docs/accelerate/v0.30.1/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> so that all of the data is available on the current device and a properly calculated metric can be achieved:`,yt,_e,Tt,We,us='Now you just need to calculate the actual metric for this problem, and you can print it on the main process using <a href="/docs/accelerate/v0.30.1/en/package_reference/accelerator#accelerate.Accelerator.print">print()</a>:',ht,ke,Ut,Be,bs="A full version of this training loop is available below:",jt,ve,dt,Ye,ut,Ae,Is='All that’s left is to use the <a href="/docs/accelerate/v0.30.1/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a>.',bt,Ne,fs='You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the <a href="../package_reference/launchers">documentation</a> for more information)',It,Xe,ft,Re,Ct,Ve,Cs="In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time.",$t,xe,$s="For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of “172.31.43.8”, it would look like so:",Zt,Fe,Gt,Qe,Zs="And in the second Jupyter session on the other machine:",gt,Z,_t,ze,Wt,Ee,Gs="In the case of running on the TPU, it would look like so:",kt,Se,Bt,He,gs="As it’s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:",vt,Le,Yt,De,_s="And that’s it!",At,Pe,Ws='Please note that <a href="/docs/accelerate/v0.30.1/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> ignores the 🤗 Accelerate config file, to launch based on the config use:',Nt,qe,Xt,Ke,Rt,Oe,ks=`A common issue when running the <code>notebook_launcher</code> is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch <code>torch.cuda</code> sublibrary. To help narrow down what went wrong,
you can launch the <code>notebook_launcher</code> with <code>ACCELERATE_DEBUG_MODE=yes</code> in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`,Vt,el,xt,ll,Bs="This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:",Ft,tl,vs='<li>Make sure to save any code that use CUDA (or CUDA imports) for the function passed to <a href="/docs/accelerate/v0.30.1/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a></li> <li>Set the <code>num_processes</code> to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)</li> <li>If using the TPU, declare your model outside the training loop function</li>',Qt,sl,zt,Ml,Et;return G=new nl({props:{title:"Launching Multi-GPU Training from a Jupyter Environment",local:"launching-multi-gpu-training-from-a-jupyter-environment",headingTag:"h1"}}),u=new al({props:{$$slots:{default:[qs]},$$scope:{ctx:d}}}),_=new nl({props:{title:"Configuring the Environment",local:"configuring-the-environment",headingTag:"h2"}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),b=new al({props:{warning:!0,$$slots:{default:[Ks]},$$scope:{ctx:d}}}),Y=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHdyaXRlX2Jhc2ljX2NvbmZpZyUwQSUwQXdyaXRlX2Jhc2ljX2NvbmZpZygpJTIwJTIwJTIzJTIwV3JpdGUlMjBhJTIwY29uZmlnJTIwZmlsZSUwQW9zLl9leGl0KDAwKSUyMCUyMCUyMyUyMFJlc3RhcnQlMjB0aGUlMjBub3RlYm9vaw==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()  <span class="hljs-comment"># Write a config file</span>
os._exit(<span class="hljs-number">00</span>)  <span class="hljs-comment"># Restart the notebook</span>`,wrap:!1}}),A=new nl({props:{title:"Preparing the Dataset and Model",local:"preparing-the-dataset-and-model",headingTag:"h2"}}),V=new h({props:{code:"aW1wb3J0JTIwb3MlMkMlMjByZSUyQyUyMHRvcmNoJTJDJTIwUElMJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyME9uZUN5Y2xlTFIlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMkMlMjBEYXRhc2V0JTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBSZXNpemUlMkMlMjBUb1RlbnNvciUwQSUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBZnJvbSUyMHRpbW0lMjBpbXBvcnQlMjBjcmVhdGVfbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> os, re, torch, PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> OneCycleLR
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader, Dataset
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, RandomResizedCrop, Resize, ToTensor

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> timm <span class="hljs-keyword">import</span> create_model`,wrap:!1}}),F=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEFkYXRhX2RpciUyMCUzRCUyMCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMEFmbmFtZXMlMjAlM0QlMjBvcy5saXN0ZGlyKGRhdGFfZGlyKSUwQWZuYW1lJTIwJTNEJTIwZm5hbWVzJTVCMCU1RCUwQXByaW50KGZuYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> os

data_dir = <span class="hljs-string">&quot;../../images&quot;</span>
fnames = os.listdir(data_dir)
fname = fnames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(fname)`,wrap:!1}}),Q=new h({props:{code:"YmVhZ2xlXzMyLmpwZw==",highlighted:"beagle_32.jpg",wrap:!1}}),E=new h({props:{code:"aW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZW0lMjAlM0QlMjBmbmFtZS5zcGxpdChvcy5wYXRoLnNlcCklNUItMSU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlLnNlYXJjaChyJTIyJTVFKC4qKV8lNUNkJTJCJTVDLmpwZyUyNCUyMiUyQyUyMHN0ZW0pLmdyb3VwcygpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_label</span>(<span class="hljs-params">fname</span>):
    stem = fname.split(os.path.sep)[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">return</span> re.search(<span class="hljs-string">r&quot;^(.*)_\\d+\\.jpg$&quot;</span>, stem).groups()[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new h({props:{code:"ZXh0cmFjdF9sYWJlbChmbmFtZSk=",highlighted:"extract_label(fname)",wrap:!1}}),L=new h({props:{code:"JTIyYmVhZ2xlJTIy",highlighted:'<span class="hljs-string">&quot;beagle&quot;</span>',wrap:!1}}),P=new h({props:{code:"Y2xhc3MlMjBQZXRzRGF0YXNldChEYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBmaWxlX25hbWVzJTJDJTIwaW1hZ2VfdHJhbnNmb3JtJTNETm9uZSUyQyUyMGxhYmVsX3RvX2lkJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZpbGVfbmFtZXMlMjAlM0QlMjBmaWxlX25hbWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0lMjAlM0QlMjBpbWFnZV90cmFuc2Zvcm0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxhYmVsX3RvX2lkJTIwJTNEJTIwbGFiZWxfdG9faWQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGVuKHNlbGYuZmlsZV9uYW1lcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2dldGl0ZW1fXyhzZWxmJTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuYW1lJTIwJTNEJTIwc2VsZi5maWxlX25hbWVzJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X2ltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oZm5hbWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjByYXdfaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmltYWdlX3RyYW5zZm9ybSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0oaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlMjAlM0QlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5sYWJlbF90b19pZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5sYWJlbF90b19pZCU1QmxhYmVsJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwbGFiZWwlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PetsDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, file_names, image_transform=<span class="hljs-literal">None</span>, label_to_id=<span class="hljs-literal">None</span></span>):
        self.file_names = file_names
        self.image_transform = image_transform
        self.label_to_id = label_to_id

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.file_names)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
        fname = self.file_names[idx]
        raw_image = PIL.Image.<span class="hljs-built_in">open</span>(fname)
        image = raw_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        <span class="hljs-keyword">if</span> self.image_transform <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            image = self.image_transform(image)
        label = extract_label(fname)
        <span class="hljs-keyword">if</span> self.label_to_id <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            label = self.label_to_id[label]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;image&quot;</span>: image, <span class="hljs-string">&quot;label&quot;</span>: label}`,wrap:!1}}),K=new h({props:{code:"Zm5hbWVzJTIwJTNEJTIwJTVCb3MucGF0aC5qb2luKCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMkMlMjBmbmFtZSklMjBmb3IlMjBmbmFtZSUyMGluJTIwZm5hbWVzJTIwaWYlMjBmbmFtZS5lbmRzd2l0aCglMjIuanBnJTIyKSU1RA==",highlighted:'fnames = [os.path.join(<span class="hljs-string">&quot;../../images&quot;</span>, fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames <span class="hljs-keyword">if</span> fname.endswith(<span class="hljs-string">&quot;.jpg&quot;</span>)]',wrap:!1}}),ee=new h({props:{code:"YWxsX2xhYmVscyUyMCUzRCUyMCU1QmV4dHJhY3RfbGFiZWwoZm5hbWUpJTIwZm9yJTIwZm5hbWUlMjBpbiUyMGZuYW1lcyU1RCUwQWlkX3RvX2xhYmVsJTIwJTNEJTIwbGlzdChzZXQoYWxsX2xhYmVscykpJTBBaWRfdG9fbGFiZWwuc29ydCgpJTBBbGFiZWxfdG9faWQlMjAlM0QlMjAlN0JsYmwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxibCUyMGluJTIwZW51bWVyYXRlKGlkX3RvX2xhYmVsKSU3RA==",highlighted:`all_labels = [extract_label(fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames]
id_to_label = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_labels))
id_to_label.sort()
label_to_id = {lbl: i <span class="hljs-keyword">for</span> i, lbl <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(id_to_label)}`,wrap:!1}}),te=new h({props:{code:"ZGVmJTIwZ2V0X2RhdGFsb2FkZXJzKGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA2NCklM0ElMEElMjAlMjAlMjAlMjAlMjJCdWlsZHMlMjBhJTIwc2V0JTIwb2YlMjBkYXRhbG9hZGVycyUyMHdpdGglMjBhJTIwYmF0Y2hfc2l6ZSUyMiUwQSUyMCUyMCUyMCUyMHJhbmRvbV9wZXJtJTIwJTNEJTIwbnAucmFuZG9tLnBlcm11dGF0aW9uKGxlbihmbmFtZXMpKSUwQSUyMCUyMCUyMCUyMGN1dCUyMCUzRCUyMGludCgwLjglMjAqJTIwbGVuKGZuYW1lcykpJTBBJTIwJTIwJTIwJTIwdHJhaW5fc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QiUzQWN1dCU1RCUwQSUyMCUyMCUyMCUyMGV2YWxfc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QmN1dCUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTIwYSUyMHNpbXBsZSUyMFJhbmRvbVJlc2l6ZWRDcm9wJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMHRyYWluX3RmbSUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3AoKDIyNCUyQyUyMDIyNCklMkMlMjBzY2FsZSUzRCgwLjUlMkMlMjAxLjApKSUyQyUyMFRvVGVuc29yKCklNUQpJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMFBldHNEYXRhc2V0KCU1QmZuYW1lcyU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjB0cmFpbl9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRHRyYWluX3RmbSUyQyUyMGxhYmVsX3RvX2lkJTNEbGFiZWxfdG9faWQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwZXZhbHVhdGlvbiUyMGElMjBkZXRlcm1pbmlzdGljJTIwUmVzaXplJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMGV2YWxfdGZtJTIwJTNEJTIwQ29tcG9zZSglNUJSZXNpemUoKDIyNCUyQyUyMDIyNCkpJTJDJTIwVG9UZW5zb3IoKSU1RCklMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBQZXRzRGF0YXNldCglNUJmbmFtZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwZXZhbF9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRGV2YWxfdGZtJTJDJTIwbGFiZWxfdG9faWQlM0RsYWJlbF90b19pZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMGRhdGFsb2FkZXJzJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIodHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihldmFsX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNERmFsc2UlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyMColMjAyJTJDJTIwbnVtX3dvcmtlcnMlM0Q0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_dataloaders</span>(<span class="hljs-params">batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;Builds a set of dataloaders with a batch_size&quot;</span>
    random_perm = np.random.permutation(<span class="hljs-built_in">len</span>(fnames))
    cut = <span class="hljs-built_in">int</span>(<span class="hljs-number">0.8</span> * <span class="hljs-built_in">len</span>(fnames))
    train_split = random_perm[:cut]
    eval_split = random_perm[cut:]

    <span class="hljs-comment"># For training a simple RandomResizedCrop will be used</span>
    train_tfm = Compose([RandomResizedCrop((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), scale=(<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>)), ToTensor()])
    train_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> train_split], image_transform=train_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># For evaluation a deterministic Resize will be used</span>
    eval_tfm = Compose([Resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)), ToTensor()])
    eval_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> eval_split], image_transform=eval_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># Instantiate dataloaders</span>
    train_dataloader = DataLoader(train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=batch_size, num_workers=<span class="hljs-number">4</span>)
    eval_dataloader = DataLoader(eval_dataset, shuffle=<span class="hljs-literal">False</span>, batch_size=batch_size * <span class="hljs-number">2</span>, num_workers=<span class="hljs-number">4</span>)
    <span class="hljs-keyword">return</span> train_dataloader, eval_dataloader`,wrap:!1}}),ae=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyMENvc2luZUFubmVhbGluZ0xS",highlighted:'<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> CosineAnnealingLR',wrap:!1}}),ne=new nl({props:{title:"Writing the Training Function",local:"writing-the-training-function",headingTag:"h2"}}),I=new al({props:{$$slots:{default:[Os]},$$scope:{ctx:d}}}),ie=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    accelerator = Accelerator(mixed_precision=mixed_precision)`,wrap:!1}}),f=new al({props:{warning:!0,$$slots:{default:[ea]},$$scope:{ctx:d}}}),ce=new h({props:{code:"JTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhiYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RsZW4obGFiZWxfdG9faWQpKQ==",highlighted:`    train_dataloader, eval_dataloader = get_dataloaders(batch_size)
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))`,wrap:!1}}),C=new al({props:{$$slots:{default:[la]},$$scope:{ctx:d}}}),we=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBtb2RlbC5nZXRfY2xhc3NpZmllcigpLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBUcnVl",highlighted:`    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>`,wrap:!1}}),ye=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMm1lYW4lMjIlNUQpJTVCTm9uZSUyQyUyMCUzQSUyQyUyME5vbmUlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwc3RkJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsLmRlZmF1bHRfY2ZnJTVCJTIyc3RkJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RA==",highlighted:`    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),he=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2Up",highlighted:`    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)`,wrap:!1}}),je=new h({props:{code:"JTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTIlMjAlMkYlMjAyNSklMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKQ==",highlighted:`    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))`,wrap:!1}}),$=new al({props:{$$slots:{default:[ta]},$$scope:{ctx:d}}}),ue=new h({props:{code:"JTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjAp",highlighted:`    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )`,wrap:!1}}),Ie=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwKGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMjAtJTIwbWVhbiklMjAlMkYlMjBzdGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmNyb3NzX2VudHJvcHkob3V0cHV0cyUyQyUyMGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()`,wrap:!1}}),Ce=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMA==",highlighted:`        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>`,wrap:!1}}),Ze=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSk=",highlighted:`        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)`,wrap:!1}}),_e=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCk=",highlighted:`            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()`,wrap:!1}}),ke=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9tZXRyaWMlMjAlM0QlMjBhY2N1cmF0ZS5pdGVtKCklMjAlMkYlMjBudW1fZWxlbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5wcmludChmJTIyZXBvY2glMjAlN0JlcG9jaCU3RCUzQSUyMCU3QjEwMCUyMColMjBldmFsX21ldHJpYyUzQS4yZiU3RCUyMik=",highlighted:`        eval_metric = accurate.item() / num_elems
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),ve=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    <span class="hljs-comment"># Initialize accelerator</span>
    accelerator = Accelerator(mixed_precision=mixed_precision)
    <span class="hljs-comment"># Build dataloaders</span>
    train_dataloader, eval_dataloader = get_dataloaders(batch_size)

    <span class="hljs-comment"># Instantiate the model (you build the model here so that the seed also controls new weight initaliziations)</span>
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

    <span class="hljs-comment"># Freeze the base model</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>

    <span class="hljs-comment"># You can normalize the batches of images to be a bit faster</span>
    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]

    <span class="hljs-comment"># To make these constants available on the active device, set it to the accelerator device</span>
    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)

    <span class="hljs-comment"># Instantiate the optimizer</span>
    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)

    <span class="hljs-comment"># Instantiate the learning rate scheduler</span>
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))

    <span class="hljs-comment"># Prepare everything</span>
    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the</span>
    <span class="hljs-comment"># prepare method.</span>
    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )

    <span class="hljs-comment"># Now you train the model</span>
    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()

        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)
            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()

        eval_metric = accurate.item() / num_elems
        <span class="hljs-comment"># Use accelerator.print to print only on the main process.</span>
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Ye=new nl({props:{title:"Using the notebook_launcher",local:"using-the-notebooklauncher",headingTag:"h2"}}),Xe=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlcg==",highlighted:'<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher',wrap:!1}}),Re=new h({props:{code:"YXJncyUyMCUzRCUyMCglMjJmcDE2JTIyJTJDJTIwNDIlMkMlMjA2NCklMEFub3RlYm9va19sYXVuY2hlcih0cmFpbmluZ19sb29wJTJDJTIwYXJncyUyQyUyMG51bV9wcm9jZXNzZXMlM0QyKQ==",highlighted:`args = (<span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">2</span>)`,wrap:!1}}),Fe=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMCUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">0</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Z=new al({props:{$$slots:{default:[sa]},$$scope:{ctx:d}}}),ze=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMSUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">1</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Se=new h({props:{code:"bW9kZWwlMjAlM0QlMjBjcmVhdGVfbW9kZWwoJTIycmVzbmV0NTBkJTIyJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRGxlbihsYWJlbF90b19pZCkpJTBBJTBBYXJncyUyMCUzRCUyMChtb2RlbCUyQyUyMCUyMmZwMTYlMjIlMkMlMjA0MiUyQyUyMDY0KSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDgp",highlighted:`model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

args = (model, <span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">8</span>)`,wrap:!1}}),Le=new h({props:{code:"TGF1bmNoaW5nJTIwdHJhaW5pbmclMjBvbiUyMDIlMjBHUFVzLiUwQWVwb2NoJTIwMCUzQSUyMDg4LjEyJTBBZXBvY2glMjAxJTNBJTIwOTEuNzMlMEFlcG9jaCUyMDIlM0ElMjA5Mi41OCUwQWVwb2NoJTIwMyUzQSUyMDkzLjkwJTBBZXBvY2glMjA0JTNBJTIwOTQuNzE=",highlighted:`Launching training on <span class="hljs-number">2</span> GPUs.
epoch <span class="hljs-number">0</span>: <span class="hljs-number">88.12</span>
epoch <span class="hljs-number">1</span>: <span class="hljs-number">91.73</span>
epoch <span class="hljs-number">2</span>: <span class="hljs-number">92.58</span>
epoch <span class="hljs-number">3</span>: <span class="hljs-number">93.90</span>
epoch <span class="hljs-number">4</span>: <span class="hljs-number">94.71</span>`,wrap:!1}}),qe=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaA==",highlighted:"accelerate launch",wrap:!1}}),Ke=new nl({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),el=new nl({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),sl=new Ps({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/notebook.md"}}),{c(){p=M("meta"),U=a(),T=M("p"),j=a(),o(G.$$.fragment),il=a(),g=M("p"),g.textContent=St,rl=a(),o(u.$$.fragment),ol=a(),o(_.$$.fragment),cl=a(),W=M("p"),W.textContent=Ht,ml=a(),o(k.$$.fragment),wl=a(),B=M("p"),B.innerHTML=Lt,Jl=a(),v=M("p"),v.textContent=Dt,yl=a(),o(b.$$.fragment),Tl=a(),o(Y.$$.fragment),hl=a(),o(A.$$.fragment),Ul=a(),N=M("p"),N.innerHTML=Pt,jl=a(),X=M("p"),X.textContent=qt,dl=a(),R=M("p"),R.innerHTML=Kt,ul=a(),o(V.$$.fragment),bl=a(),x=M("p"),x.textContent=Ot,Il=a(),o(F.$$.fragment),fl=a(),o(Q.$$.fragment),Cl=a(),z=M("p"),z.innerHTML=es,$l=a(),o(E.$$.fragment),Zl=a(),o(S.$$.fragment),Gl=a(),H=M("p"),H.textContent=ls,gl=a(),o(L.$$.fragment),_l=a(),D=M("p"),D.innerHTML=ts,Wl=a(),o(P.$$.fragment),kl=a(),q=M("p"),q.textContent=ss,Bl=a(),o(K.$$.fragment),vl=a(),O=M("p"),O.textContent=as,Yl=a(),o(ee.$$.fragment),Al=a(),le=M("p"),le.innerHTML=ns,Nl=a(),o(te.$$.fragment),Xl=a(),se=M("p"),se.textContent=ps,Rl=a(),o(ae.$$.fragment),Vl=a(),o(ne.$$.fragment),xl=a(),pe=M("p"),pe.innerHTML=Ms,Fl=a(),Me=M("p"),Me.textContent=is,Ql=a(),o(I.$$.fragment),zl=a(),o(ie.$$.fragment),El=a(),re=M("p"),re.innerHTML=rs,Sl=a(),o(f.$$.fragment),Hl=a(),oe=M("p"),oe.textContent=os,Ll=a(),o(ce.$$.fragment),Dl=a(),o(C.$$.fragment),Pl=a(),me=M("p"),me.textContent=cs,ql=a(),o(we.$$.fragment),Kl=a(),Je=M("p"),Je.textContent=ms,Ol=a(),o(ye.$$.fragment),et=a(),Te=M("p"),Te.textContent=ws,lt=a(),o(he.$$.fragment),tt=a(),Ue=M("p"),Ue.textContent=Js,st=a(),o(je.$$.fragment),at=a(),de=M("p"),de.innerHTML=ys,nt=a(),o($.$$.fragment),pt=a(),o(ue.$$.fragment),Mt=a(),be=M("p"),be.textContent=Ts,it=a(),o(Ie.$$.fragment),rt=a(),fe=M("p"),fe.textContent=hs,ot=a(),o(Ce.$$.fragment),ct=a(),$e=M("p"),$e.textContent=Us,mt=a(),o(Ze.$$.fragment),wt=a(),Ge=M("p"),Ge.textContent=js,Jt=a(),ge=M("p"),ge.innerHTML=ds,yt=a(),o(_e.$$.fragment),Tt=a(),We=M("p"),We.innerHTML=us,ht=a(),o(ke.$$.fragment),Ut=a(),Be=M("p"),Be.textContent=bs,jt=a(),o(ve.$$.fragment),dt=a(),o(Ye.$$.fragment),ut=a(),Ae=M("p"),Ae.innerHTML=Is,bt=a(),Ne=M("p"),Ne.innerHTML=fs,It=a(),o(Xe.$$.fragment),ft=a(),o(Re.$$.fragment),Ct=a(),Ve=M("p"),Ve.textContent=Cs,$t=a(),xe=M("p"),xe.textContent=$s,Zt=a(),o(Fe.$$.fragment),Gt=a(),Qe=M("p"),Qe.textContent=Zs,gt=a(),o(Z.$$.fragment),_t=a(),o(ze.$$.fragment),Wt=a(),Ee=M("p"),Ee.textContent=Gs,kt=a(),o(Se.$$.fragment),Bt=a(),He=M("p"),He.textContent=gs,vt=a(),o(Le.$$.fragment),Yt=a(),De=M("p"),De.textContent=_s,At=a(),Pe=M("p"),Pe.innerHTML=Ws,Nt=a(),o(qe.$$.fragment),Xt=a(),o(Ke.$$.fragment),Rt=a(),Oe=M("p"),Oe.innerHTML=ks,Vt=a(),o(el.$$.fragment),xt=a(),ll=M("p"),ll.textContent=Bs,Ft=a(),tl=M("ul"),tl.innerHTML=vs,Qt=a(),o(sl.$$.fragment),zt=a(),Ml=M("p"),this.h()},l(e){const l=Ls("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=n(e),T=i(e,"P",{}),Fs(T).forEach(t),j=n(e),c(G.$$.fragment,e),il=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-6spvy7"&&(g.textContent=St),rl=n(e),c(u.$$.fragment,e),ol=n(e),c(_.$$.fragment,e),cl=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1xlepvp"&&(W.textContent=Ht),ml=n(e),c(k.$$.fragment,e),wl=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ml2jih"&&(B.innerHTML=Lt),Jl=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3qwb6i"&&(v.textContent=Dt),yl=n(e),c(b.$$.fragment,e),Tl=n(e),c(Y.$$.fragment,e),hl=n(e),c(A.$$.fragment,e),Ul=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-maqpj6"&&(N.innerHTML=Pt),jl=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gkh70d"&&(X.textContent=qt),dl=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-myu7hv"&&(R.innerHTML=Kt),ul=n(e),c(V.$$.fragment,e),bl=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-h07c4l"&&(x.textContent=Ot),Il=n(e),c(F.$$.fragment,e),fl=n(e),c(Q.$$.fragment,e),Cl=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-60ulbw"&&(z.innerHTML=es),$l=n(e),c(E.$$.fragment,e),Zl=n(e),c(S.$$.fragment,e),Gl=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1kzkru5"&&(H.textContent=ls),gl=n(e),c(L.$$.fragment,e),_l=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-eeriqt"&&(D.innerHTML=ts),Wl=n(e),c(P.$$.fragment,e),kl=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1erq0yi"&&(q.textContent=ss),Bl=n(e),c(K.$$.fragment,e),vl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-17fsfbj"&&(O.textContent=as),Yl=n(e),c(ee.$$.fragment,e),Al=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1wyd1v3"&&(le.innerHTML=ns),Nl=n(e),c(te.$$.fragment,e),Xl=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-s9102n"&&(se.textContent=ps),Rl=n(e),c(ae.$$.fragment,e),Vl=n(e),c(ne.$$.fragment,e),xl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1yzothe"&&(pe.innerHTML=Ms),Fl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-oa85ci"&&(Me.textContent=is),Ql=n(e),c(I.$$.fragment,e),zl=n(e),c(ie.$$.fragment,e),El=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1qaiau2"&&(re.innerHTML=rs),Sl=n(e),c(f.$$.fragment,e),Hl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ojop43"&&(oe.textContent=os),Ll=n(e),c(ce.$$.fragment,e),Dl=n(e),c(C.$$.fragment,e),Pl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2qfnag"&&(me.textContent=cs),ql=n(e),c(we.$$.fragment,e),Kl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-16kq69y"&&(Je.textContent=ms),Ol=n(e),c(ye.$$.fragment,e),et=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1x7hf7y"&&(Te.textContent=ws),lt=n(e),c(he.$$.fragment,e),tt=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1drdkyl"&&(Ue.textContent=Js),st=n(e),c(je.$$.fragment,e),at=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-3czs4d"&&(de.innerHTML=ys),nt=n(e),c($.$$.fragment,e),pt=n(e),c(ue.$$.fragment,e),Mt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-8iqamy"&&(be.textContent=Ts),it=n(e),c(Ie.$$.fragment,e),rt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-uq3liu"&&(fe.textContent=hs),ot=n(e),c(Ce.$$.fragment,e),ct=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1vssgg7"&&($e.textContent=Us),mt=n(e),c(Ze.$$.fragment,e),wt=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-o67l3v"&&(Ge.textContent=js),Jt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-c0hm7g"&&(ge.innerHTML=ds),yt=n(e),c(_e.$$.fragment,e),Tt=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-15e8kuk"&&(We.innerHTML=us),ht=n(e),c(ke.$$.fragment,e),Ut=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1kobhd"&&(Be.textContent=bs),jt=n(e),c(ve.$$.fragment,e),dt=n(e),c(Ye.$$.fragment,e),ut=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-14anqxq"&&(Ae.innerHTML=Is),bt=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-7o5jv1"&&(Ne.innerHTML=fs),It=n(e),c(Xe.$$.fragment,e),ft=n(e),c(Re.$$.fragment,e),Ct=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-rkokvk"&&(Ve.textContent=Cs),$t=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-192rw96"&&(xe.textContent=$s),Zt=n(e),c(Fe.$$.fragment,e),Gt=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-3ig3ul"&&(Qe.textContent=Zs),gt=n(e),c(Z.$$.fragment,e),_t=n(e),c(ze.$$.fragment,e),Wt=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-10flsnd"&&(Ee.textContent=Gs),kt=n(e),c(Se.$$.fragment,e),Bt=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-svq1hp"&&(He.textContent=gs),vt=n(e),c(Le.$$.fragment,e),Yt=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-9wooxy"&&(De.textContent=_s),At=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1vwfo1z"&&(Pe.innerHTML=Ws),Nt=n(e),c(qe.$$.fragment,e),Xt=n(e),c(Ke.$$.fragment,e),Rt=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1p7dsaj"&&(Oe.innerHTML=ks),Vt=n(e),c(el.$$.fragment,e),xt=n(e),ll=i(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-ixf1ne"&&(ll.textContent=Bs),Ft=n(e),tl=i(e,"UL",{"data-svelte-h":!0}),r(tl)!=="svelte-k4zavl"&&(tl.innerHTML=vs),Qt=n(e),c(sl.$$.fragment,e),zt=n(e),Ml=i(e,"P",{}),Fs(Ml).forEach(t),this.h()},h(){Qs(p,"name","hf:doc:metadata"),Qs(p,"content",na)},m(e,l){Ds(document.head,p),s(e,U,l),s(e,T,l),s(e,j,l),m(G,e,l),s(e,il,l),s(e,g,l),s(e,rl,l),m(u,e,l),s(e,ol,l),m(_,e,l),s(e,cl,l),s(e,W,l),s(e,ml,l),m(k,e,l),s(e,wl,l),s(e,B,l),s(e,Jl,l),s(e,v,l),s(e,yl,l),m(b,e,l),s(e,Tl,l),m(Y,e,l),s(e,hl,l),m(A,e,l),s(e,Ul,l),s(e,N,l),s(e,jl,l),s(e,X,l),s(e,dl,l),s(e,R,l),s(e,ul,l),m(V,e,l),s(e,bl,l),s(e,x,l),s(e,Il,l),m(F,e,l),s(e,fl,l),m(Q,e,l),s(e,Cl,l),s(e,z,l),s(e,$l,l),m(E,e,l),s(e,Zl,l),m(S,e,l),s(e,Gl,l),s(e,H,l),s(e,gl,l),m(L,e,l),s(e,_l,l),s(e,D,l),s(e,Wl,l),m(P,e,l),s(e,kl,l),s(e,q,l),s(e,Bl,l),m(K,e,l),s(e,vl,l),s(e,O,l),s(e,Yl,l),m(ee,e,l),s(e,Al,l),s(e,le,l),s(e,Nl,l),m(te,e,l),s(e,Xl,l),s(e,se,l),s(e,Rl,l),m(ae,e,l),s(e,Vl,l),m(ne,e,l),s(e,xl,l),s(e,pe,l),s(e,Fl,l),s(e,Me,l),s(e,Ql,l),m(I,e,l),s(e,zl,l),m(ie,e,l),s(e,El,l),s(e,re,l),s(e,Sl,l),m(f,e,l),s(e,Hl,l),s(e,oe,l),s(e,Ll,l),m(ce,e,l),s(e,Dl,l),m(C,e,l),s(e,Pl,l),s(e,me,l),s(e,ql,l),m(we,e,l),s(e,Kl,l),s(e,Je,l),s(e,Ol,l),m(ye,e,l),s(e,et,l),s(e,Te,l),s(e,lt,l),m(he,e,l),s(e,tt,l),s(e,Ue,l),s(e,st,l),m(je,e,l),s(e,at,l),s(e,de,l),s(e,nt,l),m($,e,l),s(e,pt,l),m(ue,e,l),s(e,Mt,l),s(e,be,l),s(e,it,l),m(Ie,e,l),s(e,rt,l),s(e,fe,l),s(e,ot,l),m(Ce,e,l),s(e,ct,l),s(e,$e,l),s(e,mt,l),m(Ze,e,l),s(e,wt,l),s(e,Ge,l),s(e,Jt,l),s(e,ge,l),s(e,yt,l),m(_e,e,l),s(e,Tt,l),s(e,We,l),s(e,ht,l),m(ke,e,l),s(e,Ut,l),s(e,Be,l),s(e,jt,l),m(ve,e,l),s(e,dt,l),m(Ye,e,l),s(e,ut,l),s(e,Ae,l),s(e,bt,l),s(e,Ne,l),s(e,It,l),m(Xe,e,l),s(e,ft,l),m(Re,e,l),s(e,Ct,l),s(e,Ve,l),s(e,$t,l),s(e,xe,l),s(e,Zt,l),m(Fe,e,l),s(e,Gt,l),s(e,Qe,l),s(e,gt,l),m(Z,e,l),s(e,_t,l),m(ze,e,l),s(e,Wt,l),s(e,Ee,l),s(e,kt,l),m(Se,e,l),s(e,Bt,l),s(e,He,l),s(e,vt,l),m(Le,e,l),s(e,Yt,l),s(e,De,l),s(e,At,l),s(e,Pe,l),s(e,Nt,l),m(qe,e,l),s(e,Xt,l),m(Ke,e,l),s(e,Rt,l),s(e,Oe,l),s(e,Vt,l),m(el,e,l),s(e,xt,l),s(e,ll,l),s(e,Ft,l),s(e,tl,l),s(e,Qt,l),m(sl,e,l),s(e,zt,l),s(e,Ml,l),Et=!0},p(e,[l]){const Ys={};l&2&&(Ys.$$scope={dirty:l,ctx:e}),u.$set(Ys);const As={};l&2&&(As.$$scope={dirty:l,ctx:e}),b.$set(As);const Ns={};l&2&&(Ns.$$scope={dirty:l,ctx:e}),I.$set(Ns);const Xs={};l&2&&(Xs.$$scope={dirty:l,ctx:e}),f.$set(Xs);const Rs={};l&2&&(Rs.$$scope={dirty:l,ctx:e}),C.$set(Rs);const Vs={};l&2&&(Vs.$$scope={dirty:l,ctx:e}),$.$set(Vs);const xs={};l&2&&(xs.$$scope={dirty:l,ctx:e}),Z.$set(xs)},i(e){Et||(w(G.$$.fragment,e),w(u.$$.fragment,e),w(_.$$.fragment,e),w(k.$$.fragment,e),w(b.$$.fragment,e),w(Y.$$.fragment,e),w(A.$$.fragment,e),w(V.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(L.$$.fragment,e),w(P.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(ne.$$.fragment,e),w(I.$$.fragment,e),w(ie.$$.fragment,e),w(f.$$.fragment,e),w(ce.$$.fragment,e),w(C.$$.fragment,e),w(we.$$.fragment,e),w(ye.$$.fragment,e),w(he.$$.fragment,e),w(je.$$.fragment,e),w($.$$.fragment,e),w(ue.$$.fragment,e),w(Ie.$$.fragment,e),w(Ce.$$.fragment,e),w(Ze.$$.fragment,e),w(_e.$$.fragment,e),w(ke.$$.fragment,e),w(ve.$$.fragment,e),w(Ye.$$.fragment,e),w(Xe.$$.fragment,e),w(Re.$$.fragment,e),w(Fe.$$.fragment,e),w(Z.$$.fragment,e),w(ze.$$.fragment,e),w(Se.$$.fragment,e),w(Le.$$.fragment,e),w(qe.$$.fragment,e),w(Ke.$$.fragment,e),w(el.$$.fragment,e),w(sl.$$.fragment,e),Et=!0)},o(e){J(G.$$.fragment,e),J(u.$$.fragment,e),J(_.$$.fragment,e),J(k.$$.fragment,e),J(b.$$.fragment,e),J(Y.$$.fragment,e),J(A.$$.fragment,e),J(V.$$.fragment,e),J(F.$$.fragment,e),J(Q.$$.fragment,e),J(E.$$.fragment,e),J(S.$$.fragment,e),J(L.$$.fragment,e),J(P.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(te.$$.fragment,e),J(ae.$$.fragment,e),J(ne.$$.fragment,e),J(I.$$.fragment,e),J(ie.$$.fragment,e),J(f.$$.fragment,e),J(ce.$$.fragment,e),J(C.$$.fragment,e),J(we.$$.fragment,e),J(ye.$$.fragment,e),J(he.$$.fragment,e),J(je.$$.fragment,e),J($.$$.fragment,e),J(ue.$$.fragment,e),J(Ie.$$.fragment,e),J(Ce.$$.fragment,e),J(Ze.$$.fragment,e),J(_e.$$.fragment,e),J(ke.$$.fragment,e),J(ve.$$.fragment,e),J(Ye.$$.fragment,e),J(Xe.$$.fragment,e),J(Re.$$.fragment,e),J(Fe.$$.fragment,e),J(Z.$$.fragment,e),J(ze.$$.fragment,e),J(Se.$$.fragment,e),J(Le.$$.fragment,e),J(qe.$$.fragment,e),J(Ke.$$.fragment,e),J(el.$$.fragment,e),J(sl.$$.fragment,e),Et=!1},d(e){e&&(t(U),t(T),t(j),t(il),t(g),t(rl),t(ol),t(cl),t(W),t(ml),t(wl),t(B),t(Jl),t(v),t(yl),t(Tl),t(hl),t(Ul),t(N),t(jl),t(X),t(dl),t(R),t(ul),t(bl),t(x),t(Il),t(fl),t(Cl),t(z),t($l),t(Zl),t(Gl),t(H),t(gl),t(_l),t(D),t(Wl),t(kl),t(q),t(Bl),t(vl),t(O),t(Yl),t(Al),t(le),t(Nl),t(Xl),t(se),t(Rl),t(Vl),t(xl),t(pe),t(Fl),t(Me),t(Ql),t(zl),t(El),t(re),t(Sl),t(Hl),t(oe),t(Ll),t(Dl),t(Pl),t(me),t(ql),t(Kl),t(Je),t(Ol),t(et),t(Te),t(lt),t(tt),t(Ue),t(st),t(at),t(de),t(nt),t(pt),t(Mt),t(be),t(it),t(rt),t(fe),t(ot),t(ct),t($e),t(mt),t(wt),t(Ge),t(Jt),t(ge),t(yt),t(Tt),t(We),t(ht),t(Ut),t(Be),t(jt),t(dt),t(ut),t(Ae),t(bt),t(Ne),t(It),t(ft),t(Ct),t(Ve),t($t),t(xe),t(Zt),t(Gt),t(Qe),t(gt),t(_t),t(Wt),t(Ee),t(kt),t(Bt),t(He),t(vt),t(Yt),t(De),t(At),t(Pe),t(Nt),t(Xt),t(Rt),t(Oe),t(Vt),t(xt),t(ll),t(Ft),t(tl),t(Qt),t(zt),t(Ml)),t(p),y(G,e),y(u,e),y(_,e),y(k,e),y(b,e),y(Y,e),y(A,e),y(V,e),y(F,e),y(Q,e),y(E,e),y(S,e),y(L,e),y(P,e),y(K,e),y(ee,e),y(te,e),y(ae,e),y(ne,e),y(I,e),y(ie,e),y(f,e),y(ce,e),y(C,e),y(we,e),y(ye,e),y(he,e),y(je,e),y($,e),y(ue,e),y(Ie,e),y(Ce,e),y(Ze,e),y(_e,e),y(ke,e),y(ve,e),y(Ye,e),y(Xe,e),y(Re,e),y(Fe,e),y(Z,e),y(ze,e),y(Se,e),y(Le,e),y(qe,e),y(Ke,e),y(el,e),y(sl,e)}}}const na='{"title":"Launching Multi-GPU Training from a Jupyter Environment","local":"launching-multi-gpu-training-from-a-jupyter-environment","sections":[{"title":"Configuring the Environment","local":"configuring-the-environment","sections":[],"depth":2},{"title":"Preparing the Dataset and Model","local":"preparing-the-dataset-and-model","sections":[],"depth":2},{"title":"Writing the Training Function","local":"writing-the-training-function","sections":[],"depth":2},{"title":"Using the notebook_launcher","local":"using-the-notebooklauncher","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function pa(d){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Ss{constructor(p){super(),Hs(this,p,pa,aa,zs,{})}}export{ma as component};
